; pdraw/asm - kjw/bqsd - revised 04/15/83
;
	TITLE	'<PDRAW/ASM - PowerDRAW>'
;
	SUBTTL	'<by Kim Watt - Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;
;	key equates
;
_ETBL	EQU	00H		;end of table
_ETX	EQU	03H		;end of text
_CLEAR	EQU	04H		;clear key
_TAB	EQU	09H		;tab boundary
_LF	EQU	0AH		;linefeed
_CR	EQU	0DH		;carriage return
_SUARR	EQU	18H		;shift up arrow
_SDARR	EQU	19H		;shift down arrow
_SLARR	EQU	1AH		;shift left arrow
_SRARR	EQU	1BH		;shift right arrow
_EOF1	EQU	1CH		;end of file
_HOME	EQU	1CH		;home cursor
_EOF2	EQU	1DH		;end of file
_BOL	EQU	1DH		;cursor begining line
_EOL	EQU	1EH		;clear end of line
_EOF	EQU	1FH		;clear end of frame
_SPACE	EQU	20H		;space
_UARR	EQU	5BH		;up arrow
_DARR	EQU	5CH		;down arrow
_LARR	EQU	5DH		;left arrow
_RARR	EQU	5EH		;right arrow
_ACTBUF	EQU	63H		;active buffer flag
_SSPACE	EQU	7FH		;shift spacebar
_CTL	EQU	80H		;control char
;
;	system address/size equates
;
$VIDEO	EQU	3C00H		;start video memory
$TROWS	EQU	16		;text rows
$TCOLS	EQU	64		;text columns
$GROWS	EQU	128		;graphic rows
$GCOLS	EQU	48		;graphic columns
$VIDLEN	EQU	$TROWS*$TCOLS	;video length
$CODE	EQU	5200H		;origin load code
$KBDR0	EQU	3801H		;keyboard matrix
$KBDR1	EQU	3802H
$KBDR2	EQU	3804H
$KBDR3	EQU	3808H
$KBDR4	EQU	3810H
$KBDR5	EQU	3820H
$KBDR6	EQU	3840H
$KBDR7	EQU	3880H
$ROMID	EQU	0125H		;rom ID address
$MOD3	EQU	'I'		;mod III identifier
$HIMEM3	EQU	4411H		;topmem Mod III
$HIMEM1	EQU	4049H		;topmem Mod I
$CURSOR	EQU	4020H		;cursor address
$VSEL1	EQU	0FFH		;video size port I
$VSEL3	EQU	0ECH		;video size port III
$VSELM	EQU	37DCH		;video select max
$DELAY1	EQU	400H		;first key repeat delay
$DELAY2	EQU	2		;between key delay
$DELAY3	EQU	500H		;keybounce delay
$DELAY4	EQU	0A00H		;extra debounce for text
$DELAY5	EQU	1800H		;debounce delay joystick
$PRTSTA	EQU	37E8H		;printer status address
$PRTR1	EQU	37E8H		;printer output I
$PRTR3	EQU	0F8H		;printer output III
$DEFBAU	EQU	4211H		;default baud Mod III
BFTSIZE	EQU	230		;buffer table size
;
;	system call equivalences
;
@DELAY	EQU	0060H		;decrement BC till 0
@KBCHAR	EQU	002BH		;scan keyboard
@VDCHAR	EQU	0033H		;display char to video
@ERROR	EQU	4409H		;display error message
@CLOSE	EQU	4428H		;close file
@TAPON	EQU	0212H		;turn on tape
@TAPOFF	EQU	01F8H		;turn off tape deck
@KBLINE	EQU	0040H		;string from keyboard
@DEFCAS	EQU	0212H		;define cassette
@OPEN	EQU	4424H		;open file
@INIT	EQU	4420H		;open/create file
@READ	EQU	4436H		;read file record
@TLEAD	EQU	0296H		;read tape leader
@TREAD	EQU	0235H		;read tape byte
@WRITE	EQU	4439H		;write file record
@TWLEAD	EQU	0287H		;write tape leader
@TWRITE	EQU	0264H		;write tape byte
@BASIC2	EQU	1A19H		;entry to level 2 basic
@DOS	EQU	402DH		;entry to dos
@PRCHAR	EQU	003BH		;char to printer
;
	ORG	$VIDEO
*GET	PDRAW0			;opening graphics
;
	ORG	$CODE
*GET	PDRAW1			;code module 1
*GET	PDRAW2			;code module 2
*GET	PDRAW3			;code module 3
*GET	PDRAW4			;code module 4
*GET	PDRAW5			;code module 5
*GET	PDRAW6			;code module 6
*GET	PDRAW7			;text/buffers
;
_______	EQU	$
;
DCB	DEFS	64		;file block
STRING	DEFS	256		;keyboard buffer
BFTABLE	DEFS	BFTSIZE		;buffer size
DBUFF	EQU	$&0FF00H	;last even page
FBUFF	EQU	DBUFF+100H	;next even page
IOBUFF	EQU	FBUFF		;I/O buffer
VBUFF	EQU	IOBUFF+100H	;start video buffer
SBUFF	EQU	VBUFF+400H	;start storage buffer
;
	END	ENTRY
