MERGE  ;merge
 	ORG	5200H
 ENTRY	PUSH	HL		;save input pointer
 	LD	HL,MESG		;title message
 	CALL	PRINT		;display it
 	XOR	A		;zero screen counter
 	LD	(COUNTER),A
 	POP	HL		;get pointer back
 	CALL	POSHL		;anything?
 	JR	NC,RESUME	;continue
 	LD	HL,FMESG	;ask for files
 	CALL	PRINT		;display it
 	LD	B,63		;63 char input
 	CALL	GETSTR		;ask for input
 RESUME	CALL	POSHL		;anything?
 	JP	C,ABORT		;cancel and quit
 	CP	'>'		;dest filespec?
 	JP	NZ,ABORT	;invalid
 	INC	HL		;next position
 	CALL	POSHL		;go to character
 	JP	C,ABORT		;nothing else
 	LD	DE,DDCB		;dest DCB
 	CALL	MOVEFILE	;move filename there
 	LD	(PTR),HL	;save current pointer
 	CALL	ADDEXT		;add default extension
 	LD	B,0		;LRL=0
 	LD	HL,DIOBUFF	;dest I/O buffer
 	LD	DE,DDCB		;dest DCB
 	CALL	4420H		;open the file
 	JP	NZ,ERROR
 	LD	HL,DIOBUFF	;dest I/O buffer
 	LD	DE,DIOBUFF+1	;zero it out
 	LD	BC,0FFH
 	LD	(HL),0
 	LDIR
 	LD	HL,QUICK	;identifier string
 	LD	DE,DIOBUFF	;where it goes
 	LD	BC,21
 	LDIR
 	LD	DE,DDCB		;dest DCB
 	CALL	4439H		;write the sector
 	JP	NZ,ERROR
 LOOP	LD	HL,0		;get pointer
 PTR	EQU	$-2
 	CALL	POSHL		;check for input
 	JP	C,QUIT		;nothing more
 	LD	DE,SDCB		;source DCB
 	CALL	MOVEFILE	;move file to DCB
 	LD	(PTR),HL	;save new pointer
 	CALL	ADDEXT		;add extension
 	LD	HL,SIOBUFF	;source I/O buffer
 	LD	B,0		;LRL = 256
 	CALL	4424H		;open the file
 	JP	NZ,ERROR	;I/O error
 	CALL	4436H		;read first sector
 	JP	NZ,ERROR	;cancel
 	LD	HL,SIOBUFF
 	LD	DE,QUICK	;file header
 	LD	B,21		;check for valid file
 	CALL	COMPARE		;same ?
 	JP	NZ,INVALID	;invalid file
 	LD	BC,0E600H	;get counter
 CKLP	LD	A,(HL)		;get a byte
 	CP	99		;active?
 	JR	NZ,NXCK		;don't count this one
 	INC	C		;bump counter
 NXCK	INC	HL		;bump pointer
 	DJNZ	CKLP		;check 'em all
 	LD	A,C		;get counter
 	LD	(COUNT),A	;save # buffers
 LOADLP	CALL	LOAD		;load a buffer
 	CALL	PUTBUFF		;put on screen
 	LD	A,0		;fetch # buffers
 COUNTER	EQU	$-1
 	INC	A		;bump counter
 	LD	(COUNTER),A	;put it back
 	CALL	ASCII		;convert to ASCII
 	LD	(3C00H),A	;put on video
 	LD	(3C01H),BC
 	CALL	SAVE		;write to dest
 	LD	A,0		;get counter
 COUNT	EQU	$-1
 	DEC	A		;# screen remaining
 	LD	(COUNT),A	;save new count
 	JP	NZ,LOADLP	;do next screen
 	JP	LOOP		;do next file
 INVALID	LD	HL,VALMSG	;invalid file
 	CALL	PRINT		;display it
 	LD	HL,CANCELMSG	;quit message
 	JP	CLOSE-3		;print and close file
 CANCEL	LD	HL,CANCELMSG
 	CALL	PRINT
 	JP	402DH		;back to DOS
 ABORT	LD	HL,ABORTMSG	;abort message
 	CALL	PRINT
 	LD	HL,CANCELMSG+2
 	JR	CANCEL+3
 QUIT	LD	DE,DDCB		;dest DCB
 	LD	BC,0		;first record
 	CALL	4442H		;position to first rec
 	JP	NZ,ERROR
 	LD	HL,DIOBUFF	;zero the buffer
 	LD	DE,DIOBUFF+1
 	LD	(HL),0
 	LD	BC,0FFH
 	LDIR
 	LD	HL,QUICK	;insert identifier
 	LD	DE,DIOBUFF
 	LD	BC,21
 	LDIR
 	EX	DE,HL		;HL => buffer
 	LD	A,(COUNTER)	;# files
 	LD	C,A		;save here
 	LD	B,230		;230 allowed
 PUTCNT	LD	(HL),99		;set as active
 	INC	HL		;bump pointer
 	DEC	C		;reduce counter
 	JR	Z,PUTDN		;all indicated
 	DJNZ	PUTCNT		;go for the rest
 	JR	PUTFIN		;finished
 PUTDN	LD	(HL),0		;set last as non-active
 	INC	HL
 	DJNZ	PUTDN
 PUTFIN	LD	DE,DDCB		;dest DCB
 	CALL	4439H		;write the sector
 	JP	NZ,ERROR
 	LD	HL,QUICK-2	;terminate message
 	CALL	PRINT		;display it
 	LD	A,(COUNTER)	;# buffers saved
 	CALL	ASCII		;decimal ASCII
 	LD	(ASCNT),A	;put in string
 	LD	(ASCNT+1),BC
 	LD	HL,NUMESG	;point to string
 	CALL	PRINT		;display it
 CLOSE	LD	DE,DDCB		;dest DCB
 	LD	A,(DE)		;see if OPEN now
 	BIT	7,A		;7 set if open
 	JP	Z,402DH		;exit DOS if not
 	CALL	4428H		;close the file
 	JP	Z,402DH		;successful
 	OR	0C0H		;set error code
 	CALL	4409H		;display error
 	JP	402DH		;now exit DOS
 ASCII	PUSH	HL		;save HL
 	CALL	ASCI		;covert
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET			;ACB = decimal ascii
 ASCI	LD	C,'0'
 ASCII1	SUB	10
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 PUTBUFF	LD	HL,BUFFER	;where it is
 	LD	DE,3C00H	;where it goes
 	LD	BC,1024		;1K of data
 	LDIR			;move it to video
 	RET			;done
 PRINT	PUSH	HL		;save the string
 PRTLP	LD	A,(HL)		;get a byte
 	INC	HL		;bump it
 	CP	3		;terminator?
 	JR	Z,PRTDN		;done
 	CALL	VOUT		;out to video
 	CP	13		;terminator?
 	JR	NZ,PRTLP
 PRTDN	POP	HL
 	RET
 VOUT	CP	20H		;control code?
 	JP	C,33H		;let ROM do this
 	PUSH	HL		;else save pointer
 	LD	HL,(4020H)	;get cursor
 	LD	(HL),A		;put on screen
 	CP	(HL)		;still there?
 	JR	Z,VIDOK		;lower case in
 	SUB	20H		;else make it upper
 	LD	(HL),A		;put it back
 VIDOK	INC	HL
 	LD	(4020H),HL	;update cursor
 	POP	HL		;restore pointer
 	RET			;done
 SAVE	LD	B,4		;4 sectors/buffer
 	LD	HL,BUFFER	;where it is
 SAVEIT	PUSH	BC		;save counter
 	LD	DE,DIOBUFF	;dest I/O buffer
 	LD	BC,100H		;1 sector data
 	LDIR			;move it there
 	PUSH	HL		;save pointer
 	LD	DE,DDCB		;dest DCB
 	CALL	4439H		;write sector
 	JP	NZ,ERROR
 	POP	HL		;restore pointer
 	POP	BC		;restore counter
 	DJNZ	SAVEIT		;do all 4 sectors
 	RET			;done
 LOAD	LD	B,4		;4 sectors / file
 	LD	DE,BUFFER	;where data goes
 LOADIT	PUSH	BC		;save pointers
 	PUSH	DE
 	LD	DE,SDCB		;point to file DCB
 	CALL	4436H		;read a sector
 	JP	NZ,ERROR	;abort
 	POP	DE		;get pointer back
 	LD	HL,SIOBUFF	;where data is
 	LD	BC,100H		;1 sector worth
 	LDIR			;move it there
 	POP	BC		;get counter back
 	DJNZ	LOADIT		;do all 4 sectors
 	RET			;done
 COMPARE	LD	A,(DE)		;compare buffers
 	CP	(HL)
 	INC	DE
 	INC	HL
 	RET	NZ
 	DJNZ	COMPARE
 	RET
 ERROR	PUSH	AF		;save error code
 	LD	HL,ERRMSG	;error message
 	CALL	PRINT
 	POP	AF
 	OR	0C0H		;setup for return
 	CALL	4409H		;display error
 	JP	CLOSE		;close the file
 GETSTR	LD	HL,STRING	;point to string
 WAITKEY	LD	A,(387FH)	;check for ANY keys
 	OR	A		;set Z flag
 	JR	NZ,WAITKEY	;wait till NONE
 	CALL	40H		;get keyboard input
 	JP	C,CANCEL	;BREAK pressed
 	LD	A,B		;get length of input
 	OR	A		;set flags
 	LD	A,(HL)		;get first character
 	RET
 UCASE	CP	60H		;upper case now?
 	RET	C
 	CP	80H		;graphics now?
 	RET	NC
 	AND	5FH		;make upper case
 	RET
 VALUE	LD	C,0		;start value
 VALLP	LD	A,(HL)		;get a number
 	CALL	CKVAL		;good
 	RET	Z
 	RET	C
 	LD	C,A		;ok
 	INC	HL
 	LD	A,(HL)		;ok?
 	CP	13		;terminator?
 	RET	Z		;done
 	CALL	CKVAL		;good?
 	RET	Z
 	RET	C		;nope
 	LD	B,A		;save here
 	LD	A,C		;get first
 	ADD	A,A		;*2
 	ADD	A,A		;*4
 	ADD	A,C		;*5
 	ADD	A,A		;*10
 	ADD	A,B		;add second number
 	LD	C,A
 	OR	A		;clear carry
 	RET
 CKVAL	CP	1
 	RET	Z
 	CP	13
 	RET	Z
 	CP	20H
 	RET	Z
 	CP	','
 	RET	Z
 	SUB	30H
 	RET	C		;no good
 	CP	10
 	CCF
 	RET			;C flag if bad
 	INC	HL
 POSHL	LD	A,(HL)		;get a byte
 	CP	13		;check for terminator
 	SCF
 	RET	Z		;end of string
 	CP	1		;break?
 	SCF
 	RET	Z
 	CP	20H		;space?
 	JR	Z,POSHL-1	;bump pointer
 	CP	','		;comma?
 	JR	Z,POSHL-1	;bump it
 	OR	A		;clear carry
 	RET
 MOVEFILE	PUSH	DE
 MOVLP	LD	A,(HL)		;get a byte
 	CP	13		;terminator?
 	JR	Z,TERM
 	CP	1		;terminator?
 	JR	Z,TERM
 	INC	HL
 	CP	20H		;space?
 	JR	Z,TERM
 	CP	','		;comma?
 	JR	Z,TERM
 	CALL	UCASE		;make upper case
 	LD	(DE),A		;put in DCB
 	INC	DE
 	JR	MOVLP		;continue
 TERM	LD	A,13		;insert terminator
 	LD	(DE),A		;to the DCB
 	POP	DE
 	RET			;done
 ADDEXT	LD	HL,DEFEXT	;default extension
 	PUSH	DE		;save DCB
 	PUSH	HL
 	EX	DE,HL
 	INC	HL
 	LD	B,9		;9 spaces
 EXTLP	LD	A,(HL)		;get a byte
 	CP	'/'		;has extension?
 	JR	Z,EXTDONE	;done if yes
 	JR	C,DOEXT		;add extension
 	CP	':'		;drive number?
 	JR	C,EXTNEXT	;continue if yes
 	CP	'A'		;41H
 	JR	C,DOEXT		;add extension
 EXTNEXT	INC	HL		;next location
 	DJNZ	EXTLP		;continue
 EXTDONE	POP	HL		;done
 	POP	DE
 	RET			;DCB restored
 DOEXT	LD	BC,0FH		;15 bytes
 	ADD	HL,BC
 	LD	D,H
 	LD	E,L
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	BC
 	LDDR
 	POP	HL
 	INC	HL
 	INC	HL
 	LD	C,3
 	LDDR
 	LD	A,2FH
 	LD	(DE),A
 	POP	DE
 	RET
 DEFEXT	DB	'DRW'		;default extension
 ERRMSG	DB	1CH,1FH
 	DB	'Error !',13
 CANCELMSG	DB	1CH,1FH
 	DB	'Utility ABORTED !',10,13
 ABORTMSG	DB	1CH,1FH
 	DB	'Syntax Error !',13
 	DB	1CH,1FH
 QUICK	DB	'***  POWER-DRAW  ***',13
 MESG	DB	1CH,1FH
 	DB	'***  POWER-DRAW ',27H,'merge',27H
 	DB	' UTILITY  ***',10
 	DB	'by Kim Watt - Breeze/QSD, Inc.',10
 	DB	10,13
 VALMSG	DB	1CH,1FH
 	DB	'Invalid File Format',10,13
 FMESG	DB	'Enter File(s):',13
 NUMESG	DB	10,'Number Buffers in Dest File = '
 ASCNT	DB	'xxx.',13
 SDCB	DS	32
 DDCB	DS	32
 DBUFF	EQU	$&0FF00H
 STRING	EQU	DBUFF+100H
 SIOBUFF	EQU	STRING+100H
 DIOBUFF	EQU	SIOBUFF+100H
 BUFFER	EQU	DIOBUFF+100H
 	END	ENTRY
0,'Number Buffers in Dest File = '
 ASCNT	DB	'xxx.',13
 SDCB	DS	32
 DDCB	DS	32
 DBUFF	EQU	$&0FF00H
 STRING	EQU	DBUFF+100H
 SIOBUFF	EQU	STRING