; DRAW/ASM - kjw/bqsd - 07/82
;
; mini-PowerDraw
;
	ORG	3000H
;
;	SUPERVISOR CALL EQUIVALENCES
;
VDLINE	EQU	9		;STRING TO VIDEO
KBCHAR	EQU	4		;FETCH KEYBOARD
LOOKUP	EQU	28		;LOOKUP VALUE IN TABLE
VDGRAF	EQU	10		;VIDEO GRAPHIC MODE
VDCHAR	EQU	8		;VIDEO CHARACTER MODE
SETBRK	EQU	3		;SET USER BREAK VECTOR
VDREAD	EQU	11		;READ VIDEO DATA
JP2DOS	EQU	36		;EXIT TO DOS
OPEN	EQU	40		;OPEN A FILE
CLOSE	EQU	42		;CLOSE FILE
READNX	EQU	34		;READ A RECORD
WRITNX	EQU	43		;WRITE A RECORD
ERROR	EQU	39		;DISPLAY ERROR MESSAGE
;
SVC	EQU	8		;SUPERVISOR EXECUTOR
;
;	LOCAL DATA SUPPORT
;
CURSOR	DEFW	0000H		;CURSOR ROW/COLUMN
SPBUF	DEFW	0		;SPECIAL DISPLAY BUFFER
FLAG	DEFB	0		;FLAG BYTE
;	7 = 1 = TEXT MODE, = 0 = GRAPHIC MODE
;	6 = UNUSED
;	5 = UNUSED
;	4 = UNUSED
;	3 = UNUSED
;	2 = UNUSED
;	1 = DRAW MODE
;	0 = ERASE MODE (IF 1&0=0 THEN SKIP MODE)
LAST	DEFB	0		;LAST CHAR DISPLAYED
;
;	LOCAL TABLE SUPPORT
;
TABLE0	DEFM	'4'             ;LEFT
	DEFW	BYTE4
	DEFM	'6'             ;RIGHT
	DEFW	BYTE6
	DEFM	'8'             ;UP
	DEFW	BYTE8
	DEFM	'2'             ;DOWN
	DEFW	BYTE2
	DEFM	'5'             ;HOME
	DEFW	BYTE5
	DEFM	'7'             ;DRAW MODE
	DEFW	BYTE7
	DEFM	'9'             ;SKIP MODE
	DEFW	BYTE9
	DEFM	'1'             ;ERASE MODE
	DEFW	BYTE1
	DEFM	'3'
	DEFW	BYTE3
	DEFM	'<'             ;LOAD FILE
	DEFW	LOAD
	DEFM	'>'             ;SAVE FILE
	DEFW	SAVE
	DEFB	-1		;TABLE TERMINATOR
;
;	MESSAGE TEXT
;
MSG0	DEFB	13
	DEFM	'DRAW - '
	DEFM	'DosPLUS II Graphic Screen Editor - '
	DEFM	'Series A.00'
	DEFB	13
	DEFM	'(c)(p) Copyright 1982 '
	DEFM	'by MicroPower, Inc.'
	DEFB	13
	DEFB	13
	DEFB	13
MSG0L	EQU	$-MSG0
;
;	PROGRAM ENTRY POINT, DISPLAY SIGN-ON MESSAGE
;
ENTRY	LD	HL,MSG0 	;HEADER MESSAGE
	LD	BC,MSG0L<8+0	;LENGTH + TERMINATOR BYTE
	LD	A,VDLINE	;SVC #
	RST	SVC		;DISPLAY IT
;
;	CLEAR END OF 'HELP' DISPLAY BUFFER
;
	LD	HL,HLPEND	;END OF HELP DATA
	LD	DE,HLPEND+1
	LD	BC,2000
	LD	(HL),20H	;FILL WITH SPACES
	LDIR			;DO IT!
;
;	SET BREAK PROCESSOR TO EXIT PROGRAM FROM HEADER
;
	LD	HL,0		;DISABLE VECTOR
	LD	A,SETBRK	;SVC #
	RST	SVC
	LD	HL,EXIT 	;EXIT TO DOS VECTOR
	LD	A,SETBRK	;SVC #
	RST	SVC
;
;	SET IY TO POINT TO FLAG BYTE, IT WILL STAY
;
	LD	IY,FLAG 	;EASY BIT TESTING
;
;	WAIT FOR KEYBOARD INPUT TO CONTINUE
;
	CALL	WAITKY		;WAIT FOR A KEY
;
;	DISABLE THE BREAK PROCESSOR
;
	LD	HL,0		;DISABLE IT
	LD	A,SETBRK	;SVC #
	RST	SVC		;DO IT
;
;	CLEAR SCREEN
;
	CALL	CLS		;CLEAR IT
;
;	PROGRAM LOOPER, WAIT FOR A KEY, CURSOR IS FLASH'N
;
LOOPER	CALL	WAITKY		;FETCH A KEY
;
;	CHECK FOR SPECIAL 'HELP' KEY
;
	LD	A,B		;FETCH THE KEY
	CP	5CH		;CONTROL 9?
	JP	Z,SHOW		;DISPLAY HELP COMMANDS
;
;	TEST FOR SPECIAL PROGRAM EXIT KEY
;
	CP	7EH		;CTL 6?
	JP	Z,EXIT		;GO IF YES
;
;	CHECK FOR TEXT MODE, NO CHARACTER ADJUST
;
	BIT	7,(IY)		;TEXT MODE ON?
	JR	NZ,HAVCHR	;HAVE THE CHARACTER, DISP
;
;	ADJUST ALPHA BYTES TO CONTROL CODES FOR GRAPHIC
;
	OR	A		;CHECK FOR HOLD
	JR	Z,HAVCHR	;DON'T ADJUST IT
	SUB	40H		;CHANGE ALPHA TO CONTROL
	JR	C,HAVCHR	;DON'T ADJUST, NOT IN RNG
	CP	32		;SHOULD RESULT IN 0-31
	JR	NC,HAVCHR	;DON'T ADJUST, NOT IN RNG
	LD	B,A		;ELSE ADJUST CHARACTER
;
;	HAVE A CHARACTER, CHECK FOR 'COMMAND' CODES
;
HAVCHR	LD	HL,TABLE0	;COMMAND LOOKUP TABLE
	LD	A,LOOKUP	;SVC #
	RST	SVC		;SEE IF HERE
	JR	Z,SPKEY 	;SPECIAL KEY, GO
;
;	SAVE THE NON-COMMAND KEY FOR 'REPEAT' FEATURE
;
SHOCHR	LD	A,B		;GET KEY
	LD	(LAST),A	;SAVE IT
;
;	KEY IS NOT A CONTROL CODE, DISPLAY IT
;
	CALL	DSPCHR		;DISPLAY CHARACTER
	JR	LOOPER		;CONTINUE
;
;	SPECIAL CURSOR CONTROL BYTE
;
SPKEY	LD	DE,SPRET	;SPECIAL RETURN VECTOR
	PUSH	DE		;SAVE ON STACK FOR RETURN
	JP	(HL)		;GO VECTOR
;
;	RETURN VECTOR FOR SPECIAL COMMAND KEYS
;
SPRET	BIT	1,(IY)		;DRAW MODE?
	JR	NZ,RETDRW	;SETUP FOR DRAW MODE
	BIT	0,(IY)		;ERASE MODE?
	JR	NZ,RETERA	;SETUP FOR ERASE MODE
;
;	SKIP MODE, SET CURSOR, DO NOT CHANGE CHARACTER
;
	LD	D,0		;SETUP FOR 0 CHARS
	LD	A,VDGRAF	;GRAPHIC MODE
	LD	BC,(CURSOR)	;FETCH CURSOR
	RST	SVC		;SET UP ON VIDEO
	LD	(CURSOR),BC	;SAVE IT
	JP	LOOPER		;CONTINUE
;
;	DRAW MODE, DRAW LAST CHAR DISPLAYED
;
RETDRW	LD	A,(LAST)	;GET LAST CHARACTER USED
	LD	B,A		;PASS IT HERE
	JR	SETCUR		;CONTINUE
;
;	ERASE MODE, DRAW A SPACE
;
RETERA	LD	B,20H		;PUT A SPACE ON VIDEO
;
;	SEND CHAR TO DISPLAY AT CURRENT CURSOR LOCATION
;
SETCUR	LD	HL,SPBUF	;SPECIAL BUFFER
	LD	(HL),B		;SAVE CHARACTER
	LD	BC,(CURSOR)	;FETCH CURSOR POSIT
	LD	D,1		;1 CHAR TO DISPLAY
	LD	A,VDGRAF	;GRAPHICS MODE
	RST	SVC		;DISPLAY IT
	JP	LOOPER		;CONTINUE
;
;	CLEAR VIDEO SCREEN
;
CLS	LD	B,1BH		;CLEAR SCREEN CODE
	LD	A,VDCHAR	;VIDEO CHARACTER
	RST	SVC		;GO!
	RET			;DONE, RETURN
;
;	DISPLAY B REGISTER
;
DSPCHR	LD	HL,SPBUF	;SPECIAL BUFFER
	LD	(HL),B		;SAVE CHAR
	LD	D,1		;DISPLAY 1 CHAR
	LD	BC,(CURSOR)	;FETCH CURSOR
	LD	A,VDGRAF	;SVC #
	RST	SVC		;CALL SYSTEM
	LD	D,0		;FETCH CURSOR BACK
	LD	A,VDREAD	;READ IT
	RST	SVC		;FROM DOS SVC
	LD	(CURSOR),BC	;UPDATE NEW CURSOR
	RET
;
;	SPECIAL CURSOR CONTROL COMMANDS
;
;
;	'7' = SET DRAW MODE
;
BYTE7	SET	1,(IY)		;TURN ON DRAW
	RES	0,(IY)		;TURN OFF ERASE
	RET			;DONE
;
;	'8' = UP CURSOR
;
BYTE8	LD	B,0FEH		;UP CURSOR COMMAND
	JR	GOCUR		;CONTINUE
;
;	'9' = SET SKIP MODE
;
BYTE9	RES	1,(IY)		;TURN OFF DRAW
	RES	0,(IY)		;TURN OFF ERASE
	RET			;DONE
;
;	'4' = LEFT CURSOR
;
BYTE4	LD	B,0FCH		;BACK CURSOR COMMAND
	JR	GOCUR		;CONTINUE
;
;	'5' = HOME CURSOR
;
BYTE5	LD	B,0FBH		;HOME CURSOR COMMAND
	JR	GOCUR		;CONTINUE
;
;	'6' = RIGHT CURSOR
;
BYTE6	LD	B,0FDH		;FORWARD CURSOR COMMAND
	JR	GOCUR		;CONTINUE
;
;	'1' = SET ERASE MODE
;
BYTE1	RES	1,(IY)		;TURN OFF DRAW
	SET	0,(IY)		;TURN ON ERASE
	RET			;DONE
;
;	'2' = DOWN CURSOR
;
BYTE2	LD	B,0FFH		;DOWN CURSOR COMMAND
	JR	GOCUR		;CONTINUE
;
;	'3' = TOGGLE TEXT/GRAPHIC MODE
;
BYTE3	LD	A,(IY)		;GET FLAG
	XOR	80H		;REVERSE BIT 7
	LD	(IY),A		;UPDATE FLAG
	RET			;DONE
;
;	DISPLAY CONTROL CODE BYTE IN B REGISTER
;
GOCUR	CALL	DSPCHR		;DISPLAY CHARACTER IN B
	RET			;BACK TO @RETSP, RETURN
;
;	DISPLAY THE KEYS AND ASSOCIATED GRAPHICS
;
SHOW	CALL	GETVID		;MOVE VIDEO INTO A BUFFER
	LD	HL,HELP 	;'HELP' COMMANDS
	CALL	PUTVID+3	;PUT THE MESSAGE ON VIDEO
;
;	WAIT FOR A KEY TO CONTINUE
;
SHOWWT	CALL	WAITKY		;WAIT FOR A KEY
;
;	RESTORE BUFFER TO VIDEO DISPLAY
;
	CALL	PUTVID		;RESTORE VIDEO
;
;	RESET CURSOR BACK TO CURRENT LOCATION
;
FIXCUR	LD	BC,(CURSOR)	;FETCH CURSOR
	LD	D,0		;0 CHARS TO DISPLAY
	LD	A,VDGRAF	;GRAPHICS MODE
	RST	SVC		;CALL IT
	JP	LOOPER		;CONTINUE
;
;	LOAD VIDEO MEMORY INTO (BUFFER)
;
GETVID	LD	HL,BUFFER	;BUFFER START
	LD	BC,0		;START ROW, COLUMN
	LD	E,24		;NUMBER OF VIDEO ROWS
GETV	PUSH	BC		;SAVE REGISTERS
	PUSH	DE
	PUSH	HL
	LD	D,80		;80 BYTE BLOCKS
	LD	A,VDREAD	;SVC #
	RST	SVC		;GET A BLOCK
	POP	HL		;UNSTACK
	LD	DE,80		;BLOCK LENGTH
	ADD	HL,DE		;NEW BUFFER POSITION
	POP	DE		;FINISH UNSTACK
	POP	BC
	INC	B		;BUMP ROW
	DEC	E		;LESS ROW COUNTER
	JR	NZ,GETV 	;CONTINUE
	RET			;DONE, VIDEO LOADED
;
;	LOAD (BUFFER) INTO VIDEO MEMORY
;
PUTVID	LD	HL,BUFFER	;DATA START
	LD	BC,0		;ROW COLUMN
	LD	E,24		;NUMBER OF ROWS
PUTV	PUSH	BC
	PUSH	DE
	PUSH	HL
	LD	D,80		;80 BYTE BLOCKS
	LD	A,VDGRAF	;SVC #
	RST	SVC		;PUT A BLOCK
	POP	HL
	LD	DE,80		;80 BYTE BLOCKS
	ADD	HL,DE		;HL => NEW BUFFER
	POP	DE		;FINISH UNSTACK
	POP	BC
	INC	B		;INCREMENT ROW
	DEC	E		;LESS ROW COUNTER
	JR	NZ,PUTV 	;GO IF MORE
	RET			;ELSE DONE
;
;	PROGRAM EXIT
;
EXIT	CALL	CLS		;CLEAR SCREEN
	LD	A,JP2DOS	;EXIT BACK TO DOS
	RST	SVC		;GO
	JP	ENTRY		;BACK AGAIN?
;
;	LOAD FILE DRAW/SAV INTO BUFFER, AND THEN PUT VID
;
LOAD	CALL	GETFIL		;LOAD THE FILE INTO BUFF
	CALL	PUTVID		;MOVE BUFFER INTO VIDEO
	JP	FIXCUR		;RESET CURSOR, AND CONT
;
;	SAVE FILE DRAW/SAV FROM VIDEO VIA BUFFER
;
SAVE	CALL	GETVID		;MOVE VIDEO INTO BUFFER
	CALL	PUTFIL		;SAVE FILE TO DISK
	JR	LOAD+3		;RE-DRAW VIDEO AND CONT
;
;	LOAD FILE INTO BUFFER
;
GETFIL	LD	DE,FCB		;FILE CONTROL BLOCK
	LD	HL,LLIST	;LOAD PARAMETER LIST
	LD	A,OPEN		;SVC #
	RST	SVC		;OPEN THE FILE
	JP	NZ,ERR		;ERROR, ABORT
;
;	FILE OPENED, LOAD THE DATA
;
	LD	HL,BUFFER	;LOAD ADDRESS
	LD	E,24		;24 VIDEO LINES
;
LLP	PUSH	DE		;SAVE COUNTER
	PUSH	HL		;SAVE BUFFER POINTER
	LD	DE,FCB		;FILE CONTROL BLOCK
	LD	A,READNX	;SVC #
	RST	SVC		;READ THE DATA
	POP	HL		;UNSTACK
	POP	DE
	JR	NZ,ERR		;ERROR, ABORT
	CALL	LBUF		;MOVE I/O BUFFER => VID
	LD	BC,80		;LRL
	ADD	HL,BC		;NEXT BUFFER ADDRESS
	DEC	E		;DEC COUNTER
	JR	NZ,LLP		;MORE TO DO?, GO IF YES
	RET			;ELSE FILE IS LOADED
;
;	SAVE A FILE FROM CONTENTS OF BUFFER
;
PUTFIL	LD	DE,FCB		;FILE CONTROL BLOCK
	LD	HL,SLIST	;SAVE PARAMETER LIST
	LD	A,OPEN		;SVC #
	RST	SVC		;OPEN THE FILE
	JR	NZ,ERR		;ERROR, DISPLAY IT
;
;	FILE OPENED, DUMP THE DATA
;
	LD	HL,BUFFER	;BUFFER POINTER
	LD	E,24		;# VIDEO LINES
;
SLP	PUSH	DE		;SAVE POINTERS
	PUSH	HL
	CALL	SBUF		;MOVE VIDEO BUFFER => I/O
	LD	DE,FCB		;FILE CONTROL BLOCK
	LD	A,WRITNX	;SVC #
	RST	SVC		;WRITE THE BLOCK
	POP	HL		;UNSTACK
	POP	DE
	JR	NZ,ERR		;DISK I/O ERROR
	LD	BC,80		;LRL
	ADD	HL,BC		;NEW POINTER
	DEC	E		;DEC COUNTER
	JR	NZ,SLP		;CONTINUE
;
;	FILE READ/WRITTEN, CLOSE IT
;
CLOSIT	LD	DE,FCB		;FILE CONTROL BLOCK
	LD	A,CLOSE 	;SVC #
	RST	SVC		;GO!
	RET			;IGNORE ERROR HERE
;
;	ERROR ON OPEN OR DISK I/O, DISPLAY ERROR
;
ERR	LD	B,A		;PASS ERROR CODE HERE
	LD	A,ERROR 	;SVC #
	RST	SVC		;DISPLAY ERROR CODE
	CALL	WAITKY		;GET A KEY
	JR	CLOSIT		;CLOSE THE FILE
;
;	KEYBOARD INPUT, WAIT FOR A KEY
;
WAITKY	LD	A,KBCHAR	;KEYBOARD INPUT
	RST	SVC		;CHECK FOR A KEY
	JR	NZ,WAITKY	;WAIT IF NOTHING
	RET			;DONE, RETURN
;
;	MOVE RECORD BUFFER TO VIDEO BUFFER
;
LBUF	PUSH	HL		;SAVE REGISTERS
	PUSH	DE
	EX	DE,HL		;DE => VIDEO BUFFER
	LD	HL,RECADR	;RECORD BUFFER
	JR	MOVER		;MOVE THE DATA
;
;
;	MOVE VIDEO BUFFER TO RECORD BUFFER
;
SBUF	PUSH	HL		;SAVE REGISTERS
	PUSH	DE
	LD	DE,RECADR	;HL => VIDEO BUFFER
;
;	MOVE DATA BETWEEN BUFFERS
;
MOVER	LD	BC,80		;LOGICAL RECORD LENGTH
	LDIR			;MOVE THE BLOCK
	POP	DE		;UNSTACK
	POP	HL
	RET			;DONE
;
;	PARAMETER LIST FOR LOADING A FILE
;
LLIST	DEFW	BUFADR		;BUFFER ADDRESS
	DEFW	RECADR		;RECORD ADDRESS
	DEFW	0000		;EOF XFER ADDRESS
	DEFB	'R'             ;READ ONLY
	DEFB	80		;RECORD LENGTH
	DEFB	'F'             ;FIXED RECORD LENGTH
	DEFB	0		;OPEN, DO NOT CREATE
	DEFB	0		;USER ATTRIBUTE
;
;	PARAMETER LIST FOR SAVING A FILE
;
SLIST	DEFW	BUFADR		;BUFFER ADDRESS
	DEFW	RECADR		;RECORD ADDRESS
	DEFW	0000		;EOF XFER ADDRESS
	DEFB	'W'             ;READ/WRITE ACCESS
	DEFB	80		;RECORD LENGTH
	DEFB	'F'             ;FIXED LENGTH FILE
	DEFB	2		;OPEN/CREATE FILE
	DEFB	0		;USER ATTRIBUTE
;
;	FILE CONTROL BLOCK (60 BYTES)
;
FCB	DEFM	'DRAWSAVE:0'
	DEFB	13
	DEFS	49
;
;	DATA BLOCK FOR 'HELP' COMMANDS
;
HELP	DEFM	'HLD='
	DEFB	0
	DEFM	'   '
	DEFM	'A  ='
	DEFB	1
	DEFM	'   '
	DEFM	'B  ='
	DEFB	2
	DEFM	'   '
	DEFM	'C  ='
	DEFB	3
	DEFM	'   '
	DEFM	'D  ='
	DEFB	4
	DEFM	'   '
	DEFM	'E  ='
	DEFB	5
	DEFM	'   '
	DEFM	'F  ='
	DEFB	6
	DEFM	'   '
	DEFM	'G  ='
	DEFB	7
	DEFM	'   '
	DEFM	'H  ='
	DEFB	8
	DEFM	'   '
	DEFM	'I  ='
	DEFB	9
	DEFM	'   '
	DEFM	'                                                                                '
	DEFM	'J  ='
	DEFB	10
	DEFM	'   '
	DEFM	'K  ='
	DEFB	11
	DEFM	'   '
	DEFM	'L  ='
	DEFB	12
	DEFM	'   '
	DEFM	'M  ='
	DEFB	13
	DEFM	'   '
	DEFM	'N  ='
	DEFB	14
	DEFM	'   '
	DEFM	'O  ='
	DEFB	15
	DEFM	'   '
	DEFM	'P  ='
	DEFB	16
	DEFM	'   '
	DEFM	'Q  ='
	DEFB	17
	DEFM	'   '
	DEFM	'R  ='
	DEFB	18
	DEFM	'   '
	DEFM	'S  ='
	DEFB	19
	DEFM	'   '
	DEFM	'                                                                                '
	DEFM	'T  ='
	DEFB	20
	DEFM	'   '
	DEFM	'U  ='
	DEFB	21
	DEFM	'   '
	DEFM	'V  ='
	DEFB	22
	DEFM	'   '
	DEFM	'W  ='
	DEFB	23
	DEFM	'   '
	DEFM	'X  ='
	DEFB	24
	DEFM	'   '
	DEFM	'Y  ='
	DEFB	25
	DEFM	'   '
	DEFM	'Z  ='
	DEFB	26
	DEFM	'   '
	DEFM	'ESC='
	DEFB	27
	DEFM	'   '
	DEFM	'LFT='
	DEFB	28
	DEFM	'   '
	DEFM	'RHT='
	DEFB	29
	DEFM	'   '
	DEFM	'                                                                                '
	DEFM	'UP ='
	DEFB	30
	DEFM	'   '
	DEFM	'DWN='
	DEFB	31
	DEFM	'                                                                   '
	DEFM	'                                                                                '
	DEFM	'7 = DRAW MODE          8 = UP CURSOR         9 = SKIP MODE                      '
	DEFM	'4 = LEFT CURSOR        5 = HOME CURSOR       6 = RIGHT CURSOR                   '
	DEFM	'1 = ERASE MODE         2 = DOWN CURSOR       3 = TOGGLE TEXT/GRAPHIC MODES      '
	DEFM	'                                                                                '
	DEFM	'< = LOAD FILE          > = SAVE FILE         FILENAME=DRAW/SAV'
HLPEND	EQU	$
;
	DEFS	2000
DBUFF	EQU	$&0FF00H
	ORG	DBUFF+100H	;START OF BUFFER AREA, EVEN PAGE
BUFADR	DEFS	200H		;I/O BUFFER
RECADR	DEFS	200H		;RECORD BUFFER
BUFFER	EQU	$		;VIDEO BUFFER
	END	ENTRY
