; sys5/asm - kjw/bqsd - 05/24/83
;
;	created 05/24/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
@ERRS	EQU	99		;max error messages
@ERRUS	EQU	127		;special author message
;
	TITLE	'<PowerDOS - SYS05/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$ERROR	- SVC 39	- display error message
;	$ERRMSG	- SVC 52	- fetch error message
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$ERROR		;2 - display error msg
	DEFW	$ERRMSG		;3 - fetch error message
	DEFW	$UNDEF		;4 - undefined
	DEFW	$UNDEF		;5 - undefined
	DEFW	$UNDEF		;6 - undefined
	DEFW	$UNDEF		;7 - undefined
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined entry
;
$UNDEF	LD	A,_ERR01	;"bad function code"
	OR	A		;set NZ flag
	RET			;return in error
;
	PAGE
;
;	$ERROR	- display error message
;
;	ENTRY	B  =	error number (0-127)
;			(high bit set will abort to DOS)
;
;	EXIT	Z  =	OK, A=0, message displayed
;		NZ =	A = error code
;
$ERROR	PUSH	BC		;save it
	PUSH	HL		;save this too
;
;	save error number into LAST ERROR
;
	PUSH	IX		;save IX
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch pointer
	RES	7,B		;reset return command
	LD	(IX+36),B	;save error code
	POP	IX		;restore IX
;
	LD	HL,WORK		;sys5 work buffer
	CALL	$ERRMSG		;load (HL) with message
;
;	remove trailing spaces
;
	PUSH	HL		;save text start
	LD	BC,4EH		;length -2
	ADD	HL,BC		;point to 2nd last char
	LD	B,4FH		;max length = 79 chars
	LD	A,' '		;looking for spaces
;
STRIP	CP	(HL)		;space here?
	JR	NZ,ERRPUT	;done, display it
	DEC	HL		;backspace pointer
	DJNZ	STRIP		;dec counter, next char
;
ERRPUT	POP	HL		;restore text start
	LD	A,@VDLINE	;SVC VDLINE
	LD	C,_CR		;B=length, C=term char
	RST	$SVC		;via SVC call
	CALL	NZ,RESVID	;reset video if error
;
ERRET	POP	HL		;restore stack
	POP	BC
;
;	check for abort to dos
;
	LD	A,B		;get error code
	AND	80H		;check bit 7
	RET	Z		;Z flag for OK, return
	LD	A,@ABORT	;SVC #
	RST	$SVC		;abort to DOS
;
;	reset video link/route
;
RESVID	PUSH	IX		;save it
	LD	C,@DO		;display DCB #
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;locate display DCB
	RES	5,(IX+0)	;reset link
	RES	4,(IX+0)	;reset route
	POP	IX		;restore
$RETURN	XOR	A		;return zero
	RET			;done
;
	PAGE
;
;	$ERRMSG	- fetch error message
;
;	ENTRY	B  =	error code (0-127)
;		HL =>	buffer to place text (80 chars)
;
;	EXIT	NZ =	A = error code
;		Z  =	OK
;		HL =>	error message (80 chars)
;
$ERRMSG	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
;
;	pad string with blank characters
;
	PUSH	HL		;save string start
	LD	A,B		;get the error
	AND	7FH		;mask off command bit
	LD	B,79		;string length -1
ERRNUL	LD	(HL),' '	;put one
	INC	HL		;bump pointer
	DJNZ	ERRNUL		;do whole thing
	LD	(HL),_CR 	;put C/R at end
	POP	DE		;get start back
;
;	check for special error code for authors
;
	LD	HL,TABLEUS	;author table
	CP	@ERRUS		;special error?
	JR	Z,SHOERR	;yes, go!
;
;	check for error in defined range
;
	LD	HL,TABLE2	;command lookup table
	CP	@ERRS+1		;valid error #?
	JR	C,$+4		;go if yes
	LD	A,@ERRS+1	;force 'undefined'
;
;	locate error number in table
;
FINDERR BIT	7,(HL)		;high bit on ?
	INC	HL		;bump pointer
	JR	Z,FINDERR	;continue
	CP	B		;correct one ?
	JR	Z,SHOERR-1	;yes, display it
	INC	B		;bump counter
	JR	FINDERR 	;continue through table
;
;	word list found, load text string
;
	DEC	HL		;point to word list start
SHOERR	CALL	SHOW1		;display word
	INC	HL		;bump pointer
	BIT	7,(HL)		;word list terminator?
	JR	Z,SHOERR	;nope, continue
;
	XOR	A		;string loaded, return Z
	RET			;done, no errors!
;
;	display word number pointed to by (HL)
;
SHOW1	LD	A,(HL)		;get the byte
	AND	7FH		;turn off high bit
	LD	C,1		;counter
	PUSH	HL		;save pointer
	LD	HL,TABLE1	;word table
;
FINDSHO BIT	7,(HL)		;high bit on/word start?
	INC	HL		;bump pointer
	JR	Z,FINDSHO	;continue if not
	CP	C		;one we want ?
	JR	Z,PUTERR	;display the word
	INC	C		;bump word position
	JR	FINDSHO 	;else continue
;
PUTERR	DEC	HL		;word start
	JR	PUTCONT 	;print it
;
PUTLOOP BIT	7,(HL)		;end of word?
	JR	Z,PUTCONT	;go if not end!
;
	LD	A,' '		;place a space into buff
	LD	(DE),A		;separator
	INC	DE		;bump string pointer
	POP	HL		;restore table pointer
	RET			;done!
;
PUTCONT LD	A,(HL)		;get char
	AND	7FH		;remove high bit
	LD	(DE),A		;put into buffer
	INC	DE		;bump buffer
	INC	HL		;bump word pointer
	JR	PUTLOOP 	;continue
;
	PAGE
;
; table of words numbered 1-127
; high bit of first char in each word is set
; 80H is the table terminator
;
TABLE1	EQU	$
	DEFM	'A'+80H,'borted'	;1
	DEFM	'A'+80H,'ccess'		;2
	DEFM	'A'+80H,'lready'	;3
	DEFM	'A'+80H,'ttempt'	;4
	DEFM	'A'+80H,'vailable'	;5
	DEFM	'B'+80H,'ad'		;6
	DEFM	'B'+80H,'ank'		;7
	DEFM	'B'+80H,'een'		;8
	DEFM	'B'+80H,'uffer'		;9
	DEFM	'C'+80H,'all'		;10
	DEFM	'C'+80H,'annot'		;11
	DEFM	'C'+80H,'arrier'	;12
	DEFM	'C'+80H,'hange'		;13
	DEFM	'C'+80H,'hannel'	;14
	DEFM	'C'+80H,'haracter'	;15
	DEFM	'C'+80H,'ode'		;16
	DEFM	'C'+80H,'ommand'	;17
	DEFM	'C'+80H,'ompleted'	;18
	DEFM	'C'+80H,'RC'		;19
	DEFM	'C'+80H,'TS'		;20
	DEFM	'D'+80H,'ata'		;21
	DEFM	'D'+80H,'CB'		;22
	DEFM	'D'+80H,'eleted'	;23
	DEFM	'D'+80H,'enied'		;24
	DEFM	'D'+80H,'evice'		;25
	DEFM	'D'+80H,'evicespec'	;26
	DEFM	'D'+80H,'irectory'	;27
	DEFM	'D'+80H,'isk'		;28
	DEFM	'D'+80H,'oes'		;29
	DEFM	'D'+80H,'rive'		;30
	DEFM	'D'+80H,'rivespec'	;31
	DEFM	'E'+80H,'ncountered'	;32
	DEFM	'E'+80H,'nd'		;33
	DEFM	'E'+80H,'rror'		;34
	DEFM	'E'+80H,'stablish'	;35
	DEFM	'E'+80H,'xist'		;36
	DEFM	'E'+80H,'xists'		;37
	DEFM	'E'+80H,'xtend'		;38
	DEFM	'F'+80H,'ault'		;39
	DEFM	'F'+80H,'ile'		;40
	DEFM	'F'+80H,'ilespec'	;41
	DEFM	'F'+80H,'ormat'		;42
	DEFM	'F'+80H,'ound'		;43
	DEFM	'F'+80H,'raming'	;44
	DEFM	'F'+80H,'ull'		;45
	DEFM	'F'+80H,'unction'	;46
	DEFM	'G'+80H,'AT'		;47
	DEFM	'H'+80H,'ardware'	;48
	DEFM	'H'+80H,'as'		;49
	DEFM	'H'+80H,'eader'		;50
	DEFM	'H'+80H,'IT'		;51
	DEFM	'I'+80H,'/O'		;52
	DEFM	'I'+80H,'llegal'	;53
	DEFM	'I'+80H,'n'		;54
	DEFM	'I'+80H,'nitialized'	;55
	DEFM	'I'+80H,'nput'		;56
	DEFM	'I'+80H,'nsufficient'	;57
	DEFM	'I'+80H,'nvalid'	;58
	DEFM	'L'+80H,'oad'		;59
	DEFM	'L'+80H,'ogical'	;60
	DEFM	'L'+80H,'ost'		;61
	DEFM	'M'+80H,'ember'		;62
	DEFM	'M'+80H,'emory'		;63
	DEFM	'D'+80H,'etected'	;64
	DEFM	'M'+80H,'odem'		;65
	DEFM	'M'+80H,'odified'	;66
	DEFM	'N'+80H,'o'		;67
	DEFM	'N'+80H,'ot'		;68
	DEFM	'N'+80H,'umber'		;69
	DEFM	'O'+80H,'f'		;70
	DEFM	'O'+80H,'n'		;71
	DEFM	'O'+80H,'nly'		;72
	DEFM	'O'+80H,'pen'		;73
	DEFM	'O'+80H,'peration'	;74
	DEFM	'O'+80H,'ut'		;75
	DEFM	'O'+80H,'utput'		;76
	DEFM	'O'+80H,'verflow'	;77
	DEFM	'P'+80H,'aper'		;78
	DEFM	'P'+80H,'arameter'	;79
	DEFM	'P'+80H,'arity'		;80
	DEFM	'P'+80H,'rinter'	;81
	DEFM	'P'+80H,'rogram'	;82
	DEFM	'P'+80H,'rotected'	;83
	DEFM	'P'+80H,'rovided'	;84
	DEFM	'R'+80H,'ange'		;85
	DEFM	'R'+80H,'ead'		;86
	DEFM	'R'+80H,'eady'		;87
	DEFM	'R'+80H,'ecord'		;88
	DEFM	'R'+80H,'equired'	;89
	DEFM	'S'+80H,'ector'		;90
	DEFM	'S'+80H,'eek'		;91
	DEFM	'S'+80H,'erial'		;92
	DEFM	'S'+80H,'et'		;93
	DEFM	'S'+80H,'pace'		;94
	DEFM	'S'+80H,'tack'		;95
	DEFM	'S'+80H,'VC'		;96
	DEFM	'S'+80H,'ystem'		;97
	DEFM	'T'+80H,'able'		;98
	DEFM	'T'+80H,'erminated'	;99
	DEFM	'T'+80H,'o'		;100
	DEFM	'T'+80H,'ransmitter'	;101
	DEFM	'T'+80H,'ype'		;102
	DEFM	'U'+80H,'nopen'		;103
	DEFM	'U'+80H,'se'		;104
	DEFM	'V'+80H,'LR'		;105
	DEFM	'W'+80H,'rite'		;106
	DEFM	'U'+80H,'ndefined'	;107
	DEFM	'S'+80H,'ystem Authors:  '
	DEFM	'Kim Watt - Dennis Brent - '
	DEFM	'Renato Reyes - Doug Hogarth'
	DEFB	80H
;
; following is the sentence table
; high bit of first word number in sentence is set
; 80H terminates the table
;
TABLE2	EQU	$
	DEFB	67+80H,34			;0
	DEFB	06+80H,46,16,71,96,10		;1
	DEFB	15+80H,68,05			;2
	DEFB	79+80H,34			;3
	DEFB	19+80H,34,71,28,52,74		;4
	DEFB	28+80H,90,68,43			;5
	DEFB	58+80H,96,21			;6
	DEFB	53+80H,28,13			;7
	DEFB	28+80H,30,68,87			;8
	DEFB	58+80H,21,84			;9
	DEFB	95+80H,75,70,85			;10
	DEFB	40+80H,03,37			;11
	DEFB	67+80H,30,05,100,73,40		;12
	DEFB	106+80H,04,100,86,72,40		;13
	DEFB	106+80H,39,71,28,52		;14
	DEFB	40+80H,106,83			;15
	DEFB	22+80H,49,08,66			;16
	DEFB	27+80H,86,34			;17
	DEFB	27+80H,106,34			;18
	DEFB	58+80H,41			;19
	DEFB	47+80H,86,34			;20
	DEFB	47+80H,106,34			;21
	DEFB	51+80H,86,34			;22
	DEFB	51+80H,106,34			;23
	DEFB	40+80H,68,43			;24
	DEFB	40+80H,02,24			;25
	DEFB	27+80H,94,45			;26
	DEFB	28+80H,94,45			;27
	DEFB	33+80H,70,40,32			;28
	DEFB	88+80H,69,75,70,85		;29
	DEFB	27+80H,94,45,11,38,40		;30
	DEFB	82+80H,68,43			;31
	DEFB	58+80H,31			;32
	DEFB	09+80H,77			;33
	DEFB	59+80H,40,42,34			;34
	DEFB	63+80H,39			;35
	DEFB	14+80H,68,55			;36
	DEFB	73+80H,04,100,73,40		;37
	DEFB	52+80H,04,100,103,40		;38
	DEFB	53+80H,52,04			;39
	DEFB	91+80H,34			;40
	DEFB	61+80H,21,71,28,52		;41
	DEFB	81+80H,68,87			;42
	DEFB	81+80H,75,70,78			;43
	DEFB	81+80H,39			;44
	DEFB	81+80H,68,05			;45
	DEFB	58+80H,52,04,100,105,102,40	;46
	DEFB	89+80H,79,68,43			;47
	DEFB	58+80H,17,79			;48
	DEFB	48+80H,39,71,28,52		;49
	DEFB	21+80H,93,62,68,43		;50
	DEFB	19+80H,34,71,50,86		;51
	DEFB	91+80H,34,71,86			;52
	DEFB	61+80H,21,71,86			;53
	DEFB	19+80H,34,71,86			;54
	DEFB	21+80H,88,68,43,71,86		;55
	DEFB	04+80H,100,86,97,21,88		;56
	DEFB	04+80H,100,86,23,21,88		;57
	DEFB	25+80H,68,05			;58
	DEFB	19+80H,34,71,50,106		;59
	DEFB	91+80H,34,71,106		;60
	DEFB	61+80H,21,71,106		;61
	DEFB	19+80H,34,71,106		;62
	DEFB	21+80H,88,68,43,71,106		;63
	DEFB	106+80H,39,71,28,30		;64
	DEFB	28+80H,106,83			;65
	DEFB	67+80H,46,37			;66
	DEFB	30+80H,68,54,97			;67
	DEFB	58+80H,26			;68
	DEFB	67+80H,25,94,05			;69
	DEFB	25+80H,68,43			;70
	DEFB	25+80H,54,104			;71
	DEFB	83+80H,97,25			;72
	DEFB	65+80H,12,61			;73
	DEFB	101+80H,68,05			;74
	DEFB	92+80H,44,34			;75
	DEFB	92+80H,21,61			;76
	DEFB	92+80H,80,34			;77
	DEFB	20+80H,68,64			;78
	DEFB	53+80H,60,40,69			;79
	DEFB	58+80H,56,14			;80
	DEFB	58+80H,76,14			;81
	DEFB	57+80H,63			;82
	DEFB	25+80H,03,37			;83
	DEFB	21+80H,93,62,68,43		;84
	DEFB	82+80H,99			;85
	DEFB	82+80H,01			;86
	DEFB	58+80H,21,93,62			;87
	DEFB	46+80H,68,05			;88
	DEFB	53+80H,52,14			;89
	DEFB	11+80H,35,28,102		;90
	DEFB	53+80H,21,85			;91
	DEFB	63+80H,07,68,05			;92
	DEFB	63+80H,07,29,68,36		;93
	DEFB	83+80H,63,07			;94
	DEFB	53+80H,02,100,83,40		;95
	DEFB	18+80H				;96
	DEFB	63+80H,07,98,03,37		;97
	DEFB	63+80H,07,98,29,68,36		;98
	DEFB	53+80H,27,88			;99
	DEFB	107+80H,34			;100
TABLEUS	DEFB	108+80H				;127
	DEFB	80H
;
WORK	DEFS	80		;work area for text
;
	PAGE
;
; message text for errors
;
;00 - No Error
;01 - Bad Function Code On SVC Call
;02 - Character Not Available
;03 - Parameter Error
;04 - CRC Error On Disk I/O Operation
;05 - Disk Sector Not Found
;06 - Invalid SVC Data
;07 - Illegal Disk Change
;08 - Disk Drive Not Ready
;09 - Invalid Data Provided
;10 - Stack Out Of Range
;11 - File Already Exists
;12 - No Drive Available To Open File
;13 - Write Attempt To Read Only File
;14 - Write Fault On Disk I/O
;15 - File Write Protected
;16 - DCB Has Been Modified
;17 - Directory Read Error
;18 - Directory Write Error
;19 - Invalid Filespec
;20 - GAT Read Error
;21 - GAT Write Error
;22 - HIT Read Error
;23 - HIT Write Error
;24 - File Not Found
;25 - File Access Denied
;26 - Directory Space Full
;27 - Disk Space Full
;28 - End Of File Encountered
;29 - Record Number Out Of Range
;30 - Directory Space Full Cannot Extend File
;31 - Program Not Found
;32 - Invalid Drivespec
;33 - Buffer Overflow
;34 - Load File Format Error
;35 - Memory Fault
;36 - Channel Not Initialized
;37 - Open Attempt To Open File
;38 - I/O Attempt To Unopen File
;39 - Illegal I/O Attempt
;40 - Seek Error
;41 - Lost Data On Disk I/O
;42 - Printer Not Ready
;43 - Printer Out Of Paper
;44 - Printer Fault
;45 - Printer Not Available
;46 - Invalid I/O Attempt To VLR Type File
;47 - Required Parameter Not Found
;48 - Invalid Command Parameter
;49 - Hardware Fault On Disk I/O
;50 - Data Set Member Not Found
;51 - CRC Error On Header Read
;52 - Seek Error On Read
;53 - Lost Data On Read
;54 - CRC Error On Read
;55 - Data Record Not Found On Read
;56 - Attempt To Read System Data Record
;57 - Attempt To Read Deleted Data Record
;58 - Device Not Available
;59 - CRC Error On Header Write
;60 - Seek Error On Write
;61 - Lost Data On Write
;62 - CRC Error On Write
;63 - Data Record Not Found On Write
;64 - Write Fault On Disk Drive
;65 - Disk Write Protected
;66 - No Function Exists
;67 - Drive Not In System
;68 - Invalid Devicespec
;69 - No Device Space Available
;70 - Device Not Found
;71 - Device In Use
;72 - Protected System Device
;73 - Modem Carrier Lost
;74 - Transmitter Not Available
;75 - Serial Framing Error
;76 - Serial Data Lost
;77 - Serial Parity Error
;78 - CTS Not Detected
;79 - Illegal Logical File Number
;80 - Invalid Input Channel
;81 - Invalid Output Channel
;82 - Insufficient Memory
;83 - Device Already Exists
;84 - Data Set Member Not Found
;85 - Program Terminated
;86 - Program Aborted
;87 - Invalid Data Set Member
;88 - Function Not Available
;89 - Illegal I/O Channel
;90 - Cannot Establish Disk Type
;91 - Illegal Data Range
;92 - Memory Bank Not Available
;93 - Memory Bank Does Not Exist
;94 - Protected Memory Bank
;95 - Illegal Access To Protected File
;96 - Completed
;97 - Memory Bank Table Already Exists
;98 - Memory Bank Table Does Not Exist
;99 - Illegal Directory Record
;100 - Undefined Error
;
_______	EQU	$
;
	END	VECTORS
