; sys2/asm - kjw/bqsd - 05/25/83
;
;	created 05/25/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
SYSPASS	EQU	0692H		;system password '$$'
;
	TITLE	'<PowerDOS - SYS02/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$OPEN	- open file/device
;	$RENAME	- rename file
;	$SETTDC	- fetch password
;	$SETDCB	- setup DCB
;	$HASH	- compute file hashcode
;	$CRACK	- crack filespec
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$OPEN		;2 - open file/device
	DEFW	$RENAME		;3 - rename file
	DEFW	$SETTDC		;4 - set trap door code
	DEFW	$SETDCB		;5 - setup DCB
	DEFW	$HASH		;6 - compute hash code
	DEFW	$CRACK		;7 - crack open filespec
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined entry
;
$UNDEF	LD	A,_ERR01	;undefined call
	OR	A		;set NZ
	RET			;return in error!
;
	PAGE
;
;	$OPEN - open file/device
;
;	ENTRY	DE =>	file/device to open
;		HL =>	open parameter list
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$OPEN	LD	A,@SAVERN	;SVC #
	RST	$SVC		;setup for FCB activity
	LD	(PRIV),A	;init access privledge
	LD	A,(IX+0)	;get 1st char DCB
	CP	'@'		;opening a device?
	JR	NZ,OPEN1	;nope, open file!
;
;	open an existing device
;
OPEND0	PUSH	IX		;save open DCB
	PUSH	IX		;pass to HL
	POP	HL		;HL => FCB
	INC	HL		;HL => text
	CALL	GETDEV		;get device #
	POP	HL		;HL => DCB
	RET	NZ		;go if not found
	LD	A,C		;get device #
	CP	@DRVOFF		;device 0-7?
	JR	C,OPEND1	;go if OK
	LD	A,_ERR68	;'invalid device'
	OR	A		;set NZ
	RET			;return in error
;
;	device found, init DCB
;
OPEND1	LD	(HL),@BIT4	;set as ROUTED device
	INC	HL		;bump DCB
	LD	(HL),C		;save device #
	INC	HL
	INC	HL		;HL => route DCB
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;IX => FCB
	PUSH	IX		;pass to DE
	POP	DE		;DE = DCB
	LD	(HL),E		;load lsb
	INC	HL		;bump
	LD	(HL),D		;load msb
	RET			;return Z for OK
;
	PAGE
;
;	open/init file
;
;	ENTRY	DE =>	FCB
;		HL =>	user parameter list
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
;	parameter list:
;
;	+0/1	- buffer address
;	+2/3	- record address
;	+4/5	- end of file transfer address (EODAD)
;	+6	- access type (R/W/P)
;	+7	- logical record length (LRL)
;	+8	- file type (V/F/E)
;	+9	- open code (0-3)
;	+10	- user attribute
;	+11	- terminating character (00)
;
OPEN1	PUSH	HL		;pass param list to IY
	POP	IY		;IY => user params
	LD	A,(IY+9)	;get open type
	AND	3		;code 0?
	JR	Z,OPEN2		;go if yes
	XOR	3		;code 3?
	JP	NZ,INIT		;open/init file
;
;	open existing file
;
OPEN2	CALL	$CRACK		;crack open filespec
	RET	NZ		;illegal filespec
;
;	get hash and password codes
;
	LD	HL,NAME		;name storage
	CALL	$HASH		;generate hash code
	LD	(HCODE),A	;save it
	LD	DE,PWORD	;DE => user password
	CALL	$SETTDC		;calculate password
	LD	(USRTDC),HL	;save user code
;
;	init drive number
;
	LD	A,(DRIVE)	;get drive #
	OR	A		;global drive?
	JP	P,$+4		;go if not
	XOR	A		;start search
	LD	C,A		;set drive #
;
;	check directory for file
;
OPEN3	LD	A,@DCHECK	;I/O command
	RST	$DIO		;drive ready?
	JR	NZ,OPEN6	;go if not
	CALL	RDHIT		;read HIT table
	RET	NZ		;go if disk error
	LD	HL,BUFF		;start buffer
;
OPEN4	LD	A,(HCODE)	;get hash code
	CP	(HL)		;match?
	JR	Z,OPEN9		;yes, found!
;
OPEN5	INC	L		;bump LSB hit
	JR	NZ,OPEN4	;go till found
;
;	not found on current drive, try next
;
OPEN6	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,OPEN7		;go if not
	INC	C		;bump drive #
	LD	A,C		;get result
	CP	@DRVS		;at end?
	JR	C,OPEN3		;go if not
;
;	file not found!
;
OPEN7	LD	A,_ERR24	;'file not found'
	OR	A		;set NZ
	RET			;return in error
;
;	directory entry does not match, try next
;
OPEN8	POP	BC		;B = LFN
	POP	HL		;HL => directory
	POP	BC		;C = drive #
	CALL	RDHIT		;re-read HIT table
	POP	HL		;HL => hit location
	RET	NZ		;go if I/O error
	JR	OPEN5		;try next slot
;
;	valid hash code found, read directory to test
;
OPEN9	PUSH	HL		;HL => hit
	PUSH	BC		;C = drive #
	LD	B,L		;B = LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory record
	JR	Z,OPEN11	;go if no error
OPEN10	POP	BC		;restore
	POP	HL		;restore
	RET			;return in error
;
;	check filename and extension for match
;
OPEN11	LD	A,(HL)		;get first byte
	CPL			;reverse bits
	AND	@BIT4		;active entry?
	LD	A,_ERR99	;'illegal directory'
	JR	NZ,OPEN10	;directory corrupt!
;
	PUSH	HL		;save directory
	PUSH	BC		;save LFN/drive
	BIT	7,(HL)		;extended entry?
	JR	NZ,OPEN8	;yes, ignore & continue
;
	LD	A,L		;get LSB dir record
	ADD	A,5		;offset to name
	LD	L,A		;HL => directory name
	LD	B,11		;name length
	LD	DE,NAME		;requested name here
;
OPEN12	LD	A,(DE)		;get character
	CP	(HL)		;match?
	JR	NZ,OPEN8	;nope, try next entry
	INC	HL		;bump
	INC	DE		;bump
	DJNZ	OPEN12		;go for name length
;
;	file found, check protection level
;
	POP	BC		;get drive/LFN
	POP	HL		;HL => directory
	POP	AF		;ignore save drive
	POP	AF		;ignore save hit pointer
;
	PUSH	HL		;save dir pointer
	PUSH	BC		;save lfn/drive
	LD	A,(HL)		;get file attribute
	AND	7		;low 3 bits
	LD	C,A		;save prot level
;
	LD	DE,16		;offset to passwords
	ADD	HL,DE		;HL => passwords
;
;	check if 'system' password
;
	LD	DE,(USRTDC)	;user password
	PUSH	HL		;save
	LD	HL,SYSPASS	;'system' password
	XOR	A		;clear carry, prot level
	SBC	HL,DE		;yes?
	POP	HL		;restore dir pointer
	JR	Z,OPEN14	;go if yes!
;
;	check for NO ACCESS to file
;
	LD	A,C		;get access
	CP	_NONE		;no access?
	JR	Z,OPEN13	;'access denied'
;
;	check if 'UPDATE' password
;
	LD	B,(HL)		;get LSB update
	INC	HL		;HL => msb's
	PUSH	HL		;save
	LD	A,(HL)		;get LSB
	RLCA			;shift high bits low
	RLCA
	RLCA
	RLCA
	AND	0FH		;low 4 bits only
	LD	H,A		;msb
	LD	L,B		;lsb
	XOR	A		;clear carry/prot level
	SBC	HL,DE		;update password?
	POP	HL		;restore directory
	JR	Z,OPEN14	;go if yes
;
;	check if 'ACCESS' password
;
	LD	A,(HL)		;get msb
	AND	0FH		;low nibble
	INC	HL		;bump pointer
	LD	L,(HL)		;get lsb
	LD	H,A		;HL = password
	XOR	A		;clear carry/ prot
	SBC	HL,DE		;access password?
	LD	A,C		;restore prot level
	JR	Z,OPEN14	;go if yes
;
;	file access DENIED
;
OPEN13	POP	BC		;restore
	POP	HL		;restore
	LD	A,_ERR25	;'file access denied'
	OR	A		;set NZ
	RET			;return in error
;
OPEN14	POP	BC		;restore
	POP	HL		;restore
	LD	(PRIV),A	;update access privledge
	JP	$SETDCB		;setup DCB
;
	PAGE
;
;	open/create file
;
INIT	CALL	OPEN2		;attempt to open file
	JR	Z,INIT1		;go if no error
	CP	_ERR24		;not found?
	JR	Z,INIT3		;go if yes, init
	RET			;else return error code
;
;	file already exists
;
INIT1	LD	A,(IY+9)	;get open code
	DEC	A		;code 1?
	LD	A,_ERR11	;'file already exists'
	JR	Z,INIT2		;go if 1
	XOR	A		;else OK
INIT2	OR	A		;set error code
	RET			;return OK/error
;
;	init drive #
;
INIT3	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,$+4		;go if not
	XOR	A		;else init #
	LD	C,A		;set drive #
;
;	search HIT for an available slot
;
INIT4	LD	A,@DCHECK	;I/O command
	RST	$DIO		;drive ready?
	JR	NZ,INIT5	;go if not
	JR	C,INIT5		;go if write protected
	CALL	RDHIT		;read HIT table
	RET	NZ		;go if disk error
	LD	HL,BUFF		;start buffer
	CALL	GETENT		;get an available entry
	JR	Z,INIT7		;go if one found
;
;	directory full/drive not ready/write protected
;
INIT5	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,INIT6		;go if not
	INC	C		;bump drive #
	LD	A,C		;get result
	CP	@DRVS		;at max?
	JR	C,INIT4		;nope, try next one
;
;	no drive available to open file
;
INIT6	LD	A,_ERR12	;'no drive available'
	OR	A		;set NZ
	RET			;return in error
;
;	update the HIT table
;
INIT7	PUSH	HL		;save LFN
	LD	A,(HCODE)	;pick up hash code
	LD	(HL),A		;place in table
	CALL	WRHIT		;write HIT table
	POP	HL		;restore HL
	RET	NZ		;go if error
;
;	update the directory
;
	LD	B,L		;B = LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if disk error!
;
	PUSH	HL		;save dir pointer
	LD	(HL),@BIT4	;set as ACTIVE entry
	INC	HL		;bump
	LD	(HL),0		;init flags/date
	INC	HL		;bump
	LD	(HL),0		;date
	INC	HL		;bump
	LD	(HL),0		;EOF byte
	INC	HL		;bump
	LD	A,(IY+7)	;get LRL
	LD	(HL),A		;to directory
	INC	HL		;HL => filename
;
	PUSH	BC		;save LFN
	LD	BC,11		;name length
	LD	DE,NAME		;name stored here
	EX	DE,HL		;DE => directory
	LDIR			;move name
;
	LD	HL,USRTDC	;user password
	PUSH	HL		;save it
	LDI			;lsb to directory
	LD	A,(HL)		;get msb
	RLD			;both nibbles
	LDI			;to entry
	POP	HL		;HL => lsb
	LDI			;set lsb
	EX	DE,HL		;HL => fcb
;
	LD	(HL),0		;clear ern msb
	INC	HL		;bump
	LD	(HL),0		;clear ern lsb
	INC	HL		;bump
	LD	(HL),0		;clear ern nsb
	INC	HL		;bump
;
;	clear SD's
;
	LD	B,10		;SD count
INIT8	LD	(HL),-1		;reset SD
	INC	HL		;bump
	DJNZ	INIT8		;go for count
;
	POP	BC		;restore LFN
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;update directory
	POP	HL		;restore dir entry
	RET	NZ		;go if error
	CALL	$SETDCB		;setup DCB
	SCF			;set 'file created'
	RET			;return Z/Cy
;
	PAGE
;
;	$SETDCB - load file FCB
;
;	ENTRY	B  =	LFN
;		C  =	drive #
;		HL =>	directory record
;		IY =>	user parameter list
;		IX =>	FCB
;
$SETDCB	PUSH	IX		;save
	LD	A,(IY+9)	;get open code
	OR	A		;code 0?
	LD	A,(IY+7)	;get LRL from param list
	JR	NZ,SETDCB1	;go if not 0
;
;	get LRL from directory record
;
	PUSH	HL		;save entry
	INC	HL		;bump to LRL
	INC	HL
	INC	HL
	INC	HL
	LD	A,(HL)		;get LRL
	POP	HL		;restore
;
SETDCB1	LD	(IX+15),A	;pass LRL
	OR	A		;LRL = 0?
	LD	A,(PRIV)	;get access privledge
	SET	5,A		;buffer <> NRN
	JR	Z,SETDCB2	;go if LRL <> 0
	OR	@BIT7		;set blocked records
;
SETDCB2	LD	(IX+1),A	;to FCB
	LD	A,(HL)		;get flags
	INC	HL		;bump to EOF byte
	INC	HL
	INC	HL
	AND	@BIT5		;non shrink file?
	ADD	A,A		;move to bit 6
	LD	(IX+2),A	;to FCB
;
	LD	A,(IY+6)	;get access type
	AND	5FH		;make upper case
	CP	'R'		;read only?
	JR	NZ,SETDCB3	;go if not
	SET	5,(IX+2)	;set READ ONLY
;
SETDCB3	LD	A,(IY+8)	;get file type
	AND	5FH		;make upper case
	CP	'E'		;extended open?
	JR	NZ,SETDCB4	;go if not
	SET	3,(IX+2)	;set extended open bit
;
SETDCB4	CP	'V'		;variable length?
	JR	NZ,SETDCB5	;go if not
	SET	7,(IX+1)	;set blocked records
	SET	7,(IX+2)	;set variable file
;
SETDCB5	LD	A,(IY+0)	;lsb buffer address
	LD	(IX+3),A	;to FCB
	LD	A,(IY+1)	;msb buffer address
	LD	(IX+4),A	;to FCB
	LD	A,(IY+2)	;lsb blocking buffer
	LD	(IX+5),A	;to FCB
	LD	A,(IY+3)	;msb blocking buffer
	LD	(IX+6),A	;to FCB
	LD	A,(IY+4)	;lsb EODAD
	LD	(IX+18),A	;to FCB
	LD	A,(IY+5)	;msb EODAD
	LD	(IX+19),A	;to FCB
;
	LD	(IX+16),C	;device #
	LD	(IX+17),B	;LFN/DEC
;
	XOR	A		;load zero
	LD	(IX+7),A	;nrn byte
	LD	(IX+8),A	;nrn msb
	LD	(IX+9),A	;nrn nsb
	LD	(IX+10),A	;nrn lsb
;
	LD	A,(HL)		;get EOF byte
	LD	(IX+11),A	;to FCB
	LD	DE,16		;offset to dir ERN
	ADD	HL,DE		;HL => ERN
	LD	B,(HL)		;nrn msb
	INC	HL		;bump
	LD	D,(HL)		;nrn nsb
	INC	HL		;bump
	LD	E,(HL)		;nrn lsb
	INC	HL		;bump
	OR	A		;EOF byte = 0?
	JR	Z,SETDCB6	;go if yes
;
	EX	DE,HL		;BHL = nrn
	LD	A,@DEC24	;SVC #
	RST	$SVC		;BHL = BHL -1
	EX	DE,HL		;BDE = nrn
;
SETDCB6	LD	(IX+12),B	;nrn msb
	LD	(IX+13),D	;nrn nsb
	LD	(IX+14),E	;nrn lsb
;
;	setup segment descriptor list
;
	LD	A,(HL)		;get first SD
	INC	HL		;bump
	LD	(IX+22),A	;to FCB
	LD	A,(HL)		;get first SD
	INC	HL		;bump
	LD	(IX+23),A	;to FCB
;
	AND	1FH		;A = gran count
	INC	A		;correct to actual
	LD	E,A		;init offset
	LD	D,0		;DE = gran count
	LD	B,6		;init SD count
;
SETDCB7	LD	A,(HL)		;get SD
	CP	-2		;terminator?
	JR	NC,SETDCB8	;go if yes
	LD	(IX+24),E	;update gran count
	LD	(IX+25),D	;gran offset
	LD	A,(HL)		;get start cylinder
	INC	HL		;bump
	LD	(IX+26),A	;to FCB
	LD	A,(HL)		;get gran offset/count
	INC	HL		;bump
	LD	(IX+27),A	;to FCB
;
;	add gran count to cum total
;
	PUSH	HL		;save
	AND	1FH		;# grans
	INC	A		;correct to actual
	LD	L,A		;pass LSB
	LD	H,0		;HL = count
	ADD	HL,DE		;HL = total offset
	LD	DE,4		;offset to next SD
	ADD	IX,DE		;IX => next SD
	EX	DE,HL		;DE = gran count
	POP	HL		;restore dir pointer
	DJNZ	SETDCB7		;go for SD count
	POP	IX		;restore FCB start
$RETURN	XOR	A		;set NO error
	RET			;return OK
;
;	clear remaining SD's
;
SETDCB8	SLA	B		;*2
	SLA	B		;*4
SETDCB9	LD	(IX+24),-1	;clear SD
	INC	IX		;bump
	DJNZ	SETDCB9		;go for remaining count
	POP	IX		;restore IX
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$CRACK - crack open filespec
;
;	ENTRY	DE =>	filespec
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$CRACK	LD	B,8+3+8+2	;name/ext/password/drive
	LD	HL,NAME		;start name field
	PUSH	HL		;save start
;
CRACK0	LD	(HL),' '	;clear field
	INC	HL		;bump pointer
	DJNZ	CRACK0		;go for length
	POP	HL		;HL => name
	EX	DE,HL		;HL=>name, DE=>storage
;
;	get NAME field (required)
;
	LD	B,8		;name length
	CALL	GETFLD		;move characters
	LD	C,A		;save term character
	LD	A,B		;get length
	CP	8		;anything?
	JR	NZ,CRACK2	;go if yes
	LD	A,_ERR19	;'invalid filespec'
	OR	A		;set NZ
	RET			;return in error
;
;	get EXTENSION field (optional)
;
CRACK2	LD	A,C		;get term char
	CP	'/'		;extension?
	JR	NZ,CRACK3	;go if not
	LD	B,3		;3 chars
	LD	DE,EXT		;extension
	CALL	GETFLD		;move chars
;
;	get PASSWORD field (optional)
;
CRACK3	CP	'.'		;password?
	JR	NZ,CRACK4	;go if not
	LD	B,8		;max length
	LD	DE,PWORD	;move here
	CALL	GETFLD		;move chars
;
;	get DRIVE field (optional)
;
CRACK4	CP	':'		;drive here?
	LD	A,-1		;init global
	JR	NZ,CRACK5	;go if no drive #
;
;	fetch drive #
;
	CALL	GETDEV		;get drive #
	RET	NZ		;invalid
	LD	A,C		;get device #
	SUB	@DRVOFF		;device 0-7?
	JR	NC,CRACK5	;go if OK
	LD	A,_ERR32	;'invalid drivespec'
	OR	A		;set NZ
	RET			;return in error
;
CRACK5	LD	(DRIVE),A	;save it
	XOR	A		;set NO error
	RET			;done!
;
;	$GETDEV - locate device number
;
;	ENTRY	HL =>	user text
;
;	EXIT	Z  =	found, C=device #
;		NZ =	A = error code
;
GETDEV	LD	DE,TDRV		;storage for drive
	EX	DE,HL		;swap
	LD	(HL),' '	;clear first char
	INC	HL		;bump
	LD	(HL),' '	;clear second char
	DEC	HL		;adjust back
	EX	DE,HL		;HL=>name, DE=>tdrv
	LD	B,2		;2 chars max
	CALL	GETFLD		;move chars
	LD	HL,(TDRV)	;get 2 input chars
	LD	A,@LOCNAM	;SVC #
	RST	$SVC		;locate device
	RET			;return with status
;
;	$GETFLD - move filespec characters to field
;
GETFLD	PUSH	BC		;save count
	LD	B,(HL)		;get character
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid character?
	LD	A,B		;get result
	POP	BC		;restore count
	RET	NZ		;go if invalid char
	LD	(DE),A		;else put into field
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	GETFLD		;go for count
	LD	A,(HL)		;get term char
	INC	HL		;bump pointer
	RET			;done!
;
	PAGE
;
;	$HASH - generate hash code
;
;	ENTRY	HL =>	cracked filespec
;
;	EXIT	A  =	hash code
;
$HASH	LD	BC,11<8+0	;B=count, C=hash
;
HASH1	LD	A,(HL)		;get char
	INC	HL		;bump to next
	XOR	C		;accumulate hash
	RLCA
	LD	C,A
	DJNZ	HASH1		;go for count
	OR	A		;=0?
	RET	NZ		;nope, have one
	INC	A		;force non-zero
	RET			;return with code
;
	PAGE
;
;	$SETTDC - set trap door code (password)
;
;	ENTRY	DE =>	password array
;
;	EXIT	HL =	password
;
$SETTDC	LD	HL,-1		;init password
	LD	B,8		;max length
	LD	A,E		;get lsb pointer
	ADD	A,7		;offset to end
	LD	E,A		;update
	JR	NC,SETTDC1	;go if not overflow
	INC	D		;bump msb
;
SETTDC1	LD	A,(DE)		;get char
	PUSH	DE		;save pointer
	LD	D,A		;accumulate password
	LD	E,H
	LD	A,L
	AND	7
	RRCA
	RRCA
	RRCA
	XOR	L
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	XOR	H
	XOR	D
	LD	D,A
	LD	A,L
	ADD	HL,HL
	XOR	H
	XOR	E
	LD	E,A
	EX	DE,HL
	POP	DE		;restore pointer
	DEC	DE		;move back
	DJNZ	SETTDC1		;go for 8 chars
	LD	A,H		;get MsB
	AND	0FH		;drop high 4 bits
	LD	H,A		;HL = password
	RET			;done!
;
	PAGE
;
;	$GETENT - locate available HIT entry
;
;	ENTRY	HL =>	hit table
;		C  =	drive number
;
;	EXIT	Z  =	found, HL => HIT entry
;		NZ =	A = error code
;
GETENT	PUSH	DE		;save
	PUSH	IY		;save
	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;IY => DCT
;
;	begin with random number
;
	LD	A,(IY+23)	;get dir length
	SUB	2		;less gat/hit
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	PUSH	BC		;save
	LD	B,A		;pass limit value
	LD	A,@RANDOM	;SVC #
	RST	$SVC		;compute random number
	LD	L,C		;get random number
	POP	BC		;restore
;
GETENT1	CALL	GETENT4		;locate entry
	JR	Z,GETENT3	;go if one found
;
GETENT2	LD	L,0		;init start table
	CALL	GETENT4		;locate an entry
;
GETENT3	POP	IY		;unstack
	POP	DE		;unstack
	RET			;Z=found, NZ=not found
;
GETENT4	LD	A,(HL)		;get entry
	OR	A		;empty?
	RET	Z		;yes, found!
	LD	A,L		;get LSB
	ADD	A,20H		;offset to next
	LD	L,A		;update LSB
	JR	NC,GETENT4	;go till end
;
	LD	A,(IY+23)	;get dir length
	SUB	3		;ignore gat/hit/+1
	INC	L		;skip to next dir record
	CP	L		;at end?
	JR	NC,GETENT4	;go if not
	OR	-1		;set NO SPACE
	RET			;end of hit
;
	PAGE
;
;	$CLOSE - close file/device
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$CLOSE	LD	A,(DE)		;get flags
	OR	A		;open file?
	JP	M,CLOSE1	;go if file!
	CP	@BIT4		;device?
	LD	A,_ERR38	;'I/O to unopen file'
	RET	NZ		;go if error
;
;	close device
;
	LD	A,@SAVERN	;save registers
	RST	$SVC		;setup for FCB I/O
	LD	B,_EOT		;end of text
	LD	A,@PUT		;SVC #
	RST	$SVC		;send EOT to device
	LD	(IX+0),'@'	;install device header
	LD	C,(IX+1)	;get device #
	LD	A,@GETNAM	;SVC #
	RST	$SVC		;locate device name
	LD	(IX+1),L	;load LSB
	LD	A,H		;get MSB
	CP	' '		;nil?
	JR	NZ,$+4		;go if not
	LD	A,_ETX		;else end text
	LD	(IX+2),A	;load MSB
	LD	(IX+3),_ETX	;terminate devicespec
	XOR	A		;set NO error
	RET			;return CLOSED
;
;	close file
;
CLOSE1	LD	A,@SAVERN	;SVC #
	RST	$SVC		;setup registers
	LD	A,@DBLOCK	;SVC #
	RST	$SVC		;write buffer data
	JR	Z,CLOSE2	;go if no error
	CP	_ERR27		;disk space full?
	RET	NZ		;nope, I/O error
;
	LD	(IX+11),0	;ignore residual
	CALL	CLOSE2		;close file
	RET	NZ		;I/O error
	LD	A,_ERR27	;disk full
	OR	A		;set NZ
	RET			;return in error
;
CLOSE2	LD	B,(IX+17)	;get LFN
	LD	C,(IX+16)	;get drive #
	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;locate DCT
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if I/O error
;
	BIT	4,(HL)		;file active?
	JR	NZ,CKEOF	;yes, continue
	LD	A,_ERR24	;'file not found'
	OR	A		;set NZ
	RET			;return in error
;
CKEOF	PUSH	HL		;save pointer
	BIT	3,(IX+1)	;file updated?
	JR	NZ,UPDEOF	;yes, update EOF
	LD	A,L		;get LSB directory
	ADD	A,22		;offset to SD list
	LD	L,A		;HL => SD list
	POP	AF		;kill pointer
	JR	CNTGRN		;skip directory update
;
;	update shrink/mod flags
;
UPDEOF	POP	HL		;get pointer
	LD	A,(IX+2)	;get flags
	RRCA			;bit 6 => 5
	AND	@BIT5		;keep flag only
	OR	(HL)		;with flags
	LD	(HL),A		;set flags
	INC	L		;=> flags
	LD	A,(IX+1)	;modified flag
	RLCA			;shift bits
	RLCA
	RLCA
	AND	@BIT6		;mod only
	OR	(HL),A		;with flags
	LD	(HL),A		;update flags
;
;	update current date
;
	CALL	DATEP		;BC = date
	OR	(HL)		;with flags
	LD	(HL),A		;update
	INC	L		;HL => date
	LD	(HL),C		;set date
	INC	L		;HL => EOF
;
;	update current EOF/LRL
;
	LD	A,(IX+11)	;EOF byte
	LD	(HL),A		;to dir
	INC	L		;bump
	LD	A,(IX+15)	;get LRL
	LD	(HL),A		;to dir entry
	LD	A,L		;get LSB
	ADD	A,15		;offset to EOF
	LD	L,A		;HL => EOF
;
;	update current EOF Msb's
;
	LD	B,(IX+12)	;ern msb
	LD	D,(IX+13)	;ern nsb
	LD	E,(IX+14)	;ern lsb
	LD	A,(IX+11)	;ern byte
	OR	A		;=0?
	JR	Z,UPEOF1	;go if yes
	EX	DE,HL		;BHL = record
	LD	A,@INC24	;SVC $
	RST	$SVC		;BHL = BHL +1
	EX	DE,HL		;BHL = record
;
UPEOF1	LD	(HL),B		;update MSB eof
	INC	HL		;bump
	LD	(HL),E		;update LSB eof
	INC	HL		;bump
	LD	(HL),D		;update MSB eof
	INC	HL		;HL => SD list
;
;	write updated entry
;
	PUSH	HL		;save
	LD	B,(IX+17)	;LFN
	LD	C,(IX+16)	;drive
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;write record
	POP	HL		;restore
	RET	NZ		;go if I/O error!
;
;	get total grans for file for space release
;
CNTGRN	BIT	6,(IX+2)	;non-shrink?
	JP	NZ,SET0		;skip if yes
;
	LD	DE,0		;init gran count
CNTGRN1	LD	A,(HL)		;get LSB SD
	INC	L		;bump
	CP	-2		;FXDE or end?
	JR	NC,CKFXDE	;go if either
	LD	A,(HL)		;get MSB SD
	INC	L		;bump pointer
	AND	1FH		;gran count
	INC	A		;correct to actual
	ADD	A,E		;add to subtotal
	LD	E,A		;update
	JR	NC,CNTGRN1	;go if no overflow
	INC	D		;bump msb
	JR	CNTGRN1		;continue
;
;	check for read and extended dir entry
;
CKFXDE	JR	NZ,UPDGRN	;FF, update gran count
	LD	B,(HL)		;get FXDE LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read extension
	RET	NZ		;go if I/O error
	LD	A,L		;get LSB
	ADD	A,16H		;offset to SD list
	LD	L,A		;HL => SD list
	JR	CNTGRAN1	;continue counting
;
;	determine # granules to release
;
UPDGRN	PUSH	BC		;save LFN
	PUSH	HL		;save term SD
	LD	B,(IX+12)	;ern msb
	LD	H,(IX+13)	;ern nsb
	LD	L,(IX+14)	;ern lsb
	LD	A,(IX+11)	;ern byte
	OR	A		;byte = 0?
	JR	Z,UPDGRN4	;go if yes
	LD	A,@INC24	;SVC #
	RST	$SVC		;BHL = BHL +1
UPDGRN4	LD	C,(IY+24)	;secs/gran
	LD	A,@DIVID	;SVC #
	RST	$SVC		;BHL+A = BHL/C
	OR	A		;partial?
	JR	Z,UPDGRN5	;go if not
	INC	HL		;full gran if partial
;
UPDGRN5	EX	DE,HL		;DE = alloc grans
	SBC	HL,DE		;less needed
	EX	DE,HL		;DE = unalloc grans
	POP	HL		;restore term SD
	POP	BC		;restore LFN
	JP	Z,SET0		;nothing to release
	JP	C,SET0		;nothing to release
;
;	read GAT for examination
;
	CALL	RDGAT		;read GAT
	RET	NZ		;go if error
	DEC	L		;move back
	DEC	L		;HL => SD
;
;	check if all granules released
;
UPDGRN1	LD	A,D		;get count
	OR	E		;DE = 0000?
	JR	Z,UPDGRN2	;go if done!
;
;	locate next gran to release
;
	PUSH	DE		;save total grans
	LD	A,(HL)		;msb sd
	RLCA			;shift to low
	RLCA
	RLCA
	AND	7		;low 3 bits
	LD	E,A		;offset from track
	LD	A,(HL)		;get again
	AND	1FH		;number grans-1
	ADD	A,E		;add to offset
	LD	E,A		;ending gran
	LD	A,(IY+25)	;grans/cylinder
	CALL	SDIVID		;divide
	DEC	L		;lsb SD
	ADD	A,(HL)		;add track to offset
	INC	L		;adjust back
	LD	D,A		;save track offset
;
;	release gran on gat
;
	PUSH	BC		;save
	PUSH	HL		;save
	LD	L,D		;pass cylinder
	LD	H,BUFF<-8	;msb buffer
	LD	A,E		;get gran offset
	CALL	RESET		;reset bit
	POP	HL		;restore
	POP	BC		;restore
;
;	any more grans on segment?
;
	DEC	(HL)		;grans for segment
	LD	A,(HL)		;get result
	INC	A		;correct
	AND	1FH		;get gran count
	POP	DE		;restore total grans
	JR	NZ,NXTGRN	;go if count <> 0
;
;	kill last segment descriptor
;
	LD	(HL),-1		;reset MSB
	DEC	L		;move back
	LD	(HL),-1		;reset LSB
	DEC	L		;msb PSD
	LD	A,L		;get result
	AND	1FH		;low 5 bits
	CP	16H		;any SD's left?
	JR	NC,NXTGRN	;yes, go!
	XOR	L		;pos to FDE
	LD	L,A		;update
	BIT	7,(HL)		;FXDE?
	JR	Z,UPGRN2	;go if not
;
;	remove dir/hit entries
;
	LD	(HL),0		;kill fxde
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;write LFN
	RET	NZ		;I/O error
	LD	A,B		;get LFN
	AND	0E0H		;file location
	LD	L,A		;pass
	LD	H,$SBUFF<-8	;msb buffer
	INC	L		;HL = rev lfn
	LD	A,(HL)		;get rev LFN
	LD	(RLFN),A	;save it
	CALL	RDHIT		;read HIT
	RET	NZ		;disk error
	LD	L,B		;pass LFN
	LD	(HL),0		;clear HIT table
	CALL	WRHIT		;update HIT table
	RET	NZ		;disk error!
;
;	replace dir entry in buffer
;
	LD	B,0		;get LFN
RLFN	EQU	$-1
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read it
	RET	NZ		;go if error
;
;	write end of SD's marker
;
	LD	A,B		;get LFN
	AND	0E0H		;kill dir record
	ADD	A,1FH		;offset
	LD	L,A		;HL => SD end
	LD	(HL),-1		;term SD
	DEC	L		;move back
	LD	(HL),-1		;term SD
	DEC	L		;move back
;
;	update count of grans to free
;
NXTGRN	DEC	DE		;less gran count
	JR	UPGRN1		;continue till done
;
;	save updated tables
;
UPGRN2	LD	A,@WRLFN	;SVC #
	RST	$SVC		;write record
	RET	NZ		;I/O error
	CALL	WRGAT		;write GAT
	RET	NZ		;go if error
	JR	SET0		;skip
;
	PAGE
;
;	$RETDCB - return filespec to FCB
;
$RETDCB	LD	A,@SAVERN	;SVC #
	RST	$SVC		;setup registers
	LD	B,(IX+17)	;get LFN
	LD	C,(IX+16)	;get drive #
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
;
;	read primary LFN if necessary
;
SET0	LD	A,(IX+17)	;get LFN
	XOR	B		;in?
	LD	B,(IX+17)	;B = LFN
	AND	1FH		;buffer?
	LD	A,@RDLFN	;SVC #
	CALL	NZ,$SVC		;read if not
	RET	NZ		;go if disk error
;
;	move name field to FCB
;
	LD	A,(IX+16)	;get drive #
	PUSH	AF		;save drive
	LD	A,(IX+17)	;get LFN
	AND	0E0H		;sector offset
	ADD	A,5		;offset to name
	LD	L,A		;update
	LD	H,$SBUFF<-8	;msb
	PUSH	IX		;pass to DE
	POP	DE		;DE => FCB
;
	LD	B,8		;max count
SET2	LD	A,(HL)		;get character
	CP	' '		;nothing?
	JR	Z,SET1		;go if yes
	LD	(DE),A		;else put in buffer
	INC	L		;next
	INC	DE		;next
	DJNZ	SET2		;go for count
;
;	move extension field to FCB
;
SET1	LD	A,L		;get LSB
	ADD	A,B		;offset to extension
	LD	L,A		;HL => extension
	LD	A,(HL)		;any?
	CP	' '		;nil?
	JR	Z,SET3		;go if not
	LD	A,'/'		;extension marker
	LD	(DE),A		;to buffer
	INC	DE		;bump
;
	LD	B,3		;3 chars
SET4	LD	A,(HL)		;get char
	CP	' '		;nil?
	JR	Z,SET3		;yes, go!
	LD	(DE),A		;else to FCB
	INC	L		;next
	INC	DE		;next
	DJNZ	SET4		;go for count
;
;	move drive field to FCB
;
SET3	POP	AF		;get drive #
	PUSH	BC		;save
	LD	C,A		;C = device #
	LD	A,@GETNAM	;SVC #
	RST	$SVC		;get device name
	EX	DE,HL		;DE = name
;
	LD	(HL),':'	;mark as drive #
	INC	HL		;bump
	LD	(HL),E		;lsb name
	INC	HL		;bump
	LD	A,D		;get msb
	CP	' '		;nil?
	JR	NZ,$+4		;go if not
	LD	A,_ETX		;else end text
	LD	(HL),A		;second char name
	INC	HL		;bump
	LD	(HL),_ETX	;end filespec
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$PURGE - delete file from directory
;
;	ENTRY	B  =	LFN
;		C  =	drive #
;
$PURGE	LD	A,@SAVERN	;SVC #
	RST	$SVC		;setup for I/O
;
PURGE1	CALL	RDGAT		;read GAT
	RET	NZ		;go if I/O error
	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;locate DCT
	RET	NZ		;illegal drive #
;
PURGE4	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if error
	LD	A,L		;get LSB
	ADD	A,16H		;offset to SD list
	LD	L,A		;HL => SD
;
PURGE3	LD	E,(HL)		;get LSB SD
	INC	L		;bump
	LD	D,(HL)		;get MSB SD
	LD	A,E		;get cylinder
	CP	-2		;FXDE or done?
	JR	NC,PURGE2	;go if yes
	INC	L		;HL => next SD
	CALL	FREE		;release it
	JR	PURGE3		;continue
;
PURGE2	LD	A,L		;get LSB
	AND	0E0H		;reset to beginning
	LD	L,A		;HL => dir record
	LD	(HL),0		;kill dir entry
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;update directory
	RET	NZ		;go if error
;
;	clear HIT entry
;
	CALL	RDHIT		;read HIT table
	RET	NZ		;go if error
	LD	L,B		;HL => hit entry
	LD	(HL),0		;clear hit
	CALL	WRHIT		;update HIT table
	RET	NZ		;go if error
;
	LD	B,D		;pass LFN
	LD	A,E		;get SD entry
	CP	-2		;FXDE?
	JR	Z,PURGE4	;yes, kill also
	JR	WRGAT		;else update GAT
;
	PAGE
;
;	$FREE - free allocated grans for segment
;
FREE	PUSH	DE		;save
	PUSH	HL		;save
	LD	L,E		;track
	LD	H,BUFF<-8	;msb buffer
	LD	A,D		;get msb SD
	AND	1FH		;gran count-1
	LD	E,A		;number grans-1
	INC	E		;correct
	XOR	D		;high 3 bits
	RLCA			;align to low bits
	RLCA
	RLCA
FREE2	PUSH	AF		;save gran
	CALL	RESET		;reset bit
	POP	AF		;restore
	INC	A		;next gran
	CP	(IY+25)		;grans/cylinder
	JR	C,FREE1		;go if not at end
	XOR	A		;offset zero
	INC	L		;next GAT address
FREE1	DEC	E		;less gran count
	JR	NZ,FREE2	;go for count
	POP	HL		;unstack
	POP	DE
	RET			;return Z status
;
;	$RESET - reset bit A at byte (HL)
;
RESET	AND	7		;bit #
	RLCA			;shift bits left
	RLCA
	RLCA
	OR	86H		;create opcode
	LD	(BIT),A		;save opcode
	RES	0,(HL)		;reset bit
BIT	EQU	$-1
	RET			;done
;
	PAGE
;
;	$DATEP - fetch date in packed format
;
;	EXIT	B  =	month
;		C  =	year, day
;
DATEP	PUSH	HL		;save
	PUSH	IX		;save
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch pointers
	LD	L,(IX+10)	;get TIME$
	LD	H,(IX+11)
	LD	BC,4		;offset to DATE$
	ADD	HL,BC		;HL => DATE$
	LD	A,(HL)		;get day
	INC	HL		;bump
	INC	HL		;=> year
	AND	1FH		;day 0-31
	LD	C,A		;pass it
	LD	A,(HL)		;get year
	DEC	HL		;HL => month
	AND	7		;year 0-7
	RRCA			;align high
	RRCA
	RRCA
	OR	C		;combine
	LD	C,A		;C = year/day
	LD	A,(HL)		;get month
	AND	0FH		;month 0-15
	LD	B,A		;B = month
	POP	IX		;restore
	POP	HL		;restore
	RET			;done
;
	PAGE
;
;	$RDGAT/$WRGAT/$RDHIT/$WRHIT
;
RDGAT	PUSH	DE		;save
	LD	DE,@SREAD<8+0	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR20	;'gat read error'
	RET			;return in error
;
WRGAT	PUSH	DE		;save
	LD	DE,@SWRIT<8+0	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR21	;'gat write error'
	RET			;return in error
;
RDHIT	PUSH	DE		;save
	LD	DE,@SREAD<8+1	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR22	;'hit read error'
	RET			;return in error
;
WRHIT	PUSH	DE		;save
	LD	DE,@SWRIT<8+1	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR23	;'hit write error'
	RET			;return in error
;
READWRT	PUSH	BC		;save
	PUSH	HL		;save
	LD	B,0		;BE = sector
	LD	HL,BUFF		;I/O buffer
	LD	A,D		;get command
	RST	$DIO		;read/write sector
	POP	HL		;restore HL
	POP	BC		;restore
	RET			;return with status
;
	PAGE
;
;	data storage
;
NAME	DEFM	'        '
EXT	DEFM	'   '
PWORD	DEFM	'        '
TDRV	DEFM	'  '
;
DRIVE	DEFB	0
PRIV	DEFB	0
HCODE	DEFB	0
USRTDC	DEFW	0
