; sys2/asm - kjw/bqsd - 05/25/83
;
;	created 05/25/83	- kjw/bqsd
;	revised 06/06/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
SYSPASS	EQU	0692H		;system password '$$'
;
	TITLE	'<PowerDOS - SYS02/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$OPEN	- open file/device
;	$RENAME	- rename file
;	$SETTDC	- fetch password
;	$SETDCB	- setup DCB
;	$HASH	- compute file hashcode
;	$CRACK	- crack filespec
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$OPEN		;2 - open file/device
	DEFW	$RENAME		;3 - rename file
	DEFW	$SETTDC		;4 - set trap door code
	DEFW	$SETDCB		;5 - setup DCB
	DEFW	$HASH		;6 - compute hash code
	DEFW	$CRACK		;7 - crack open filespec
	DEFW	$UNDEF		;8 - undefined
	DEFW	$UNDEF		;9 - undefined
	DEFW	$UNDEF		;10 - undefined
	DEFW	$UNDEF		;11 - undefined
	DEFW	$UNDEF		;12 - undefined
	DEFW	$UNDEF		;13 - undefined
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined entry
;
$UNDEF	LD	A,_ERR01	;undefined call
	OR	A		;set NZ
	RET			;return in error!
;
	PAGE
;
;	$OPEN - open file/device
;
;	ENTRY	DE =>	file/device to open
;		HL =>	open parameter list
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$OPEN	LD	A,@SAVERN	;SVC #
	RST	$SVC		;setup for FCB activity
	LD	(PRIV),A	;init access privledge
	LD	A,(IX+0)	;get 1st char DCB
	CP	'@'		;opening a device?
	JR	NZ,OPEN1	;nope, open file!
;
;	open an existing device
;
OPEND0	PUSH	IX		;save open DCB
	PUSH	IX		;pass to HL
	POP	HL		;HL => FCB
	INC	HL		;HL => text
	CALL	GETDEV		;get device #
	POP	HL		;HL => DCB
	RET	NZ		;go if not found
	LD	A,C		;get device #
	CP	@DRVOFF		;device 0-7?
	JR	C,OPEND1	;go if OK
	LD	A,_ERR68	;'invalid device'
	OR	A		;set NZ
	RET			;return in error
;
;	device found, init DCB
;
OPEND1	LD	(HL),@BIT4	;set as ROUTED device
	INC	HL		;bump DCB
	LD	(HL),C		;save device #
	INC	HL
	INC	HL		;HL => route DCB
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;IX => FCB
	PUSH	IX		;pass to DE
	POP	DE		;DE = DCB
	LD	(HL),E		;load lsb
	INC	HL		;bump
	LD	(HL),D		;load msb
	RET			;return Z for OK
;
	PAGE
;
;	open/init file
;
;	ENTRY	DE =>	FCB
;		HL =>	user parameter list
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
;	parameter list:
;
;	+0/1	- buffer address
;	+2/3	- record address
;	+4/5	- end of file transfer address (EODAD)
;	+6	- access type (R/W/P)
;	+7	- logical record length (LRL)
;	+8	- file type (V/F/E)
;	+9	- open code (0-3)
;	+10	- user attribute
;	+11	- terminating character (00)
;
OPEN1	PUSH	HL		;pass param list to IY
	POP	IY		;IY => user params
	LD	A,(IY+9)	;get open type
	AND	3		;code 0?
	JR	Z,OPEN2		;go if yes
	XOR	3		;code 3?
	JP	NZ,INIT		;open/init file
;
;	open existing file
;
OPEN2	CALL	$CRACK		;crack open filespec
	RET	NZ		;illegal filespec
;
;	get hash and password codes
;
	LD	HL,NAME		;name storage
	CALL	$HASH		;generate hash code
	LD	(HCODE),A	;save it
	LD	DE,PWORD	;DE => user password
	CALL	$SETTDC		;calculate password
	LD	(USRTDC),HL	;save user code
;
;	init drive number
;
	LD	A,(DRIVE)	;get drive #
	OR	A		;global drive?
	JP	P,$+4		;go if not
	XOR	A		;start search
	LD	C,A		;set drive #
;
;	check directory for file
;
OPEN3	LD	A,@DCHECK	;I/O command
	RST	$DIO		;drive ready?
	JR	NZ,OPEN6	;go if not
;
;	check if disk name field specified
;
	LD	DE,DNAME	;disk name field
	LD	A,(DE)		;get a char
	CP	' '		;anything?
	JR	Z,OPEN3A	;nope, continue
	LD	B,0		;init LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read BOOT/SYS
	RET	NZ		;go if I/O error
	LD	B,8		;char count
	CALL	COMPAR		;match?
	JR	NZ,OPEN6	;not this drive!
;
OPEN3A	CALL	RDHIT		;read HIT table
	RET	NZ		;go if disk error
;
OPEN4	LD	A,(HCODE)	;get hash code
	CP	(HL)		;match?
	JR	Z,OPEN9		;yes, found!
;
OPEN5	INC	L		;bump LSB hit
	JR	NZ,OPEN4	;go till found
;
;	not found on current drive, try next
;
OPEN6	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,OPEN7		;go if not
	INC	C		;bump drive #
	LD	A,C		;get result
	CP	@DRVS		;at end?
	JR	C,OPEN3		;go if not
;
;	file not found!
;
OPEN7	LD	A,_ERR24	;'file not found'
	OR	A		;set NZ
	RET			;return in error
;
;	directory entry does not match, try next
;
OPEN8	POP	BC		;B = LFN
	POP	HL		;HL => directory
	POP	BC		;C = drive #
	CALL	RDHIT		;re-read HIT table
	POP	HL		;HL => hit location
	RET	NZ		;go if I/O error
	JR	OPEN5		;try next slot
;
;	valid hash code found, read directory to test
;
OPEN9	PUSH	HL		;HL => hit
	PUSH	BC		;C = drive #
	LD	B,L		;B = LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory record
	JR	Z,OPEN11	;go if no error
OPEN10	POP	BC		;restore
	POP	HL		;restore
	RET			;return in error
;
;	check filename and extension for match
;
OPEN11	LD	A,(HL)		;get first byte
	CPL			;reverse bits
	AND	@BIT4		;active entry?
	LD	A,_ERR99	;'illegal directory'
	JR	NZ,OPEN10	;directory corrupt!
;
	PUSH	HL		;save directory
	PUSH	BC		;save LFN/drive
	BIT	7,(HL)		;extended entry?
	JR	NZ,OPEN8	;yes, ignore & continue
;
	LD	DE,NAME		;requested name here
	LD	B,11		;char count
	CALL	COMPAR		;compare
	JR	NZ,OPEN8	;nope, try next entry
;
;	file found, check protection level
;
	POP	BC		;get drive/LFN
	POP	HL		;HL => directory
	POP	AF		;ignore save drive
	POP	AF		;ignore save hit pointer
;
	PUSH	HL		;save dir pointer
	PUSH	BC		;save lfn/drive
	LD	A,(HL)		;get file attribute
	AND	7		;low 3 bits
	LD	C,A		;save prot level
;
	LD	DE,16		;offset to passwords
	ADD	HL,DE		;HL => passwords
;
;	check if 'system' password
;
	LD	DE,(USRTDC)	;user password
	PUSH	HL		;save
	LD	HL,SYSPASS	;'system' password
	XOR	A		;clear carry, prot level
	SBC	HL,DE		;yes?
	POP	HL		;restore dir pointer
	JR	Z,OPEN14	;go if yes!
;
;	check for NO ACCESS to file
;
	LD	A,C		;get access
	CP	_NONE		;no access?
	JR	Z,OPEN13	;'access denied'
;
;	check if 'UPDATE' password
;
	LD	B,(HL)		;get LSB update
	INC	HL		;HL => msb's
	PUSH	HL		;save
	LD	A,(HL)		;get LSB
	RLCA			;shift high bits low
	RLCA
	RLCA
	RLCA
	AND	0FH		;low 4 bits only
	LD	H,A		;msb
	LD	L,B		;lsb
	XOR	A		;clear carry/prot level
	SBC	HL,DE		;update password?
	POP	HL		;restore directory
	JR	Z,OPEN14	;go if yes
;
;	check if 'ACCESS' password
;
	LD	A,(HL)		;get msb
	AND	0FH		;low nibble
	INC	HL		;bump pointer
	LD	L,(HL)		;get lsb
	LD	H,A		;HL = password
	XOR	A		;clear carry/ prot
	SBC	HL,DE		;access password?
	LD	A,C		;restore prot level
	JR	Z,OPEN14	;go if yes
;
;	file access DENIED
;
OPEN13	POP	BC		;restore
	POP	HL		;restore
	LD	A,_ERR25	;'file access denied'
	OR	A		;set NZ
	RET			;return in error
;
OPEN14	POP	BC		;restore
	POP	HL		;restore
	LD	(PRIV),A	;update access privledge
	JP	$SETDCB		;setup DCB
;
	PAGE
;
;	open/create file
;
INIT	CALL	OPEN2		;attempt to open file
	JR	Z,INIT1		;go if no error
	CP	_ERR24		;not found?
	JR	Z,INIT3		;go if yes, init
	RET			;else return error code
;
;	file already exists
;
INIT1	LD	A,(IY+9)	;get open code
	DEC	A		;code 1?
	LD	A,_ERR11	;'file already exists'
	JR	Z,INIT2		;go if 1
	XOR	A		;else OK
INIT2	OR	A		;set error code
	RET			;return OK/error
;
;	init drive #
;
INIT3	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,$+4		;go if not
	XOR	A		;else init #
	LD	C,A		;set drive #
;
;	search HIT for an available slot
;
INIT4	LD	A,@DCHECK	;I/O command
	RST	$DIO		;drive ready?
	JR	NZ,INIT5	;go if not
	JR	C,INIT5		;go if write protected
;
;	check if disk name specified
;
	LD	DE,DNAME	;disk name field
	LD	A,(DE)		;get a char
	CP	' '		;anything?
	JR	Z,INIT4A	;nope, continue
	LD	B,0		;init LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read it
	RET	NZ		;go if I/O error
	LD	B,8		;char count
	CALL	COMPAR		;match?
	JR	NZ,INIT5	;go if not match
;
INIT4A	CALL	RDHIT		;read HIT table
	RET	NZ		;go if disk error
	CALL	GETENT		;get an available entry
	JR	Z,INIT7		;go if one found
;
;	directory full/drive not ready/write protected
;
INIT5	LD	A,(DRIVE)	;get drive #
	OR	A		;global?
	JP	P,INIT6		;go if not
	INC	C		;bump drive #
	LD	A,C		;get result
	CP	@DRVS		;at max?
	JR	C,INIT4		;nope, try next one
;
;	no drive available to open file
;
INIT6	LD	A,_ERR12	;'no drive available'
	OR	A		;set NZ
	RET			;return in error
;
;	update the HIT table
;
INIT7	PUSH	HL		;save LFN
	LD	A,(HCODE)	;pick up hash code
	LD	(HL),A		;place in table
	CALL	WRHIT		;write HIT table
	POP	HL		;restore HL
	RET	NZ		;go if error
;
;	update the directory
;
	LD	B,L		;B = LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if disk error!
;
	PUSH	HL		;save dir pointer
	LD	(HL),@BIT4	;set as ACTIVE entry
	INC	HL		;bump
	LD	(HL),0		;init flags/date
	INC	HL		;bump
	LD	(HL),0		;date
	INC	HL		;bump
	LD	(HL),0		;EOF byte
	INC	HL		;bump
	LD	A,(IY+7)	;get LRL
	LD	(HL),A		;to directory
	INC	HL		;HL => filename
;
	PUSH	BC		;save LFN
	LD	BC,11		;name length
	LD	DE,NAME		;name stored here
	EX	DE,HL		;DE => directory
	LDIR			;move name
;
	LD	HL,USRTDC	;user password
	PUSH	HL		;save it
	LDI			;lsb to directory
	LD	A,(HL)		;get msb
	RLD			;both nibbles
	LDI			;to entry
	POP	HL		;HL => lsb
	LDI			;set lsb
	EX	DE,HL		;HL => fcb
;
	LD	(HL),0		;clear ern msb
	INC	HL		;bump
	LD	(HL),0		;clear ern lsb
	INC	HL		;bump
	LD	(HL),0		;clear ern nsb
	INC	HL		;bump
;
;	clear SD's
;
	LD	B,10		;SD count
INIT8	LD	(HL),-1		;reset SD
	INC	HL		;bump
	DJNZ	INIT8		;go for count
;
	POP	BC		;restore LFN
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;update directory
	POP	HL		;restore dir entry
	RET	NZ		;go if error
	CALL	$SETDCB		;setup DCB
	RET	NZ		;go if error
	SCF			;set 'file created'
	RET			;return Z/Cy
;
	PAGE
;
;	$RENAME - rename file/device
;
;	ENTRY	HL =>	existing device/filespec
;		DE =>	new device/filespec
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$RENAME	LD	A,@SAVREG	;SVC#
	RST	$SVC		;save registers
;
	LD	A,(HL)		;get device name
	CP	'@'		;rename device?
	JP	Z,RENDEV	;yes, go!
;
;	rename file - break apart old spec
;
	PUSH	HL		;save old spec
	PUSH	DE		;save new spec
	EX	DE,HL		;DE => old spec
	CALL	$CRACK		;crack it open
	POP	DE		;restore new
	POP	HL		;restore old
	RET	NZ		;illegal filespec!
;
	PUSH	DE		;save new spec
	LD	DE,FILDCB	;temp DCB
	PUSH	DE		;save DCB
	LD	BC,@DCBLEN	;full spec
	LDIR			;move to temp
	POP	DE		;DE => name
	LD	HL,PLIST	;param list for open
	CALL	$OPEN		;locate file
	POP	HL		;restore new spec
	RET	NZ		;go if error
;
;	check for rename access
;
	LD	A,(FILDCB+1)	;get attribute
	AND	7		;low 3 bits = attribute
	CP	_WRITE		;rename or higher?
	JR	C,RENAME1	;yes, go!
	LD	A,_ERR95	;'illegal file access'
	OR	A		;set NZ
	RET			;return in error
;
;	move new spec to FCB
;
RENAME1	LD	DE,NEWNAME	;new name here
	LD	B,8		;8 chars max name
	CALL	GETFLD		;move chars in
	LD	C,A		;save term char
	LD	A,B		;get result length
	CP	8		;anything?
	JR	NZ,RENAME2	;go if anything
;
;	keep name portion of field
;
	PUSH	BC		;save term char
	PUSH	HL		;save pointer
	LD	HL,NAME		;original name
	LD	DE,NEWNAME	;new name
	LD	BC,8		;length
	LDIR			;keep it
	POP	HL		;restore
	POP	BC		;restore
;
RENAME2	LD	A,C		;get term char
	CP	'/'		;extension?
	JR	Z,RENAME3	;go if yes
;
;	keep old extension
;
	PUSH	HL		;save pointer
	LD	HL,EXT		;old extension
	LD	DE,NEWEXT	;new extension
	LD	BC,3		;length
	LDIR			;save it
	POP	HL		;restore
	JR	RENAME4		;continue
;
RENAME3	LD	DE,NEWEXT	;new extension
	LD	B,3		;length
	CALL	GETFLD		;move data into field
;
;	check for invalid parameters
;
RENAME4	CP	'.'		;password?
	JR	NZ,RENAME6	;go if not
;
RENAME5	LD	A,_ERR19	;'invalid filespec'
	OR	A		;set NZ
	RET			;return in error
;
RENAME6	CP	'('		;disk name?
	JR	Z,RENAME5	;yes, illegal
	CP	':'		;drive?
	JR	Z,RENAME5	;yes, illegal
;
;	create new filespec
;
	LD	BC,(FILDCB+16)	;get drive/lfn
	LD	(USRTDC),BC	;save them
	LD	HL,NEWNAME	;new name
	LD	DE,FILDCB	;file DCB area
	LD	B,8		;name length
;
RENAME7	LD	A,(HL)		;get character
	CP	' '		;anything?
	JR	Z,RENAME8	;nope, continue
	LD	(DE),A		;else load
	INC	DE		;bump
RENAME8	INC	HL		;bump source
	DJNZ	RENAME7		;go for length
	LD	A,(HL)		;get extension field
	CP	' '		;anything?
	JR	Z,RENAM10	;go if not
	LD	A,'/'		;extension marker
	LD	(DE),A		;to buffer
	INC	DE		;bump
	LD	B,3		;3 chars max
;
RENAME9	LD	A,(HL)		;get a char
	CP	' '		;anything?
	JR	Z,RENAM10	;go if not
	LD	(DE),A		;else place in DCB
	INC	DE		;bump
	INC	HL		;bump
	DJNZ	RENAME9		;go for count
;
RENAM10	EX	DE,HL		;HL => DCB
	LD	(HL),':'	;indicate drive
	INC	HL		;bump
	LD	BC,(USRTDC)	;get drive #
	EX	DE,HL		;DE => DCB
	LD	A,@GETNAM	;SVC #
	RST	$SVC		;get device name
	EX	DE,HL		;HL=>DCB, DE=name
	LD	(HL),E		;load first char
	INC	HL		;bump pointer
	LD	A,D		;get second char
	CP	' '		;anything?
	JR	NZ,$+4		;go if yes
	LD	A,_ETX		;else terminate
	LD	(HL),A		;term char
;
;	check if file exists already
;
	LD	DE,FILDCB	;file DCB
	LD	HL,PLIST	;param list to open
	CALL	$OPEN		;attempt to open file
	JR	Z,RENAM11	;go if no error!
	CP	_ERR24		;not found?
	RET	NZ		;nope, disk error!
	JR	RENAM12		;else continue
;
;	file already exists!
;
RENAM11	LD	A,_ERR11	;'file already exists'
	OR	A		;set NZ
	RET			;return in error
;
RENAM12	LD	BC,(USRTDC)	;get drive/LFN
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if error
	LD	DE,5		;offset to name
	ADD	HL,DE		;HL => name
	EX	DE,HL		;DE => dir name
	LD	HL,NEWNAME	;new name
	PUSH	BC		;save
	LD	BC,11		;name/ext count
	LDIR			;move to directory
	POP	BC		;restore drive/lfn
	LD	A,@WRLFN	;write it out
	RST	$SVC		;update directory
	RET	NZ		;go if disk error
;
;	update HIT table for new name
;
	CALL	RDHIT		;read HIT table
	RET	NZ		;I/O error
	PUSH	HL		;save table
	LD	HL,NEWNAME	;new name
	CALL	$HASH		;compute hash code
	POP	HL		;HL => hit table
	LD	L,B		;HL => hit entry
	LD	(HL),A		;save new hit entry
	JP	WRHIT		;write new hit table
;
;	rename device
;
RENDEV	INC	HL		;bump pointer
	CALL	GETDEV		;get device name
	RET	NZ		;device not found!
;
	EX	DE,HL		;swap
	LD	A,(HL)		;get second name
	CP	'@'		;rename to device?
	LD	A,_ERR68	;'invalid devicespec'
	RET	NZ		;type mismatch!
;
	INC	HL		;bump to data
	PUSH	BC		;save device #
	CALL	GETDEV		;see if exists
	POP	DE		;E = prev dev #
	JR	NZ,RENDEV1	;go if not found!
	LD	A,_ERR83	;'device exists'
	OR	A		;set NZ
	RET			;return in error
;
RENDEV1	CP	_ERR70		;device not found?
	RET	NZ		;nope, exit!
;
;	alter device name
;
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch pointer
	LD	L,(IX+12)	;get DCB table
	LD	H,(IX+13)	;HL => device table
	LD	A,C		;get device #
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,L		;add to table
	LD	L,A		;update lsb
	JR	NC,$+3		;go if no overflow
	INC	H		;HL => device name
	LD	DE,(TDRV)	;new name
	LD	(HL),E		;load first char
	INC	HL		;bump
	LD	(HL),D		;load second char
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$SETDCB - load file FCB
;
;	ENTRY	B  =	LFN
;		C  =	drive #
;		HL =>	directory record
;		IY =>	user parameter list
;		IX =>	FCB
;
$SETDCB	LD	A,(IY+6)	;get open code
	CALL	UCASE		;make upper case
	CP	'R'		;for read only?
	JR	Z,SETDCB0	;yes, ok to continue
;
;	check if MUSER bit set
;
	PUSH	IX		;save
	LD	A,@DPOINT	;SVC#
	RST	$SVC		;fetch data block
	BIT	4,(IX+35)	;muser bit set?
	POP	IX		;restore
	JR	Z,SETDCB0	;nope, continue
;
;	check if file currently open for write
;
	INC	HL		;bump DCB
	LD	A,(HL)		;get flags
	DEC	HL		;adjust back
	AND	@BIT7		;open for write now?
	LD	A,_ERR37	;'file already open'
	RET	NZ		;go if open now!
;
SETDCB0	PUSH	IX		;save
	LD	A,(IY+9)	;get open code
	OR	A		;code 0?
	LD	A,(IY+7)	;get LRL from param list
	JR	NZ,SETDCB1	;go if not 0
;
;	get LRL from directory record
;
	PUSH	HL		;save entry
	INC	HL		;bump to LRL
	INC	HL
	INC	HL
	INC	HL
	LD	A,(HL)		;get LRL
	POP	HL		;restore
;
SETDCB1	LD	(IX+15),A	;pass LRL
	OR	A		;LRL = 0?
	LD	A,(PRIV)	;get access privledge
	SET	5,A		;buffer <> NRN
	JR	Z,SETDCB2	;go if LRL <> 0
	OR	@BIT7		;set blocked records
;
SETDCB2	LD	(IX+1),A	;to FCB
	LD	(IX+0),@BIT7	;flag as OPEN
	LD	A,(HL)		;get flags
	INC	HL		;bump to EOF byte
	INC	HL
	INC	HL
	AND	@BIT5		;non shrink file?
	ADD	A,A		;move to bit 6
	LD	(IX+2),A	;to FCB
;
	LD	A,(IY+6)	;get access type
	CALL	UCASE		;make upper case
	CP	'R'		;read only?
	JR	NZ,SETDCB3	;go if not
	SET	5,(IX+2)	;set READ ONLY
;
SETDCB3	LD	A,(IY+8)	;get file type
	CALL	UCASE		;make upper case
	CP	'E'		;extended open?
	JR	NZ,SETDCB4	;go if not
	SET	3,(IX+2)	;set extended open bit
;
SETDCB4	CP	'V'		;variable length?
	JR	NZ,SETDCB5	;go if not
	SET	7,(IX+1)	;set blocked records
	SET	7,(IX+2)	;set variable file
;
SETDCB5	LD	A,(IY+0)	;lsb buffer address
	LD	(IX+3),A	;to FCB
	LD	A,(IY+1)	;msb buffer address
	LD	(IX+4),A	;to FCB
	LD	A,(IY+2)	;lsb blocking buffer
	LD	(IX+5),A	;to FCB
	LD	A,(IY+3)	;msb blocking buffer
	LD	(IX+6),A	;to FCB
	LD	A,(IY+4)	;lsb EODAD
	LD	(IX+18),A	;to FCB
	LD	A,(IY+5)	;msb EODAD
	LD	(IX+19),A	;to FCB
;
	LD	(IX+16),C	;device #
	LD	(IX+17),B	;LFN/DEC
;
	XOR	A		;load zero
	LD	(IX+7),A	;nrn byte
	LD	(IX+8),A	;nrn msb
	LD	(IX+9),A	;nrn nsb
	LD	(IX+10),A	;nrn lsb
;
	LD	A,(HL)		;get EOF byte
	LD	(IX+11),A	;to FCB
	LD	DE,16		;offset to dir ERN
	ADD	HL,DE		;HL => ERN
	LD	B,(HL)		;nrn msb
	INC	HL		;bump
	LD	E,(HL)		;nrn lsb
	INC	HL		;bump
	LD	D,(HL)		;nrn nsb
	INC	HL		;bump
	OR	A		;EOF byte = 0?
	JR	Z,SETDCB6	;go if yes
;
	EX	DE,HL		;BHL = nrn
	LD	A,@DEC24	;SVC #
	RST	$SVC		;BHL = BHL -1
	EX	DE,HL		;BDE = nrn
;
SETDCB6	LD	(IX+12),B	;nrn msb
	LD	(IX+13),D	;nrn nsb
	LD	(IX+14),E	;nrn lsb
;
;	setup segment descriptor list
;
	LD	A,(HL)		;get first SD
	INC	HL		;bump
	LD	(IX+20),A	;to FCB
	LD	A,(HL)		;get first SD
	INC	HL		;bump
	LD	(IX+21),A	;to FCB
;
	AND	1FH		;A = gran count
	INC	A		;correct to actual
	LD	E,A		;init offset
	LD	D,0		;DE = gran count
	LD	B,4		;init SD count
;
SETDCB7	LD	A,(HL)		;get SD
	CP	-2		;terminator?
	JR	NC,SETDCB8	;go if yes
	LD	(IX+22),E	;update gran count
	LD	(IX+23),D	;gran offset
	LD	A,(HL)		;get start cylinder
	INC	HL		;bump
	LD	(IX+24),A	;to FCB
	LD	A,(HL)		;get gran offset/count
	INC	HL		;bump
	LD	(IX+25),A	;to FCB
;
;	add gran count to cum total
;
	PUSH	HL		;save
	AND	1FH		;# grans
	INC	A		;correct to actual
	LD	L,A		;pass LSB
	LD	H,0		;HL = count
	ADD	HL,DE		;HL = total offset
	LD	DE,4		;offset to next SD
	ADD	IX,DE		;IX => next SD
	EX	DE,HL		;DE = gran count
	POP	HL		;restore dir pointer
	DJNZ	SETDCB7		;go for SD count
;
;	check if MUSER bit set and file open for write
;
SETDCBX	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data pointer
	BIT	4,(IX+35)	;muser bit?
	POP	IX		;restore FCB
	JR	Z,$RETURN	;go if not set
	BIT	5,(IX+2)	;open for write?
	JR	NZ,$RETURN	;nope, continue
	LD	A,(IX+1)	;get access level
	AND	7		;low 3 bits
	CP	_WRITE		;write access?
	JR	C,$RETURN	;nope, go!
;
;	flag file as open in directory
;
	LD	C,(IX+16)	;get drive
	LD	B,(IX+17)	;get lfn
	LD	A,@RDLFN	;SVC #
	RST	$SVC		;read directory
	RET	NZ		;go if I/O error
	INC	HL		;directory +1
	SET	7,(HL)		;set file as OPEN
	LD	A,@WRLFN	;SVC #
	RST	$SVC		;update directory
	RET	NZ		;go if I/O error
;
$RETURN	XOR	A		;set NO error
	RET			;return OK
;
;	clear remaining SD's
;
SETDCB8	SLA	B		;*2
	SLA	B		;*4
SETDCB9	LD	(IX+22),-1	;clear SD
	INC	IX		;bump
	DJNZ	SETDCB9		;go for remaining count
	JR	SETDCBX		;continue
;
	PAGE
;
;	$CRACK - crack open filespec
;
;	ENTRY	DE =>	filespec
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$CRACK	LD	B,8+3+8+2+8	;name/ext/password/drive
	LD	HL,NAME		;start name field
	PUSH	HL		;save start
;
CRACK0	LD	(HL),' '	;clear field
	INC	HL		;bump pointer
	DJNZ	CRACK0		;go for length
	POP	HL		;HL => name
	EX	DE,HL		;HL=>name, DE=>storage
;
;	get NAME field (required)
;
	LD	B,8		;name length
	CALL	GETFLD		;move characters
	LD	C,A		;save term character
	LD	A,B		;get length
	CP	8		;anything?
	JR	NZ,CRACK2	;go if yes
	LD	A,_ERR19	;'invalid filespec'
	OR	A		;set NZ
	RET			;return in error
;
;	get EXTENSION field (optional)
;
CRACK2	LD	A,C		;get term char
	CP	'/'		;extension?
	JR	NZ,CRACK3	;go if not
	LD	B,3		;3 chars
	LD	DE,EXT		;extension
	CALL	GETFLD		;move chars
;
;	get PASSWORD field (optional)
;
CRACK3	CP	'.'		;password?
	JR	NZ,CRACK4	;go if not
	LD	B,8		;max length
	LD	DE,PWORD	;move here
	CALL	GETFLD		;move chars
;
;	get DRIVE field (optional)
;
CRACK4	LD	B,A		;save term char
	CP	':'		;drive here?
	LD	C,-1		;init global
	JR	NZ,CRACK5	;go if no drive #
;
;	fetch drive #
;
	CALL	GETDEV		;get drive #
	RET	NZ		;invalid
	LD	A,C		;get device #
	SUB	@DRVOFF		;device 0-7?
	LD	C,A		;update drive
	JR	NC,CRACK5	;go if OK
	LD	A,_ERR32	;'invalid drivespec'
	OR	A		;set NZ
	RET			;return in error
;
;	fetch DISKNAME field
;
CRACK5	LD	A,C		;get drive #
	LD	(DRIVE),A	;save it
	LD	A,B		;get term char back
	CP	'('		;disk name field?
	JR	NZ,CRACK6	;go if not
	LD	DE,DNAME	;disk name
	LD	B,8		;field length
	CALL	GETFLD		;fetch field
;
CRACK6	XOR	A		;set NO error
	RET			;done!
;
;	$GETDEV - locate device number
;
;	ENTRY	HL =>	user text
;
;	EXIT	Z  =	found, C=device #
;		NZ =	A = error code
;
GETDEV	PUSH	DE		;save
	LD	DE,TDRV		;storage for drive
	EX	DE,HL		;swap
	LD	(HL),' '	;clear first char
	INC	HL		;bump
	LD	(HL),' '	;clear second char
	DEC	HL		;adjust back
	EX	DE,HL		;HL=>name, DE=>tdrv
	LD	B,2		;2 chars max
	CALL	GETFLD		;move chars
	LD	B,A		;save term char
	POP	DE		;restore
;
	PUSH	HL		;save pointer
	LD	HL,(TDRV)	;get 2 input chars
	LD	A,@LOCNAM	;SVC #
	RST	$SVC		;locate device
	POP	HL		;restore
	RET	NZ		;go if not found
	LD	A,B		;get term char
	RET			;return term char
;
;	$GETFLD - move filespec characters to field
;
GETFLD	PUSH	BC		;save count
	LD	B,(HL)		;get character
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid character?
	LD	A,B		;get result
	POP	BC		;restore count
	INC	HL		;bump pointer
	RET	NZ		;go if invalid char
	LD	(DE),A		;else put into field
	INC	DE		;bump dest
	DJNZ	GETFLD		;go for count
	LD	A,(HL)		;get term char
	INC	HL		;bump pointer
	RET			;done!
;
	PAGE
;
;	$HASH - generate hash code
;
;	ENTRY	HL =>	cracked filespec
;
;	EXIT	A  =	hash code
;
$HASH	LD	BC,11<8+0	;B=count, C=hash
;
HASH1	LD	A,(HL)		;get char
	INC	HL		;bump to next
	XOR	C		;accumulate hash
	RLCA
	LD	C,A
	DJNZ	HASH1		;go for count
	OR	A		;=0?
	RET	NZ		;nope, have one
	INC	A		;force non-zero
	RET			;return with code
;
	PAGE
;
;	$SETTDC - set trap door code (password)
;
;	ENTRY	DE =>	password array
;
;	EXIT	HL =	password
;
$SETTDC	LD	HL,-1		;init password
	LD	B,8		;max length
	LD	A,E		;get lsb pointer
	ADD	A,7		;offset to end
	LD	E,A		;update
	JR	NC,SETTDC1	;go if not overflow
	INC	D		;bump msb
;
SETTDC1	LD	A,(DE)		;get char
	PUSH	DE		;save pointer
	LD	D,A		;accumulate password
	LD	E,H
	LD	A,L
	AND	7
	RRCA
	RRCA
	RRCA
	XOR	L
	LD	L,A
	LD	H,0
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	XOR	H
	XOR	D
	LD	D,A
	LD	A,L
	ADD	HL,HL
	XOR	H
	XOR	E
	LD	E,A
	EX	DE,HL
	POP	DE		;restore pointer
	DEC	DE		;move back
	DJNZ	SETTDC1		;go for 8 chars
	LD	A,H		;get MsB
	AND	0FH		;drop high 4 bits
	LD	H,A		;HL = password
	RET			;done!
;
	PAGE
;
;	$GETENT - locate available HIT entry
;
;	ENTRY	HL =>	hit table
;		C  =	drive number
;
;	EXIT	Z  =	found, HL => HIT entry
;		NZ =	A = error code
;
GETENT	PUSH	DE		;save
	PUSH	IY		;save
	LD	A,@LOCDRV	;SVC #
	RST	$SVC		;IY => DCT
;
;	check if files to be allocated sequentially
;
	PUSH	IX		;save
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	BIT	6,(IX+35)	;sequential?
	POP	IX		;restore
	JR	NZ,GETENT2	;start sequential
;
;	begin with random number
;
	LD	A,(IY+23)	;get dir length
	SUB	2		;less gat/hit
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	PUSH	BC		;save
	LD	B,A		;pass limit value
	LD	A,@RANDOM	;SVC #
	RST	$SVC		;compute random number
	LD	L,C		;get random number
	POP	BC		;restore
;
GETENT1	CALL	GETENT4		;locate entry
	JR	Z,GETENT3	;go if one found
;
GETENT2	LD	L,0		;init start table
	CALL	GETENT4		;locate an entry
;
GETENT3	POP	IY		;unstack
	POP	DE		;unstack
	RET			;Z=found, NZ=not found
;
GETENT4	LD	A,(HL)		;get entry
	OR	A		;empty?
	RET	Z		;yes, found!
	LD	A,L		;get LSB
	ADD	A,20H		;offset to next
	LD	L,A		;update LSB
	JR	NC,GETENT4	;go till end
;
	LD	A,(IY+23)	;get dir length
	SUB	3		;ignore gat/hit/+1
	INC	L		;skip to next dir record
	CP	L		;at end?
	JR	NC,GETENT4	;go if not
	OR	-1		;set NO SPACE
	RET			;end of hit
;
;	$COMPAR - compare DE with directory entry
;
COMPAR	LD	A,L		;get LSB
	ADD	A,5		;offset to name
	LD	L,A		;HL => name
;
COMPAR1	LD	A,(DE)		;get a char
	CP	(HL)		;match?
	RET	NZ		;nope, return
	INC	HL		;bump
	INC	DE		;bump
	DJNZ	COMPAR1		;go for count
	RET			;return Z for match
	PAGE
;
;	$RDHIT/$WRHIT
;
RDHIT	PUSH	DE		;save
	LD	DE,@SREAD<8+1	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR22	;'hit read error'
	RET			;return in error
;
WRHIT	PUSH	DE		;save
	LD	DE,@SWRIT<8+1	;D=command, E=sector
	CALL	READWRT		;go common
	POP	DE		;restore
	RET	Z		;no error
	LD	A,_ERR23	;'hit write error'
	RET			;return in error
;
READWRT	PUSH	BC		;save
	LD	B,0		;BE = sector
	LD	HL,$SBUFF	;I/O buffer
	LD	A,D		;get command
	RST	$DIO		;read/write sector
	POP	BC		;restore
	RET			;return with status
;
UCASE	CP	'a'		;in range?
	RET	C		;nope, go!
	CP	'z'+1		;in range?
	RET	NC		;nope
	AND	5FH		;make upper case
	RET			;A = ucase char
;
	PAGE
;
;	data storage
;
NAME	DEFM	'        '
EXT	DEFM	'   '
PWORD	DEFM	'        '
TDRV	DEFM	'  '
DNAME	DEFM	'        '
;
NEWNAME	DEFM	'        '
NEWEXT	DEFM	'   '
;
DRIVE	DEFB	0
PRIV	DEFB	0
HCODE	DEFB	0
USRTDC	DEFW	0
;
FILDCB	DC	@DCBLEN,0
;
PLIST	DEFW	$SBUFF
	DEFW	$SBUFF
	DEFW	0
	DEFB	'R'
	DEFB	0
	DEFB	'F'
	DEFB	0
	DEFB	0
;
_______	EQU	$
;
	END	VECTORS
