; sys1/asm - kjw/bqsd - 05/13/83
;
;	created 05/13/83	- kjw/bqsd
;	revised 05/31/83	- kjw
;
*GET	DOSEQU			;external equivalences
;
	TITLE	'<PowerDOS - SYS01/SYS>'
;
	SUBTTL	'<Copyright (C) 1983 - Breeze/QSD, Inc. - Dallas, Texas>'
;
;	$JP2DOS	- SVC 36	- normal DOS entry & cont
;	$ABORT	- SVC 31	- abort to dos
;	$CLRXIT	- SVC 57	- exit & clear memory
;	$DOSCMD	- SVC 37	- dos command & exit
;	$RETCMD	- SVC 38	- dos command & return
;	$BOOT	- SVC 108	- hardware system reset
;	$EVAL	- SVC 83	- evaluate input command
;	$FSPEC	- SVC 84	- fetch user filespec
;	$PARAM	- SVC 87	- evaluate user params
;	$FEXT	- SVC 88	- add default extension
;	$LIB	- library	- fetch sys library pntr
;	$CLS	- library	- clear video screen
;
	PAGE
;
	ORG	$LOSYS		;low overlay
;
VECTORS	DEFW	$RETURN		;1 - load and return
	DEFW	$JP2DOS		;2 - exit to dos
	DEFW	$ABORT		;3 - abort to dos
	DEFW	$CLRXIT		;4 - exit dos and clear
	DEFW	$DOSCMD		;5 - dos cmd and exit
	DEFW	$RETCMD		;6 - dos cmd and return
	DEFW	$BOOT		;7 - hardware reset
	DEFW	$EVAL		;8 - evaluate input cmd
	DEFW	$FSPEC		;9 - fetch filespec
	DEFW	$PARAM		;10 - fetch cmd params
	DEFW	$FEXT		;11 - add file extension
	DEFW	$LIB		;12 - fetch lib pointer
	DEFW	$CLS		;13 - clear video
	DEFW	$UNDEF		;14 - undefined
	DEFW	$UNDEF		;15 - undefined
	DEFW	$UNDEF		;16 - undefined
;
	PAGE
;
;	undefined entry
;
$UNDEF	LD	A,_ERR01	;undefined call
	OR	A		;set NZ for error
	RET			;done!
;
	PAGE
;
;	$CLRXIT - clear memory and abort to dos
;
$CLRXIT	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	SET	3,(IX+34)	;set memory protect
;
	PAGE
;
;	$ABORT - abort to dos
;
$ABORT	LD	C,@KI		;keyboard DCB #
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;locate @KI dcb
	RES	1,(IX+5)	;turn off chaining
	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	(IX+35),0	;debug OFF, no sys load
;
;	reset command pointers
;
	LD	L,(IX+58)	;get dos command buff
	LD	H,(IX+59)
	LD	(HL),_CR 	;put terminator
	LD	(IX+18),L	;set pointer
	LD	(IX+19),H
;
;	check if memory needs to be cleared
;
	BIT	3,(IX+34)	;memory protected?
	RES	3,(IX+34)	;reset mem protect
	JR	Z,$JP2DOS	;nope, exit to dos
;
;	clear system memory
;
	LD	HL,0		;reset HL
	LD	D,H		;pass to DE
	LD	E,L		;HL & DE = 0000
	LD	BC,1<8+5	;B=bank, C=command
	LD	A,@MEMCTL	;SVC #
	RST	$SVC		;fetch HI/LO memory
	JR	NZ,$JP2DOS	;go if error!
	SBC	HL,DE		;HL = mem length -1
	LD	B,H		;pass length to BC
	LD	C,L		;BC = length -1
	LD	H,D		;pass start to HL
	LD	L,E		;HL = low memory
	INC	DE		;DE = low +1
	LD	(HL),0		;load zero
	LDIR			;fill memory!
;
	PAGE
;
;	$JP2DOS - Normal DOS entry level
;
$JP2DOS	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	L,(IX+61)	;get top of stack
	LD	H,(IX+62)
	LD	SP,HL		;init stack
	XOR	A		;load zero
	SBC	HL,HL		;AHL = 0
	PUSH	HL		;return address ($EXIT)
	LD	B,H		;pass to BC
	LD	C,L		;BC & HL = 0000
	LD	A,@TIMER	;SVC #
	RST	$SVC		;user timer OFF
	LD	A,@SETBRK	;SVC #
	RST	$SVC		;break processor OFF
	LD	A,@SCROLL	;SVC #
	RST	$SVC		;turn off scroll protect
	LD	A,@HLDKEY	;SVC #
	RST	$SVC		;turn off hold processor
;
;	move debug ON to debug trigger
;
	LD	A,(IX+35)	;get debug flag
	RES	1,A		;debug trigger OFF
	LD	B,A		;save
	ADD	A,A		;shift bit 0=>1
	AND	@BIT1		;keep 1 only
	OR	B		;combine bits
	LD	(IX+35),A	;update debug flags
;
;	Fetch next available command
;
	LD	L,(IX+18)	;get interpreter pointer
	LD	H,(IX+19)
;
EXIT0	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	INC	HL		;bump pointer
	JR	NZ,EXIT0	;go till terminator
	CP	';'             ;logical term?
	LD	B,80		;maximum length
	JR	Z,$RETCMD	;execute if yes
;
;	Prompt & input command line
;
READY	PUSH	IX		;save PBLOCK
	LD	C,@KI		;keyboard DCB
	LD	A,@LOCDEV	;SVC #
	RST	$SVC		;locate DCB
	BIT	1,(IX+5)	;chaining on?
	LD	E,(IX+25)	;get prompt char
	POP	IX		;restore IX
	JR	NZ,READY1	;get input if yes
;
;	check for normal/expert modes
;
	BIT	2,(IX+34)	;expert mode?
	LD	HL,PROMPT	;normal prompt
	JR	Z,$+5		;go if normal
	LD	HL,EPROMPT	;expert mode prompt
	LD	A,@DSPLY	;SVC #
	RST	$SVC		;display prompt
;
READY1	LD	HL,$UBUFF	;system I/O buffer
	LD	B,78		;length to fetch
	LD	A,@KBLINE	;SVC #
	RST	$SVC		;call KBLINE
;
READY2	RET	C		;nil input, done!
;
;	check for nil input
;
	LD	A,B		;get input length
	OR	A		;anything?
	JR	NZ,$RETCMD	;go if user input
;
;	nil input, edit last command if any
;
	LD	L,(IX+58)	;get cmd pointer start
	LD	H,(IX+59)
	PUSH	HL		;save command start
	LD	BC,80<8+0	;B=maximum, C=length
;
READY3	LD	A,(HL)		;get a char
	CP	_CR		;terminator?
	JR	Z,READY4	;go if yes
	INC	C		;bump length
	INC	HL		;bump pointer
	DJNZ	READY3		;go for max length
	POP	HL		;restore stack
	JR	READY		;bad!
;
READY4	INC	B		;check for done
READY5	DEC	B		;B=0?
	JR	Z,READY6	;yes, go!
	LD	(HL),E		;load prompt char
	INC	HL		;bump pointer
	JR	READY5		;go for count
;
READY6	POP	HL		;get command start
	LD	A,C		;anything?
	OR	A		;B=0?
	JR	Z,READY		;yes, nothing to edit!
;
	LD	B,_VT		;vertical tab
	LD	A,@VDCHAR	;SVC #
	RST	$SVC		;cursor up
	RET	NZ		;go if error
	LD	B,C		;pass length
	LD	C,78		;set maximum length
	LD	A,@KBEDIT	;SVC #
	RST	$SVC		;edit current line
	JR	READY2		;continue
;
	PAGE
;
;	$DOSCMD - Interpret cmd & EXIT
;
$DOSCMD	PUSH	HL		;save it
	LD	HL,0000H	;return vector
	EX	(SP),HL 	;leave on stack, get HL
;
	PAGE
;
;	$RETCMD - Interpret cmd & return
;
;	ENTRY	HL =>	command line
;		B  =	command length
;
;	move command to system command buffer!
;
$RETCMD	LD	A,@DPOINT	;SVC #
	RST	$SVC		;fetch data block
	LD	E,(IX+58)	;start command buffer
	LD	D,(IX+59)
	LD	C,B		;pass length
	LD	B,0		;BC = command length
	PUSH	DE		;save pointer
	LDIR			;move to buffer
	LD	A,_CR		;carriage return
	LD	(DE),A		;terminate input
	POP	HL		;HL => command
	LD	(IX+18),L	;update pointer
	LD	(IX+19),H	;system pointer reset
;
	LD	A,@POSHL	;SVC #
	RST	$SVC		;position to input
	LD	A,0		;set no error
	RET	Z		;nil, return (Z set)
	LD	A,(HL)		;get next char
	SUB	'.'		;non-executing command?
	JR	NZ,RETCMD0	;go if not
	LD	(HL),_CR	;terminate command line
	RET			;return Z
;
RETCMD0	LD	DE,$UBUFF	;user buffer
	CALL	$FSPEC		;move spec to DCB
	INC	DE		;adjust to normal DCB
	RET	NZ		;go if error!
;
	PUSH	HL		;SAVE => cmd line
	LD	HL,LIBRARY	;library lookup table
	CALL	FIND		;library command?
	POP	HL		;GET => cmd line
	JR	NZ,GOTLIB	;have library command
;
;	Execute program file, add /CMD extension
;
	PUSH	HL		;save pointer
	LD	HL,CMD		;/CMD extension
	CALL	$FEXT		;add extension
	POP	HL		;restore string pointer
;
	LD	A,@RUN		;run program SVC #
	JP	$SVC		;execute program & return
;
;	Execute library command
;
GOTLIB	LD	DE,LOOKUP-1	;lookup table
	ADD	A,E		;add entry number
	LD	E,A		;table on a page
	JR	NC,$+3		;go if no overflow
	INC	D		;bump MSB
	LD	A,(DE)		;get the command #
	RST	$OVL		;go!
;
	PAGE
;
;	Finds string in array routine
;
;	ENT	HL =>	Table array
;		DE =>	Compare string
;
FIND	LD	B,0		;position counter
FINLP	INC	B		;bump command #
	LD	A,(HL)		;GET table
	INC	HL		;next
	OR	A		;end list?
	JP	P,FINLP+1	;til 1st byte
	AND	7FH		;END?
	RET	Z		;not found!
;
	PUSH	DE		;save string
FINLP1	LD	C,A		;C = CHAR
	LD	A,(DE)		;get string byte
	CALL	UCASE		;make upper case
	CP	C		;same?
	JR	NZ,HAVCNT	;if not
	LD	A,(HL)		;get next char
	INC	DE		;bump string
	INC	HL		;next
	JR	FINLP1		;til no match
;
HAVCNT	POP	DE		;restore string
	BIT	7,C		;end table entry?
	JR	Z,FINLP 	;if not
	CP	_ETX		;terminator?
	DEC	HL		;put pointer back
	JR	NZ,FINLP	;if yes
	LD	A,B		;get table posit
	OR	A		;set NZ flag
	RET			;done
;
	PAGE
;
;	FEXT -add default extension to filename
;
;	ENT	DE => file DCB
;		HL => extension (3 chars)
;
;	EXT	HL, DE unchanged
;		Z = no extension added (one exists)
;		NZ = extension added
;
$FEXT	LD	A,@SAVREG	;SVC #
	RST	$SVC		;save registers
	LD	C,9		;max chars to check
	EX	DE,HL		;HL => DCB
;
FEXTLP	LD	A,(HL)		;get a character
	CP	'/'             ;extension now?
	JR	Z,$RETURN	;not added
	LD	B,A		;pass char
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid character?
	JR	NZ,FEXTADD	;nope, add the extension
	INC	HL		;bump pointer
	DEC	C		;less counter
	JR	NZ,FEXTLP	;go for count
;
$RETURN	XOR	A		;not added
	RET
;
FEXTADD PUSH	DE		;save extension
	LD	BC,24		;max length of ext+term
	ADD	HL,BC		;point to end
	LD	D,H		;give to DE
	LD	E,L
	INC	DE		;add 4 for /ext
	INC	DE
	INC	DE
	INC	DE
	INC	BC		;+ terminator
	LDDR			;make a hole
	POP	HL		;get ext pointer
	INC	HL		;point to end
	INC	HL
	LD	C,3		;BC = 3
	LDDR			;move in extension
	LD	A,'/'           ;put in /
	LD	(DE),A		;do it
	OR	-1		;set NZ
	RET
;
	PAGE
;
;	$FSPEC - fetch filespec into DCB
;
;	ENT	HL => ascii string
;		DE => 40 byte DCB
;
;	EXT	HL => terminating character
;		DE => DCB (41 bytes long)
;		NZ = A = error code, HL unchanged
;		Z = OK, HL=> terminating character
;
;	DCB returned:
;	+0	7 - device field evaluated
;		6 - filespec field evaluated
;		5 - filespec has wildcard characters
;		4-0 - device number 0-15 (global default)
;
;	+1->   filename, terminated with 03H (normal DCB)
;
$FSPEC	PUSH	HL		;save string start
	PUSH	BC		;save this
	PUSH	DE		;save DCB start
;
;	Start initializing flags
;
	LD	A,1FH		;device number (nil)
	LD	(DE),A		;put it in
	INC	DE		;bump pointer to DCB
;
;	Fetch FILENAME field
;
	DEC	HL		;adjust filed
	CALL	MOVBLK8 	;move 8 bytes
	JP	NZ,CKDEV	;not a filespec
	JR	NC,MBLK1	;no wild chars
;
	EX	(SP),HL 	;get DCB first byte
	SET	5,(HL)		;set wild card bit
	EX	(SP),HL 	;put it back
;
MBLK1	EX	(SP),HL 	;get first
	SET	6,(HL)		;set contains file data
	EX	(SP),HL 	;put it back
;
;	Fetch EXTENSION field
;
	CP	'/'             ;start extension?
	JR	NZ,FSPEC1	;check password
	LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
	LD	B,3		;3 char extension
	CALL	MOVBLK-1	;move it in
	JR	NZ,FSPCER	;invalid
	JR	NC,FSPEC1	;go if no wild cards
;
	EX	(SP),HL 	;get DCB start
	SET	5,(HL)		;turn on wild bit
	EX	(SP),HL 	;put it back
;
;	Fetch PASSWORD field
;
FSPEC1	CP	'.'             ;start password
	JR	NZ,FSPEC2	;check drive
	LD	(DE),A		;put it in
	INC	DE		;bump ptr
	CALL	MOVBLK8 	;move 8 bytes
	JR	NZ,FSPCER	;invalid
	JR	C,FSPCER	;wild card chars
;
;	Fetch DRIVE field
;
FSPEC2	CP	':'             ;drive number?
	JR	NZ,FSPEC3	;check for diskname
;
;	check for wild cards & device
;
	EX	(SP),HL 	;get flags
	BIT	5,(HL)		;wild bit?
	EX	(SP),HL 	;put it back
	JR	NZ,FSPEC5	;terminate right here
	INC	HL		;restore pointer
	LD	(DE),A		;put it in
	INC	DE		;bump ptr
	CALL	FDRV		;get the device number
	JR	NZ,FSPCER1	;invalid
;
	EX	(SP),HL 	;get start of DCB
	LD	B,A		;save it
	LD	A,(HL)		;get the byte
	AND	60H		;bits 6&5 only wanted
	OR	B		;merge it
	OR	80H		;set device evaluated
	LD	(HL),A		;update
	EX	(SP),HL 	;put it back
;
	LD	B,2		;move in the 2 chars
	CALL	MOVBLK		;move it in
;
;	Fetch DISKNAME field
;
FSPEC3	CP	'('             ;diskname?
	JR	NZ,FSPEC5	;terminate field
	LD	(DE),A		;put in buffer
	INC	DE		;bump ptr
;
	EX	(SP),HL 	;get start pointer
	BIT	7,(HL)		;device specified?
	EX	(SP),HL 	;put it back
	LD	A,_ERR32	;'invalid drivespec'
	JR	Z,FSPCER1	;invalid
	CALL	MOVBLK8 	;go for 8 chars
	JR	NZ,FSPCER	;invalid
	JR	C,FSPCER	;wild card chars
	CP	')'             ;closer?
	JR	NZ,FSPCER	;invalid
	LD	(DE),A		;put in buffer
	INC	DE		;bump ptr
	INC	HL		;bump
;
;	Terminate filespec
;
FSPEC5	LD	A,_ETX		;terminator
	LD	(DE),A		;put it in
	POP	DE		;get DCB start
	POP	BC		;get this back
	POP	AF		;ignore string
	XOR	A		;set Z flag for OK
	RET			;return with Z
;
FSPCER	LD	A,_ERR19	;bad filespec
FSPCER1 POP	DE		;unstack
	POP	BC
	POP	HL		;unchanged
	OR	A		;set NZ flag
	RET			;done, A = error
;
;	Check for DEVICE specification
;
CKDEV	CP	':'             ;drive only?
	JR	Z,FSPEC2	;evaluate it
	CP	'@'             ;device specifier?
	JR	NZ,FSPCER	;go error
	LD	(DE),A		;save char
	INC	DE		;next
	INC	HL
	CALL	FDEV		;get device number
	JR	NZ,FSPCER1	;invalid
;
	EX	(SP),HL 	;get DCB start
	OR	80H		;set device evaluated
	LD	(HL),A		;put in device #
	EX	(SP),HL 	;put it back
;
	LD	B,2		;2 chars in name
	CALL	MOVBLK		;move into DCB
	JR	FSPEC5		;done
;
	PAGE
;
;	Extract field from master string
;
;	ENT	 B =	maximum field length
;		HL =>	master string
;		DE =>	field destination
;
;	EXT	 A =	terminating char
;		 Z =	field found
;		 Cy =	wild card chars
;
MOVBLK8 LD	B,8		;go for 8 chars
;
	INC	HL		;bump to next field
MOVBLK	LD	A,-1		;set error
	OR	A		;NC,NZ
	EX	AF,AF'          ;save flags
;
MOVBLK1	PUSH	BC		;save BC
	LD	B,(HL)		;get a byte
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid character?
	JR	NZ,$+3		;go if invalid
	LD	A,B		;else get char
	POP	BC		;restore stack
	JR	NZ,MOVBLK5	;invalid char
	INC	HL		;bump pointer
;
	CP	'?'             ;wild?
	JR	Z,MOVBLK2	;if yes
	CP	'!'		;wild?
	JR	Z,MOVBLK2	;yes, go!
	CP	'*'             ;wild?
	JR	NZ,MOVBLK3	;if not
;
MOVBLK2 EX	AF,AF'          ;get flags
	SCF			;have wild!
	EX	AF,AF'          ;save flags
;
MOVBLK3 LD	(DE),A		;put in buffer
	INC	DE		;bump pointer
	EX	AF,AF'          ;get flags back
	LD	A,0		;load with 0
	INC	A		;set Z, not C
	DEC	A
	EX	AF,AF'          ;save flag byte
	DJNZ	MOVBLK1 	;go more
;
MOVBLK5	EX	AF,AF'          ;get flags
	LD	A,(HL)		;get term
	RET			;tats all fowks!
;
	PAGE
;
;	$FDRV - fetch drive spec from string
;
;	ENT	HL => string (1 or 2 bytes long)
;
;	EXT	HL unchanged
;		NZ = invalid or drive not found
;		Z = A = device number
;
FDRV	CALL	FINDEV		;look for the device
	JR	NZ,FDRVBAD	;no good
	CP	7		;must be 8-15
	JR	C,FDRVBAD	;no good
	CP	A		;set Z
	RET
;
FDRVBAD LD	A,_ERR32	;invalid drivespec
	OR	A
	RET			;done, NZ
;
;	FDEV - fetch device spec from string
;
;	ENT	HL => string (1 or 2 chars)
;
;	EXT	HL unchanged
;		NZ = A = error code (invalid or not found
;		Z  = A = device number
;
FDEV	CALL	FINDEV		;look for the device
	JR	NZ,FDEVBAD	;error
	CP	8		;must be 0-7
	JR	NC,FDEVBAD	;error
	CP	A		;set Z
	RET			;done
;
FDEVBAD LD	A,_ERR68	;invalid devicespec
	OR	A
	RET			;return with NZ
;
	PAGE
;
;	Find device/drive routine
;
;	ENT	HL => string (1 or 2 chars)
;
;	EXT	HL unchanged
;		NZ = A = error code, invalid or not found
;		Z  = A = device number
;
FINDEV	PUSH	HL		;save HL
	PUSH	BC		;save BC
;
	LD	C,(HL)		;get first char
	INC	HL		;bump pointer
	LD	B,(HL)		;get second char
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;second char OK?
	JR	Z,$+4		;go if valid
	LD	B,' '		;else set blank
	LD	L,C		;set first char
	LD	H,B		;set second char
	LD	A,@LOCNAM	;SVC #
	RST	$SVC		;locate name
	JR	NZ,$+3		;go if not found
	LD	A,C		;else get device #
;
	POP	BC		;unstack
	POP	HL		;unstack
	RET			;Z = found, A = dev #
;
	PAGE
;
;	$PARAM - evaluate parameter list
;
;	ENT	HL => string to parse
;		DE => parameter list
;
;	EXT	DE is unchanged
;		Z = all parameters OK
;		NZ = A = error
;		HL => terminating/offending character
;
;	PARAMETER LIST:
;
;	A string of parameter blocks terminated with 00
;
;	PARAMETER BLOCK:
;
;	+0    - 7 - string expression can be evaluated
;		6 - value expression valid
;		5 - switch expression valid
;		4 - reserved
;		3-0 - string length-1 (1-16 chars)
;	+1,+2 - parameter data indirect address
;	+3    - string (must be upper case)
;
;	(note) table chars must be in upper case, but
;	the input string evaluated is case independent
;
;	(note) if string is found with no expression
;	true (FFFF) is assumed.  In this case,
;	the switch valid bit MUST be set or an
;	error will be generated.
;
	INC	HL		;bump pointer
PARAMB	XOR	A		;set NO error
	RET			;done, return status
;
$PARAM	LD	A,@POSHL	;SVC #
	RST	$SVC		;locate valid char
	JR	Z,PARAMB	;go if no input!
;
	CP	_LBRACE		;param starter?
	JR	NZ,PARAM0	;go if not
	INC	HL		;bump pointer if yes
;
;	Check for parameter end
;
PARAM0	LD	A,@POSHL	;SVC #
	RST	$SVC		;locate next char
	JR	Z,PARAMB	;go if nothing more
	CP	_RBRACE		;param terminator?
	JR	Z,PARAMB-1	;yes, skip past
;
	PUSH	DE		;save param block
	CALL	DOPARAM 	;execute parameter
	POP	DE		;restore stack
	RET	NZ		;param not found
	JR	PARAM0		;else get next one
;
;	Evaluate parameter
;
DOPARAM LD	A,(DE)		;get length byte
	OR	A		;0 terminator?
	JP	Z,EXPERR	;go if yes
	AND	0FH		;low 4 bits only
	INC	A		;plus 1 for length
	LD	B,A		;give here for test
	PUSH	BC		;save length
	PUSH	DE		;save pointer
	CALL	THISONE 	;this entry?
	POP	DE		;restore
	POP	BC		;get length
	JR	Z,HAVTHIS	;get params
	INC	DE		;bump past vector
	INC	DE
	INC	DE
HAVNXT	INC	DE		;bump again
	DJNZ	HAVNXT		;position to next one
	JR	DOPARAM 	;check next word
;
;	Check for any expression
;
HAVTHIS LD	BC,-1		;default value to use
	LD	A,(HL)		;get next byte
	CP	'='             ;expression following?
	JR	Z,HAVEXP	;have an expression, go!
SETPAR	LD	A,B		;ABC = switch
;
;	= found with NO expression, default NO
;
	EX	DE,HL		;get flags
	BIT	5,(HL)		;switch valid?
	EX	DE,HL		;put it back
	JR	Z,EXPERR	;expression error
	JR	PUTPAR		;continue
;
;	Place result of expression, ABC
;
	EX	AF,AF'		;get MSB back
PUTPAR	PUSH	HL		;save pointer
	PUSH	DE		;this too
	INC	DE		;point to vector
	PUSH	AF		;save MSB
	LD	A,(DE)		;get vector lsb
	LD	L,A		;put it here
	INC	DE		;point to MSB
	LD	A,(DE)		;get it
	LD	H,A		;HL => vector
	POP	AF		;get MSB
;
	LD	(HL),A		;load MSB
	INC	HL		;bump pointer
	LD	(HL),B		;load NSB
	INC	HL		;bump pointer
	LD	(HL),C		;load LSB
	POP	DE		;unstack
	POP	HL
	XOR	A		;set Z flag for OK
	RET
;
;	Check for string expression
;
HAVEXP	INC	HL		;bump string
	LD	A,(HL)		;get the byte
;
;	check for = with no input
;
	LD	BC,0		;init FALSE
	CP	' '		;separator?
	JR	Z,SETPAR	;yes, go!
	CP	','		;separator?
	JR	Z,SETPAR	;yes, go!
	CALL	CKTERM		;terminator?
	JR	Z,SETPAR	;go if yes
;
	CP	'"'             ;string?
	JR	Z,HAVSTR	;go!
	CP	27H		;' string?
	JR	Z,HAVSTR	;go!
	EX	DE,HL		;HL => param byte
	BIT	5,(HL)		;can it have switch
	EX	DE,HL		;put back
	JR	Z,EXPVAL	;no switch allowed
;
;	Evaluate logical expression
;
	PUSH	DE		;save table
	LD	DE,ONMSG-3	;on?
	LD	B,2		;2 chars
	CALL	THISONE 	;yes?
	JR	Z,HAVTRUE	;have a true
	LD	DE,OFFMSG-3	;off?
	LD	B,3
	CALL	THISONE 	;yes?
	JR	Z,HAVFAL	;have a false
	LD	DE,YESMSG-3	;yes?
	LD	B,3
	CALL	THISONE 	;yes?
	JR	Z,HAVTRUE	;have a true
	LD	DE,NOMSG-3	;no?
	LD	B,2
	CALL	THISONE 	;yes?
	JR	Z,HAVFAL	;have a false
	POP	DE		;restore it
;
;	Evaluate numeric expression
;
EXPVAL	EX	DE,HL		;get control byte
	BIT	6,(HL)		;can it have a value?
	EX	DE,HL
	JR	NZ,EXPVOK	;yes, go
EXPERR	LD	A,_ERR03	;param error
	OR	A
	RET
;
EXPVOK	PUSH	DE		;save DE
	LD	A,@VALUE	;SVC #
	RST	$SVC		;fetch value
	JR	NZ,$+3		;go if error
	LD	A,C		;get MSB
	LD	B,D		;get NSB
	LD	C,E		;get LSB
	POP	DE		;restore DE
;
	RET	NZ		;error
	JP	PUTPAR		;insert value
;
;	Evaluate string expression
;
HAVSTR	EX	DE,HL		;exchange
	BIT	7,(HL)		;string OK
	EX	DE,HL
	JR	Z,EXPERR	;expression error
	LD	C,H		;BC => string vector
	LD	B,L
	INC	HL		;bump pointer
	XOR	A		;init length
;
HAVSLP	EX	AF,AF'		;save length
	LD	A,(HL)		;get a char
	CALL	CKTERM		;terminator?
	JP	Z,PUTPAR-1	;put parameter
	INC	HL		;bump pointer
	CP	'"'             ;terminator?
	JP	Z,PUTPAR-1	;go if yes
	CP	27H		;terminator?
	JP	Z,PUTPAR-1	;go!
	EX	AF,AF'		;get count back
	INC	A		;bump it
	JR	HAVSLP		;go till found
;
HAVFAL	LD	BC,0		;0 = false
	POP	DE		;restore stack
	LD	A,B		;ABC = value
	JP	PUTPAR		;put in table
;
HAVTRUE LD	BC,-1		;-1 = true
	JR	HAVFAL+3	;save a byte
;
;	Scan field for match
;
THISONE PUSH	HL		;save string pointer
	INC	DE		;bump to string
	INC	DE		;past vector
	INC	DE
	XOR	A		;init count
	EX	AF,AF'          ;save it here
THISLP	LD	A,(HL)		;get a byte
	CALL	UCASE		;make upper case
	LD	C,A		;save it here
	LD	A,(DE)		;get param byte
	CP	C		;same?
	JR	NZ,THISNOT	;nope
	INC	HL		;bump pointers
	INC	DE		;this too
	EX	AF,AF'          ;get flag byte
	INC	A		;bump match count
	EX	AF,AF'          ;put it back
	DJNZ	THISLP		;do whole thing
	EX	(SP),HL 	;replace new HL
	POP	HL		;unstack
	EX	AF,AF'          ;get counter back
	CP	A		;set Z
	RET
;
THISNOT EX	AF,AF'          ;get flag
	DEC	A		;1 byte matched?
	JR	NZ,THISBAD	;not valid, original HL
	PUSH	BC		;save BC
	LD	B,(HL)		;get last byte
	LD	A,@VALCHR	;SVC #
	RST	$SVC		;valid character?
	POP	BC		;restore
	JR	Z,THISBAD	;valid char!
	EX	(SP),HL 	;else put this one
	POP	HL		;unstack
	LD	A,1		;set 1 byte match
	CP	A		;set Z
	RET			;done, Z = OK
;
THISBAD POP	HL		;unstack
	OR	-1		;NZ
	RET
;
	PAGE
;
;	$EVAL - evaluate source,dest,mask,params
;
;	ENT  :	IX => parameter block
;		HL => string to evaluate
;
;	EXT :	HL => terminating/offending character
;		DE => param address for PARAM (if Z set)
;		Z  = evaluation OK
;		NZ = A = error code (DE MAY be unchanged)
;		if Z, parameter blocks are loaded
;
;	PARAMETER BLOCK:
;
;	+0    - work byte for flag use
;	+1,+2 - source DCB pointer (41 bytes)
;	+3,+4 - dest DCB pointer (41 bytes)
;	+5,+6 - mask DCB pointer (41 bytes)
;	+7,+8 - parameter list address for PARAM
;
;	On exit, IX+0:
;	bit 4 = 1 = param field found
;	bit 3 = 1 = I/O field found
;	bit 2 = 1 = source field filled
;	bit 1 = 1 = dest field filled
;	bit 0 = 1 = mask field filled
;
$EVAL	LD	(IX+0),0	;reset flags
	LD	A,@POSHL	;SVC #
	RST	$SVC		;any input?
	LD	A,0		;set no error
	RET	Z		;nothing!
	PUSH	BC		;save
	SET	3,(IX+0)	;set data found
;
EVALLP	LD	A,(IX+0)	;get the flag
	AND	0FH		;low 4 bits only
	LD	(IX+0),A	;re-save
;
;	Check for PARAM field
;
EVAL0	LD	A,(HL)		;get a byte
	CP	','             ;param field broken?
	JR	Z,EVALP 	;go param
	CP	_LBRACE		;param field?
	JR	Z,EVALP 	;go param
;
;	Check for field end
;
	CALL	CKTERM		;terminator
	JR	Z,EVALRET	;done
;
;	Check for field tabs
;
	INC	HL		;bump pointer
	CP	' '		;separator?
	JR	Z,EVAL0 	;go if yes
	DEC	HL		;less 1
;
;	TO field specifier?
;
	LD	DE,TOMSG-3	;to?
	LD	B,2
	CALL	THISONE 	;yes?
	JR	NZ,CKFROM	;no, go
	DEC	A		;one char match?
	JR	Z,CKFROM-1	;skip if yes
	SET	6,(IX+0)	;set TO flag
	JR	EVAL0		;position to next one
;
EVALERR LD	A,_ERR03	;parameter error
	OR	A		;set NZ
;
;	Exit EVAL routine here
;
EVALRET POP	BC
	RET	NZ
	XOR	A
	RET
;
;	Evaluate PARAM field
;
EVALP	POP	BC		;unstack
	LD	E,(IX+7)	;get parameter block
	LD	D,(IX+8)
	SET	4,(IX+0)	;set param found
	JP	$PARAM		;go param
;
;	FROM field specifier?
;
	DEC	HL		;reset pointer
CKFROM	LD	DE,FROMMSG-3	;from?
	LD	B,4		;length
	CALL	THISONE
	JR	NZ,CKUSE	;check using
	DEC	A		;one char match only?
	JR	Z,CKUSE-1	;backspace & ignore
	SET	7,(IX+0)	;set FROM flag
	JR	EVAL0		;go next word
;
;	USING field specifier?
;
	DEC	HL		;backspace pointer
CKUSE	LD	DE,USEMSG-3	;using?
	LD	B,5
	CALL	THISONE
	JR	NZ,CKNXT	;no, go
	DEC	A		;one char only?
	JR	Z,CKNXT-1	;ignore if yes
	SET	5,(IX+0)	;set from
	JR	EVAL0		;go next word
;
;	Fetch field here
;
	DEC	HL		;backspace
CKNXT	LD	DE,$UBUFF	;work area
	CALL	$FSPEC		;evaluate device
	JR	NZ,EVALRET	;invalid spec
	LD	A,(DE)		;get type byte
	BIT	5,A		;wild cards?
	JR	NZ,CHKMASK	;wild, force MASK
	LD	A,(IX+0)	;get the byte
	AND	0E0H		;to from using?
	JR	NZ,EVALC	;go if yes
	LD	A,(IX+0)	;get again
	CPL			;reverse the bits
	RRCA
	RRCA			;align to high bits
	RRCA
;
EVALC	RLCA			;check bit 7
	JR	C,FILSRC	;go source
	RLCA
	JR	C,FILDES
	JR	FILMASK 	;go fill mask
;
CHKMASK LD	A,(IX+0)	;see if TO FROM ?
	AND	0C0H		;yes?
	JR	NZ,EVALERR	;error if yes
;
;	Fill MASK field
;
FILMASK BIT	0,(IX+0)	;mask filled?
	JR	NZ,EVALERR	;return if yes
	LD	C,(IX+5)	;else fill mask
	LD	B,(IX+6)
	SET	0,(IX+0)	;set filled
	JR	EVALFIL 	;fill the buffer
;
;	Fill SOURCE field
;
FILSRC	BIT	2,(IX+0)	;source filled?
	JR	NZ,EVALERR	;yes, return
	LD	C,(IX+1)	;get source addr
	LD	B,(IX+2)
	SET	2,(IX+0)	;set filled
	JR	EVALFIL 	;fill it
;
;	Fill DESTINATION field
;
FILDES	BIT	1,(IX+0)	;dest filled?
	JP	NZ,EVALERR	;yes, return
	LD	C,(IX+3)	;get addr
	LD	B,(IX+4)
	SET	1,(IX+0)	;set filled
;
;	Fill GENERAL field
;
EVALFIL PUSH	HL		;save it
	EX	DE,HL		;HL => DCB
	LD	D,B		;load DE with BC
	LD	E,C
	LD	BC,41		;length
	LDIR			;move to correct area
	POP	HL		;get string back
	JP	EVALLP		;get next char
;
;	Check for terminator character
;
CKTERM	CP	_CR		;carriage return?
	RET	Z		;go if yes
	CP	_ETX		;end of text?
	RET	Z		;yes, go!
	CP	_ECR		;embedded CR?
	RET	Z		;yes, go!
	CP	_RBRACE		;right brace?
	RET			;Z = yes
;
	PAGE
;
;	$LIB - library command
;
$LIB	LD	HL,LIBRARY	;library command table
	XOR	A		;set NO error
	RET			;back to caller
;
	PAGE
;
;	$CLS	- clear video screen
;
$CLS	LD	B,_ESC		;clear screen code
	LD	A,@VDCHAR	;SVC #
	RST	$SVC		;clear screen
	XOR	A		;force ZERO return
	RET			;done, Z = result
;
	PAGE
;
;	$BOOT	- cold reset the system
;
$BOOT	LD	A,@BOOT		;SVC #
	RST	$SVC		;hardware reset
;
;	convert char in A to upper case
;
UCASE	CP	'a'		;in range?
	RET	C		;go if not
	CP	'z'+1		;in range?
	RET	NC		;go if not
	AND	5FH		;make upper case
	RET			;done
;
	PAGE
;
;	Messages and text strings
;
PROMPT	DEFB	_CR		;next line
	DEFB	_ETB		;clear line
	DEFM	'PowerDOS Ready'
	DEFB	_CR		;next line
	DEFB	_ETB		;clear line
	DEFB	_ETX		;end text
;
EPROMPT	DEFB	_CR		;carriage return
	DEFB	_ETB		;clear line
	DEFM	'.'		;expert prompt
	DEFB	_ETX		;end text
;
FROMMSG DEFM	'FROM'
USEMSG	DEFM	'USING'
CMD	DEFM	'CMD'
YESMSG	DEFM	'YES'
TOMSG	DEFM	'T'
ONMSG	DEFM	'ON'
NOMSG	EQU	$-1
OFFMSG	DEFM	'OFF'
;
	PAGE
;
;	Library command lookup table
;	Each byte is a RST 30H command
;
LOOKUP	DEFB	_SYS10+_CMD03	;append
	DEFB	_SYS14+_CMD03	;attrib
	DEFB	_SYS12+_CMD08	;auto
	DEFB	_SYS10+_CMD06	;backup
	DEFB	_SYS01+_CMD07	;boot
	DEFB	_SYS15+_CMD05	;build
	DEFB	_SYS15+_CMD02	;clear
	DEFB	_SYS01+_CMD13	;cls
	DEFB	_SYS16+_CMD03	;config
	DEFB	_SYS10+_CMD02	;copy
	DEFB	_SYS15+_CMD03	;create
	DEFB	_SYS12+_CMD07	;date
	DEFB	_SYS12+_CMD06	;debug
	DEFB	_SYS09+_CMD02	;dir
	DEFB	_SYS13+_CMD03	;do
	DEFB	_SYS15+_CMD04	;dump
	DEFB	_SYS12+_CMD05	;error
	DEFB	_SYS11+_CMD06	;filter
	DEFB	_SYS13+_CMD04	;forms
	DEFB	_SYS09+_CMD03	;free
	DEFB	_SYS12+_CMD04	;i
	DEFB	_SYS14+_CMD04	;kill
	DEFB	_SYS11+_CMD08	;ksm
	DEFB	_SYS12+_CMD11	;lib
	DEFB	_SYS11+_CMD05	;link
	DEFB	_SYS10+_CMD04	;list
	DEFB	_SYS15+_CMD06	;load
	DEFB	_SYS09+_CMD03	;map
	DEFB	_SYS11+_CMD07	;memory
	DEFB	_SYS10+_CMD05	;move
	DEFB	_SYS12+_CMD09	;pause
	DEFB	_SYS14+_CMD02	;prot
	DEFB	_SYS13+_CMD06	;receive
	DEFB	_SYS15+_CMD07	;rename
	DEFB	_SYS11+_CMD03	;reset
	DEFB	_SYS11+_CMD02	;route
	DEFB	_SYS12+_CMD10	;screen
	DEFB	_SYS13+_CMD05	;send
	DEFB	_SYS11+_CMD04	;set
	DEFB	_SYS13+_CMD02	;setcom
	DEFB	_SYS16+_CMD02	;system
	DEFB	_SYS12+_CMD03	;time
	DEFB	_SYS12+_CMD02	;verify
;
	PAGE
;
;	Table of library words
;
LIBRARY DEFB	'A'+80H         ;append
	DEFM	'PPEND'
	DEFB	'A'+80H         ;attrib
	DEFM	'TTRIB'
	DEFB	'A'+80H         ;auto
	DEFM	'UTO'
	DEFB	'B'+80H		;backup
	DEFM	'ACKUP'
	DEFB	'B'+80H         ;boot
	DEFM	'OOT'
	DEFB	'B'+80H         ;build
	DEFM	'UILD'
	DEFB	'C'+80H         ;clear
	DEFM	'LEAR'
	DEFB	'C'+80H         ;cls
	DEFM	'LS'
	DEFB	'C'+80H         ;config
	DEFM	'ONFIG'
	DEFB	'C'+80H         ;copy
	DEFM	'OPY'
	DEFB	'C'+80H         ;create
	DEFM	'REATE'
	DEFB	'D'+80H         ;date
	DEFM	'ATE'
	DEFB	'D'+80H         ;debug
	DEFM	'EBUG'
	DEFB	'D'+80H         ;dir
	DEFM	'IR'
	DEFB	'D'+80H         ;do
	DEFM	'O'
	DEFB	'D'+80H         ;dump
	DEFM	'UMP'
	DEFB	'E'+80H         ;error
	DEFM	'RROR'
	DEFB	'F'+80H         ;filter
	DEFM	'ILTER'
	DEFB	'F'+80H         ;forms
	DEFM	'ORMS'
	DEFB	'F'+80H         ;free
	DEFM	'REE'
	DEFB	'I'+80H         ;i
	DEFB	'K'+80H         ;kill
	DEFM	'ILL'
	DEFB	'K'+80H		;ksm
	DEFM	'SM'
	DEFB	'L'+80H         ;lib
	DEFM	'IB'
	DEFB	'L'+80H         ;link
	DEFM	'INK'
	DEFB	'L'+80H         ;list
	DEFM	'IST'
	DEFB	'L'+80H         ;load
	DEFM	'OAD'
	DEFB	'M'+80H		;map
	DEFM	'AP'
	DEFB	'M'+80H		;memory
	DEFM	'EMORY'
	DEFB	'M'+80H		;move
	DEFM	'OVE'
	DEFB	'P'+80H         ;pause
	DEFM	'AUSE'
	DEFB	'P'+80H         ;prot
	DEFM	'ROT'
	DEFB	'R'+80H		;receive
	DEFM	'ECEIVE'
	DEFB	'R'+80H         ;rename
	DEFM	'ENAME'
	DEFB	'R'+80H         ;reset
	DEFM	'ESET'
	DEFB	'R'+80H         ;route
	DEFM	'OUTE'
	DEFB	'S'+80H         ;screen
	DEFM	'CREEN'
	DEFB	'S'+80H		;send
	DEFM	'END'
	DEFB	'S'+80H         ;set
	DEFM	'ET'
	DEFB	'S'+80H         ;setcom
	DEFM	'ETCOM'
	DEFB	'S'+80H         ;system
	DEFM	'YSTEM'
	DEFB	'T'+80H         ;time
	DEFM	'IME'
	DEFB	'V'+80H         ;verify
	DEFM	'ERIFY'
	DEFB	80H		;terminator
;
_______	EQU	$
;
	END	VECTORS
