; sys0svcm/asm - rbr/bqsd - 05/06/83
;
;	created 05/06/83	- rbr/bqsd
;	revised 05/19/83	- kjw
;
	PAGE
;
;	$$MEMCTL - SVC 65 - Memory Control & Management
;
;	Entry:	B  = Bank Number (0 - 15)
;		C  = Command
;			0 = Select bank
;			    If bit 7 of B set, then HL =
;			    entry addr. in selected bank
;			1 = Unmark (reset) bank
;			2 = Test bank marked
;			3 = Mark (set) bank
;			4 = Select video memory
;			5 = Fetch/Set bank memory ptrs.
;			    HL = HIGH$, DE = LOW$
;			6 = Allocate high memory
;			    DE = number of bytes needed
;			7 = Reclaim memory
;			    HL = value returned when C=6
;			    DE = # bytes requested
;			8 = Fetch current memory bank
;
$$MEMCTL
	LD	A,C		;get command
	OR	A		;0?
	JR	Z,MEMCTL0	;go if yes
	DEC	A		;1?
	JR	Z,MEMCTL1
	DEC	A
	JR	Z,MEMCTL2
	DEC	A
	JR	Z,MEMCTL3
	DEC	A
	JR	Z,MEMCTL4
	DEC	A
	JR	Z,MEMCTL5
	DEC	A
	JP	Z,MEMCTL6
	DEC	A
	JP	Z,MEMCTL7
	DEC	A
	JP	Z,MEMCTL8
;
;	invalid command!
;
	LD	A,_ERR06	;invalid SVC data
	OR	A		;set NZ
	RET			;return in error!
;
	PAGE
;
;	$MEMCTL0 - mark bank and enable
;
;	ENTRY	B  =	bank number (0-15)
;		HL =	vector address if bit 7 B set
;
;	EXIT	Z  =	OK, bank selected
;		NZ =	A = error code (not available)
;
MEMCTL0	LD	A,B		;get bank #
	AND	@BIT7.XOR.-1	;reset command bit
	CALL	VALBANK		;valid bank #
	RET	NZ		;bank not available!
;
;	check that (SP) and SP below 8000H
;
	EXX			;swap registers
	LD	DE,8000H	;(SP) and SP below!
	CALL	MRANGE		;in valid range?
	CALL	MEMCTL3		;set bank as marked!
	LD	A,B		;get bank #
	AND	@BIT7.XOR.-1	;strip command bit
	LD	C,A		;save bank #
	LD	A,($VMASK)	;get bank select mask
	AND	11110000B	;drop bank #
	OR	C		;set new bank #
	LD	($VMASK),A	;set new mask #
	OUT	($LBANK),A	;load bank register
	XOR	A		;set NO error
	BIT	7,B		;execute bank?
	RET	Z		;nope, go!
	XOR	A		;set Z again
	JP	(HL)		;go vector!
;
	PAGE
;
;	$MEMCTL1 - unmark requested bank
;
;	ENTRY	B  =	bank #
;
;	EXIT	NZ =	A = error code (not available)
;		Z  =	A=0, bank unmarked and available
;
MEMCTL1	LD	A,B		;get bank #
	OR	A		;unmark bank 0?
	JR	Z,MEMCT1A	;cannot unmark 0!
	CALL	VALBANK		;test for valid #
	RET	NZ		;go if not
;
	CALL	UMARK		;unmark bank!
	XOR	A		;set NO error
	RET			;done!
;
MEMCT1A	LD	A,_ERR94	;'protected bank'
	OR	A		;set NZ
	RET			;done!
;
	PAGE
;
;	$MEMCTL2 - test if bank marked
;
;	ENTRY	B  =	bank #
;
;	EXIT	Z  =	bank available and not marked
;		NZ =	A = error code (not available)
;
MEMCTL2	LD	A,B		;get bank #
	CALL	VALBANK		;bank available?
	RET	NZ		;nope, exit!
;
	CALL	MTEST		;test bank marked
	RET	Z		;bank free, return Z
	LD	A,_ERR94	;'protected bank'
	RET			;done!
;
	PAGE
;
;	$MEMCTL3 - mark bank
;
;	ENTRY	B  =	bank #
;
;	EXIT	Z  =	OK, bank reserved for use
;		NZ =	A = error code (bank in use)
;
MEMCTL3	CALL	MEMCTL2		;available and not marked
	RET	NZ		;nope, cannot use!
;
	CALL	BMARK		;mark bank as used
	XOR	A		;set NO error
	RET			;bank now reserved!
;
	PAGE
;
;	$VSEL - enable video memory
;
;	ENTRY	B  =	0 = select video
;		B <>	0 = de-select video
;
;	EXIT	Z  =	OK, video selected
;		NZ =	cannot select video!
;
;	check that (SP) and PC are below F800H
;
MEMCTL4	EXX			;swap registers
	LD	DE,$VIDEO	;must be below
	CALL	MRANGE		;PC and SP in range?
;
	LD	A,B		;command into A
	OR	A		;select or deselect?
	JR	NZ,$VDSEL	;deselect - go
;
;	enable video memory
;
$VSEL	LD	A,($VMASK)	;get video mask
	OR	@BIT7		;set video bit
	JR	VDCTL		;go common
;
;	disable video memory
;
$VDSEL	LD	A,($VMASK)	;get video mask
	AND	@BIT7.XOR.-1	;reset bit 7
;
VDCTL	LD	($VMASK),A	;update mask
	OUT	($LBANK),A	;select bank
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$MEMCTL5 - fetch/load memory pointers
;
;	ENTRY	B  =	bank # (0-15)
;		HL =	high memory (=0000=fetch)
;		DE =	low  memory (=0000=fetch)
;
;	EXIT	HL =	high memory in bank
;		DE =	low memory in bank
;		BC =	physical memory in bank
;
MEMCTL5	LD	A,B		;get bank #
	CALL	VALBANK		;valid bank #?
	RET	NZ		;nope, abort!
;
	PUSH	IX		;save IX
	LD	A,($FLAG1)	;get system flag
	AND	@BIT6		;bank table loaded?
	LD	IX,$LOMEM	;start normal bank table
	JR	Z,NBANK		;go normal bank table
;
;	locate bank table in high memory
;
	PUSH	BC		;save BC
	LD	C,B		;C = bank #
	LD	B,0		;BC = bank #
	PUSH	BC		;pass to IX
	POP	IX		;IX = bank #
	ADD	IX,IX		;*2
	ADD	IX,BC		;*3
	ADD	IX,IX		;*6
	LD	BC,($HIMEM)	;get table pointer
	ADD	IX,BC		;IX => table
	POP	BC		;restore BC
;
;	IX => bank table
;		+0/1	= low memory
;		+2/3	= high memory
;		+4/5	= physical memory
;
NBANK	LD	A,H		;check for high set
	OR	L		;HL = 0000?
	JR	Z,NBANK1	;yes, fetch high memory
;
	LD	(IX+2),L	;set high memory
	LD	(IX+3),H	;new high memory set
;
NBANK1	LD	L,(IX+2)	;get high memory
	LD	H,(IX+3)
;
	LD	A,D		;check for low set
	OR	E		;DE = 0000?
	JR	Z,NBANK2	;yes, fetch low memory
;
	LD	(IX+0),E	;set low memory
	LD	(IX+1),D	;new low memory set
;
NBANK2	LD	E,(IX+0)	;get low memory
	LD	D,(IX+1)
	LD	C,(IX+4)	;get phys memory
	LD	B,(IX+5)	;BC = phys memory
	XOR	A		;set NO error
	RET			;return with values
;
	PAGE
;
;	$MEMCTL6 - allocate high memory
;
;	ENTRY	B  =	bank # (0-15)
;		DE =	# bytes requested in bank
;
;	EXIT	NZ =	A = error code (insufficient)
;		Z  =	OK, A=0, HL = first free address
;
MEMCTL6	LD	A,B		;get bank #
	CALL	VALBANK		;bank available?
	RET	NZ		;nope, go!
;
	PUSH	BC		;save bank #
	PUSH	DE		;save length needed
	LD	H,0		;init highmem
	LD	L,H		;HL = 0000
	LD	D,H		;init lowmem
	LD	E,L		;DE = 0000
	CALL	MEMCTL5		;fetch pointers
;
	LD	B,H		;save top memory
	LD	C,L		;BC = current top
	OR	A		;clear carry
	SBC	HL,DE		;HL = free memory
	POP	DE		;get count
	JR	C,INMEM		;insufficient memory!
	SBC	HL,DE		;check for enough room
	JR	C,INMEM		;insufficient memory
;
	LD	H,B		;get old top back
	LD	L,C		;HL = topmem
	POP	BC		;restore bank #
	SBC	HL,DE		;HL = new topmem
	PUSH	DE		;save byte count
	LD	DE,0		;init lowmem
	PUSH	BC		;save bank #
	CALL	MEMCTL5		;set new highmem
	POP	BC		;restore bank #
	POP	DE		;restore byte count
	INC	HL		;HL => user address
	XOR	A		;set NO error
	RET			;return OK
;
INMEM	POP	BC		;restore bank #
	LD	A,_ERR82	;'insufficient memory'
	OR	A		;set NZ
	RET			;return in error
;
	PAGE
;
;	$MEMCTL7 - reclaim memory
;
;	ENTRY	HL =	address of current highmem
;		DE =	byte count to reclaim
;
;	EXIT	Z  =	memory reclaimed (HIMEM) = HL-1
;		NZ =	cannot reclaim block
;
MEMCTL7	LD	A,B		;get bank #
	CALL	VALBANK		;bank available?
	RET	NZ		;nope, go!
;
	CALL	$$SAVREG	;save registers
	PUSH	DE		;save length
	PUSH	HL		;save start
;
;	fetch current pointers
;
	LD	H,0		;init highmem
	LD	L,H		;HL = 0000
	LD	D,H		;init lowmem
	LD	E,L		;DE = 0000
	PUSH	BC		;save bank #
	CALL	MEMCTL5		;fetch pointers
	POP	BC		;restore bank #
	EX	DE,HL		;DE = highmemory
	POP	HL		;get user highmem
	DEC	HL		;must be (HIMEM)-1
	OR	A		;clear carry
	SBC	HL,DE		;unchanged?
	POP	HL		;get length
	LD	A,_ERR88	;'function not avail'
	RET	NZ		;cannot alter!
;
	ADD	HL,DE		;HL = new highmem
	LD	DE,0		;init lowmem
	JP	MEMCTL5		;set new pointers
;
	PAGE
;
;	$MEMCTL8 - fetch currently selected bank
;
;	ENTRY	none
;
;	EXIT	B  = currently selected bank
;
MEMCTL8	LD	A,($VMASK)	;get current  mask
	AND	0FH		;get bank number
	LD	B,A		;pass to B
	XOR	A		;set NO error
	RET			;return bank #
;
;	bank mark/unmark/test
;
;	$BSETUP - setup for bank activity
;
;	ENTRY	B  =	bank number
;		HL =>	bank flags
;
;	EXIT	HL =>	bank number flag
;		B  =	bank reset bits
;		C  =	bank set bit
;
BSETUP	RES	7,B		;set bank in range
	INC	B		;setup for test
BSCONT	LD	C,@BIT0		;init test bit
;
BSLOOP	DEC	B		;less bank #
	JR	Z,BSFND		;found, go!
	SLA	C		;shift test bit
	JR	NZ,BSLOOP	;go till 00
	DEC	HL		;bank byte left
	JR	BSCONT		;continue
;
BSFND	LD	A,C		;get set bit
	CPL			;reverse bits
	LD	B,A		;B = reset bits
	RET			;done!
;
;	$ATEST - test if bank available
;
;	ENTRY	B  =	bank number
;
;	EXIT	Z  =	no, bank NOT available
;		NZ =	yes, bank available
;
ATEST	PUSH	HL		;save
	LD	HL,$BANKA	;available banks
	JR	AMTEST		;go common
;
;	$MTEST - test if bank marked
;
;	ENTRY	B  =	bank number
;
;	EXIT	Z  =	yes, A=0, bank NOT marked
;		NZ =	bank marked, A=-1
;
MTEST	PUSH	HL		;save
	LD	HL,$BANKM	;marked banks flag
;
AMTEST	PUSH	BC		;save
	CALL	BSETUP		;setup for test
	LD	A,(HL)		;get flag
	AND	C		;marked?
	POP	BC		;unstack
	POP	HL
	RET			;Z=not marked
;
;	$BMARK - set bank as marked
;
BMARK	CALL	BUSET		;setup for change
	OR	B		;mark bank
	JR	MUCOMM		;continue
;
;	$UMARK - set bank as unmarked
;
UMARK	CALL	BUSET		;setup
	AND	C		;unmark it
;
MUCOMM	LD	(HL),A		;update
	POP	BC		;unstack
	POP	HL		;unstack
	RET			;done
;
BUSET	POP	AF		;get caller
	PUSH	HL		;save registers
	PUSH	BC
	PUSH	AF		;restore caller
	LD	HL,$BANKM	;marked bank flags
	CALL	BSETUP		;setup bank #
	LD	A,(HL)		;get flags
	RET			;done!
;
;	$VALBANK - test if valid bank number issued
;
VALBANK	OR	A		;bank 0?
	JR	Z,NOTBANK	;non-existent!
	CP	@BANKS		;in range? (0-15)
	JR	NC,INVBANK	;nope, abort!
	CALL	ATEST		;test if available
	JR	Z,NOTBANK	;bank not available!
	XOR	A		;set OK
	RET			;done!
;
NOTBANK	LD	A,_ERR93	;'bank non-existant'
	OR	A		;set NZ
	RET			;return in error
;
INVBANK	LD	A,_ERR06	;invalid data
	OR	A		;set NZ
	RET			;return in error
;
;	$MRANGE - test if (SP) and SP > DE
;
MRANGE	POP	BC		;remove caller address
	EX	(SP),HL		;get return vector
	OR	A		;clear carry
	SBC	HL,DE		;(SP) > DE?
	EX	(SP),HL		;put it back!
	JR	NC,OUTRANG	;out of range!
;
	LD	HL,0		;init zero
	ADD	HL,SP		;HL = stack
	OR	A		;clear carry flag
	SBC	HL,DE		;SP > DE?
	JR	NC,OUTRANG	;out of range!
;
;	(SP) and SP in range, ok to execute
;
	PUSH	BC		;return address back
	EXX			;swap registers back
	RET			;done!
;
;	requested call has pointers out of range!
;
OUTRANG	LD	A,_ERR10	;caller out of range!
	OR	A		;set NZ
	EXX			;swap registers back
	RET			;return one level above
;
