;sys0svcl/asm - 05/04/83 - kjw/bqsd
;
; created 05/04/83	- kjw/bqsd
; revised 05/04/83	- dwh
; revised 05/23/83	- kjw
;
	PAGE
;
;	$VDLINE - SVC 9 - send line to video
;	$PRLINE - SVC 19 - send line to printer
;
;	ENTRY	B  =	buffer length
;		C  =	term character
;		HL =>	ASCII text
;
;	EXIT	Z  =	ok
;
$$PRLINE
	LD	A,@PR 		;printer device
	JR	DVLIN0		;skip
;
$$VDLINE
	LD	A,@DO	 	;display device
;
DVLIN0	EX	AF,AF'		;save DCB #
	CALL	$$SAVREG	;save registers
	EX	AF,AF'		;get DCB # back
	CALL	$$LOCDEV+1	;locate DCB
	PUSH	IX
	POP	DE		;DE => DCB
	INC	B
	DEC	B		;null?
	JR	Z,DVLIN2	;skip
;
DVLIN1	PUSH	BC		;save count
	LD	B,(HL)		;get char
	CALL	$$PUT		;output
	POP	BC		;get count
	RET	NZ		;if error
	INC	HL		;next
	DJNZ	DVLIN1		;till done
;
DVLIN2	XOR	A		;prepare no error exit
	INC	C
	DEC	C		;any term?
	LD	B,C		;get term
	JP	NZ,$$PUT	;if yes
	RET
;
	PAGE
;
;	$DSPLY - SVC 14 - send message to display
;	$PRINT - SVC 16 - send message to printer
;
;	ENTRY	HL =>	ASCII text followed by ETX
;
;	EXIT	Z  =	ok
;
$$DSPLY	LD	A,@DO		;display device
	JR	DVLIN3
;
$$PRINT	LD	A,@PR		;print device
;
DVLIN3	EX	AF,AF'		;save device #
	CALL	$$SAVREG	;save registers
	EX	AF,AF'		;restore device #
	CALL	$$LOCDEV+1	;locate DCB
	PUSH	IX
	POP	DE		;DE => DCB
;
DVLIN4	LD	A,(HL)		;get one char
	LD	B,A		;pass char to B
	SUB	_ETX		;last character?
	RET	Z		;done
	CALL	$$PUT		;send it
	RET	NZ		;error
	INC	HL		;next char
	JR	DVLIN4		;again
;
	PAGE
;
;	$MSG - SVC 114 - send message to device
;
;	ENTRY	DE =>	DCB
;
;	EXIT	Z  =	ok
;
$$MSG	CALL	$$SAVREG	;save registers
	JR	DVLIN4		;continue
;
