; sys0svc1/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 06/01/83	- kjw
;
;	system SVC file #1
;
	PAGE
;
;	$SAVREG - SVC 104 - preserve primary registers
;
;	ENTRY	none
;
;	EXIT	AF destroyed
;		BC,DE,HL,IX,IY preserved on stack
;		unstacker vector left on stack
;
$$SAVREG
	POP	AF		;get caller address
	PUSH	IY		;save registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
;
;	setup stack for unstacker return
;
	PUSH	HL		;save
	LD	HL,GETREG	;unstacker
	EX	(SP),HL		;get HL, leave on stack
	PUSH	AF		;restore caller address
	RET			;done!
;
GETREG	POP	BC		;unstack registers
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;return with AF status
;
	PAGE
;
;	$NMICTL - SVC 92 - add/remove RTC interrupt tasks
;
;	ENTRY	B  =	set/reset flag (0=reset/1=set)
;		C  =	slot number 0-7
;		DE =>	user subroutine
;
;	EXIT	Z  =	OK, task added
;		NZ =	A = error code
;
$$NMICTL
	CALL	$$SAVREG	;save registers
	INC	B		;check if B=0
	DEC	B		;yes?
	JR	NZ,$+5		;go if ADD
RESNMI	LD	DE,$NOTASK	;else REMOVE (nil vector)
;
	LD	A,C		;get slot #
	CP	@SLOTS		;in range?
	JR	NC,NMIBAD	;nope, error!
;
	LD	HL,$RTCTBL	;real time clock table
	ADD	A,A		;*2
	ADD	A,L		;offset in table
	LD	L,A		;HL => task slot
	CALL	$$NMIOFF	;disable RTC/video
	LD	(HL),E		;load LSB vector
	INC	L		;bump table
	LD	(HL),D		;load MSB vector
	CALL	$$NMION		;enable RTC/video
	XOR	A		;return Z/NC
	RET			;done!
;
NMIBAD	LD	A,_ERR06	;'invalid SVC data'
	OR	A		;set NZ/NC
	RET			;return in error
;
	PAGE
;
;	$SCROLL - SVC 27 - scroll protect video
;
;	ENTRY	B  =	# lines to protect (0-22)
;
;	EXIT	Z  =	OK, setup
;		NZ =	A = error code
;
$$SCROLL
	CALL	$$SAVREG	;save registers
	LD	A,@DO		;display DCB #
	CALL	$$LOCDEV+1	;locate DCB block
	LD	A,(IX+09)	;get # video rows
	SUB	2		;adjust for compare
	CP	B		;in range?
	JR	NC,GOSCRL	;yes, continue!
;
	LD	A,_ERR06	;'invalid SVC data'
	OR	A		;set NZ/NC
	RET			;return in error
;
GOSCRL	LD	L,(IX+08)	;get # columns
	LD	H,0		;HL = length
	LD	C,B		;get scroll line
	LD	B,H		;BHL=len, C=columns
	CALL	$$MULT		;ABHL = result
	LD	DE,$VIDEO	;start video memory
	ADD	HL,DE		;HL = top scroll line
	LD	(IX+12),L	;update start scroll area
	LD	(IX+13),H
;
;	determine new scroll count
;
	LD	E,(IX+14)	;get end scroll area
	LD	D,(IX+15)
	EX	DE,HL		;HL=end, DE=start
	OR	A		;clear carry
	SBC	HL,DE		;HL = video scroll length
	LD	E,(IX+08)	;get # cols
	LD	D,0		;DE = # cols
	OR	A		;clear carry
	SBC	HL,DE		;HL = scroll count
	LD	(IX+16),L	;update DCT
	LD	(IX+17),H
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$CURSOR - SVC 26 - set cursor controls
;
;	ENTRY	B  =	switch (0=OFF else ON)
;
;	EXIT	cursor enabled/disabled
;
$$CURSOR
	PUSH	BC		;save it
	INC	B		;check command type
	DEC	B		;B=0=off?
	JR	Z,$+4		;go if yes
	LD	B,-1		;B=-1=on!
	INC	B		;adjust -1/0 > 1/2
	INC	B		;B=1=off, B=2=on
	CALL	CURSOR2		;load CRTC data
	POP	BC		;restore stack
	RET			;done!
;
;	$CURSOR2 - cursor control
;
;	ENTRY	B  =	cursor type 1-4
;		B = 1 = 1/32 blink ON
;		B = 2 = cursor OFF
;		B = 3 = 1/16 blink ON
;		B = 4 = blink OFF
;		($DODCB+20)	= cursor start/end scan
;		high 4 bits	= start scan line
;		low  4 bits	= end scan line
;		(start/end must be in range 0-9)
;
;	EXIT	CRTC programmed for new cursor
;
CURSOR2	PUSH	HL		;save HL
	LD	HL,CURTBL-1	;HL => table -1
;
;	locate table data
;
CURSOR3	INC	HL		;bump table
	DJNZ	CURSOR3		;locate entry
	LD	A,10		;select register 10
	OUT	($LCRTA),A	;select CRTC reg 10
	LD	A,($DODCB+20)	;get start scan line
	PUSH	AF		;save original
	RLCA			;align high => low bits
	RLCA
	RLCA
	RLCA
	AND	0FH		;low 4 bits only
	OR	(HL)		;get blink/rate
	OUT	($LCRTD),A	;load CRTC data register
	LD	A,11		;select register 11
	OUT	($LCRTA),A	;select CRTC reg 11
	POP	AF		;get cursor byte back
	AND	0FH		;low 4 bits only
	OUT	($LCRTD),A	;set cursor end
	POP	HL		;unstack HL
	XOR	A		;load zero
	RET			;return no error
;
;	CRTC cursor initialization data
;
CURTBL	DEFB	01100000B	;1/32 blink ON
	DEFB	00100000B	;cursor OFF
	DEFB	01000000B	;1/16 blink ON
	DEFB	00000000B	;blink OFF
;
	PAGE
;
;	$POSHL - SVC 105 - position HL to significant char
;
;	ENTRY	HL =>	text string
;
;	EXIT	Z  =	terminator found, HL => term char
;		NZ =	valid char found
;			HL => first valid character
;			A  =  first valid character
;
	INC	HL		;bump pointer
$$POSHL	LD	A,(HL)		;get a character
	CP	' '		;separator?
	JR	Z,$$POSHL-1	;ignore if yes
	CP	','		;separator?
	JR	Z,$$POSHL-1	;ignore if yes
;
;	$CKTERM - check for terminator character
;
;	ENTRY	A  =	character to test
;
;	EXIT	Z  =	terminator found
;		NZ =	no terminating char
;
$CKTERM	CP	_ETX		;end of text?
	RET	Z		;yes, return
	CP	_CR		;carriage return?
	RET	Z		;yes, return
	CP	_ECR		;embedded CR?
	RET			;return, Z=yes
;
	PAGE
;
;	$UCASE - convert character to upper case
;
;	ENTRY	A  =	character to convert
;
;	EXIT	A  =	character in upper case
;
$UCASE	CP	'a'		;in LC range?
	RET	C		;nope, return
	CP	'z'+1		;in LC range?
	RET	NC		;nope, return
	AND	5FH		;else make upper case
	RET			;return with UC char
;
	PAGE
;
;	$RANDOM - SVC 20 - generate 'random' number
;
;	ENT	B = limit value (2-255)
;
;	EXT	C = random number, range 0,B-1
;		if B = 0 or 1, then return C = 0
;		A = 0
;		Z set
;
; (NOTE) does NOT use clock to generate numbers
;
$$RANDOM
	LD	A,B		;get limit value
	OR	A		;z?
	JR	Z,RANRET	;return if yes
	DEC	A		;1?
	JR	Z,RANRET	;return if yes
	CALL	RAND0		;get random number
;
;	force 'random' number to specified limit
;
RANDM1	CP	B		;within limit?
	JR	C,RANRET	;go if yes
	SUB	B		;else force limit
	JR	RANDM1		;try again
RANRET	LD	C,A		;put it here
	XOR	A		;set Z
	RET			;go
;
;	generate 'random' number
;
RAND0	LD	A,R		;get initial 'seed'
	XOR	37H
RAND1	EQU	$-1
	LD	(RAND3),A
	RRCA
	RRCA
	XOR	2FH
RAND2	EQU	$-1
	LD	(RAND1),A
	RLA
	XOR	77H
RAND3	EQU	$-1
	LD	(RAND2),A
	RET			;done
;
	PAGE
;
;	$VALCHR - SVC 106 - check for valid filespec char
;
;	ENTRY	B  =	character to check
;
;	EXIT	Z  =	OK, A=0, B=upper case char
;		NZ =	A = error code
;
$$VALCHR
	PUSH	HL		;save
	PUSH	BC		;save
	LD	A,B		;get test char
	LD	HL,CHRTBL	;character table
	LD	BC,CHRTBLL	;table length
	CPIR			;find it
	POP	BC		;restore
	POP	HL		;restore
	JR	Z,INVCHR	;found, invalid char!
;
;	B = valid character, convert to upper case
;
	LD	A,B		;get char
	CALL	$UCASE		;make upper case
	LD	B,A		;reset char
	XOR	A		;set NO error
	RET			;return char
;
INVCHR	LD	A,_ERR91	;'illegal data range'
	OR	A		;set NZ
	RET			;return in error
;
;	table of reserved characters
;
CHRTBL	DEFM	'!'
	DEFM	'('
	DEFM	')'
	DEFM	','
	DEFM	'.'
	DEFM	'/'
	DEFM	';'
	DEFM	' '
	DEFM	':'
	DEFM	'@'
	DEFM	'='
	DEFM	'?'
	DEFM	'*'
	DEFM	'"'
	DEFB	27H
	DEFB	_ETX
	DEFB	_CR
	DEFB	_LBRACE
	DEFB	_RBRACE
CHRTBLL	EQU	$-CHRTBL
;
	PAGE
;
;	$BOOT - SVC 50 - hardware system reset
;
$$BOOT
	LD	A,@BIT0		;set bit 0
	OUT	($ROM),A	;enable boot ROM
	RST	$XIT		;re-boot!
;
	PAGE
;
;	$SPWILD - SVC 113 - directory entry / wild compare
;
;	ENTRY	HL =>	directory entry for file
;
;	EXIT	Z  =	directory entry matches $WILD
;		NZ =	filespec does not match
;
$$SPWILD
	CALL	$$SAVREG	;save registers
	LD	BC,5		;offset to name
	ADD	HL,BC		;HL => dir entry name
	LD	DE,$WLDMSK	;wildmask storage
	LD	B,11		;filename length
;
SPWILD1	LD	A,(DE)		;get a mask char
	CP	'?'		;wildcard?
	JR	Z,SPWILD2	;go if yes, force match
	CP	(HL)		;match?
	JR	Z,SPWILD2	;go if OK
	LD	A,_ERR24	;'file not found'
	RET			;return NZ
SPWILD2	INC	HL		;bump test string
	INC	DE		;bump mask
	DJNZ	SPWILD1		;go for length
	XOR	A		;set NO error
	RET			;return MATCH
;
	PAGE
;
;	$SOUND - SVC 60 - output to speaker
;
;	EXIT	L  =	unchanged
;
$$SOUND	CALL	$$SAVREG	;save registers
	LD	A,L		;get sound duration
	LD	($SOTASK+2),A	;init counter
	LD	DE,$SOTASK	;start service
	LD	BC,1<8+@SLOTSO	;B=add, C=slot #
	JP	$$NMICTL	;add task and return
;
