; sys0pr/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 05/05/83	- kjw/bqsd
;
	PAGE
;
;	system printer driver
;
;	ENTRY	B  =	character to print
;		IX =>	printer DCB
;
;	EXIT	Z  =	OK, character printed
;		NZ =	A = error code
;
$PRDVR	JP	NZ,PRIN		;@CTL/@INPUT (status)
;
	PUSH	BC		;save char/C reg
	LD	A,B		;get char to print
	BIT	3,(IX+5)	;transparent mode?
	JR	NZ,PRCHOUT	;send with no dos control
;
	CP	_VT		;form feed (0B)?
	JR	Z,PRFORM	;go if yes
	CP	_FF		;form feed (0C)?
	JR	Z,PRFORM	;go if yes
;
	BIT	4,(IX+5)	;lower case on?
	JR	NZ,$+5		;go if not
	CALL	$UCASE		;else make char upper
;
	CP	_CR		;carriage return?
	JR	NZ,PRNCR	;go if not
;
	INC	(IX+20)		;any chars on line?
	DEC	(IX+20)		;=0?
	JR	NZ,PRNCR	;go if yes
;
PRSNLF	LD	A,_LF		;else convert to linefeed
;
PRNCR	CALL	PRCHOUT		;send char to buffer
;
	CP	_LF		;linefeed?
	JR	Z,PRNLIN	;go new line if yes
	CP	_VT		;formfeed?
	JR	Z,PRNFRM	;go new form if yes
	CP	_FF		;formfeed?
	JR	Z,PRNFRM	;go new form if yes
	CP	_CR		;carriage return?
	JR	NZ,PRNCHR	;nope, continue
;
;	check for linefeed on carriage return
;
	BIT	6,(IX+5)	;LF on CR?
	JR	NZ,PRSNLF	;send it if yes
	JR	PRNLIN		;else go new line
;
;	new character printed
;
PRNCHR	INC	(IX+20)		;bump char counter
	LD	A,(IX+19)	;get chars/line
	OR	A		;nil?
	JR	Z,PRCRET	;yes, no adjusting!
;
	CP	(IX+20)		;at end of line?
	JR	NZ,PRCRET	;go if not yet
	LD	A,_CR		;else force carriage ret
	JR	PRNCR		;send char to buffer
;
;	new line printed
;
PRNLIN	LD	(IX+20),0	;reset char counter
	INC	(IX+18)		;bump line counter
	LD	A,(IX+17)	;printed lines/page
	CP	(IX+18)		;compare with line count
	JR	NZ,PRCRET	;done if not there!
;
;	new form to print
;
PRFORM	BIT	2,(IX+5)	;real form feeds?
	JR	NZ,PRNCR	;output char if yes
;
	LD	A,(IX+16)	;get page length
	SUB	(IX+18)		;less lines printed
	LD	C,A		;counter
	JR	Z,PRNFRM	;go if nil!
;
PRFMLP	LD	A,_LF		;linefeed
	CALL	PRCHOUT		;send character
	DEC	C		;less byte count
	JR	NZ,PRFMLP	;go for count
;
;	printed a new form, set top of page
;
PRNFRM	LD	(IX+18),0	;clear line counter
	LD	(IX+20),0	;clear char counter
;
;	print complete, unstack and return Z
;
PRCRET	POP	BC		;restore BC
	XOR	A		;set Z/NC
	RET			;return no error
;
;	send actual char to printer buffer
;
PRCHOUT	PUSH	BC		;save BC
	LD	B,A		;pass char
	CALL	$XLATE		;translate char
	LD	A,B		;get xlated char
;
PRCHWT	PUSH	AF		;save char
	SET	5,(IX+5)	;no interrupt de-spool
	CALL	$SPOOL		;attempt de-spool char
	RES	5,(IX+5)	;set int spool OK
	POP	AF		;restore char
	CALL	$BUFADD		;add char to buffer
	JR	NC,PRCHWT	;wait for buffer space
	LD	(IX+12),E	;else update ring pointer
	LD	(IX+13),D
	POP	BC		;restore BC
	RET			;done!
;
