; sys0over/asm - 05/05/83 - kjw/bqsd
;
;	created 05/05/83	- kjw/bqsd
;	revised 05/05/83	- dwh
;	revised 05/23/83	- kjw
;
	PAGE
;
;	$OVERLY - system overlay loader
;
;	ENT	 A  =	load command
;
;		BIT:	  7	high/low flag
;			6-4	LFN-3
;			3-0	command number
;
$OVERLY	INC	SP		;ignore
	INC	SP		;caller
;
OVRLY0	PUSH	HL		;save registers
	PUSH	DE
	PUSH	BC
;
	LD	HL,$CURCMD	;HL => current command
	LD	(HL),A		;save current command
	INC	HL		;HL => $CUROVL
;
;	check/load system overlay
;
	LD	DE,$CURENL	;low system entry
	OR	A		;check bit 7 for hi/lo
	JP	P,OVRLY1	;go if low overlay
	INC	HL		;high overlay number
	LD	DE,$CURENH	;high overlay entry
;
OVRLY1	AND	0F0H		;get system #
	CP	(HL)		;loaded?
	LD	(HL),A		;set as new system
	JR	Z,OVRLY2	;go if resident!
;
;	overlay not resident, load it!
;
	CALL	OVRLY5		;load system file
	JP	NZ,OVRLY8	;go if I/O error
	EX	DE,HL		;DE = entry point
	LD	(HL),E		;save entry for re-enter
	INC	HL		;bump pointer
	LD	(HL),D		;save MSB entry
	JR	OVRLY3		;continue
;
;	overlay loaded, get entry and go!
;
OVRLY2	EX	DE,HL		;HL => entry point
	LD	E,(HL)		;get LSB entry
	INC	HL		;bump pointer
	LD	D,(HL)		;get MSB entry
;
OVRLY3	LD	A,($CURCMD)	;get current command
	AND	0FH		;get command # 0-15
	ADD	A,A		;* 2
	LD	L,A		;pass offset to L
	LD	H,0		;HL = offset into table
	ADD	HL,DE		;HL = execute address
	CALL	$GETHL		;load HL with (HL)
;
	POP	BC		;restore stack
	POP	DE
	EX	(SP),HL		;leave vector, get HL
	RET			;go overlay!
;
	PAGE
;
;	load overlay, check if SYSRES on
;
OVRLY5	RRCA			;align sys # to LSB
	RRCA
	RRCA
	RRCA
	AND	0FH		;system # only
	LD	HL,$FLAG1	;system flag 1
	BIT	7,(HL)		;SYSRES table on?
	RES	4,(HL)		;reset table entry
	JR	Z,OVRLY5A	;go if not
;
;	check if sysres table entry active
;
	PUSH	AF		;save sys#
	LD	HL,($SYSADD)	;start sys table
	ADD	A,A		;*2
	ADD	A,L		;add offset to L
	LD	L,A		;update LSB
	JR	NC,$+3		;go if no overflow
	INC	H		;bump MSB
	CALL	$GETHL		;load HL with (HL)
	LD	A,H		;=-1 for nil entry?
	AND	L
	INC	A		;FFFF?
	JR	Z,OVRLY5A-1	;go if nil
	POP	AF		;restore stack
	LD	($SYSPNT),HL	;save sys pointer address
	LD	HL,$FLAG1	;sys flag 1
	SET	4,(HL)		;set load from memory
	JP	LOAD1		;load the file
;
;	setup system overlay special DCB
;
;	ENT	 A =	system number (0-15)
;
	POP	AF		;restore sys #
OVRLY5A	PUSH	DE		;save registers
	PUSH	IY
	ADD	A,3		;correct to LFN
	LD	B,A		;B = assumed LFN
;
	LD	C,@D0-@DRVOFF	;system drive #
	CALL	$$LOCDRV	;locate DCT block
	LD	A,B		;get LFN
	SUB	(IY+23) 	;past directory length?
	JR	C,OVRLY6	;go if not
	OR	@BIT5		;correct to LFN
	LD	B,A		;B = True LFN
;
OVRLY6	LD	A,B		;get LFN
	LD	($SYSDCB+17),A	;to DCB
	XOR	A		;set zero
	LD	($SYSDCB+10),A	;LSB nrn
	LD	A,@BIT5		;buffer <> NRN
	LD	($SYSDCB+01),A	;attribute/flags
;
	CALL	$$RDLFN		;read directory for sys
	JR	NZ,OVRLY7	;error!
	LD	A,(HL)		;get flags
	CPL			;reverse bits
	AND	50H		;active/system?
	LD	A,_ERR24	;file not found
	JR	NZ,OVRLY7	;go if invalid sys file
;
;	convert segment descriptor to disk address
;
	LD	DE,16H		;offset to SD
	ADD	HL,DE		;HL => SD list
	LD	DE,$SYSDCB+20	;DE => SD list
	LDI			;first SD
	LDI			;first SD
;
	LD	DE,$SYSDCB	;start system DCB
	CALL	LOAD1		;load overlay!
;
OVRLY7	POP	IY		;restore used registers
	POP	DE
	RET			;return with status
;
;	overlay error handler
;
OVRLY8	LD	HL,$CURCMD	;current load command
	BIT	7,(HL)		;low overlay?
	INC	HL		;HL => $CUROVL
	JR	Z,OVRLY9	;go if low
	INC	HL		;HL => $CUROVH
OVRLY9	LD	(HL),-1 	;set system not active
	LD	DE,OVRMESN	;system error number
	LD	L,A		;pass error code
	LD	C,1		;init precision
	CALL	$$EXPDEC	;binary => decimal
	LD	HL,OVRMES 	;sys error message
	CALL	$$DSPLY		;display error message
	CALL	$$KBDW		;wait for a key
	LD	A,B		;get key
	CP	_BREAK		;reboot?
	JP	Z,$$BOOT	;go if yes
	JP	$$ABORT		;else go dos ready
;
OVRMES	DEFM	'System Error'
OVRMESN	DEFM	'...'
	DEFB	_CR
	DEFB	_ETX
;
