????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????????b, nsb, lsb)
; +11,12,13,14	- ERN (byte, msb, nsb, lsb)
; +15		- LRL
; +16		- drive
; +17		- LFN/DEC
; +18,19	- EODAD
; +20-39	- SD list
;
;	flags 1
; 7	0=DCB		1=FCB
; 6	0=DCB		1=DCT
; 5	0=not		1=linked
; 4	0=not		1=routed
; 3	0=available	1=nil
; 2	0=not		1=@CTL
; 1	0=not		1=@PUT
; 0	0=not		1=@GET
;
;	flags 2
; 7	0=sector	1=blocked records
; 6	0=sequential	1=random access
; 5	0=buffer=NRN	1=buffer<>NRN
; 4	0=no		1=buffer updated
; 3	0=no		1=file updated
; 2-0	protection level (0-7)
;
;	flags 3
; 7	0=fixed		1=variable records
; 6	0=deallocate	1=non shrinkable file
; 5	0=read/write	1=read only
; 4	0=no		1=dynamic EOF update
; 3	0=fixed		1=extended open
; 2	0=PowerDOS	1=alien file
; 1	unused
; 0	unused
;
;	SD list
; +0,1		- diskette address
; +2,3,4	- start sector # this address
;
;	diskette address
; +0		- starting cylinder current disk address
; +1	7-5	- starting gran offset (0-7) this address
;	4-0	- contiguous gran count (0-31)
; +2,3,4	- relative file sector this SD pair
;
	PAGE
;
;	system file handler
;
;	$LOCATE	- locate current record #
;	$READNX	- read next record
;	$DIRRD	- read record direct
;	$WRITNX	- write next record
;	$DIRWR	- write record direct
;	$RDLFN	- read directory of file
;	$WRLFN	- write directory of file
;	$CHIOF	- character I/O via files
;	$POSN	- position to logical record
;	$REWIND	- rewind file
;	$PEOF	- position to end of file
;	$BKSP	- backspace file
;	$KILL	- kill file
;
	PAGE
;
;	$LOCATE - SVC 33 - locate current record
;
;	ENTRY	DE =>	FCB
;		BC =>	record # buffer (extended)
;
;	EXIT	BC =	current record (fixed)
;		BC =>	current record (extended)
;
$$LOCATE
	CALL	$SAVER		;setup for FCB activity
	LD	B,(IX+08)	;NRN msb
	LD	H,(IX+09)	;NRN nsb
	LD	L,(IX+10)	;NRN lsb
;
;	if VLR file or not blocked records use NRN
;
	BIT	7,(IX+01)	;blocked file?
	JR	Z,LOCAT2	;go if not!
;
;	compute logical record in fixed/blocked file
;
LOCAT1	LD	C,(IX+15)	;get LRL
	CALL	$$DIVID		;BHL+A = BHL/C
	PUSH	BC		;save MSB
	PUSH	HL		;save NSB/LSB
	LD	H,A		;pass remainder
	LD	L,(IX+07)	;NRN byte
	LD	B,0		;BHL = remain length
	CALL	$$DIVID		;BHL = remain record
	POP	DE		;get NSB/LSB result
	POP	AF		;get MSB
	LD	C,A		;CDE = length
	CALL	$$ADD24		;BHL = BHL + CDE
;
;	done, BHL = record #, setup for return to caller
;
LOCAT2	BIT	3,(IX+02)	;extended open?
	POP	DE		;DE = return address
	EX	(SP),HL		;NSB/LSB-get user buff/BC
	JR	Z,LOCAT3	;go if not extended
;
;	load record # into extended buffer
;
	LD	(HL),B		;load MSB result to buff
	POP	BC		;get NSB/LSB
	INC	HL		;bump pointer
	LD	(HL),B		;load NSB to buff
	INC	HL		;bump pointer
	LD	(HL),C		;load LSB to buff
	DEC	HL		;move back to start
	DEC	HL		;HL => user buffer
	PUSH	HL		;leave for BC pop
;
;	BC =  record # if fixed file
;	BC => record if extended file
;
LOCAT3	PUSH	DE		;return to stack
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$POSN - SVC 79 - position to logical record
;
;	ENTRY	DE =>	FCB
;		BC =	record # (if fixed)
;		BC =>	record # (if extended)
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$POSN
	CALL	$SAVER		;setup FCB activity
;
;	check for attempt to position to VLR type file
;
POSN0	CALL	VARTEST		;test if variable file
;
;	check if fixed/extended parameter
;
	SET	6,(IX+01)	;set RANDOM access
	LD	H,B		;pass rec # to HL
	LD	L,C		;HL = rec #
	LD	BC,00FFH	;B=MSB, C=for EOF check
	BIT	3,(IX+02)	;extended open?
	JR	Z,POSN1		;go if not
;
;	fetch indirect rec # from extended open
;
	LD	B,(HL)		;get MSB
	LD	C,B		;msb => C for EOF check
	INC	HL		;bump pointer
	LD	A,(HL)		;get NSB
	INC	HL		;bump
	LD	L,(HL)		;get LSB
	LD	H,A		;BHL = rec #
;
;	check for FFFF (FFFFFF) special EOF call
;
POSN1	LD	A,C		;MSB
	AND	H		;NSB
	AND	L		;LSB
	INC	A		;BHL = FFFFFF?
	JR	Z,PEOF1		;yes, posit end of file
;
;	calculate physical record from BHL logical
;
	LD	A,(IX+01)	;get flags
	AND	@BIT7		;blocked records?
	JR	Z,POSN2		;nope, go, BHLA is it
;
	LD	C,(IX+15)	;LRL
	CALL	$$MULT		;ABHL = BHL*C
	LD	C,L		;pass result to BHLA
	LD	L,H		;lsb
	LD	H,B		;nsb
	LD	B,A		;msb
	LD	A,C		;byte
;
;	position to record, BHL=record, A=byte
;
POSN2	LD	(IX+07),A	;NRN byte
;
;	check if buffer = next record #
;
	BIT	5,(IX+01)	;buffer=NRN?
	JR	NZ,POSN4	;go if not
;
;	check if attempt to position to NRN
;
	LD	A,B		;get MSB
	CP	(IX+08)		;at NRN?
	JR	NZ,POSN3	;go if not
	LD	A,H		;get NSB
	CP	(IX+09)		;at NRN?
	JR	NZ,POSN3	;go if not
	LD	A,L		;get LSB
	CP	(IX+10)		;at NRN?
	JR	Z,POSN4		;go if yes!
;
;	buffer = NRN which <> requested record
;	write residual data to disk if necessary
;
POSN3	PUSH	BC		;save new NRN
	PUSH	HL
	CALL	$$DBLOC		;write residual data
	POP	HL		;get new NRN
	POP	BC
	RET	NZ		;go if disk error!
	SET	5,(IX+01)	;buffer <> NRN
;
;	update new NRN
;
POSN4	LD	(IX+08),B	;NRN msb
	LD	(IX+09),H	;NRN nsb
	LD	(IX+10),L	;NRN lsb
	JP	CKEOF		;check against ERN
;
	PAGE
;
;	$REWIND - SVC 48 - rewind file to first record
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$$REWIND
	CALL	$SAVER		;setup for FCB I/O
	LD	B,A		;pass 0 record #
	LD	H,B
	LD	L,H		;BHLA = 00000000
	JR	POSN2		;position to record
;
	PAGE
;
;	$PEOF - SVC 82 - position to end of file
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$$PEOF
	CALL	$SAVER		;setup for FCB activity
;
PEOF1	LD	A,(IX+11)	;ERN byte
	LD	B,(IX+12)	;ERN msb
	LD	H,(IX+13)	;ERN nsb
	LD	L,(IX+14)	;ERN lsb
	JR	POSN2		;position to record
;
	PAGE
;
;	$BKSP - SVC 80 - backspace logical record
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$BKSP
	CALL	$SAVER		;setup for FCB activity
	LD	B,(IX+08)	;NRN msb
	LD	H,(IX+09)	;NRN nsb
	LD	L,(IX+10)	;NRN lsb
	BIT	7,(IX+01)	;blocked records?
	JR	Z,BKSP1		;go if not
;
;	backspace by logical record
;
	LD	A,(IX+15)	;get LRL
	NEG			;A = 0-A
	ADD	A,(IX+07)	;NRN byte
	JR	C,POSN2		;position to record BHLA
;
;	backspace NRN record
;
BKSP1	PUSH	AF		;save byte
	CALL	$$DEC24		;BHL = BHL-1
	POP	AF		;get byte
	JR	POSN2		;position to record BHLA
;
	PAGE
;
;	$READNX - SVC 34 - read next record
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$$READNX
	CALL	$SAVER		;setup for FCB activity
;
READ0	BIT	7,(IX+01)	;blocked records?
	JP	Z,RDREC		;go if not!
;
	LD	L,(IX+05)	;get user buffer
	LD	H,(IX+06)
	LD	B,(IX+15)	;get LRL
	BIT	7,(IX+02)	;fixed/variable?
	JR	Z,READ1		;go if fixed
;
;	read next record from variable length file
;
	PUSH	HL		;save buffer
	CALL	RDBYTE		;read record length
	POP	HL		;restore buffer
	RET	NZ		;go if error
	LD	(IX+15),A	;pass LRL to FCB
	LD	B,A		;pass LRL to counter
	JR	READ2		;place into buffer
;
;	read a blocked record
;
READ1	PUSH	BC		;save
	PUSH	HL		;save
	CALL	RDBYTE		;read single byte
	POP	HL		;restore
	POP	BC
	RET	NZ		;go if error!
;
READ2	LD	(HL),A		;load data
	CP	(HL)		;still there?
	JR	NZ,READ3	;go memory error!
	INC	HL		;bump buffer
	DJNZ	READ1		;go for count
	XOR	A		;set NO error
	RET			;done!
;
READ3	LD	A,_ERR35	;memory fault!
	OR	A		;set NZ
	RET			;return in error!
;
	PAGE
;
;	$WRITNX - SVC 43 - write next record
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ = 	A = error code
;
$$WRITNX
	CALL	$SAVER		;setup for FCB activity
;
WRITE0	BIT	7,(IX+01)	;blocked records?
	JP	Z,WRREC		;nope, write record!
;
	LD	L,(IX+05)	;get user buffer
	LD	H,(IX+06)
	BIT	7,(IX+02)	;fixed/variable length?
	JR	Z,WRITE1	;go if fixed length
	LD	A,(HL)		;else get variable LRL
	LD	(IX+15),A	;pass to FCB
;
;	write a blocked record
;
WRITE1	LD	B,(IX+15)	;get LRL
;
WRITE2	LD	A,(HL)		;get data byte
	INC	HL		;bump buff pointer
	PUSH	BC		;save
	PUSH	HL		;save
	CALL	WRBYTE		;write single byte
	POP	HL		;restore
	POP	BC
	RET	NZ		;go if disk error!
	DJNZ	WRITE2		;go for LRL
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$DIRRD - 35 - direct record read with position
;
;	ENTRY	DE =>	FCB
;		BC =	record number (fixed)
;		BC =>	record number (extended)
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$DIRRD
	CALL	$SAVER		;setup for FCB activity
	CALL	POSN0		;position to record
	RET	NZ		;go if error!
	JR	READ0		;read record!
;
	PAGE
;
;	$DIRWR - SVC 44 - direct record write with posn
;
;	ENTRY	DE =>	FCB
;		BC =	logical record # (fixed)
;		BC =>	logical record # (extended)
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$DIRWR
	CALL	$SAVER		;setup for FCB activity
	CALL	POSN0		;position to record
	JR	Z,DIRWR1	;go if no error
;
;	check for EOF or disk error
;
	CP	_ERR28		;end of file?
	JR	Z,DIRWR1	;go if yes
	CP	_ERR29		;past end of file?
	RET	NZ		;nope, return error!
;
DIRWR1	JR	WRITE0		;write record!
;
	PAGE
;
;	$CHIOF - file character I/O driver
;
;	ENTRY	IX =>	FCB
;		B  =	byte (if output)
;
;	EXIT	Z  =	OK, B = byte input/output
;		NZ =	A = error code
;
CHIOF	PUSH	IX		;pass to DE
	POP	DE		;DE => FCB
	EX	AF,AF'		;save command flags
	CALL	$SAVER		;setup registers
	EX	AF,AF'		;get flags back
	SET	7,(IX+01)	;set blocked records
	BIT	0,A		;input/output?
	LD	A,B		;get data for output
	JR	Z,WRBYTE	;write byte if output
;
	CALL	RDBYTE		;else read a byte
	RET	NZ		;go if error!
;
;	pass data to stack for exit
;
	POP	HL		;get ret address
	POP	BC		;get data
	LD	B,A		;pass new char
	PUSH	BC		;restore stack
	PUSH	HL		;ret address
	XOR	A		;set NO error
	RET			;unstack & return
;
	PAGE
;
;	$RDBYTE - read single byte from file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=input character
;		NZ = 	A = error code
;
RDBYTE	CALL	CKEOF		;check for end of file
	RET	NZ		;go if error!
;
	CALL	RDSEC		;read record
	RET	NZ		;go if any error!
;
	CALL	CALCBA		;calculate buffer address
	LD	A,(DE)		;get data byte
;
	PUSH	AF		;save input byte
	INC	(IX+07)		;bump NRN byte
	JR	NZ,RDBYTE2	;go if not at end
	CALL	$$DBLOC		;write residual data
	JR	Z,RDBYTE1	;go if no error
	POP	HL		;remove input on stack
	RET			;return in error
;
RDBYTE1	CALL	INCREC		;bump record #
RDBYTE2	POP	AF		;restore character
	CP	A		;set Z for no error
	RET			;done, return with char
;
	PAGE
;
;	$WRBYTE - write single byte to file
;
;	ENTRY	IX =>	FCB
;		A  =	character to write
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
WRBYTE	PUSH	AF		;save data char
	BIT	5,(IX+01)	;buffer = NRN?
	JR	Z,WRBYTE2	;go if yes
	CALL	CKEOF		;check end of file
	JR	Z,WRBYTE1	;go if not EOF
;
;	read next sector if NRN byte <> 0
;
	LD	A,(IX+07)	;get NRN byte
	OR	A		;= 00?
	JR	Z,WRBYTE2	;go if yes
;
WRBYTE1	CALL	RDSEC		;read next sector
	JR	Z,WRBYTE2	;go if no error
	POP	HL		;remove character
	RET			;return in error
;
WRBYTE2	RES	5,(IX+01)	;buffer = NRN
	CALL	CALCBA		;calculate buffer address
	POP	AF		;get character
	LD	(DE),A		;char to buffer
	SET	4,(IX+01)	;set buffer updated
	INC	(IX+07)		;bump NRN byte
	JR	NZ,WRBYTE3	;go if not at end
;
	CALL	WRSEC		;write full sector
	RET	NZ		;go if error!
	CALL	INCREC		;bump next record #
;
WRBYTE3	CALL	STEOF		;set optional EOF update
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$RDREC - read physical record from file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
RDREC	CALL	CKEOF		;check for end of file
	RET	NZ		;go if EOF error!
	CALL	RDSEC		;read sector
	RET	NZ		;go if I/O error!
	CALL	INCREC		;bump record #
	XOR	A		;set NO error
	RET			;done, return
;
	PAGE
;
;	$RDSEC - read sector from file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
RDSEC	LD	A,(IX+01)	;get flags
	BIT	5,A		;buffer = NRN?
	RET	Z		;yes, already read!
;
	LD	HL,$FLAG1	;sys flag 1
	BIT	0,(HL)		;force read?
	JR	NZ,RDSEC1	;go if yes
;
;	check for read access to file
;
	AND	7		;A = protection level
	CP	_EXEC		;read?
	JR	NC,WRSEC0	;go if not!
;
RDSEC1	CALL	GETPDA		;get physical disk addr
	RET	NZ		;go if error
	LD	A,@DREAD	;sector read
	RST	$DIO		;read it
	RET	NZ		;go if error
	RES	5,(IX+01)	;buffer = NRN
	RET			;return Z
;
	PAGE
;
;	$WRREC - write physical record to file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
WRREC	CALL	WRSEC		;write sector
	RET	NZ		;go if disk error
	CALL	INCREC		;bump logical rec #
	CALL	STEOF		;set EOF update
	XOR	A		;set NO error
	RET			;return OK
;
	PAGE
;
;	$WRSEC - write sector to file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
WRSEC	BIT	5,(IX+02)	;write access?
	LD	A,_ERR13	;'write to read only file
	RET	NZ		;go if not!
;
	LD	A,(IX+01)	;get prot flags
	AND	7		;A = protection level
	CP	_READ		;write access?
	JR	C,WRSEC1	;go if allowed
;
WRSEC0	LD	A,_ERR95	;'illegal access'
	OR	A		;set NZ for error
	RET			;return in error
;
WRSEC1	CALL	GETPDA		;physical disk address
	RET	NZ		;go if error
	LD	A,@DWRIT	;disk write
	RST	$DIO		;write sector
	RET	NZ		;go if disk error!
;
	LD	HL,$FLAG1	;system flag 1
	BIT	1,(HL)		;verify on?
	JR	Z,WRSEC2	;go if no verify
;
	LD	HL,$SBUFF	;system I/O buffer
	LD	A,@DVERF	;disk verify
	RST	$DIO		;verify the sector
	RET	NZ		;go if disk error
;
WRSEC2	RES	4,(IX+01)	;set buffer updated
	XOR	A		;set NO error
	RET			;done, return Z
;
	PAGE
;
;	$$$DBLOC - write out residual buffer data
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$DBLOC	LD	A,(IX+01)	;get flags
	CPL			;reverse bits
	AND	90H		;new blocked data?
	JR	Z,WRSEC		;write sector if yes
	XOR	A		;else set NO error
	RET			;done!
;
;	$INCREC - increment to next record
;
INCREC	SET	5,(IX+01)	;buffer <> NRN
	INC	(IX+10)		;NRN lsb
	RET	NZ		;go no overflow
	INC	(IX+09)		;NRN nsb
	RET	NZ		;go no overflow
	INC	(IX+08)		;NRN msb
	RET			;done! NRN = NRN+1
;
	PAGE
;
;	$STEOF - set end of file
;
STEOF	SET	3,(IX+01)	;set file updated!
	CALL	CKEOF		;check for end of file
	JR	NZ,STEOF1	;go if end of file
	BIT	6,(IX+01)	;random access?
	RET	NZ		;yes, no update!
;
STEOF1	LD	A,(IX+01)	;get prot level
	AND	7		;low 3 bits
	CP	_UPDATE		;write or higher?
	RET	NC		;cannot update EOF!
;
	PUSH	IX		;pass FCB to DE
	POP	DE		;DE => FCB
	LD	HL,7		;offset to NRN
	ADD	HL,DE		;HL => NRN
	EX	DE,HL		;DE => NRN
	LD	HL,4		;length of NRN
	LD	B,H		;pass count to BC
	LD	C,L
	ADD	HL,DE		;HL => ERN
	EX	DE,HL		;HL=>NRN, DE=>ERN
	LDIR			;move NRN => ERN
	RET			;file extended!
;
	PAGE
;
;	$CALCBA - calculate effective buffer address
;
;	ENTRY	IX =>	FCB
;
;	EXIT	DE =>	blocking buffer address
;
CALCBA	LD	A,(IX+07)	;NRN byte
	ADD	A,(IX+03)	;LSB buffer
	LD	E,A		;E = LSB buffer
	LD	A,(IX+04)	;MSB buffer
	ADC	A,0		;+ lsb overflow
	LD	D,A		;D = MSB buffer
	RET			;DE => buffer
;
	PAGE
;
;	$CKEOF - check for end of file
;
;	ENTRY	IX =>	FCB
;
;	EXIT	Z  =	OK, A=0, within ERN
;		NZ =	A = error code
;
CKEOF	LD	A,(IX+08)	;msb NRN
	CP	(IX+12)		;msb ERN
	JR	NZ,CKEOF2	;go if not
	LD	A,(IX+09)	;nsb NRN
	CP	(IX+13)		;nsb ERN
	JR	NZ,CKEOF2	;go if not
	LD	A,(IX+10)	;lsb NRN
	CP	(IX+14)		;lsb ERN
	JR	NZ,CKEOF2	;go if not
	LD	A,(IX+07)	;byte NRN
	SUB	(IX+11)		;byte ERN
	JR	NZ,CKEOF2	;go if not
;
	OR	_ERR28		;EOF error!
	RET			;go!
;
CKEOF2	LD	A,_ERR29	;beyond EOF?
	RET	NC		;go if error
	XOR	A		;else OK
	RET			;return no error
;
	PAGE
;
;	$SAVER - setup for FCB activity
;
;	ENTRY	DE =>	FCB
;
;	EXIT	IX =>	FCB, exit left on stack
;		will not exit if file not open!
;
$SAVER	LD	A,(DE)		;get file flags
	RLCA			;open?
	JR	C,$$SAVERN	;go if yes!
;
;	I/O attempt to unopen file!
;
	POP	AF		;remove call address
	LD	A,_ERR38	;'I/O to unopen file'
	OR	A		;set NZ for error
	RET			;return error!
;
$$SAVERN
	POP	AF		;get caller
	PUSH	HL		;save HL
	PUSH	DE		;FCB to stack
	EX	(SP),IX		;IX=>stack, get FCB
	PUSH	IY		;save registers
	PUSH	DE
	PUSH	BC
;
	PUSH	HL		;save
	LD	HL,SAVER1	;return vector
	EX	(SP),HL		;leave, get HL
	PUSH	AF		;caller to stack
	XOR	A		;set NO error
	RET			;done!
;
;	restore registers and check EOF
;
SAVER1	POP	BC		;restore stack
	POP	DE
	POP	IY
	JR	Z,SAVER3	;go if no error
	CP	_ERR28		;EOF error?
	JR	C,SAVER2	;go if below
	CP	_ERR30		;beyond EOF error?
	JR	NC,SAVER2	;go if not!
;
;	check for end of file transfer
;
	LD	H,(IX+19)	;get msb EODAD
	INC	H		;check for no xfer
	DEC	H		;msb = 00?
	JR	Z,SAVER2	;go if no transfer
	LD	L,(IX+18)	;get lsb EODAD
	POP	IX		;restore IX
	EX	(SP),HL		;get HL, leave vector
	RET			;go EODAD address
;
SAVER2	OR	A		;set flags on result
SAVER3	POP	IX		;unstack
	POP	HL
	RET			;return with status
;
	PAGE
;
;	$GETPDA - get physical disk address
;
;	ENTRY	IX =>	FCB
;
;	EXIT	C  =	drive # (0-7)
;		BE =	sector number
;		D  =	cylinder number
;		HL =	blocking buffer
;
GETPDA	LD	C,(IX+16)	;get drive #
	CALL	$$LOCDRV	;get DCT
	LD	A,_ERR16	;'dcb modified'
	RET	NZ		;go if FCB corrupt!
;
;	get NRN and compute gran than contains it
;
	LD	B,(IX+08)	;NRN msb
	LD	H,(IX+09)	;NRN nsb
	LD	L,(IX+10)	;NRN lsb
	LD	C,(IY+24)	;get secs/gran
	CALL	$$DIVID		;divide BHL/C
	LD	(SDISP),A	;save sector offset
;
	PUSH	IX		;pass IX => HL
	EX	(SP),HL		;HL => FCB
	LD	BC,20		;offset to SD list
	ADD	HL,BC		;HL => SD list
	POP	BC		;BC = required gran
;
	LD	A,5		;init SD count
	LD	DE,0		;init gran offset
;
GETPDA0	PUSH	AF		;save SD count
	LD	A,(HL)		;get lsb csd
	INC	HL		;bump pointer
	INC	A		;FF terminator?
	JR	Z,GETPDA1	;go if yes
;
	PUSH	HL		;save SD pointer
	LD	H,D		;pass gran count
	LD	L,E
	XOR	A		;clear carry
	SBC	HL,BC		;found?
	JR	C,GETPDA2	;possible
	POP	HL		;restore SD list
	JR	Z,NXTCSD	;found, go!
;
GETPDA1	INC	HL		;HL => next gran offset
	POP	AF		;get SD count
	DEC	A		;end SD list?
	JR	Z,GETPDA3	;go if yes
;
	LD	E,(HL)		;get next gran offset
	INC	HL		;bump
	LD	D,(HL)		;get msb offset
	INC	HL		;bump
	JR	GETPDA0		;go next SD quad
;
GETPDA2	INC	H		;required gran > offset?
	LD	A,L		;get offset requested
	POP	HL		;HL => SD list
	JR	NZ,GETPDA1	;go if not found
;
	PUSH	DE		;save gran offset
	LD	E,A		;E = offset required
	LD	A,(HL)		;get SD count
	AND	1FH		;gran count -1
	ADD	A,E		;add offset
	LD	A,E		;get offset + count
	POP	DE		;restore
	JR	NC,GETPDA1	;not found!
	NEG			;gran displacement
	JR	NXTCSD		;found, go!
;
;	save info and setup for SD fetch
;
GETPDA3	LD	A,(SDISP)	;get sector displace
	LD	(TDISP),A	;save temp disp
	LD	A,($CUROVL)	;get current low overlay
	LD	(TOVL),A	;save it
;
	LD	A,_SYS03+_CMD02	;fetch new CSD
	CALL	OVRLY0		;load/execute system
;
	PUSH	AF		;save gran/error
	LD	A,0		;get last overlay
TOVL	EQU	$-1
	CP	_SYS02		;open?
	CALL	NZ,OVRLY0	;reload if not
	POP	AF		;restore gran/error
	RET	NZ		;go if error!
;
	LD	(GRAN),A	;save gran disp
;
	LD	A,0		;get stored displ.
TDISP	EQU	$-1
	LD	(SDISP),A	;reset displacement
	JR	C,TOPCSD	;move CSD to top
	JR	CSDPDA		;else get disk address
;
;	shift FCB SD list
;
NXTCSD	LD	(GRAN),A	;save gran displacement
	LD	B,(HL)		;get quad
	DEC	HL		;move back
	LD	C,(HL)		;BC = gran offset
	INC	HL		;HL => SD
	POP	AF		;get SD count
	CPL			;reverse bits
	ADD	A,4		;count >3
	JR	NC,GETPDA4	;go if yes
	INC	A		;correct count
	RLCA			;*2
	RLCA			;*4
	PUSH	BC		;save
	PUSH	DE		;save
	EX	DE,HL		;DE => SD list
	LD	HL,-4		;offset to next
	ADD	HL,DE		;HL => start squeeze
	LD	C,A		;C = length
	LD	B,0		;BC = length
	LDDR			;shift SD list
	EX	DE,HL		;HL => SD list
	POP	DE		;restore
	POP	BC		;restore
;
;	place current SD at top of list
;
TOPCSD	LD	(HL),B		;msb
	DEC	HL		;back
	LD	(HL),C		;lsb
	DEC	HL		;back
	LD	(HL),D		;msb gran
	DEC	HL		;back
	LD	(HL),E		;lsb gran
;
GETPDA4	LD	H,B		;pass to HL
	LD	L,C		;HL = SD
;
;	convert current SD to disk address
;
CSDPDA	LD	A,H		;get gran info
	RLCA			;high bits to low
	RLCA
	RLCA
	AND	7		;gran offset
	ADD	A,0		;add offset
GRAN	EQU	$-1
	LD	E,A		;E = gran
	LD	A,(IY+25)	;grans/cylinder
	CALL	SDIVID		;divide
	ADD	A,L		;+ cyl disp
	LD	D,A		;D = cylinder
	LD	C,(IY+24)	;secs/gran
	LD	L,E		;pass gran offset
	LD	H,0		;nsb
	LD	B,H		;msb
	CALL	$$MULT		;ABHL = BHL * C
	LD	A,L		;get lsb result
	ADD	A,0		;+ sector offset
SDISP	EQU	$-1
	LD	E,A		;E = lsb sector
	LD	A,H		;get nsb
	ADC	A,0		;+ overflow
	LD	B,A		;msb sector
	LD	C,(IX+16)	;get drive #
	LD	L,(IX+03)	;get blocking buffer
	LD	H,(IX+04)
	XOR	A		;set NO error
	RET			;return with disk address
;
	PAGE
;
;	$RDLFN - SVC 32 - read logical file => sys buffer
;	$WRLFN - SVC 50 - write logical file from sys buf
;
;	ENTRY	C  =	drive number (0-7)
;		B  =	logical file number (0-255)
;
;	EXIT	HL =>	directory record (read)
;			sector written (write)
;		Z  =	OK, A=0
;		NZ =	A = error code
;
$$RDLFN
	LD	A,@SREAD	;read command
	CALL	DIRIO		;directory I/O
	RET	Z		;go if no error
	LD	A,_ERR17	;directory read error
	RET			;converted error
;
$$WRLFN
	LD	A,@SWRIT	;write command
	CALL	DIRIO		;directory I/O
	RET	Z		;go if no error
	LD	A,_ERR18	;directory write error
	RET			;converted error
;
;	convert LFN and perform I/O
;
DIRIO	PUSH	BC		;save
	PUSH	DE		;save
	PUSH	AF		;save I/O type
	LD	A,B		;get LFN
	AND	0E0H		;get sector offset
	LD	L,A		;pass to L
	LD	H,$SBUFF<-8	;MSB system buffer
	XOR	B		;low nybble
	ADD	A,2		;correct to sector
	LD	E,A		;E = sector #
	POP	AF		;get I/O type
	PUSH	HL		;save system buffer ptr
	LD	B,0		;BE = sector number
	LD	L,B		;HL => system buffer
	RST	$DIO		;read/write sector
	POP	HL		;HL => file
	POP	DE		;restore
	POP	BC		;restore
	RET			;return with status
;
	PAGE
;
;	$KILL - SVC 41 - kill file
;
;	ENTRY	DE => 	FCB
;
;	EXIT	Z  =	OK, A=0
;		NZ =	A = error code
;
$$KILL
	PUSH	HL		;save HL
	LD	HL,LOADP	;param list
	LD	A,(DE)		;get file flags
	CPL			;reverse bits
	AND	@BIT7		;file open?
	CALL	NZ,$$OPEN	;open if not
	POP	HL		;restore HL
	CALL	Z,$$KILLO	;delete file
	RET			;return with status
;
;	$VARTEST - check if variable length file
;
VARTEST	BIT	7,(IX+02)	;variable length file?
	RET	Z		;nope, go!
	POP	AF		;remove caller
	LD	A,_ERR46	;'invalid VLR attempt'
	OR	A		;set NZ
	RET			;return in error
;
;	single precision divide
;
;	ENTRY	E  =	dividend
;		A  =	divisor
;
;	EXIT	A  =	quotient
;		E  =	remainder
;
SDIVID	PUSH	BC		;save
	LD	C,A		;C = divisor
	LD	B,8		;init precision
	XOR	A		;init remainder
;
SDIVD1	SLA	E		;shift dividend
	RLA			;catch overflow
	CP	C		;at divisor?
	JR	C,SDIVD2	;go if less
	SUB	C		;remainder - divisor
	INC	E		;quotient +1
SDIVD2	DJNZ	SDIVD1		;go for precision
	LD	C,A		;C = remainder
	LD	A,E		;A = quotient
	LD	E,C		;E = remainder
	POP	BC		;restore
	RET			;done
;
