; sys0dvr/asm - kjw/bqsd - 04/27/83
;
;	created 04/28/83	- kjw/bqsd
;	revised 05/12/83	- kjw/bqsd
;
;	system driver support
;
	PAGE
;
;	@EXESVC - execute supervisor call
;
;	ENTRY	A  =	supervisor # (0-127)
;
;	EXIT	exit conditions of requested SVC
;
$EXESVC	ADD	A,A		;double for table
	JR	C,$$UNDEF	;go if out of range
;
	PUSH	HL		;save HL
	LD	L,A		;pass table offset
	LD	H,$SVCTBL<-8	;MSB table start
	CALL	$GETHL		;load HL < (HL)
	EX	(SP),HL		;leave vect/get HL
	RET			;go SVC driver!
;
;	undefined or out of range SVC
;
$$UNDEF	LD	A,_ERR01	;'bad function on SVC'
	OR	A		;set NZ/NC
	RET			;return in error
;
	PAGE
;
;	$BUFTAK - fetch character from spool buffer
;
;	ENTRY	IX =>	DCB
;
;	EXIT	A  =	character
;		HL =>	character buffer
;		DE =	ring location
;		Cy =	character available
;
$BUFTAK	LD	L,(IX+12)	;get add offset
	LD	H,(IX+13)	;HL = add ring
	LD	E,(IX+14)	;get take offset
	LD	D,(IX+15)	;DE = take ring
	OR	A		;clear carry
	SBC	HL,DE		;add = take?
	RET	Z		;yes, NC = nil buffer
;
	LD	L,(IX+08)	;get buffer start
	LD	H,(IX+09)	;HL = buffer start
	CALL	$INCBUF		;bump ring pointer
	ADD	HL,DE		;HL => character
	LD	A,(HL)		;get character
	SCF			;CY = have character
	RET			;return with character
;
	PAGE
;
;	$BUFADD - add character to spool buffer
;
;	ENTRY	IX =>	DCB
;		A  =	character to add
;
;	EXIT	HL =	add location
;		DE =	ring location
;		Cy =	character added
;
$BUFADD	LD	L,(IX+14)	;get take offset
	LD	H,(IX+15)	;HL = take ring
	LD	E,(IX+12)	;get add offset
	LD	D,(IX+13)	;DE = add ring
	CALL	$INCBUF		;bump ring pointer
	OR	A		;clear carry
	SBC	HL,DE		;add = take?
	RET	Z		;NC - no room to add!
;
	LD	L,(IX+08)	;get buffer start
	LD	H,(IX+09)	;HL = buffer start
	ADD	HL,DE		;HL = char location
	LD	(HL),A		;add char to buffer
	SCF			;CY = char added
	RET			;done!
;
	PAGE
;
;	$INCBUF - increment ring buffer pointer
;
;	ENTRY	IX =>	DCB
;		DE =	ring location
;
;	EXIT	DE =	next ring location
;
$INCBUF	PUSH	HL		;save HL
	INC	DE		;bump ring pointer
	LD	L,(IX+10)	;get buffer length
	LD	H,(IX+11)	;HL = max buffer length
	SCF			;set for adjust
	SBC	HL,DE		;compare to buffer end
	POP	HL		;restore HL
	RET	NC		;go if not at end yet
	LD	DE,0		;else reset to start
	RET			;DE = new offset
;
	PAGE
;
;	$XLATE - translate character
;
;	ENTRY	IX =>	DCB
;		B  =	character to translate
;
;	EXIT	B  =	translated character
;		A,HL destroyed
;
$XLATE	BIT	0,(IX+5)	;XLATE on?
	RET	Z		;nope, go!
;
	LD	L,(IX+6)	;get xlate table
	LD	H,(IX+7)	;HL => table
	LD	A,B		;get xlate char
	LD	B,(HL)		;get table length
;
XLATE1	INC	HL		;bump table pointer
	CP	(HL)		;matching entry?
	INC	HL		;bump table
	JR	Z,XLATE2	;go if match
	DJNZ	XLATE1		;go for table length
	LD	B,A		;restore original
	RET			;done!
;
XLATE2	LD	B,(HL)		;get translated char
	RET			;return with it
;
