; sendrecv/asm - 05/09/83 - dwh
;
;	created 05/09/83	- dwh
;	revised 05/11/83	- dwh
;
;	LIB command to send/receive a file
;	through RS232 with protocal.
;
*GET DOSEQU			;external equivalences
;
;	SEND from filespec to device 3 or 4 (RETRY=value)
;
SEND	LD	(STACK),SP	;save stack
	LD	BC,EXIT		;exit vector
	PUSH	BC		;to the stack
;
	LD	A,10		;default retrys
	LD	(RTRIES+2),A	;save default
	XOR	A		;load zero
	LD	(EOFLAG),A	;EOF flag
	LD	BC,PARAM	;allow params on SEND
	CALL	$EVAL		;evaluate input
	RET	NZ		;go if error
;
;	check for valid input
;
	LD	A,(IX+0)	;get flag
	AND	0FH		;mask byte
	CP	0EH		;source/dest/not mask
	LD	A,_ERR48	;invalid data
	RET	NZ		;abort if error
;
;	check for source = filespec
;
	LD	DE,SDCB		;source DCB
	CALL	VALFILE		;valid file?
	RET	NZ		;go if not
;
;	open source for input
;
	INC	DE		;bump to filespec
	LD	HL,SBUFF	;source I/O buffer
	LD	BC,'R'<8+0	;read/open existing
	CALL	$OPEN		;open the file
	RET	NZ		;go if error
;
;	check for dest = CA/CB devices
;
	LD	DE,DDCB		;dest DCB
	CALL	VALSIO		;valid SIO channel?
	RET	NZ		;go if not
;
;	open dest for output
;
	INC	DE		;bump to filespec
	LD	A,@OPEN		;SVC open
	RST	$SVC		;open for output
	RET	NZ		;go if error!
;
;	fetch and store LRL from source file
;
	LD	A,(SDCB+16)	;get source LRL
	LD	(SENDLRL),A	;store
;
;	setup 30 second time-out delay
;
	CALL	TIMEON		;enable timer
	RET	NZ		;go if error
;
;	send 'ENQUIRE' to init loop
;
	LD	B,_ENQ		;initial ENQ
	LD	A,@PUT		;send it to CL
	RST	$SVC		;send to DE
	RET	NZ		;go if error!
;
;	wait for 'ACKNOWLEDGE' before continuing
;
SEND2	CALL	$GET		;get byte from channel
	RET	NZ		;go if error
	CP	_ACK		;ACK?
	JR	NZ,SEND2	;try again
;
;	now send the LRL and retry if echo is wrong
;	timer still in effect
;
SEND3	LD	A,(SENDLRL)	;get true LRL
	LD	B,A		;setup for send
	LD	A,@PUT		;send it to CL
	RST	$SVC		;send char!
	RET	NZ		;go if error!
;
;	wait for echo of LRL character
;
SEND4	CALL	$GET		;fetch a char
	RET	NZ		;go if error!
;
	LD	BC,(SENDLRL)	;get true
	CP	C		;compare to echo
	JR	Z,SEND5		;okay
;
;	LRL did not echo, send 'NAK' and resend LRL
;
	LD	B,_NAK		;bad
	LD	A,@PUT		;send to CL
	RST	$SVC		;send char
	RET	NZ		;go if error
	JR	SEND3		;try again
;
;	main block send routine, disable timer
;
SEND5	CALL	TIMEOFF		;turn off timer
	RET	NZ		;go if error
;
;	check if file completed
;
	LD	A,(EOFLAG)	;get EOF flag
	INC	A		;FF for end?
	JR	Z,SEND12	;yes, done!
;
;	load block of data = LRL
;
SEND6	LD	DE,SDCB+1	;source FCB
	LD	HL,BUFF		;memory buff
	LD	BC,(SENDLRL)	;C = LRL
;
SEND7	CALL	$GET		;get a byte
	RET	NZ		;go if error!
	JR	NC,SEND7A	;go if not EOF
;
;	EOF reached, but possible in middle of record
;	pad remainder of record with FF's
;
	LD	A,-1		;set EOF flag
	LD	(EOFLAG),A	;save it
;
SEND7A	LD	(HL),A		;store it to memory
	INC	HL		;next location
	DEC	C		;less byte count
	JR	NZ,SEND7	;go for LRL
;
;	inform dest channel that text follows
;
	LD	B,_STX		;start of text
	LD	DE,DDCB+1	;dest DCB
	LD	A,@PUT		;send to CL
	RST	$SVC		;send char
	RET	NZ		;go if error!
;
;	setup outer retry loop
;
	LD	BC,(RTRIES+2)	;C = retry count
;
;	setup inner LRL block transfer loop
;
SEND8	LD	A,(SENDLRL)	;get LRL
	LD	B,A		;B = LRL
	LD	E,0		;init checksum
	LD	HL,BUFF		;memory buffer
;
;	attempt to send LRL block of data
;
SEND9	PUSH	BC		;save LRL/retries
	LD	A,(HL)		;get character
	LD	B,A		;pass to B for output
	ADD	A,E		;add to checksum
	LD	E,A		;update checksum
	PUSH	DE		;save checksum
	LD	DE,DDCB+1	;dest DCB block
	LD	A,@PUT		;SVC put
	RST	$SVC		;send byte
	POP	DE		;restore checksum
	POP	BC		;restore LRL/tries
	RET	NZ		;go if error!
;
	INC	HL		;next memory
	DJNZ	SEND9		;go for LRL
;
;	now send cksum, and wait for ACK/NAK.
;	turn on timer in case no response
;
	LD	B,E		;checksum
	LD	DE,DDCB+1	;dest DCB
	LD	A,@PUT		;send it to CL
	RST	$SVC		;send byte
	CALL	TIMEON		;enable timer
	RET	NZ		;go if error
;
SEND10	CALL	$GET		;get a char
	RET	NZ		;go if error
	CP	_ACK		;okay?
	JR	Z,SEND5		;next block
	CP	_NAK		;negative?
	JR	NZ,SEND10	;invalid reply
	DEC	C		;less retry count
	JR	NZ,SEND8	;go till retry limit
;
;	retry count exceeded, send 'CANCEL'
;
ABORT	LD	B,_CAN		;cancel
	LD	A,@PUT		;SVC put
	RST	$SVC		;send cancel
	RET	NZ		;go if error
;
;	EODAD - send ETX and finish
;
SEND12	LD	B,_ETX		;end of text
	LD	DE,DDCB+1	;output channel
	LD	A,@PUT		;send
	RST	$SVC		;do it
;
;	common exit vector
;
EXIT	AND	7FH		;any errors?
	JR	Z,DONE		;nope, go!
	LD	B,A		;pass error code
	LD	A,@ERROR	;SVC error
	RST	$SVC		;display error
;
DONE	CALL	TIMEOFF		;timer off
	LD	SP,$		;reset stack
STACK	EQU	$-2
	XOR	A		;set NO error
	RET			;done!
;
;	open file/device
;
;	ENTRY	DE =>	DCB/FCB
;		HL =	I/O buffer
;		B  =	'R'/'W' access code
;		C  =	0-3 creation code
;
;	EXIT	Z/NZ
;
$OPEN	LD	(OLIST),HL	;pass I/O buffer
	LD	A,B		;get read/write
	LD	(OLIST+6),A	;to list
	LD	A,C		;get open type code
	LD	(OLIST+9),A	;to list
	LD	HL,OLIST	;start open list
	LD	A,@OPEN		;SVC open
	RST	$SVC		;open file/device
	RET			;return with status
;
;	$EVAL - evaluate user input
;
;	ENTRY	BC =	address of params (0000=none)
;
;	EXIT	Z/NZ, IX => EBLOCK
;
$EVAL	LD	(EBLOCK+7),BC	;pass param address
	LD	IX,EBLOCK	;start eval block
	LD	A,@EVAL		;SVC eval
	RST	$SVC		;evaluate user input
	RET			;done, return with status
;
;	$TIMEON/$TIMEOFF - enable/disable user timer
;
TIMEON	LD	HL,ABORT	;timer vector
	LD	BC,30		;timer seconds
	JR	TIME		;continue
;
TIMEOFF	LD	HL,0		;nil vector
	LD	B,H		;pass to BC
	LD	C,L		;HL/BC = 00
;
TIME	LD	A,@TIMER	;SVC timer
	RST	$SVC		;setup timer
	RET			;return with status
;
;	$GET - fetch character from device/file
;
;	ENTRY	DE =>	DCB/FCB
;
;	EXIT	Z  =	OK, A=char
;		NZ =	A = error code
;		Cy =	end of file reached
;
$GET	LD	A,@GET		;SVC get
	RST	$SVC		;fetch character
	RET	Z		;go if no error
;
	CP	_ERR02		;char not available?
	JR	Z,$GET		;yes, wait for it
;
;	check for EOF condition
;
	CP	_ERR28		;EOF?
	SCF			;Z/C = yes
	RET	Z		;yes, go
	CP	_ERR29		;EOF?
	RET	NZ		;nope, return NZ error
	SCF			;else C = yes
	RET			;return Z/C
;
;	$VALFILE - check for valid file as input/output
;
;	ENTRY	DE =>	DCB
;
;	EXIT	Z  =	OK, file device specified
;		NZ =	A = error code
;
VALFILE	LD	A,(DE)		;get flags
	XOR	@BIT6		;filespec MUST be set
	AND	@BIT6+@BIT5	;file with NO wild
	LD	A,_ERR89	;'illegal I/O channel'
	RET			;Z = OK, NZ = A = error
;
;	$VALSIO - check for valid SIO channel
;
;	ENTRY	DE =>	DCB
;
;	EXIT	Z  =	OK, IX => DCB
;		NZ = 	A = error code
;
VALSIO	LD	A,(DE)		;get flags
	XOR	@BIT7		;device MUST be set
	AND	@BIT7+@BIT6+@BIT5
INVSIO	LD	A,_ERR89	;'illegal I/O channel'
	RET	NZ		;go if not!
;
;	check for device 3/4
;
	LD	A,(DE)		;fetch flags again
	AND	0FH		;get device #
	CP	3		;device 3 (@CA)?
	JR	Z,SIOOK		;go if OK
	CP	4		;device 4 (@CB)?
	JR	NZ,INVSIO	;invalid channel
;
SIOOK	LD	C,A		;pass device #
	LD	A,@LOCDEV	;SVC locdev
	RST	$SVC		;fetch device block
	RET	NZ		;go if error
;
;	check for baud rate in bounds
;
	LD	A,(IX+22)	;get word length
	CPL			;reverse bits
	AND	@BIT2+@BIT3	;word must be 8
	LD	A,_ERR36	;'channel not inited'
	RET			;return with flags
;
	PAGE
;
;	RECEIVE from channel to filespec
;
;	entry point
;
RECEIVE	LD	(STACK),SP	;setup for exit
	LD	BC,EXIT		;exit vector
	PUSH	BC		;leave on stack
;
	LD	BC,0000H	;NO parameters
	CALL	$EVAL		;evaluate input
	RET	NZ		;go if error
;
;	check for valid input
;
	LD	A,(IX+0)	;flags
	AND	1FH		;mask
	CP	0EH		;srce/dest/NOT mask/param
	LD	A,_ERR47	;missing parm
	RET	NZ		;go if error
;
RSEND1	LD	DE,SDCB		;source DCB
	CALL	VALSIO		;valid SIO channel?
	RET	NZ		;go if not!
;
	INC	DE		;bump to text
	LD	A,@OPEN		;open CL
	RST	$SVC		;open device
	RET	NZ		;go if error!
;
;**************************
;
;
;	inital stuff done, send inital ACK
;	setup timer waiting for LRL
;	echo, resend if NAK
;
	LD	B,_ACK		;initial ACK
	LD	A,@PUT		;send to CL
	RST	$SVC
	JR	NZ,ABORT	;error
	LD	BC,30		;seconds
	LD	HL,TIMER	;routine
	LD	A,@TIMER
	RST	$SVC
RECV2	LD	A,@GET		;get from CL
	RST	$SVC
	JR	NZ,RECV2	;not yet
	LD	A,B		;transfer
	LD	(RECVLRL),A	;save it
	LD	A,@PUT		;echo to CL
	RST	$SVC
	JR	NZ,ABORT	;error
RECV3	LD	A,@GET		;check for reply
	RST	$SVC
	JR	NZ,RECV3	;not yet
	LD	A,B		;transfer
	CP	_NAK		;bad
	JR	Z,RECV2		;try again
	CP	_ACK		;okay
	JR	NZ,RECV3	;wait
	LD	BC,0		;reset timer
	LD	HL,0
	LD	A,@TIMER
	RST	$SVC
;
;	OPEN file with new LRL
;
	LD	DE,DDCB		;file
	LD	HL,RECVT2	;open parm list/new LRL
	LD	A,@OPEN
	RST	$SVC
RECV4	LD	BC,30		;seconds
	LD	HL,TIMER	;routine
	LD	A,@TIMER
	RST	$SVC
	LD	DE,SDCB		;device
;
;	receive block
;
RECV5	LD	A,@GET
	RST	$SVC
	JR	NZ,RECV5	;not yet
	LD	A,B
	CP	_ETX		;done
	JP	Z,RECV12
	CP	_STX		;block follows
	JR	NZ,RECV5	;illegal
	LD	BC,0		;reset timer
	LD	HL,0
	LD	A,@TIMER
	RST	$SVC
RECV6	LD	HL,BUFF		;temp
	LD	A,(RECVLRL)	;get RL
	LD	B,A		;setup for loop
	XOR	A		;zero cksum
RECV7	PUSH	BC		;save RL
	PUSH	AF		;save cksum
	PUSH	HL		;save buff loc
	LD	BC,30		;seconds
	LD	HL,TIMER	;routine
	LD	A,@TIMER
	RST	$SVC
	POP	HL		;restore buff loc
RECV8	LD	A,@GET		;from CL
	RST	$SVC
	JR	NZ,RECV8	;none yet
	LD	A,B		;move
	LD	(HL),A		;store it
	POP	AF		;get back cksum
	ADD	A,B		;add current
	INC	HL		;next loc
	POP	BC		;get RL
	DJNZ	RECV7		;next
;
;	done block, get checksum, compare, reply
;
RECV9	LD	C,A		;cksum
	LD	A,@GET		;from CL
	RST	$SVC
	JR	NZ,RECV9	;not yet
	LD	A,B		;for compare
	CP	C		;to cksum
	JR	Z,RECV10	;match
	LD	B,_NAK		;bad
	LD	A,@PUT		;send to CL
	RST	$SVC
	JR	NZ,ABORT	;error
	JR	RECV6		;resend block
RECV10	LD	DE,DDCB		;file
	LD	HL,BUFF		;memory
	LD	A,(RECVLRL)	;RL
	LD	B,A		;setup for loop
RECV11	PUSH	BC		;save
	LD	B,(HL)		;get char
	LD	A,@PUT		;to file
	RST	$SVC
	JP	NZ,ABORT	;print error and exit
	INC	HL		;next loc
	POP	BC		;restore counter
	DJNZ	RECV11		;more
	LD	DE,SDCB		;CL
	LD	B,_ACK		;okay
	LD	A,@PUT		;send to CL
	RST	$SVC
	JR	NZ,ABORT	;error
	JR	RECV4		;next block
;
;	end of file
;
RECV12	LD	DE,DDCB		;close write file
	LD	A,@CLOSE
	RST	$SVC
	JR	NZ,ABORT	;error
	JP	GETOUT		;exit
;
	END
