SYS10  ;	sys10/asm
 MODI	EQU	0
 MODII	EQU	0
 MODIII	EQU	-1
 	ORG	5000H
 	AND	0F0H		;mask it out
 	CP	10H		;command 1
 	JR	Z,PREPARE	;initialize
 	CP	20H		;command 2
 	JP	Z,BACKUP	;disk backup
 	LD	A,47		;illegal command
 	JP	402AH		;abort command
 ABORT	LD	HL,ABMSG
 	CALL	4030H
 	JP	402DH		;back to menu
 PREPARE	CALL	4065H		;heading
 	LD	HL,PREMSG	;initializing message
 	CALL	4030H
 BAD0	LD	HL,DEST		;get dest drive
 	CALL	4030H
 	LD	B,1		;one key
 	CALL	4036H		;get input
 	JP	C,402DH		;abort
 	JR	Z,BAD0		;nothing
 	SUB	30H		;remove ascii
 	JR	C,BAD0
 	CP	4
 	JR	NC,BAD0		;invalid drive #
 	LD	(IY+36),A	;dest drive
 	SET	6,(IY+16)	;set system mount
 	CALL	4015H		;set it up
 	LD	A,(IY+18)	;get system drive
 	LD	(IY+35),A	;set as source for mount
 ASKDEN	LD	HL,DENMSG	;get density
 	CALL	4030H
 	LD	B,1		;one key
 	CALL	4036H		;from keyboard
 	JP	C,402DH		;back to menu
 	JR	Z,ASKDEN	;invalid
 	CALL	403FH		;convert U/C
 	CP	'D'		;double?
 	LD	B,80H		;set bit 7
 	JR	Z,ADEN
 	CP	'S'
 	JR	NZ,ASKDEN	;invalid input
 	LD	B,0
 ADEN	CALL	404DH		;get drive type
 	LD	A,(HL)		;get the byte
 	AND	7FH		;mask bit 7
 	OR	B		;set density
 	LD	(HL),A		;re-save new value
 ASKTKS	LD	HL,TRKMSG	;# tracks
 	CALL	4030H		;display it
 	LD	B,3
 	CALL	4036H
 	JP	C,402DH		;abort
 	JR	Z,ASKTKS	;nothing
 	CALL	@VALUE		;convert value
 	JR	C,ASKTKS	;invalid number
 	CALL	4045H		;get tracks
 	LD	(HL),C		;put in table
 	CALL	DMOUNT		;mount the disk
 	JP	NZ,402AH
 	CALL	FORMAT		;format the disk
 	JP	NZ,402AH	;error exit
 	LD	HL,INITMSG	;initializing message
 	CALL	4030H		;display it
 	CALL	ZBUFF		;zero the buffer
 	LD	HL,IDENT1	;identity mark
 	LD	DE,@BUFF
 	LD	BC,8		;8 byte string
 	LDIR			;move it
 	LD	HL,IDENT2
 	LD	BC,8
 	LDIR
 	LD	A,1
 	LD	(DE),A
 	INC	DE
 	XOR	A
 	LD	(DE),A
 	INC	DE
 	LD	HL,IDENT3	;invoicing
 	LD	BC,8
 	LDIR			;place in sector
 	LD	A,27		;track 20
 	LD	(DE),A		;invoice start
 	INC	DE
 	XOR	A		;sector 0
 	LD	(DE),A		;put here
 	INC	DE
 	LD	HL,IDENT4
 	LD	BC,8
 	LDIR
 	XOR	A
 	LD	(DE),A
 	INC	DE
 	INC	A
 	LD	(DE),A
 	INC	DE
 	LD	A,(IY+48)
 	CALL	ASCII
 	LD	(@BUFF+50H),BC
 	LD	(@BUFF+58H),BC
 	LD	A,(IY+49)
 	CALL	ASCII
 	LD	(@BUFF+53H),BC
 	LD	(@BUFF+5BH),BC
 	LD	A,(IY+50)
 	CALL	ASCII
 	LD	(@BUFF+56H),BC
 	LD	(@BUFF+5EH),BC
 	LD	A,'/'
 	LD	(@BUFF+52H),A
 	LD	(@BUFF+55H),A
 	LD	(@BUFF+5AH),A
 	LD	(@BUFF+5DH),A
 	CALL	4045H
 	LD	A,(HL)
 	LD	(@BUFF+0FFH),A
 	LD	DE,0		;write to track 0
 	LD	BC,@BUFF	;buffer
 	CALL	4024H		;disk output
 	JP	NZ,402AH	;error
 	CALL	ZBUFF		;zero again
 	LD	DE,1
 INITLP	LD	BC,@BUFF
 	CALL	4024H		;write sector
 	JP	NZ,402AH	;error
 	CALL	WFLICK
 	CALL	NEXSEC		;next sector
 	JR	NZ,INITLP	;this track
 	INC	D		;bump track
 	CALL	4045H		;get track count
 	LD	A,D		;get current
 	CP	(HL)		;at end yet?
 	JR	C,INITLP	;finish whole disk
 	CALL	DEFLICK
 	CALL	INVGAT		;make it
 	CALL	SHOWINV
 	LD	BC,@BUFF
 	LD	DE,1B00H
 	CALL	4024H		;write it out
 	JP	NZ,402AH	;error exit
 	CALL	RECGAT		;invoicing gat
 	CALL	SHOWREC
 	LD	BC,@BUFF
 	LD	DE,0100H	;track0, sector2
 	CALL	4024H		;write it
 	JP	NZ,402AH	;error
 	CALL	VERIFY		;verify the disk
 	JP	NZ,402AH	;error
 	LD	HL,PREFIN	;finished message
 	JP	EXIT		;done
 RECGAT	CALL	ZBUFF
 	LD	IX,@BUFF+0E0H	;where to build it
 	LD	(IX+1AH),80H	;128 byte records
 	LD	(IX+18H),1	;track data start
 	LD	(IX+17H),1	;sector data start
 	LD	(IX+14H),0
 	LD	(IX+15H),2
 	CALL	404DH		;get drive type
 	BIT	7,(HL)		;test
 	LD	HL,459		;396 single den
 	JR	Z,GATGO		;continue
 	LD	HL,867		;716 double den
 	JR	GATGO		;continue
 INVGAT	CALL	ZBUFF		;clear buffer
 	LD	IX,@BUFF+0E0H	;point to it
 	LD	(IX+1AH),40H	;64 byte records
 	LD	(IX+18H),27	;track data start
 	LD	(IX+17H),1	;sector data start
 	LD	(IX+14H),0
 	LD	(IX+15H),28
 	CALL	404DH		;get density
 	BIT	7,(HL)		;set = DD
 	LD	HL,459		;236 single density
 	JR	Z,GATGO
 	LD	HL,867		;428 double density
 GATGO	LD	(IX+1DH),L	;save # records
 	LD	(IX+1EH),H
 	CALL	4045H
 	LD	A,(HL)		;get track count
 	LD	(IX+1FH),A	;put in table
 	LD	A,(IY+48)	;get month
 	CALL	ASCII		;make it ascii
 	LD	(IX),C
 	LD	(IX+8H),C
 	LD	(IX+1H),B	;put in table
 	LD	(IX+9H),B
 	LD	A,(IY+49)	;get day
 	CALL	ASCII
 	LD	(IX+3H),C
 	LD	(IX+0BH),C
 	LD	(IX+4H),B
 	LD	(IX+0CH),B
 	LD	A,(IY+50)	;get year
 	CALL	ASCII
 	LD	(IX+6H),C
 	LD	(IX+0EH),C
 	LD	(IX+7H),B
 	LD	(IX+0FH),B
 	LD	(IX+2H),'/'
 	LD	(IX+5H),'/'
 	LD	(IX+0AH),'/'
 	LD	(IX+0DH),'/'
 	RET
 ASCII	PUSH	HL		;save it
 	CALL	ASCI		;convert
 	LD	H,B
 	PUSH	HL
 	LD	A,C		;get msb
 	SUB	30H		;remove ascii
 	CALL	ASCI		;convert
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET			;done
 ASCI	LD	C,'0'		;start
 ASCII1	SUB	10
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 @VALUE	LD	BC,0		;start number
 	EX	DE,HL		;DE => string
 VALLP	LD	A,(DE)		;get a byte
 	INC	DE		;point to next
 	CP	13		;terminator?
 	RET	Z		;done
 	CALL	CONV		;convert to binary
 	RET	C		;invalid
 	LD	H,B		;get value
 	LD	L,C
 	ADD	HL,HL		;*2
 	ADD	HL,HL		;*4
 	ADD	HL,BC		;*5
 	ADD	HL,HL		;*10
 	LD	C,A		;new number
 	LD	B,0
 	ADD	HL,BC		;add it
 	LD	B,H		;re-save result
 	LD	C,L
 	JR	VALLP		;continue
 CONV	SUB	30H		;remove ascii
 	RET	C
 	CP	10		;must be 0-9
 	CCF			;complement
 	RET			;C = non-number
 BACKUP	CALL	4065H		;heading
 	LD	HL,BAKMSG
 	CALL	4030H		;backup title
 BAD1	LD	HL,SRC		;source message
 	CALL	4030H
 	LD	B,1		;one key
 	CALL	4036H		;get it
 	JP	C,402DH		;reload menu
 	JP	Z,BAD1		;ask source again
 	SUB	30H		;remove ascii
 	JR	C,BAD1
 	CP	4		;check for good drive #
 	JR	NC,BAD1
 	LD	(IY+35),A	;save source drive
 BAD2	LD	HL,DEST		;dest message
 	CALL	4030H
 	LD	B,1
 	CALL	4036H
 	JP	C,402DH
 	JP	Z,BAD2
 	SUB	30H
 	JR	C,BAD2
 	CP	4
 	JR	NC,BAD2
 	LD	(IY+36),A
 	SET	6,(IY+16)	;system mount prompt
 	CALL	SMOUNT		;mount source disk
 	JP	NZ,402AH
 	LD	BC,@BUFF	;buffer
 	LD	DE,0		;read tk0,sect0
 	CALL	4021H		;read it
 	JP	NZ,402AH	;error exit
 	LD	HL,@BUFF
 	LD	DE,IDENT1
 	LD	B,8
 	CALL	4042H
 	JR	Z,DATBOK
 	LD	HL,NOTDISK
 	CALL	4030H
 	JP	402DH
 DATBOK	CALL	404DH		;get drive type
 	LD	A,(HL)		;get the byte
 	PUSH	AF		;save here a sec
 	CALL	4045H		;get track count
 	LD	A,(@BUFF+0FFH)
 	LD	(HL),A
 	PUSH	AF		;save this too
 	CALL	DMOUNT		;mount dest disk
 	JP	NZ,402AH
 	CALL	4045H
 	POP	AF		;track count
 	LD	(HL),A		;save it
 	CALL	ASCII		;convert
 	LD	(BTKS),BC	;to the string
 	CALL	404DH		;get drive type
 	LD	A,(HL)		;get it
 	AND	3		;low 2 bits only
 	LD	(HL),A		;re-store it
 	POP	AF		;get source type back
 	AND	0FCH		;all BUT 2 low bits
 	OR	(HL)		;create new drive type
 	LD	(HL),A		;re-save updated type
 	BIT	7,A		;double den?
 	LD	HL,DDMSG
 	JR	NZ,PUTDMSG
 	LD	HL,SDMSG
 PUTDMSG	LD	DE,BDEN
 	LD	BC,4
 	LDIR
 	LD	HL,TPMESG
 	CALL	4030H
 	CALL	FORMAT		;format the disk
 	JP	NZ,402AH	;error exit
 ;	CALL	VERIFY		;verify the disk
 ;	JP	NZ,402AH	;error exit
 	XOR	A		;perform the copy
 	LD	(IY+37),A	;start track number
 	LD	HL,COPMSG
 	CALL	4030H
 LOOP	CALL	SMOUNT		;source disk mount
 	JP	NZ,402AH
 	LD	D,(IY+37)	;get track
 	LD	E,0		;start sector
 	LD	BC,@BUFF	;buffer
 RDLOOP	CALL	4021H		;read sector
 	JP	NZ,402AH	;error exit
 	CALL	RFLICK
 	INC	B		;bump buffer
 	CALL	NEXSEC		;next sector
 	JR	NZ,RDLOOP	;finish this track
 	CALL	DMOUNT		;dest mount
 	JP	NZ,402AH
 	LD	BC,@BUFF
 WRLOOP	CALL	4024H		;write sector
 	JP	NZ,402AH	;error exit
 	CALL	WFLICK
 	INC	B
 	CALL	NEXSEC
 	JR	NZ,WRLOOP	;finish track
 	LD	A,(IY+37)	;get track
 	INC	A		;bump it
 	LD	(IY+37),A	;point to next
 	PUSH	AF		;save it
 	CALL	4045H		;get track count
 	POP	AF		;get it back
 	CP	(HL)		;at end yet
 	JP	C,LOOP		;finish it up
 	CALL	DEFLICK
 	CALL	VERIFY
 	JP	NZ,402AH
 	LD	HL,FINMSG	;finished
 EXIT	CALL	4030H
 	JP	402DH		;back to menu
 SMOUNT	LD	A,(IY+35)	;get source drive
 	CALL	4015H		;set it up
 	CALL	DRVSAME		;source/dest same?
 	JR	NZ,DOMNT
 	LD	A,(IY+35)	;get it back
 	ADD	A,30H		;make it ascii
 	LD	(SDRV),A	;put into string
 	LD	HL,SMSG		;source mount
 	CALL	4039H
 DOMNT	JP	403CH		;check status
 DMOUNT	LD	A,(IY+36)	;get dest drive
 	CALL	4015H
 	CALL	DRVSAME
 	JR	NZ,DOMNT
 	LD	A,(IY+36)
 	ADD	A,30H
 	LD	(DDRV),A
 	LD	HL,DMSG
 	JR	DOMNT-3
 DRVSAME	LD	A,(IY+35)
 	CP	(IY+36)		;compare source/dest
 	RET			;Z set if same
 NEXSEC	INC	E		;bump sector
 	CALL	404DH		;get type
 	BIT	7,(HL)		;NZ = double den
 	LD	A,10
 	JR	Z,HAVSEC
 	LD	A,18
 HAVSEC	SUB	E
 	RET	NZ		;not at end
 	LD	E,A		;restart and beginning
 	RET
 VERIFY	LD	HL,VERMSG
 	CALL	4030H		;verifying message
 	CALL	403CH		;check status
 	RET	NZ
 	LD	DE,0		;start with track 0
 VERLOOP	LD	BC,@BUFF	;I/O buffer
 	CALL	4021H		;read a sector
 	JP	NZ,DEFLICK
 	CALL	RFLICK
 	CALL	NEXSEC		;next sector
 	JR	NZ,VERLOOP	;finish this track
 	INC	D		;bump track
 	CALL	4045H		;get track count
 	LD	A,D		;get current track
 	CP	(HL)		;at end yet?
 	JR	C,VERLOOP	;not yet
 	CALL	DEFLICK
 	XOR	A
 	RET			;done
 FORMAT	CALL	403CH		;check status
 	RET	NZ		;not ready
 	CALL	4050H		;seek track 0
 	RET	NZ		;error already
 	CALL	404DH
 	LD	A,(HL)
 	PUSH	AF
 	LD	BC,@BUFF
 	LD	DE,0
 	CALL	4021H
 	EX	AF,AF'
 	CALL	404DH
 	POP	AF
 	LD	(HL),A
 	EX	AF,AF'
 	JR	NZ,FORMDO	;continue
 HASBD	LD	HL,HASMSG	;has data
 	CALL	4030H
 	LD	B,1
 	CALL	4036H
 	JP	C,402DH
 	JR	Z,HASBD
 	CALL	403FH
 	CP	'N'
 	JP	Z,402DH
 	CP	'Y'
 	JR	NZ,HASBD
 FORMDO	CALL	ZBUFF		;clear the buffer
 	LD	HL,FORMSG
 	CALL	4030H
 FORM	CALL	BUILD		;build track
 	CALL	WRITETR		;write the track
 	JP	NZ,DEFLICK
 	CALL	WFLICK
 	CALL	4045H		;get tracks
 	IF	MODI
 	LD	A,(37EDH)	;read FDC track
 	ENDIF
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 	INC	A
 	CP	(HL)		;end of disk?
 	JP	Z,DEFLICK
 	CALL	4053H		;stepin a track
 	JP	NZ,DEFLICK
 	JR	FORM
 ZBUFF	LD	HL,@BUFF	;buffer
 	LD	DE,@BUFF+1
 	LD	BC,0FFFH	;length
 	LD	(HL),0		;fill with 0's
 	LDIR			;move it
 	RET			;done
 BUILD	CALL	404DH		;drive type
 	BIT	7,(HL)		;NZ = double den
 	LD	HL,DOUBLE
 	LD	BC,DPATTERN	;double density pattern
 	JR	NZ,GOTBLD
 	LD	HL,SINGLE
 	LD	BC,SPATTERN
 GOTBLD	LD	(PATTUSE),BC	;save pattern
 	LD	C,(HL)		;get sector counter
 	INC	HL
 	LD	E,(HL)		;get sector order
 	INC	HL
 	LD	D,(HL)		;pointer
 	INC	HL
 	CALL	ORDNEW		;sector skewing
 	PUSH	DE		;save this
 	LD	DE,@BUFF	;format buffer
 	EX	DE,HL		;DE => table
 	CALL	MOVEIN		;move post index gap
 	LD	(DESVE),DE	;save for loop
 SECLP	CALL	MOVEIN		;pre-index gap
 	CALL	MOVEIN
 	LD	(HL),0FEH	;ID header
 	INC	HL
 	IF	MODI
 	LD	A,(37EDH)	;get track
 	ENDIF
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 	LD	(HL),A
 	INC	HL
 	LD	(HL),0
 	INC	HL
 	EX	(SP),HL
 	LD	A,(HL)		;sector number
 	INC	HL
 	EX	(SP),HL		;put it back
 	LD	(HL),A
 	INC	HL
 	LD	(HL),1		;length
 	INC	HL
 	LD	(HL),0F7H	;crc
 	INC	HL
 	CALL	MOVEIN		;post index gap
 	CALL	MOVEIN		;pre data gap
 	CALL	MOVEIN		;sync field
 	LD	(HL),0FBH	;data header
 	INC	HL
 	PUSH	DE
 	EX	DE,HL
 	LD	HL,0		;get data pattern
 PATTUSE	EQU	$-2
 	LD	B,16
 PATTPUT	PUSH	BC
 	PUSH	HL
 	LD	BC,16
 	LDIR
 	POP	HL
 	POP	BC
 	DJNZ	PATTPUT
 	EX	DE,HL
 	POP	DE
 	LD	(HL),0F7H
 	INC	HL
 	CALL	MOVEIN
 	LD	DE,0
 DESVE	EQU	$-2
 	DEC	C		;decrement sector cnt
 	JR	NZ,SECLP	;finish the track
 	INC	SP
 	INC	SP
 	DEC	DE
 	LD	A,(DE)
 	JP	FILL		;fill pre-index gap
 MOVEIN	LD	A,(DE)
 	LD	B,A
 	INC	DE
 	LD	A,(DE)
 	INC	DE
 FILL	LD	(HL),A
 	INC	HL
 	DJNZ	FILL
 	RET
 SINGLE	DB	10
 	DW	SORDER
 	DB	1FH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 	DB	3,0
 	DB	3,0
 	DB	0BH,0FFH
 DOUBLE	DB	18
 	DW	DORDER
 	DB	3EH,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 	DB	0CH,0
 	DB	3,0F5H
 	DB	16H,4EH
 SORDER	DB	0,5,1,6,2,7,3,8,4,9
 DORDER	DB	0,6,12,1,7,13,2,8,14
 	DB	3,9,15,4,10,16,5,11,17
 ORDNEW	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	EX	DE,HL
 	LD	B,4
 	DEC	C
 ORDNEW1	PUSH	BC
 	LD	A,(HL)
 	PUSH	HL
 	INC	HL
 ORDNEW2	LD	E,(HL)
 	LD	(HL),A
 	LD	A,E
 	INC	HL
 	DEC	C
 	JR	NZ,ORDNEW2
 	POP	HL
 	LD	(HL),A
 	POP	BC
 	DJNZ	ORDNEW1
 	POP	HL
 	POP	DE
 	POP	BC
 	RET
 SPATTERN
 	DB	0E5H,0E5H,0E5H,0E5H,0E5H,0E5H,0E5H,0E5H
 	DB	0E5H,0E5H,0E5H,0E5H,0E5H,0E5H,0E5H,0E5H
 DPATTERN
 	DB	06DH,0B6H,06DH,0B6H,06DH,0B6H,06DH,0B6H
 	DB	06DH,0B6H,06DH,0B6H,06DH,0B6H,06DH,0B6H
 WRITETR	LD	(IY+13),6	;retry counter
 	SET	7,(IY+16)	;set write I/O
 TRWLP	CALL	TRWRITE		;write track
 	RET	Z		;no error
 	EX	AF,AF'		;save error code
 	DEC	(IY+13)		;decrement counter
 	JR	NZ,TRWLP	;try again
 	EX	AF,AF'		;restore error code
 	RET			;back in error
 TRWRITE	CALL	4056H		;select drive
 	RET	NZ		;dropped ready
 	IF	MODI
 	LD	A,(37ECH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F0H)
 	ENDIF
 	AND	40H
 	LD	A,15
 	RET	NZ		;write protected
 	IF	MODIII
 	CALL	SETNMI		;setup NMI
 	LD	A,0F4H
 	OUT	(0F0H),A	;give write track
 	CALL	DSKSLO
 W1	LD	A,E
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	B
 	JP	PO,W1
 	OUTI
 W2	LD	A,E
 	OUT	(0F4H),A
 	IN	A,(0F0H)
 	AND	D
 	JR	Z,W2
 	OUTI
 	LD	A,E
 W3	OUT	(0F4H),A
 	OUTI
 	JP	W3
 SETNMI	CALL	405CH		;setup density
 	LD	HL,RETNMI	;return vector
 	LD	(404AH),HL	;where it goes
 	LD	HL,@BUFF	;data buffer
 	DI
 	LD	A,0C0H
 	OUT	(0E4H),A	;enable NMI
 	LD	DE,240H
 	LD	A,(IY+14)	;get drive bit
 	OR	E		;set wait states
 	LD	E,A		;save it here
 	LD	BC,3F3H		;transfer port/mask
 	IN	A,(0F0H)
 	RET
 RETNMI	POP	HL
 	XOR	A
 	OUT	(0E4H),A	;disable NMI
 	LD	HL,4059H	;RETN
 	LD	(404AH),HL	;normal vector
 	IN	A,(0F0H)	;read status
 	PUSH	AF		;save it
 	LD	A,0D0H
 	OUT	(0F0H),A	;force interrupt
 	POP	AF		;have it back
 	ENDIF
 	IF	MODI
 	CALL	405CH
 	LD	HL,37ECH
 	LD	DE,37EFH
 	LD	BC,@BUFF	;data address
 	DI
 	LD	(HL),0F4H	;write track command
 	CALL	DSKSLO
 	LD	A,(BC)
 WX1	BIT	7,(HL)
 	JR	NZ,WX5
 	BIT	1,(HL)
 	JR	Z,WX1
 	LD	(DE),A
 	INC	BC
 	LD	A,(BC)
 WX2	BIT	1,(HL)
 	JR	Z,WX2
 WX3	LD	(DE),A
 	INC	BC
 	LD	A,(BC)
 WX4	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	1,(HL)
 	JR	NZ,WX3
 	BIT	0,(HL)
 	JR	NZ,WX4
 WX5	LD	A,(HL)
 	LD	(HL),0D0H
 	ENDIF
 	AND	0FCH		;error mask
 	EI
 	RET	Z		;OK, done
 	LD	L,A		;save here for test
 	LD	A,8
 	BIT	7,L
 	RET	NZ
 	LD	A,15
 	BIT	6,L
 	RET	NZ
 	LD	A,14
 	BIT	5,L
 	RET	NZ
 	LD	A,13
 	BIT	4,L
 	RET	NZ
 	LD	A,12
 	BIT	3,L
 	RET	NZ
 	LD	A,11
 	BIT	2,L
 	RET	NZ
 	LD	A,63
 	OR	A
 	RET
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 SHOWINV	LD	DE,INVMSG
 	CALL	PUTNUMBER
 	LD	HL,INVMSG-1
 	JP	4030H
 SHOWREC	LD	DE,RECMSG
 	CALL	PUTNUMBER
 	LD	HL,RECMSG
 	JP	4030H
 PUTNUMBER	LD	HL,(@BUFF+0FDH)
 	LD	(DEPUT),DE
 	LD	DE,TENTBL
 A4B7B	LD	A,(DE)
 	LD	C,A
 	INC	DE
 	LD	A,(DE)
 	LD	B,A
 	INC	DE
 	PUSH	DE
 	LD	A,2FH
 A4B84	INC	A
 	LD	D,H
 	LD	E,L
 	ADD	HL,BC
 	JR	C,A4B84
 	EX	DE,HL
 	LD	DE,0
 DEPUT	EQU	$-2
 	LD	(DE),A
 	INC	DE
 	LD	(DEPUT),DE
 	POP	DE
 	INC	C
 	JR	NZ,A4B7B
 	RET
 RFLICK	PUSH	AF
 	LD	A,0AH
 	JR	DOFLICK
 WFLICK	PUSH	AF
 	LD	A,3
 DOFLICK	LD	(FLICK1),A
 	LD	(FLICK2),A
 	PUSH	HL
 	PUSH	BC
 	LD	L,(IY+19)
 	LD	H,(IY+20)
 	LD	A,(HL)
 	XOR	0
 FLICK1	EQU	$-1
 	LD	(HL),A
 	INC	HL
 	IF	MODI
 	LD	A,(37EDH)
 	ENDIF
 	IF	MODIII
 	IN	A,(0F1H)
 	ENDIF
 	CALL	ASCII
 	LD	(HL),C
 	INC	HL
 	LD	(HL),B
 	INC	HL
 	LD	A,(HL)
 	XOR	0
 FLICK2	EQU	$-1
 	LD	(HL),A
 	CALL	4018H
 	CP	1
 	JP	Z,ABORT
 	CP	2
 	JP	Z,ABORT
 	POP	BC
 	POP	HL
 	POP	AF
 	RET
 DEFLICK	PUSH	HL
 	LD	L,(IY+19)
 	LD	H,(IY+20)
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	POP	HL
 	RET
 ;##
 ABMSG	DB	10,'** Routine Aborted **',13
 NOTDISK	DB	10,'Source is NOT a POWER-TECH data disk !',13
 TPMESG	DB	10,'Copying '
 BTKS	DB	'xx Tracks in '
 BDEN	DB	'xxxxle Density.',13
 SDMSG	DB	'Sing'
 DDMSG	DB	'Doub'
 TENTBL	DW	-10000,-1000,-100,-10,-1
 	DB	10
 INVMSG	DB	'00000 Invoice Records Available.',13
 RECMSG	DB	'00000 Customer Records Available.',3
 HASMSG	DB	10,'Diskette HAS DATA!  Continue ? ',3
 IDENT1	DB	'POWERTC*'
 IDENT2	DB	'RECEIVE*'
 IDENT3	DB	'INVOICE*'
 IDENT4	DB	'TAXTABL*'
 TRKMSG	DB	10,'Track Count ? ',3
 DENMSG	DB	10,'S>ingle or D>ouble density ? ',3
 BAKMSG	DB	'- Disk Backup Utility -',10,10,13
 PREMSG	DB	'- Disk Initialization Utility -',10,10,13
 INITMSG	DB	10,'Initializing. ',3
 SRC	DB	10,'Source Drive ? ',3
 DEST	DB	10,'Destination Drive ? ',3
 FINMSG	DB	10,10,'* Backup Complete *',13
 PREFIN	DB	10,10,'* Initialization Complete *',10
 	DB	'Run "Gen Info F/M" and "Taxtable F/M" to complete disk.',13
 SMSG	DB	1DH,1EH,'Mount SOURCE Disk on Drive '
 SDRV	DB	'x.',3
 DMSG	DB	1DH,1EH,'Mount DESTINATION Disk on Drive '
 DDRV	DB	'x.',3
 FORMSG	DB	10,'Formatting. ',3
 COPMSG	DB	10,'Copying. ',3
 VERMSG	DB	10,'Verifying. ',3
 DBUFF	EQU	$&0FF00H
 @BUFF	EQU	DBUFF+100H
 	END	5000H
