; u2mx80/asm - kjw/bqsd - 03/82
;
	ORG	5200H
;
@DSP	EQU	33H		;char to video
@DISP	EQU	4467H		;string to video
@TOP1	EQU	4049H		;topmem mod I
@TOP3	EQU	4411H		;topmem mod III
@ABORT	EQU	4030H		;dos abort vector
;
;	program entry
;
	PUSH	HL		;save input pointer
	LD	(DCB),DE	;save device DCB pointer
	LD	HL,HELLO	;sign-on message
	CALL	@DISP		;display it
	LD	HL,@TOP3	;topmem mod III
	LD	A,(4)		;read ROM
	CP	30H		;mod III?
	JR	Z,HTOP		;yes, go!
	LD	HL,@TOP1	;topmem mod I
HTOP	LD	(TOP1),HL	;save topmem pointer
	LD	(TOP2),HL	;need it here too
	POP	HL		;restore input pointer
;
	LD	DE,(DCB)	;fetch device DCB
	LD	A,(DE)		;get first byte
	AND	2		;output device?
	JR	NZ,ENTRY	;yes, continue
;
	LD	HL,NOTOUT	;can't filter input
	CALL	@DISP		;display it
	JR	ABORT		;abort program
;
ENTRY	LD	A,(HL)		;get user input
	INC	HL		;look to next one
	CP	'?'		;requesting 'who' ?
	JR	NZ,NOTHIN	;nope, continue
;
	PUSH	HL		;save input
	CALL	SHOWWHO		;display author
	POP	HL		;restore input
	JR	ENTRY		;continue
;
ABORT	LD	HL,PARERR	;param error
	CALL	@DISP		;display it
	JP	@ABORT		;go dos abort exit
;
NOTHIN	LD	HL,0		;get topmem
TOP1	EQU	$-2
GOTNOT	LD	BC,LAST-FIRST	;program length
	OR	A		;clear carry flag
	SBC	HL,BC		;get length
	PUSH	HL		;save it
	DEC	HL		;reduce by 1
	LD	(0),HL		;resave new topmem
TOP2	EQU	$-2
	POP	DE		;get where to move to
	LD	HL,DRIVER	;where driver is
	PUSH	BC		;save length
	PUSH	DE		;save dest
	PUSH	HL		;save start
	EX	DE,HL		;DE = start
	OR	A		;clear carry
	SBC	HL,DE		;compute offset
	EX	DE,HL		;DE = offset
;
	LD	IX,0		;get DCB again
DCB	EQU	$-2
	LD	L,(IX+1)	;LSB driver
	LD	H,(IX+2)	;MSB driver
	LD	(CALL),HL	;save old vector
	LD	HL,DRIVER	;new driver
	ADD	HL,DE		;add offset
	DI			;disable for DCB change
	LD	(IX+1),L	;LSB driver
	LD	(IX+2),H	;MSB driver
	POP	HL		;restore pointers
	POP	DE
	POP	BC
	LDIR			;move program to topmem
	EI			;installed, can enable
	RET			;done, driver active
;
PARERR	DEFM	'Parameter Error !'
	DEFB	13
;
NOTOUT	DEFM	'Cannot Filter INPUT Device !'
	DEFB	13
;
HELLO	DEFB	1CH,1FH
	DEFM	'PMX80 - MX80 Printer Filter for LD0S - '
	DEFM	'Version 2.1'
	DEFB	10
	DEFM	'by Kim Watt - '
	DEFM	'(c)(p) Copyright 1982 '
	DEFM	'Breeze/QSD, Inc.'
	DEFB	10
	DEFB	10
	DEFB	13
;
WHOMSG	DEFB	93H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,093H
	DEFB	0B3H,0B9H,0C9H,0EBH,0F6H,0FEH,0EBH,0F8H
;
	DEFB	0F4H,0B9H,0FBH,0E0H,0B9H,0D2H,0F0H,0F4H
	DEFB	0B9H,0CEH,0F8H,0EDH,0EDH,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B1H,0FAH
	DEFB	0B0H,0B1H,0E9H,0B0H,0B9H,0A8H,0A0H,0A1H
;
	DEFB	0ABH,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0DBH,0EBH,0FCH,0FCH
;
	DEFB	0E3H,0FCH,0B6H,0C8H,0CAH,0DDH,0B5H,0B9H
	DEFB	0D0H,0F7H,0FAH,0B7H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0A8H,0A8H,0ACH,0A9H,0A9H,0B9H
	DEFB	0CAH,0EDH,0FCH,0F4H,0F4H,0F6H,0F7H,0EAH
;
	DEFB	0B9H,0DFH,0EEH,0E0H,0B7H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0CAH
;
	DEFB	0ECH,0F0H,0EDH,0FCH,0B9H,0A8H,0ABH,0ACH
	DEFB	0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0DDH,0F8H,0F5H,0F5H,0F8H,0EAH
	DEFB	0B5H,0B9H,0CDH,0FCH,0E1H,0F8H,0EAH,0B9H
;
	DEFB	0AEH,0ACH,0ABH,0ABH,0A0H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0B1H,0ABH,0A8H,0ADH
;
	DEFB	0B0H,0B9H,0ADH,0A1H,0ADH,0B4H,0A0H,0ADH
	DEFB	0ABH,0A1H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,094H
	DEFB	93H
	DEFB	99H
;
;
SHOWWHO	LD	HL,WHOMSG	;encoded text
;
WHOLP	LD	A,(HL)		;fetch a character
	INC	HL		;bump pointer
	XOR	99H		;decrypt it
	RET	Z		;terminator, done!
	CALL	@DSP		;else display char
	JR	WHOLP		;continue
;
;	actual printer driver moved to topmem
;
FIRST	DEFB	0
;
DRIVER	PUSH	AF		;save flags
	LD	A,C		;get character
	BIT	7,A		;graphics char?
	JR	Z,SKIP		;nope, continue
	RES	6,A		;turn off bit 6
	ADD	A,20H		;adjust for MX80
	LD	C,A		;C = new char
SKIP	POP	AF		;restore flags
	JP	0		;go old driver!
CALL	EQU	$-2
;
LAST	DEFB	0
;
	END	5200H
