;  u3phelp/asm
	ORG	5200H
	PUSH	HL
	LD	HL,HELLO
	CALL	@DISPLY
	POP	HL
SCAN	CALL	POSHL
	JP	C,SHOWEM
	CP	'?'
	JP	Z,SHOWHELP
	CP	'!'
	JR	Z,SHOWME
	CP	'*'
	JR	NZ,CHECKIT
	XOR	A
	LD	(DUAL),A
	INC	HL
	JR	SCAN
SHOWME	CALL	SHOWWHO
	JP	DRAIN
CHECKIT	LD	DE,LIBRARY
	LD	B,1
	CALL	FIND
	JR	NZ,GOTCMD
	LD	DE,UTILITY
	CALL	FIND
	JR	NZ,GOTCMD
	LD	DE,OTHERS
	CALL	FIND
	JR	Z,NOTLIB
GOTCMD	CP	1
	JR	Z,ALL
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,LOOKUP-4	;point to table
	ADD	HL,BC
	LD	A,(HL)		;get command #
	INC	HL
	LD	H,(HL)
	LD	L,A
DODISPLY
	PUSH	HL
	CALL	@DISPLY
	POP	HL
	PUSH	DE
	CALL	@KBD
	POP	DE
	OR	A
	JR	Z,DUAL
	CP	1
	JP	Z,ABORT
	CP	'`'
	JR	NZ,DUAL
PAUWT	PUSH	DE
	CALL	@KBD
	POP	DE
	OR	A
	JR	Z,PAUWT
	CP	1
	JP	Z,ABORT
DUAL	RET
	JP	@PRINT
SHOWHELP
	LD	HL,HELPMSG
	JP	DODISPLY
ABORT	LD	HL,ABMSG
	CALL	@DISPLY
DRAIN	CALL	@KBD
	OR	A
	JR	NZ,DRAIN
	JP	402DH
ALL	LD	IY,LOOKUP
SHOWALL	LD	L,(IY)
	INC	IY
	LD	H,(IY)
	INC	IY
	LD	A,H
	OR	L
	RET	Z
	PUSH	IY
	CALL	DODISPLY
	LD	A,10
	CALL	VOUT
	CALL	VOUT
	POP	IY
	JR	SHOWALL
@DISPLY	EQU	4467H
@PRINT	EQU	446AH
@DSP	EQU	33H
@PRT	EQU	3BH
@KBD	EQU	2BH
NOTLIB	LD	HL,NOTMSG
	CALL	@DISPLY
	JP	SHOWEM
LOOKUP
;	HELP COMMAND LOOK UP TABLE
	DW	APPEND
	DW	ATTRIB
	DW	AUTO
	DW	BOOT
	DW	BUILD
	DW	CLOCK
	DW	COPY
	DW	CREATE
	DW	DATE
	DW	DEBUG
	DW	DEVICE
	DW	DIR
	DW	DO
	DW	DUMP
	DW	FILTER
	DW	FREE
	DW	KILL
	DW	LIB
	DW	LINK
	DW	LIST
	DW	LOAD
	DW	MEMORY
	DW	PURGE
	DW	RENAME
	DW	RESET
	DW	ROUTE
	DW	RUN
	DW	SET
	DW	SPOOL
	DW	SYSTEM
	DW	TIME
	DW	TRACE
	DW	VERIFY
	DW	LBASIC
	DW	FORMAT
	DW	BACKUP
	DW	CONV
	DW	PATCH
	DW	REPAIR
	DW	WHO
	DW	HELP
	DW	KIM
	DW	DENNIS
	DW	BILL
	DW	ROY
	DW	LDOS
	DW	LSI
	DW	NEWDOS
	DW	TRSDOS
	DW	HOW
	DW	0
LIBRARY
;  HIGH BIT OF FIRST BYTE MUST BE SET
	DB	'A'+80H,'ll'
	DB	'A'+80H,'ppend'
	DB	'A'+80H,'ttrib'
	DB	'A'+80H,'uto'
	DB	'B'+80H,'oot'
	DB	'B'+80H,'uild'
	DB	'C'+80H,'lock'
	DB	'C'+80H,'opy'
	DB	'C'+80H,'reate'
	DB	'D'+80H,'ate'
	DB	'D'+80H,'ebug'
	DB	'D'+80H,'evice'
	DB	'D'+80H,'ir'
	DB	'D'+80H,'o'
	DB	'D'+80H,'ump'
	DB	'F'+80H,'ilter'
	DB	'F'+80H,'ree'
	DB	'K'+80H,'ill'
	DB	'L'+80H,'ib'
	DB	'L'+80H,'ink'
	DB	'L'+80H,'ist'
	DB	'L'+80H,'oad'
	DB	'M'+80H,'emory'
	DB	'P'+80H,'urge'
	DB	'R'+80H,'ename'
	DB	'R'+80H,'eset'
	DB	'R'+80H,'oute'
	DB	'R'+80H,'un'
	DB	'S'+80H,'et'
	DB	'S'+80H,'pool'
	DB	'S'+80H,'ystem'
	DB	'T'+80H,'ime'
	DB	'T'+80H,'race'
	DB	'V'+80H,'erify'
	DB	80H
UTILITY
	DB	'L'+80H,'basic'
	DB	'F'+80H,'ormat'
	DB	'B'+80H,'ackup'
	DB	'C'+80H,'onv'
	DB	'P'+80H,'atch'
	DB	'R'+80H,'epair'
	DB	80H
OTHERS	DB	'W'+80H,'ho'
	DB	'H'+80H,'elp'
	DB	'K'+80H,'im'
	DB	'D'+80H,'ennis'
	DB	'B'+80H,'ill'
	DB	'R'+80H,'oy'
	DB	'L'+80H,'dos'
	DB	'L'+80H,'si'
	DB	'N'+80H,'ewdos'
	DB	'T'+80H,'rsdos'
	DB	'H'+80H,'ow'
	DB	80H
SHOWEM	LD	HL,LIBMSG
	CALL	DODISPLY
	LD	DE,LIBRARY
	CALL	LI2
	LD	HL,UTILMSG
	CALL	DODISPLY
	LD	DE,UTILITY
LI2	LD	C,6		;B=LEN, C=PER LINE
LI3	LD	B,0AH
	LD	A,(DE)		;GET FIRST BYTE
	AND	7FH		;REMOVE HIGH BIT
	JR	NZ,LIBLP2		;DONE
	RET
;	LD	A,0DH
;	JP	VOUT
LIBLP2	CALL	VOUT		;TO DISPLAY
	INC	DE		;NEXT
	DEC	B
	LD	A,(DE)		;NEXT BYTE
	BIT	7,A		;HIGH BIT SET ?
	JR	Z,LIBLP2	;CONTINUE IF NOT
	DEC	C
	JR	Z,NXTLIN
	LD	A,20H
LPE	CALL	VOUT
	DJNZ	LPE
	JR	LI3
NXTLIN	LD	A,0DH
	CALL	VOUT
	JR	LI2
FIND	LD	A,(DE)
	INC	DE
	BIT	7,A
	JR	Z,FIND
	AND	7FH
	RET	Z
	CALL	UCASE
	LD	C,A
	LD	A,(HL)
	CALL	UCASE
	CP	C
	PUSH	HL
	JR	NZ,CMDEND
	INC	HL
	LD	A,(HL)
	CP	13
	JR	Z,HAVCNT
FINLP1	LD	A,(DE)
	BIT	7,A
	JR	NZ,CMDEN
	CALL	UCASE
	LD	C,A
	LD	A,(HL)
	CP	13
	JR	Z,HAVCNT
	CALL	UCASE
	CP	C
	JR	NZ,CMDEND
	INC	DE
	INC	HL
	JR	FINLP1
CMDEN	LD	A,(HL)
	CP	13
	JR	Z,HAVCNT
CMDEND	POP	HL
	INC	B
	JR	FIND
HAVCNT	LD	A,B
	OR	A
	POP	HL
	RET
	INC	HL
POSHL	LD	A,(HL)
	CP	','
	JR	Z,POSHL-1
	CP	20H
	JR	Z,POSHL-1
	CP	13
	SCF
	RET	Z
	OR	A
	RET
VOUT	PUSH	DE
	CALL	@DSP
	POP	DE
	PUSH	AF
	LD	A,(DUAL)
	OR	A
	JR	NZ,VDONE
	POP	AF
	PUSH	AF
	PUSH	DE
	CALL	@PRT
	POP	DE
VDONE	POP	AF
	RET
UCASE	CP	'a'
	RET	C
	CP	'z'+1
	RET	NC
	AND	5FH
	RET
WHOMSG
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,093H
	DB	0B3H,0B9H,0C9H,0EBH,0F6H,0FEH,0EBH,0F8H
;
	DB	0F4H,0B9H,0FBH,0E0H,0B9H,0D2H,0F0H,0F4H
	DB	0B9H,0CEH,0F8H,0EDH,0EDH,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B1H,0FAH
	DB	0B0H,0B1H,0E9H,0B0H,0B9H,0A8H,0A0H,0A1H
;
	DB	0ABH,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0DBH,0EBH,0FCH,0FCH
;
	DB	0E3H,0FCH,0B6H,0C8H,0CAH,0DDH,0B5H,0B9H
	DB	0D0H,0F7H,0FAH,0B7H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0A8H,0A8H,0ACH,0A9H,0A9H,0B9H
	DB	0CAH,0EDH,0FCH,0F4H,0F4H,0F6H,0F7H,0EAH
;
	DB	0B9H,0DFH,0EEH,0E0H,0B7H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0CAH
;
	DB	0ECH,0F0H,0EDH,0FCH,0B9H,0A8H,0ABH,0ACH
	DB	0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0DDH,0F8H,0F5H,0F5H,0F8H,0EAH
	DB	0B5H,0B9H,0CDH,0FCH,0E1H,0F8H,0EAH,0B9H
;
	DB	0AEH,0ACH,0ABH,0ABH,0A0H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B1H,0ABH,0A8H,0ADH
;
	DB	0B0H,0B9H,0ADH,0A1H,0ADH,0B4H,0A0H,0ADH
	DB	0ABH,0A1H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,094H
	DB	99H
SHOWWHO	LD	HL,WHOMSG
WHOLP	LD	A,(HL)
	INC	HL
	XOR	99H
	RET	Z
	CALL	@DSP
	JR	WHOLP
;##
KIM	DB	'KIM',10
	DB	'accepts phone calls ONLY from:',10
	DB	'3pm-5pm CST Monday, Wednesday, and Friday',13
HELP	DB	'HELP',10
	DB	'Try Examining Things.',13
LDOS	DB	'LDOS',10
	DB	'is a trademark of Logical Systems Inc.',10
	DB	'be sure to keep it updated',13
LSI	DB	'LSI',10
	DB	'Logical Systems Incorporated',10
	DB	'11520 N. Port Washington Road',10
	DB	'Mequon, Wisconsin  53092',10
	DB	'(414) 241-8030',13
HOW	DB	'Try pressing the keys !',13
NEWDOS	DB	'I refuse',13
TRSDOS	DB	'Get LDOS dummy !',13
ROY	DB	'R0Y S0LT0FF',10
	DB	'Personal thanks to Roy for his expertise and consultations',13
BILL	DB	'Bill Schroeder',10
	DB	'Personal thanks to Bill for his continuing support',13
DENNIS	DB	'Dennis Brent',10
	DB	'President Breeze/QSD, Inc.',10
	DB	'11500 Stemmons Fwy. - Suite 125',10
	DB	'Dallas, Texas  75229',10
	DB	'(214) 484-2976',13
HELPMSG	DB	'PHELP,*',10
	DB	'displays list of commands help is available for',10
	DB	'(* is optional in all commands and sends output to printer)',10
	DB	'PHELP,*,?',10
	DB	'displays this list',10
	DB	'PHELP,*,command',10
	DB	'displays syntax for associated command',13
ABMSG	DB	'Power Help * Aborted *',13
HELLO	DB	1CH,1FH
	DB	'PHELP - Help Utility for LDOS - Version 2.1',10
	DB	'by Kim Watt - (c)(p) Copyright 1982 Breeze/QSD, Inc.',10,13
LIBMSG	DB	'Library Commands:',13
UTILMSG	DB	10,'Utilities:',13
NOTMSG	DB	10,'The Following Commands Are Available:',13
;
APPEND	DB	'APPEND fspec/devspec to fspec (param,param)',10
	DB	'ECHO = echo characters to screen when copying to a devspec',10
	DB	'STRIP = backspace old file 1 byte before appending (SCRIPSIT)',10,10
	DB	'Copies the contents of one file onto the end of another',10
	DB	'or copies a filespec to a devspec',13
ATTRIB	DB	'ATTRIB filespec.password:d (ACC=a,UPD=b,PROT=c,VIS/INV) or:',10
	DB	'ATTRIB :d (LOCK,UNLOCK,MPW="aaa",NAME="bbb",PW="cc"',10
	DB	'ACC = access password       UPD = update password',10
	DB	'PROT = protection level - EXEC,READ,WRIT,NAME,KILL,FULL, or ALL',10
	DB	'VIS/INV = visible or invisible',10
	DB	'LOCK = assigns disk MPW to all visible files',10
	DB	'UNLOCK = removes access and update passwords from visible files',10
	DB	'MPW = Disk password        PW = New disk password',10
	DB	'NAME = New disk name',13
AUTO	DB	'AUTO * dos-command',10
	DB	'"*" is optional and will disable the ability of <ENTER> to',10
	DB	'override the AUTO command.  AUTO without argument will',10
	DB	'erase the previous auto command.',13
BOOT	DB	'BOOT	<CLEAR> <ENTER> <D> <UP ARROW>',10
	DB	'Holding down the following keys while booting will:',10
	DB	'<CLEAR> no SYSGENed configuration will be loaded',10
	DB	'<ENTER> no breakable AUTO command will be executed',10
	DB	'<D> Debug will be entered, no SYSGEN loaded',10
	DB	'<UP ARROW> disable keyboard debounce & key repeat',13
BUILD	DB	'BUILD fspec (HEX,APPEND)',10
	DB	'HEX = optional parameter allowing packed hex format',10
	DB	'APPEND = append to the end of existing file',13
CLOCK	DB	'CLOCK (ON) or CLOCK (OFF) sets clock display',10
	DB	'ON or OFF in upper right of screen.  Default = ON',10
	DB	'The clock may also be turned on and off by the simultaneous',10
	DB	'depression of <CLEAR> <SHIFT> and <C> if Minidos/flt is active',13
COPY	DB	'COPY fspec1 <TO> fspec2 (LRL=nnn,CLONE)',10
	DB	'COPY fspec1 <TO> partspec (LRL=nnn,CLONE)',10
	DB	'COPY fspec1 <TO> :d (LRL=nnn,CLONE)',10
	DB	'COPY devspec <TO> fspec (LRL=nnn,CLONE,ECHO)',10
	DB	'COPY devspec <TO> devspec (ECHO)',10
	DB	'COPY fspec <TO> devspec',10
	DB	'LRL = logical record length.  CLONE copies attributes also',10
	DB	'ECHO = echoes characters to screen if copy from devspec',13
CREATE	DB	'CREATE fspec (LRL=nnn,REC=nnnn,SIZE=nnnn)',10
	DB	'LRL = logical record length default=256',10
	DB	'REC = number of records to be allocated',10
	DB	'SIZE = # of Kbytes to be allocated',10
	DB	'SIZE & LRL should not be used together',13
DEBUG	DB	'DEBUG (switch,EXT)',10
	DB	'switch = ON or OFF.  ON is assumed',10
	DB	'EXT turns on the extended debugger',13
DEVICE	DB	'DEVICE',10
	DB	'Displays the density, number of sides, number of cylinders',10
	DB	'step rate, and power on delay of the disks mounted in the',10
	DB	'drives at the time this command is given, or the last',10
	DB	'mounted disk if the drive is empty or non-existent',10
	DB	'Also shows the devices currently in use and their routing',10
	DB	'*KI = KEYBOARD	         *DO = DISPLAY OUTPUT',10
	DB	'*PR = PRINTER          *JL = JOBLOG',10
	DB	'*SI = SOURCE INPUT     *LO = LISTING OUTPUT',10
	DB	'*CL = RS232 LINE       *UD = USER DEFINED DEVICE',10
	DB	'Also shows SYSTEM options and resident /SYS modules',3
DIR	DB	'DIR :d (A,I,S,P,N,MOD)     DIR fspec:d (A,I,S,P,N,SORT=Y/N)',10
	DB	'DIR partspec:d (A,I,S,P,N,DATE=)',10
	DB	'$ = substitute for unknown character in fspec or partspec',10
	DB	'A = full allocation format    I = invisible files also',10
	DB	'DATE = "M1/D1/Y1-M2/D2/Y2" displays range of dates',10
	DB	'S = display /SYS files     P = printer output also',10
	DB	'SORT=Y/N = turn sorted directory on or off',10
	DB	'N = non-stop display mode (assumed with "P")',10
	DB	'Example: DIR /CMD:1 displays directory of all /CMD files',13
DO	DB	'DO character fspec (@LABEL,param,param...);',10
	DB	'character = optional "$", "=", or "*"',10
	DB	'$ = compile phase only, no execute',10
	DB	'= = skip compile - go directly to execute',10
	DB	'* = re-run the last DO command that was compiled',10
	DB	'@LABEL = optional label indicating start point in /JCL file',10
	DB	'param = optional parameters to be pased to the fspec during',10
	DB	'execution',10
	DB	'; = Optional semicolon allows DO command line to be longer',10
	DB	'than 64 characters',13
DUMP	DB	'DUMP fspec (START=,END=,TRA=,ASCII,ETX=)',10
	DB	'fspec is any valid filespec.  Default extension is /CIM',10
	DB	'START = starting address of memory block',10
	DB	'END = ending address of memory block',10
	DB	'TRA = transfer address or entry point',10
	DB	'ASCII = optional parameter for ascii dump',10
	DB	'ETX = optional end of text marker',13
FILTER	DB	'FILTER devspec <USING> fspec (param,param...)',10
	DB	'devspec = any valid LDOS device',10
	DB	'fspec = filespec of filter program.  /FLT is assumed',10
	DB	'param = optional parameters for the fspec program',13
FREE	DB	'FREE (P)      FREE :d',10
	DB	'Display used and available space on each diskette',10
	DB	'(P) Optional parameter to send display to printer',10
	DB	':d = FREE given with drivespec will display a free space map',13
KILL	DB	'KILL fspec   or KILL devspec',10
	DB	'Deletes directory entry for fspec effectively killing file',10
	DB	'Deletes devspec from device control block effectively',10
	DB	'removing the device.  *DO, *JL, *LO, *KI, *PR, and *SI',10
	DB	'may NOT be killed',13
LIB	DB	'LIB',10
	DB	'Displays LDOS command library',10
	DB	'<A> is contained within SYS6 and <B> is contained within SYS7',10
	DB	'HELP command works for these and selected Utilities',13
LINK	DB	'LINK devspec1 <TO> devspec2',10
	DB	'This command links together multiple logical I/O devices',10
	DB	'For example, LINK *PR *DO echoes the printer to the screen',13
LIST	DB	'LIST fspec (NUM,HEX,TAB,P,LINE=aa,REC=bb,LRL=cc)',10
	DB	'NUM = sets line numbering mode for ASCII text',10
	DB	'HEX = sets HEXadecimal format output',10
	DB	'TAB = sets tab expansion for ASCII text',10
	DB	'P = directs output to the printer',10
	DB	'aa = line in text file where ASCII list is to begin',10
	DB	'bb = record number where HEX list is to begin',10
	DB	'cc = logical record length to be used to display HEX list',13
LOAD	DB	'LOAD (X) fspec',10
	DB	'(X) is an optional parameter for loading from a non-system',10
	DB	'disk in drive 0',10
	DB	'Loads a load module into memory without execution',13
MEMORY	DB	'MEMORY (HIGH=addr,ADD=addr,WORD=dddd,BYTE=dd,GO=addr)',10
	DB	'MEMORY (CLEAR) zeros memory from 5200H to HIGH$',10
	DB	'HIGH = will set the specified address as HIGH$',10
	DB	'ADD = displays 16 bit word at addr.',10
	DB	'WORD = changes the contents of addr.  Cannot = 0000',10
	DB	'BYTE = changes the contents of addr.  Cannot = FF',10
	DB	'GO = transfers control to specified address',10
	DB	'addr = any address in HEX or Decimal notation',10
	DB	'dddd = any HEX word except 0000',10
	DB	'dd = any hex byte except FF',13
PURGE	DB	'PURGE :d                     PURGE :d (QUERY,MPW="aa")',10
	DB	'PURGE partspec :d (QUERY=N,MPW="aa",DATE="M1/D1/Y1")',10
	DB	'QUERY = ask if file is to be killed before killing it',10
	DB	'MPW = Disks master password if other than "PASSWORD"',10
	DB	'DATE= allows specific date or range of dates to be specified',13
RENAME	DB	'RENAME fspec1 <TO> fspec2',10
	DB	'RENAME fspec <TO> partspec',10
	DB	'This command renames a file',13
RESET	DB	'RESET            or    RESET devspec',10
	DB	'This command will reset a logical device and usually restore',10
	DB	'the top of memory pointer',13
ROUTE	DB	'ROUTE devspec1 <TO> fspec/devspec2',10
	DB	'ROUTE devspec <TO> (NIL)',10
	DB	'This command routes I/O from one device to another',10
	DB	'(NIL) is a bit-bucket meaning nothing',10
	DB	'ROUTE *PR *CL sends printer output to the RS232',13
RUN	DB	'RUN (X) fspec (param,param....)',10
	DB	'fspec = any valid LDOS filespec',10
	DB	'(X) optional parameter to execute the program from a',10
	DB	'non-system diskette in drive :0',10
	DB	'param = optional parameter to be passed to fspec',13
SET	DB	'SET devspec <TO> fspec (param,param...)',10
	DB	'devspec = any currently available logical device',10
	DB	'fspec = any driver type program /DVR ext assumed',10
	DB	'param = parameters passed to the driver program',13
SPOOL	DB	'SPOOL devspec <TO> fspec (MEM=aa,DISK=bb)',10
	DB	'SPOOL devspec (OFF)',10
	DB	'devspec = any valid LDOS device spec',10
	DB	'fspec = optional LDOS filespec',10
	DB	'OFF = turns off spooler and resets devspec',10
	DB	'MEM = amount of memory to be used by spooler',10
	DB	'DISK = amount of disk space to be used by spooler',10
	DB	'aa = amount of memory to be used in blocks of 1K (Default=1K)',10
	DB	'bb = amount of disk space in blocks of 1K',13
LBASIC	DB	'LBASIC (MEM=nnnn,FILES=nn,BLK=N,) command',10
	DB	'MEM = memory size',10
	DB	'FILES = # of files',10
	DB	'BLK=N blocked file mode off',10
	DB	'command = any valid lbasic command',10
	DB	'To sort from LBASIC: CMD"O",# of elements,First array element',10
	DB	'CMD"P" returns printer status',10
	DB	'RUN"fspec",V,### preserves variables and specifies line number',13
SYSTEM	DB	'SYSTEM (param,param,...)',10
	DB	'Allowable parameters :',10
	DB	'ALIVE       BASIC2      BLINK=       BREAK=',10
	DB	'BSTEP=      DATE=Y/N    DATE=Y/N     DRIVE=',10
	DB	'FAST        GRAPHIC     SLOW         SVC',10
	DB	'UPDATE      SYSRES=     TIME=        TYPE=Y/N',10
	DB	'SYSTEM(SYSGEN)  stores current system status on disk to be',10
	DB	'loaded each time the system is BOOTed',13
TIME	DB	'TIME hh:mm:ss',10
	DB	'hh = HOURS    mm = MINUTES    ss = SECONDS: Colons required!',10
	DB	'Time given without argument returns the system time',13
TRACE	DB	'TRACE (ON,OFF)',10
	DB	'Forces diaplay of PC register on upper right of screen',13
VERIFY	DB	'VERIFY (ON,OFF)',10
	DB	'Causes all writes to disk to be verified',13
FORMAT	DB	'FORMAT :d (param,param,...)',10
	DB	'Formats disk.  Allowable parameters :',10
	DB	'NAME = Disk name',10
	DB	'MPW = Master password to be given to the disk',10
	DB	'DDEN or SDEN = Single or Double density',10
	DB	'SIDES = # of sides to format on the disk',10
	DB	'CYL = # of cylinders to format (tracks)',10
	DB	'STEP = bootstrap stepping rate for system disks only',10
	DB	'ABS = will format the disk even if it contains data',10
	DB	'Parameters may be passed to the FORMAT program in the',10
	DB	'command line.  If omitted, they will be asked for',3
BACKUP	DB	'BACKUP :s <TO> :d (param,param,...)',10
	DB	':s = source drive     :d = destination drive',10
	DB	'Parameters are optional as follows :',10
	DB	'MPW = "aa" passes source disks password',10
	DB	'SYS = parameter indicating system files',10
	DB	'INV = invisible files     VIS = visible files',10
	DB	'MOD = backup only those files that have modified',10
	DB	'QUERY = query each file before moving',10
	DB	'(X) = allows backups with a non system disk in drive :0',10
	DB	'BACKUP :0 :1 performs a regular cylinder by cylinder backup',10
	DB	'BACKUP $:0 :1 forces backup by file to take place',3
DATE	DB	'DATE MM/DD/YY',10
	DB	'Sets the system date',10
	DB	'DATE without argument returns system date',13
CONV	DB	'CONV :s <TO> :d (param,param...)',10
	DB	'CONV partspec w/wcc:s <TO> :d (param,param...',10
	DB	'Moves files from a Model III formatted disk to an LDOS disk',10
	DB	'The Model I must be capable of double density to do this!',10
	DB	'VIS = visible files     INV = invisible files',10
	DB	'SYS = system files      NEW = new files only',10
	DB	'OLD = must exist on :d  QUERY = query each file first',13
PATCH	DB	'PATCH fspec1 <USING> fspec2 (YANK)',10
	DB	'fspec1 = any valid filespec.  default extension = /CMD',10
	DB	'fspec2 = any valid filespec.  Default extension = /FIX',10
	DB	'YANK = parameter will remove the specified patch from the',10
	DB	'file if it exists and was not a "Dxx,yy=" type of patch',13
REPAIR	DB	'REPAIR :d (ALIEN)',10
	DB	'repairs disk to LDOS specifications',10
	DB	'This should be done to all data disks used with LDOS',10
	DB	'however it is not necessary to merely transfer files from an',10
	DB	'alien disk if LDOS will read it in the first place',13
WHO	DB	'CREDITS:',10,10
	DB	'The LDOS Utility Disk Series written specially for',10
	DB	'the LDOS Disk Operating System',10
	DB	'by Kim Watt - Breeze/QSD, Inc.',10
	DB	'LDOS is a trademark of Logical Systems Inc.',13
	END	5200H
