; u2pex/asm - kjw/bqsd - 03/82
;
@DISPLY	EQU	4467H		;string to video
@KEYIN	EQU	40H		;string from keyboard
@KEY	EQU	49H		;single key with wait
@DSP	EQU	33H		;char to video
@KBD	EQU	2BH		;single key, no wait
@ERROR	EQU	4409H		;display error
@EXIT	EQU	402DH		;normal dos exit
@ABORT	EQU	4030H		;dos abort exit
@GETDCT	EQU	478FH		;fetch drive DCT
@SELECT	EQU	4754H		;select a drive
@SEEK	EQU	475EH		;seek disk track
@CKDRV1	EQU	44B8H		;check drive status I
@CKDRV3	EQU	4209H		;check drive status III
;
	ORG	5200H
;
ENTRY	PUSH	HL		;save input pointer
	LD	HL,HELLO	;sign on message
	CALL	@DISPLY		;display to video
	POP	HL		;restore input
;
SCAN	CALL	POSHL		;position to valid char
	JP	C,ASKPARAMS	;nil, ask for params
	CP	'?'		;asking for author?
	JR	NZ,CNTSCN	;nope, continue
	PUSH	HL		;save input
	CALL	SHOWWHO		;display author
	POP	HL		;restore
	INC	HL		;bump pointer
	JR	SCAN		;check for more input
;
CNTSCN	CP	':'		;drive number?
	JR	NZ,ZAPDRV	;nope, continue
	INC	HL		;else bump past colon
ZAPDRV	LD	A,(HL)		;fetch drive number
	SUB	'0'		;remove ascii
	JP	C,ILLDRV	;illegal drive
	CP	8		;0-7?
	JP	NC,ILLDRV	;nope, illegal
	LD	(DRIVE),A	;save drive number
	INC	HL		;bump input pointer
	CALL	POSHL		;any more?
	JR	C,CHKDRV	;nope, continue
	CALL	VALUE		;get numeric value
	JR	C,PARAMERR	;invalid numeric
	LD	A,C		;get LSB value
	LD	(TRACKS),A	;save track count
FININIT	LD	A,-1		;set current track
	LD	(TRACK),A	;to non-inited
	JP	CONTINUE	;continue program
;
CHKDRV	LD	A,(4)		;fetch ROM byte
	CP	30H		;mod I/III?
	LD	A,(DRIVE)	;get drive number
	LD	C,A		;C = drive
	JR	Z,CKIII		;go mod III
	CALL	@CKDRV1		;check drive I
	JR	CKI		;continue
CKIII	CALL	@CKDRV3		;check drive III
CKI	JR	NZ,PARAMERR	;not ready, ask again
	LD	A,(DRIVE)	;get drive again
	LD	C,A		;C = drive
	CALL	@GETDCT		;locate drive DCT
	LD	A,(IY+6)	;get highest cylinder
	INC	A		;adjust to track count
	LD	(TRACKS),A	;save track count
	JR	FININIT		;continue
;
ILLDRV	LD	A,20H		;illegal drive number
ERROR	OR	0C0H		;return - non descriptive
	CALL	@ERROR		;display error message
	JR	ASKPARAMS	;ask for params again
;
PARAMERR LD	HL,PARMSG	;param error
	CALL	@DISPLY		;display message
;
ASKPARAMS
	XOR	A		;clear mode
	LD	(MODE),A	;save flag
	LD	HL,DRVMSG	;prompt string
	CALL	@DISPLY		;display it
	LD	B,31		;31 char input
	LD	HL,STRING	;input buffer
	CALL	@KEYIN		;fetch keyboard input
	JR	C,EXIT		;break key, exit program
	LD	A,B		;get length
	OR	A		;anything input?
	JP	NZ,SCAN		;yes, parse input
;
	LD	HL,HELP1	;help message
	CALL	@DISPLY		;display it
	JR	ASKPARAMS	;ask again
;
EXIT	LD	HL,EXMSG	;exiting message
	CALL	@DISPLY		;display it
	LD	HL,ABMSG	;program aborted
	CALL	@DISPLY		;display
	JP	@EXIT		;to dos exit
;
;
	INC	HL		;bump input pointer
POSHL	LD	A,(HL)		;fetch string char
	CP	13		;terminator?
	SCF			;carry = yes
	RET	Z		;yes, return with flag
	CP	1		;break?
	SCF			;carry = yes
	RET	Z		;yes, return
	CP	' '		;space?
	JR	Z,POSHL-1	;yes, parse over it
	CP	','		;comma?
	JR	Z,POSHL-1	;yes, parse over it
	OR	A		;clear carry flag
	RET			;return non-carry
;
;
VALUE	EX	DE,HL		;DE => input buffer
	LD	BC,ADDHEX	;hex adder
	LD	(VALCAL1),BC	;save it
	LD	BC,CONVH	;hex ascii converter
	LD	(VALCAL2),BC	;save it
	LD	A,(DE)		;get string input
	CALL	UCASE		;make it upper case
	CP	'H'		;hex?
	JR	Z,VALDOIT-1	;yes, go!
	LD	BC,ADDOCT	;octal adder
	LD	(VALCAL1),BC	;save
	LD	BC,CONVO	;octal converter
	LD	(VALCAL2),BC	;save
	CP	'O'		;octal?
	JR	Z,VALDOIT-1	;yes, go!
	CP	'Q'		;octal?
	JR	Z,VALDOIT-1	;yes, go!
	LD	BC,ADDBIN	;binary adder
	LD	(VALCAL1),BC	;save
	LD	BC,CONVB	;binary converter
	LD	(VALCAL2),BC	;save
	CP	'B'		;binary?
	JR	Z,VALDOIT-1	;yes, go!
	LD	BC,ADDDEC	;decimal adder
	LD	(VALCAL1),BC	;save
	LD	BC,CONVD	;decimal converter
	LD	(VALCAL2),BC	;save
	CP	'D'		;decimal?
	JR	NZ,VALDOIT	;nope, go!
	INC	DE		;bump past base specifier
;
VALDOIT	LD	BC,0		;starting value
VALLP	LD	A,(DE)		;get string char
	CP	13		;terminator?
	JR	Z,VALDN+1	;yes, done!
	CP	','		;separator?
	JR	Z,VALDN		;yes, done!
	CP	' '		;separator?
	JR	Z,VALDN		;yes, done!
	CALL	UCASE		;make it upper case
	CALL	0		;call converter
VALCAL2	EQU	$-2
	RET	C		;invalid char, return
	LD	H,B		;pass value to HL
	LD	L,C
	CALL	0		;call adder
VALCAL1	EQU	$-2
	LD	C,A		;C = new char
	LD	B,0		;BC = new numeric
	ADD	HL,BC		;add to subtotal
	LD	B,H		;pass back to BC
	LD	C,L
	INC	DE		;bump input pointer
	JR	VALLP		;go next char
;
VALDN	INC	DE		;bump input
	EX	DE,HL		;HL => remaining chars
	RET			;done, BC = value
;
ADDDEC	ADD	HL,HL		;decimal adder
	ADD	HL,HL
	ADD	HL,BC
ADDBIN	ADD	HL,HL		;binary adder
	RET
;
ADDHEX	ADD	HL,HL		;hex adder
ADDOCT	ADD	HL,HL		;octal adder
	ADD	HL,HL
	ADD	HL,HL
	RET
;
CONVD	SUB	'0'		;decimal converter
	RET	C		;return error
	CP	10		;0-9?
	CCF			;reverse carry
	RET			;return, C = invalid
;
CONVH	SUB	'0'		;convert hex
	RET	C		;invalid
	CP	10		;0-9?
	CCF			;reverse carry
	RET	NC		;0-9, return OK
	SUB	7		;adjust for A-F
	RET	C		;invalid
	CP	16		;0-15 result?
	CCF			;reverse
	RET			;return, C = invalid
;
CONVB	SUB	'0'		;binary converter
	RET	C		;error
	CP	2		;0-1?
	CCF			;reverse
	RET			;C = invalid digit
;
CONVO	SUB	'0'		;octal converter
	RET	C		;return error
	CP	8		;0-7?
	CCF			;reverse
	RET			;C = invalid char
;
ASCII	PUSH	HL		;save it
	CALL	ASCI		;convert A => BC ascii
	LD	H,B		;get MSB
	PUSH	HL		;save H msb on stack
	LD	A,C		;get LSB
	SUB	'0'		;remove ascii
	CALL	ASCI		;convert to BC
	LD	A,C		;get MSB
	CP	'0'		;leading zero?
	JR	NZ,ASCIGO1	;nope, continue
	LD	A,' '		;convert to space
ASCIGO1	POP	HL		;restore H nsb
	LD	C,B		;C = lsb
	LD	B,H		;B = nsb
	POP	HL		;restore HL
	RET			;done, ACB = ascii
;
ASCI	LD	C,'0'		;start digit
ASCII1	SUB	10		;check 10's place
	JR	C,ASCII2	;have the digit
	INC	C		;bump ascii
	JR	ASCII1		;continue
ASCII2	ADD	A,'0'+10	;ascii + last sub
	LD	B,A		;B = lsb
	RET			;CB = ascii
;
UCASE	CP	'a'		;lowercase now
	RET	C		;nope, return
	CP	'z'+1		;lowercase top range
	RET	NC		;not needed
	AND	5FH		;convert to upper case
	RET			;A = upper case char
;
;
GOTABLE	PUSH	BC		;save BC
	PUSH	DE		;save
	PUSH	AF		;save char
	EX	AF,AF'		;char in A'
	POP	AF		;get char back
	CALL	UCASE		;convert to upper case
	LD	C,A		;C = char to find
TABLP	LD	A,(DE)		;get table byte
	OR	A		;table terminator?
	JR	Z,NOTINT	;yes, not in table
	CP	C		;one we want?
	JR	Z,HAVTAB	;yes, go table vector
	INC	DE		;bump table (3 bytes)
	INC	DE
	INC	DE
	JR	TABLP		;continue next entry
;
NOTINT	EX	AF,AF'		;get original char back
	POP	DE		;unstack
	POP	BC
	RET			;return to caller
;
HAVTAB	EX	(SP),HL		;fetch old DE from stack
	EX	DE,HL		;DE = original DE
	INC	HL		;bump table to vector
	LD	A,(HL)		;get lsb vector
	INC	HL		;bump table
	LD	H,(HL)		;get msb vector
	LD	L,A		;HL = vector
	POP	AF		;dummy remove DE
	POP	BC		;unstack BC
	EX	(SP),HL		;remove ret address
	PUSH	AF		;old HL
	POP	HL		;restore HL
	RET			;go new vector
;
CONTINUE LD	A,(TRACK)	;get track
	CP	-1		;initialized?
	JR	NZ,NEWTRK	;yes, go!
	LD	A,0		;get drive number
DRIVE	EQU	$-1
	LD	C,A		;C = drive
	CALL	@SELECT		;select drive
	JP	NZ,ERROR	;go error
	XOR	A		;set track as 0
;
NEWTRK	LD	(TRACK),A	;save track number
	LD	D,A		;pass track to D
	LD	A,(DRIVE)	;fetch drive #
	LD	C,A		;C = drive
	CALL	@SEEK		;move head to track
	JP	NZ,ERROR	;go error if bad
	JR	BEGINLOOP	;wait for new command
;
NEWSTEP	PUSH	AF		;save key
	LD	A,(DRIVE)	;fetch drive #
	LD	C,A		;pass to C
	CALL	@GETDCT		;fetch DCT
	POP	BC		;B = key
	LD	A,(IY+3)	;get DCT data
	AND	0F8H		;remove low 2 bits
	OR	B		;merge with new step rate
	LD	(IY+3),A	;back to the DCT
;
BEGINLOOP
	LD	A,(MODE)	;fetch mode
	OR	A		;nil?
	JR	NZ,STARTLOOP	;no, go!
	LD	HL,PROMPT	;command prompt
	CALL	@DISPLY		;display it
;
STARTLOOP
	CALL	SHOWTRK		;display current data
	LD	A,(MODE)	;fetch mode
	OR	A		;nil?
	LD	A,(DRIVE)	;fetch drive
	LD	C,A		;pass to C
	CALL	NZ,@SELECT	;keep drive running
	CALL	@KBD		;scan keyboard
	OR	A		;anything input?
	LD	DE,TABLE	;lookup table
	CALL	NZ,GOTABLE	;go vector if any keys
	LD	A,0		;fetch operation mode
MODE	EQU	$-1
	OR	A		;nil?
	JR	Z,STARTLOOP	;yes, wait for a key
;
	LD	A,0		;fetch current track
TRACK	EQU	$-1
	OR	A		;on track 0?
	JR	Z,DOTOP		;yes, go to top track
RESTOR	XOR	A		;else go track 0
	JR	NEWTRK		;continue
;
DOTOP	LD	A,0		;get track count
TRACKS	EQU	$-1
	DEC	A		;compute top track
	JR	NEWTRK		;continue
;
;	jump table for keyboard input
;
TABLE	DEFB	1		;break
	DEFW	EXIT
	DEFB	'D'		;D
	DEFW	NEWPARAMS
	DEFB	'C'		;C
	DEFW	ASKCYL
	DEFB	'S'		;S
	DEFW	ASKSTEP
	DEFB	'A'		;A
	DEFW	SETAUTO
	DEFB	'R'		;R
	DEFW	RESTOR
	DEFB	'T'		;T
	DEFW	DOTOP
	DEFB	0		;terminator
;
NEWPARAMS LD	A,10		;send linefeed
	CALL	@DSP		;to video
	JP	ASKPARAMS	;ask for params
;
SETAUTO	LD	A,1		;set automatic mode
	LD	(MODE),A	;save it
	JR	STARTLOOP	;wait for key to change
;
ASKCYL	XOR	A		;set non-auto mode
	LD	(MODE),A	;save it
	LD	HL,CYLMSG	;prompt text
	CALL	@DISPLY		;display it
	LD	B,10		;10 char input
	LD	HL,STRING	;input buffer
	CALL	@KEYIN		;fetch from keyboard
	JP	C,EXIT		;go if break key
	CALL	POSHL		;find first char
	JR	C,ASKCYL	;nil, ask again
	CALL	VALUE		;fetch numeric value
	JR	C,ASKCYL	;invalid, ask again
	LD	A,C		;fetch LSB value
	JP	NEWTRK		;go new track
;
ASKSTEP	XOR	A		;turn-off auto mode
	LD	(MODE),A	;save param
	LD	HL,STEPMSG	;prompt text
	CALL	@DISPLY		;display it
	LD	B,10		;10 char input
	LD	HL,STRING	;key input buffer
	CALL	@KEYIN		;get key input
	JP	C,EXIT		;go if break key
	CALL	POSHL		;find first char
	JR	C,ASKSTEP	;nil, ask again
	CALL	VALUE		;fetch numeric value
	JR	C,ASKSTEP	;go if invalid
	LD	A,C		;fetch LSB value
	CP	4		;0-3?
	JR	NC,ASKSTEP	;out of range, ask again
	JP	NEWSTEP		;else have new step rate
;
SHOWTRK	LD	A,(DRIVE)	;get drive number
	ADD	A,'0'		;make it ascii
	LD	(DRM),A		;save to text string
	LD	A,(TRACK)	;get current track
	CALL	ASCII		;to decimal ascii
	LD	(TRM),A		;to text string
	LD	(TRM+1),BC	;rest
	LD	A,(TRACKS)	;get track count
	CALL	ASCII		;to decimal ascii
	LD	(TKM),A		;to the string
	LD	(TKM+1),BC
	LD	A,(DRIVE)	;get drive number again
	LD	C,A		;pass to C
	CALL	@GETDCT		;locate the DCT
	LD	A,(IY+3)	;get data
	AND	3		;current step rate
	ADD	A,A		;*2
	LD	C,A		;C = step *2
	LD	B,0		;BC = table offset
	LD	HL,SPDTBL	;text lookup table
	ADD	HL,BC		;HL => ascii represent
	LD	DE,SPM		;text where it goes
	LD	BC,2		;2 chars to move
	LDIR			;move to string
	LD	HL,MMSG		;start of message
	JP	@DISPLY		;display and return
;
WHOMSG	DEFB	93H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,093H
	DEFB	0B3H,0B9H,0C9H,0EBH,0F6H,0FEH,0EBH,0F8H
;
	DEFB	0F4H,0B9H,0FBH,0E0H,0B9H,0D2H,0F0H,0F4H
	DEFB	0B9H,0CEH,0F8H,0EDH,0EDH,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B1H,0FAH
	DEFB	0B0H,0B1H,0E9H,0B0H,0B9H,0A8H,0A0H,0A1H
;
	DEFB	0ABH,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0DBH,0EBH,0FCH,0FCH
;
	DEFB	0E3H,0FCH,0B6H,0C8H,0CAH,0DDH,0B5H,0B9H
	DEFB	0D0H,0F7H,0FAH,0B7H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0A8H,0A8H,0ACH,0A9H,0A9H,0B9H
	DEFB	0CAH,0EDH,0FCH,0F4H,0F4H,0F6H,0F7H,0EAH
;
	DEFB	0B9H,0DFH,0EEH,0E0H,0B7H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0CAH
;
	DEFB	0ECH,0F0H,0EDH,0FCH,0B9H,0A8H,0ABH,0ACH
	DEFB	0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,0B9H,0DDH,0F8H,0F5H,0F5H,0F8H,0EAH
	DEFB	0B5H,0B9H,0CDH,0FCH,0E1H,0F8H,0EAH,0B9H
;
	DEFB	0AEH,0ACH,0ABH,0ABH,0A0H,0B9H,0B3H,093H
	DEFB	0B3H,0B9H,0B9H,0B9H,0B1H,0ABH,0A8H,0ADH
;
	DEFB	0B0H,0B9H,0ADH,0A1H,0ADH,0B4H,0A0H,0ADH
	DEFB	0ABH,0A1H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DEFB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,094H
	DEFB	93H
	DEFB	99H
;
;
SHOWWHO	LD	HL,WHOMSG	;start of author message
WHOLP	LD	A,(HL)		;fetch a char
	INC	HL		;bump pointer
	XOR	99H		;'decrypt' it
	RET	Z		;return if terminator
	CALL	@DSP		;else send char
	JR	WHOLP		;continue
;
;
;##
SPDTBL	DEFB	'0','6'
	DEFB	'1','2'
	DEFB	'2','0'
	DEFB	'3','0'
;
MMSG	DEFB	1DH
	DEFM	'Drive '
DRM	DEFM	'x, Cylinders='
TKM	DEFM	'xxx, Step='
SPM	DEFM	'xxms, Head Over'
TRM	DEFM	'xxx.'
	DEFB	1EH
	DEFB	3
;
CLRLIN	DEFB	1DH,1EH,3
;
PROMPT	DEFB	10
	DEFM	'D>rive, C>ylinder, S>tep, '
	DEFM	'A>utomatic, R>estore, T>op'
	DEFB	13
;
CYLMSG	DEFB	10
	DEFM	'Cylinder to Seek ? '
	DEFB	3
;
STEPMSG	DEFB	10
	DEFM	'Step Rate (0-3) ? '
	DEFB	3
;
HELP1	DEFB	10
	DEFM	':a,bbb'
	DEFB	10
	DEFB	10
	DEFM	'a   = exercise this drive '
	DEFM	'(colon optional)'
	DEFB	10
	DEFM	'bbb = track count '
	DEFM	'(optional if formatted disk in place'
	DEFB	10
	DEFB	13
;
EXMSG	DEFB	10
	DEFM	'Power Exerciser '
	DEFB	3
;
ABMSG	DEFM	'* Aborted *'
	DEFB	13
;
PARMSG	DEFM	'Parameter Error !'
	DEFB	13
;
HELLO	DEFB	1CH
	DEFB	1FH
	DEFM	'PEX - '
	DEFM	'Disk Exerciser Utility for LDOS - '
	DEFM	'Version 2.1'
	DEFB	10
	DEFM	'by Kim Watt - '
	DEFM	'(c)(p) Copyright 1982 '
	DEFM	'Breeze/QSD, Inc.'
	DEFB	10
	DEFB	10
	DEFB	13
;
DRVMSG	DEFM	'Exercise: Drive (0-7), '
	DEFM	'Cylinder Count ? '
	DEFB	3
;
STRING	EQU	$
	DS	31
;
	END	ENTRY
