; u3pcomp/asm
@DISPLY	EQU	4467H
@KEYIN	EQU	40H
@CKDRV3	EQU	4209H
@CKDRV1	EQU	44B8H
@RDSEC	EQU	4777H
@FSPEC	EQU	441CH
@VERSEC	EQU	4772H
@OPEN	EQU	4424H
@DIRRD	EQU	4B10H
@DSP	EQU	33H
@KBD	EQU	2BH
@ERROR	EQU	4409H
@EXIT	EQU	402DH
@ABORT	EQU	4030H
@GETDCT	EQU	478FH
@POSN	EQU	4442H
@READ	EQU	4436H
@PRINT	EQU	446AH
	ORG	5200H
ENTRY	PUSH	HL
	LD	HL,HELLO
	CALL	@DISPLY
	POP	HL
SCAN	CALL	POSHL
	JP	C,ASKPARAMS
	CP	'?'
	JR	NZ,CNTSCN
	PUSH	HL
	CALL	SHOWWHO
	POP	HL
	INC	HL
	JR	SCAN
CNTSCN	CP	':'
	JR	Z,MAPDRV
	CP	'*'
	JR	NZ,CONTSCAN
	XOR	A
	LD	(DUAL),A
	INC	HL
	JR	SCAN
CONTSCAN	SUB	30H
	JP	C,MAPFIL
	CP	8
	JP	NC,MAPFIL
	DEC	HL
MAPDRV	INC	HL
	LD	A,(HL)
	SUB	30H
	JP	C,ILLDRV
	CP	8
	JP	NC,ILLDRV
	LD	(SDRIVE),A
	INC	HL
	LD	DE,0
	LD	(SSECTOR),DE
	DEC	DE
	LD	(SCOUNT),DE
	CALL	POSHL
	JP	C,PARAMERR
	CP	':'
	JP	Z,SCANDEST
	CALL	VALUE
	JP	C,PARAMERR
	LD	A,C
	LD	(STRACK),A
	CALL	POSHL
	JP	C,PARAMERR
	CP	':'
	JP	Z,SCANDEST
	CALL	VALUE
	JP	C,PARAMERR
	LD	A,C
	LD	(SSECTOR),A
	CALL	POSHL
	JP	C,PARAMERR
	CP	':'
	JP	Z,SCANDEST
	CALL	VALUE
	JP	C,PARAMERR
	LD	(SCOUNT),BC
	CALL	POSHL
	JP	C,PARAMERR
	CP	':'
	JP	NZ,PARAMERR
SCANDEST	INC	HL
	LD	A,(HL)
	SUB	30H
	JP	C,ILLDRV
	CP	8
	JP	NC,ILLDRV
	LD	(DDRIVE),A
	INC	HL
	LD	DE,0
	LD	(DSECTOR),DE
	CALL	POSHL
	JP	C,CONTINUE1
	CALL	VALUE
	JP	C,PARAMERR
	LD	A,C
	LD	(DTRACK),A
	CALL	POSHL
	JP	C,CONTINUE1
	CALL	VALUE
	JP	C,PARAMERR
	LD	A,C
	LD	(DSECTOR),A
	JP	CONTINUE1
MAPFIL	LD	DE,@FCB1
	CALL	@FSPEC
	JR	NZ,ERROR
	CALL	POSHL
	JP	C,PARAMERR
	LD	DE,@FCB2
	CALL	@FSPEC
	JR	NZ,ERROR
	PUSH	HL
	LD	HL,@IOBUFF1
	LD	DE,@FCB1
	LD	B,0
	CALL	@OPEN
	POP	HL
	JP	NZ,ERROR
	LD	A,(@FCB1+1)
	AND	0F8H
	LD	(@FCB1+1),A
	PUSH	HL
	LD	HL,@IOBUFF2
	LD	DE,@FCB2
	LD	B,0
	CALL	@OPEN
	POP	HL
	JP	NZ,ERROR
	LD	A,(@FCB2+1)
	AND	0F8H
	LD	(@FCB2+1),A
	LD	BC,0
	LD	(POSIT),BC
	CALL	POSHL
	JP	C,CONTINUE2
	CALL	VALUE
	JP	C,PARAMERR
	LD	(POSIT),BC
	JP	CONTINUE2
ILLDRV	LD	A,20H
ERROR	OR	0C0H
	CALL	@ERROR
	JP	ASKPARAMS
DRAIN	CALL	@KBD
	OR	A
	JR	NZ,DRAIN
TERMIN	LD	HL,EXMSG
	CALL	@DISPLY
ABORT	LD	HL,ABMSG
	CALL	@DISPLY
	JP	@ABORT
PARAMERR	LD	HL,PARMSG
	CALL	@DISPLY
ASKPARAMS
	LD	HL,DRVMSG
	CALL	@DISPLY
	LD	B,63
	LD	HL,STRING
	CALL	@KEYIN
	JR	C,DRAIN
	LD	A,B
	OR	A
	JP	NZ,SCAN
	LD	HL,HELP1
	CALL	@DISPLY
	JR	ASKPARAMS
	INC	HL
POSHL	LD	A,(HL)
	CP	13
	SCF
	RET	Z
	CP	1
	SCF
	RET	Z
	CP	20H
	JR	Z,POSHL-1
	CP	','
	JR	Z,POSHL-1
	OR	A
	RET
BADRD	LD	(ERNO),A
	CP	6
	RET	Z
	CP	7
	RET	Z
	PUSH	HL
	LD	HL,BADRMSG
	PUSH	DE
	PUSH	BC
	CALL	@DISPLY
	LD	A,0
ERNO	EQU	$-1
	OR	0C0H
	CALL	@ERROR
GETBAD	LD	HL,ASKBAD
	CALL	@DISPLY
	LD	B,1
	LD	HL,STRING
	CALL	@KEYIN
	JP	C,DRAIN
	LD	A,(HL)
	CALL	UCASE
	CP	'S'
	JR	Z,BADRET
	CP	'R'
	JR	NZ,GETBAD
	OR	1
BADRET	POP	BC
	POP	DE
	POP	HL
	RET
ASCII	OR	A		;256?
	JR	NZ,ASCGO	;nope, continue
	LD	A,'2'		;set 256
	LD	BC,'65'		;set rest
	RET			;ACB = ascii
ASCGO	LD	B,'0'		;100's place start
ASC1	SUB	100		;less 100
	JR	C,ASC2		;go if found
	INC	B		;bump ascii
	JR	ASC1		;continue
ASC2	PUSH	BC		;save MSB for A
	ADD	A,100		;add back last sub
	LD	C,'0'		;10's place start
ASC3	SUB	10		;less 10
	JR	C,ASC4		;go if found
	INC	C		;bump ascii digit
	JR	ASC3		;continue
ASC4	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;LSB to B
	POP	AF		;get MSB
	CP	'0'		;leading zero?
	RET	NZ		;nope, return
	LD	A,' '		;change to space
	RET
UCASE	CP	'a'
	RET	C
	CP	'z'+1
	RET	NC
	AND	5FH
	RET
CKITT	LD	A,(4)
	CP	30H
	JR	Z,CKIII
	CALL	@CKDRV1
	JR	CKI
CKIII	CALL	@CKDRV3
CKI	LD	A,8
	RET
CONTINUE1
	LD	A,0
SDRIVE	EQU	$-1
	LD	C,A
	CALL	CKITT
	JP	NZ,ERROR
	LD	A,(SDRIVE)
	LD	C,A
	CALL	@GETDCT
	LD	(IYSRC),IY
	LD	A,(SDRIVE)
	CALL	SHOWDRV
	LD	A,0
DDRIVE	EQU	$-1
	LD	C,A
	CALL	CKITT
	JP	NZ,ERROR
	LD	A,(DDRIVE)
	LD	C,A
	CALL	@GETDCT
	LD	(IYDES),IY
	LD	A,(DDRIVE)
	CALL	SHOWDRV
	LD	HL,0
	LD	(COUNT0),HL
	LD	(COUNT1),HL
	LD	(COUNT2),HL
	LD	A,20H
	LD	(TOT4),A
LOOPER	LD	A,(SDRIVE)
	LD	C,A
	LD	DE,0
SSECTOR	EQU	$-2
STRACK	EQU	$-1
	LD	HL,@IOBUFF1
	CALL	@RDSEC
	CALL	NZ,BADRD
	JR	NZ,LOOPER
LOOPEE	LD	A,(DDRIVE)
	LD	C,A
	LD	DE,0
DSECTOR	EQU	$-2
DTRACK	EQU	$-1
	LD	HL,@IOBUFF2
	CALL	@RDSEC
	CALL	NZ,BADRD
	JR	NZ,LOOPEE
	LD	HL,0
COUNT0	EQU	$-2
	INC	HL
	LD	(COUNT0),HL
	CALL	REPORT
	LD	BC,0
SCOUNT	EQU	$-2
	DEC	BC
	LD	(SCOUNT),BC
	LD	A,B
	OR	C
	JP	Z,COMPLETE
	LD	DE,(SSECTOR)
	LD	IY,0
IYSRC	EQU	$-2
	CALL	NEXSEC
	JP	Z,ENDSRC
	LD	(SSECTOR),DE
	LD	DE,(DSECTOR)
	LD	IY,0
IYDES	EQU	$-2
	CALL	NEXSEC
	JP	Z,ENDDES
	LD	(DSECTOR),DE
	JR	LOOPER
ENDSRC	LD	HL,SENDMSG
	JR	GOEND
ENDDES	LD	HL,DENDMSG
GOEND	CALL	DODISPLY
	LD	HL,EXMSG
	CALL	@DISPLY
	LD	HL,ABMSG
GOCOMPL	CALL	@DISPLY
	CALL	SHOTOTAL
	JP	@EXIT
COMPLETE	LD	HL,EXMSG
	CALL	@DISPLY
	LD	HL,PLETEMSG
	JR	GOCOMPL
SHOTOTAL
	LD	IX,TOT1
	LD	HL,(COUNT0)
	CALL	WRLNO
	LD	IX,TOT2
	LD	HL,(COUNT1)
	CALL	WRLNO
	LD	IX,TOT3
	LD	HL,(COUNT2)
	CALL	WRLNO
	LD	HL,TOT1
	JP	DODISPLY
PAUSE	PUSH	DE
	CALL	@KBD
	POP	DE
	CP	1
	JP	Z,DRAIN
	CP	'`'
	RET	NZ
PAUSWT	PUSH	DE
	CALL	@KBD
	POP	DE
	CP	1
	JP	Z,DRAIN
	OR	A
	JR	Z,PAUSWT
	RET
NEXSEC	INC	E
	CALL	FIGTOP
	SUB	E
	RET	NZ
	LD	E,A
	LD	A,D
	CP	(IY+6)
	RET	Z
	INC	D
	RET
FIGTOP	LD	A,(IY+7)
	AND	1FH
	INC	A
	BIT	5,(IY+4)
	JR	Z,NEXS
	ADD	A,A
NEXS	BIT	3,(IY+3)
	RET	Z
	PUSH	BC
	LD	C,A
	LD	A,(IY+7)
	RRCA
	RRCA
	RRCA
	RRCA
	RRCA
	AND	7
	INC	A
	LD	B,A
	XOR	A
FIGXTOP	ADD	A,C
	DJNZ	FIGXTOP
	POP	BC
	RET
HEXCV	OR	A		;100H?
	JR	NZ,HEXGO	;nope, continue
	LD	A,'1'		;MSB
	LD	BC,'00'		;NSB, LSB
	RET			;done, 100H
;
HEXGO	LD	B,A
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	HEXTST
	LD	C,A
	LD	A,B
	CALL	HEXTST
	LD	B,A
	LD	A,' '		;MSB
	RET			;ACB = ascii
HEXTST	AND	0FH
	ADD	A,'0'
	CP	3AH
	RET	M
	ADD	A,7
	RET
WRLNO	LD	DE,TENTBL
A4B7B	LD	A,(DE)
	LD	C,A
	INC	DE
	LD	A,(DE)
	LD	B,A
	INC	DE
	PUSH	DE
	LD	A,2FH
A4B84	INC	A
	LD	D,H
	LD	E,L
	ADD	HL,BC
	JR	C,A4B84
	EX	DE,HL
	POP	DE
	LD	(IX),A
	INC	IX
	INC	C
	JR	NZ,A4B7B
	RET
TENTBL	DW	-10000,-1000,-100,-10,-1
SHOWDRV	ADD	A,30H
	LD	(MY0),A
	LD	HL,2020H
	BIT	7,(IY+3)
	JR	Z,NOTWP
	LD	HL,5057H
NOTWP	LD	(MY0+1),HL
	LD	A,'5'
	BIT	5,(IY+3)
	JR	Z,MMY1
	LD	A,'8'
MMY1	LD	(MY1),A
	LD	HL,FLPMSG
	BIT	3,(IY+3)
	JR	Z,MMY2
	LD	HL,HRDMSG
MMY2	LD	DE,MY2
	LD	BC,6
	LDIR
	LD	A,(IY+4)
	AND	0FH
	ADD	A,30H
	LD	(MY2B),A
	LD	A,(IY+6)
	INC	A
	CALL	ASCGO
	LD	(MY3),A
	LD	(MY3+1),BC
	LD	A,'S'
	BIT	6,(IY+3)
	JR	Z,MMY3
	LD	A,'D'
MMY3	LD	(MY4),A
	LD	A,'1'
	BIT	5,(IY+4)
	JR	Z,MMY4
	INC	A
MMY4	LD	(MY5),A
	LD	H,'5'
	LD	L,'.'
	BIT	2,(IY+3)
	JR	NZ,MMY5C
	LD	H,'1'
	LD	L,20H
MMY5C	LD	(MY5C),HL
	LD	HL,SPDTBL
	LD	A,(IY+3)
	AND	3
	ADD	A,A
	LD	C,A
	LD	B,0
	ADD	HL,BC
	LD	DE,MY5B
	LD	BC,2
	LDIR
	LD	HL,MYMSG
	CALL	DODISPLY
	LD	HL,MY4
	BIT	3,(IY+3)
	JP	Z,DODISPLY
	BIT	2,(IY+3)
	LD	HL,FIXMSG
	JP	NZ,DODISPLY
	LD	HL,REMMSG
	JP	DODISPLY
SPDTBL	DB	'0','6'
	DB	'1','2'
	DB	'2','0'
	DB	'3','0'
VALUE	EX	DE,HL
	LD	BC,ADDHEX
	LD	(VALCAL1),BC
	LD	BC,CONVH
	LD	(VALCAL2),BC
	LD	A,(DE)
	CALL	UCASE
	CP	'H'
	JR	Z,VALDOIT-1
	LD	BC,ADDOCT
	LD	(VALCAL1),BC
	LD	BC,CONVO
	LD	(VALCAL2),BC
	CP	'O'
	JR	Z,VALDOIT-1
	LD	BC,ADDBIN
	LD	(VALCAL1),BC
	LD	BC,CONVB
	LD	(VALCAL2),BC
	CP	'B'
	JR	Z,VALDOIT-1
	LD	BC,ADDDEC
	LD	(VALCAL1),BC
	LD	BC,CONVD
	LD	(VALCAL2),BC
	CP	'D'
	JR	NZ,VALDOIT
	INC	DE
VALDOIT	LD	BC,0
VALLP	LD	A,(DE)
	CP	13
	JR	Z,VALDN+1
	CP	','
	JR	Z,VALDN
	CP	20H
	JR	Z,VALDN
	CALL	UCASE
	CALL	0
VALCAL2	EQU	$-2
	RET	C
	LD	H,B
	LD	L,C
	CALL	0
VALCAL1	EQU	$-2
	LD	C,A
	LD	B,0
	ADD	HL,BC
	LD	B,H
	LD	C,L
	INC	DE
	JR	VALLP
VALDN	INC	DE
	EX	DE,HL
	RET
ADDDEC	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,BC
ADDBIN	ADD	HL,HL
	RET
ADDHEX	ADD	HL,HL
ADDOCT	ADD	HL,HL
	ADD	HL,HL
	ADD	HL,HL
	RET
CONVD	SUB	30H
	RET	C
	CP	10
	CCF
	RET
CONVH	SUB	30H
	RET	C
	CP	10
	CCF
	RET	NC
	SUB	7
	RET	C
	CP	16
	CCF
	RET
CONVB	SUB	30H
	RET	C
	CP	2
	CCF
	RET
CONVO	SUB	30H
	RET	C
	CP	8
	CCF
	RET
;
COMPARE	PUSH	BC		;save B count
	LD	BC,0		;reset mismatches
	LD	(MISSES),BC	;set to 0000H
	POP	BC		;original
;
COMPLP	LD	A,B		;any more to test?
	OR	C		;yes?
	RET	Z		;nope, done!
	DEC	BC		;less this test
	LD	A,(DE)		;get first byte
	CP	(HL)		;match?
	INC	HL		;bump pointers
	INC	DE
	JR	Z,COMPLP	;go if match!
;
;	mismatched byte
;
	LD	A,L		;get offset next byte
	DEC	A		;adjust to real offset
	LD	(FIRSTB),A	;save offset
;
COMPBD	PUSH	BC		;save remain count
	LD	BC,(MISSES)	;get current count
	INC	BC		;+ this bad one
	LD	(MISSES),BC	;resave current errors
	POP	BC		;restore
;
	LD	A,B		;any more to test?
	OR	C
	RET	Z		;nope, return
;
	LD	A,(DE)		;get first byte
	CP	(HL)		;test to second
	RET	Z		;match, continue
	DEC	BC		;less this test
	INC	HL		;bump pointers
	INC	DE
	JR	COMPBD		;else count this one too
;
REPORT	LD	A,(3840H)
	AND	2
	JP	NZ,DRAIN
;
;	compare buffers and report mismatches
;
	LD	HL,@IOBUFF1	;first buffer
	LD	DE,@IOBUFF2	;second buffer
	LD	BC,100H		;buffer length
	CALL	COMPARE		;compare buffers
;
	PUSH	BC		;save remain count
	LD	BC,(MISSES)	;any mismatches?
	LD	A,B		;get MSB
	OR	C		;any bits on?
	POP	BC		;restore remainder
;
	RET	Z		;all bytes matched!
;
;	sector mismatch, display current set
;
	PUSH	HL		;save buff 1
	PUSH	DE		;save buff 2
	PUSH	BC		;save remain count
	LD	BC,0		;get # buffers mismatched
COUNT1	EQU	$-2
	INC	BC		;+ these buffers
	LD	(COUNT1),BC	;re-save new subtotal
;
	LD	A,(SDRIVE)	;get source drive
	ADD	A,'0'		;add ascii
	LD	(SM0),A		;to the string
;
	LD	A,(STRACK)	;get source track
	CALL	ASCGO		;to ascii
	LD	(SM1),A		;to the string
	LD	(SM1+1),BC	;rest of it
;
	LD	A,(SSECTOR)	;get source sector
	CALL	ASCGO		;to decimal ascii
	LD	(SM3),A		;MSB to string
	LD	(SM3+1),BC	;NSB,LSB to string
;
	LD	IY,(IYSRC)	;source DCT
	BIT	4,(IY+3)	;side 0?
	LD	A,'0'		;load ascii
	JR	Z,GOTSDD	;yes, go!
	INC	A		;else side 1
GOTSDD	LD	(SM2),A		;side # to string
;
	LD	A,(DDRIVE)	;dest drive #
	ADD	A,'0'		;make it ascii
	LD	(SD0),A		;to the string
;
	LD	A,(DTRACK)	;dest track #
	CALL	ASCGO		;to decimal ascii
	LD	(SD1),A		;MSB
	LD	(SD1+1),BC	;NSB,LSB
;
	LD	A,(DSECTOR)	;dest sector
	CALL	ASCGO		;to ascii
	LD	(SD3),A		;to string
	LD	(SD3+1),BC	;rest of it
;
	LD	IY,(IYDES)	;dest DCT pointer
	BIT	4,(IY+3)	;side 0?
	LD	A,'0'		;load ascii
	JR	Z,GTDSD		;yes, go!
	INC	A		;else side 1
GTDSD	LD	(SD2),A		;to text string
;
	LD	HL,SMDMSG	;start of message
	CALL	DODISPLY	;dual display driver
;
	POP	BC		;unstack 'em
	POP	DE
	POP	HL
;
;
REPLP	PUSH	BC		;remaining count
	PUSH	HL		;buffer #1
	LD	HL,0		;get total byte mismatch
COUNT2	EQU	$-2
	LD	BC,(MISSES)	;get mismatches this time
	ADD	HL,BC		;add to total
	LD	(COUNT2),HL	;save as subtotal
	JR	NC,NOTCRY	;did not exceed 65535
	LD	A,'+'		;else set ascii overflow
	LD	(TOT4),A	;to the text string
;
NOTCRY	PUSH	DE		;save buffer #2
	CALL	PAUSE		;check for a pause 
	POP	DE		;restore buff 2
	POP	HL		;restore buff 1
;
	LD	A,0		;get offset of first bad
FIRSTB	EQU	$-1
	PUSH	AF		;save for 2 converts
	CALL	HEXGO		;to hex ascii
	LD	(RE2),A		;to the string
	LD	(RE2+1),BC
	POP	AF		;restore
	CALL	ASCGO		;to decimal ascii
	LD	(RE1),A		;to the string
	LD	(RE1+1),BC
;
	LD	A,L		;get first match byte
	DEC	A		;to last bad one
	PUSH	AF		;save
	CALL	ASCGO
	LD	(RE1X),A
	LD	(RE1X+1),BC
	POP	AF
	CALL	HEXGO
	LD	(RE2X),A
	LD	(RE2X+1),BC
	LD	BC,0
MISSES	EQU	$-2
	LD	A,C
	PUSH	AF
	CALL	HEXCV
	LD	(RE4),A
	LD	(RE4+1),BC
	POP	AF
	CALL	ASCII
	LD	(RE3),A
	LD	(RE3+1),BC
	PUSH	DE
	PUSH	HL
	LD	HL,REMSG
	CALL	DODISPLY
	POP	HL
	POP	DE
	POP	BC
	LD	A,B
	OR	C
	RET	Z
	CALL	COMPARE
	PUSH	BC
	LD	BC,(MISSES)
	LD	A,B
	OR	C
	POP	BC
	RET	Z
	JP	REPLP
CONTINUE2	LD	HL,0
	LD	(COUNT0),HL
	LD	(COUNT1),HL
	LD	(COUNT2),HL
	LD	A,20H
	LD	(TOT4),A
FLOOP	LD	BC,(POSIT)
	LD	DE,@FCB1
	CALL	@POSN
	JP	NZ,COMPLETE
	LD	DE,@FCB1
	LD	HL,@IOBUFF1
	CALL	@READ
	CALL	NZ,BADRD
	JR	NZ,FLOOP
FLOOPA	LD	DE,@FCB2
	LD	BC,(POSIT)
	CALL	@POSN
	JP	NZ,ERROR
	LD	DE,@FCB2
	LD	HL,@IOBUFF2
	CALL	@READ
	CALL	NZ,BADRD
	JR	NZ,FLOOPA
	CALL	REPORTF
	LD	BC,0
POSIT	EQU	$-2
	INC	BC
	LD	(POSIT),BC
	LD	BC,(COUNT0)
	INC	BC
	LD	(COUNT0),BC
	JR	FLOOP
REPORTF	LD	HL,@IOBUFF1
	LD	DE,@IOBUFF2
	LD	BC,100H
	CALL	COMPARE
	PUSH	BC
	LD	BC,(MISSES)
	LD	A,B
	OR	C
	POP	BC
	RET	Z
	PUSH	HL
	PUSH	DE
	PUSH	BC
	LD	HL,(COUNT1)
	INC	HL
	LD	(COUNT1),HL
	LD	HL,(POSIT)
	LD	IX,FILPOS
	CALL	WRLNO
	LD	HL,FILEBADM
	CALL	DODISPLY
	POP	BC
	POP	DE
	POP	HL
	JP	REPLP
DODISPLY	PUSH	HL
	CALL	@DISPLY
	POP	HL
DUAL	RET
	JP	@PRINT
WHOMSG
	DB	93H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,093H
	DB	0B3H,0B9H,0C9H,0EBH,0F6H,0FEH,0EBH,0F8H
;
	DB	0F4H,0B9H,0FBH,0E0H,0B9H,0D2H,0F0H,0F4H
	DB	0B9H,0CEH,0F8H,0EDH,0EDH,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B1H,0FAH
	DB	0B0H,0B1H,0E9H,0B0H,0B9H,0A8H,0A0H,0A1H
;
	DB	0ABH,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0DBH,0EBH,0FCH,0FCH
;
	DB	0E3H,0FCH,0B6H,0C8H,0CAH,0DDH,0B5H,0B9H
	DB	0D0H,0F7H,0FAH,0B7H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0A8H,0A8H,0ACH,0A9H,0A9H,0B9H
	DB	0CAH,0EDH,0FCH,0F4H,0F4H,0F6H,0F7H,0EAH
;
	DB	0B9H,0DFH,0EEH,0E0H,0B7H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0CAH
;
	DB	0ECH,0F0H,0EDH,0FCH,0B9H,0A8H,0ABH,0ACH
	DB	0B9H,0B9H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,0B9H,0DDH,0F8H,0F5H,0F5H,0F8H,0EAH
	DB	0B5H,0B9H,0CDH,0FCH,0E1H,0F8H,0EAH,0B9H
;
	DB	0AEH,0ACH,0ABH,0ABH,0A0H,0B9H,0B3H,093H
	DB	0B3H,0B9H,0B9H,0B9H,0B1H,0ABH,0A8H,0ADH
;
	DB	0B0H,0B9H,0ADH,0A1H,0ADH,0B4H,0A0H,0ADH
	DB	0ABH,0A1H,0B9H,0B9H,0B9H,0B9H,0B3H,093H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,019H
;
	DB	0B3H,019H,0B3H,019H,0B3H,019H,0B3H,094H
	DB	93H
	DB	99H
SHOWWHO	LD	HL,WHOMSG
WHOLP	LD	A,(HL)
	INC	HL
	XOR	99H
	RET	Z
	CALL	@DSP
	JR	WHOLP
;##
FILEBADM	DB	10,'Data Mismatch File Relative Sector '
FILPOS	DB	'xxxxx.',13
TOT1	DB	'xxxxx Total Sectors Compared.',10
TOT2	DB	'xxxxx Sectors Did Not Match.',10
TOT3	DB	'xxxxx'
TOT4	DB	'xBytes Did Not Match.',13
SMDMSG	DB	10,':'
SM0	DB	'x, Cyl'
SM1	DB	'xxx, Side '
SM2	DB	'x, Sect'
SM3	DB	'xxx <<==>> :'
SD0	DB	'x, Cyl'
SD1	DB	'xxx, Side '
SD2	DB	'x, Sect'
SD3	DB	'xxx',13
REMSG	DB	'At Relative '
RE1	DB	'xxx ('
RE2	DB	'xxxH) to '
RE1X	DB	'xxx ('
RE2X	DB	'xxxH) for '
RE3	DB	'xxx ('
RE4	DB	'xxxH) byte(s)',13
SENDMSG	DB	10,'End of SOURCE disk reached !',3
DENDMSG	DB	10,'End of DESTINATION disk reached !',3
EXMSG	DB	10,'Power Compare ',3
PLETEMSG	DB	'* Completed *',13
HELP1	DB	10
	DB	'*:a,b,c,d,:e,f,g            or',10
	DB	'*file1,file2,h',10,10
	DB	':a,b,c         = Source: Drive, Cylinder, Sector',10
	DB	':e,f,g         = Dest:   Drive, Cylinder, Sector',10
	DB	'd              = optional sector count',10
	DB	'file1,file2    = compare these files',10
	DB	'h              = optional starting relative sector',10
	DB	'*              = optional send output to printer',10,13
MYMSG	DB	':'
MY0	DB	'x   '
MY1	DB	'x" '
MY2	DB	'xxxxxx #'
MY2B	DB	'x, Cyls='
MY3	DB	'xxx, ',3
MY4	DB	'xDen, Sides='
MY5	DB	'x, Step='
MY5B	DB	'xxms, Dly='
MY5C	DB	'xxs',13
FLPMSG	DB	'Floppy'
HRDMSG	DB	'Rigid '
FIXMSG	DB	'Fixed',13
REMMSG	DB	'Removable',13
ASKBAD	DB	'R>etry, S>kip, or <BREAK> ? ',3
BADRMSG	DB	10,'Disk READ Error !',13
ABMSG	DB	'* Aborted *',13
PARMSG	DB	'Parameter Error !',13
HELLO	DB	1CH,1FH
	DB	'PCOMPARE - Disk/File Compare Utility for LDOS - Version 2.1',10
	DB	'by Kim Watt - (c)(p) Copyright 1982 Breeze/QSD, Inc.',10,10,13
DRVMSG	DB	'Compare Parameters:',13
DBUFF	EQU	$&0FF00H
STRING	EQU	DBUFF+100H
@FCB1	EQU	STRING+100H
@FCB2	EQU	STRING+180H
@IOBUFF1	EQU	STRING+200H
@IOBUFF2	EQU	STRING+300H
	END	ENTRY
