HOWTOD ;	howtodo/asm
 SERIALNO	DB	'                '
 OKCONT	DB	0
 PREENTRY	DI
 	LD	SP,STACK
 	LD	A,0FEH		;MAKE SINGLE DENSITY
 	LD	(37ECH),A
 	LD	A,0D0H
 	LD	(37ECH),A
 	LD	BC,0
 	CALL	DELAY
 	CALL	DELAY
 	CALL	CLEARSCR
 	EI
 	RST	18H
 	RST	20H
 	RST	8
 	DB	1CH,1FH,10,10
 	DB	10,'Distributed by Breeze/QSD, Inc.'
 	DB	10,'11500 Stemmons Exway - Suite 125'
 	DB	10,'Dallas, Texas  75229'
 	DB	10,'(214) 484-9428'
 	DB	10,10,'Testing Buffer Memory ...',13
 MEMTEST	LD	HL,BUFFER
 TESTMEM	LD	A,-1
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	INC	A
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	INC	HL
 	LD	A,H
 	OR	L
 	JR	Z,ENTRY
 	JR	TESTMEM
 BADMEM	PUSH	HL
 	LD	A,H
 	RST	30H
 	LD	(BYTEBAD),HL
 	POP	HL
 	LD	A,L
 	RST	30H
 	LD	(BYTEBAD+2),HL
 	RST	8
 	DB	10
 	DB	'Memory Test Failed at byte X',27H
 BYTEBAD	DB	'0000',27H,10
 	DB	'MUST HAVE 48K to run program ! ',3
 	LD	B,2
 	RST	10H
 	JR	MEMTEST
 ENTRY	LD	SP,STACK
 GETSPDS	CALL	SETUPS
 	RST	8
 	DB	10,'Step Speed (0=6ms,1=12ms,2=20ms,3=40ms, default 0) ? ',3
 	LD	B,1
 	RST	10H
 	LD	A,0
 	LD	(SPEED),A
 	JR	Z,HSPD
 	LD	A,(HL)
 	SUB	30H
 	JR	C,GETSPDS
 	CP	4
 	JR	NC,GETSPDS
 	LD	(SPEED),A
 HSPD	ADD	A,30H
 	LD	(ST81),A
 	RST	18H
 	JR	RESME
 SETUPS	LD	A,'N'
 	LD	(VFLAG),A
 	XOR	A		;REQUESTED COPIES
 	LD	(SOURCE),A	;DEFAULT SOURCE DRIVE
 	LD	(FINISHED),A	;HOW MANY ARE DONE
 	LD	A,100
 	LD	(REQUEST),A	;DEFAULT REQUEST #
 	LD	A,35
 	LD	(TRACKS),A	;DEFAULT TRACKS
 	LD	HL,DEST		;DESTINATION TABLE
 	LD	(HL),'N'	;DEFAULT VALUES
 	INC	HL
 	LD	(HL),'Y'
 	INC	HL
 	LD	(HL),'Y'
 	INC	HL
 	LD	(HL),'Y'
 	XOR	A
 	LD	(SERLEN),A
 	LD	A,'N'
 	LD	(SERONOFF),A
 	LD	(INCONOFF),A
 	LD	A,'S'
 	LD	(STPR),A
 	LD	HL,3CC0H
 	LD	DE,3CC1H
 	LD	(HL),140
 	LD	BC,63
 	LDIR
 	RST	18H
 	JP	HOWMANY
 RESME	RST	20H		;PRINT LINE 2
 ASKSP	RST	8
 	DB	'S>tandard or P>rotection (default standard) ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,STDISK
 	CP	'S'
 	JR	Z,STDISK
 	CP	'P'
 	JR	NZ,ASKSP
 	LD	A,'P'
 	JR	STDISK+2
 STDISK	LD	A,'S'
 	LD	(STPR),A
 	LD	(ST82),A
 	PUSH	AF
 	RST	18H
 	POP	AF
 	CP	'S'
 	JP	Z,GOSTD
 	RST	8
 	DB	10,'One sector on track 0 can be renamed.',13
 ASKOSEC	RST	8
 	DB	'Enter original sector to be modified (0-9) ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,ASKOSEC
 	SUB	30H
 	JR	C,ASKOSEC
 	CP	10
 	JR	NC,ASKOSEC
 	LD	(OSEC),A
 	ADD	A,30H
 	LD	(ST85),A
 	RST	18H
 ASKNSEC	RST	8
 	DB	'Enter sector number to be changed to (10-246) ? ',3
 	LD	B,3
 	RST	10H
 	JR	Z,ASKNSEC
 	CALL	VALUE
 	JR	C,ASKNSEC
 	LD	A,C
 	CP	247
 	JR	NC,ASKNSEC
 	CP	10
 	JR	C,ASKNSEC
 	LD	(NSEC),A
 	RST	28H
 	LD	(ST86),A
 	LD	(ST86+1),BC
 	RST	18H
 SERIALIN	RST	8
 LINFIX	DB	'Use a serial number (default no) ? ',3
 	LD	B,3
 	RST	10H
 	JR	Z,YESSER
 	CP	'N'
 	JR	Z,YESSER
 	CP	'Y'
 	JR	NZ,SERIALIN
 	LD	A,'Y'
 	JR	YESSER+2
 YESSER	LD	A,'N'
 	LD	(SERONOFF),A
 	LD	(ST83),A
 	PUSH	AF
 	RST	18H
 	POP	AF
 	CP	'N'
 	JP	Z,GOSTD
 	LD	A,(NSEC)
 	RST	28H
 	LD	(SHYS),A
 	LD	(SHYS+1),BC
 	RST	8
 	DB	'Serial number will be placed in sector '
 SHYS	DB	'000, starting at F0H.',13
 ASKSTSER	RST	8
 	DB	'Start serial number (16 chars. max) ? ',3
 	LD	B,16
 	RST	10H
 	JR	Z,ASKSTSER
 	LD	A,B
 	LD	(SERLEN),A
 	LD	C,A
 	LD	B,0
 	LD	DE,SERIALNO
 	LDIR
 	RST	18H
 ASKINC	RST	8
 	DB	'Increment the number (default yes) ? ',3
 	LD	B,1
 	RST	10H
 	JR	Z,INCYES
 	CP	'Y'
 	JR	Z,INCYES
 	CP	'N'
 	JR	NZ,ASKINC
 	JR	INCYES+2
 INCYES	LD	A,'Y'
 	LD	(INCONOFF),A
 	LD	(ST84),A
 	RST	18H
 GOSTD	LD	A,(STPR)
 	CP	'S'
 	JR	Z,X7X8
 	LD	HL,ORDER2
 	LD	DE,BUFFER+0F0H
 	LD	B,10
 	LD	A,(OSEC)
 GOSTD1	CP	(HL)
 	JR	Z,GOSTD2
 	INC	HL
 	INC	D
 	DJNZ	GOSTD1
 	JR	X7X8
 GOSTD2	LD	A,(NSEC)
 	LD	(HL),A
 	LD	(SERBUF),DE
 X7X8	RST	8
 	DB	'How many copies to be made decimal (default 100) ? ',3
 	LD	B,3		;ALLOW 3 CHARACTERS
 	RST	10H	;USE INTERNAL BUFFER
 	LD	A,100		;DEFAULT TO 100
 	JR	Z,HAVECOUNT	;CONTINUE IF DEFAULT
 	CALL	VALUE		;GET STRING VALUE
 	JR	C,X7X8		;C=BAD INPUT ELSE BC=NUM.
 	LD	A,C
 HAVECOUNT	LD	(REQUEST),A	;SAVE VALUE
 	RST	20H		;SHOW ON SCREEN
 ASKTKS	RST	8
 	DB	'Diskette Track Count (default 35) ? ',3
 	LD	B,3
 	RST	10H
 	LD	A,35
 	JR	Z,TKSASK
 	CALL	VALUE
 	JR	C,ASKTKS
 	LD	A,C
 TKSASK	LD	(TRACKS),A
 	RST	20H
 BAD5	RST	8
 	DB	'Byte for byte verify after write (default yes) ? ',3
 	LD	B,3
 	RST	10H
 	JR	Z,VERNO
 	CP	'N'
 	JR	Z,VERNO+2
 	CP	'Y'
 	JR	NZ,BAD5		;INVALID INPUT
 VERNO	LD	A,'Y'		;DEFAULT
 	LD	(VFLAG),A	;VERIFY FLAG
 	RST	18H		;PRINT ON SCREEN
 BAD2	RST	8		;PRINT
 	DB	'Source drive (default 0) ? ',3
 	LD	B,1
 	RST	10H	;GET INPUT
 	LD	C,0		;DEFAULT 0
 	JR	Z,HAVESRC
 	SUB	30H
 	JR	C,BAD2
 	LD	C,A
 HAVESRC	LD	A,C
 	CP	4
 	JR	NC,BAD2		;TOO MUCH
 	LD	(SOURCE),A	;SAVE BINARY DRIVE
 	ADD	A,30H		;MAKE ASCII
 	LD	(SRCDRV),A	;FOR STRING
 	SUB	30H
 	CALL	DRVBIT		;SET DRIVE BIT
 	LD	(SRC),A		;SAVE BIT SET
 	XOR	A
 	LD	(DESDR),A
 	RST	18H		;SHOW SOURCE DRIVE
 	RST	20H
 DESTLOOP	LD	A,(DESDR)
 	ADD	A,30H		;MAKE DRIVE INTO ASCII
 	LD	(INLINE),A	;PUT IN MESSAGE
 	RST	20H
 	LD	BC,(DESDR)
 	LD	A,(SOURCE)
 	CP	C
 	JR	Z,HAVENO	;skip source drive
 	RST	8		;DISPLY IT
 	DB	'Copy to drive '
 INLINE	DB	'0 (default no) ? ',3
 	LD	B,3
 	RST	10H	;GET RESPONSE
 	JR	Z,HAVENO	;GO IF NO INPUT
 	CP	'Y'		;YES ?
 	JR	Z,HAVEIF	;GO IF YES
 	CP	'N'		;NO ?
 	JR	NZ,DESTLOOP	;BAD INPUT IF NOT Y/N
 HAVENO	LD	A,'N'
 HAVEIF	LD	HL,DEST		;DESTINATION TABLE
 	LD	E,A		;SAVE RESPONSE
 	LD	A,(DESDR)	;GET DRIVE
 	ADD	A,L
 	LD	L,A
 	LD	(HL),E
 	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	JR	C,DESTLOOP	;CONTINUE IF NOT END
 	LD	A,99
 	LD	(OKCONT),A
 	LD	HL,DEST		;POINT TO TABLE
 	LD	A,(SOURCE)	;GET SOURCE DRIVE
 	ADD	A,L		;POINT TO DEST BYTE
 	LD	L,A
 	LD	A,(HL)		;GET DEST BYTE
 	CP	'Y'		;SOURCE & DEST THE SAME ?
 	JR	NZ,START	;START COPY IF NOT SAME
 	RST	8		;MESSAGE
 	DB	10,'Source & Destination same drive !',13
 	JP	BAD2		;START AGAIN
 START	LD	SP,STACK	;RESET STACK FROM BREAK
 	LD	A,(OKCONT)
 	CP	99
 	JP	NZ,ENTRY
 	RST	18H		;TITLE
 	RST	20H		;HOWMANY COPIES
 	RST	8		;MESSAGE
 	DB	10,'Mount all disks, press <ENTER>. ',3
 	LD	B,1
 	RST	10H	;WAIT FOR ENTER
 	XOR	A		;START WITH TRACK 0
 	LD	(TRACK),A	;SAVE IT
 	LD	(DESDR),A	;DESTINATION COUNT
 	LD	HL,0
 	LD	(LOCKTBL),HL	;SET ALL DRIVES AS OK
 	LD	(LOCKTBL+2),HL
 	LD	(PLACE),HL	;PLACE OF NEXT READ
 	LD	HL,DEST
 	LD	B,4
 CHKLP	LD	A,(HL)
 	CP	'Y'
 	JR	Z,FORMAT
 	INC	HL
 	DJNZ	CHKLP
 	RST	8
 	DB	'NO DESTINATION DRIVES.  Press <ENTER> to continue. ',3
 	LD	B,1
 	RST	10H
 	JP	ENTRY
 FORMAT	LD	HL,DEST		;POINT TO TABLE
 	LD	IY,TRACKS
 	LD	A,(DESDR)	;GET COUNT
 	ADD	A,L		;POINT TO DES DRIVE
 	LD	L,A
 	LD	A,(HL)		;GET A BYTE
 	CP	'Y'		;COPY TO THAT ONE ?
 	JR	NZ,FMTNEXT	;SKIP IF NOT "Y"
 	LD	A,(DESDR)	;DRIVE COUNT
 	LD	(DRIVE),A	;SAVE BINARY
 	CALL	DRVBIT		;SET BIT FOR DRIVE SELECT
 	LD	(DRIV),A	;SAVE THAT
 	CALL	RESTOR		;RESTORE THE DRIVE
 	CALL	WSTAT		;CHECK WRITE STATUS
 	JR	NZ,FMTNEXT
 	XOR	A		;START WITH TRACK 0
 	LD	(TRACK),A	;FOR FORMAT
 	CALL	FORM		;FORMAT THE DISK
 FMTNEXT	LD	A,(DESDR)	;GET COUNTER
 	INC	A		;BUMP IT
 	LD	(DESDR),A	;RE-SAVE IT
 	CP	4		;END OF TABLE ?
 	JR	C,FORMAT	;CONTINUE IF NOT
 	XOR	A		;ZERO TRACK AGAIN
 	LD	(TRACK),A	;SAVE IT
 	CALL	RESTOREALL	;RESTORE ALL DRIVES & TBL
 	LD	IY,TRACKS	;POINT TO TRACK COUNT
 	LD	HL,0		;ZERO OUT CURRENT TRACK
 	LD	(CTRACK),HL	;TABLE TO FORCE RESTORE
 	LD	(CTRACK+2),HL	;DONE
 COPY	LD	A,(SOURCE)	;SOURCE DRIVE
 	LD	(DRIVE),A
 	LD	A,(SRC)		;BIT SET
 	LD	(DRIV),A
 	LD	DE,(PLACE)	;PLACE OF READ
 	LD	(TRAK),DE	;SAVE FOR WRITE
 	CALL	MREAD		;MULTIPLE SECTOR READ
 	LD	(PLACE),DE
 	XOR	A		;FOR TABLE
 	LD	(DESDR),A	;ZERO IT
 CPYLOOP	LD	HL,DEST		;DESTINATION TABLE
 	LD	A,(DESDR)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	CP	'Y'
 	JR	NZ,CPYNEXT	;SKIP IF NOT YES
 	LD	A,(DESDR)
 	LD	(DRIVE),A	;BINARY DRIVE
 	CALL	DRVBIT		;SET DRIVE BIT
 	LD	(DRIV),A
 	LD	DE,(TRAK)	;GET TRACK
 	LD	A,D
 	OR	A
 	CALL	Z,NEXTSERIAL
 	CALL	MWRITE		;MULTIPLE WRITE
 	LD	A,(VFLAG)	;VERIFY ON ?
 	CP	'Y'
 	CALL	Z,VERIFY	;DO IT IF YES
 CPYNEXT	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	JR	C,CPYLOOP	;GO LOOP
 	LD	A,(PLACE+1)	;GET CURRENT TRACK
 	CP	(IY)		;END ?
 	JP	NZ,COPY		;CONTINUE
 	RST	8
 	DB	13		;CARRIAGE RETURN
 	LD	HL,(CURSOR)	;GET CURSOR
 	PUSH	HL		;GIVE TO DE
 	POP	DE
 	INC	DE		;CURSOR +1
 	LD	(HL),140	;GRAPHIC BLOCK
 	LD	BC,63
 	LDIR			;DRAW LINE
 	RST	8		;DROP ANOTHER LINE
 	DB	13
 	LD	HL,LOCKTBL	;LOCKOUT TABLE
 	LD	DE,DEST		;DESTINATION TABLE
 	LD	B,4		;GO FOR 4 DRIVES
 	LD	C,30H		;ASCII DRIVE
 CHKMANY	LD	A,(DE)		;ACTIVE DRIVE ?
 	CP	'Y'
 	JR	NZ,CHKNEXT	;CONTINUE IF NOT
 	LD	A,(HL)		;GET LOCKOUT BYTE
 	OR	A		;SET FLAGS
 	JP	NZ,CHKBAD	;FAULTY
 	LD	A,(FINISHED)	;INCREMENT # OF DONE
 	INC	A
 	LD	(FINISHED),A
 	LD	A,C
 	LD	(GOODDRV),A
 	PUSH	HL
 	PUSH	DE
 	RST	8
 	DB	10,'Drive '
 GOODDRV	DB	'0 Copied OK.',3
 	POP	DE
 	POP	HL
 CHKNEXT	INC	HL		;BUMP POINTERS
 	INC	DE
 	INC	C
 	DJNZ	CHKMANY
 	JP	COPYBYE		;DONE
 CHKBAD	LD	A,C		;GET DRIVE ASCII
 	LD	(BADDRV),A	;PUT IN STRING
 	PUSH	HL
 	PUSH	DE
 	RST	8		;DISPLAY MESSAGE
 	DB	10,'DO NOT USE Drive '
 BADDRV	DB	'0, BAD COPY.',3
 	POP	DE
 	POP	HL
 	JP	CHKNEXT
 DRVBIT	PUSH	DE		;SAVE DE
 	LD	E,1		;BIT 0
 BITLOOP	OR	A		;CHECK IF 0
 	JR	Z,BITFND	;FOUND IF 0
 	DEC	A		;DRIVE -1
 	SLA	E		;MOVE DRIVE BIT
 	JR	BITLOOP		;CONTINUE
 BITFND	LD	A,E		;GET BIT
 	POP	DE		;RESTORE DE
 	RET			;DONE
 CLEARSCR	LD	HL,3C00H	;VIDEO
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),20H	;SPACE
 	LDIR			;CLEAR SCREEN
 	LD	HL,3CC0H
 	LD	DE,3CC1H
 	LD	BC,63
 	LD	(HL),140
 	LDIR
 	RET			;DONE
 MSG0	DB	'* POWER-COPY I * by Kim Watt - Source='
 SRCDRV	DB	'0, Verify='
 VERON	DB	'N         '
 HOWMANY	LD	A,(REQUEST)	;GET REQUEST
 	RST	28H		;MAKE IT ASCII
 	LD	(MANY1),A	;PUT IN STRING
 	LD	(MANY1+1),BC
 	LD	A,(FINISHED)	;HOW MANY DONE
 	RST	28H		;MAKE IT ASCII TOO
 	LD	(MANY2),A
 	LD	(MANY2+1),BC	;PUT IN STRING
 	LD	A,(TRACKS)	;GET TRACK COUNT
 	RST	28H
 	LD	(MANY3),A
 	LD	(MANY3+1),BC
 	LD	HL,DEST
 	LD	A,(HL)
 	LD	(DRV1),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV2),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV3),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV4),A
 	LD	HL,MSG1		;POINT TO MESSAGE
 	LD	DE,3C40H	;VIDEO LINE 2
 	LD	B,64		;64 CHARS
 	JP	PUTITON		;PRINT IT
 MSG1	DB	'Requested='
 MANY1	DB	'000, Finished='
 MANY2	DB	'000, Tracks='
 MANY3	DB	'000. Dest 0='
 DRV1	DB	'N, 1='
 DRV2	DB	'Y, 2='
 DRV3	DB	'Y, 3='
 DRV4	DB	'Y '
 FORM	LD	A,(DRIVE)	;GET BINARY DRIVE
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(FMTDRV),A	;PUT IN STRING
 	RST	8		;ONE CARRIAGE RETURN
 	DB	13
 FORMLP	LD	A,(TRACK)	;GET TRACK
 	RST	28H		;MAKE IT ASCII
 	LD	(FMTTRK),A	;PUT IN STRING
 	LD	(FMTTRK+1),BC
 	CALL	ORDNEW		;SHIFT SECTOR ORDER
 	CALL	ORDNEW		;FOR FAST READ AT 40 MS
 	CALL	ORDNEW		;STEP RATE
 	RST	8
 	DB	1DH		;BEGINNING OF LINE
 	DB	'Formatting - Drive '
 FMTDRV	DB	'0, Track '
 FMTTRK	DB	'000.',3
 	LD	HL,BUFFER	;FORMAT BUFFER
 	LD	DE,ORDER	;SECTOR ORDER
 	LD	A,'S'
 STPR	EQU	$-1
 	CP	'S'
 	JR	Z,TKFGO
 	LD	A,(TRACK)	;SEE IF TRACK 0
 	OR	A		;SET FLAGS
 	JR	NZ,TKFGO
 	LD	DE,ORDER2
 TKFGO	LD	IY,TRACKS
 	LD	B,0EH		;PRE INDEX GLL
 	CALL	FILLFF
 SECLP	LD	B,6
 	LD	C,0
 	CALL	FILL
 	LD	C,0FEH		;SECTOR HEADER
 	CALL	FILL1
 	LD	A,(TRACK)	;GET TRACK
 	LD	C,A
 	CALL	FILL1
 	LD	C,0		;HEAD
 	CALL	FILL1
 	LD	A,(DE)		;GET SECTOR
 	LD	C,A
 	CALL	FILL1
 	LD	C,1		;SECTOR LENGTH 256 BYTES
 	CALL	FILL1
 	LD	C,0F7H		;GENERATE CRC
 	CALL	FILL1
 	LD	B,0BH		;POST SECTOR GAP
 	CALL	FILLFF
 	LD	B,6		;6 0'S FOR SYNC FIELD
 	LD	C,0
 	CALL	FILL
 	LD	C,0FBH		;DATA HEADER
 	CALL	FILL1
 	LD	B,0		;256 BYTES
 	LD	C,0		;FILL BYTE
 	CALL	FILL
 	LD	C,0F7H		;GENERATE CRC
 	CALL	FILL1
 	LD	B,11H
 	CALL	FILLFF		;POST DATA GAP
 	INC	DE		;BUMP SECTOR POINTER
 	LD	A,(DE)		;GET THE BYTE
 	INC	A		;TEST FOR FFH
 	JR	NZ,SECLP	;FINISH ALL SECTORS
 	LD	B,5BH		;PRE-INDEX GAP
 	CALL	FILLFF		;TO BUFFER
 	CALL	WRITTR		;WRITE THE TRACK
 	RET	NZ
 	LD	A,(TRACK)	;GET TRACK
 	INC	A		;BUMP IT
 	LD	(TRACK),A	;SAVE IT
 	CP	(IY)		;END OF DISK ?
 	RET	Z		;FINISHED IF YES
 	CALL	STEPIN		;STEP IN DRIVE
 	JP	FORMLP		;GO LOOP
 ORDNEW	LD	IX,ORDER	;POINT TO TABLE
 	PUSH	IX		;PASS TO DE
 	POP	DE
 	LD	B,9		;GO 9 TIMES
 NEORLP	LD	A,(IX+9)
 	LD	C,(IX+8)
 	LD	(IX+9),C
 	LD	(IX+8),A
 	DEC	IX
 	DJNZ	NEORLP
 	RET			;DONE WITH SHIFT
 RESTOREALL	XOR	A	;START WITH 0
 	LD	(DESDR),A	;SAVE IT
 	LD	HL,0		;ZERO THE TRACK TABLE
 	LD	(CTRACK),HL
 	LD	(CTRACK+2),HL
 	RST	8
 	DB	13
 	LD	A,(SRC)		;GET SOURCE DRIVE
 	LD	(DRIV),A	;SAVE IT
 	LD	A,(SOURCE)
 	LD	(DRIVE),A
 	CALL	RSTAT		;CHECK STATUS OF READ
 	JP	NZ,STOP
 RESLOOP	LD	A,(DESDR)	;GET DESTINATION COUNT
 	LD	HL,DEST
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	CP	'Y'		;DESTINATION ?
 	JR	NZ,RESNEXT	;SKIP IF NOT YES
 	LD	HL,LOCKTBL
 	LD	A,(DESDR)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	JR	Z,RESNEXT
 	LD	A,(DESDR)
 	LD	(DRIVE),A
 	CALL	DRVBIT
 	LD	(DRIV),A
 	CALL	WSTAT		;CHECK WRITE STATUS
 RESNEXT	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	RET	NC
 	JR	RESLOOP
 MREAD	RST	8
 	DB	13
 	CALL	GETTRK		;SETUP TRACK REGISTER
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(RDDR),A
 	LD	A,D
 	RST	28H
 	LD	(RDTK),A
 	LD	(RDTK+1),BC
 	LD	BC,BUFFER
 	LD	IX,POINTER	;TO SAVE READ TYPE
 READLP	PUSH	BC		;SAVE BUFFER
 	LD	A,B
 	RST	30H
 	LD	(BUFF1),HL
 	LD	A,E
 	RST	28H
 	LD	(RDSC),A
 	LD	(RDSC+1),BC
 	RST	8
 	DB	1DH,'Reading   Drive '
 RDDR	DB	'0, Track '
 RDTK	DB	'000, Sector '
 RDSC	DB	'000, Buffer '
 BUFF1	DB	'0000H.',3
 	POP	BC		;LOAD ADDRESS
 	CALL	BAIL		;CHECK IF BREAK KEY
 	CALL	READ
 	JR	NZ,STOP		;QUIT IF READ ERROR
 	LD	A,(RESULT)	;GET READ TYPE
 	LD	(IX),A		;SAVE IN TABLE
 	INC	IX
 	INC	E		;BUMP SECTOR
 	LD	A,E		;GET INTO ACCUM
 	SUB	0AH		;END OF TRACK ?
 	JR	NZ,READEN	;NOPE
 	LD	E,A		;E=0
 	INC	D		;BUMP TRACK
 	PUSH	BC
 	LD	A,D
 	RST	28H
 	LD	(RDTK),A
 	LD	(RDTK+1),BC
 	POP	BC
 READEN	LD	A,B		;GET BUFFER POINTER
 	OR	A		;TOP OF 48K ?
 	JP	Z,SAVETRK	;SAVE CURRENT TRACK
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	JP	NC,SAVETRK	;SAVE AND RETURN
 	JP	READLP
 STOP	RST	8
 	DB	10,'Cannot continue because of Source Read Error. ',10
 	DB	'Press <ENTER> to restart. ',3
 	LD	B,1
 	RST	10H
 	JP	ENTRY
 FILLFF	LD	C,0FFH
 FILL	CALL	FILL1
 	DJNZ	FILL
 	RET
 FILL1	LD	(HL),C
 	INC	HL
 	RET
 WRITTR	CALL	BAIL		;CHECK FOR QUIT
 TRWRIT	CALL	SELECT		;SELECT DRIVE
 	LD	BC,BUFFER	;POINT TO BUFFER
 	LD	HL,37ECH
 	DI
 	LD	(HL),0F4H	;WRITE TRACK COMMAND
 	LD	DE,37EFH	;TRANSFER ADDRESS
 	CALL	DSKSLO		;WAIT FOR READY
 	JR	WRBZZ		;TRANSFER
 BZWRZ	BIT	0,(HL)		;COMMAND DONE ?
 	JR	Z,WRDNZ		;NOT SET = DONE
 WRBZZ	BIT	1,(HL)		;READY FOR BYTE ?
 	JR	Z,BZWRZ		;NOT YET
 	LD	A,(BC)		;GET A BYTE
 	LD	(DE),A		;GIVE TO FDC
 	INC	BC		;BUMP POINTER
 	JR	WRBZZ		;DO NEXT BYTE
 WRDNZ	LD	A,(HL)		;GET STATUS BYTE
 	LD	(HL),0D0H	;INTERRUPT
 	EI
 	LD	HL,ERMSG5	;DATA LOST
 	BIT	2,A		;CHECK BIT
 	JR	NZ,FMTERR	;FORMAT ERROR
 	LD	HL,0-BUFFER	;CHECK FOR BYTE COUNT
 	ADD	HL,BC
 	EX	DE,HL
 	LD	HL,0F413H	;CHECK LOW LIMIT
 	ADD	HL,DE
 	LD	HL,ERMSG6	
 	JR	NC,FMTERR
 	LD	HL,0F397H
 	ADD	HL,DE
 	LD	HL,ERMSG7	;MOTOR TOO SLOW
 	JR	C,FMTERR
 	XOR	A		;WRITE WAS OK
 	RET			;DONE
 FMTERR	CALL	PRINT		;PRINT MESSAGE
 	JP	BADWRT		;LOCKOUT THE DRIVE
 VERIFY	LD	HL,LOCKTBL	;SEE IF USING DRIVE
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)		;LOCKED OUT ?
 	OR	A
 	RET	NZ
 	LD	BC,BUFFER	;READ BUFFER
 	LD	(BPOINT),BC	;SAVE IN BUFFER POINTER
 	LD	A,(DRIVE)
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(VDR),A
 	RST	8
 	DB	13
 	CALL	GETTRK
 	LD	DE,(TRAK)	;TRACK/SECTOR
 	LD	A,D
 	RST	28H
 	LD	(VRTK),A
 	LD	(VRTK+1),BC
 	LD	IX,POINTER	;READ TYPE POINTER
 VERLOOP	LD	BC,(BPOINT)	;VERIFY BUFFER
 	LD	A,B		;GET BUFFER
 	RST	30H		;HEX ASCII
 	LD	(BUFF5),HL	;TO STRING
 	LD	A,E		;GET SECTOR
 	RST	28H
 	LD	(VSC),A
 	LD	(VSC+1),BC
 	RST	8
 	DB	1DH
 	DB	'Verifying Drive '
 VDR	DB	'0, Track '
 VRTK	DB	'000, Sector '
 VSC	DB	'000, Buffer '
 BUFF5	DB	'0000H.',3
 	LD	BC,VERBUFF	;VERIFY READ BUFFER
 	CALL	BAIL		;CHECK BREAK KEY
 	LD	A,E
 	LD	(ESAV1),A
 	LD	A,(STPR)
 	CP	'S'
 	JR	Z,VRDGO
 	LD	A,D		;GET TRACK
 	OR	A
 	JR	NZ,VRDGO
 	LD	A,E
 	CP	1
 OSEC	EQU	$-1
 	JR	NZ,VRDGO
 	LD	E,10
 NSEC	EQU	$-1
 VRDGO	CALL	READ
 	LD	E,0
 ESAV1	EQU	$-1
 	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 	LD	A,(RESULT)	;GET READ RESULT
 	CP	(IX)		;SAME ?
 	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 	INC	IX
 	LD	HL,(BPOINT)	;GET BUFFER POINTER
 	PUSH	DE		;SAVE TRACK/SECTOR
 	LD	DE,VERBUFF	;VERIFY BUFFER
 	LD	B,0		;1 SECTOR
 	CALL	COMPARE		;COMPARE 'EM
 	POP	DE
 	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 VERIFGO	LD	HL,(BPOINT)	;BUMP IT
 	INC	H
 	LD	(BPOINT),HL	;PUT IT BACK
 	INC	E		;BUMP SECTOR
 	LD	A,E
 	SUB	0AH
 	JR	NZ,VERCONT	;CONTINUE IF NOT AT END
 	LD	E,A		;E=0
 	INC	D
 	LD	A,D		;GET TRACK
 	RST	28H
 	LD	(VRTK),A
 	LD	(VRTK+1),BC
 VERCONT	LD	BC,(BPOINT)	;GET BUFFER POINTER
 	LD	A,B		;GET MSB
 	OR	A		;SET FLAGS FOR TOPMEM
 	JP	Z,SAVETRK	;END OF BUFFER
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	JP	NC,SAVETRK	;END OF DISK
 	JP	VERLOOP		;GO LOOP
 COMPARE	LD	A,(DE)		;GET A BYTE
 	CP	(HL)		;SAME ?
 	RET	NZ		;NOPE IF NZ
 	INC	HL
 	INC	DE		;BUMP POINTERS
 	DJNZ	COMPARE		;CONTINUE 100H BYTES
 	RET			;Z FLAG SET
 MWRITE	LD	HL,LOCKTBL	;POINT TO LOCK TABLE
 	LD	A,(DRIVE)	;BINARY DRIVE
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)		;IS DRIVE LOCKED OUT ?
 	OR	A
 	RET	NZ		;QUIT IF FAULTY DRIVE
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(WDR),A
 	RST	8
 	DB	13
 	CALL	GETTRK		;SETUP 37EDH TRACK REG
 	LD	A,D
 	RST	28H
 	LD	(WRTK),A
 	LD	(WRTK+1),BC
 	LD	BC,BUFFER	;POINT TO BUFFER
 	LD	IX,POINTER	;FOR WRITE TYPE
 WRITELP	LD	A,(IX)		;GET TABLE BYTE
 	INC	IX		;BUMP POINTER
 	AND	60H		;GET READ TYPE
 	SRA	A		;MOVE TO LOW BITS
 	SRA	A
 	SRA	A
 	SRA	A
 	SRA	A
 	OR	0A8H		;MAKE WRITE COMMAND
 	LD	(WRTYPE+1),A	;SAVE IN CODE
 	PUSH	BC
 	LD	A,B
 	RST	30H
 	LD	(BUFF3),HL
 	LD	A,E
 	RST	28H
 	LD	(WRSC),A
 	LD	(WRSC+1),BC
 	RST	8
 	DB	1DH
 	DB	'Writing   Drive '
 WDR	DB	'0, Track '
 WRTK	DB	'000, Sector '
 WRSC	DB	'000, Buffer '
 BUFF3	DB	'0000H.',3
 	POP	BC
 	CALL	BAIL		;CHECK BREAK KEY
 	LD	A,E
 	LD	(ESAV2),A
 	LD	A,(STPR)
 	CP	'S'
 	JR	Z,WCKGO
 	LD	A,D
 	OR	A
 	JR	NZ,WCKGO
 	LD	A,(OSEC)
 	CP	E
 	JR	NZ,WCKGO
 	LD	A,(NSEC)
 	LD	E,A
 WCKGO	CALL	WRITE
 	LD	E,0
 ESAV2	EQU	$-1
 	JR	NZ,BADWRT	;NZ=BAD
 	INC	E		;BUMP SECTOR
 	LD	A,E
 	SUB	0AH		;END OF TRACK ?
 	JR	NZ,WRITEEN
 	LD	E,A		;E=0
 	INC	D		;BUMP TRACK
 	PUSH	BC
 	LD	A,D
 	RST	28H
 	LD	(WRTK),A
 	LD	(WRTK+1),BC
 	POP	BC
 WRITEEN	LD	A,B		;GET BUFFER POINTER
 	OR	A		;END OF MEMORY ?
 	JP	Z,SAVETRK
 	LD	A,D		;GET TRACK
 	CP	(IY)		;END OF DISK ?
 	JP	NC,SAVETRK
 	JP	WRITELP		;ELSE CONTINUE
 BADWRT	LD	HL,LOCKTBL	;LOCKOUT THE DRIVE
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	(HL),-1		;LOCK IT OUT
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(BADDR),A
 	RST	8
 	DB	'Drive '
 BADDR	DB	'0 LOCKED OUT !',13
 	OR	1
 	RET			;QUIT
 COPYBYE	RST	8		;MESSAGE
 	DB	13		;CARRIAGE RETURN
 	RST	20H		;UPDATE # OF COPIES
 	LD	A,(REQUEST)	;GET REQUEST #
 	LD	B,A
 	LD	A,(FINISHED)	;HOW MANY DONE
 	CP	B		;DONE YET ?
 	JP	C,START		;MOUNT DISKETTES
 	RST	8		;DISPLAY DONE MESSG
 	DB	10,'All copies finished.  <ENTER> to restart. ',3
 	LD	B,1
 	RST	10H
 	JP	ENTRY
 ASCII	PUSH	HL		;SAVE IT
 	CALL	ASCI		;CONVERT LOW PART
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI		;CONVERT HIGH PART
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,30H
 ASCII1	SUB	0AH
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 STEPIN	CALL	SELECT		;TURN ON DRIVE
 	LD	A,(SPEED)
 	AND	3
 	OR	58H
 	LD	(37ECH),A	;GIVE TO CONTROLLER
 	CALL	DSKSLO		;WAIT TO TEST STATUS
 STEPWT	CALL	SELECT		;KEEP DRIVE ON
 	LD	A,(37ECH)	;GET STATUS
 	BIT	0,A
 	JR	NZ,STEPWT	;WAIT TILL INVERTED
 	BIT	4,A
 	RET			;DONE
 PTITLE	LD	A,(VFLAG)
 	LD	(VERON),A
 	LD	HL,MSG0
 	LD	DE,3C00H
 	LD	B,64
 	CALL	PUTITON
 	LD	DE,3C80H
 	LD	HL,MSG99
 SHMGX	LD	B,64
 	CALL	PUTITON
 	LD	A,(SERONOFF)
 	CP	'N'
 	RET	Z
 	LD	A,(SERLEN)
 	OR	A
 	RET	Z
 	LD	HL,SERIALNO
 	LD	DE,3CD7H
 	LD	A,(SERLEN)
 	LD	B,A
 	JP	PUTITON
 MSG99	DB	'Step='
 ST81	DB	'0, Prot='
 ST82	DB	'N, Serial Number='
 ST83	DB	'N, Increment='
 ST84	DB	'N, Osec='
 ST85	DB	'0, Nsec='
 ST86	DB	'000.                   '
 VALUE	LD	A,B		;LENGTH
 	CP	3		;MAKE IT 3 BYTES
 	JR	Z,VALGO		;HAVE 3 CHAR
 	DEC	HL		;POINTER
 	LD	(HL),'0'	;MAKE IT ZERO
 	INC	B		;LENGTH + 1
 	JR	VALUE		;CONTINUE
 VALGO	LD	D,0		;0 START VALUE
 VALOOP	LD	A,(HL)		;GET A BYTE
 	CALL	MAKNUM
 	RET	C		;BAD NUMBER
 	CALL	BYTEN		;A * 10
 	CALL	BYTEN		;A * 100
 	ADD	A,D		;ADD TO TOTAL
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	RET	C
 	CALL	BYTEN		;A * 10
 	ADD	A,D		;RESULT
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	ADD	A,D
 	LD	C,A
 	LD	B,0		;BC=RESULT
 	SCF
 	CCF			;CLEAR CARRY
 	RET
 BYTEN	LD	B,10		;MULTIPLIER
 	PUSH	DE		;SAVE DE
 	LD	E,A
 	LD	D,0		;DE=MULTIPLICAND
 	PUSH	HL		;SAVE POINTER
 	LD	HL,0		;START VALUE
 BYLOOP	SRL	B		;MULTIPLIER BIT
 	JR	NC,BYCONT	;GO IF EVEN NUMBER
 	ADD	HL,DE		;ADD TO TOTAL
 BYCONT	JR	Z,BYDONE
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	BYLOOP		;CONTINUE
 BYDONE	LD	A,L		;GET PRODUCT
 	POP	HL
 	POP	DE		;RESTORE PREVIOUS
 	RET			;A=NUMBER
 MAKNUM	SUB	30H		;REMOVE ASCII
 	RET	C		;BAD NUMBER
 	CP	0AH		;>9 ?
 	CCF			;REVERSE CARRY FLAG
 	RET			;FINISHED
 HEXCV	LD	C,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	HEXTST
 	LD	H,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PUTITON	EX	DE,HL		;HL=VIDEO, DE=TEXT
 PUTITLP	LD	A,(DE)		;GET A TEXT BYTE
 	LD	(HL),A		;PRINT IT
 	CP	(HL)		;STILL THERE ?
 	JR	Z,PUTITNX	;LOWERCASE INSTALLED
 	SUB	20H		;MAKE IT UPPER CASE
 	LD	(HL),A		;REPRINT IT
 PUTITNX	INC	HL		;BUMP POINTERS
 	INC	DE
 	DJNZ	PUTITLP		;CONTINUE
 	RET			;DONE
 ADDC	INC	C
 	LD	A,7
 	ADD	A,B
 	LD	B,A
 	RET
 NEXTSERIAL	LD	A,'N'
 SERONOFF	EQU	$-1
 	CP	'N'
 	RET	Z
 	PUSH	DE
 	PUSH	BC
 	RST	18H
 	LD	DE,0
 SERBUF	EQU	$-2
 BFFIN	LD	HL,SERIALNO
 	LD	B,0
 	LD	C,0
 SERLEN	EQU	$-1
 	LDIR
 	LD	A,'N'
 INCONOFF	EQU	$-1
 	CP	'N'
 	POP	BC
 	POP	DE
 	RET	Z
 	LD	HL,SERIALNO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	POP	BC
 	DEC	HL
 NEXTSLP	LD	A,(HL)
 	INC	A
 	LD	(HL),A
 	CP	3AH
 	RET	C
 	LD	(HL),'0'
 	DEC	HL
 	JR	NEXTSLP
D	HL,SERIALNO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	POP	BC
 	DEC	HL
 NEXTSLP	LD	A,(HL)
