DISKIO ;	diskio/asm
 ;
 ;  SELECT A DISK DRIVE
 ;  ENTRY:	(DRIV)=CORRECT BIT SET FOR DRIVE
 ;		1=0, 2=1, 4=2, 8=3
 ;  EXIT:	ERROR MESSAGE DISPLAYED IF NOT READY
 ;		A REG. DESTROYED
 ;		ALL OTHERS MAINTAINED
 ;	WAIT 1/4 SECOND FOR MOTOR SPEED IF
 ;		DRIVE IS NOT RUNNING
 SELECT	LD	A,(37ECH)		;GET DRIVE 37EFH
 	BIT	7,A		;CHECK IF MOTOR ON
 	LD	A,(DRIV)	;GET DRIVE BIT
 	LD	(37E1H),A	;SELECT IT
 	RET	Z		;DRIVE ALREADY ON
 	PUSH	BC		;SAVE BC
 	LD	BC,0
 	CALL	DELAY		;DO IT
 	POP	BC		;RESTORE IT
 	JR	SELECT
 ;
 ;  RESTORE A DISK DRIVE
 ;  ENTRY:	(DRIV)=CORRECT BIT FOR DRIVE
 ;  EXIT:	ERROR MESSAGE DISPLAYED IF NOT IN SYSTEM
 ;		A REG. DESTROYED
 ;		ALL OTHERS MAINTAINED
 RESTOR	CALL	SELECT		;SELECT DRIVE
 	LD	A,(SPEED)
 	AND	3
 	OR	8
 	LD	(37ECH),A	;GIVE TO CONTROLLER
 	CALL	DSKSLO		;WAIT FOR VALID STATUS
 RESWT	CALL	SELECT		;KEEP MOTOR ON
 	LD	A,(37ECH)	;GET STATUS BYTE
 	BIT	0,A		;BUSY BIT
 	JR	NZ,RESWT	;NOT FINISHED
 	BIT	2,A		;HEAD OVER TRACK 0 ?
 	RET	NZ
 	LD	HL,ERMSG2	;DRIVE NOT IN SYSTEM
 	JP	ERROR		;DISPLAY AND GO DOS
 DSKSLO	PUSH	BC
 	LD	B,12
 	DJNZ	$
 	POP	BC
 	RET
 ;
 ;  READ A DISK SECTOR
 ;  ENTRY:	(DRIV)=DRIVE TO BE SELECTED
 ;		DE = TRACK/SECTOR TO READ
 ;		BC = LOAD ADDRESS
 ;		C FLAG SET IF DIRECTORY READ
 ;  EXIT:	DE = MAINTAINED
 ;		BC = LAST BYTE IN BUFFER + 1
 ;		HL = DESTROYED
 ;		Z FLAG SET IF OK ELSE A = ERROR CODE
 READ	PUSH	BC		;SAVE LOAD
 	CALL	READ1		;TRY ONE TIME
 	POP	HL		;RESTORE LOAD ADDRESS
 	RET	Z
 	LD	B,H		;HL=>BC
 	LD	C,L
 	PUSH	HL
 	CALL	READ1
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 	RET	Z
 	JP	IOERR
 READ1	CALL	SELECT		;TURN ON DRIVE
 	LD	(37EEH),DE	;TRACK/SECTOR
 	LD	HL,37ECH	;FDC
 	LD	A,(SPEED)	;GET SPEED BYTE
 	AND	3		;LOW 2 BITS ONLY
 	OR	18H		;MAKE SEEK COMMAND
 	LD	(HL),A		;TO FDC
 	CALL	DSKSLO		;WAIT FOR VALID STATUS
 RDSK	CALL	SELECT		;KEEP MOTOR ON
 	LD	A,(HL)		;GET STATUS
 	RRCA			;SHIFT BUSY BIT
 	JR	C,RDSK		;WAIT SOME MORE
 	DI
 	LD	(HL),88H	;READ SECTOR
 	PUSH	DE		;SAVE TRACK/SECTOR
 	LD	DE,37EFH	;TRANSFER ADDRESS
 	CALL	DSKSLO		;WAIT 8 MS.
 	JR	RDCK		;TRANSFER DATA
 RDTST	RRCA			;SHIFT BUSY BIT
 	JR	NC,RDDONE	;DONE IF NOT SET
 RDCK	LD	A,(HL)		;GET STATUS
 	BIT	1,A		;BYTE READY ?
 	JR	Z,RDTST		;WAIT IF NOT SET
 	LD	A,(DE)		;GET A BYTE
 	LD	(BC),A		;PUT IN BUFFER
 	INC	BC		;BUMP POINTER
 	JR	RDCK		;WAIT FOR NEXT BYTE
 RDDONE	LD	A,(HL)		;GET OPERATION STATUS
 	LD	(RESULT),A	;SAVE STATUS
 	AND	9FH		;CHECK STATUS
 	POP	DE		;RESTORE TRACK/SECTOR
 	LD	(HL),0D0H
 	EI
 	RET
 ;  WRITE A DISK SECTOR
 ;  ENTRY & EXIT SAME AS READ
 WRITE	PUSH	BC
 	CALL	WRITE1
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 	PUSH	HL
 	CALL	WRITE1
 	POP	HL
 	RET	Z
 	LD	B,H
 	LD	C,L
 	RET	Z
 	JP	IOERR
 WRITE1	LD	(37EEH),DE	;TRACK/SECTOR
 	LD	HL,37ECH	;FDC
 	LD	A,(SPEED)	;SPEED BYTE
 	AND	3
 	OR	18H
 	LD	(HL),A		;SEEK COMMAND
 	CALL	DSKSLO		;8 MS.
 WRSK	CALL	SELECT		;MOTOR ON FOR LONG SEEK
 	LD	A,(HL)		;STATUS
 	RRCA
 	JR	C,WRSK		;WAIT TILL READY
 	DI
 WRTYPE	LD	(HL),0A8H	;WRITE COMMAND
 	PUSH	DE		;SAVE TRACK/SECTOR
 	LD	DE,37EFH	;TRANSFER ADDRESS
 	CALL	DSKSLO
 	JR	WRCK
 WRBZ	RRCA
 	JR	NC,WRDONE
 WRCK	LD	A,(HL)
 	BIT	1,A
 	JR	Z,WRBZ
 	LD	A,(BC)
 	LD	(DE),A		;TO CONTROLLER
 	INC	BC
 	JR	WRCK
 WRDONE	LD	A,(HL)
 	LD	(RESULT),A	;SAVE IT
 	OR	A
 	POP	DE		;RESTORE TRACK/SECTOR
 	LD	(HL),0D0H	;FORCE INTERRUPT
 	EI
 	RET
 IOERR	LD	A,(RESULT)	;GET STATUS BYTE
 	LD	HL,ERMSG1	;NOT READY
 	BIT	7,A		;TEST THE BIT
 	RET	NZ
 	LD	HL,ERMSG11	;WRITE PROTECT ?
 	BIT	6,A		;CHECK IT
 	RET	NZ
 	LD	HL,ERMSG3	;TRACK/SECTOR NOT FOUND
 	BIT	4,A		;TEST
 	RET	NZ
 	LD	HL,ERMSG4	;ERROR IN ID/DATA FIELD
 	BIT	3,A		;TEST
 	RET	NZ
 	LD	HL,ERMSG5	;DATA LOST
 	BIT	2,A		;TEST
 	RET			;DONE
 GETTRK	PUSH	HL		;SAVE HL
 	LD	HL,CTRACK	;CURRENT TRACK TABLE
 LOKTBL	LD	A,(DRIVE)	;GET BINARY DRIVE
 	ADD	A,L		;POINT TO BYTE
 	LD	L,A		;GIVE TO L
 	LD	A,(HL)		;GET DRIVE BYTE
 	LD	(37EDH),A	;GIVE TO TRACK REGISTER
 	OR	A		;SET FLAGS
 	CALL	Z,RESTOR	;RESTORE IF TRACK 0
 	POP	HL		;RESTORE HL
 	RET			;DONE
 SAVETRK	PUSH	HL
 	LD	HL,CTRACK
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(37EDH)	;GET TRACK FROM FDC
 	LD	(HL),A		;SAVE IN TABLE
 	POP	HL		;RESTORE HL
 	RET			;DONE
 	POP	HL		;RESTORE HL
 	RET			;DONE
 SAVETRK	PUSH	HL
 	LD	HL,CTRACK
