IODVR/ 	DB	0
 ;	IODVR/ASM
 ; SPLIT SCREEN DISPLY IN 3 PARTS
 ;	DRIVERS ONLY USE MIDDLE PART
 ;	USER MAY DEFINE AND USE TOP AND BOTTOM PARTS
 ;  BELOW WILL OUTPUT A STRING POINTED TO BY HL
 ;	TO THE PRINTER OR VIDEO
 ;	TERMINATORS ARE 3 AND 0DH
 ;  CALL "DISPLY" TO PRINT BYTES FOLLOWING CALL, AND RET.
 ;	TO BYTE FOLLOWING THE TERMINATOR
 DISPLY	LD	HL,DISPRET	;RETURN ADDRESS
 	EX	(SP),HL		;GET DATA POINTER FROM ST
 PRINT	LD	A,(HL)		;GET BYTE FROM STRING
 	INC	HL		;BUMP STRING POINTER
 	CP	3		;TERMINATOR
 	RET	Z
 	CALL	VOUT		;OUTPUT TO VIDEO
 	CP	0DH		;TERMINATOR ?
 	RET	Z
 	JR	PRINT		;GO SOME MORE
 DISPRET	JP	(HL)		;GO TO BYTE AFTER TERM.
 LPRINT	LD	A,(HL)
 	INC	HL
 	CP	3
 	RET	Z
 	CALL	POUT
 	CP	0DH
 	JR	NZ,LPRINT	;GO AGAIN
 	RET			;DONE
 ;  GET A STRING FROM KEYBOARD
 ;	HL => BUFFER TO SAVE CHARACTERS
 ;	B = LENGTH OF INPUT
 ;  CALL GETSTR TO DEFAULT TO INTERNAL STRING AREA & 64 CH
 ;  CALL GETSTR+2 TO SUPPLY LENGTH IN B REG.
 ;  CALL INPUT TO SUPPLY BUFFER & LENGTH
 GETSTR	LD	B,63		;64 CHAR. INCL. ENTER
 	LD	HL,STRING	;INTERNAL AREA
 INPUT	EX	DE,HL		;DE=>BUFFER
 	LD	(BUFPNT),DE	;SAVE BUFFER POINTER
 CLRST	LD	DE,(BUFPNT)	;CLEAR KEY RESTART
 	LD	C,0		;START LENGTH
 INLP1	LD	HL,(CURSOR)	;CURSOR POSITION
 CR1	PUSH	BC
 	LD	BC,500H
 	LD	(FLDLY),BC
 	POP	BC
 	LD	A,95
 	JR	INLP2
 CON1	LD	A,0B0H
 INLP2	LD	(HL),A		;PUT ON VIDEO
 	CALL	KEYIN		;STROBE KEYBOARD
 	JR	NZ,HAVKEY	;HAVE ONE
 	PUSH	BC
 	LD	BC,500H
 FLDLY	EQU	$-2
 	DEC	BC
 	LD	(FLDLY),BC
 	LD	A,B
 	OR	C
 	POP	BC
 	JR	NZ,INLP2+1
 	PUSH	BC
 	LD	BC,500H
 	LD	(FLDLY),BC
 	POP	BC
 	LD	A,(HL)		;GET CURSOR CHAR
 	CP	95
 	JR	Z,CON1
 	LD	A,95
 	JR	INLP2		;CONTINUE
 HAVKEY	LD	(HL),20H	;CURSOR OFF
 	CP	0DH		;ENTER ?
 	JR	Z,INDONE	;DONE
 	CP	5DH		;LEFT ARROW ?
 	JR	Z,BCKSPA
 	CP	18H		;SH LEFT ARROW ?
 	JR	Z,RESTRT
 	CP	3		;CLEAR
 	JR	Z,RESTRT	;RESTART WITH THIS TOO
 	LD	(DE),A		;SAVE IN BUFFER
 	LD	A,C		;CURRENT LENGTH
 	CP	B		;REQUESTED LENGTH
 	JR	NC,INLP1	;DON'T TAKE IT
 	LD	A,(DE)		;GET BYTE BACK
 	CALL	VOUT		;PUT ON SCREEN
 	INC	DE		;BUMP BUFFER POINTER
 	INC	C		;BUMP LENGTH
 	JR	INLP1		;GO SOME MORE
 INDONE	LD	(DE),A		;TERMINATE
 	LD	(HL),20H	;CLEAR CURSOR
 	CALL	VOUT		;C/R TO VIDEO
 	LD	HL,(BUFPNT)	;GET BUFFER POINTER
 	LD	B,C		;LENGTH
 	LD	A,B		;FOR FLAGS
 	OR	A		;SET IF ANY INPUT
 	LD	A,(HL)		;A=FIRST CHARACTER
 	RET			;DONE
 BCKSPA	LD	(CHAR),A	;FOR CURSOR
 	LD	A,C		;GET LENGTH
 	OR	A		;ANY INPUT ?
 	JR	Z,INLP1		;CAN'T BACKSPACE
 	DEC	C		;LENGTH -1
 	DEC	DE		;BUFFER POINTER
 	LD	A,8		;BACKSPACE CHARACTER
 	CALL	VOUT		;UPDATE CURSOR
 	JR	INLP1		;GO
 RESTRT	LD	A,5DH		;L ARROW
 	LD	(CHAR),A	;TO CURSOR
 	LD	A,C		;ANY LENGTH ?
 	OR	A		;FLAGS SET
 	JR	Z,INLP1		;GO
 	DEC	DE		;GO BACK ONE SPACE
 	DEC	C		;LESS ONE CHARACTER
 	LD	A,8		;BACKSPACE CHARACTER
 	CALL	VOUT		;TO VIDEO
 	JR	RESTRT		;GO TILL DONE
 POUT	PUSH	AF		;SAVE OUTPUT BYTE
 PWAIT	LD	A,(37E8H)	;GET PRINTER STATUS
 	AND	0C0H		;CHECK IT
 	JR	Z,PGO		;SEND IT
 	LD	A,(3840H)	;CHECK BREAK KEY
 	BIT	2,A		;IS IT SET ?
 	JR	NZ,PDCAN	;QUIT IF PRESSED
 	JR	PWAIT		;WAIT IF NOT
 PGO	POP	AF		;GET CHARACTER
 	LD	(37E8H),A	;GIVE TO PRINTER
 	RET			;DONE
 PDONE	POP	AF		;RESTORE STACK
 	RET			;DONE
 PDCAN	LD	(KYBRD+6),A	;PUT IN TEST MASK
 ;				;SO KEY NOT RETURNED
 	JR	PDONE		;RETURN
 VOUT	PUSH	HL		;SAVE HL
 	LD	HL,(CURSOR)	;GET CURSOR POSITION
 	CP	20H		;CONTROL BYTE ?
 	JR	C,GOCTL		;DO CONTROL IF <20H
 CTLRET	LD	(HL),A		;PUT ON VIDEO
 	CP	(HL)		;STILL THERE ?
 	JR	Z,VOK		;LOWERCASE IF YES
 	SUB	20H		;MAKE IT UPPER
 	LD	(HL),A		;PUT IT BACK
 VOK	INC	HL		;BUMP CURSOR
 VDONE	PUSH	AF		;SAVE BYTE
 	LD	A,H		;GET MSB CURSOR
 	CP	3CH		;STILL ON VIDEO ?
 	CALL	C,NEWCUR	;PUT AT TOP IF YES
 	CP	40H		;NEED A SCROLL ?
 	CALL	NC,SCROLL	;DO IT
 	POP	AF		;RESTORE CHARACTER
 	LD	(CURSOR),HL	;UPDATE CURSOR POSIT
 	POP	HL		;RESTORE HL
 	RET			;DONE
 ;  CHECK TO SEE IF CURSOR IS WITHIN BOUNDRIES
 NEWCUR	LD	HL,(VIDTOP)	;GET START POSITION
 	LD	A,H		;GET H BACK
 	RET
 GOCTL	CP	8		;BACKSPACE ?
 	JR	Z,BAKSP
 	CP	9		;FORE TAB ?
 	JR	Z,FORESP
 	CP	6		;BACK TAB ?
 	JR	Z,BAKTAB
 	CP	0AH		;LINEFEED ?
 	JR	Z,LINFED	;DO IT
 	CP	0DH		;CARRIAGE RETURN ?
 	JR	Z,LINFED	;DO IT
 	CP	1CH		;HOME CURSOR ?
 	JR	Z,HOME
 	CP	1FH		;CLEAR ?
 	JR	Z,CLEAR
 	CP	1DH		;BEGIN LINE
 	JR	Z,BLINE
 	CP	1EH		;ERASE LINE
 	JR	Z,ERASE
 	LD	A,5DH		;UNDEFINED BYTE DISPLY
 	JR	CTLRET		;CONTINUE
 BAKSP	LD	(HL),20H	;ERASE CHARACTER
 	DEC	HL		;GO BACK
 	JR	VDONE		;DONE
 FORESP	PUSH	AF		;SAVE OUTPUT BYTE
 	PUSH	DE		;SAVE DE
 	LD	A,L		;GET LSB
 	AND	0F0H		;MASK LOW 4 BITS
 	LD	L,A		;BACK TO CURSOR LSB
 	LD	DE,10H		;MOVE CURSOR RIGHT
 	ADD	HL,DE		;POINT TO CURSOR + COLUMN
 	POP	DE		;RESTORE DE
 	POP	AF		;AND CHARACTER
 	JR	VDONE		;DONE
 BAKTAB	PUSH	AF
 	PUSH	DE
 	LD	A,L
 	AND	0F0H
 	LD	L,A
 	LD	DE,-10H
 	ADD	HL,DE
 	POP	DE
 	POP	AF
 	JR	VDONE
 LINFED	PUSH	DE		;SAVE DE
 	LD	DE,40H		;ONE LINE DOWN
 	PUSH	AF		;SAVE CHAR
 	LD	A,L		;GET LSB
 	AND	0C0H		;START OF LINE
 	LD	L,A		;PUT IT BACK
 	POP	AF		;RESTORE AF
 	ADD	HL,DE		;DROP DOWN A LINE
 	POP	DE		;RESTORE DE
 	JR	VDONE		;FINISHED
 HOME	LD	HL,(VIDTOP)
 	JR	VDONE
 CLEAR	PUSH	AF		;SAVE CHARACTER
 	PUSH	DE		;SAVE DE
 	EX	DE,HL		;DE=CURSOR
 	LD	HL,4000H	;END OF SCREEN
 CLICO	OR	A		;CLEAR CARRY
 	SBC	HL,DE		;# BYTES TO MOVE
 	EX	DE,HL		;HL=CURSOR,DE=NUMBER
 	PUSH	HL		;SAVE CURSOR
 CLINE	LD	(HL),20H	;PUT A SPACE
 	DEC	DE		;LESS COUNT
 	INC	HL
 	LD	A,D
 	OR	E		;ANY BITS LEFT ON ?
 	JR	NZ,CLINE	;CONTINUE
 	POP	HL		;RESTORE
 	POP	DE
 	POP	AF
 	JP	VDONE		;GO BACK
 ERASE	PUSH	AF		;SAVE BYTE
 	PUSH	DE
 	LD	A,L
 	AND	0C0H		;PUT CURSOR AT BOL
 	LD	L,A
 	EX	DE,HL		;DE=CURSOR
 	LD	H,D		;GET MSB
 	LD	A,E		;GET LSB
 	OR	3FH		;END OF LINE
 	LD	L,A
 	JR	CLICO		;CONTINUE
 BLINE	PUSH	AF		;SAVE BYTE
 	LD	A,L		;GET LSB
 	AND	0C0H		;BEGINNING OF LINE
 	LD	L,A		;PUT IT BACK
 	POP	AF		;RESTORE BYTE
 	JP	VDONE
 SCROLL	PUSH	BC		;SAVE REGS
 	PUSH	DE
 	LD	DE,(VIDTOP)	;TOP LINE OF SCREEN
 	LD	HL,4000H	;END OF SCREEN
 	OR	A		;CLEAR CARRY
 	SBC	HL,DE		;SUBTRACT
 	LD	DE,40H		;LESS ONE MORE LINE
 	OR	A
 	SBC	HL,DE		;HL=LENGTH TO MOVE
 	PUSH	HL
 	POP	BC		;GIVE TO BC
 	LD	HL,(VIDTOP)	;GET VIDEO TOP
 	PUSH	HL		;SAVE FOR DE
 	ADD	HL,DE		;DOWN ONE LINE
 	POP	DE		;DE=TOPLINE/HL=DE+40H
 	LDIR			;MOVE THE BYTES
 	LD	HL,(VIDBOT)	;BOTTOM LINE
 	LD	B,40H		;ERASE IT
 SCR2	LD	(HL),20H
 	INC	HL
 	DJNZ	SCR2
 	POP	DE		;RESTORE REGS
 	POP	BC
 	LD	HL,(VIDBOT)	;CURSOR TO BOTTOM
 	RET			;DONE
 KEYGONE	POP	DE		;RETURN HERE TO GET REGS.
 	POP	HL
 	POP	BC
 	OR	A
 	RET			;RETURN WITH FLAGS SET
 KEYIN	PUSH	BC		;SAVE ALL REGISTERS
 	PUSH	HL
 	PUSH	DE
 	LD	HL,KEYGONE	;POINT TO RETURN ADDRESS
 	PUSH	HL		;SAVE FOR RET
 	LD	A,(KIFLAG)	;GET KEY FLAG
 	BIT	1,A		;REPEAT ON ?
 	JR	NZ,RSTCON	;NO REPEAT
 	LD	HL,LSTMSK	;LAST MASK BYTE
 	LD	A,(387FH)	;ANY KEYS PRESSED ?
 	OR	A		;SET FLAGS
 	JR	Z,SKPRPT	;SKIP IF NOT KEY
 	CP	(HL)		;TEST WITH MASK
 	LD	(HL),A		;SAVE NEW KEY
 	JR	Z,ADDRPT	;ADJUST REPEAT COUNT
 SKPRPT	LD	A,(KICOUNT)	;GET DELAY COUNT
 	LD	(RPCOUNT),A	;SAVE IN DCB
 	JR	RSTCON		;CONTINUE
 ADDRPT	LD	A,(RPCOUNT)	;GET COUNT
 	OR	A		;ANY BITS ON ?
 	JR	Z,RSTGO		;PAST FIRST REPEAT
 	DEC	A
 	LD	(RPCOUNT),A
 	JR	RSTCON
 RSTGO	LD	HL,KYBRD
 	LD	DE,KYBRD+1
 	LD	BC,6
 	LD	(HL),0
 	LDIR			;CLEAR MASK AREA
 RSTCON	LD	HL,KYBRD	;7 BYTE MASK AREA
 	LD	BC,3801H	;KEYBOARD ROW 1
 	LD	D,0		;ROW COUNTER
 NEXROW	LD	A,(BC)		;GET A BYTE
 	LD	E,A		;SAVE IT
 	XOR	(HL)		;COMPARE TO LAST KEY
 	LD	(HL),E		;SAVE NEW KEY
 	AND	E		;SAME AS LAST ?
 	JR	NZ,HAVEIT	;HAVE NEW KEY
 	INC	D		;BUMP ROW
 	INC	L		;BUMP MASK TABLE
 	RLC	C		;BUMP KEYBOARD POINTER
 	JP	P,NEXROW	;ALL BUT SHIFT KEY
 	RET			;NOTHING
 HAVEIT	LD	E,A		;SAVE HERE
 	LD	A,D		;GET ROW
 	RLCA			;* 2
 	RLCA			;* 4
 	RLCA			;* 8
 	LD	D,A		;ROW * 8
 	LD	C,1		;COLUMN MASK BIT
 KI1	LD	A,C		;GET BIT
 	AND	E		;SAME AS NEW KEY ?
 	JR	NZ,KI2		;NOPE
 	INC	D		;BUMP ROW * 8
 	RLC	C		;MOVE TEST BIT
 	JR	KI1		;KEEP GOING TILL COLUMN
 KI2	LD	A,(3880H)	;GET SHIFT KEY
 	OR	A		;FLAGS
 	LD	B,0		;SET ALL BITS IF PRESSED
 	JR	Z,KI2A		;CONTINUE IF NOT
 	DEC	B		;MAKE B FFH
 KI2A	LD	A,(3840H)	;SEE IF KEY FROM LAST ROW
 	OR	A		;FLAGS
 	JR	NZ,KI5		;GET BYTE FROM TABLE
 	LD	A,40H		;MAKE INPUT ASCII
 	ADD	A,D		;ADD TO TOTAL
 	CP	60H		;TEST FOR @-Z
 	JR	C,KI3		;@-Z GO
 	SUB	30H		;MAKE IT NUMERIC
 	CP	3CH		;TEST FOR: < = > ?
 	JR	C,KI6		;CONTINUE IF NOT
 	RRC	B		;SHIFT KEY ?
 	JR	C,KIDONE	;WORKS OPPOSITE OF
 	SUB	10H		;REST OF KEYBOARD
 	JR	KIDONE
 KI6	RRC	B		;SHIFT KEY ?
 	JR	NC,KIDONE	;DON'T ADJUST
 	SUB	10H		;SHIFT NUMBERS
 	CP	20H		;SH 0 ?
 	JR	NZ,KIDONE	;NOPE
 	LD	A,5		;CONTROL FOR SH 0
 	JR	KIDONE		;GO NOW
 KI3	LD	D,A		;SAVE INPUT
 	LD	A,(KIFLAG)	;GET FLAG
 	BIT	0,A		;LOWER CASE ON ?
 	LD	A,D		;KEY BACK
 	JR	Z,KIDONE	;DON'T ADJUST FOR SHIFT
 	RRC	B		;GET SHIFT BIT
 	JR	C,KIDONE	;SHIFT, KEEP UPPER CASE
 	ADD	A,20H		;OTHERWISE MAKE LOWER
 	JR	KIDONE
 KI5	LD	A,D		;GET BYTE
 	AND	7		;COLUMN POSITON
 	SLA	A		;DOUBLE IT FOR TABLE
 	LD	C,A
 	RRC	B		;GET SHIFT
 	JR	NC,SKKI		;NO SHIFT
 	INC	C		;ADJUST FOR SHIFT ENTRY
 SKKI	LD	B,0		;FOR TABLE
 	LD	HL,KEYTBL	;POINT TO TABLE
 	ADD	HL,BC		;POINT TO ASCII
 	LD	A,(HL)		;GET THE BYTE
 KIDONE	LD	D,A		;SAVE FROM DEBOUNCE
 DEBNCE	LD	BC,1000H	;DEBOUNCE DELAY
 	CALL	DELAY		;WAIT
 	LD	A,D		;GET CHAR BACK
 	CP	2		;SH BREAK ?
 	JP	Z,ENTRY0		;RESTART PROGRAM
 	CP	1		;BREAK ?
 	JP	Z,START0		;RESTART LOOP
 	CP	14		;SH ENTER?
 	JR	Z,VID		;GO VIDEO PRINTER
 	CP	4		;SH CLEAR ?
 	JR	Z,RPTONF	;REPEAT ON/OFF
 	CP	5		;SH 0 ?
 	JR	Z,ADJGRP	;ADJUST GRAPHICS BIT
 	CP	80H		;SH SPACE ?
 	JR	Z,ULFLAG
 	LD	D,A		;SAVE AGAIN
 	LD	A,(KIFLAG)	;KEYBOARD FLAG
 	AND	80H		;GRAPHIC BIT ON ?
 	LD	A,D		;KEY BACK
 	RET	Z		;NO ADJUST
 	CP	40H		;AT LEAST ALPHABET
 	RET	C		;NO ADJUST <40H
 	ADD	A,40H		;MAKE IT GRAPHICS
 	RET			;DONE
 START0	CALL	CLEARS
 	JP	START
 ENTRY0	CALL	CLEARS
 	JP	ENTRY
 CLEARS	LD	A,1CH		;HOME CURSOR
 	CALL	VOUT		;PRINT IT
 	LD	A,1FH		;CLEAR TO EOF
 	CALL	VOUT		;DO IT
 	LD	A,4
 	RET
 ULFLAG	LD	A,(KIFLAG)	;GET UPPER/LOWER FLAG
 	XOR	1		;REVERSE BIT
 ADJCON	LD	(KIFLAG),A	;SAVE IT
 	XOR	A		;ZERO FOR INPUT
 	RET
 RPTONF	LD	A,(KIFLAG)	;GET FLAG
 	XOR	2
 	JR	ADJCON
 ADJGRP	LD	A,(KIFLAG)	;GET FLAG BYTE
 	XOR	80H
 	JR	ADJCON		;CONTINUE
 VID	LD	B,16		;16 LINES
 	LD	HL,3C00H	;TOP OF VIDEO
 VIDE1	LD	C,64		;CHAR/LINE
 	PUSH	HL		;SAVE BEGIN OF LINE
 	LD	A,L
 	ADD	A,3FH		;POINT TO END
 	LD	E,A		;GIVE TO DE
 	LD	D,H
 VIDE3	LD	A,(DE)		;GET BYTE FROM END
 	CP	20H		;SPACE ?
 	JR	NZ,VIDIT	;LAST CHAR IN LINE
 	DEC	DE		;LESS ONE
 	DEC	C		;LESS COUNT
 	JR	NZ,VIDE3	;GO MORE
 VIDLIN	LD	A,0AH		;LINEFEED
 	CALL	POUT		;GIVE TO PRINT
 	LD	A,0DH		;CARRIAGE RETURN
 	CALL	POUT		;PRINT IT
 VIDNEX	POP	HL		;START OF LINE
 	LD	DE,40H		;CHAR/LINE
 	ADD	HL,DE		;NEXT LINE
 	DJNZ	VIDE1		;FOR 16 LINES
 	XOR	A		;NO INPUT
 	RET			;DONE
 VIDIT	INC	DE		;END + 1
 VIDIT1	LD	A,(PRFLAG)	;GET GRAPHICS TEST
 	AND	80H		;TEST FOR PRINTER GRAPHIC
 	LD	A,(HL)		;GET BYTE
 	JR	NZ,VID4		;DON'T ADJUST
 	BIT	7,A		;GRAPHICS ?
 	JR	Z,VID4		;SKIP ADJUST IF NOT
 	LD	A,'.'		;OTHERWISE, USE PERIOD
 VID4	CP	20H		;CONTROL BYTE ?
 	JR	NC,VID5		;DON'T ADJUST IF NOT
 	LD	A,'.'		;PERIOD FOR THIS TOO
 VID5	CALL	POUT		;SEND TO PRINTER
 	INC	HL		;BUMP VIDEO POINTER
 	PUSH	HL		;SAVE FOR TEST
 	OR	A		;CLEAR CARRY FLAG
 	SBC	HL,DE		;TEST END OF LINE
 	POP	HL		;RESTORE POINTER
 	JR	NZ,VIDIT1	;CONTINUE IF NOT AT END
 	JR	VIDLIN		;OUTPUT CARRIAGE RETURN
 DELAY	DEC	C		;DELAY COUNTER
 	JR	NZ,DELAY
 	DJNZ	DELAY
 	RET
 	END
RY FLAG
 	SBC	HL,DE		;TEST END OF LINE
 	POP	HL		;RESTORE POINTER
 	JR	NZ,VIDIT1	;CONTINUE IF NOT AT END
 	JR	VIDLIN		;OUTPUT CARRIAGE RETURN
 DELAY	DEC	 	ADD	HL,DE		;NEXT LINE
 	DJNZ	VIDE1		;FOR 16 LINES
 	XOR	A		;NO IN