HOWTOD 	ORG	$
 ;	HOWTODO/ASM
 PREENTRY	DI
 	LD	SP,STACK
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	A,32		;TURN OFF HI-RES GRAPHICS
 	OUT	(0FFH),A
 	CALL	CLEARSCR
 	CALL	SETUPS
 	CALL	PTITLE
 	CALL	HOWMANY
 	CALL	DISPLY
 	DB	1CH,1FH,10,10
 	DB	'Program inspired by Scott Adams',10,13
 MEMTEST	LD	HL,0C000H	;CHECK FOR 48K
 	LD	A,(HL)
 	INC	A
 	LD	(HL),A
 	CP	(HL)		;STILL THERE ?
 	JR	Z,STARTHERE		;CONTINUE IF YES
 	CALL	DISPLY
 	DB	10
 	DB	'MUST HAVE 48K to run program ! ',3
 	LD	B,1
 	CALL	GETSTR
 	JR	MEMTEST
 STARTHERE	CALL	DISPLY
 	DB	10,'Testing Buffer Memory ',3
 	CALL	TESTMEM
 	CALL	DISPLY
 	DB	10,'Buffer Memory OK.',13
 ENTRY	LD	SP,STACK
 GETSPDS	CALL	SETUPS
 	CALL	DISPLY
 	DB	1EH,'Step Speed (0=6ms,1=12ms,2=20ms,3=40ms, default 0) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	LD	A,0
 	LD	(SPEED),A
 	JR	Z,HSPD
 	LD	A,(HL)
 	SUB	30H
 	JR	C,GETSPDS
 	CP	4
 	JR	NC,GETSPDS
 	LD	(SPEED),A
 HSPD	ADD	A,30H
 	LD	(ST81),A
 	CALL	PTITLE
 	JR	RESME
 SETUPS	LD	A,'N'
 	LD	(VFLAG),A
 	XOR	A		;REQUESTED COPIES
 	LD	(SOURCE),A	;DEFAULT SOURCE DRIVE
 	LD	(FINISHED),A	;HOW MANY ARE DONE
 	LD	A,100
 	LD	(REQUEST),A	;DEFAULT REQUEST #
 	LD	A,40
 	LD	(TRACKS),A	;DEFAULT TRACKS
 	LD	HL,DEST		;DESTINATION TABLE
 	LD	(HL),'N'	;DEFAULT VALUES
 	INC	HL
 	LD	(HL),'Y'
 	INC	HL
 	LD	(HL),'Y'
 	INC	HL
 	LD	(HL),'Y'
 	CALL	PTITLE
 	JP	HOWMANY
 RESME	CALL	HOWMANY		;PRINT LINE 2
 ASKSP	CALL	DISPLY
 	DB	1EH,'S>ingle or D>ouble Density (default double) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	JR	Z,STDISK
 	CP	'S'
 	JR	Z,STDISK+2
 	CP	'D'
 	JR	NZ,ASKSP
 STDISK	LD	A,'D'
 	CP	'D'
 	LD	A,80H
 	JR	Z,SSTY
 	LD	A,0
 SSTY	LD	(DENSITY),A
 	CALL	PTITLE
 	LD	A,(DENSITY)
 	BIT	7,A
 	JR	Z,X7X8UU
 CKSIZ	CALL	DISPLY
 	DB	1EH,'A> Sectors 1-18, B> Sectors 0-17 (default A) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	LD	B,1
 	CP	'A'
 	JR	Z,HAVSIZ
 	CP	'a'
 	JR	Z,HAVSIZ
 	LD	B,0
 	CP	'B'
 	JR	Z,HAVSIZ
 	CP	'b'
 	JR	NZ,CKSIZ
 HAVSIZ	LD	(SIZE),A
 X7X8UU	CALL	SETUPDEN
 	CALL	PTITLE
 X7X8	CALL	DISPLY
 	DB	1EH,'How many copies to be made decimal (default 100) ? ',3
 	LD	B,3		;ALLOW 3 CHARACTERS
 	CALL	GETSTR
 	LD	A,100		;DEFAULT TO 100
 	JR	Z,HAVECOUNT	;CONTINUE IF DEFAULT
 	CALL	VALUE		;GET STRING VALUE
 	JR	C,X7X8		;C=BAD INPUT ELSE BC=NUM.
 	LD	A,C
 HAVECOUNT	LD	(REQUEST),A	;SAVE VALUE
 	CALL	HOWMANY		;SHOW ON SCREEN
 ASKTKS	CALL	DISPLY
 	DB	1EH,'Diskette Track Count (default 40) ? ',3
 	LD	B,3
 	CALL	GETSTR
 	LD	A,40
 	JR	Z,TKSASK
 	CALL	VALUE
 	JR	C,ASKTKS
 	LD	A,C
 TKSASK	LD	(TRACKS),A
 	CALL	HOWMANY
 BAD5	CALL	DISPLY
 	DB	1EH,'Byte for byte verify after write (default no) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	JR	Z,VERNO
 	CP	'Y'
 	JR	Z,VERNO+2
 	CP	'N'
 	JR	NZ,BAD5		;INVALID INPUT
 VERNO	LD	A,'N'		;DEFAULT
 	LD	(VFLAG),A	;VERIFY FLAG
 	CALL	PTITLE		;PRINT ON SCREEN
 BAD2	CALL	DISPLY		;PRINT
 	DB	1EH,'Source drive (default 0) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	LD	C,0		;DEFAULT 0
 	JR	Z,HAVESRC
 	SUB	30H
 	JR	C,BAD2
 	LD	C,A
 HAVESRC	LD	A,C
 	CP	4
 	JR	NC,BAD2		;TOO MUCH
 	LD	(SOURCE),A	;SAVE BINARY DRIVE
 	ADD	A,30H		;MAKE ASCII
 	LD	(SRCDRV),A	;FOR STRING
 	SUB	30H
 	CALL	DRVBIT		;SET DRIVE BIT
 	LD	(SRC),A		;SAVE BIT SET
 	XOR	A
 	LD	(DESDR),A
 	CALL	PTITLE		;SHOW SOURCE DRIVE
 	CALL	HOWMANY
 DESTLOOP	LD	A,(DESDR)
 	ADD	A,30H		;MAKE DRIVE INTO ASCII
 	LD	(INLINE),A	;PUT IN MESSAGE
 	CALL	HOWMANY
 	CALL	DISPLY		;DISPLY IT
 	DB	1EH,'Copy to drive '
 INLINE	DB	'0 (default no) ? ',3
 	LD	B,1
 	CALL	GETSTR
 	JR	Z,HAVENO	;GO IF NO INPUT
 	CP	'Y'		;YES ?
 	JR	Z,HAVEIF	;GO IF YES
 	CP	'N'		;NO ?
 	JR	NZ,DESTLOOP	;BAD INPUT IF NOT Y/N
 HAVENO	LD	A,'N'
 HAVEIF	LD	HL,DEST		;DESTINATION TABLE
 	LD	E,A		;SAVE RESPONSE
 	LD	A,(DESDR)	;GET DRIVE
 	ADD	A,L
 	LD	L,A
 	LD	(HL),E
 	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	JR	C,DESTLOOP	;CONTINUE IF NOT END
 	LD	A,99
 	LD	(OKCONT),A
 	LD	HL,DEST		;POINT TO TABLE
 	LD	A,(SOURCE)	;GET SOURCE DRIVE
 	ADD	A,L		;POINT TO DEST BYTE
 	LD	L,A
 	LD	A,(HL)		;GET DEST BYTE
 	CP	'Y'		;SOURCE & DEST THE SAME ?
 	JR	NZ,START	;START COPY IF NOT SAME
 	CALL	DISPLY		;MESSAGE
 	DB	1EH,'Source & Destination same drive !',13
 	JP	BAD2		;START AGAIN
 START	LD	SP,STACK	;RESET STACK FROM BREAK
 	LD	A,(OKCONT)
 	CP	99
 	JP	NZ,ENTRY
 	CALL	PTITLE		;TITLE
 	CALL	HOWMANY		;HOWMANY COPIES
 	CALL	DISPLY		;MESSAGE
 	DB	1EH,'Mount all disks, press <ENTER>. ',3
 	LD	B,1
 	CALL	GETSTR
 	XOR	A		;START WITH TRACK 0
 	SBC	HL,HL
 	LD	(TRACK),A	;SAVE IT
 	LD	(DESDR),A	;DESTINATION COUNT
 	LD	(LOCKTBL),HL	;SET ALL DRIVES AS OK
 	LD	(LOCKTBL+2),HL
 	LD	(PLACE),HL	;PLACE OF NEXT READ
 	LD	HL,DEST
 	LD	B,4
 	LD	A,(DENSITY)
 	OR	A
 	JR	Z,CHKLP
 	LD	A,(SIZE)
 	OR	A
 	JR	Z,CHKLP
 	LD	A,1
 	LD	(PLACE),A
 CHKLP	LD	A,(HL)
 	CP	'Y'
 	JR	Z,FORMAT
 	INC	HL
 	DJNZ	CHKLP
 	CALL	DISPLY
 	DB	1EH,'NO DESTINATION DRIVES.  Press <ENTER> to continue. ',3
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 FORMAT	LD	HL,DEST		;POINT TO TABLE
 	LD	IY,TRACKS
 	LD	A,(DESDR)	;GET COUNT
 	ADD	A,L		;POINT TO DES DRIVE
 	LD	L,A
 	LD	A,(HL)		;GET A BYTE
 	CP	'Y'		;COPY TO THAT ONE ?
 	JR	NZ,FMTNEXT	;SKIP IF NOT "Y"
 	LD	A,(DESDR)	;DRIVE COUNT
 	LD	(DRIVE),A	;SAVE BINARY
 	CALL	DRVBIT		;SET BIT FOR DRIVE SELECT
 	LD	(DRIV),A	;SAVE THAT
 	CALL	RESTOR		;RESTORE THE DRIVE
 	CALL	WSTAT		;CHECK WRITE STATUS
 	JR	NZ,FMTNEXT
 	XOR	A		;START WITH TRACK 0
 	LD	(TRACK),A	;FOR FORMAT
 	LD	BC,9000H
 	CALL	60H
 	CALL	FORM		;FORMAT THE DISK
 FMTNEXT	LD	A,(DESDR)	;GET COUNTER
 	INC	A		;BUMP IT
 	LD	(DESDR),A	;RE-SAVE IT
 	CP	4		;END OF TABLE ?
 	JR	C,FORMAT	;CONTINUE IF NOT
 	XOR	A		;ZERO TRACK AGAIN
 	LD	(TRACK),A	;SAVE IT
 	CALL	RESTOREALL	;RESTORE ALL DRIVES & TBL
 	LD	IY,TRACKS	;POINT TO TRACK COUNT
 COPY	LD	A,(SOURCE)	;SOURCE DRIVE
 	LD	(DRIVE),A
 	LD	A,(SRC)		;BIT SET
 	LD	(DRIV),A
 	LD	DE,(PLACE)	;PLACE OF READ
 	LD	(TRAK),DE	;SAVE FOR WRITE
 	CALL	MREAD		;MULTIPLE SECTOR READ
 	LD	(PLACE),DE
 	XOR	A		;FOR TABLE
 	LD	(DESDR),A	;ZERO IT
 CPYLOOP	LD	HL,DEST		;DESTINATION TABLE
 	LD	A,(DESDR)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	CP	'Y'
 	JR	NZ,CPYNEXT	;SKIP IF NOT YES
 	LD	A,(DESDR)
 	LD	(DRIVE),A	;BINARY DRIVE
 	CALL	DRVBIT		;SET DRIVE BIT
 	LD	(DRIV),A
 	LD	DE,(TRAK)	;GET TRACK
 	CALL	MWRITE		;MULTIPLE WRITE
 	LD	A,(VFLAG)	;VERIFY ON ?
 	CP	'Y'
 	CALL	Z,VERIFY	;DO IT IF YES
 CPYNEXT	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	JR	C,CPYLOOP	;GO LOOP
 	LD	A,(PLACE+1)	;GET CURRENT TRACK
 	CP	(IY)		;END ?
 	JP	NZ,COPY		;CONTINUE
 	CALL	DISPLY
 	DB	13		;CARRIAGE RETURN
 	LD	HL,(CURSOR)	;GET CURSOR
 	PUSH	HL		;GIVE TO DE
 	POP	DE
 	INC	DE		;CURSOR +1
 	LD	(HL),140	;GRAPHIC BLOCK
 	LD	BC,63
 	LDIR			;DRAW LINE
 	CALL	DISPLY		;DROP ANOTHER LINE
 	DB	13
 	LD	HL,LOCKTBL	;LOCKOUT TABLE
 	LD	DE,DEST		;DESTINATION TABLE
 	LD	B,4		;GO FOR 4 DRIVES
 	LD	C,30H		;ASCII DRIVE
 CHKMANY	LD	A,(DE)		;ACTIVE DRIVE ?
 	CP	'Y'
 	JR	NZ,CHKNEXT	;CONTINUE IF NOT
 	LD	A,(HL)		;GET LOCKOUT BYTE
 	OR	A		;SET FLAGS
 	JP	NZ,CHKBAD	;FAULTY
 	LD	A,(FINISHED)	;INCREMENT # OF DONE
 	INC	A
 	LD	(FINISHED),A
 	LD	A,C
 	LD	(GOODDRV),A
 	PUSH	HL
 	PUSH	DE
 	CALL	DISPLY
 	DB	10,'Drive '
 GOODDRV	DB	'0 Copied OK.',3
 	POP	DE
 	POP	HL
 CHKNEXT	INC	HL		;BUMP POINTERS
 	INC	DE
 	INC	C
 	DJNZ	CHKMANY
 	JP	COPYBYE		;DONE
 CHKBAD	LD	A,C		;GET DRIVE ASCII
 	LD	(BADDRV),A	;PUT IN STRING
 	PUSH	HL
 	PUSH	DE
 	CALL	DISPLY		;DISPLAY MESSAGE
 	DB	10,'DO NOT USE Drive '
 BADDRV	DB	'0, BAD COPY.',3
 	POP	DE
 	POP	HL
 	JP	CHKNEXT
 DRVBIT	PUSH	DE		;SAVE DE
 	LD	E,1		;BIT 0
 BITLOOP	OR	A		;CHECK IF 0
 	JR	Z,BITFND	;FOUND IF 0
 	DEC	A		;DRIVE -1
 	SLA	E		;MOVE DRIVE BIT
 	JR	BITLOOP		;CONTINUE
 BITFND	LD	A,E		;GET BIT
 	POP	DE		;RESTORE DE
 	RET			;DONE
 CLEARSCR	XOR	A	;ZERO THE ACCUM
 	OUT	(0FFH),A	;64 CHAR SIZE
 	LD	HL,3C00H	;VIDEO
 	LD	DE,3C01H
 	LD	BC,1023
 	LD	(HL),20H	;SPACE
 	LDIR			;CLEAR SCREEN
 	LD	HL,3C80H
 	LD	DE,3C81H
 	LD	BC,63
 	LD	(HL),140
 	LDIR
 	LD	HL,3CC0H
 	LD	(CURSOR),HL
 	RET			;DONE
 MSG0	DB	'MULTI-DISK COPY III by Kim Watt - Density='
 DEN	DB	'xx, Source='
 SRCDRV	DB	'0, Verify='
 VERON	DB	'N'
 HOWMANY	LD	A,(REQUEST)	;GET REQUEST
 	CALL	ASCII		;MAKE IT ASCII
 	LD	(MANY1),A	;PUT IN STRING
 	LD	(MANY1+1),BC
 	LD	A,(FINISHED)	;HOW MANY DONE
 	CALL	ASCII		;MAKE IT ASCII TOO
 	LD	(MANY2),A
 	LD	(MANY2+1),BC	;PUT IN STRING
 	LD	A,(TRACKS)	;GET TRACK COUNT
 	CALL	ASCII
 	LD	(MANY3),A
 	LD	(MANY3+1),BC
 	LD	HL,DEST
 	LD	A,(HL)
 	LD	(DRV1),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV2),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV3),A
 	INC	HL
 	LD	A,(HL)
 	LD	(DRV4),A
 	LD	HL,MSG1		;POINT TO MESSAGE
 	LD	DE,3C40H	;VIDEO LINE 2
 	LD	B,64		;64 CHARS
 	JP	PUTITON		;PRINT IT
 MSG1	DB	'Step='
 ST81	DB	'0, Req='
 MANY1	DB	'000, Done='
 MANY2	DB	'000, Tracks='
 MANY3	DB	'000. Dest 0='
 DRV1	DB	'N, 1='
 DRV2	DB	'Y, 2='
 DRV3	DB	'Y, 3='
 DRV4	DB	'Y    '
 FORM	LD	A,(DRIVE)	;GET BINARY DRIVE
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(FMTDRV),A	;PUT IN STRING
 	CALL	DISPLY		;ONE CARRIAGE RETURN
 	DB	13
 FORMLP	LD	A,(TRACK)	;GET TRACK
 	CALL	ASCII		;MAKE IT ASCII
 	LD	(FMTTRK),A	;PUT IN STRING
 	LD	(FMTTRK+1),BC
 	CALL	DISPLY
 	DB	1DH		;BEGINNING OF LINE
 	DB	'Formatting - Drive '
 FMTDRV	DB	'0, Track '
 FMTTRK	DB	'000.',3
 	LD	IY,TRACKS
 	CALL	BAIL
 	CALL	FORMIT
 	JP	NZ,BADWRT
 	LD	A,(TRACK)	;GET TRACK
 	INC	A		;BUMP IT
 	LD	(TRACK),A	;SAVE IT
 	CP	(IY)		;END OF DISK ?
 	RET	Z		;FINISHED IF YES
 	CALL	STEPIN		;STEP IN DRIVE
 	JP	NZ,BADWRT
 	JP	FORMLP		;GO LOOP
 RESTOREALL	XOR	A	;START WITH 0
 	LD	(DESDR),A	;SAVE IT
 	LD	HL,0		;ZERO THE TRACK TABLE
 	LD	(CTRACK),HL
 	LD	(CTRACK+2),HL
 	CALL	DISPLY
 	DB	13
 	LD	A,(SRC)		;GET SOURCE DRIVE
 	LD	(DRIV),A	;SAVE IT
 	LD	A,(SOURCE)
 	LD	(DRIVE),A
 	CALL	RSTAT		;CHECK STATUS OF READ
 	JP	NZ,STOP
 RESLOOP	LD	A,(DESDR)	;GET DESTINATION COUNT
 	LD	HL,DEST
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	CP	'Y'		;DESTINATION ?
 	JR	NZ,RESNEXT	;SKIP IF NOT YES
 	LD	HL,LOCKTBL
 	LD	A,(DESDR)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)
 	INC	A
 	JR	Z,RESNEXT
 	LD	A,(DESDR)
 	LD	(DRIVE),A
 	CALL	DRVBIT
 	LD	(DRIV),A
 	CALL	WSTAT		;CHECK WRITE STATUS
 	CALL	NZ,BADWRT
 RESNEXT	LD	A,(DESDR)
 	INC	A
 	LD	(DESDR),A
 	CP	4
 	RET	NC
 	JR	RESLOOP
 MREAD	CALL	DISPLY
 	DB	13
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(RDDR),A
 	LD	A,D
 	CALL	ASCII
 	LD	(RDTK),A
 	LD	(RDTK+1),BC
 	LD	BC,BUFFER
 	LD	IX,POINTER	;TO SAVE READ TYPE
 READLP	PUSH	BC		;SAVE BUFFER
 	LD	A,B
 	CALL	HEXCV
 	LD	(BUFF1),HL
 	LD	A,E
 	CALL	ASCII
 	LD	(RDSC),A
 	LD	(RDSC+1),BC
 	CALL	DISPLY
 	DB	1DH,'Reading   Drive '
 RDDR	DB	'0, Track '
 RDTK	DB	'000, Sector '
 RDSC	DB	'000, Buffer '
 BUFF1	DB	'0000H.',3
 	POP	BC		;LOAD ADDRESS
 	CALL	BAIL		;CHECK IF BREAK KEY
 	CALL	READ
 	JR	NZ,STOP		;QUIT IF READ ERROR
 	LD	A,(RESULT)	;GET READ TYPE
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	1
 	OR	0A0H
 	LD	(IX),A		;SAVE IN TABLE
 	INC	IX
 	INC	E		;BUMP SECTOR
 	LD	A,E		;GET INTO ACCUM
 	SUB	0AH		;END OF TRACK ?
 DD11	EQU	$-1
 	JR	NZ,READEN	;NOPE
 	LD	E,0
 DD01	EQU	$-1
 	INC	D		;BUMP TRACK
 	PUSH	BC
 	LD	A,D
 	CALL	ASCII
 	LD	(RDTK),A
 	LD	(RDTK+1),BC
 	POP	BC
 READEN	LD	A,B		;GET BUFFER POINTER
 	OR	A		;TOP OF 48K ?
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	RET	NC
 	JP	READLP
 STOP	CALL	DISPLY
 	DB	10,'Cannot continue because of Source Read Error. ',10
 	DB	'Press <ENTER> to restart. ',3
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 VERIFY	LD	HL,LOCKTBL	;SEE IF USING DRIVE
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)		;LOCKED OUT ?
 	OR	A
 	RET	NZ
 	LD	BC,BUFFER	;READ BUFFER
 	LD	(BPOINT),BC	;SAVE IN BUFFER POINTER
 	LD	A,(DRIVE)
 	ADD	A,30H		;MAKE IT ASCII
 	LD	(VDR),A
 	CALL	DISPLY
 	DB	13
 	LD	DE,(TRAK)	;TRACK/SECTOR
 	LD	A,D
 	CALL	ASCII
 	LD	(VRTK),A
 	LD	(VRTK+1),BC
 	LD	IX,POINTER	;READ TYPE POINTER
 VERLOOP	LD	BC,(BPOINT)	;VERIFY BUFFER
 	LD	A,B		;GET BUFFER
 	CALL	HEXCV		;HEX ASCII
 	LD	(BUFF5),HL	;TO STRING
 	LD	A,E		;GET SECTOR
 	CALL	ASCII
 	LD	(VSC),A
 	LD	(VSC+1),BC
 	CALL	DISPLY
 	DB	1DH
 	DB	'Verifying Drive '
 VDR	DB	'0, Track '
 VRTK	DB	'000, Sector '
 VSC	DB	'000, Buffer '
 BUFF5	DB	'0000H.',3
 	LD	BC,VERBUFF	;VERIFY READ BUFFER
 	CALL	BAIL		;CHECK BREAK KEY
 	CALL	READ
 	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 	LD	A,(RESULT)	;GET READ RESULT
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	RRCA
 	AND	1
 	OR	0A0H
 	CP	(IX)		;SAME ?
 	INC	IX
 ;	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 	LD	HL,(BPOINT)	;GET BUFFER POINTER
 	PUSH	DE		;SAVE TRACK/SECTOR
 	LD	DE,VERBUFF	;VERIFY BUFFER
 	LD	B,0		;1 SECTOR
 	CALL	COMPARE		;COMPARE 'EM
 	POP	DE
 	JP	NZ,BADWRT	;LOCKOUT THE DRIVE
 VERIFGO	LD	HL,(BPOINT)	;BUMP IT
 	INC	H
 	LD	(BPOINT),HL	;PUT IT BACK
 	INC	E		;BUMP SECTOR
 	LD	A,E
 	SUB	0AH
 DD12	EQU	$-1
 	JR	NZ,VERCONT	;CONTINUE IF NOT AT END
 	LD	E,0
 DD02	EQU	$-1
 	INC	D
 	LD	A,D		;GET TRACK
 	CALL	ASCII
 	LD	(VRTK),A
 	LD	(VRTK+1),BC
 VERCONT	LD	BC,(BPOINT)	;GET BUFFER POINTER
 	LD	A,B		;GET MSB
 	OR	A		;SET FLAGS FOR TOPMEM
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;AT END ?
 	RET	NC
 	JP	VERLOOP		;GO LOOP
 COMPARE	LD	A,(DE)		;GET A BYTE
 	CP	(HL)		;SAME ?
 	RET	NZ		;NOPE IF NZ
 	INC	HL
 	INC	DE		;BUMP POINTERS
 	DJNZ	COMPARE		;CONTINUE 100H BYTES
 	RET			;Z FLAG SET
 MWRITE	LD	HL,LOCKTBL	;POINT TO LOCK TABLE
 	LD	A,(DRIVE)	;BINARY DRIVE
 	ADD	A,L
 	LD	L,A
 	LD	A,(HL)		;IS DRIVE LOCKED OUT ?
 	OR	A
 	RET	NZ		;QUIT IF FAULTY DRIVE
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(WDR),A
 	CALL	DISPLY
 	DB	13
 	LD	A,D
 	CALL	ASCII
 	LD	(WRTK),A
 	LD	(WRTK+1),BC
 	LD	BC,BUFFER	;POINT TO BUFFER
 	LD	IX,POINTER	;FOR WRITE TYPE
 WRITELP	LD	A,(IX)		;GET TABLE BYTE
 	INC	IX		;BUMP POINTER
 	LD	(TYPE),A	;SAVE IN CODE
 	PUSH	BC
 	LD	A,B
 	CALL	HEXCV
 	LD	(BUFF3),HL
 	LD	A,E
 	CALL	ASCII
 	LD	(WRSC),A
 	LD	(WRSC+1),BC
 	CALL	DISPLY
 	DB	1DH
 	DB	'Writing   Drive '
 WDR	DB	'0, Track '
 WRTK	DB	'000, Sector '
 WRSC	DB	'000, Buffer '
 BUFF3	DB	'0000H.',3
 	POP	BC
 	CALL	BAIL		;CHECK BREAK KEY
 	CALL	WRITE
 	JR	NZ,BADWRT	;NZ=BAD
 	INC	E		;BUMP SECTOR
 	LD	A,E
 	SUB	0AH		;END OF TRACK ?
 DD13	EQU	$-1
 	JR	NZ,WRITEEN
 	LD	E,0
 DD03	EQU	$-1
 	INC	D		;BUMP TRACK
 	PUSH	BC
 	LD	A,D
 	CALL	ASCII
 	LD	(WRTK),A
 	LD	(WRTK+1),BC
 	POP	BC
 WRITEEN	LD	A,B		;GET BUFFER POINTER
 	OR	A		;END OF MEMORY ?
 	RET	Z
 	LD	A,D		;GET TRACK
 	CP	(IY)		;END OF DISK ?
 	RET	NC
 	JP	WRITELP		;ELSE CONTINUE
 BADWRT	LD	HL,LOCKTBL	;LOCKOUT THE DRIVE
 	LD	A,(DRIVE)
 	ADD	A,L
 	LD	L,A
 	LD	(HL),-1		;LOCK IT OUT
 	LD	A,(DRIVE)
 	ADD	A,30H
 	LD	(BADDR),A
 	CALL	DISPLY
 	DB	10,'Drive '
 BADDR	DB	'0 LOCKED OUT !',13
 	OR	1
 	RET			;QUIT
 COPYBYE	CALL	DISPLY		;MESSAGE
 	DB	13		;CARRIAGE RETURN
 	CALL	HOWMANY		;UPDATE # OF COPIES
 	LD	A,(REQUEST)	;GET REQUEST #
 	LD	B,A
 	LD	A,(FINISHED)	;HOW MANY DONE
 	CP	B		;DONE YET ?
 	JP	C,START		;MOUNT DISKETTES
 	CALL	DISPLY		;DISPLAY DONE MESSG
 	DB	10,'All copies finished.  <ENTER> to restart. ',3
 	LD	B,1
 	CALL	GETSTR
 	JP	ENTRY
 ASCII	PUSH	HL		;SAVE IT
 	CALL	ASCI		;CONVERT LOW PART
 	LD	H,B
 	PUSH	HL
 	LD	A,C
 	SUB	30H
 	CALL	ASCI		;CONVERT HIGH PART
 	LD	A,C
 	POP	HL
 	LD	C,B
 	LD	B,H
 	POP	HL
 	RET
 ASCI	LD	C,30H
 ASCII1	SUB	0AH
 	JR	C,ASCII2
 	INC	C
 	JR	ASCII1
 ASCII2	ADD	A,3AH
 	LD	B,A
 	RET
 PTITLE	LD	A,(VFLAG)
 	LD	(VERON),A
 	LD	A,(DENSITY)
 	OR	A
 	LD	B,' '
 	LD	C,'S'
 	JR	Z,DENHAV
 	LD	C,'D'
 	LD	A,(SIZE)
 	OR	A
 	LD	B,'B'
 	JR	Z,DENHAV
 	LD	B,'A'
 DENHAV	LD	(DEN),BC
 	LD	HL,MSG0
 	LD	DE,3C00H
 	LD	B,64
 	JP	PUTITON
 VALUE	LD	A,B		;LENGTH
 	CP	3		;MAKE IT 3 BYTES
 	JR	Z,VALGO		;HAVE 3 CHAR
 	DEC	HL		;POINTER
 	LD	(HL),'0'	;MAKE IT ZERO
 	INC	B		;LENGTH + 1
 	JR	VALUE		;CONTINUE
 VALGO	LD	D,0		;0 START VALUE
 VALOOP	LD	A,(HL)		;GET A BYTE
 	CALL	MAKNUM
 	RET	C		;BAD NUMBER
 	CALL	BYTEN		;A * 10
 	CALL	BYTEN		;A * 100
 	ADD	A,D		;ADD TO TOTAL
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	RET	C
 	CALL	BYTEN		;A * 10
 	ADD	A,D		;RESULT
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	ADD	A,D
 	LD	C,A
 	LD	B,0		;BC=RESULT
 	SCF
 	CCF			;CLEAR CARRY
 	RET
 BYTEN	LD	B,10		;MULTIPLIER
 	PUSH	DE		;SAVE DE
 	LD	E,A
 	LD	D,0		;DE=MULTIPLICAND
 	PUSH	HL		;SAVE POINTER
 	LD	HL,0		;START VALUE
 BYLOOP	SRL	B		;MULTIPLIER BIT
 	JR	NC,BYCONT	;GO IF EVEN NUMBER
 	ADD	HL,DE		;ADD TO TOTAL
 BYCONT	JR	Z,BYDONE
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	BYLOOP		;CONTINUE
 BYDONE	LD	A,L		;GET PRODUCT
 	POP	HL
 	POP	DE		;RESTORE PREVIOUS
 	RET			;A=NUMBER
 MAKNUM	SUB	30H		;REMOVE ASCII
 	RET	C		;BAD NUMBER
 	CP	0AH		;>9 ?
 	CCF			;REVERSE CARRY FLAG
 	RET			;FINISHED
 HEXCV	LD	C,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	HEXTST
 	LD	H,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PUTITON	EX	DE,HL		;HL=VIDEO, DE=TEXT
 PUTITLP	LD	A,(DE)		;GET A TEXT BYTE
 	LD	(HL),A		;PRINT IT
 	INC	HL		;BUMP POINTERS
 	INC	DE
 	DJNZ	PUTITLP		;CONTINUE
 	RET			;DONE
 ADDC	INC	C
 	LD	A,7
 	ADD	A,B
 	LD	B,A
 	RET
 SETUPDEN	LD	A,(DENSITY)
 	OR	A
 	LD	B,0
 	JR	NZ,SETDBL
 	LD	A,10
 SETDDD	LD	(DD11),A
 	LD	(DD12),A
 	LD	(DD13),A
 	LD	A,B
 	LD	(DD01),A
 	LD	(DD02),A
 	LD	(DD03),A
 	RET
 SETDBL	LD	A,(SIZE)
 	OR	A
 	LD	A,19
 	LD	B,1
 	JR	NZ,SETDDD
 	LD	A,18
 	LD	B,0
 	JR	SETDDD
 TESTMEM	LD	HL,TESTBUFF
 TESTLP0	LD	A,H
 	AND	3
 	JR	NZ,TESTLP1
 	PUSH	HL
 	CALL	DISPLY
 	DB	'.',3
 	POP	HL
 TESTLP1	LD	A,(HL)
 	LD	B,A
 	LD	A,-1
 	LD	(HL),A
 	CP	(HL)
 	JR	NZ,BADMEM
 	XOR	A
 	LD	(HL),A
 	CP	(HL)
 	LD	(HL),B
 	JR	NZ,BADMEM
 	INC	L
 	JR	NZ,TESTLP1
 	INC	H
 	JR	NZ,TESTLP0
 	RET
 BADMEM	CALL	DISPLY
 	DB	10,'DEFECTIVE MEMORY !!'
 	DB	10,'DO NOT USE THIS MACHINE FOR DUPLICATING !!',13
 ENDHERE	JP	ENDHERE
 	END
 	JR	NZ,BADMEM
 	INC	L
 	JR	NZ,TESTLP1
 	INC	H
 	JR	NZ,TESTLP0
 	RET
 BADMEM	CALL	DISPLY
 	DB	10,'DEFECTIVE MEMORY !!'
 	DB	10,'DO NOT USE THIS MACHINE FOR DUPLICATING !!',13
 ENDH 	JR	NZ,DENHAV
 	LD	A,'S'
 DENHAV	LD	(DEN),A
 	LD	HL,MSG0
 	LD	DE,3C00H
 	LD	B,64
 	JP	PUTITON
 VALUE	LD	A,B		;LENGTH
 	CP	3		;MAKE IT 3 BYTES
 	JR	Z,VALGO		;HAVE 3 CHAR
 	DEC	HL		;POINTER
 	LD	(HL),'0'	;MAKE IT ZERO
 	INC	B		;LENGTH + 1
 	JR	VALUE		;CONTINUE
 VALGO	LD	D,0		;0 START VALUE
 VALOOP	LD	A,(HL)		;GET A BYTE
 	CALL	MAKNUM
 	RET	C		;BAD NUMBER
 	CALL	BYTEN		;A * 10
 	CALL	BYTEN		;A * 100
 	ADD	A,D		;ADD TO TOTAL
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	RET	C
 	CALL	BYTEN		;A * 10
 	ADD	A,D		;RESULT
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	ADD	A,D
 	LD	C,A
 	LD	B,0		;BC=RESULT
 	SCF
 	CCF			;CLEAR CARRY
 	RET
 BYTEN	LD	B,10		;MULTIPLIER
 	PUSH	DE		;SAVE DE
 	LD	E,A
 	LD	D,0		;DE=MULTIPLICAND
 	PUSH	HL		;SAVE POINTER
 	LD	HL,0		;START VALUE
 BYLOOP	SRL	B		;MULTIPLIER BIT
 	JR	NC,BYCONT	;GO IF EVEN NUMBER
 	ADD	HL,DE		;ADD TO TOTAL
 BYCONT	JR	Z,BYDONE
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	BYLOOP		;CONTINUE
 BYDONE	LD	A,L		;GET PRODUCT
 	POP	HL
 	POP	DE		;RESTORE PREVIOUS
 	RET			;A=NUMBER
 MAKNUM	SUB	30H		;REMOVE ASCII
 	RET	C		;BAD NUMBER
 	CP	0AH		;>9 ?
 	CCF			;REVERSE CARRY FLAG
 	RET			;FINISHED
 HEXCV	LD	C,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	HEXTST
 	LD	H,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PUTITON	EX	DE,HL		;HL=VIDEO, DE=TEXT
 PUTITLP	LD	A,(DE)		;GET A TEXT BYTE
 	LD	(HL),A		;PRINT IT
 	CP	(HL)		;STILL THERE ?
 	JR	Z,PUTITNX	;LOWERCASE INSTALLED
 	SUB	20H		;MAKE IT UPPER CASE
 	LD	(HL),A		;REPRINT IT
 PUTITNX	INC	HL		;BUMP POINTERS
 	INC	DE
 	DJNZ	PUTITLP		;CONTINUE
 	RET			;DONE
 ADDC	INC	C
 	LD	A,7
 	ADD	A,B
 	LD	B,A
 	RET
 NEXTSERIAL	LD	A,'N'
 SERONOFF	EQU	$-1
 	CP	'N'
 	RET	Z
 	PUSH	DE
 	PUSH	BC
 	CALL	PTITLE
 	LD	DE,0
 SERBUF	EQU	$-2
 BFFIN	LD	HL,SERIALNO
 	LD	B,0
 	LD	C,0
 SERLEN	EQU	$-1
 	LDIR
 	LD	A,'N'
 INCONOFF	EQU	$-1
 	CP	'N'
 	POP	BC
 	POP	DE
 	RET	Z
 	LD	HL,SERIALNO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	POP	BC
 	DEC	HL
 NEXTSLP	LD	A,(HL)
 	INC	A
 	LD	(HL),A
 	CP	3AH
 	RET	C
 	LD	(HL),'0'
 	DEC	HL
 	JR	NEXTSLP
 	END
NO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,9	DB	'Step='
 ST81	DB	'0, Prot='
 ST82	DB	'N, Serial Number='
 ST83	DB	'N, Increment='
 ST84	DB	'N, Osec='
 ST85	DB	'0, Nsec='
 ST86	DB	'000.                   '
 VALUE	LD	A,B		;LENGTH
 	CP	3		;MAKE IT 3 BYTES
 	JR	Z,VALGO		;HAVE 3 CHAR
 	DEC	HL		;POINTER
 	LD	(HL),'0'	;MAKE IT ZERO
 	INC	B		;LENGTH + 1
 	JR	VALUE		;CONTINUE
 VALGO	LD	D,0		;0 START VALUE
 VALOOP	LD	A,(HL)		;GET A BYTE
 	CALL	MAKNUM
 	RET	C		;BAD NUMBER
 	CALL	BYTEN		;A * 10
 	CALL	BYTEN		;A * 100
 	ADD	A,D		;ADD TO TOTAL
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	RET	C
 	CALL	BYTEN		;A * 10
 	ADD	A,D		;RESULT
 	LD	D,A
 	INC	HL
 	LD	A,(HL)
 	CALL	MAKNUM
 	ADD	A,D
 	LD	C,A
 	LD	B,0		;BC=RESULT
 	SCF
 	CCF			;CLEAR CARRY
 	RET
 BYTEN	LD	B,10		;MULTIPLIER
 	PUSH	DE		;SAVE DE
 	LD	E,A
 	LD	D,0		;DE=MULTIPLICAND
 	PUSH	HL		;SAVE POINTER
 	LD	HL,0		;START VALUE
 BYLOOP	SRL	B		;MULTIPLIER BIT
 	JR	NC,BYCONT	;GO IF EVEN NUMBER
 	ADD	HL,DE		;ADD TO TOTAL
 BYCONT	JR	Z,BYDONE
 	EX	DE,HL
 	ADD	HL,HL
 	EX	DE,HL
 	JR	BYLOOP		;CONTINUE
 BYDONE	LD	A,L		;GET PRODUCT
 	POP	HL
 	POP	DE		;RESTORE PREVIOUS
 	RET			;A=NUMBER
 MAKNUM	SUB	30H		;REMOVE ASCII
 	RET	C		;BAD NUMBER
 	CP	0AH		;>9 ?
 	CCF			;REVERSE CARRY FLAG
 	RET			;FINISHED
 HEXCV	LD	C,A
 	SRL	A
 	SRL	A
 	SRL	A
 	SRL	A
 	CALL	HEXTST
 	LD	L,A
 	LD	A,C
 	AND	0FH
 	CALL	HEXTST
 	LD	H,A
 	RET
 HEXTST	ADD	A,30H
 	CP	3AH
 	RET	M
 	ADD	A,7
 	RET
 PUTITON	EX	DE,HL		;HL=VIDEO, DE=TEXT
 PUTITLP	LD	A,(DE)		;GET A TEXT BYTE
 	LD	(HL),A		;PRINT IT
 	CP	(HL)		;STILL THERE ?
 	JR	Z,PUTITNX	;LOWERCASE INSTALLED
 	SUB	20H		;MAKE IT UPPER CASE
 	LD	(HL),A		;REPRINT IT
 PUTITNX	INC	HL		;BUMP POINTERS
 	INC	DE
 	DJNZ	PUTITLP		;CONTINUE
 	RET			;DONE
 ADDC	INC	C
 	LD	A,7
 	ADD	A,B
 	LD	B,A
 	RET
 NEXTSERIAL	LD	A,'N'
 SERONOFF	EQU	$-1
 	CP	'N'
 	RET	Z
 	PUSH	DE
 	PUSH	BC
 	CALL	PTITLE
 	LD	DE,0
 SERBUF	EQU	$-2
 BFFIN	LD	HL,SERIALNO
 	LD	B,0
 	LD	C,0
 SERLEN	EQU	$-1
 	LDIR
 	LD	A,'N'
 INCONOFF	EQU	$-1
 	CP	'N'
 	POP	BC
 	POP	DE
 	RET	Z
 	LD	HL,SERIALNO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	POP	BC
 	DEC	HL
 NEXTSLP	LD	A,(HL)
 	INC	A
 	LD	(HL),A
 	CP	3AH
 	RET	C
 	LD	(HL),'0'
 	DEC	HL
 	JR	NEXTSLP
 	END
NO
 	LD	A,(SER	JR	NEXTSLP
 	END
NO
 	LD	A,(SERLEN)
 	PUSH	BC
 	LD	C,A
 	LD	B,0
 	ADD	HL,BC
 	POP	BC
 	DEC	HL
 NEXTSLP	LD	A,(HL)
 	INC	A
 	LD	(HL),A
 	CP	3AH
 	RET	C
 	LD	(HL),'0'
                    