; smove2/asm - kjw/bqsd - revised 04/20/83
;
;	select drive
;
SELECT	IN	A,(0F0H)	;read FDC status
	AND	80H		;drive motor on?
	LD	A,0		;get drive bit
DRIV	EQU	$-1
	OUT	(0F4H),A	;select drive
	RET	Z		;motor already was on
	PUSH	BC		;save this
	LD	BC,0		;1 second delay time
	CALL	DELAY		;decrement BC till 0
	POP	BC		;restore it
	JR	SELECT		;re-select till ready
;
;	copy files vector
;
COPYALL	LD	HL,CREATE	;create/allocate files
	RST	30H		;do all files
	LD	HL,DOCOPY	;file copy routine
	RST	30H		;do all files
	CALL	MAKEHIT		;rebuild HIT table
	LD	HL,MSG27	;updating directory
	RST	20H		;display message
	CALL	DMOUNT		;setup for dest write
	LD	A,18		;write 18 sectors
	LD	BC,DDIRBUF	;destination directory
	LD	DE,0		;get directory track
DESDIR	EQU	$-2
	CALL	MDWRITE		;multiple directory write
	LD	HL,MSG21	;bad directory update
	JP	NZ,ERROR	;messed it up
	LD	HL,MSG23	;else completed
	RST	20H		;display message
	LD	HL,MSG20	;enter to re-boot
	RST	28H		;flash it
	DI			;disable
	RST	0		;re-boot
;
;	check if current file exists
;
IFMATCH	PUSH	HL		;save pointers
	PUSH	DE
	LD	B,11		;must match 11 chars
;
IFMATC1	LD	A,(DE)		;get a byte
	CP	(HL)		;same ?
	JR	NZ,IFMATC2	;go if not
	INC	DE		;bump pointers
	INC	HL
	DJNZ	IFMATC1		;continue for 11
IFMATC2	POP	DE		;restore pointers
	POP	HL
	RET			;Z = file matches!
;
;	kill file on SOURCE diskette
;
SKILLIT	XOR	A		;NOP opcode
	LD	(CKKEXT),A	;for extension checker
	LD	HL,KR1		;kill vector source
	LD	(CKKILL),HL	;pass vector
	JR	KILLIT		;go common
;
;	kill file on DEST diskette
;
DKILLIT	LD	A,0C9H		;RET opcode
	LD	(CKKEXT),A	;no extensions
	LD	HL,KR3		;kill vector dest
	LD	(CKKILL),HL	;pass vector
;
;	common kill vector
;
KILLIT	BIT	4,(IX+0)	;dead already?
	RET	Z		;yep, no need!
	PUSH	IX		;pass to IY for kill
	POP	IY		;IY => dir record
;
KILLLP	RES	4,(IY+0)	;de-activate this entry
;
KILLLP1	LD	A,(IY+16H)	;get extension entry
	CP	0FFH		;terminator?
	RET	Z		;yep, done!
	CALL	CKKEXT		;any extensions?
	LD	H,A		;start track of kill
	LD	A,(IY+17H)	;get gran offset/count
	CALL	$		;compute grans
CKKILL	EQU	$-2
	INC	IY		;bump to next extent
	INC	IY		;2 bytes each
	JR	KILLLP1		;go next extent pair
;
;	check for extension
;
CKKEXT	NOP			;III place RET here
	CP	0FEH		;extension?
	RET	NZ		;nope, continue
;
;	fetch pointer to extension
;
	LD	A,(IY+17H)	;get extension DEC
	PUSH	HL		;save HL
	LD	L,A		;pass LSB
	AND	7		;get sector offset
	LD	H,A		;pass to MSB
	LD	A,L		;get original DEC
	AND	0E0H		;get byte offset
	LD	L,A		;HL = sector/byte offset
	ADD	HL,DE		;point to next entry
	PUSH	HL		;pass to IY
	POP	IY		;IY => extension
	POP	HL		;restore HL
	EX	(SP),HL		;remove call vector
	POP	HL		;restore HL
	JP	KILLLP		;kill extension
;
;	delete extents on Mod III directory
;
KR3	AND	0E0H		;get gran offset
	LD	L,1		;start sector gran 1
	JR	Z,PASTAA	;go if first
	CP	20H		;second gran?
	LD	L,4		;start sector
	JR	Z,PASTAA	;go if yes
	CP	40H		;3'rd gran?
	LD	L,7		;sector offset
	JR	Z,PASTAA	;go if found
	CP	60H		;4th gran?
	LD	L,10		;start sector
	JR	Z,PASTAA	;go if found
	CP	80H		;5th gran?
	LD	L,13		;start sector
	JR	Z,PASTAA	;go if yes
	LD	L,16		;else 6th, start sector
;
PASTAA	LD	A,(IY+17H)	;get original back
	AND	1FH		;get gran counter
	LD	C,A		;here for count
	RET	Z		;go if nil file!
;
	PUSH	DE		;save HIT table pointer
	EX	DE,HL		;DE => start track/sector
	DEC	H		;HL points to HIT table
	DEC	H		;HL => GAT table
	LD	L,D		;point to GAT track
	LD	A,E		;see if start on sec 0
	CP	1		;first sector?
	JR	Z,RELLP		;go if yes
	CP	4		;second?
	JR	Z,SECOND	;go if yes
	CP	7		;third?
	JR	Z,THIRD		;go if yes
	CP	10		;fourth?
	JR	Z,FOURTH	;go if yes
	CP	13		;fifth?
	JR	Z,FIFTH		;go if yes
	JR	SIXTH		;last!
;
;	release grans assigned to file
;
RELLP	RES	0,(HL)		;release the gran
	DEC	C		;less gran counter
	JR	Z,RELDONE	;done with this entry
;
SECOND	RES	1,(HL)		;release the gran
	DEC	C		;less gran counter
	JR	Z,RELDONE	;go if done
;
THIRD	RES	2,(HL)		;release gran
	DEC	C		;less gran counter
	JR	Z,RELDONE	;go if done
;
FOURTH	RES	3,(HL)		;release gran
	DEC	C		;less counter
	JR	Z,RELDONE	;go if done
;
FIFTH	RES	4,(HL)		;release gran
	DEC	C		;less gran counter
	JR	Z,RELDONE	;go if done
;
SIXTH	RES	5,(HL)		;release gran
	DEC	C		;less gran counter
	JR	Z,RELDONE	;go if done
;
	INC	HL		;point to next track
	JR	RELLP		;go next gran
;
RELDONE	POP	DE		;restore DE
	RET			;HIT done separately
;
;	release space on source file
;
KR1	LD	L,0		;init sector #
	BIT	5,A		;first gran?
	JR	Z,KR11		;go if yes
	LD	L,5		;start sector gran 2
;
KR11	AND	1FH		;get # grans
	INC	A		;adjust to actual
	LD	C,A		;pass to counter
	PUSH	DE		;save DE
	EX	DE,HL		;HL => directory start
	DEC	H		;points to HIT
	DEC	H		;points to GAT
	LD	L,D		;pass track #
	LD	A,E		;get start sector
	OR	A		;first gran?
	JR	NZ,SECND	;go if not!
;
RELP1	RES	0,(HL)		;release gran
	DEC	C		;less counter
	JR	Z,RELDN1	;go if done!
;
SECND	RES	1,(HL)		;release gran
	INC	HL		;bump table pointer
	DEC	C		;less gran counter
	JR	NZ,RELP1	;go if more to do
;
RELDN1	POP	DE		;restore stack
	RET			;file de-allocated!
;
;	create file on dest drive
;
;	check if current file is to be replaced
;
CREATE2	LD	A,L		;get lsb
	SUB	5		;move back to entry start
	LD	L,A		;HL => record start
	BIT	4,(HL)		;alive ?
	JR	Z,CREAT2B	;skip it, dead already
;
CREAT2A	PUSH	HL		;save on stack
	LD	A,1		;load Mod I flag
	LD	(GFLAG),A	;pass to gran counter
	CALL	PRTFILE		;print the filename
	LD	HL,MSG25	;ask if to be replaced
	RST	20H		;display prompt
	CALL	INKEY		;wait for answer
	PUSH	AF		;save key
	LD	HL,MSG00	;linefeed
	RST	20H		;clear line
	POP	AF		;restore input key
	POP	HL		;restore HL
	LD	DE,SDIRBUF+200H	;source records
	CP	'N'		;no ?
	JP	Z,SKILLIT	;cancel this file
	CP	'Y'		;yes ?
	JR	NZ,CREAT2A	;try again
;
;	overwrite, first kill current dest file
;
	PUSH	IX		;save pointer
	PUSH	HL		;pass start to IX
	POP	IX		;IX => current record
	LD	DE,DDIRBUF+200H	;dest dir records
	CALL	DKILLIT		;kill dest file
	POP	IX		;restore pointer
	JR	CREATE3		;continue
;
;	reset pointer to name text
;
CREAT2B	LD	A,L		;get LSB pointer
	ADD	A,5		;add offset to name
	LD	L,A		;HL => current filename
	JR	CREAT2C		;continue with dir
;
;	create current file on dest drive
;
CREATE	LD	A,0		;get prompt flag
FLAG	EQU	$-1
	DEC	A		;must be 1 for prompt
	JR	NZ,CREAT00	;continue with no prompt
;
;	ask user if file is to be copied
;
	LD	A,1		;set Mod I
	LD	(GFLAG),A	;set gran flag
	CALL	PRTFILE		;show name
	LD	HL,MSG12	;copy it?
	RST	20H		;display prompt
	CALL	INKEY		;get a key
	PUSH	AF		;save key
	LD	HL,MSG00	;linefeed
	RST	20H		;clear current line
	POP	AF		;restore input key
	LD	DE,SDIRBUF+200H	;source dir records
	CP	'N'		;nope ?
	JP	Z,SKILLIT	;kill from source file
	CP	'Y'		;yes ?
	JR	NZ,CREATE	;ask again if wrong
;
;	create file on dest disk
;
CREAT00	PUSH	IX		;pass file data start
	POP	DE		;to DE
	LD	A,E		;get LSB
	ADD	A,5		;point to name
	LD	E,A		;DE => filename
	LD	HL,DDIRBUF+205H	;destination name start
	LD	C,80		;# directory records
;
;	check if current file already exists on dest
;
CREATE1	CALL	IFMATCH		;see if files match
	JR	Z,CREATE2	;see if to be overwritten
CREAT2C	PUSH	BC		;save this
	LD	BC,30H		;displacement between
	ADD	HL,BC		;add to dest pointer
	POP	BC		;get counter back
	LD	A,L		;get LSB
	CP	0F5H		;at last line?
	JR	NZ,CUOO		;nope, continue
	LD	L,5		;reset to sector start
	INC	H		;bump sector pointer
CUOO	DEC	C		;less entry counter
	JR	NZ,CREATE1	;go some more
;
;	file does not exist, create it on dest directory
;
CREATE3	CALL	FNDSPOT		;locate an entry
	PUSH	HL		;pass to IY for allocate
	POP	IY		;IY => new entry
	EX	DE,HL		;DE => dest spot
	PUSH	IX		;pass source to HL
	POP	HL		;HL => source spot
	LD	BC,22		;move the entry here
	LDIR			;exact duplication
	LD	H,D		;pass pointer to DE
	LD	L,E
	INC	DE		;clear the extents
	LD	BC,25		;extent length -1
	LD	(HL),0FFH	;set no extents
	LDIR			;fill extent field
;
;	check if EOF correction to be made
;
	PUSH	HL		;save
	LD	L,(IY+14H)	;get EOF sector
	LD	H,(IY+15H)
	LD	A,(IY+3)	;get EOFB
	OR	A		;zero EOF byte?
	JR	Z,$+3		;don't bump if 0
INCEPT	INC	HL		;intercept with SPACEBAR
	LD	(IY+14H),L	;update EOF sector
	LD	(IY+15H),H
	POP	HL		;restore HL
;
;	remove passwords due to incompatability
;
	LD	(IY+10H),0EFH	;set nil passwords
	LD	(IY+11H),5CH
	LD	(IY+12H),0EFH
	LD	(IY+13H),5CH
;
	PUSH	IY		;save from manygrans
	LD	A,1		;set Mod I
	LD	(GFLAG),A	;pass gran flag
	CALL	MNYGRNS		;how many grans we need?
	LD	A,3		;set Mod III
	LD	(GFLAG),A	;pass gran flag
	LD	A,(HL)		;get # grans
	CALL	NEWGRNS		;compute grans rel III
	POP	IY		;restore IY
	LD	B,A		;pass # grans to B
ALLOCL0	LD	A,12		;allow 12 extents/entry
	PUSH	IY		;save pointer
;
ALLOCLP	PUSH	AF		;save extent counter
	CALL	CHUNK		;allocate chunk of grans
	LD	HL,MSG26	;disk space full
	JP	C,ERROR		;no good
	LD	(IY+16H),D	;save start track
	LD	A,C		;get gran count
	OR	E		;or with sector start
	LD	(IY+17H),A	;save this too
	INC	IY		;look at next entry
	INC	IY
	LD	A,B		;get needed count
	SUB	C		;less this entry
	LD	B,A		;re-save it
	JR	Z,ALLOCDN	;finished
	POP	AF		;get 12 counter back
	DEC	A		;only 12 spots available
	JR	NZ,ALLOCLP	;do them all
	LD	HL,MSG13	;out of entry space!
	JP	ERROR		;go file error!
;
;	allocation complete
;
ALLOCDN	POP	AF		;restore stack
	POP	IY		;restore pointer
	RET			;done with this entry
;
;	locate inactive entry for new file
;
FNDSPOT	LD	HL,DDIRBUF+200H	;dest dir file start
	PUSH	DE		;save DE
	PUSH	BC		;save BC
	LD	B,80		;80 entries/dir
	LD	DE,30H		;offset between entries
;
CREATE4	BIT	4,(HL)		;available?
	JR	Z,CREATE5	;got one if yes
;
CREATE6	ADD	HL,DE		;offset to next entry
	LD	A,L		;get LSB result
	CP	0F0H		;at last line?
	JR	NZ,CRR5		;continue if not
	LD	L,0		;else set first record
	INC	H		;of the next sector
;
CRR5	DJNZ	CREATE4		;continue for length
	LD	HL,MSG13	;out of filespace
	JP	ERROR		;terminate
;
CREATE5	LD	A,L		;get lsb = DEC
	POP	BC		;restore stack
	POP	DE
	RET			;HL => entry area
;
;	fetch chunk of disk space
;
CHUNK	LD	HL,DDIRBUF	;dest gat table
	LD	C,0		;how many allocated
;
CHUNK1	BIT	0,(HL)		;gran 0 available?
	LD	D,L		;get track we're on
	LD	E,0		;gran offset
	JR	Z,CHUNK2	;yes, set E at 0
	BIT	1,(HL)		;gran 1 available ?
	LD	E,20H		;start gran offset
	JR	Z,CHUNK3	;yes, set E at 20H
	BIT	2,(HL)		;gran 2?
	LD	E,40H		;gran offset
	JR	Z,CHUNK4	;go if yes
	BIT	3,(HL)		;gran 3?
	LD	E,60H		;gran offset
	JR	Z,CHUNK5	;go if yes
	BIT	4,(HL)		;gran 4?
	LD	E,80H		;gran offset
	JR	Z,CHUNK6	;go if yes
	LD	E,0A0H		;else gran offset
	BIT	5,(HL)		;gran 5?
	JR	Z,CHUNK7	;go if yes
	INC	L		;next track
	LD	A,L		;get track #
	CP	40		;end of table?
	JR	C,CHUNK1	;continue if not
	SCF			;C = error
	RET			;done, disk space full!
;
CHUNK2	BIT	0,(HL)		;allocation test
	JR	NZ,CHUNK8	;finished
	SET	0,(HL)		;allocate it
	INC	C		;bump counter
	LD	A,B		;get needed count
	CP	C		;enough ?
	RET	Z		;done
	CALL	IFNUF		;at max?
	RET	Z		;go if yes
;
CHUNK3	BIT	1,(HL)		;allocation test
	JR	NZ,CHUNK8	;done if not
	SET	1,(HL)		;allocate it
	INC	C		;bump gran counter
	LD	A,B		;get desired
	CP	C		;enough?
	RET	Z		;yes, go!
	CALL	IFNUF		;at max?
	RET	Z		;go if yes
;
CHUNK4	BIT	2,(HL)		;available?
	JR	NZ,CHUNK8	;go if not
	SET	2,(HL)		;allocate it
	INC	C		;bump gran counter
	LD	A,B		;get # needed
	CP	C		;enough?
	RET	Z		;yes, go!
	CALL	IFNUF		;at max?
	RET	Z		;yes, go!
;
CHUNK5	BIT	3,(HL)		;gran free?
	JR	NZ,CHUNK8	;nope, go!
	SET	3,(HL)		;else allocate it
	INC	C		;bump gran counter
	LD	A,B		;get # needed
	CP	C		;enough?
	RET	Z		;yes, go!
	CALL	IFNUF		;at maximum?
	RET	Z		;yes, go!
;
CHUNK6	BIT	4,(HL)		;gran free?
	JR	NZ,CHUNK8	;go if not
	SET	4,(HL)		;else grab it
	INC	C		;bump gran counter
	LD	A,B		;get # needed
	CP	C		;enough?
	RET	Z		;yes, go!
	CALL	IFNUF		;at max?
	RET	Z		;yes, return
;
CHUNK7	BIT	5,(HL)		;gran free?
	JR	NZ,CHUNK8	;go if not
	SET	5,(HL)		;else allocate it
	INC	C		;bump gran counter
	LD	A,B		;get # needed
	CP	C		;enough?
	RET	Z		;go if yes
	CALL	IFNUF		;at max?
	RET	Z		;yes, go!
;
	INC	L		;next track
	LD	A,L		;get track #
	CP	40		;at end?
	JR	C,CHUNK2	;go more if not
	SCF			;else set disk full!
	RET			;return in error!
;
CHUNK8	OR	A		;clear carry
	RET			;return OK
;
;	check if max # grans
;
IFNUF	LD	A,C		;get gran counter
	CP	1FH		;at max?
	RET			;Z = yes!
;
;	transfer current file
;
DOCOPY	LD	HL,MSG22	;copying file....
	RST	20H		;display it
	LD	A,1		;set mod I flag
	LD	(GFLAG),A	;pass to gran flag
	CALL	PRTFILE		;print filename
	CALL	POSITIY		;position IY to file
	LD	HL,1		;position in file
;
DOCOPY0	XOR	A		;use this as a counter
	LD	(COUNTER),A	;save it
	LD	(DESPOS),HL	;dest start position
	PUSH	HL		;save this
	CALL	SMOUNT		;mount source disk
	POP	HL		;restore posit
	LD	BC,DATABUF	;data buffer
;
DOCOPY1	PUSH	BC		;save buffer
	PUSH	HL		;save position
	CALL	POSITS		;position file
	POP	HL		;restore position
	POP	BC		;restore buffer
	JR	C,EMPTBUF	;write the buffer back
;
	PUSH	HL		;save position
	LD	A,5		;sector / source gran
	CALL	SMREAD		;read gran
	POP	HL		;restore it
	JR	NZ,DOCOPYN	;bad read on source
	INC	HL		;bump position in file
	LD	A,0		;get gran counter
COUNTER	EQU	$-1
	INC	A		;+ this gran
	LD	(COUNTER),A	;update counter
	LD	A,B		;get page in memory
	CP	0		;at top of memory?
TOPMEM	EQU	$-1
	JR	C,DOCOPY1	;go if more room
	OR	A		;clear carry for not done
;
EMPTBUF	PUSH	AF		;save carry flag for loop
	PUSH	HL		;save posit
	CALL	DMOUNT		;mount destination disk
	LD	A,3		;set mod III flag
	LD	(GFLAG),A	;to gran counter
	LD	A,(COUNTER)	;get # grans loaded
	CALL	NEWGRNS		;compute new # sectors
	LD	(COUNTER),A	;update counter
	LD	BC,DATABUF	;where data is
	LD	HL,0		;get start position
DESPOS	EQU	$-2		;saved from above
	CALL	CREWRIT		;write the grans back
	POP	HL		;restore position
	POP	AF		;get result back
	RET	C		;done with this file
	JR	DOCOPY0		;else do the rest
;
;	this file had an error
;
DOCOPYN	LD	HL,MSG7		;error message
	JP	ERROR		;source read error
;
;	create new HIT table on dest directory
;
MAKEHIT	LD	HL,DDIRBUF+100H	;dest HIT table
	LD	DE,DDIRBUF+101H	;start +1
	LD	BC,0DFH		;length HIT -1
	LD	(HL),0		;zero it out
	LDIR			;table cleared
	LD	IX,DDIRBUF+200H	;start of names
	LD	B,80		;80 entries
	XOR	A		;load rel file #
	LD	(TEMP0),A	;pass to temp storage
;
HITLP	BIT	4,(IX+0)	;active entry
	PUSH	BC		;save count
	CALL	NZ,PUTHIT	;insert HIT byte if yes
	LD	BC,30H		;next entry offset
	ADD	IX,BC		;IX => next entry
	PUSH	IX		;pass to BC for test
	POP	BC		;BC => next entry
	LD	A,C		;get LSB
	CP	0F0H		;at last row?
	JR	NZ,ASDF		;nope, continue
	LD	C,0		;else reset to first
	INC	B		;and bump sector
	PUSH	BC		;save
	POP	IX		;IX => entry
ASDF	POP	BC		;restore BC
	LD	A,(TEMP0)	;get rel file #
	INC	A		;+ this file
	LD	(TEMP0),A	;update
	DJNZ	HITLP		;do all 80 files
	RET			;done, HIT re-built
;
;	hash current filespec
;
HASH	PUSH	IX		;save position
	PUSH	BC		;save counter
	LD	BC,0B00H	;B = char count, C = hash
;
HASHLP	LD	A,(IX+5)	;get a name byte
	INC	IX		;point to next one
	XOR	C		;hash it
	RLCA			;shift bits
	LD	C,A		;update subtotal
	DJNZ	HASHLP		;go for count
	OR	A		;check for 0 hash
	JR	NZ,HASHOK	;ok if not
	INC	A		;else make it 1
HASHOK	POP	BC		;restore BC
	POP	IX		;restore file pointer
	RET			;done, A = HASH code
;
;	install current HIT
;
PUTHIT	BIT	7,(IX+0)	;extension entry ?
	RET	NZ		;don't do those YET
	LD	HL,DDIRBUF+100H	;start HIT table
	LD	A,0		;get rel file entry
TEMP0	EQU	$-1
	LD	L,A		;L = HIT entry
	CALL	HASH		;compute hash byte
	LD	(HL),A		;put in table
	RET			;done!
;
;	position file @ IY to HL relative sector
;
POSITIY	PUSH	IX		;pass to HL for compare
	POP	DE		;DE => entry
	LD	A,E		;get LSB
	ADD	A,5		;offset to name
	LD	E,A		;point to name
	LD	HL,DDIRBUF+205H	;start records
	LD	C,80		;80 files to check
;
POSIY1	CALL	IFMATCH		;compare names
	JR	Z,POSIYG	;go if match
	PUSH	BC		;save count
	LD	BC,30H		;point to next entries
	ADD	HL,BC		;HL => next entry
	POP	BC		;restore count
	LD	A,L		;get LSB
	CP	0F5H		;at last row?
	JR	NZ,LKJ		;go if not
	LD	L,5		;reset to start record
	INC	H		;and bump sector
LKJ	DEC	C		;less entry counter
	JR	NZ,POSIY1	;continue if more
;
;	cannot locate the file!!!!
;
	LD	HL,MSG24	;program error
	JP	ERROR		;go error vector
;
POSIYG	LD	A,L		;get dest LSB
	SUB	5		;offset to entry start
	LD	L,A		;HL => entry start
	PUSH	HL		;pass to IY
	POP	IY		;IY => current entry
	RET			;IY => filename (dest)
;
;	position to source record
;
POSITS	PUSH	IY		;must save IY from use
	PUSH	IX		;pass to IY
	POP	IY		;IY => name
	LD	DE,SDIRBUF+200H	;source buffer
	LD	(SAVEDIR),DE	;save for postion use
	XOR	A		;load NOP
	LD	(CKPEXT),A	;for extension checker
	PUSH	HL		;save it
	LD	HL,CP1		;sub vector
	LD	(COMPOS),HL	;pass vector
	LD	HL,NG1		;vector
	LD	(NEXGRAN),HL	;for next gran compute
	POP	HL		;restore HL
	CALL	POSIT		;position to IY file
	POP	IY		;restore IY
	RET			;file positioned
;
;	position to dest file
;
POSITD	PUSH	IY		;save IY
	LD	DE,DDIRBUF+200H	;dest dir buffer
	LD	(SAVEDIR),DE	;save it
	LD	A,0C9H		;RET opcode
	LD	(CKPEXT),A	;for extension checker
	PUSH	HL		;save HL
	LD	HL,CP3		;sub vector
	LD	(COMPOS),HL	;pass it
	LD	HL,NG3		;sub vector
	LD	(NEXGRAN),HL	;for next gran calculate
	POP	HL		;restore HL
	CALL	POSIT		;position the file
	POP	IY		;restore it
	RET			;file positioned
;
;	position current file @ IY
;
POSIT	LD	A,(IY+16H)	;get extent
	CP	0FFH		;terminator?
	SCF			;C = EOF
	RET	Z		;return if end
	CALL	CKPEXT		;any extensions?
	LD	D,A		;else start track
	LD	A,(IY+17H)	;get offset/grans
	CALL	$		;compute # grans
COMPOS	EQU	$-2
	JP	POSIT2A		;continue
;
;	compute sector of current gran
;
CP3	LD	E,1		;start with sector 1
	PUSH	AF		;save
	AND	0E0H		;get gran offset
	JR	Z,POSIT2-1	;go if found
	CP	20H		;2nd?
	LD	E,4		;sector offset
	JR	Z,POSIT2-1	;go if yes
	CP	40H		;3rd?
	LD	E,7		;sector offset
	JR	Z,POSIT2-1	;go if yes
	CP	60H		;4th?
	LD	E,10		;sector offset
	JR	Z,POSIT2-1	;go if yes
	CP	80H		;5th?
	LD	E,13		;sector offset
	JR	Z,POSIT2-1	;go if yes
	LD	E,16		;else sector offset
;
	POP	AF		;restore A
POSIT2	AND	1FH		;get gran counter
	RET			;done!
;
CP1	LD	E,0		;start sector mod I
	BIT	5,A		;first gran?
	JR	Z,POSIT21	;yes, go!
	LD	E,5		;start sector gran 2
;
POSIT21	AND	1FH		;get # grans
	INC	A		;adjust to actual
	RET			;done!
;
;	check for extensions
;
CKPEXT	NOP			;NOP or RET codes
	CP	0FEH		;extension?
	RET	NZ		;go if not
;
	LD	A,(IY+17H)	;get DEC of extension
	PUSH	HL		;save HL
	LD	L,A		;save DEC
	AND	7		;get sector offset
	LD	H,A		;save in H
	LD	A,L		;get original DEC
	AND	0E0H		;get byte offset
	LD	L,A		;HL = file offset
	LD	DE,(SAVEDIR)	;start of dir
	ADD	HL,DE		;HL=> extension entry
	PUSH	HL		;pass to IY
	POP	IY		;IY => extension
	POP	HL		;restore HL
	EX	(SP),HL		;remove call vector
	POP	HL		;HL original
	JP	POSIT		;continue with position
;
POSIT2A	LD	(CNTSAV),A	;save the counter
	DEC	HL		;reduce posit count
	LD	A,H		;position complete?
	OR	L		;any bits left ?
	RET	Z		;yes, DE = track/sector
	CALL	$		;compute next gran
NEXGRAN EQU	$-2
	LD	A,0		;get count back
CNTSAV	EQU	$-1
	DEC	A		;reduce it
	JR	NZ,POSIT2A	;go if more to do
	INC	IY		;next extent
	INC	IY
	JR	POSIT		;continue position
;
NG3	LD	A,E		;get current sector
	ADD	A,3		;add offset to next gran
	LD	E,A		;update sector
	CP	19		;1-18 range?
	RET	NZ		;yes, go!
	LD	E,1		;else reset first sector
	INC	D		;bump track
	RET			;DE = next gran
;
NG1	LD	A,E		;get sector
	CP	5		;at second gran?
	JR	Z,NG11		;go if yes
	LD	E,5		;set second gran
	RET			;done
NG11	LD	E,0		;set first sector
	INC	D		;bump track
	RET			;done!
;
;	write data to dest file
;
CREWRIT	PUSH	HL		;save counter
	PUSH	BC		;save buffer
	CALL	POSITD		;posit dest file
	POP	BC		;restore buffer
	LD	A,3		;3 sectors/gran
	CALL	MWRITE		;multiple write
	LD	HL,MSG9		;dest write error
	JP	NZ,ERROR	;terminate
	POP	HL		;restore position
	INC	HL		;+1
	LD	A,(COUNTER)	;get # sectors to write
	DEC	A		;reduce it
	RET	Z		;done with this bunch
	LD	(COUNTER),A	;else update counter
	JR	CREWRIT		;continue
;
;	new 'trick' alive display
;
GETTASK	LD	A,(TASKC1)	;get task counter
	LD	E,A		;pass to E
	LD	D,0		;DE = task offset
	LD	L,A		;pass to L
	LD	H,D		;HL = task offset
	ADD	HL,HL		;*2
	ADD	HL,DE		;*3
	LD	DE,TASKTBL	;start task table
	ADD	HL,DE		;HL => current display
	LD	A,0		;get counter
TASKC1	EQU	$-1
	INC	A		;+1
	CP	20		;0-19?
	JR	C,TASKC2	;go if yes
	XOR	A		;else reset position
TASKC2	LD	(TASKC1),A	;update next counter
	RET			;done, HL => table
;
;	'alive' definition table
;
TASKTBL	DEFB	088H,082H,090H
	DEFB	084H,090H,089H
	DEFB	080H,089H,080H
	DEFB	081H,091H,088H
	DEFB	0A0H,089H,080H
	DEFB	081H,090H,082H
	DEFB	082H,084H,084H
	DEFB	0A0H,082H,0A0H
	DEFB	0A0H,084H,088H
	DEFB	089H,0A0H,082H
	DEFB	084H,081H,090H
	DEFB	081H,084H,080H
	DEFB	090H,088H,080H
	DEFB	082H,090H,0A0H
	DEFB	080H,084H,092H
	DEFB	0A2H,080H,084H
	DEFB	088H,081H,0A0H
	DEFB	080H,0A4H,081H
	DEFB	084H,082H,090H
	DEFB	081H,0A4H,080H
;
;	display 'alive' to video
;
ALIVE	CALL	GETTASK		;get table offset
	LD	DE,3C00H+61	;where on video
	LDI			;move to video
	LDI			;2
	LDI			;3 chars to move
	RET			;done!
;
;	compute new # grans from I => III
;
NEWGRNS PUSH	AF		;save it
	LD	A,0		;get gran flag
GFLAG	EQU	$-1
	CP	1		;mod I?
	JR	Z,NEWG1		;yes, go!
	POP	AF		;restore count
;
	PUSH	HL		;save it
	PUSH	BC		;save
	PUSH	DE		;save
	CALL	MUL5		;sectors X 5
	CALL	DIV6		;sectors / 3
	POP	DE		;unstack
	POP	BC		;unstack
	POP	HL		;unstack
	RET			;done, A = sector count
;
NEWG1	POP	AF		;no adjust mod I
	RET			;return original
;
;	multiply A X 5
;
MUL5	LD	L,A		;pass binary start
	LD	H,0		;HL = # grans
	PUSH	BC		;save
	LD	C,5		;mult factor
	CALL	MULT		;multiply it
	POP	BC		;restore
	RET			;done, HL = result
;
;	divide # sectors / 3 secs/gran
;
DIV6	PUSH	BC		;save
	LD	C,3		;3 secs/gran
	CALL	DIVID		;divide
	LD	A,C		;get LSB result
	OR	A		;any remainder?
	JR	Z,DIV6O		;go if not
	INC	HL		;else bump result
DIV6O	LD	A,L		;get LSB # sectors
	POP	BC		;restore
	RET			;A = # converted grans
;
;	multiply
;
MULT	PUSH	DE		;save
	EX	DE,HL		;DE = multiplicand
	LD	H,0		;init multiplier
	LD	L,A		;HL = multiplier
	LD	B,8		;8 bits precision
;
M1	ADD	HL,HL		;*2
	RLA			;catch overflow
	RLC	C		;move into C
	JR	NC,M2		;go if no overflow
	ADD	HL,DE		;*3
	ADC	A,0		;catch overflow
M2	DJNZ	M1		;for for precision
	POP	DE		;restore
	RET			;AHL = result
;
;	divide
;
DIVID	PUSH	DE		;save
	LD	D,C		;pass divisor
	LD	E,16		;16 bits precision
	XOR	A		;init remainder
DIV1	ADD	HL,HL		;shift left
	RLA			;catch overflow
	JR	C,DIV2		;go if yes
	CP	D		;at divisor?
	JR	C,DIV3		;less, go!
DIV2	SUB	D		;subtract divisor
	INC	L		;bump result
DIV3	DEC	E		;less precision
	JR	NZ,DIV1		;go if more
	POP	DE		;restore stack
	RET			;HL/A = result
;
;	compute # grans from dir record
;
GRAN13	PUSH	AF		;save
	LD	A,(GFLAG)	;get gran flag
	CP	1		;mod I?
	JR	Z,GRAN1		;go if yes
	POP	AF		;restore original
	AND	1FH		;# grans
	RET			;done!
GRAN1	POP	AF		;restore
	AND	1FH		;# grans
	INC	A		;+1
	RET
;
;  **  MESSAGE TEXT  **
;
FILMSG	DEFB	10
SFILESA	DEFM	'xxx Files, '
SGRANSA	DEFM	'xxx Grans to be copied'
	DEFB	10
	DEFB	0
;
FILENAM	DEFM	'            '
	DEFB	0
;
	DEFM	' / '
GRANMSG	DEFM	'xxx Grans'
	DEFB	11
	DEFB	0
;
MSG00	DEFB	10
	DEFB	0
;
MSG0	DEFB	1DH
	DEFB	1EH
	DEFB	0
;
MSG1	DEFB	31
	DEFM	'SuperMOVE - Mod III Transfer Utility'
	DEFM	' - by '
KIM	DEFB	'Kim Watt'
	DEFB	10
	DEFM	'Copyright (C) 1982 Breeze/QSD, Inc. '
	DEFM	'- All Rights Reserved'
	DEFB	10
	DEFM	'*******************************'
	DEFM	'*******************************'
	DEFB	10
	DEFB	10
	DEFM	'This program will copy the following'
	DEFM	' files from this'
	DEFB	10
	DEFM	'diskette onto another TRSDOS III'
	DEFM	' formatted disk on any drive'
	DEFB	10
	DEFB	0
;
MSG2AA	DEFM	'Disk Name/Date:  '
MSG2	DEFM	'         -         '
	DEFB	10
	DEFB	0
;
MSG3	DEFM	'                '
	DEFB	10
	DEFB	0
;
MSG4	DEFB	1DH
	DEFM	'Mount SOURCE disk, <KEY>:'
	DEFB	0
;
MSG5	DEFB	1DH
	DEFM	'Mount DESTINATION disk, <KEY>:'
	DEFB	0
;
MSG6	DEFB	1DH
	DEFB	1EH
	DEFM	'Destination Drive ? '
	DEFB	0
;
MSG7	DEFB	10
	DEFM	'SOURCE Disk READ ERROR !'
	DEFB	10
	DEFB	0
;
MSG8	DEFB	10
	DEFM	'DESTINATION Disk READ ERROR !'
	DEFB	10
	DEFB	0
;
MSG9	DEFB	10
	DEFM	'DESTINATION Disk WRITE ERROR !'
	DEFB	10
	DEFB	0
;
MSG10	DEFB	10
	DEFM	'Program TERMINATED in ERROR'
	DEFB	10
	DEFB	0
;
MSG11	DEFB	10
	DEFM	'CANNOT LOCATE Directory'
	DEFB	10
	DEFB	0
;
MSG12	DEFM	'<< Copy it ? '
	DEFB	0
;
MSG13	DEFB	10
	DEFM	'FILE SPACE FULL !'
	DEFB	10
	DEFB	0
;
MSG18	DEFM	'xxx Grans available on destination disk'
	DEFB	10
	DEFB	0
;
MSG19	DEFM	'<KEY> to proceed with copy:'
	DEFB	0
;
MSG20	DEFM	'<KEY> to BOOT:'
	DEFB	0
;
MSG21	DEFB	10
	DEFM	'Destination Directory Update'
	DEFM	' WRITE ERROR!'
	DEFB	10
	DEFB	0
;
MSG22	DEFM	'Copying File ==>> '
	DEFB	0
;
MSG23	DEFM	'**  Copy Completed  **'
	DEFB	10
	DEFB	0
;
MSG24	DEFB	10
	DEFM	'Internal error.  Notify Breeze/QSD'
	DEFB	10
	DEFB	0
;
MSG25	DEFM	'<< EXISTS, Replace it ? '
	DEFB	0
;
MSG26	DEFB	10
	DEFB	'DISK SPACE FULL !'
	DEFB	10
	DEFB	0
;
MSG27	DEFM	'Updating Destination Directory'
	DEFB	10
	DEFB	0
;
MSG28	DEFM	'Not enough grans on Destination Disk,'
	DEFM	' Select files to copy'
	DEFB	10
	DEFB	0
;
;**  BUFFERS  **
;
LOWEND	EQU	$&0FF00H	;get even page of memory
SDIRBUF	EQU	LOWEND+100H	;source dir buffer
DDIRBUF	EQU	SDIRBUF+1200H	;dest dir buffer
DATABUF	EQU	DDIRBUF+1200H	;for data I/O
;
