; ********  MEMDISK  **********
;
	ORG	6000H
;
	TITLE	<DISK SOURCE 1.0.8 >
	COM	'<MemDISK 101, (c) 1982 by Galactic Software Ltd.>'
;
;+=+=+ Equate Table +=+=+
;
@DSPLY	EQU	4467H
@KEYIN	EQU	40H
@EXIT	EQU	402DH
@DATE1	EQU	4470H
@DATE3	EQU	3033H
HIGH$1	EQU	4049H
HIGH$3	EQU	4411H
CURSOR	EQU	4020H
CLS	EQU	1C9H
SPC	EQU	20H
CR	EQU	13
LF	EQU	10
EOT	EQU	3
BPTRK	EQU	1536
WP	EQU	15
;
;+=+=+=+=+=+=+=+=+=+=+=+=
;
;
;*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*=*
;
START	CALL	CLS		;Clear the screen
	LD	(SAVEDCT),DE	;save DCT address
;
;=== Display Entry Message ===
;
	LD	HL,LOGON	;Display message
	CALL	@DSPLY		;and all the formalities
;
;
;=== Set System Entry points to MOD I/III addresses ===
;
;
	LD	A,(125H)	;Model I or III ?
	CP	49H		;MOD III?
	LD	HL,HIGH$3	;default MOD III
	LD	DE,@DATE3	;default "" ""
	JR	Z,MODIII	;do it
	LD	HL,HIGH$1	;Mod I High$
	LD	DE,@DATE1	;Mod I Date
MODIII	LD	(HIGH1+2),HL	;stuff in address
	LD	(HIGH2+1),HL	;stuff in address
	LD	(HIGH3+2),HL	;stuff in address
	LD	(HIGH4+1),HL	;stuff in address
	LD	(HIGH5+1),HL	;stuff in address
	LD	(DATE+1),DE	;stuff in address
;
;
;
;=== Stuff Logical Drive number into header ===
;
;
;
NOPARM	LD	A,(SAVEDCT)	;p/u lsb of DCT address
	LD	B,-1		;B = dividend
DIVID10	INC	B		;increment dividend
	SUB	10		;divisor = 10
	JR	NC,DIVID10	;successive sub's til C
	LD	A,B		;A = dividend
	ADD	A,30H		;convert to ASCII
	LD	(LOGDRIV),A	;stuff in Drive address
	LD	(MEMDISK+7),A	;stuff into GAT
;
;
;=== Input Number of Sectors per Granule (1 or 2) ===
;
;
INPSEC	LD	HL,SECGRAN	;"How many sec/gran ?"
	CALL	@DSPLY		;display it
	LD	B,1		;input a 1 or 2
	LD	HL,BUFFER	;Keyboard input buffer
	CALL	@KEYIN		;system input
	JP	C,@EXIT		;exit if <BREAK>
	INC	B		;If B=0 then
	DEC	B		;no characters input
	JR	Z,INPSEC	;if so - start again
	LD	A,(HL)		;p/u byte
	CP	'0'		;can't be less
	JR	C,INPSEC	;it is - re-input
	JR	Z,DISABLE	;zero- disable drive
	CP	'1'		;normal-default
	JP	Z,START2	;input number of tracks
	CP	'2'+1		;better be less
	JR	NC,INPSEC	;re-input
;
;
;*=*=* Values for 12 Sector/Track, 2 Sector/Gran *=*=*
;
;
	LD	A,1		;stuff a X'01' for # trks
	LD	(DIGNUM+1),A	;1 digit track input
	LD	A,7		;OPCODE for RLCA
	LD	(MULT12A),A	;used to multiply
	LD	(MULT12B),A	;Sector # x 2
	LD	A,0BH		;New ERN
	LD	(BYTE7+3),A	;DCT = 12 sectors/track
	INC	A		;stuff X'0C' into
	LD	(DIR+20),A	;lsb of 2-byte ERN
	LD	(BPTRK1+2),A	;Bytes/track
	LD	(BPTRK2+2),A	;change to X'0C00' bpt
	LD	A,10100001B	;DCT = 2 sectors/granule
	LD	(BYTE8+3),A	;stuff into DCT address
	LD	A,'3'		;"3" of 3.0 tracks
	LD	(FRTRK1),A	;stuff into  string
	LD	A,'0'		;"0" of 3.0 tracks
	LD	(FRTRK1+2),A	;stuff into string
	LD	A,'9'		;"9" tracks maximum
	LD	(FRTRK2),A	;stuff into string
	LD	A,EOT		;end of text
	LD	(FRTRK2+1),A	;stuff into string
	JP	START2		;jump around this mess
;
;
;
;
;*+*+* Disable the Drive *+*+*
;
;
DISABLE	LD	HL,(SAVEDCT)	;p/u DCT address
	LD	A,(HL)		;get disable/enable byte
	CP	0C3H		;Enabled ?
	JR	NZ,NODIZE	;it ain't there !
	INC	HL		;HL => lsb of driver add.
	LD	E,(HL)		;p/u lsb driver address
	INC	HL		;HL => msb of driver add.
	LD	D,(HL)		;DE => driver address
	EX	DE,HL		;HL => driver address
	LD	(DRADD),HL	;save driver address
	INC	HL		;bump pointer
	INC	HL		;HL => lsb of old HIGH$
	LD	E,(HL)		;p/u lsb of old High
	INC	HL		;HL => msb of high
	LD	D,(HL)		;DE => old HIGH$
	LD	(SAVEHI),DE	;store it away
	INC	HL		;bump pointer
	INC	HL		;HL => Driver Header
	LD	DE,MEMDISK	;"MEMDISK"
	LD	B,7		;Header length of 7
LOOPH	LD	A,(DE)		;p/u MEMDISK byte
	CP	(HL)		;must be same
	JR	NZ,NODIZE	;no - ain't it
	INC	HL		;bump pointers
	INC	DE		;HL => Source DE => Dest
	DJNZ	LOOPH		;do it HEADLEN times
;
;
;**** MEMDISK is in HIGH memory ****
;
;
	LD	HL,(DRADD)	;driver address
HIGH3	LD	DE,(0000)	;Mod I/III HIGH$
	INC	DE		;DE => first protected
	OR	A		;clear carry
	SBC	HL,DE		;better be same
	JR	NZ,CANTDO	;Can't do it
	LD	HL,(SAVEHI)	;old HIGH$
HIGH4	LD	(0000H),HL	;stuff in old high$
	LD	HL,(SAVEDCT)	;HL => DCT Address
	LD	(HL),0C9H	;disable it
	LD	HL,DISABE	;"MEMDISK" disabled
	JR	NODIZE+3	;display and exit
;
NODIZE	LD	HL,NOTPRES	;"MEMDISK not present"
	CALL	@DSPLY		;display it
	JP	@EXIT		;and return
;
CANTDO	LD	HL,UNABLE	;"Can't do it Jack"
	JR	NODIZE+3	;display & exit
;
;
;=== Input Number of Tracks and Convert to # in A ===
;
;
;
;
START2	LD	HL,FRTRACK	;"Number of free tracks"
	CALL	@DSPLY		;display it
	LD	HL,FRTRK3	;" (0=Disable) ? "
	CALL	@DSPLY		;display it
;
;#=#=# Stuff a X'01' in DIGNUM+1 if 12 sec/track #=#=#
;
DIGNUM	LD	B,2		;maximum of 1/2 digits
;
	LD	HL,BUFFER	;input buffer
	CALL	@KEYIN		;input number of tracks
	JP	C,@EXIT		;exit & Ret to LDOS
	INC	B		;If B = 0
	DEC	B		;Then not a valid input
	JR	Z,START2	;re-start
	LD	A,(HL)		;get byte
	SUB	30H		;strip high bits
	JR	C,START2	;re-start
	CP	10		;valid digit ?
	JR	NC,START2	;re-start
	LD	D,A		;save digit
	INC	HL		;next byte in buffer
	DEC	B		;dec digit counter
	JR	Z,DONE1		;all done
	LD	A,(HL)		;p/u second digit
	SUB	30H		;strip off ASCII bits
	JR	C,START2	;re-start
	CP	10		;legal digit
	JR	NC,START2	;no - return to start
	LD	E,A		;save digit
	LD	A,D		;p/u ten's digit
	SLA	A		;multiply
	SLA	A		;A times 10
	ADD	A,D		;and add it
	SLA	A		;to the ones digit
	ADD	A,E		;A = number of tracks
	CP	20		;A must be less
	JR	NC,START2	;than 20, but
DONE1	OR	A		;greater than
	JR	Z,START2	;input again
;
;
;
;
;=== Calculate where to put DISKMEM and new HIGH$ ===
;
;
PUTIN	PUSH	AF		;save # of tracks
	INC	A		;A = Total # of tracks
	LD	D,A		;Multiply A x 6 or 12
	RLCA			;A x 2
	ADD	A,D		;A x 3
	RLCA			;A x 6
;
;*** Stuff a RLCA instruction here if 2 sec / gran ***
;
MULT12A	NOP			;A x 12 if 2 sec/gran
;
	LD	D,A		;Store A in D
	LD	E,0		;bytes disk storage
	LD	HL,LENGTH	;HL = length of driver
	PUSH	HL		;save length
	ADD	HL,DE		;HL = Total space used
HIGH1	LD	DE,(0000H)	;p/u high$
	LD	(OLDHIGH),DE	;stuff into header
	OR	A		;clear carry
	EX	DE,HL		;HL => current HIGH$
	SBC	HL,DE		;Enough memory
;
;
;=== Check if enough memory is present ===
;
;
	BIT	7,H		;HL must be > X'7FFF'
	JR	NZ,HIGH2	;yes - enough memory
	LD	HL,INSFMEM	;no - "Insufficient Mem"
	CALL	@DSPLY		;display it
	JP	@EXIT		;do not honor request
;
;
;=== Change HIGH$ and relocate driver ===
;
;
HIGH2	LD	(0000H),HL	;new high$
	INC	HL		;first byte of prog
	POP	BC		;get length of driver
	PUSH	HL		;save program start
	ADD	HL,BC		;start of 
	LD	(LOADHL+1),HL	;stuff in GAT address
	POP	HL		;get start
	LD	DE,DRIVER	;Start of driver
	OR	A		;clear carry
	PUSH	HL		;save destination
	SBC	HL,DE		;offset
	LD	B,H		;Set BC = offset
	LD	C,L		;to add
	LD	HL,REL1+1	;first relocatable
	LD	E,(HL)		;p/u lsb
	INC	HL		;next byte
	LD	D,(HL)		;DE = address
	EX	DE,HL		;HL = address
	ADD	HL,BC		;new address
	LD	(REL1+1),HL	;stuff in new address
	LD	(REL2+1),HL	;Take care of CALL's
	LD	HL,REL4+1	;HL => address
	LD	E,(HL)		;p/u lsb of address
	INC	HL		;HL => msb
	LD	D,(HL)		;p/u msb
	EX	DE,HL		;HL = address
	ADD	HL,BC		;add offset
	LD	(REL4+1),HL	;stuff in address
	LD	HL,DRIVER	;Source
	POP	DE		;Destination
	PUSH	DE		;Save start
	LD	BC,LENGTH	;# bytes to move
	LDIR			;do it baby
	POP	DE		;restore start
	POP	AF		;restore # of tracks
;
;
;
;=== Set up the Drive Code Table ===
;
;
;
	LD	IY,(SAVEDCT)	;IY => DCT address
;
	LD	(IY+0),0C3H	;Enable
	LD	(IY+1),E	;lsb of driver
	LD	(IY+2),D	;msb of driver
	LD	(IY+3),0	;SD,5",floppy,Rem,step=6
	LD	(IY+4),0	;DDC=N, 1 side, STD DC
	LD	(IY+5),0	;Current Cyl = 0
	LD	(IY+6),A	;# of tracks rel from 0
;
;=#=#= Byte7 + 3 will be a X'0B' if 2 sec/gran =#=#=
;
BYTE7	LD	(IY+7),5	;6/12 sectors per track
;
;=#=#= Byte8 + 3 will be a X'A1' if 2 sec/gran =#=#=
;
BYTE8	LD	(IY+8),0A0H	;6 g/c, 1/2 sec's per gran
;
	LD	(IY+9),1	;Directory Cyl = 1
;
;
;
;=== Format memory, initialize GAT, HIT, & DIR/SYS ===
;
;
	LD	HL,(LOADHL+1)	;p/u Start of GAT
	CALL	FORMAT		;format
	CALL	INITGAT		;initialize GAT
	INC	H		;HL => HIT
	CALL	INITHIT		;initialize HIT
	INC	H		;HL => 4th sector
	INC	H		;first entry
	CALL	INITDIR		;put DIR/SYS in slot
;
;=== That's all Folks ===
;
	JP	@EXIT		;return to LDOS
;
;
;
;
;*=*=*   FORMATTING OF THE DISK ?   *=*=*
;
;
;
;
;*+*+*  Initialize Granule Allocation Table *+*+*
;
;HL => GAT start address
;A = Number of FREE tracks on drive
;
INITGAT	CALL	SAVEREG		;Save all registers used
	PUSH	HL		;save start of GAT
	PUSH	AF		;save # free tracks
;
;*=*=* Stuff lockout bytes (X'FF') *=*=*
;*=*=* into GAT+X'00' - GAT+X'CA'  *=*=*
;
	LD	B,0CBH		;Lock out the bytes
LOCKOUT	LD	(HL),0FFH	;GAT + X'00' through
	INC	HL		;GAT + X'CA'
	DJNZ	LOCKOUT		;do it 96 times
;
;*=*=* GAT + X'CB' *=*=*
;
	LD	(HL),51H	;GAT + X'CB'= Version 5.1
;
;*=*=* GAT + X'CC' *=*=*
;
	SUB	33		;tracks in excess of 35
	INC	HL		;HL => next GAT byte
	LD	(HL),A		;GAT + X'CC'= tracks - 35
;
;*=*=* GAT + X'CD' *=*=*
;
	INC	HL		;GAT + X'CD' =
	LD	(HL),05		;SDEN, 1 Side, 6 gran/cyl
;
;*=*=* GAT + X'CE' & X'CF' *=*=*
;
	INC	HL		;GAT + X'CE' & X'CF' =
	LD	(HL),0E0H	;16-bit Hash code of
	INC	HL		;"PASSWORD"
	LD	(HL),42H	;Hash = X'E042'
;
;*=*=* GAT + X'D0' - X'D7' *=*=*
;
	INC	HL		;HL => next GAT byte
	LD	DE,MEMDISK	;"MEMDISK " is Pack ID
	LD	C,8		;Eight bytes
	EX	DE,HL		;swap 'em for LDIR
	LDIR			;stuff in ID
	EX	DE,HL		;HL => GAT + X'D8'
;
;*=*=* GAT + X'D8' - X'DF' *=*=*
;
DATE	CALL	0000H		;stuff date in GAT
;
;*=*=* GAT + X'E0' - X'FF' *=*=*
;
	LD	(HL),CR		;X'0D' - no auto
;
	LD	B,31		;put blank spaces
BLANK	INC	HL		;next GAT byte
	LD	(HL),SPC	;blank space X'20'
	DJNZ	BLANK		;31 times
;
;*=*=* GAT + X'02' - GAT + X'02' + # free tracks *=*=*
;
	LD	A,0C0H		;6 gran/track
	OR	A		;clear carry
	LD	BC,253		;point HL to
	SBC	HL,BC		;GAT + X'02'
	POP	BC		;B = # free tracks
FREETRK	LD	(HL),A		;free track
	INC	HL		;next GAT byte
	DJNZ	FREETRK		;do it B times
;
;*=*=* GAT + X'60' - GAT + X'BF' *=*=*
;
	POP	DE		;DE => start of GAT
	LD	H,D		;HL => start of GAT
	LD	L,E		;plus the offset
	LD	BC,60H		;of X'60' for the
	ADD	HL,BC		;duplicate of top
	EX	DE,HL		;prepare for LDIR
	LDIR			;duplicate allocation
;
	RET			;all done
;
;
;
;
;*+*+* Initialize Hash Index Table *+*+*
;
;
;
;HL => HIT start address
;
INITHIT	CALL	SAVEREG		;Save all registers used
	LD	B,0		;256 bytes to zero out
ZEROHIT	LD	(HL),0		;zero HIT position
	INC	HL		;bump HIT pointer
	DJNZ	ZEROHIT		;do it 256 times
	DEC	H		;HL => HIT + X'00'
	INC	HL		;HL => HIT + X'01'
	LD	(HL),0C4H	;Hash for DIR/SYS
	RET			;done
;
;
;
;
;*+*+* Initial DIR/SYS entry *+*+*
;
;
;
;HL => Start of DIR/SYS slot
;
INITDIR	CALL	SAVEREG		;Save all registers used
	LD	DE,DIR		;DIR/SYS byte field
	EX	DE,HL		;swap for ldir
	LD	BC,32		;32 bytes in entry
	LDIR			;block move
	RET			;done
;
;((((( DIR/SYS Bytes )))))
;
DIR	DB	01011101B	;read only,inv,sys,FPDE
	DW	0		;Date= 00/00/00
	DW	0		;EOF offset=0, LRL=256
	DM	'DIR     '	;Name field "DIR     "
	DM	'SYS'		;Extension field "SYS"
	DW	0E972H		;Update password hash
	DW	4296H		;Access password hash
	DW	6		;ERN+1=6 or 12
	DB	1		;starts on cylinder 1
	DB	00000101B	;st. gran=0, 6 cont grans
	DW	0FFFFH		;No Second Extent
	DW	0FFFFH		;No Third Extent
	DW	0FFFFH		;No Fourth Extent
	DB	0FFH		;No further records
	DB	0FFH		;No DEC for DIR/SYS
;
;
;
;
;*+*+* Format and Verify RAM Tracks *+*+*
;
;
;
;HL => Starting Byte of first track to Verify
;A = Number of Free Tracks used
;
FORMAT	CALL	SAVEREG		;Save all registers used
	INC	A		;offset two
	LD	(COMPARE+1),A	;Compare post byte
	PUSH	HL		;save track pointer
	LD	HL,VERIFY	;"Verifying RAM ..."
	CALL	@DSPLY		;display it
	POP	HL		;and HL
	LD	D,00		;track counter
WIPELP	LD	A,11111111B	;all bits on
	CALL	VERTRK		;verify track w/ bits on
	LD	A,00000000B	;all bits off
	CALL	VERTRK		;verify track w/ bits off
	LD	A,01010101B	;next pattern
	CALL 	VERTRK
	LD	A,10101010B	;last pattern
	CALL	VERTRK
	LD	A,D		;pu	track-1
	OR	A		;check for 0
	JR	Z,GODO		;is DIR trk put 00
	INC	A		; NOT DIR correct trk #
GODO	CALL	VERTRK		; final trk init
;
;#=#=# Stuff an X'0C' in BPTRK1 + 1 if 12 sec/gran #=#=#
;
BPTRK1	LD	BC,BPTRK	;bytes per track
;
	ADD	HL,BC		;point to next track
	LD	A,D		;get track counter
	CALL	DECASC		;display Dec ASCII equiv.
	INC	D		;bump track counter
	LD	A,D		;get counter
COMPARE	CP	00		;changed
	JR	NZ,WIPELP	;do it D times
	LD	HL,FORMCOM	;"Formatting Complete"
	CALL	@DSPLY		;print it
	RET			;done formatting
;
;*=*=* VERIFY A TRACK *=*=*
;
VERTRK	PUSH	HL		;Save Pointer
	PUSH	DE		;save DE
;
;#=#=# Stuff a X'0C' into BPTRK2+1 if 12 sec/track #=#=#
;
BPTRK2	LD	BC,BPTRK	;Loop is 1 less than bpt
;
LOOPV	LD	(HL),A		;set bit
	CP	(HL)		;same ?
	JP	NZ,ERROR	;not the same !!!
	INC	HL		;bump pointer
	LD	D,A		;store character
	DEC	BC		;dec byte count
	LD	A,B		;is BC = 0
	OR	C		;B=0 & C=0
	LD	A,D		;get A back
	JP	NZ,LOOPV	;not done yet
	POP	DE		;restore DE
	POP	HL		;restore counter
	RET			;oky doky
;
;
;
;
;*=*=* Display Decimal ASCII equivilent *=*=*
;
DECASC	CALL	SAVEREG		;save registers
	LD	H,2FH		;H=msb  of BCD ASCII
LPADD	INC	H		;bump msb
	SUB	10		;successive sub's of 10
	JR	NC,LPADD	;keep doin'
	ADD	A,3AH		;A = lsb ASCII
	LD	L,A		;HL => DEC ASCII
	EX	DE,HL		;DE => DEC ASCII
	LD	HL,(CURSOR)	;get current Cursor
	DEC	HL		;backspace 2
	LD	(HL),E		;stuff in lsb
	DEC	HL		;HL => where we print
	LD	(HL),D		;stuff in msb
	RET			;ret & restore reg's
;
;*=*=* Verify Error *=*=*
;
ERROR	PUSH	HL		;save memory location
	LD	HL,BADRAM	;"BAD RAM BUDDY"
	CALL	@DSPLY		;display it
	POP	HL		;get verify error loc.
	CALL	DISHL		;display HL in Hex ASCII
	LD	HL,(OLDHIGH)	;p/u old high$
HIGH5	LD	(0000),HL	;restore HIGH$
	JP	@EXIT		;leave & clear stack
;
;
;*** Display HL in X'nnnn'= format
;
DISHL	PUSH	HL		;save HL
	EX	DE,HL		;point DE to number
	CALL	HEXASC		;convert to ASCII
	LD	HL,STRING	;HL=> X'nnnn'
	CALL	@DSPLY		;display it
	POP	HL		;restore
	RET			;all done
;
;conversion of hex number to hex ascii
;convert DE to ascii string pointed to by IX
;
HEXASC	LD	IX,STRTAB
	PUSH	IX
	LD	C,D
	LD	B,2
AS1	LD	A,0F0H
	AND	C
	RRCA
	RRCA
	RRCA
	RRCA
	CALL	ASCV1
	LD	A,0FH
	AND	C
	CALL	ASCV1
	DEC	B
	JR	NZ,KEPGOIN
	POP	IX
	RET
KEPGOIN	LD	C,E
	JR	AS1
ASCV1	ADD	A,30H
	CP	3AH
	JR	C,ASCV2
	ADD	A,7
ASCV2	LD	(IX),A
	INC	IX
	RET
;
;
XSPACE	DEFW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
;
;
;*=*=*=*=* DISKMEM Disk Driver *=*=*=*=*
;
;
;
DRIVER	JR	CHECK		;jump around header
OLDHIGH	DW	0		;Old High$
	DB	8,'MEMDISK'	;Header
LOGDRIV	DB	0		;Logical Drive Number
;
CHECK	LD	A,B		;get operation byte
	CP	2		;Operation #2 ?
	JR	Z,B2		;yes - do it to it
	CP	4		;Operation #4 same as #2
	JR	NZ,B5		;Check byte 5
B2	RES	4,(IY+3)	;Set to Side 0
	XOR	A		;Current Cyl = 0
	LD	(IY+5),A	;and set Z flag
	RET			;done - return
;
B5	CP	5		;Operation #5 ?
	JR	NZ,B6		;no - check for #6
	INC	(IY+5)		;Cyl = Cyl + 1
	XOR	A		;Reset A, set Z
	RET			;Bye  Bye
;
B6	CP	6		;Operation #6
	JR	NZ,B7		;no check #7
	LD	(IY+5),D	;Current cylinder
	XOR	A		;reset A, set Z
	RET			;Bye
;
B7	CP	7		;TSTBSY ?
	JR	NZ,B9		;no - check byte 9
	LD	A,0		;LD A,nn
VALUE	EQU	$-1		;nn of LD  A,nn
	XOR	2		;flip bit 1
REL4	LD	(VALUE),A	;store it
	BIT	0,A		;set Z flag
	RET			;return
;
;
B9	CP	9		;Operation #9 ?
	JR	Z,READS		;check Byte 13
	CP	10		;Verify sector ?
	JR	NZ,B13		;next byte
;
;*=*=* Read A Sector *=*=*
;
READS	LD	A,D		;Does the dude request
	OR	E		;Track 0, Sector 0
	JR	NZ,READS1	;no - Read a sector
	INC	HL		;point HL to
	INC	HL		;Dir Cyl Byte
	LD	(HL),1		;Dir Cyl = 1
	DEC	HL		;restore
	DEC	HL		;HL to Byte 0
	XOR	A		;successful Read
	RET			;Get out
;
READS1	PUSH	DE		;Save DE
	PUSH	BC		;Save BC
	PUSH	HL		;Save HL
	DEC	D		;Offset from 1
	PUSH	AF		;Save Z flag
REL1	CALL	HLDE		;point HL & DE
	LDIR			;put data into buffer
	POP	AF		;get Z
	JR	NZ,NOTDIR	;not a directory read
	LD	A,6		;Error Code = 6
	OR	A		;NZ condition
	JR	NOTDIR+1	;skip XOR A
NOTDIR	XOR	A		;Set Z flag
	POP	HL		;Restore the
	POP	BC		;Registers
	POP	DE		;used
	RET			;done !!!!
;
B13	CP	13		;Operation #13
	JR	NZ,B14		;check byte 14
;
;*=*=* Write A Sector *=*=*
;
;
;*:*:* Check if Software WP *:*:*
;
WRITES	LD	A,WP		;WP error X'0F'
	BIT	7,(IY+3)	;Software Write Protect?
	RET	NZ		;return with error
;
	LD	A,D		;No writing to
	OR	A		;Cylinder Zero
	RET	Z		;if so - Return
;
	PUSH	DE		;Save DE
	PUSH	BC		;Save BC
	PUSH	HL		;Save HL
	DEC	D		;offset from 1
REL2	CALL	HLDE		;point HL & DE
	EX	DE,HL		;swap 'em
	LDIR			;do it to it
	JR	NOTDIR		;restore registers & RET
;
B14	CP	14		;Operation 14 ?
	JR	Z,WRITES		;op14
;
EX1	XOR	A		;zero a, set Z
	RET			;Ha ha Done !!!!
;
;*=*=* This points HL to DISKMEM I/O source *=*=*
;*=*=* DE to the User Buffer, BC = 256 for LDIR *=*=*
;
;*=*=* BC => User Buffer *=*=*
;*=*=*  HL <= I/O Source, DE <= User Buffer *=*=*
;
HLDE	LD	B,H		;Set BC => User
	LD	C,L		;Buffer, later to DE
LOADHL	LD	HL,0000H	;Start of Disk Area
	LD	A,D		;Multiply D by 6 or 12
	RLCA			;depending on sec / gran
	ADD	A,D		;A x 3
	RLCA			;A x 6
;
;*** Stuff in a RLCA instruction if 2 sec/gran ***
;
MULT12B	NOP			;A x 12 if 2 sec/gran
;
	LD	D,A		;D x 6 or 12
	LD	A,E		;A = lsb
	LD	E,0		;lsb = 0
	ADD	HL,DE		;HL => Track
	LD	D,A		;p/u sector
	ADD	HL,DE		;offset
	LD	D,B		;DE => User Buffer
	LD	E,C		;to transfer data into
	LD	BC,256		;256 bytes to transfer
	RET			;HL => Source DE => dest
PSPACE	DEFB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
;
LENGTH	EQU	$-DRIVER
;
;**** Save Register Routine and destroy NONE! ****
;
SAVEREG	EX	(SP),HL
	LD	(RETADDR),HL
	POP	HL
	PUSH	HL
	LD	(SAVEDE),DE
	PUSH	DE
	PUSH	BC
	PUSH	AF
	LD	DE,RESTREG
	PUSH	DE
	LD	DE,(SAVEDE)
	DB	0C3H
RETADDR	DW	0
RESTREG	POP	AF
	POP	BC
	POP	DE
	POP	HL
	RET
SAVEDE	DW	0
SAVEDCT	DW	0
SAVEHI	DW	0
DRADD	DW	0
;
;
;#### STRINGS ####
;
LOGON	DB	'MemDISK - RAM - based disk drive '
	DB	'VER. 1.0.8 ',LF
	DB	'Copyright (C) 1982 by Galactic Software'
	DB	LF,CR
SECGRAN	DM	'1 or 2 Sectors/Granule (0=Disable) ?'
	DM	' ',EOT
FRTRACK	DM	'Note: Each Track equals '
FRTRK1	DM	'1.5K of space.',LF
	DM	'Number of free tracks 1-'
FRTRK2	DB	'19',EOT
FRTRK3	DM	' ? ',EOT
MEMDISK	DB	'MEMDISK '
INSFMEM	DM	LF,'Insufficient Memory ',LF,CR
NOTPRES	DM	LF,'MemDISK not present',LF,CR
DISABE	DM	LF,'MemDISK disabled, High memory re-'
	DM	'allocated',LF,CR
UNABLE	DM	LF,'Unable to disable MemDISK, '
	DM	'additional memory used',LF,CR
VERIFY	DM	LF,'Verifying RAM Track 00',EOT
BADRAM	DM	LF,'Verify Error at location ',EOT
FORMCOM	DM	LF,LF,'Verifying Complete, RAM good',LF
	DM	'Directory has been placed on Cylinder 1'
	DM	LF,LF,'Note: Real-Time clock still '
	DM	'accurate.',CR
;
STRING	DB	'X',39
STRTAB	DS	4
	DB	39,LF,LF,CR
;
;#### Other garbage used ####
;
BUFFER	DS	3
;
	END	START
USH	HL
	LD	(SAVEDE),DE
	PUSH	DE
	PUSH	BC
	PUSH	AF
	LD	DE,RESTREG
	PUSH	DE
	LD	DE,(SAVEDE)
	DB	0C3H
RETADDR	DW	0
RESTREG	POP	AF
	POP	BC
	POP	DE
	POP	HL
	RET
SAVEDE	DW	0
SAVEDCT	DW	0
SAVEHI	DW	0
DRADD	DW	0
;
;
;#### STRINGS ####
;
LOGON	DB	'MemDISK - RAM - based disk drive '
	DB	'VER. 1.0.8 ',LF
	DB	'Copyright (C) 1982 by Galactic Software'
	DB	LF,CR
SECGRAN	DM	'1 or 2 Sectors/Granule (0=Disable) ?'
	DM	' ',EOT
FRTRACK	DM	'Note: Each Track equals '
FRTRK1	DM	'1.5K of space.',LF
	DM	'Number of free tracks 1-'
FRTRK2	DB	'19',EOT
FRTRK3	DM	' ? ',EOT
MEMDISK	DB	'MEMDISK '
INSFMEM	DM	LF,'Insufficient Memory ',LF,CR
NOTPRES	DM	LF,'MemDISK not present',LF,CR
DISABE	DM	LF,'MemDISK disabled, High memory re-'
	DM	'allocated',LF,CR
UNABLE	DM	LF,'Unable to disable MemDISK