;ldcopy3/asm - kjw/bqsd - revised 12/82
;
	PAGE
;
	SUBTTL	'<LDCOPY3/ASM - Disk I/O Section>'
;
;	sector read
;
READ	LD	HL,SREAD	;subroutine vector
	LD	A,9FH		;error mask byte
	JR	COMMON		;go common I/O
;
;	sector write
;
WRITE	LD	HL,SWRITE	;sub vector
	LD	A,0FFH		;error mask
	JR	COMMON		;go I/O common
;
;	track write
;
WRITETR	LD	HL,TWRITE	;write code
	LD	A,0FFH		;error mask
;
COMMON	LD	(VECTOR),HL	;save call vector
	LD	(MASK),A	;save error mask
	LD	A,(IY+15)	;I/O retry reset
	LD	(IY+14),A	;init retry counter
;
COMMLP	PUSH	BC		;save buffer address
	LD	(IY+25),0	;clear checksum adder
	CALL	0		;call vector
VECTOR	EQU	$-2
	POP	BC		;restore buffer
	AND	0		;mask error bits
MASK	EQU	$-1
	RET	Z		;OK, return no error
	EX	AF,AF'		;save error code
;
;	clear FDC error condition
;
	LD	A,0D0H		;reset command
;
	IF	MODI
	LD	(37ECH),A	;FDC mod I
	ENDIF
;
	IF	MODIII
	OUT	(0F0H),A	;FDC mod III
	ENDIF
;
	DEC	(IY+14)		;less this attempt
	JR	NZ,COMMLP	;try again if any left
	EX	AF,AF'		;restore error
	RET			;return NZ
;
;	actual sector I/O for read
;
SREAD	CALL	SEEK		;move head to track
	RET	NZ		;error now, return
;
	IF	MODIII
	LD	(STACK),SP	;save current stack
	CALL	RSETNMI		;setup for NMI return
	LD	A,80H		;read command
	OUT	(0F0H),A	;issue to FDC
	CALL	DSKSLO		;short wait valid status
;
R1	IN	A,(0F0H)	;read FDC status
	AND	B		;check bit 1
	JR	Z,R1		;wait for byte ready
	IN	A,(C)		;read the byte
	LD	(HL),A		;to I/O buffer
	INC	HL		;bump buffer
	ADD	A,E		;add to checksum
	LD	E,A		;re-save new subtotal
;
R2	LD	A,D		;fetch drive select code
	OUT	(0F4H),A	;select and wait for byte
	IN	A,(C)		;fetch the byte
	LD	(HL),A		;to I/O buffer
	INC	HL		;bump pointer
	ADD	A,E		;add to checksum
	LD	E,A		;update subtotal
	JR	R2		;wait for interrupt
	ENDIF
;
	IF	MODI
	LD	HL,37ECH	;point to Mod I FDC
	DI			;disable interrupts
	LD	(HL),88H	;issue 'read' command
	CALL	DSKSLO		;wait for valid status
	PUSH	DE		;save track/sector
	LD	E,0		;E = checksum
;
RX0	LD	A,(HL)		;read FDC status
	AND	87H		;byte ready/motor on?
	JP	PO,RX0		;wait if not time yet
;
RX1	LD	A,(37EFH)	;fetch a byte from FDC
	LD	(BC),A		;load into I/O buffer
	INC	BC		;bump buffer pointer
	ADD	A,E		;add to checksum
	LD	E,A		;update new subtotal
;
RX2	BIT	1,(HL)		;byte ready?
	JR	NZ,RX1		;yes, go!
	BIT	1,(HL)		;byte ready?
	JR	NZ,RX1		;yes, go!
	BIT	7,(HL)		;motor still on?
	JR	NZ,RX3		;no, go!
	BIT	1,(HL)		;byte ready?
	JR	NZ,RX1		;yes, go!
	BIT	0,(HL)		;command still pending?
	JR	NZ,RX2		;yes, wait more!
;
RX3	LD	A,(HL)		;fetch result FDC status
	LD	(IY+25),E	;save checksum
	POP	DE		;restore DE
	EI			;enable interrupts
;
;	convert to DAM byte
;
	PUSH	AF		;save status byte
	RLCA			;align bits 6/5
	RLCA			;to bits 0/1
	RLCA
	AND	3		;low 2 bits only
	LD	(IY+30),A	;save resulting DAM
	POP	AF		;restore status
	RET			;return with status
	ENDIF
;
;	track write, save FDC command
;
	IF	MODI
TWRITE	LD	A,0F4H		;Mod I format command
	LD	(WRTYPE),A	;save write type code
	ENDIF
;
;	sector I/O write
;
SWRITE	CALL	SEEK		;move head to track
	RET	NZ		;return with error if bad
;
	IF	MODIII
	LD	(STACK),SP	;save current stack
	CALL	WSETNMI		;setup for NMI return
	LD	A,0A0H		;fetch write command
WRTYPE	EQU	$-1
	OUT	(0F0H),A	;give to FDC
	CALL	DSKSLO		;wait for valid status
;
W1	IN	A,(0F0H)	;read FDC status
	AND	B		;check ready bit
	JR	Z,W1		;wait if byte not ready
	LD	A,(HL)		;fetch byte from buffer
	OUT	(C),A		;give to FDC
	INC	HL		;bump buffer
	ADD	A,E		;add checksum
	LD	E,A		;update subtotal
;
	LD	B,60H		;delay before wait state
	DJNZ	$		;wait right here
W2	LD	A,D		;fetch select code
	OUT	(0F4H),A	;wait for next byte
	LD	A,(HL)		;fetch byte from buffer
	OUT	(C),A		;give to FDC
	INC	HL		;bump buffer pointer
	ADD	A,E		;add to checksum
	LD	E,A		;update subtotal
	JR	W2		;wait for interrupt
	ENDIF
;
	IF	MODI
	LD	HL,37ECH	;mod I FDC command reg.
	LD	A,(HL)		;fetch FDC status
	AND	40H		;write protected?
	RET	NZ		;yes, skip command
;
	DI			;disable for transfer
	LD	(HL),0A8H	;issue write command
WRTYPE	EQU	$-1
	CALL	DSKSLO		;wait for valid status
	PUSH	DE		;save track/sector
	LD	E,0		;E = checksum subtotal
	LD	A,(BC)		;fetch buffer byte
;
WX1	BIT	7,(HL)		;motor on?
	JR	NZ,WX5		;go if not!
	BIT	1,(HL)		;ready for a byte?
	JR	Z,WX1		;nope, wait
	LD	(DE),A		;give to FDC
	INC	BC		;bump buffer
	ADD	A,E		;add to checksum
	LD	E,A		;re-save value
	LD	A,(BC)		;fetch next byte
;
WX2	BIT	1,(HL)		;ready for byte?
	JR	Z,WX2		;nope, wait
;
WX3	LD	(DE),A		;give byte to FDC
	INC	BC		;bump buffer pointer
	ADD	A,E		;add to checksum byte
	LD	E,A		;update subtotal
	LD	A,(BC)		;fetch next byte
;
WX4	BIT	1,(HL)		;ready for byte?
	JR	NZ,WX3		;yes, send it!
	BIT	1,(HL)		;ready?
	JR	NZ,WX3		;yes, send!
	BIT	1,(HL)		;ready?
	JR	NZ,WX3		;yes, send!
	BIT	1,(HL)		;ready?
	JR	NZ,WX3		;yes, send!
	BIT	1,(HL)		;ready?
	JR	NZ,WX3		;yes, send!
	BIT	1,(HL)		;ready?
	JR	NZ,WX3		;yes, send!
	BIT	0,(HL)		;command still pending?
	JR	NZ,WX4		;yes, wait more
;
WX5	LD	A,(HL)		;read result status
	LD	(IY+25),E	;save checksum
	POP	DE		;restore track/sector
	EI			;enable interrupts
	RET			;return with status
	ENDIF
;
;	track write code, mod III only
;
	IF	MODIII
TWRITE	CALL	SEEK		;move head to track
	RET	NZ		;return with error
	LD	(STACK),SP	;save current stack
	CALL	WSETNMI		;setup for NMI return
	LD	A,0F0H		;get write track command
	OUT	(0F0H),A	;give to FDC
	CALL	DSKSLO		;wait for valid status
;
	INC	B		;set bits 0/1 mask
	JP	WW101		;write track!
;
;	setup NMI for read operation
;
RSETNMI	LD	HL,NMIRETR	;return vector
	JR	SETNMI		;go!
;
;	setup NMI for write operation
;
WSETNMI	LD	HL,NMIRETW	;return vector
;
SETNMI	LD	(SECPASS),DE	;pass DE pointer
	DI			;disable for transfer
	LD	(404AH),HL	;pass NMI vector
	LD	H,B		;pass buffer to HL
	LD	L,C		;HL => I/O buffer
	LD	A,(DRIVE)	;fetch drive select code
	OUT	(0F4H),A	;select drive
	OR	40H		;set 'wait states'
	LD	D,A		;save here for I/O
	LD	A,0C0H		;enable NMI disk I/O
	OUT	(0E4H),A	;motor off, command done
	LD	BC,02F3H	;B=bit 1 mask, C=I/O port
	LD	E,0		;E = checksum counter
	RET			;setup for I/O complete
	ENDIF
;
;	short delay to wait for FDC to
;	place valid status on bus
;
DSKSLO	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	EX	(SP),HL
	RET
;
;	NMI return vector for reads
;
	IF	MODIII
NMIRETR	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI on disk
	IN	A,(0F0H)	;read FDC status
	RLCA			;align bit 5 to bit 0
	RLCA
	RLCA
	AND	1		;bit 0 only
	LD	(IY+30),A	;save DAM bit
	JR	NMIRET		;go common return
;
;	NMI return vector for writes
;
NMIRETW	XOR	A		;load zero
	OUT	(0E4H),A	;disable future NMI int's
;
NMIRET	LD	HL,RETNMI	;non-disk NMI vector
	LD	(404AH),HL	;save into fixed vector
	LD	SP,0		;reset stack
STACK	EQU	$-2		;to entrant conditions
	LD	(IY+25),E	;save checksum byte
	LD	DE,0		;reset track/sector
SECPASS	EQU	$-2
	IN	A,(0F0H)	;read FDC status
	EI			;can enable interrupts
	RET			;return with status byte
	ENDIF
;
;	move head to track specified by D
;	sector register also loaded from E
;
SEEK	PUSH	HL		;save HL
	LD	HL,CTRACK	;current track table
	LD	A,0		;get binary drive #
DRV	EQU	$-1
	ADD	A,L		;add offset to table
	LD	L,A		;HL => current track
	LD	A,(HL)		;fetch track
;
;	load FDC track register with current track
;
	IF	MODI
	LD	(37EDH),A	;FDC track reg mod I
	ENDIF
;
	IF	MODIII
	OUT	(0F1H),A	;FDC track reg mod III
	ENDIF
;
	OR	A		;head current over trk 0?
	JR	NZ,SEEK0	;nope, go seek!
;
;	head is supposed to be over track zero,
;	issue a $RESTORE command to be sure!
;	on program entry, current track table has
;	values all preset to zeroes.  This code
;	will assure that the head is in a known place.
;
	CALL	RESTORE		;restore drive
	JR	NZ,BADSEEK	;not in system, go error
;
SEEK0	LD	A,(IY+8)	;get current desired trak
;
	IF	MODI
	LD	(37EFH),A	;FDC data address mod I
	ENDIF
;
	IF	MODIII
	OUT	(0F3H),A	;FDC data address mod III
	ENDIF
;
	CALL	SELECT		;select the drive
	JR	NZ,BADSEEK	;go if not ready
	LD	A,18H		;load $SEEK command
	OR	(IY+22)		;combine with step rate
;
	IF	MODI
	LD	(37ECH),A	;FDC command reg mod I
	ENDIF
;
	IF	MODIII
	OUT	(0F0H),A	;FDC command reg III
	ENDIF
;
	CALL	DSKSLO		;wait for valid status
;
;	wait for seek completion
;
SEEKWT	CALL	SELECT		;keep selected, long seek
;
	IF	MODI
	LD	A,(37ECH)	;read status mod I
	ENDIF
;
	IF	MODIII
	IN	A,(0F0H)	;read status mod III
	ENDIF
;
	BIT	0,A		;command still pending?
	JR	NZ,SEEKWT	;yes, wait more
	AND	18H		;check for CRC/NOT FOUND
	JR	NZ,BADSEEK	;go if error
;
	PUSH	AF		;save status
	LD	A,E		;get sector
;
	IF	MODI
	LD	(37EEH),A	;sector register mod I
	LD	A,(37EDH)	;read track register
	ENDIF
;
	IF	MODIII
	OUT	(0F2H),A	;sector register mod III
	IN	A,(0F1H)	;get new track mod III
	ENDIF
;
SEEKRET	LD	(HL),A		;update current track tbl
	POP	AF		;restore error status
	POP	HL		;restore HL
	RET			;return with Z flag
;
;	error on seek, force restore next access
;
BADSEEK	PUSH	AF		;save error status
	XOR	A		;force restore next time
	JR	SEEKRET		;continue
;
;	restore drive head to track zero
;
RESTORE	CALL	SELECT		;select drive
	RET	NZ		;error, return
;
	LD	A,08H		;'restore' FDC command
	OR	(IY+22)		;combine with step rate
;
	IF	MODI
	LD	(37ECH),A	;give to FDC mod I
	ENDIF
;
	IF	MODIII
	OUT	(0F0H),A	;to FDC mod III
	ENDIF
;
	CALL	DSKSLO		;wait for valid status
;
;	wait for command completion
;
RESWT	CALL	SELECT		;on for long, slow seeks
;
	IF	MODI
	LD	A,(37ECH)	;read status mod I
	ENDIF
;
	IF	MODIII
	IN	A,(0F0H)	;read status mod III
	ENDIF
;
	BIT	0,A		;command pending?
	JR	NZ,RESWT	;wait if yes
	CPL			;reverse bits
	AND	4		;track 0 LED sensed?
	RET	Z		;yes, return
	LD	A,1		;use this for error code
	RET			;NZ = error
;
	PAGE
;
;	display results of current copy operation
;
RESULT	LD	HL,MSG0		;clear line + linefeed
	CALL	DISPLAY		;display it
	XOR	A		;load zero
	LD	(IY+7),A	;set as current drive
;
RESLP	LD	HL,DRIVES	;active drive table
	CALL	POINT		;fetch byte
	INC	A		;FF = active
	JR	NZ,RESNXT	;skip if not
;
;	drive is active, see if locked out during copy
;
	LD	HL,XDRIVES	;active drives this loop
	CALL	POINT		;point to it
	CP	80H		;disabled?
	JR	Z,RESNXT	;go if disabled!
	INC	A		;still active?
	JR	NZ,BADDRV	;nope, drive removed!
;
;	drive copied OK!
;
	LD	HL,(COUNT)	;get completed count
	INC	HL		;bump it
	LD	(COUNT),HL	;update new count
	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG33A),A	;save ascii drive to text
	LD	HL,MSG33	;start of message
RESRES	CALL	DISPLAY		;'drive x copied OK'
;
;	check if serial # is to be installed
;
	LD	A,(IY+6)	;serial number flag
	CP	'*'		;off?
	JR	Z,RESFEED	;yes, no serial #'s
;
	CALL	SHOWSER		;display current serial #
	JR	RESNXT		;go next drive
;
;	error on drive, show as bad
;
BADDRV	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG34A),A	;ascii drive to text
	LD	HL,MSG34	;start of message
	JR	RESRES		;'bad copy, do not use'
;
;	no serial #'s, send linefeed to terminate line
;
RESFEED	LD	A,LF		;linefeed
	CALL	VOUT		;send to display
;
RESNXT	INC	(IY+7)		;bump current drive
	LD	A,(IY+7)	;fetch result
	CP	4		;drive 0-3?
	JR	C,RESLP		;go next if more
;
	PUSH	IY		;save data pointer
	LD	HL,(COUNT)	;fetch count completed
	LD	IY,MSG35A	;where to place ascii
	CALL	WRLNO		;convert to decimal ascii
	LD	HL,(COPIES)	;get # copies
	LD	IY,MSG35B	;text to place ascii
	CALL	WRLNO		;convert to decimal ascii
	POP	IY		;restore data pointer
;
	LD	HL,MSG35	;start of message
	JP	DISPLAY		;display it
;
;	display serial number of current drive
;
SHOWSER	CALL	FSER		;load DE with current #
	EX	DE,HL		;HL => number
	LD	DE,MSG45A	;text to place it
	LD	C,(IY+21)	;get serial # length
	LD	B,0		;BC = length
	LDIR			;move ascii # to string
	LD	HL,MSG45	;point to text
	JP	DISPLAY		;display it
;
;	fetch serial # of current drive
;
FSER	LD	A,(IY+7)	;get current drive
	ADD	A,A		;*2
	PUSH	HL		;save HL
	LD	HL,SERTBL	;table pointer
	ADD	A,L		;add drive offset
	LD	L,A		;HL => entry
	LD	E,(HL)		;fetch LSB
	INC	HL		;bump table pointer
	LD	D,(HL)		;fetch MSB
	POP	HL		;restore HL
	RET			;done, DE => ascii text
;
DRVASC	LD	A,(IY+7)	;fetch current drive
	ADD	A,'0'		;make it ascii
	RET			;return with A=drive
;
