;ldcopy2/asm - kjw/bqsd - revised 12/82
;
	PAGE
;
	SUBTTL	'<LDCOPY2/ASM - Program Logic/Subs>'
;
;	looper for each set of copies
;	also the BREAK key vector
;
LOOPER	LD	SP,STAK		;reset stack
	EI			;enable interrupts
	CALL	DRAIN		;clear pending keys
	LD	A,CR		;send C/R
	CALL	VOUT		;to display
	LD	IY,TABLE	;reset data block pointer
;
;	check to see if BREAK may have been pressed
;	during the input phase without all the
;	prompts having been answered
;
	LD	A,(IY+20)	;fetch init byte
	OR	A		;all questions answered?
	JP	NZ,START	;nope, restart program
	CALL	SERIALNOS	;compute/fetch serial #'s
	LD	HL,MSG8		;'mount all diskettes'
	CALL	DISPLAY		;display prompt
	LD	B,1		;1 char input
	CALL	GETSTR		;wait for <ENTER> key
;
	LD	HL,DRIVES	;start of active drives
	LD	DE,XDRIVES	;current loop table
	LD	BC,4		;4 bytes long
	LDIR			;reset current table
;
;	check for source disk mounted
;
	LD	A,(IY+5)	;get source drive
	CALL	SETDRV		;set it up
	CALL	STAT		;check if drive ready
	JP	NZ,ABORT	;abort if source bad!
;
;	check for mounted diskettes
;
	LD	HL,CHECKER	;subroutine
	CALL	DCOMMON		;do all drives
	CALL	ANYDEST		;check for remaining dest
;
	LD	A,(IY+27)	;GAT to skip tracks?
	CP	'Y'		;yes?
	CALL	Z,READGAT	;if yes, read the GAT
;
	CALL	COPY		;format/copy the disks
	CALL	PUTSERIAL	;install serial #'s
	CALL	RESULT		;display results of copy
;
	LD	HL,(COUNT)	;fetch # copies done
	LD	DE,(COPIES)	;fetch # requested to do
	OR	A		;clear carry flag
	SBC	HL,DE		;compare
	JR	C,LOOPER	;go if more to do
;
;	loop completed
;
	LD	HL,MSG9		;'all copies completed'
	CALL	DISPLAY		;display message
	LD	B,1		;1 char input
	CALL	GETSTR		;wait for <ENTER> key
	JP	START		;restart program
;
;	abort program from source disk error
;
TERMIN	CALL	RERROR		;fetch error text
;
ABORT	LD	HL,MSG32	;source disk error
	CALL	DISPLAY		;display it
	JR	LOOPER		;restart loop
;
;	display text to video - etx or cr terminates
;
DISPLAY	PUSH	IY		;save from ROM
	PUSH	DE		;this too
;
DISPLP	LD	A,(HL)		;fetch string byte
	INC	HL		;bump pointer
	CP	ETX		;end of text?
	JR	Z,DISPDN	;yes, go!
;
	PUSH	AF		;save char
	CALL	VOUT		;send char to display
	POP	AF		;restore char
;
	CP	CR		;terminator?
	JR	NZ,DISPLP	;nope, continue
;
DISPDN	POP	DE		;unstack
	POP	IY
	RET			;return
;
;	send char to video
;	only control codes go to ROM
;
VOUT	CP	' '		;control byte?
	JP	C,33H		;yes, use ROM
	PUSH	HL		;save pointer
	LD	HL,(4020H)	;fetch current cursor
	LD	(HL),A		;char to video
;
;	automatic lower case recognition
;
	CP	(HL)		;still there (locase?)
	JR	Z,VOK		;yes, go!
	SUB	' '		;adjust to upper case
	LD	(HL),A		;back to video
VOK	INC	HL		;bump cursor posit
	LD	(4020H),HL	;update cursor
;
;	check for cursor out of bounds from increment
;
	LD	A,H		;fetch MSB cursor
	CP	40H		;less than 4000H?
	JR	C,VOKOK		;yes, continue
	LD	HL,3FFFH	;set cursor here
	LD	(4020H),HL	;set cursor
	LD	A,LF		;send linefeed
;
	PUSH	IY		;save from ROM
	PUSH	DE
	CALL	33H		;display linefeed/scroll
	POP	DE		;unstack
	POP	IY
;
VOKOK	POP	HL		;restore pointer
	RET			;char displayed
;
;	fetch string from keyboard
;
GETSTR	LD	HL,STRING	;point to input buffer
	PUSH	IY		;save from ROM
	CALL	40H		;get string
	POP	IY		;restore pointer
	LD	A,B		;fetch input length
	OR	A		;set Z flag on it
	LD	A,(HL)		;return with first char
	RET			;go!
;
;	convert char in A to upper case
;
UCASE	CP	'a'		;less?
	RET	C		;yes, return
	CP	'z'+1		;more?
	RET	NC		;yes, return
	AND	5FH		;make it upper case
	RET			;go!
;
;	position HL to next significant character
;
	INC	HL		;bump pointer
POSHL	LD	A,(HL)		;fetch a char
	CP	' '		;separator?
	JR	Z,POSHL-1	;yes, skip over it
	CP	','		;separator?
	JR	Z,POSHL-1	;yes, skip over it
	CP	CR		;terminator?
	RET			;return Z if yes
;
;	fetch decimal numeric value from string
;
VALUE	CALL	POSHL		;fetch a char
	SCF			;Carry = error
	RET	Z		;return if nil value
	LD	BC,0		;init value
;
VALLP	LD	A,(HL)		;fetch a char
	CP	' '		;separator?
	RET	Z		;yes, done!
	CP	','		;separator?
	RET	Z		;yes, done!
	CP	CR		;terminator?
	RET	Z		;yes, done!
;
	CALL	MAKNUM		;convert to binary
	RET	C		;invalid, return error
;
	PUSH	HL		;save input pointer
	LD	H,B		;pass subtotal to HL
	LD	L,C		;HL = subtotal
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,BC		;*5
	ADD	HL,HL		;*10
	LD	C,A		;pass new digit
	LD	B,0		;BC = new number
	ADD	HL,BC		;add to subtotal
	LD	B,H		;pass back to BC
	LD	C,L		;BC = new subtotal
	POP	HL		;restore input pointer
	INC	HL		;bump pointer
	JR	VALLP		;go next char
;
;	convert ascii digit to binary decimal
;
MAKNUM	SUB	'0'		;remove ascii
	RET	C		;invalid, return
	CP	10		;0-9?
	CCF			;reverse carry
	RET			;return with C flag stat
;
	PAGE
;
;	begin loop to perform format/copy
;
COPY	LD	HL,FORMAT	;subroutine
	CALL	DCOMMON		;do all drives
;
	LD	HL,MSG1		;clear current line
	CALL	DISPLAY		;display it
;
	LD	A,(IY+24)	;copy data?
	INC	A		;copy?
	RET	NZ		;nope, done!
;
	LD	DE,0		;init track 0/sector 0
	LD	(TKIN),DE	;read posit
;
;	loop to copy data to all dest drives
;
INNER	LD	DE,0		;fetch current source dat
TKIN	EQU	$-2
	LD	(TKOUT),DE	;save for write start
	LD	(IY+29),0	;set 0 sectors in buffer
	CALL	READ1		;read source disk
	LD	HL,WRITE1	;subroutine
	CALL	DCOMMON		;do all drives
;
	LD	A,(TKIN+1)	;fetch current track
	CP	(IY+9)		;compare to track count
	JR	C,INNER		;go if not done
	RET			;copy completed!
;
;	write buffer to all active dest drives
;
DCOMMON	XOR	A		;set drive 0
	LD	(IY+7),A	;set current drive
	LD	(DCMV),HL	;save vector
;
DCLP	LD	A,(IY+7)	;fetch current drive
	CALL	SETDRV		;setup for I/O
	LD	HL,XDRIVES	;drive table
	CALL	POINT		;point to drive offset
	INC	A		;FF = active?
	CALL	Z,$		;read/write/status
DCMV	EQU	$-2
	INC	(IY+7)		;bump to next drive
	LD	A,(IY+7)	;fetch result
	CP	4		;0-3?
	JR	C,DCLP		;yes, go next drive
	RET			;else all written to!
;
;	format current drive
;
FORMAT	LD	A,(IY+23)	;fetch format flag
	INC	A		;true?
	RET	NZ		;nope, skip format
;
	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG10A),A	;save ascii drive to text
	LD	HL,MSG10	;'formatting'
	CALL	DISPLAY		;display it
	LD	(IY+8),0	;set current track to 0
;
	CALL	RESTORE		;move drive head to trk 0
	JP	NZ,REMWRITE	;error, go!
	LD	(IY+0),':'	;'alive' char
	LD	(IY+1),' '	;'alive' off
;
FORMLP	CALL	FFLICK		;format 'flicker'
	CALL	BUILD		;create track image
	LD	BC,BUFFER	;I/O buffer to use
	CALL	WRITETR		;write the track
	JR	NZ,REMWRITE	;go if error
	INC	(IY+8)		;bump current track
	LD	A,(IY+8)	;fetch result
	CP	(IY+9)		;compare to track count
	JR	C,FORMLP	;go if more to format
;
ALVBAK	LD	(IY+0),86H	;reset 'on'
	LD	(IY+1),89H	;reset 'off'
	RET			;else disk is formatted!
;
;	disk/checksum error, remove drive from que
;
REMWRITE PUSH	HL		;save HL
	CALL	WERROR		;fetch write error text
	JR	REMDRIVE	;remove drive from que
;
;	remove drive from que due to read type error
;
REMREAD	PUSH	HL		;setup stack
	CALL	RERROR		;fetch msg pointer
;
REMDRIVE
	LD	(IY+0),'E'	;set different for error
	LD	(IY+1),' '
	CALL	DISPLAY		;display error message
	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG24A),A	;put in text string
	LD	HL,MSG24	;'drive x removed'
	CALL	DISPLAY		;display it
;
;	remove drive from active table
;
	LD	HL,XDRIVES	;current drive table
	CALL	POINT		;point to byte
	LD	(HL),0		;set as inactive
	POP	HL		;restore HL
;
;	check to see if any dest disks remain
;
ANYDEST	PUSH	HL		;save HL
	LD	HL,XDRIVES	;start of table
	LD	B,4		;check 4 drives
;
;	check for remaining dest drives
;
CKLP	LD	A,(HL)		;fetch table byte
	INC	A		;active?
	JR	Z,CKDN		;yes, continue
	INC	HL		;bump table
	DJNZ	CKLP		;go for 4 drives
;
;	no drives left to copy to!
;
	LD	HL,MSG12	;'no dest drives'
	CALL	DISPLAY		;display it
	JP	LOOPER		;go next pass
;
CKDN	POP	HL		;unstack pointer
	OR	-1		;set NZ for error
	RET			;return to caller
;
;	checker string to make sure my name stays
;
KIM2	DEFB	'K'+80H,'i'+80H,'m'+80H,' '+80H
	DEFB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
;
;	fetch write error message text
;
WERROR	LD	HL,TABLEW	;table of write errors
	JR	RWERR		;go read/write error
;
;	fetch read error message text
;
RERROR	LD	HL,TABLER	;table of read errors
;
RWERR	RLCA			;check if error bit
	JR	C,ERRHV		;yes, have the message!
	INC	HL		;bump table pointer
	INC	HL		;by 2 byte entries
	JR	RWERR		;continue looking
;
ERRHV	LD	A,(HL)		;fetch LSB pointer
	INC	HL		;bump table
	LD	H,(HL)		;fetch MSB pointer
	LD	L,A		;HL => message text
	RET			;return with it
;
;	lookup table for write error messages
;
TABLEW	DEFW	MSG13		;7 - 'not ready'
	DEFW	MSG14		;6 - 'write protect'
	DEFW	MSG15		;5 - 'hardware fault'
	DEFW	MSG16		;4 - 'not found'
	DEFW	MSG17		;3 - 'crc error'
	DEFW	MSG18		;2 - 'lost data'
	DEFW	MSG23		;1 - 'program error'
	DEFW	MSG31		;0 - 'not in system'
;
;	lookup table for read error messages
;
TABLER	DEFW	MSG13		;7 - 'not ready'
	DEFW	MSG23		;6 - 'program error'
	DEFW	MSG23		;5 - 'program error'
	DEFW	MSG20		;4 - 'not found'
	DEFW	MSG21		;3 - 'crc error'
	DEFW	MSG22		;2 - 'lost data'
	DEFW	MSG23		;1 - 'program error'
	DEFW	MSG31		;0 - 'not in system'
;
;	flicker subroutine for formatting
;
FFLICK	LD	A,':'.XOR.20H	;setup flicker character
	PUSH	BC		;save buffer pointer
	PUSH	HL		;save count
	PUSH	AF		;save flicker character
;
	LD	HL,(4020H)	;fetch cursor posit
	XOR	(HL)		;reverse char
	LD	(HL),A		;put on video
	INC	HL		;bump video
	INC	HL		;by 2
	LD	A,(IY+8)	;fetch current track
	CALL	ASCII		;to ascii
	LD	(HL),C		;MSB ascii to video
	INC	HL		;bump video
	LD	(HL),A		;LSB ascii to video
	INC	HL		;bump video
	INC	HL		;twice
	POP	AF		;fetch flicker char
	XOR	(HL)		;reverse char on video
	LD	(HL),A		;write result to video
;
	POP	HL		;unstack
	POP	BC
	RET			;and return
;
;	'flicker' for READ
;
RFLICK	LD	A,'-'.XOR.20H	;compute char
	JR	FLICKER		;go common
;
;	'flicker' for WRITE
;
WFLICK	LD	A,'+'.XOR.20H	;compute char
	JR	FLICKER		;go common
;
;	'flicker' for VERIFY
;
VFLICK	LD	A,'='.XOR.20H	;compute char
;
FLICKER	PUSH	HL		;save HL
	PUSH	BC		;save BC
;
	LD	HL,(4020H)	;fetch current cursor
	PUSH	AF		;save char to display
	XOR	(HL)		;reverse video char
	LD	(HL),A		;update video
	INC	HL		;bump video
	INC	HL		;twice
;
	LD	A,D		;get current track
	CALL	ASCII		;to ascii
	LD	(HL),C		;MSB ascii to video
	INC	HL		;bump video
	LD	(HL),A		;LSB ascii to video
	INC	HL		;bump video
	INC	HL		;twice
	POP	AF		;restore flicker char
	PUSH	AF		;re-save on stack
	XOR	(HL)		;reverse video char
	LD	(HL),A		;update video
	INC	HL		;bump video
	INC	HL		;twice
;
	LD	A,E		;fetch sector
	CALL	ASCII		;to decimal ascii
	LD	(HL),C		;MSB ascii to video
	INC	HL		;bump video
	LD	(HL),A		;LSB ascii to video
	INC	HL		;bump video
	INC	HL		;twice
	POP	AF		;restore flick char
	POP	BC		;restore BC buffer addr.
	PUSH	BC		;put back on stack
	PUSH	AF		;leave char too
	XOR	(HL)		;reverse video char
	LD	(HL),A		;update video
	INC	HL		;bump video
	INC	HL		;twice
;
	LD	A,B		;get MSB buffer address
	CALL	HEXCV		;to hex ascii
	LD	(HL),C		;MSB ascii to video
	INC	HL		;bump video
	LD	(HL),A		;LSB ascii to video
	INC	HL		;bump video
	LD	(HL),'0'	;set LSB buffer
	INC	HL		;bump video
	LD	(HL),'0'	;to 00H
	INC	HL		;bump video
	INC	HL		;twice
	POP	AF		;fetch flicker char
	XOR	(HL)		;alter video
	LD	(HL),A		;update video char
;
	POP	BC		;unstack
	POP	HL
	RET			;and return
;
;	check if drive is ready for I/O
;
STAT	LD	A,0D8H		;interrupt FDC
;
	IF	MODI
	LD	(37ECH),A	;reset FDC mod I
	AND	0D0H		;clear command
	LD	(37ECH),A	;FDC is cleared to type I
	ENDIF
;
	IF	MODIII
	OUT	(0F0H),A	;reset FDC mod III
	AND	0D0H		;clear
	OUT	(0F0H),A	;FDC cleared
	ENDIF
;
	CALL	SELECT		;select the drive
	LD	HL,MSG27	;'drive not ready'
	JR	NZ,HOLDER	;go if not ready
;
	LD	HL,MSG25	;'no diskette'
	LD	BC,4000H	;liberal count
;
;	attempt to detect NO index hole condition
;
TT1	CALL	TT0		;fetch index bit
	JR	NZ,TT1		;nope, wait a bit more
;
;	wait for index hole to come around
;
	LD	HL,MSG26	;'door open'
;
TT2	CALL	TT0		;fetch index bit
	JR	Z,TT2		;wait if not
;
	LD	HL,MSG25	;'no diskette'
;
;	make sure index hole goes away now
;
TT3	CALL	TT0		;fetch index bit
	JR	NZ,TT3		;yes, wait
;
	XOR	A		;all OK, return Z
	RET			;back to caller
;
;	decrement counter, and read index bit
;
TT0	DEC	BC		;less counter
	LD	A,B		;see if any left
	OR	C
	JR	Z,HOLDER-1	;remove caller if bad
;
	IF	MODI
	LD	A,(37ECH)	;read FDC
	ENDIF
;
	IF	MODIII
	IN	A,(0F0H)	;FDC III
	ENDIF
;
	AND	2		;check index bit
	RET			;return with Z flag
;
;	error detected!
;
	POP	AF		;remove call vector
HOLDER	OR	-1		;return NZ
	RET
;
	PAGE
;
;	begin loop to read buffer full from source
;
READ1	LD	A,(IY+11)	;get outer loop reset
	LD	(IY+10),A	;# tries allowed
;
	LD	A,(IY+5)	;fetch source drive
	CALL	SETDRV		;setup for I/O
	LD	(MSG28A),A	;save ascii drive to text
	LD	HL,MSG28	;'reading'
	CALL	DISPLAY		;display it
;
READ1A	LD	BC,BUFFER	;start of free buffer
	LD	IX,DAMBUFF	;data address/cksum buff
	LD	DE,(TKIN)	;get start track/sector
	LD	(IY+0),'-'	;reading
	LD	(IY+1),' '	;alive char
;
READ1B	LD	(IY+8),D	;save current track
	CALL	RFLICK		;display track/sector
	CALL	READ		;read the sector
	LD	A,(IY+30)	;get data address mark
	LD	(IX),A		;save into buffer
	LD	A,(IY+25)	;get sector checksum
	LD	(IX+1),A	;save into buffer
	INC	IX
	INC	IX		;double increment
	JP	NZ,TERMIN	;abort if any error
;
	CALL	NEXSEC		;advance DE to next sect.
	INC	(IY+29)		;bump # sectors in RAM
	INC	B		;advance buffer
	JR	Z,READ1C	;go if end of buffer
	LD	A,D		;fetch current track
	CP	(IY+9)		;test to disk end
	JR	C,READ1B	;go if not at end
;
READ1C	LD	A,(IY+4)	;get verify flag
	LD	(TKIN),DE	;save next start trk/sec
	CP	'Y'		;verify on?
	JP	NZ,ALVBAK	;restore alive
;
;	verify source read
;
	LD	A,(IY+5)	;fetch source drive
	CALL	SETDRV		;reset for I/O
	LD	(MSG30A),A	;save drive # to text
	LD	HL,MSG30	;'verifying'
	CALL	DISPLAY		;display it
	LD	DE,0		;fetch start track/sector
TKOUT	EQU	$-2
	LD	BC,BUFFER	;point to start of buffer
	LD	A,(IY+11)	;outer loop reset byte
	LD	(IY+10),A	;save for this pass
	LD	A,(IY+13)	;inner loop reset
	LD	(IY+12),A	;init it
	LD	A,(IY+29)	;get # sectors to check
	LD	(IY+31),A	;save for countdown
	LD	IX,DAMBUFF	;start of address marks
	LD	(IY+0),'='	;set 'alive'
	LD	(IY+1),' '
;
READ1D	LD	(IY+8),D	;save current track
	CALL	VFLICK		;display track/sector
;
	PUSH	BC		;save buff pointer
	LD	BC,VBUFF	;verify buffer
	CALL	READ		;read the sector
	POP	BC		;restore buff pointer
	JP	NZ,TERMIN	;abort in error
;
;	compare actual data in two buffers
;
	CALL	COMPARE		;compare two buffers
	LD	HL,MSG38	;'data mismatch'
	JR	NZ,READ1E	;go if bad
;
;	compare the data address mark type
;
	LD	A,(IY+30)	;fetch DAM type
	CP	(IX)		;same as last read?
	LD	HL,MSG53	;'address mark error'
	JR	NZ,READ1E	;nope, go error!
;
;	compare data checksum bytes
;
	LD	A,(IY+25)	;get checksum
	CP	(IX+1)		;match?
	JR	Z,READ1F	;yes, everything in order
	JP	FATAL		;fatal error!
;
READ1E	CALL	MOVBUF		;move ver buff to BC buff
	LD	A,(IY+30)	;get DAM
	LD	(IX),A		;save into buffer
	LD	A,(IY+25)	;get checksum
	LD	(IX+1),A	;save into buffer
	DEC	(IY+12)		;less inner loop retry
	JR	NZ,READ1D	;go if more tries
	DEC	(IY+10)		;dec outer loop retry
	JP	NZ,READ1A	;go if more tries
	JP	ABORT		;abort program with error
;
READ1F	CALL	NEXSEC		;advance DE to next sect.
	LD	A,(IY+13)	;inner loop reset
	LD	(IY+12),A	;save it
	INC	B		;bump buffer
	INC	IX		;bump DAM/CKSUM table
	INC	IX		;2 byte entries
	DEC	(IY+31)		;# sectors in buffer
	JR	NZ,READ1D	;go if more to do
	JP	ALVBAK		;restore alive
;
;	write memory buffer to current drive
;
WRITE1	LD	A,(IY+11)	;get outer loop reset
	LD	(IY+10),A	;save it
	LD	A,(IY+13)	;inner loop reset
	LD	(IY+12),A	;init it
;
	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG29A),A	;save drive into text
	LD	HL,MSG29	;'writing'
	CALL	DISPLAY		;display it
;
WRITE1A	LD	DE,(TKOUT)	;get start track/sector
	LD	BC,BUFFER	;start of I/O buffer
	LD	IX,DAMBUFF	;start of DAM/CKSUM's
	LD	A,(IY+29)	;fetch # sectors holding
	LD	(IY+31),A	;save for # to do
	LD	(IY+0),'+'	;setup 'alive'
	LD	(IY+1),' '
;
WRITE1B	LD	(IY+8),D	;save current track
	CALL	WFLICK		;display track/sector
;
	IF	MODI
	LD	A,0A8H		;standard write byte
	ENDIF
;
	IF	MODIII
	LD	A,0A0H		;standard write byte
	ENDIF
;
	OR	(IX)		;combine with DAM type
	LD	(WRTYPE),A	;save write type command
	CALL	WRITE		;write the sector
	JP	NZ,REMWRITE	;remove the drive if err.
;
	INC	IX		;bump DAM pointer
	INC	IX		;by 2 for checksum
	INC	B		;bump buffer pointer
	CALL	NEXSEC		;advance DE to next
	DEC	(IY+31)		;less this sector
	JR	NZ,WRITE1B	;go if more to do
;
	LD	A,(IY+4)	;get 'verify' flag
	CP	'Y'		;verify on?
	JP	NZ,ALVBAK	;restore 'alive'
;
	CALL	DRVASC		;fetch ascii drive #
	LD	(MSG30A),A	;save drive into text
	LD	HL,MSG30	;'verifying'
	CALL	DISPLAY		;display it
;
	LD	DE,(TKOUT)	;get start track/sector
	LD	BC,BUFFER	;start of I/O buffer
	LD	A,(IY+13)	;inner loop reset
	LD	(IY+12),A	;save it
	LD	A,(IY+29)	;get # sectors to check
	LD	(IY+31),A	;save into counter
	LD	IX,DAMBUFF	;start of DAM/CKSUM table
	LD	(IY+0),'='	;'alive' char
	LD	(IY+1),' '
;
WRITE1C LD	(IY+8),D	;save current track
	CALL	VFLICK		;display track/sector
;
	PUSH	BC		;save buff pointer
	LD	BC,VBUFF	;verify I/O buffer
	CALL	READ		;read the sector
	POP	BC		;restore buffer
	JP	NZ,REMREAD	;I/O error, remove drive!
;
	CALL	COMPARE		;compare buffers
	LD	HL,MSG38	;'data mismatch'
	JR	NZ,WRITE1D	;go error
	LD	A,(IY+30)	;get data address mark
	CP	(IX)		;match?
	LD	HL,MSG53	;'address mark error'
	JR	NZ,WRITE1D	;go error if mismatch
	LD	A,(IY+25)	;get checksum byte
	CP	(IX+1)		;checksum match?
	JP	NZ,FATAL	;fatal memory error
	JR	WRITE1E		;go if no error
;
WRITE1D	CALL	REWRITE		;re-write the sector
	DEC	(IY+12)		;less this inner loop try
	JR	NZ,WRITE1C	;attempt re-verify
	DEC	(IY+10)		;less outer loop retry
	JP	NZ,WRITE1A	;go if more tries
	PUSH	HL		;setup stack for error
	JP	REMDRIVE	;remove if from que
;
WRITE1E	INC	B		;bump buffer pointer
	INC	IX		;bump DAM pointer
	INC	IX		;bump CKSUM pointer
	LD	A,(IY+13)	;inner loop reset
	LD	(IY+12),A	;save it
	CALL	NEXSEC		;advance DE to next
	DEC	(IY+31)		;less this sector
	JR	NZ,WRITE1C	;go if more to do
	JP	ALVBAK		;restore 'alive'
;
	PAGE
;
;	advance DE to next sector
;
NEXSEC	LD	A,(IY+19)	;get density
	OR	A		;Z = single den
	LD	A,10		;10 sectors/track
	JR	Z,NEXGOT	;go if single
	LD	A,18		;18 sectors/track DD
;
NEXGOT	INC	E		;bump sector
	SUB	E		;less max sector #
	RET	NZ		;not at track end
	LD	E,A		;reset sector to 0
;
;	advancing to next track
;	check if GAT used to skip empty ones
;
NEXGTK	INC	D		;bump track
	LD	A,(IY+27)	;GAT to skip tracks?
	CP	'Y'		;yes?
	RET	NZ		;nope, do all tracks
	LD	A,D		;get track
	CP	(IY+9)		;test to max tracks
	RET	NC		;beyond disk, return
;
	PUSH	HL		;save HL
	PUSH	BC		;and BC
	LD	HL,GATBUFF	;HL => gat table in ram
	LD	C,D		;track to C
	LD	B,0		;BC = track
	ADD	HL,BC		;HL => current track
	LD	A,(IY+28)	;GAT skip mask
	CP	(HL)		;match?
	POP	BC		;unstack
	POP	HL
	JR	Z,NEXGTK	;advance if nil track
	RET			;else DE at next location
;
	PAGE
;
;	disk drive select service
;
	IF	MODI
SELECT	LD	A,(37ECH)	;read FDC status
	AND	80H		;motor on now?
	LD	A,0		;fetch select code
DRIVE	EQU	$-1
	LD	(37E1H),A	;issue to FDC
	RET	Z		;motor already on, go!
;
;	wait for motor on delay
	PUSH	BC		;save from count
	LD	BC,0		;1 second delay
	CALL	60H		;wait
	POP	BC		;unstack
	LD	A,(37ECH)	;read status again
	AND	80H		;return with bit 7
	RET			;done
	ENDIF
;
	IF	MODIII
SELECT	LD	A,(IY+8)	;get current track
	CP	16H		;need write precomp?
	LD	A,0		;load zero
	JR	C,SELEC		;nope, continue
	LD	A,20H		;precomp bit set
SELEC	LD	(DRIV0),A	;save into mask
;
	IN	A,(0F0H)	;read FDC status
	AND	80H		;motor on now?
;
	PUSH	AF		;save flag
	LD	A,0		;get drive select code
DRIVE	EQU	$-1
	AND	0FH		;low 4 bits only
	OR	0		;merge with pre-comp
DRIV0	EQU	$-1
	OR	(IY+19)		;set bit 7 for density
	LD	(DRIVE),A	;save new byte
	OUT	(0F4H),A	;issue to FDC
	POP	AF		;restore flags
	RET	Z		;return if motor was on
;
;	issue motor on delay
;
	PUSH	BC		;save BC
	LD	BC,0		;1 second
	CALL	60H		;wait
	POP	BC		;unstack
	IN	A,(0F0H)	;read status again
	AND	80H		;check bit 7
	RET			;return with status
	ENDIF
;
;	setup drive for I/O activity
;
SETDRV	PUSH	BC		;save it
	AND	3		;0-3 only
	PUSH	AF		;save binary drive
	LD	(DRV),A		;binary drive here
	LD	C,1		;start mask bit 0
	JR	Z,SETDN		;go if yes
SETDLP	SLA	C		;align mask bit
	DEC	A		;less this pass
	JR	NZ,SETDLP	;go if not found
;
SETDN	LD	A,C		;fetch select mask
	LD	(DRIVE),A	;save for actual select
	POP	AF		;restore binary drive
	ADD	A,'0'		;make it ascii
	POP	BC		;unstack
	RET			;return with ascii
;
;	sector checksum found in error
;	abort program to entry and retest memory
;
FATAL	LD	HL,MSG39	;'system memory error'
	CALL	DISPLAY		;display it
	LD	(IY+20),-1	;set non-initialized
	LD	B,1		;1 key input
	CALL	GETSTR		;get key input
	JP	ENTRY		;restart program!
;
;	point to current drive byte
;
POINT	LD	A,(IY+7)	;fetch current drive
	ADD	A,L		;offset to table
	LD	L,A		;put it back
	JR	NC,POINT1	;go if no page cross
	INC	H		;bump page
POINT1	LD	A,(HL)		;fetch byte
	RET			;return with it
;
;	check for mounted dest drives
;
CHECKER	CALL	STAT		;check status
	RET	Z		;return if mounted
	LD	HL,XDRIVES	;point to lockout table
	CALL	POINT		;point to the byte
	LD	(HL),80H	;set as unavailable
	RET			;done!
;
