;ldcopy1/asm - kjw/bqsd - revised 12/82
;
	PAGE
;
	SUBTTL	'<LDCOPY1/ASM - Parameter Evaluation>'
;
;	program entry point
;
ENTRY	DI			;disable a split sec
	LD	IY,TABLE	;init table pointer
	LD	(IY+20),-1	;set data not initialized
	LD	HL,TASK		;interrupt processor
	LD	(4013H),HL	;save into ROM vector
	LD	A,0C3H		;JP opcode
	LD	(4012H),A	;rest of vector
	LD	SP,STAK		;reset stack
	LD	HL,ENTRY	;put on stack
	PUSH	HL		;put it there
;
;	port init mod I
;
	IF	MODI
	XOR	A		;load zero
	LD	(37E4H),A	;reset cassette
	LD	A,0D0H		;FDC interrupt code
	LD	(37ECH),A	;clear FDC
	LD	A,(37E0H)	;clear interrupt latch
	ENDIF
;
;	port init mod III
;
	IF	MODIII
	XOR	A		;load zero
	OUT	(0E4H),A	;disable NMI
	LD	A,28H		;enable video waits
	OUT	(0ECH),A
	LD	A,4		;enable RTC interrupts
	OUT	(0E0H),A
	LD	A,0D0H		;FDC reset code
	OUT	(0F0H),A	;reset FDC
	LD	A,0C3H		;JP opcode
	LD	(4049H),A	;to hard NMI vector
	LD	HL,RETNMI	;non-disk vector
	LD	(404AH),HL	;save rest of vector
	IN	A,(0ECH)	;clear interrupt latch
	ENDIF
;
;	reset keyboard and display DCB address back
;	into ROM in case this program was loaded from
;	a system that intercepted the drivers
;
	IF	MODI
	LD	HL,03E3H
	LD	(4016H),HL
	LD	HL,0458H
	LD	(401EH),HL
	ENDIF
;
	IF	MODIII
	LD	HL,3024H
	LD	(4016H),HL
	LD	HL,0473H
	LD	(401EH),HL
	ENDIF
;
;	program entry point, and BREAK key vector
;
START	LD	SP,STAK		;reset stack
	EI			;enable interrupts
	CALL	DRAIN		;clear pending keys
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;display it
	LD	IY,TABLE	;reset data block pointer
	LD	(IY+20),-1	;set system not init'ed
	LD	HL,MSG36	;'testing memory'
	CALL	DISPLAY		;display it
	LD	(IY+0),'*'	;testing memory
	LD	(IY+1),'#'	;set 'alive' chars
	CALL	TESTMEM		;test buffer RAM
;
;	fetch # copies requested
;
BAD1	LD	HL,MSG4		;'# copies ?'
	CALL	DISPLAY		;display it
	LD	B,5		;5 char input
	CALL	GETSTR		;get from keyboard
	LD	BC,100		;default value
	JR	Z,BAD1A		;go if nil input
	CALL	VALUE		;fetch numeric value
	JR	C,BAD1		;invalid, ask again
;
BAD1A	LD	(COPIES),BC	;save # copies requested
;
;	check if 'verify' feature is to be on
;
BAD2	LD	HL,MSG5		;'verify ?'
	CALL	DISPLAY		;display it
	LD	B,1		;1 char key input
	CALL	GETSTR		;fetch from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD2A		;go if nil input
	LD	A,(HL)		;fetch first input char
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD2A		;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD2		;neither, ask again
BAD2A	LD	(IY+4),A	;save flag into table
;
;	fetch drive step rate
;
BAD3	LD	HL,MSG49	;'step rate ?'
	CALL	DISPLAY		;display it
	LD	B,1		;1 char input
	CALL	GETSTR		;fetch from keyboard
	LD	A,'0'		;default value
	JR	Z,BAD3A		;go if nil input
	LD	A,(HL)		;else fetch input char
;
BAD3A	SUB	'0'		;remove ascii
	JR	C,BAD3		;go if invalid input
	CP	4		;0-3?
	JR	NC,BAD3		;nope, try again
	LD	(IY+22),A	;save step rate 0-3
;
;	fetch diskette density
;
BAD4	LD	HL,MSG44	;'density ?'
	CALL	DISPLAY		;display prompt
;
;	setup defaults for Mod I and III
;
	IF	MODI
	LD	(IY+19),0	;set single density
	ENDIF
;
	IF	MODIII
	LD	(IY+19),80H	;set double density
	ENDIF
;
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD4A		;go if nil input
	LD	A,(HL)		;fetch input character
	CALL	UCASE		;make it upper case
	LD	(IY+19),80H	;set double density
	CP	'D'		;double?
	JR	Z,BAD4A		;yes, go!
	CP	'S'		;single?
	JR	NZ,BAD4		;neither, ask again
	LD	(IY+19),0	;set single density
BAD4A
;
;	select correct controller chip mod I
;
	IF	MODI
	LD	A,(IY+19)	;get density
	OR	A		;single?
	LD	A,-1		;load double den select
	JR	NZ,BAD4B	;go if not single
	DEC	A		;load single den select
BAD4B	LD	(37ECH),A	;give to FDC
	LD	A,0D0H		;interrupt command
	LD	(37ECH),A	;reset FDC
	ENDIF
;
;	fetch track count
;
BAD5	LD	HL,'53'		;35 tracks in ascii
	LD	A,35		;set 35
	BIT	7,(IY+19)	;check density
	JR	Z,BAD5A		;go if single
	LD	HL,'04'		;40 tracks ascii
	LD	A,40		;set 40 tracks
BAD5A	LD	(MSG46A),HL	;to the string
	LD	(IY+9),A	;save track count
;
	LD	HL,MSG46	;prompt text
	CALL	DISPLAY		;display prompt
	LD	B,3		;3 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD6		;go if nil input
	CALL	VALUE		;fetch input value
	JR	C,BAD5		;invalid, ask again
BAD5B	LD	(IY+9),C	;insert value
;
;	see if GAT to be used to skip tracks
;
BAD6	LD	HL,MSG2		;'use GAT to skip ?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default
	JR	Z,BAD6A		;nil input, go!
	LD	A,(HL)		;fetch first char
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD6A		;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD6		;neither, ask again
BAD6A	LD	(IY+27),A	;save input response
	CP	'Y'		;is GAT skip on?
	JR	NZ,BAD8		;nope, continue
;
;	GAT skip is ON, fetch mask byte to use
;
BAD7	LD	A,(IY+19)	;get density
	OR	A		;single?
	LD	HL,'CF'		;FCH single den
	LD	A,0FCH		;set mask
	JR	Z,BAD7A		;go if single
	LD	H,'8'		;F8H double den
	LD	A,0F8H		;set mask
BAD7A	LD	(IY+28),A	;save default
	LD	(MSG3A),HL	;save default into prompt
	LD	HL,MSG3		;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;fetch from keyboard
	JR	Z,BAD8		;nil input, default set
	CALL	HEXVAL		;get hex value from input
	JR	C,BAD7		;invalid, ask again
	LD	(IY+28),C	;save mask byte into data
;
;	fetch media tolerance factor
;
BAD8	LD	HL,MSG52	;prompt text
	CALL	DISPLAY		;display it
	LD	B,1		;one char
	CALL	GETSTR		;from keyboard
	LD	A,1		;default value
	JR	Z,BAD8A		;go if nil input
	LD	A,(HL)		;get input char
	SUB	'0'		;remove ascii
	JR	C,BAD8		;go if invalid input
	CP	4		;0-3?
	JR	NC,BAD8		;nope, ask again
;
BAD8A	INC	A		;bump it to 1-4
	LD	(IY+13),A	;save inner retry reset
	LD	(IY+11),A	;save outer retry reset
;
;	fetch source drive
;
BAD9	LD	HL,DRIVES	;drive table
	LD	B,4		;length
	LD	A,-1		;active flag
	CALL	FILL		;set all drives active
;
	LD	HL,MSG6		;'source drive ?'
	CALL	DISPLAY		;display it
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	LD	A,0		;default drive
	JR	Z,BAD9A		;go if nil input
	LD	A,(HL)		;else get input char
	SUB	'0'		;remove the ascii
	JR	C,BAD9		;go if invalid
	CP	4		;0-3?
	JR	NC,BAD9		;go if out of range
BAD9A	LD	(IY+5),A	;save source drive
	LD	HL,DRIVES	;start of table
	LD	(IY+7),A	;update drive #
	CALL	POINT		;point to byte
	LD	(HL),0		;set as inactive
;
;	check if serial numbering to be used
;
BAD12	LD	HL,MSG47	;'serial numbering ?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD12A	;go if nil
	CALL	UCASE		;make upper case
	CP	'Y'		;yes?
	JR	Z,BAD12B	;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD12	;neither, ask again
BAD12A	LD	A,'*'		;load OFF setting
BAD12B	LD	(IY+6),A	;save flag in table
	CP	'*'		;no serial numbers?
	JP	Z,BAD16		;go next prompt
;
;	fetch serial number location
;
BAD13	LD	HL,MSG48	;'serial # location ?'
	CALL	DISPLAY		;display prompt
	LD	B,32		;32 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD13		;no defaults here
;
	CALL	VALUE		;fetch track
	JR	C,BAD13		;invalid, ask again
	LD	(IY+16),C	;save track
;
	CALL	VALUE		;fetch sector
	JR	C,BAD13		;invalid, ask again
	LD	(IY+17),C	;save sector
;
	CALL	VALUE		;fetch byte offset
	JR	C,BAD13		;invalid, ask again
	LD	(IY+18),C	;save byte offset
;
	CALL	VALUE		;fetch length
	JR	C,BAD13		;invalid, ask again
	LD	A,C		;get length
	CP	33		;must be 1-32
	JR	NC,BAD13	;oversize, ask again
	LD	(IY+21),A	;save length
;
;	check if serial # is in AUTO mode or if
;	numbers are to be input for each drive
;
BAD14	LD	HL,MSG40	;'auto serial # ?'
	CALL	DISPLAY		;display it
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default yes
	JR	Z,BAD14A	;go if nil input
	LD	A,(HL)		;else fetch input char
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD14A	;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD14	;neither, ask again
BAD14A	LD	(IY+6),A	;save Y/N flag
	CP	'N'		;no auto?
	JR	Z,BAD16		;nope, go!
;
;	auto serial #, fetch starting number
;
BAD15	LD	HL,MSG41	;'start serial # ?'
	CALL	DISPLAY		;display prompt
	LD	B,(IY+21)	;get length serial #
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD15		;no default!
	LD	A,B		;get length of actual in
	CP	(IY+21)		;right length input?
	JR	NZ,BAD15	;nope, ask again
;
;	save serial # for incrementor
;
	LD	DE,SERX		;serial # saver
	LD	C,B		;pass length
	LD	B,0		;BC = length
	LDIR			;move into storage
;
;	check if drives are to be formatted
;
BAD16	LD	HL,MSG50	;'format drives ?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default
	JR	Z,BAD16A	;go if nil input
	LD	A,(HL)		;else fetch input char
BAD16A	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,-1		;true flag
	JR	Z,BAD16B	;yes, go!
	INC	B		;false flag
	CP	'N'		;no?
	JR	NZ,BAD16	;neither, ask again
BAD16B	LD	(IY+23),B	;put flag into table
;
;	check if data to be transferred
;
BAD17	LD	HL,MSG51	;'transfer data ?'
	CALL	DISPLAY		;display prompt
	LD	B,1		;1 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD17A	;go if nil input
	LD	A,(HL)		;else fetch first char
BAD17A	CALL	UCASE		;make upper case
	CP	'Y'		;yes?
	LD	B,-1		;true flag
	JR	Z,BAD17B	;go if yes
	INC	B		;false flag
	CP	'N'		;no?
	JR	NZ,BAD17	;neither, ask again
BAD17B	LD	(IY+24),B	;save flag in table
;
;	all input prompt satisfied, begin copy
;
	LD	HL,0		;load zero
	LD	(COUNT),HL	;# copies completed
	LD	(IY+20),0	;clear init flag
	JP	LOOPER		;go copy!
;
;	fetch hex value from string
;
HEXVAL	LD	C,0		;start value
;
HEXLP	LD	A,(HL)		;fetch string char
	CP	CR		;terminator?
	RET	Z		;yes, done!
	CALL	UCASE		;make upper case
	CALL	MAKHEX		;convert to binary
	RET	C		;invalid, return
	LD	B,A		;save char
	LD	A,C		;get current subtotal
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	ADD	A,B		;add new digit
	LD	C,A		;resave value
	INC	HL		;bump pointer
	JR	HEXLP		;continue
;
MAKHEX	SUB	'0'		;remove ascii
	RET	C		;invalid, return
	CP	10		;0-9?
	CCF			;reverse carry flag
	RET	NC		;return with no error
	SUB	7		;adjust for A-F
	RET	C		;invalid, return
	CP	16		;0-15?
	CCF			;reverse carry flag
	RET			;return
;
RETNMI	RETN			;no-disk NMI Mod III
;
;	drain all pending keys from keyboard
;
DRAIN	CALL	002BH		;read keyboard
	OR	A		;anything?
	JR	NZ,DRAIN	;read again if yes
	RET			;else done!
;
