S1/ASM 	ORG	4E00H
 ;S1/ASM
 DOS	EQU	402DH
 CURSOR	EQU	4020H
 VIDOUT	EQU	33H
 LINEOUT	EQU	21BH
 NONDOS	EQU	4030H
 STACK	EQU	409FH
 BUFFER	EQU	5200H
 FIND1	EQU	4204H
 FIND2	EQU	4214H
 KEYBUF	EQU	4225H
 FIND5	EQU	427AH
 FIND6	EQU	42AEH
 FIND7	EQU	42B4H
 FIND8	EQU	42FFH
 ERROR	EQU	4409H
 FIND9	EQU	4411H
 LOADGO	EQU	4433H
 DOSDCB	EQU	4465H
 START	AND	0F0H
 	CP	90H
 	JP	Z,402DH
 	CP	0A0H
 	JP	Z,ABORT
 	CP	0B0H
 	JP	Z,CMDRET
 	CP	0C0H
 	JP	Z,MOVEFCB
 	CP	0D0H
 	JP	Z,ADDEXT
 	CP	0F0H
 	JP	Z,COMMAND
 ABORT	LD	HL,ABORTED	;"operation aborted"
 	CALL	LINEOUT		;to the video
 	JP	402DH
 CMDRET	LD	BC,DOS		;402DH return address
 	PUSH	BC		;to the top of the stack
 COMMAND	LD	DE,DOSDCB	;DOS FCB area
 	CALL	POSHL
 	JP	C,402DH
 	CALL	MOVEFCB		;move input to DOS area
 	JR	NZ,BADNAME	;nz = invalid file name
 	PUSH	HL		;save the pointer
 	LD	BC,LIBRARY	;library command table
 	CALL	WHTABLE		;is the command there ?
 	JR	Z,GOLIB		;Z = found
 	LD	HL,CMD		;else add default ext.
 	CALL	ADDEXT		;add it
 	POP	HL		;restore data pointer
 	JP	LOADGO		;load and execute file
 GOLIB	POP	HL		;restore input pointer
 	PUSH	DE		;jump address to stack
 	RET			;go there
 BADNAME	LD	A,13H		;bad filename error
 	JP	ERROR		;display error
 MOVEFCB	PUSH	DE		;save pointer
 	LD	B,08H		;8 char allowed
 	CALL	MOVE		;move 'em
 	JR	NZ,BADRET	;nz=bad
 	CP	'/'		;extension ?
 	JR	NZ,CHKPASS	;skip if not
 	LD	(DE),A		;put in FCB
 	INC	DE		;bump pointer
 	LD	B,03H		;move 3 more chars
 	CALL	MOVE		;do it
 	JR	NZ,BADRET	;nz = bad
 CHKPASS	CP	'.'		;password ?
 	JR	NZ,CHKDRV	;skip if not
 	LD	(DE),A		;else put that in FCB
 	INC	DE		;bump pointer
 	LD	B,08H		;move 8 bytes in
 	CALL	MOVE		;do it
 	JR	NZ,BADRET	;hit a terminator
 CHKDRV	CP	':'		;drive specified ?
 	JR	NZ,CHKDEN	;skip if not
 	LD	(DE),A		;put that there too
 	INC	DE
 	LD	B,1		;one char drive
 	CALL	MOVE
 	JR	NZ,BADRET
 CHKDEN	CP	'#'
 	JR	NZ,FINISH
 	LD	(DE),A
 	INC	DE
 	LD	B,01H
 	CALL	MOVE
 	JR	NZ,BADRET
 FINISH	LD	C,A
 	LD	A,03H
 	LD	(DE),A
 	XOR	A
 	LD	A,C
 	POP	DE
 	PUSH	DE
 	LD	BC,TO
 	CALL	WHTABLE
 	POP	DE
 	JR	Z,MOVEFCB
 	XOR	A
 	RET
 BADRET	POP	DE
 	RET
 TO	DB	'To    ',0,0,0
 ADDEXT	PUSH	DE		;save FCB
 	PUSH	HL		;save default bytes
 	EX	DE,HL		;DE=> default bytes
 	INC	HL		;FCB + 1
 	LD	B,09H		;go for 9 more bytes
 LOOP5	LD	A,(HL)		;get byte from string
 	CP	'/'		;extension specified?
 	JR	Z,HAVEXT	;don't add one if yes
 	JR	C,B4DRIVE	;put ext. before drive
 	CP	':'		;drive specified?
 	JR	C,SKIP1		;skip password
 	CP	'A'		;can't be a number
 	JR	C,B4DRIVE	;it is if less than "A"
 SKIP1	INC	HL		;bump string pointer
 	DJNZ	LOOP5		;continue some more
 HAVEXT	POP	HL		;restore hl & de
 	POP	DE
 	RET			;done
 B4DRIVE	LD	BC,0FH		;point to end of FCB name
 	ADD	HL,BC		;look at it
 	LD	D,H		;give it to DE
 	LD	E,L
 	INC	DE		;make a gap for the ext
 	INC	DE
 	INC	DE
 	INC	DE
 	INC	BC		;bump count
 	LDDR			;move backwards
 	POP	HL		;restore extension
 	INC	HL		;look at last byte
 	INC	HL
 	LD	C,3		;move 3 bytes
 	LDDR			;move the ext. in
 	LD	A,'/'		;put the slash there
 	LD	(DE),A		;into the FCB
 	POP	DE		;restore FDC pointer
 	RET			;done
 MOVE	LD	A,B		;get # bytes to move
 	LD	(FLAG1),A	;save to return with it
 	INC	B		;bump length to move
 LOOP4	LD	A,(HL)		;get byte from string
 	CALL	IFTERM
 	JR	Z,MOVTERM
 	INC	HL		;bump string pointer
 	CALL	ALPNUM		;is char. alpha/numeric?
 	JR	C,MOVTERM	;C = bad
 	DEC	B		;count less 1
 	JR	Z,MOVEND	;moved 'em all
 	LD	(DE),A		;else put in FCB
 	XOR	A		;set no terminator
 	LD	(FLAG1),A	;save to return with
 	INC	DE		;bump FCB pointer
 	JR	LOOP4		;continue through
 MOVEND	INC	B		;make it nz again
 	JR	LOOP4		;continue with more
 MOVTERM	LD	C,A		;flag byte
 	LD	A,3		;terminator byte
 	LD	(DE),A		;put in the FCB
 	LD	A,0		;return with flag
 FLAG1	EQU	$-1
 	OR	A		;set the flag regs.
 	LD	A,C		;restore A byte
 	RET			;done
 WHTABLE	PUSH	HL		;save string pointer
 	LD	H,B		;bc=>hl (table pointer)
 	LD	L,C
 	LD	C,1		;position counter
 LOOP2	LD	A,(DE)		;get byte from DCB
 	AND	5FH
 	CP	(HL)		;same as table ?
 	JR	Z,CHECK5	;yes, check the rest
 LOOP3	PUSH	BC		;save counter
 	LD	BC,8		;8 bytes per entry
 	ADD	HL,BC		;point to next one
 	POP	BC		;restore counter
 	INC	C		;bump it one
 	LD	A,(HL)		;get next byte
 	OR	A		;set flags
 	JR	NZ,LOOP2	;z=terminator
 	POP	HL		;restore string pointer
 	OR	1		;set nz flag
 	RET			;return - not found
 CHECK5	LD	B,5		;go for 56 more bytes
 	PUSH	HL		;save pointers
 	PUSH	DE
 LOOP6	INC	DE		;bump 'em
 	INC	HL
 	LD	A,(DE)
 	CALL	IFTERM
 	JR	Z,Z4FD6
 	CALL	MAKELO		;make it lower case
 	CP	(HL)		;same as table ?
 	JR	NZ,Z4FD1	;skip that one
 	DJNZ	LOOP6		;finish the last 5
 Z4FC3	POP	DE		;restore DCB pointer
 	LD	A,C		;get position counter
 	POP	BC		;beginning of word
 	LD	HL,6		;6 letters / word
 	ADD	HL,BC		;point to end of word
 	LD	C,A		;restore position
 	LD	E,(HL)		;lsb to E
 	INC	HL
 	LD	D,(HL)		;msb to D
 	POP	HL		;restore string pointer
 	XOR	A		;set Z flag for found
 	RET			;done, address in DE
 Z4FD1	CALL	ALPNUM
 	JR	NC,Z4FDB
 Z4FD6	LD	A,(HL)
 	CP	20H
 	JR	Z,Z4FC3
 	CP	','
 	JR	Z,Z4FC3
 Z4FDB	POP	DE
 	POP	HL
 	JR	LOOP3
 CMD	DB	'CMD'
 TRSDOS	DB	10,'KimDOS Ready',13
 ABORTED	DB	'Operation Terminated',13
 ALPNUM	CP	'0'
 	RET	C
 	CP	':'
 	CCF
 	RET	NC
 	CP	3CH
 	RET	C
 	CP	7BH
 	CCF
 	RET
 MAKELO	CP	61H
 	RET	NC
 	ADD	A,20H
 	RET
 IFTERM	CP	';'
 	RET	Z
 	CP	3
 	RET	Z
 	CP	13
 	RET
 LIBRARY	DB	'Alloc '
 	DW	G88
 	DB	'Append'
 	DW	G86
 	DB	'Attrib'
 	DW	G86
 	DB	'Auto  '
 	DW	G86
 	DB	'Backup'
 	DW	G97
 	DB	'Boot  '
 	DW	BOOT
 	DB	'Build '
 	DW	G86
 	DB	'Check '
 	DW	G88
 	DB	'Clear '
 	DW	G86
 	DB	'Clock '
 	DW	G86
 	DB	'Cls   '
 	DW	1C9H
 	DB	'Config'
 	DW	G88
 	DB	'Copy  '
 	DW	G99
 	DB	'Create'
 	DW	G86
 	DB	'Date  '
 	DW	G86
 	DB	'Dead  '
 	DW	G88
 	DB	'Debug '
 	DW	440DH
 	DB	'Device'
 	DW	G88
 	DB	'Dir   '
 	DW	G86
 	DB	'Do    '
 	DW	G86
 	DB	'Dual  '
 	DW	G99
 	DB	'Dump  '
 	DW	G86
 	DB	'Format'
 	DW	GA7
 	DB	'Forms '
 	DW	G99
 	DB	'Free  '
 	DW	G86
 	DB	'In    '
 	DW	G88
 	DB	'Kill  '
 	DW	G99
 	DB	'Lib   '
 	DW	LIB
 	DB	'Link  '
 	DW	G88
 	DB	'List  '
 	DW	G9B
 	DB	'Load  '
 	DW	G86
 	DB	'Map   '
 	DW	G88
 	DB	'Master'
 	DW	G99
 	DB	'Out   '
 	DW	G88
 	DB	'Patch '
 	DW	G99
 	DB	'Pause '
 	DW	G86
 	DB	'Peek  '
 	DW	G88
 	DB	'Poke  '
 	DW	G88
 	DB	'Print '
 	DW	G88
 	DB	'Prot  '
 	DW	G86
 	DB	'Purge '
 	DW	G9B
 	DB	'Relo  '
 	DW	G99
 	DB	'Rename'
 	DW	G86
 	DB	'Reorg '
 	DW	G88
 	DB	'Recov '
 	DW	G88
 	DB	'Reset '
 	DW	G88
 	DB	'Route '
 	DW	G99
 	DB	'Run   '
 	DW	G88
 	DB	'Set   '
 	DW	G99
 	DB	'System'
 	DW	G88
 	DB	'Tape  '
 	DW	G9B
 	DB	'Term  '
 	DW	G88
 	DB	'Test  '
 	DW	G88
 	DB	'Time  '
 	DW	G86
 	DB	'Topmem'
 	DW	G88
 	DB	'Verify'
 	DW	G88
 	DB	'Who   '
 	DW	KIMHERE
 	DB	'Wp    '
 	DW	G99
 	DB	0
 G86	LD	A,86H
 	RST	28H
 G99	LD	A,99H
 	RST	28H
 G9B	LD	A,9BH
 	RST	28H
 G88	LD	A,88H
 	RST	28H
 G97	LD	A,97H
 	RST	28H
 GA7	LD	A,0A7H
 	RST	28H
 BOOT	HALT
 	JP	0
 KIMHERE	LD	HL,ME
 	JP	21BH
 ME	DB	'by Kim Watt - (C) 1981 Breeze Computing Inc.'
 	DB	13
 LIB	LD	HL,LIBRARY
 LLOOP1	LD	C,6
 LLOOP2	LD	A,(HL)
 	OR	A
 	JR	Z,LIBDONE
 	PUSH	HL
 	LD	B,6
 LLOOP3	LD	A,(HL)
 	CALL	33H
 	INC	HL
 	DJNZ	LLOOP3
 	LD	B,4
 LLOOP4	LD	A,20H
 	CALL	33H
 	DJNZ	LLOOP4
 	POP	HL
 	LD	DE,8
 	ADD	HL,DE
 	DEC	C
 	JR	NZ,LLOOP2
 	LD	A,10
 	CALL	33H
 	JR	LLOOP1
 LIBDONE	LD	A,(4020H)
 	AND	3FH
 	RET	Z
 	LD	A,10
 	JP	33H
 POSHL	LD	A,(HL)
 	INC	HL
 	CP	20H
 	JR	Z,POSHL
 	CP	','
 	JR	Z,POSHL
 	CP	14
 	DEC	HL
 	RET
 	END	4E00H
