
SA80IO/09391 ;% I/O ROUTINES    FILENAME: A80IO/ASM
09400 WDISK:    XOR     A       ;Write to disk routine
09410   LD      (HASEXT),A
09420   CALL    ERFX
09430 WMSG:     LD      DE,FMSG1        ;Print message
09440   LD      HL,3F50H
09450   LD      BC,15
09460   CALL    PRINT   ;print routine
09470   LD      HL,3F5FH
09480   LD      IX,4020H        ;CURSOR LOC
09490   LD      (IX),L
09500   LD      (IX+1),H
09510   LD      HL,DCB          ;CLEAR DCB
09520   LD      DE,DCB+1
09530   LD      BC,32
09540   LD      A,20H
09550   LD      (HL),A
09560   LDIR
09570   LD      HL,DCB          ;GET FILESPEC
09580   LD      B,24
09590   CALL    0040H
09600   CALL    CFSPC
09610   LD      HL,BUFFER       ;OPEN FILE
09620   LD      DE,DCB
09630   LD      B,0
09640   CALL    4420H
09650   JR      Z,WRT1
09660   JP      ERROR
09670 WRT1:     LD      HL,PSCR
09680   LD      DE,BUFFER
09690   LD      BC,256
09700   LDIR
09710   LD      DE,DCB
09720   CALL    443CH
09730   JR      Z,WRT2
09740   JP      ERROR
09750 WRT2:     LD      BC,256
09760   LD      DE,BUFFER
09770   LDIR
09780   LD      DE,DCB
09790   CALL    443CH
09800   JR      Z,WRT3
09810   JP      ERROR
09820 WRT3:     LD      BC,256
09830   LD      DE,BUFFER
09840   LDIR
09850   LD      DE,DCB
09860   CALL    443CH
09870   JR      Z,WRT4
09880   JP      ERROR
09890 WRT4:     LD      BC,256
09900   LD      DE,BUFFER
09910   LDIR
09920   DEC     DE      ;PUT NO. OF CHRS IN FILE
09930   PUSH    DE
09940   POP     IX
09950   LD      A,(CCHR)
09960   LD      (IX),A
09970   LD      DE,DCB
09980   CALL    443CH
09990   JR      Z,WRT5
10000   JP      ERROR
10010 WRT5:     LD      DE,DCB  ;CLOSE FILE
10020   CALL    4428H
10030   JP      Z,SHOW
10040   JP      ERROR
10050 ;` End Disk write routine
10060 GDISK:    EQU     $
10070   XOR     A
10080   LD      (HASEXT),A
10090   CALL    CLS
10100   LD      DE,FMSG2
10110   LD      HL,3C44H
10120   LD      BC,15
10130   CALL    PRINT
10140   LD      HL,3C53H        ;CURSOR LOC
10150   LD      IX,4020H
10160   LD      (IX),L
10170   LD      (IX+1),H
10180   LD      HL,DCB          ;CLEAR DCB
10190   LD      DE,DCB+1
10200   LD      BC,32
10210   LD      A,20H
10220   LD      (HL),A
10230   LDIR
10240   LD      HL,DCB
10250   LD      B,24
10260   CALL    0040H   ;GET FILESPEC
10270   CALL    CFSPC
10280   LD      HL,BUFFER       ;OPEN FILE TO READ
10290   LD      DE,DCB
10300   LD      B,0
10310   CALL    4424H
10320   JR      Z,GT1
10330   JP      NFERR
10340 GT1:      LD      DE,DCB  
10350   CALL    4436H
10360   JR      Z,GT2
10370   JP      ERROR
10380 GT2:      LD      IX,BUFFER
10390   LD      A,(IX)
10400   CP      80H
10410   JP      C,BDTA
10420   LD      A,(IX+14)
10430   CP      80H
10440   JP      NZ,BDTA
10450   LD      HL,BUFFER
10460   LD      DE,PSCR
10470   LD      BC,256
10480   LDIR
10490   PUSH    DE
10500   LD      DE,DCB
10510   CALL    4436H
10520   JR      Z,GT3
10530   POP     DE
10540   JP      ERROR
10550 GT3:      POP     DE
10560   LD      HL,BUFFER
10570   LD      BC,256
10580   LDIR
10590   PUSH    DE
10600   LD      DE,DCB
10610   CALL    4436H
10620   JR      Z,GT4
10630   POP     DE
10640   JP      ERROR
10650 GT4:      POP     DE
10660   LD      HL,BUFFER
10670   LD      BC,256
10680   LDIR
10690   PUSH    DE
10700   LD      DE,DCB
10710   CALL    4436H
10720   JR      Z,GT5
10730   POP     DE
10740   JP      ERROR
10750 GT5:      POP     DE
10760   LD      HL,BUFFER
10770   LD      BC,256
10780   LDIR
10790   LD      DE,DCB          ;CLOSE FILE
10800   CALL    4428H
10810   JR      Z,GOTEM
10820   JP      ERROR
10830 GOTEM:    DEC     HL
10840   LD      A,(HL)
10850   CP      1
10860   JP      C,BDTA
10870   CP      65
10880   JP      NC,BDTA
10890 GTM1:     CALL    FRAME2
10900   CALL    TOBIG
10910   JP      NEWPIC
10930 BDTA:     CALL    CLS
10940   LD      DE,BDMSG
10950   LD      HL,3D40H
10960   LD      BC,BDLEN
10970   CALL    PRINT
10980   CALL    0049H
10990   JP      FRAME
11000 EXIT:     EQU     $
11010   CALL    002BH
11020   CP      0DH
11030   JP      Z,GTM1
11040   JR      EXIT
11050 BFSPC:    POP     DE      ;RESTORE STACK
11060   LD      DE,BMSG
11070   LD      HL,3F4CH
11080   LD      BC,40
11090   CALL    PRINT
11100   CALL    0049H
11110   JP      SHOW
11120 CFSPC:    LD      HL,DCB
11130   LD      DE,TEMP
11140   LD      BC,30
11150   LDIR
11160   LD      IX,DCB
11170   LD      C,30
11180   LD      A,(IX)
11190   CP      41H
11200   JP      C,BFSPC
11210   CP      5BH
11220   JP      NC,BFSPC
11230 TNXT:     INC     IX
11240   DEC     C
11250   RET Z
11260   LD      A,(IX)
11270   CP      '/'
11280   CALL    Z,FLGEXT
11290   CP      20H
11300   CALL    Z,PUTEXT
11310   CP      0DH
11320   JP      Z,PUTEXT
11330   CP      2EH
11340   JP      C,BFSPC
11350   CP      3AH
11360   JR      C,TNXT
11370   JR      Z,CNUM
11380   CP      41H
11390   JP      C,BFSPC
11400   CP      5BH
11410   JP      NC,BFSPC
11420   JR      TNXT
11430 PUTEXT:   LD      A,(HASEXT)
11440   OR      A
11450   RET     NZ
11460   PUSH    BC
11470   LD      DE,32
11480   PUSH    IX
11490   POP     HL
11500   ADD     HL,DE
11510   PUSH    HL
11520   PUSH    IX
11530   POP     DE
11540   LD      HL,EXTXT
11550   LD      BC,3
11560   LDIR
11570   PUSH    DE
11580   POP     IX
11590   LD      HL,TEMP
11600   SBC     HL,DE
11610   PUSH    HL
11620   POP     BC
11630   POP     HL
11640   LDIR
11650   POP     BC
11660   LD      A,C
11670   SUB     3
11680   LD      C,A
11690 FLGEXT:   LD      A,0DH
11700   LD      (HASEXT),A
11710   RET
11720 CNUM:     INC     IX
11730   LD      A,(IX)
11740   CP      33H
11750   JP      NC,BFSPC
11760   CP      30H
11770   JP      C,BFSPC
11780   PUSH    AF
11790   DEC     IX
11800   CALL    PUTEXT
11810   LD      A,':'
11820   LD      (IX),A
11830   INC     IX
11840   POP     AF
11850   LD      (IX),A
11860   INC     IX
11870   LD      A,0DH
11880   LD      (IX),A
11890   RET
11900 ERROR:    CALL    CLS
11910   LD      DE,ERMSG
11920   LD      HL,3D80H
11930   LD      BC,40
11940   CALL    PRINT
11950   LD      DE,DCB  ;CLOSE FILE
11960   CALL    4428H
11970   CALL    0049H
11980   CALL    MVBACK
11990   JP      KEYIN
12000 NFERR:    CALL    CLS
12010   LD      DE,NERMS
12020   LD      HL,3D80H
12030   LD      BC,40
12040   CALL    PRINT
12050   CALL    0049H
12060   CALL    MVBACK
12070   JP      KEYIN
12080 ;`        END DISK I/O
12090 WTAPE:    LD      A,(CCHR)
12100   CP      1
12110   JP      Z,FRAME
12120   CALL    ERFX
12130   CALL    01C9H
12140   LD      DE,FTMSG2
12150   LD      HL,3C44H
12160   LD      BC,14
12170   CALL    PRINT
12180   LD      HL,3C53H
12190   LD      IX,4020H        ;CURSOR LOC
12200   LD      (IX),L
12210   LD      (IX+1),H
12220   CALL    002BH
12230   DI
12240   LD      A,0     ;SELECT DRIVE 0
12250   CALL    0212H
12260   CALL    0287H   ;WRITE LEATER & SYNC BYTE
12270   LD      HL,PSCR
12280   LD      BC,1024
12290 WTNEXT:   LD      A,(HL)
12300   CALL    0264H   ;WRITE BYTE TO TAPE
12310   DEC     BC
12320   LD      A,C
12330   OR      B
12340   JR      Z,WTROFF
12350   INC     HL
12360   JR      WTNEXT
12370 WTROFF:   LD      A,(CCHR)
12380   DEC     A
12390   CALL    0264H   ;WRITE CURRENT CHR #
12400   CALL    01F8H   ;TURN OFF CASSETTE
12410   EI
12420   JP      SHOW    ;EXIT WRITE TAPE
12430 GTAPE:    CALL    TOBIG
12440   CALL    01C9H
12450   LD      DE,FTMSG2
12460   LD      HL,3C44H
12470   LD      BC,14
12480   CALL    PRINT
12490   DI
12500   LD      HL,3C53H        ;CURSOR LOC
12510   LD      IX,4020H
12520   LD      (IX),L
12530   LD      (IX+1),H
12540   CALL    0040H   ;Ready Cas msg
12550   LD      HL,PSCR
12560   LD      BC,1024
12570   LD      A,0
12580   CALL    0212H   ;DEFINE DRIVE 0
12590   CALL    0296H   ;LOOK FOR LEADER & SYNC BYTE
12600 GTNXT:    CALL    0235H   ;GET BYTE
12610   LD      (HL),A
12620   DEC     BC
12630   LD      A,C
12640   OR      B
12650   JR      Z,GTOTEM
12660   INC     HL
12670   JR      GTNXT
12680 GTOTEM:   CALL    0235H   ;GET COUNT
12690   PUSH    AF
12700   CALL    01F8H   ;TURN OFF CASSETTE
12710   EI
12720   POP     AF
12730   CP      1
12740   JP      C,BDTA
12750   CP      65
12760   JP      NC,BDTA
12770   INC     A
12780   LD      (CCHR),A
12790   JP      GTM1
12800 WDTASK:   CALL    ERFX
12810   LD      DE,WASKM
12820   LD      HL,3F50H
12830   LD      BC,WALEN
12840   CALL    PRINT
12850 WTDAGN:   CALL    002BH
12860   CP      'D'
12870   JP      Z,WDISK
12880   CP      'T'
12890   JP      Z,WTAPE
12900   CP      0DH
12910   JR      NZ,WTDAGN
12922   JP      CONT    ;SHOW
12930 GTDASK:   CALL    TOBIG
12940   CALL    01C9H
12950   LD      DE,WASKM
12960   LD      HL,3C53H
12970   LD      BC,14
12980   CALL    PRINT
12990 GTDAGN:   CALL    002BH
13000   CP      'T'
13010   JP      Z,GTAPE
13020   CP      'D'
13030   JP      Z,GDISK
13040   CP      0DH
13050   JR      NZ,GTDAGN
13061   CALL    MVBACK
13062   JP      KEYIN
13070 ;`        END TAPE I/O
13080 ;`!       END I/O ROUTINES
