       ;This program will create a stand alone machine language
 ;program which will run on any model 1 or 3 and consist
 ;of a HELP file. Once it is created it may be reloaded and
 ;added to a later date. It works much the same as a LIB
 ;command from DOS but the command may be defined.
 ;I.E. HELP FORMAT could show how to use the FORMAT command.
 ;Definitions may use more than 1 video page.
 ;<c> 1983 by Mel Patrick
 	ORG	5200H
 STHELP	LD	HL,TEXT		;get text pointer
 	LD	(END),HL	;set up start address
 CRHELP	CALL	01C9H		;clear the video
 	LD	HL,INS1		;point to menu
 	CALL	DISP		;show it
 SELECT	CALL	49H		;wait for inkey
 	CALL	33H		;print it
 	CP	'C'		;for CREATE a FILE
 	JR	Z,CONT3		;go if create
 	CP	'L'		;load help file
 	JP	Z,LDPREV	;yes, then load it
 	CP	'S'		;show all present names
 	JP	Z,SHOWNM	;go if yes
 	CP	'W'		;write help file to disk
 	JP	Z,SAVEFL	;go save file
 	CP	'E'		;exit to DOS
 	JP	Z,402DH		;go if yes
 	LD	A,08H		;else not a valid cmd
 	CALL	33H		;back up
 	JR	SELECT		;loop back now
 CONT3	CALL	01C9H		;clear video
 	LD	HL,3C01H	;start of line counter
 	LD	(LNDISP),HL	;save it for later
 	LD	HL,INS2		;show entry instructions
 	CALL	DISP		;on the video
 	CALL	GRLINE		;show graphic line
 	LD	HL,INS3		;more instructions
 	CALL	DISP		;show them
 	LD	HL,3F00H	;reset cursor location
 	LD	(4020H),HL	;reset it now
 	CALL	GRLINE		;show graphic line
 	LD	A,0EH		;turn on the cursor
 	CALL	33H		;do it
 	LD	HL,(END)	;get end address
 	JP	NUMB		;print prompt
 STKEY	LD	A,64		;length of input
 	LD	(LENGTH),A	;save it for now
 	LD	DE,3F80H	;line for input
 	LD	(4020H),DE	;reset input line
 	LD	A,31		;clear the bottom
 	CALL	33H		;now
 	LD	A,0EH		;turn on the cursor
 	CALL	33H		;do it now.
 INKEY	CALL	49H		;wait for inkey
 	CP	01H		;BREAK key pressed?
 	JP	Z,COMPL		;go cause all done
 	CP	08H		;backspace?
 	JP	Z,BCKSPC	;go if yes
  	CP	27		;shift up arrow?
 	JP	Z,NCMD		;go if yes
 	CP	31		;clear for PAUSE?
 	JR	Z,SETP		;go set pause then
 	CP	0DH		;check for enter
 	JR	Z,ENTKEY	;go if enter key
 	CP	0AH		;down arrow?
 	JP	Z,DELETE	;yes then go backup
 	CP	24		;shift left arrow?
 	JR	NZ,NO1		;go if not
 	LD	A,7BH		;else get left bracket
 NO1	CP	25		;shift right arrow?
 	JR	NZ,NO2		;go if not
 	LD	A,7DH		;else get right bracket
 NO2	CP	20H		;else check lower limit
 	JR	C,INKEY		;back if too low
 	PUSH	AF		;save the character
 	LD	A,(LENGTH)	;get line length
 	DEC	A		;minus one from it
 	OR	A		;test for zero
 	JR	NZ,OK0		;go if its still ok
 	POP	AF		;else fix the stack
 	JR	INKEY		;and back to input
 OK0	LD	(LENGTH),A	;save new length
 	POP	AF		;restore the character
 	LD	(HL),A		;store it in buffer
 	INC	HL		;point to next
 BACK	CALL	33H		;display it
 	JR	INKEY		;loop til BREAK pressed
 ENTKEY	PUSH	AF		;save the character
 	LD	A,5DH		;show left arrow
 	CALL	33H		;on the screen
 	POP	AF		;restore character
 	LD	(HL),A		;put it in the buffer
 	INC	HL		;point to next
 	CALL	BLKMV		;move text lines
 	PUSH	HL		;save text pointer
 	LD	HL,3F80H	;point to text line
 	LD	DE,3EC0H	;point to line buffer
 MVTXT	LD	A,(HL)		;get character
 	CP	5DH		;end of line?
 	JR	Z,GOEND		;yes then exit
 	LD	(DE),A		;else move it
 	INC	HL		;point to next
 	INC	DE		;and in buffer
 	JR	MVTXT		;loop til done
 GOEND	POP	HL		;restore text pointer
 	CALL	ADD1		;add to graphic line
 	JP	STKEY		;get another line
 SETP	PUSH	HL		;save text pointer
 	CALL	BLKMV		;move lines up
 	LD	HL,3EC0H	;reset video position
 	LD	(4020H),HL	;on display
 	LD	HL,PMSG		;point to pause message
 	CALL	DISP		;show it
 	LD	HL,3F80H	;now reset it original
 	LD	(4020H),HL	;for new line
 	POP	HL		;restore text pointer
 	LD	A,31		;byte for pause
 	LD	(HL),A		;store pause byte
 	INC	HL		;point to next location
 	LD	(HL),0DH	;store a C/R
 	INC	HL		;point to next
 	CALL	GRMOVE		;show its a new page
 	JP	STKEY		;and restart entry mode
 BCKSPC	PUSH 	AF		;save character
 	LD	A,(LENGTH)	;get length of input
 	CP	64		;no input yet?
 	JR	Z,NOINP		;go if not
 	INC	A		;else add one for delete
 	LD	(LENGTH),A	;and save it
 	DEC	HL		;backup in buffer
 	POP	AF		;restore backspace char
 	CALL	33H		;do it on video
 BCKNOW	JP	INKEY		;and back to routine
 NOINP	POP	AF		;fix the stack
 	JR	BCKNOW		;and go back
 NCMD	LD	(HL),80H	;store end of message
 	INC	HL		;point to next
 	CALL	GRMOVE		;erase graphic line
 	PUSH	HL		;save text pointer
 	CALL	BLKMV		;move up text
 	LD	HL,3EC0H	;point to last line
 	LD	B,64		;bytes to show
 SHOWSP	LD	(HL),'*'	;show end of command
 	INC	HL		;point to next
 	DJNZ	SHOWSP		;loop til done
 	POP	HL		;restore text pointer
 NUMB	PUSH	HL		;save text pointer
 	LD	HL,3F40H	;reset cursor location
 	LD	(4020H),HL	;for prompt display
 	LD	A,31		;clear til end of frame
 	CALL	33H		;on the video
 	LD	HL,NUMSG	;point to number
 	CALL	DISP		;display it
 	POP	HL		;restore prompt
 GETNUM	CALL	49H		;wait for a number
 	CP	'0'		;no entry
 	JP	Z,CRHELP	;back to menu
 	CP	'1'		;else check limits
 	JR	C,GETNUM	;back if less than 1
 	CP	':'		;else higher than a 9?
 	JR	NC,GETNUM	;loop if too high
 	PUSH	AF		;save number
 	CALL	33H		;display it
 	LD	A,0DH		;do a C/R
 	CALL	33H		;on the screen
 	PUSH	HL		;save address
 	LD	HL,WMSG		;point to prompt
 	CALL	DISP		;show it
 	POP	HL		;restore address
 	POP	AF		;get back number
 	SUB	30H		;make it from 1 to 9
 	LD	(HL),A		;save it in text
 	LD	(CMDLEN),A	;save it for now
 	INC	HL		;point to main body
 	PUSH	HL		;save til after input
 	LD	DE,(4020H)	;get line location
 	LD	(LINE),DE	;save it for later
 	LD	B,A		;set length of input
 	CALL	40H		;do input in ROM
 	JP	C,402DH		;Dos on break for now
 	CALL	ADD1		;add to graphic line
 	POP	HL		;restore location
 FNDCR	LD	A,(HL)		;get a character
 	CP	0DH		;end of input
 	JR	Z,GOTCR		;go if found
 	INC	HL		;else point to next
 	JR	FNDCR		;loop til found
 GOTCR	INC	HL		;point to next
 	PUSH	HL		;save text pointer
 	CALL	BLKMV		;do a block move
 	LD	DE,3EC0H	;line on video
 	LD	HL,(LINE)	;get cursor position
 	LD	A,(CMDLEN)	;get length of input
 	LD	B,A		;move for loop
 MVCMD	LD	A,(HL)		;get a byte
 	LD	(DE),A		;move for now
 	INC	DE		;point to next
 	INC	HL		;"	"
 	DJNZ	MVCMD		;loop til done
 	LD	A,31		;clear out bottom
 	LD	HL,3F40H	;of the display
 	LD	(4020H),HL	;reset cursor location
 	CALL	33H		;do it now
 	LD	HL,INS4		;point to more msgs
 	CALL	DISP		;show them
 	POP	HL		;restore text pointer
 	JP	STKEY		;and get input
 COMPL	LD	(HL),80H	;mark end of message
 	INC	HL		;point to next
 	LD	(HL),0FFH	;mark end of text
 	LD	(END),HL	;save address
 	JP	CRHELP		;back to menu
 SAVEFL	LD	HL,SPEC		;point to prompt
 	CALL	DISP		;show it
 	XOR	A		;zero out a
 	LD	(LEN),A		;set bytes to load 256
 	LD	(BLOCKS),A	;reset blocks to dump
 	LD	HL,NAME		;point to buffer
 	LD	B,20H		;bytes for input
 	CALL	40H		;get input
 	JP	C,402DH		;back to dos on BREAK
 	LD	HL,DUMMY	;else point to dummy I/O
 	LD	DE,NAME		;point to filespec
 	LD	B,00H		;set LRL=256
 	CALL	4420H		;open or create it
 	JP	NZ,ERROR	;go if error
 	LD	HL,(END)	;get end address
 	INC	HL		;add one to it
 	LD	(END),HL	;save for moment
 	LD	DE,HELP		;point to start program
 	LD	(START),DE	;save starting point
 	LD	(EXEC),DE	;save in other buffer
 	SBC	HL,DE		;get size of dump
 	PUSH	HL		;move answer to DE
 	POP	DE		;for calculate
 	LD	BC,254		;size of blocks
 	LD	HL,0000H	;reset size to zero
 TEST	ADD	HL,BC		;add block size
 	RST	18H		;compare HL to DE
 	JR	Z,EQUAL		;go if same
 	JR	NC,GREAT	;else go if HL>DE
 	LD	A,(BLOCKS)	;else get block
 	INC	A		;add one to it
 	LD	(BLOCKS),A	;and save it again
 	JR	TEST		;loop til HL>=DE
 GREAT	SBC	HL,BC		;find previous value
 	PUSH	HL		;move for subtract
 	POP	DE		;into DE
 	LD	HL,(END)	;get end address
 	SBC	HL,DE		;get remainder <254
 	LD	A,L		;get the value
 	LD	(REMAIN),A	;save the value
 	JR	CONTIN		;and continue
 EQUAL	LD	A,(BLOCKS)	;get number
 	INC	A		;add cause they are =
 	LD	(BLOCKS),A	;and save the value
 CONTIN	LD	HL,(END)	;get last address
 	DEC	HL		;back to original
 	LD	(END),HL	;save it
 	LD	A,(BLOCKS)	;get number of blocks
 	OR	A		;0=very small dump
 	JR	Z,WRLAST	;write and close file
 WRDISK	LD	HL,HEADER	;point to header
 	LD	B,04H		;bytes to write out
 WRITE	LD	DE,NAME		;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 	LD	A,(3C3EH)	;get video character
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;put it back
 	DJNZ	WRITE		;loop for 5
 	LD	B,254		;bytes to write out
 	LD	HL,(START)	;get address of data
 WRDATA	LD	DE,NAME		;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write it to disk
 	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 	LD	A,(3C3EH)	;get scrren byte
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;put it back
 	DJNZ	WRDATA		;loop for 254
 	LD	(START),HL	;save last address
 	LD	A,(BLOCKS)	;get number of blocks
 	DEC	A		;minus one from it
 	LD	(BLOCKS),A	;save new value
 	OR	A		;test for 0
 	JR	Z,WRLAST	;go if only remainder
 	JR	WRDISK		;loop til remainder left
 WRLAST	LD	A,(REMAIN)	;get remainder
 	OR	A		;test for 0
 	JR	Z,CLOSE		;go if none there
 	INC	A		;add one for LSB
 	INC	A		;Add one for MSB
 	LD	(LEN),A		;save it in header
 	LD	HL,HEADER	;point to header
 	LD	B,4		;bytes to write
 WRHEAD	LD	DE,NAME		;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 	DJNZ	WRHEAD		;loop til done
 	LD	A,(REMAIN)	;get remainder
 	LD	B,A		;move to loop
 	LD	HL,(START)	;get address
 WRSECT	LD	DE,NAME		;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write it to disk
 	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 	LD	A,(3C3EH)	;get video byte
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;show it
 	DJNZ	WRSECT		;loop til done
 CLOSE	LD	B,4		;set eof and entry
 	LD	HL,ENTRY	;point to buffer
 CLOSE1	LD	DE,NAME		;point to filespec
 	LD	A,(HL)		;get a byte
 	CALL	1BH		;write to disk
 	JP	NZ,ERROR	;go if error
 	INC	HL		;point to next
 	DJNZ	CLOSE1		;loop til done
 	LD	DE,NAME		;point to name
 	CALL	4428H		;close the file
 	JP	CRHELP		;back to menu now
 DISP	LD	A,(HL)		;get a byte
 	CP	03H		;end of message
 	RET	Z		;back if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DISP		;loop til done
 ERROR	SET	7,A		;set return routine
 	CALL	4409H		;display error
 	CALL	49H		;wait for key press
 	JP	CRHELP		;back to menu now
 SHOWNM	CALL	01C9H		;clear the video
 	LD	A,15		;turn off cursor
 	CALL	33H		;do it
 	LD	HL,MSG		;point to message
 	CALL	DISP		;show it
 	LD	HL,(4020H)	;get cursor address
 	LD	IX,TEXT		;point to text
 	LD	A,(IX)		;get a byte
 	CP	0FFH		;any text in buffer?
 	JP	Z,CRHELP	;menu if not
 SH1	PUSH	HL		;save address
 	LD	DE,16		;calculate to next
 	ADD	HL,DE		;find it
 	LD	(VIDEO),HL	;save it for next time
 	POP	HL		;restore previous one
 	LD	B,(IX)		;get command length
 	INC	IX		;point to word itself
 SH2	LD	A,(IX)		;get character
 	CALL	33H		;display it on video
 	INC	IX		;point to next
 	DJNZ	SH2		;loop for word length
 SH3	LD	A,(IX)		;get next character
 	CP	80H		;end of description?
 	JR	Z,SH4		;go if yes
 	INC	IX		;else step through text
 	JR	SH3		;loop til found
 SH4	INC	IX		;point to new length
 	LD	A,(IX)		;get a byte
 	CP	0FFH		;end of text area?
 	JR	Z,SH5		;go if yes
 	LD	HL,(VIDEO)	;get new address
 	LD	(4020H),HL	;change next print pos.
 	JR	SH1		;loop til done
 SH5	LD	HL,EMSG		;point to end message
 	CALL	DISP		;show it
 	CALL	49H		;wait for inkey
 	JP	CRHELP		;back to menu
 LDPREV	LD	HL,EDIT		;point to edit prompt
 	CALL	DISP		;show it
 	LD	HL,NAME		;point to buffer
 	LD	B,20H		;length of input
 	CALL	40H		;get input
 	JP	C,CRHELP	;menu if break
 	LD	HL,DUMMY	;dummy buffer
 	LD	DE,NAME		;point to name
 	LD	B,00H		;LRL=256
 	CALL	4424H		;open but not create file
 	JP	NZ,ERROR	;go if error
 LD1	LD	IX,DBLK		;point to buffer
 	PUSH	IX		;save address
 	LD	B,4		;header bytes to read
 LD2	LD	DE,NAME		;point to filespec
 	CALL	13H		;read one byte
 	LD	(IX),A		;save it in buffer
 	INC	IX		;point to next
 	DJNZ	LD2		;loop for block
 	POP	IX		;restore buffer address
 	LD	A,(IX)		;get first byte
 	CP	02H		;end of file?
 	JR	NZ,NOTYET	;go if still more
 	DEC	HL		;point to end marker
 	LD	(END),HL	;save address
 	JP	CRHELP		;back cause its loaded
 NOTYET	LD	B,(IX+01H)	;get block length
 	DEC	B		;minus one
 	DEC	B		;and again
 	LD	L,(IX+02)	;get LSB address to load
 	LD	H,(IX+03)	;"   MSB "             "
 LD3	LD	DE,NAME		;point to filespec
 	CALL	13H		;read a byte
 	LD	(HL),A		;save it in buffer
 	LD	A,(3C3EH)	;get a video byte
 	XOR	0AH		;toggle a *
 	LD	(3C3EH),A	;show it again
 	INC	HL		;point to next
 	DJNZ	LD3		;go for block length
 	JR	LD1		;loop til done
 GRLINE	LD	B,64		;characters to print
 GR1	LD	A,140		;byte to show
 	CALL	33H		;display it
 	DJNZ	GR1		;loop til done
 	RET			;back to caller
 BLKMV	PUSH	HL		;save text pointer
 	LD	DE,3C80H	;destination for move
 	LD	HL,3CC0H	;one line below it
 	LD	BC,640		;move 10 lines
 	LDIR			;do it now
 	LD	HL,3EC0H	;point to bottom line
 	LD	B,64		;characters to erase
 ERLINE	LD	(HL),20H	;space out old line
 	INC	HL		;point to next
 	DJNZ	ERLINE		;loop til gone
 	POP	HL		;restore pointer
 	RET			;back to caller
 DELETE	LD	A,(LENGTH)	;get line length
 	CP	64		;must be first character
 	JP	NZ,INKEY	;back if not
 	CALL	SUB1		;show graphic deletion
 	DEC	HL		;else back up to C/R
 DLP	DEC	HL		;back again
 	LD	A,(HL)		;get a byte
 	CP	0DH		;at a C/R?
 	JR	Z,NEWLIN	;go if yes
 	CP	31		;page pause?
 	JR	Z,FNDPA		;go if yes
 	CP	20H		;else at command word?
 	JP	C,NEWNUM	;go erase last line
 	JR	DLP		;else loop til found
 FNDPA	DEC	HL		;point to previous line
 NEWLIN	INC	HL		;point to text
 	PUSH	HL		;save pointer
 	LD	HL,3C80H	;window plus 1
 	LD	DE,3C81H	;start of window
 	LD	(HL),20H	;space byte to move
 	LD	BC,639		;bytes to clear
 	LDIR			;and do it
 	LD	HL,3EC0H	;location for print
 	LD	(ZONE),HL	;save location
 	LD	B,10		;maximum number of lines
 	POP	HL		;restore text pointer
 	PUSH	HL		;and save it again
 	DEC	HL		;point to C/R
 DLP1	DEC	HL		;point to text
 	LD	A,(HL)		;get a character
 	CP	0DH		;terminator?
 	JR	Z,PRTLN		;go if yes
 	CP	31		;pause command?
 	JR	Z,SHPA		;show pause then
 	CP	20H		;else check for cmd
 	JR	C,CMDRCH	;got to start of cmd
 	JR	DLP1		;else loop til found
 CMDRCH	LD	B,1		;else reset to last line
 PRTLN	PUSH	HL		;save location
 	POP	IX		;in IX for display
 	PUSH	IX		;save location for next
 PRTLN1	LD	HL,(ZONE)	;get window print area
 DLP2	INC	IX		;point to text
 	LD	A,(IX)		;get a byte
 	CP	0DH		;end of line?
 	JR	Z,DONEXT	;yes then keep going
 	CP	03H		;end of message?
 	JR	Z,DONEXT	;go if yes
 	LD	(HL),A		;else move to window
 	INC	HL		;point to next
 	JR	DLP2		;loop til shown
 DONEXT	LD	HL,(ZONE)	;get last print area
 	LD	DE,40H		;one line less
 	SBC	HL,DE		;find new zone
 	LD	(ZONE),HL	;save it
 	POP	HL		;for next line
 	DJNZ	DLP1		;loop for 10 lines max.
 	POP	HL		;restore text pointer
 	JP	STKEY		;and back to routine
 SHPA	DEC	HL		;backup for pause
 	PUSH	HL		;save for next time
 	LD	IX,PMSG+1	;point to pause
 	JR	PRTLN1		;and back to routine
 NEWNUM	PUSH	HL		;save text pointer
 	LD	B,64		;bytes to clear
 	LD	HL,3EC0H	;line to clear it from
 NEWCLR	LD	(HL),20H	;space out last line
 	INC	HL		;point to next
 	DJNZ	NEWCLR		;loop til gone
 	POP	HL		;restore text pointer
 	JP	NUMB		;and get new command
 ADD1	PUSH	HL		;save text address
 	LD	HL,(LNDISP)	;get address to show
 	LD	A,'>'		;line full
 	CP	(HL)		;check against video
 	JR	Z,LNFULL	;go if full
 	LD	(HL),140	;set graphics block
 	INC	HL		;point to next
 ADD2	LD	(LNDISP),HL	;save it
 LNFULL	POP	HL		;restore text pointer
 	RET			;back to caller
 SUB1	PUSH	HL		;save text pointer
 	LD	HL,(LNDISP)	;get address for show
 	LD	A,'<'		;get start byte
 	DEC	HL		;back up one
 	CP	(HL)		;at the start?
 	JR	Z,LNFULL	;back if yes
 	LD	(HL),20H	;else remove the graphic
 	JR	ADD2		;and return to caller
 GRMOVE	PUSH	HL		;save text address
 	LD	HL,3C01H	;point to start of line
 	LD	(LNDISP),HL	;reset address
 	LD	B,16		;lines on a page
 GRMV	LD	(HL),20H	;remove bytes
 	INC	HL		;point to next
 	DJNZ	GRMV		;loop til done
 	JR	LNFULL		;and back to caller
 EDIT	DEFW	0D0DH
 	DEFM	'Filename to Load : '
 	DEFB	03H
 EMSG	DEFW	0D0DH
 	DEFM	'Press any key for menu...'
 	DEFB	03H
 INS1	DEFM	'             Help File Creation Version 3.2'
 	DEFB	0DH
 	DEFM	'                 <c> 1983 by Mel Patrick'
 	DEFW	0D0DH
 	DEFM	'<C>reate or Add to file'
 	DEFB	0DH
 	DEFM	'<L>oad HELP file'
 	DEFB	0DH
 	DEFM	'<S>how Defined Commands'
 	DEFB	0DH
 	DEFM	'<W>rite HELP file to Disk'
 	DEFB	0DH
 	DEFM	'<E>xit to Dos Ready'
 	DEFW	0D0DH
 	DEFM	'     Option : '
 	DEFB	03H
 INS3	DEFB	0FH		;turn off cursor
 	DEFM	'Command Keys ............... Functions'
 	DEFW	0D0DH
 	DEFM	'Shift Up Arrow - Advance to next command entry.'
 	DEFB	0DH
 	DEFM	'Clear Key      - Insert pause during text display.'
 	DEFB	0DH
 	DEFM	'Enter Key      - Advance to next line.'
 	DEFB	0DH
 	DEFM	'Break Key      - Exit entry and return to menu.'
 	DEFB	0DH
 	DEFM	'Shift Rt Arrow - Gives right bracket.
 	DEFB	0DH
 	DEFM	'Shift Lt Arrow - Gives left bracket.
 	DEFB	0DH
 	DEFM	'Down Arrow     - Backup and Erase one line.
 	DEFB	03H
 INS2	DEFM	'<                > Help File Creation - Version 3.2'
 	DEFB	0DH
 	DEFB	03H
 INS4	DEFM	'Enter text, ENTER-newline, BREAK-menu, SHIFT [-next command.'
 	DEFB	03H
 PMSG	DEFB	0FH		;turn off the cursor
 	DEFM	'    --------------< Page Pause Inserted >--------------'
 	DEFB	03H
 NUMSG	DEFM	'Command Word Length :'
 	DEFB	03H
 WMSG	DEFM	'Command Word (UPPER CASE ONLY) : '
 	DEFB	03H
 SPEC	DEFW	0D0DH
 	DEFM	'Filespec to Save : '
 	DEFB	03H
 ZONE	DEFW	0000H		;window print zones
 LNDISP	DEFW	0000H		;for graphic line display
 LENGTH	DEFB	00H		;line length
 CMDLEN	DEFB	00H		;command length
 LINE	DEFW	0000H		;for line location
 END	DEFW	0000H		;end address of text
 HEADER	DEFB	01H		;machine file
 LEN	DEFB	00H		;number of bytes to load
 START	DEFW	0000H		;address to load at
 ENTRY	DEFW	0202H		;eof bytes
 EXEC	DEFW	0060H		;entry address
 NAME	DEFS	20H		;filespec storage
 BLOCKS	DEFB	00H		;number of 254 blocks
 REMAIN	DEFB	00H		;remainder of bytes
 DBLK	DEFS	04H		;header blocks
 DUMMY	DEFS	256		;dummy I/O
 ;This is the actual HELP/CMD command routine
 ;that gets written to disk. The previous part is only
 ;for creating the text file.
 	ORG	6000H		;start of help routine
 HELP	PUSH	HL		;save position
 	LD	A,(HL)		;get the character
 	CP	0DH		;just HELP?
 	JR	NZ,CONT		;no, then continue
 	POP	HL		;else restore stack
 	JP	SHOW		;and go show support
 CONT	POP	HL		;point to start again
 	LD	DE,CMD		;point to command
 MOVE	LD	A,(HL)		;get a byte
 	CP	60H		;check for lower case
 	JR	C,OK		;go if UPPER now
 	SUB	20H		;else make it UPPER case
 OK	LD	(DE),A		;move to buffer
 	CP	0DH		;check for C/R
 	JR	Z,ENDCMD	;go if found
 	INC	DE		;else point to next
 	INC	HL		;in command too
 	JR	MOVE		;and back to move it
 ENDCMD	LD	A,0DH		;load a C/R
 	CALL	33H		;send it
 	LD	IX,TEXT		;point to table text
 AGAIN	LD	HL,CMD		;point to command
 	LD	B,(IX)		;get cmd length
 	INC	IX		;point to cmd word
 SEARCH	LD	A,(HL)		;get a byte
 	CP	(IX)		;check for match
 	JR	NZ,NOPE		;go if no match
 	INC	IX		;else point to next
 	INC	HL		;in buffer too
 	DJNZ	SEARCH		;loop for cmd length
 	LD	A,(HL)		;get the character
 	CP	0DH		;better be a C/R
 	JR	NZ,NOPE		;syntax error then
 	PUSH	IX		;move it to
 	POP	HL		;hl for display
 BKLP	DEC	HL		;back up one
 	LD	A,(HL)		;get a character
 	CP	20H		;check lower limit
 	JR	NC,BKLP		;go if not less
 	INC	HL		;point to cmd word
 	CALL	01C9H		;clear screen first
 DISPLY	LD	A,(HL)		;get a byte
 	CP	31		;pause command?
 	JR	Z,PAUSE		;yes, then go pause
 	CP	80H		;end of message
 	JP	Z,402DH		;yes then DOS
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DISPLY		;and continue
 PAUSE	PUSH	HL		;save text pointer
 	LD	HL,WAIT		;point to wait
 PRINT	LD	A,(HL)		;get a byte
 	CP	03H		;end of message?
 	JR	Z,ENPRT		;go if end
 	CALL	33H		;else show it
 	INC	HL		;point to next
 	JR	PRINT		;loop til done
 ENPRT	CALL	49H		;wait for inkey
 	POP	HL		;restore pointer
 	INC	HL		;point to next
 	JR	DISPLY		;loop til done
 NOPE	LD	A,(IX)		;get table byte
 	CP	80H		;loop for next cmd
 	JR	Z,NEXT		;go if found
 	INC	IX		;else point to next
 	JR	NOPE		;loop til found
 NEXT	INC	IX		;point to cmd length
 	LD	A,(IX)		;get cmd length
 	CP	0FFH		;end of text table?
 	JR	Z,SHOW		;go if no match found
 	JR	AGAIN		;else loop til end
 SHOW	CALL	01C9H		;clear the video
 	LD	HL,MSG		;show heading
 DIS	LD	A,(HL)		;get a byte
 	CP	03H		;end of message?
 	JR	Z,CONT2		;go if yes
 	CALL	33H		;else display it
 	INC	HL		;point to next
 	JR	DIS		;loop til shown
 CONT2	LD	HL,(4020H)	;get cursor address
 	LD	IX,TEXT		;point to text
 CONT4	PUSH	HL		;save start address
 	LD	DE,16		;bytes to next address
 	ADD	HL,DE		;add to find next address
 	LD	(VIDEO),HL	;save address
 	POP	HL		;restore to original
 	LD	B,(IX)		;get cmd length
 	INC	IX		;point to word
 SHCMD	LD	A,(IX)		;get character
 	CALL	33H		;display it
 	INC	IX		;loop til done
 	DJNZ	SHCMD		;loop til done
 FNDNX	LD	A,(IX)		;get a byte
 	CP	80H		;next command found
 	JR	Z,GOTNEX	;go if found
 	INC	IX		;else point to next
 	JR	FNDNX		;loop til found
 GOTNEX	INC	IX		;point to next
 	LD	A,(IX)		;get a byte
 	CP	0FFH		;end of file
 	JR	Z,GOTEND	;go if found
 	LD	HL,(VIDEO)	;else get next address
 	LD	(4020H),HL	;reset cursor position
 	JR	CONT4		;and loop for more
 GOTEND	LD	A,0DH		;set up a C/R
 	CALL	33H		;do it on video
 	JP	402DH		;and back to dos
 MSG	DEFM	'Commands supported by Help :'
 	DEFW	0D0DH
 	DEFB	03H
 WAIT	DEFM	'        ------ Press <ENTER> to continue ------'
 	DEFB	03H
 VIDEO	DEFW	0000H		;address buffer
 CMD	DEFS	20H		;command storage
 TEXT	DEFB	0FFH		;start of text area
 	END	STHELP
