 ; Minihost/Asm version 3.3 10/12/85
 ;
 ; Created version 3.3 10/12/85 that sets the himem
 ; pointer lower in order to load DFTHOST/CIM which
 ; is required by The Greene Machine BBS.  The HIMEM
 ; pointer was changed from F3FFh to E5FFh.  DFTHOST
 ; loads at E600h and is not relocatable.  DFTHOST
 ; performs the ASCII & DFT up/down load functions.
 ;
 ; Written by Eric Greene, Mike Bernstein & George Fischer
 ; Copyright 1984, 1985 by Mike Bernstein
 ;
 ; Modified July 20, 1985.  Changed LABEL 'STRIPIT' to
 ; 'STRIP'.  This will enable the source code to be loaded
 ; into all assemblers.  I also added the copyright
 ; message that will appear when the program is executed.
 ;
 ; Modified July 17, 1985 to correct an error when
 ; checking if a <Break>	(01H) was sent.
 ; A new feature that I added will trap the <Shift @> sent
 ; thru the RS-232 port.
 ;
 ; Modified July 14, 1985 to strip the hi bit coming from
 ; the RS-232 port.  This will enable both 8/n/1 & 7/e/1
 ; to work.  The other addition deals with BLIND.  From
 ; BASIC if BL=2 then the '*' character will be echoed
 ; back.  This is very useful for PASSWORDS.
 ;
 ; Modified Nov 25, 1984 to Recognize
 ; Model I or III Himem Pointer
 
 ; This is a PUBLIC DOMAIN program and is to
 ; remain as such.  This source code may NOT
 ; be sold or traded.
 ;
 ; Minihost was customized from a Greene Machine
 ; DRIVER program for the Mini-BBS.
 ; Minihost will run under a hard disk drive.
 ;
 ; If you have ANY questions about Minihost or
 ; any part of the Mini-BBS software, please feel
 ; free to call me.  You may leave a message for
 ; me on The Kandy Shack #1 (714) 354-8004 300/1200
 ;
 ;
 	ORG	0F400H
 SOBUF	DEFS	319	;SAVE SPACE FOR 319 CHAR. BUFFER
 LOCAL	DEFB	0	;LOCAL LOGON FLAG.  1=LOCAL
 LC	DEFB	0	;LOWER CASE LOCK.   0 IF L/C IS OK
 BUFSIZ	DEFB	0	;PERMITTED NUMBER OF CHARACTERS
 BUFCTR	DEFB	0	;ACTUAL # OF CHARACTERS ENTERED
 CRCTR	DEFB	0	;CARRIAGE RETURN COUNTER
 CXRFLG	DEFB	0	;CARRIER DETECT FLAG.  1=CARRIER
 NULLS	DEFB	0	;NO. OF NULLS AFTER C/R L/F
 FLAG	DEFB	0	;FLAG USED INTERNAL TO PROGRAM
 MINCTR	DEFB	0	;TIMEOUT MINUTE COUNTER
 SECCTR	DEFW	0	;TIMEOUT COUNTER
 BLIND	DEFB	0	;VIDEO BLINDING.  1=BLIND VIDEO
 KBDVR	JP	0	;PATCH IN NEW KEYBOARD AND VIDEO
 VIDDVR	JP	0	;DRIVER ADDRESSES
 ENTRY	PUSH	HL
 	NOP
 	NOP
 	NOP
 	CALL	RS232	;SETS UP RS232 8/N/1 & DROPS DTR
 	NOP
 	NOP
 	NOP
 	NOP
 	NOP
 	LD	HL,0E5FFH	;SET HIMEM POINTERS
 	LD	A,(0125H)       ;CHECK LOCATION 125H
 	CP	'I'		; FOR AN "I"
 	JR	NZ,MOD1         ; NOT I MUST BE MOD 1
 	LD	(4411H),HL      ;MOD III HI-MEM POINTER
 	JR	ENDMEM
 MOD1	LD	(4049H),HL	;MOD 1 HI-MEM POINTER
 ENDMEM	EQU	$
 ;THE FOLLOWING SECTION OF CODE PATCHES THE NEW SECTION
 ;OF THE KEYBOARD DRIVER AND VIDEO DRIVER INTO THE 
 ;DEVICE CONTROL BLOCKS FOR THESE DEVICES.  IT ALSO SETS
 ;UP THE RETURN ADDRESSES TO ROM.
 	LD	HL,(4016H)
 	LD	(KBDVR+1),HL
 	LD	HL,(401EH)
 	LD	(VIDDVR+1),HL
 	LD	HL,NKBDVR
 	LD	(4016H),HL
 	LD	HL,NVDDVR
 	LD	(401EH),HL
 	POP	HL
 	OUT	(0E8H),A	;MASTER RESET OF RS-232
 	JP	402DH		;RETURN TO DOS
 NKBDVR	CALL	CXRDT		;CHECK FOR CARRIER
 	JP	NZ,KBRET	;RETURN TO ROM IF NO CXR
 	LD	A,1
 	LD	(FLAG),A	;SET INTERNAL FLAG
 	IN	A,(0EAH)	;CHECK FOR CHAR. AT RS-232
 	BIT	7,A
 	JP	Z,KBDVR		;NO CHAR.  RETURN TO ROM
 	IN	A,(0EBH)	;GET CHARACTER
 	NOP
 	NOP
 	NOP
 	NOP
 	NOP
 	JP	STRIP   ; STRIPS HI BIT AND CHECKS
 			; FOR <BREAK> KEY AND NULLS IT.
 	NOP
 	NOP
 	NOP
 	NOP
 ;THE FOLLOWING CODE CHECKS TO SEE IF A CHARACTER HAS BEEN
 ;RECEIVED, RESETS THE INTERNAL FLAG IF ON HAS. RUNS THRU
 ;A TIMER ROUTINE. RESETS THE RS-232 AND GOES BACK TO ROM.
 KBRET	LD	A,(FLAG)
 	CP	0
 	JR	Z,KBDVR
 	LD	A,0
 	LD	(FLAG),A
 	LD	A,0ABH
 	OUT	(0EAH),A
 	PUSH	BC
 	CALL	TIMER
 	POP	BC
 	LD	A,06DH
 	OUT	(0EAH),A
 	JP	KBDVR
 ;THIS IS THE NEW VIDEO DRIVER ROUTINE.  LIKE THE NEW
 ;KEYBOARD DRIVER, IT IS ENTERED FROM ROM, DOES ITS FUNC-
 ;TION AND RETURNS TO ROM
 NVDDVR	PUSH	AF
 	PUSH	BC
 	CALL	CXRDT		;CHECK FOR CARRIER
 	JP	NZ,VIDRET	;IN NONE, RETURN TO ROM
 ;THIS SECTION CHECKS THE C REGISTER WHICH CONTAINS THE
 ;CHARACTER RECEIVED FROM KEYBOARD OR RS-232, IF IT IS
 ;EITHER A CARRIAGE RETURN (0DH) OR A LINE FEED (0AH)
 ;IT FORCES A JUMP TO CRLF.
 ;IF IT IS NEITHER OF THESE CHARACTERS, A NORMAL CALL IS
 ;MADE TO VIDDIS (VIDEO DISPLAY)
 	LD	A,C
 	CP	0DH
 	JR	Z,CRLF
 	CP	0AH
 	JR	Z,CRLF
 	CALL	BASIC
 ;NORMAL RETURN TO ROM
 VIDRET	POP	BC
 	POP	AF
 	JP	VIDDVR
 ;THIS ROUTINE FORCES A CR/LF PAIR (0DH AND 0AH) AFTER
 ;EITHER A C/R OR L/F.  IT ALSO INSERTS THE USER SPECIFIED
 ;NUMBER OF NULLS AFTER A C/R L/F.  NULLS ARE NEEDED IN
 ;THE EVENT A CALLER IS USER A SLOW PRINTING TERMINAL.
 ;THE C/R L/F IS SENT TO VIDEO DISPLAY AND CONTROL IS
 ;RETURNED TO ROM.
 CRLF	LD	C,0DH
 	CALL	VIDDIS
 	LD	C,0AH
 	CALL	VIDDIS
 	LD	C,00
 	LD	A,(NULLS)
 	LD	B,A
 	XOR	A
 	CP	B
 	JR	Z,VIDRET
 ;THIS LOOP IS THE COUNT-DOWN LOOP FOR THE NUMBER OF
 ;NULLS TO BE SENT.
 LOOP	CALL	VIDDIS
 	DEC	B
 	LD	A,0
 	CP	B
 	JR	NZ,LOOP
 	JR	VIDRET
 ;THE VIDEO DISPLAY ACTUALLY IS SENDING A CHARACTER OUT
 ;ON THE RS-232.  IT CHECKS FOR THE TRANSMIT HOLD REGISTER
 ;TO CLEAR AND WHEN THE PREVIOUS CHARACTER HAS BEEN SENT,
 ;SENDS THE PRESENT CHARACTER.
 VIDDIS	IN	A,(0EAH)
 	BIT	6,A
 	JR	Z,VIDDIS
 	LD	A,C
 	OUT	(0EBH),A
 	RET
 ;THIS TIMER IS USED IN THE RECEIVE PORTION OF PROGRAM.
 ;IT IS USED TO VERIFY THE RECEIPT OF CARRIER FROM THE
 ;CALLING END.
 TIMER	LD	BC,0FFFFH
 TIMER1	DEC	BC
 	LD	A,B
 	CP	0
 	JR	NZ,TIMER1
 	RET
 ;THIS IS A SHORT IN TRANSLATION TABLE.  THE ONLY CONTROL
 ;CODES PERMITTED TO ENTER THE SYSTEM ARE AS FOLLOWS:
 ;08 - BACKSPACE
 ;17 - CONTROL Q.  RESTARTS SYSTEM AFTER CTRL S.
 ;19 - CONTROL S.  PAUSES SYSTEM FOR TERMINALS WITH BUFFER
 ;24 - CONTROL X.  CLEAR TO BEGINNING OF LINE.
 ;ALL OTHER CHARACTERS BETWEEN ASCII CODES 0-31 ARE
 ;TRANSLATED TO A NULL CHARACTER (0).
 INXLAT	CP	08
 	RET	Z
 	CP	0DH
 	RET	Z
 	CP	17
 	JP	Z,CNTLQ
 	CP	19
 	JP	Z,CNTLS
 	CP	24
 	RET	Z
 	LD	A,0
 	RET
 CNTLQ	LD	A,32
 	RET
 CNTLS	LD	A,96
 	RET
 ;THE FOLLOWING CODE CHECKS THE CARRIER DETECT LEAD
 ;FROM THE RS-232 AND CHANGES THE STATE OF CXRFLG
 ;(CARRIER FLAG) IF CARRIER IS DETECTED OR NOT.
 CXRDT	IN	A,(0E8H)
 	BIT	5,A
 	JP	NZ,NOCXR
 	LD	A,1
 	LD	(CXRFLG),A
 	RET
 NOCXR	LD	A,0
 	LD	(CXRFLG),A
 	RET
 ;This is the beginning of the LINEINPUT routine.
 ;It starts by clearing a 63 character buffer and then
 ;goes into a loop waiting for a character to be entered
 ;from the keyboard or the RS-232.  Once a character is
 ;received, it makes several tests on the input before
 ;returning to BASIC.
 ;
 ;
 ;
 	LD	HL,SOBUF	;setup to clear the buff.
 	LD	A,(BUFSIZ)
 	LD	B,A
 	LD	A,0
 CLRBUF	LD	(HL),A		;actual clear loop
 	INC	HL
 	DJNZ	CLRBUF
 ;this section sets up some of the various counters used
 ;in the program.  HL points to Start of Buffer, Minctr
 ;and SECCTR are the lack of input timers.
 	LD	HL,SOBUF
 	LD	BC,0EEC0H
 	LD	(SECCTR),BC
 	LD	A,4
 	LD	(MINCTR),A
 KBSCAN	CALL	CLEAR;CHECK TO SEE IF SYSOP WANTS ATTENTION
 	CALL	002BH	;calls ROM keyboard scan
 
 	CP	32	;if returns with less than 32
 	CALL	M,INXLAT;goto translation table
 	CP	0
 	JP	Z,CXRDT1;if a null from inxlat look for carrier
 	CALL	BUFCLR	;clear the buffer if a 1DH rec.
 	CALL	EOBUF 	;have we reached end of buffer?
 	CALL	BACKSP	;is it a backspace?
 	CALL	CR	;is it a carriage return?
 	CALL	MODIFY	;UPPER or lower case
 	CALL	PUTIT	;PUTS '*' IF BL=2
 	CALL	DISPLY	;let's look at it on MON & RS232
 	CALL	ONEKEY	;simulate INKEY$ function
 CXRDT1	CALL	CXRCK	;look for carrier
 	CALL	TIMER2	;Lack of input timer
 	JP	KBSCAN	;go back and do it all again!!!
 BACKSP	CP	08
 	RET	NZ
 BKSP1	POP	DE
 	LD	A,0
 	CP	L
 	JP	Z,CXRDT1
 	DEC	HL
 	LD	(HL),A
 	LD	A,08
 	CALL	0033H
 	JP	CXRDT1
 EOBUF	LD	B,A
 	LD	DE,BUFSIZ
 	LD 	A,(DE)
 	CP	L
 	LD	A,B
 	RET	NZ
 	CP	08
 	JP	Z,BKSP1
 	CP	0DH
 	JP	Z,CR1
 	LD	A,7
 	POP	DE
 	CALL	0033H
 	JP	CXRDT1
 CR	CP	0DH
 	RET	NZ
 CR1	LD	A,L
 	LD	(BUFCTR),A
 	POP	HL
 	CP	0
 	JP	Z,CRCTR1
 	LD	A,0
 	LD	(CRCTR),A
 	LD	HL,0
 	JP	0A9AH
 CRCTR1	LD	A,(CRCTR)
 	INC	A
 	LD	(CRCTR),A
 	CP	255
 	LD	DE,MSGA
 	CALL	Z,MSG
 	LD	HL,0
 	JP	0A9AH
 MSG	LD	A,(DE)
 	CP	0
 	RET	Z
 	PUSH	DE
 	CALL	0033H
 	POP	DE
 	INC	DE
 	JR	MSG
 MODIFY	CP	60H
 	CALL	P,UCLOCK
 	LD	(HL),A
 	INC	L
 	RET
 ONEKEY	LD	B,A
 	LD	A,(BUFSIZ)
 	CP	1
 	LD	A,B
 	RET	NZ
 	LD	A,L
 	LD	(BUFCTR),A
 	POP	HL
 	LD	HL,0
 	JP	0A9AH
 UCLOCK	LD	C,A
 	LD	A,(LC)
 	CP	0
 	LD	A,C
 	RET	Z
 	SUB	20H
 	RET
 DISPLY	LD	B,A
 	LD	A,(BLIND)
 	CP	1
 	LD	A,B
 	RET	Z
 	CALL	0033H
 	LD	BC,0EEC0H
 	LD	(SECCTR),BC
 	LD	A,4
 	LD	(MINCTR),A
 	RET
 CXRCK	LD	A,(LOCAL)
 	CP	1
 	RET	Z
 	LD	A,(CXRFLG)
 	CP	1
 	RET	Z
 	POP	HL
 	LD	HL,1
 	JP	0A9AH
 TIMER2	LD	A,(LOCAL)
 	CP	1
 	RET	Z
 	LD	BC,(SECCTR)
 	DEC	BC	
 	LD	(SECCTR),BC
 	LD	A,B
 	OR	C
 	RET	NZ
 	LD	BC,0EE00H
 	LD	(SECCTR),BC
 	LD	A,(MINCTR)
 	DEC	A
 	LD	(MINCTR),A
 	CP	0
 	JP	Z,TIMOUT
 	CP	1
 	RET	NZ
 	LD	DE,MSGB
 	CALL	MSG
 	RET
 TIMOUT	POP	HL
 	LD	HL,2
 	JP	0A9AH
 MSGA	DEFB	0
 	DEFB	0DH
 	DEFB	0
 MSGB	DEFB	0AH
 	DEFM	'Lacking input - Time out in 1 minute!'
 	DEFB	7
 	DEFB	7
 	DEFB	0DH
 	DEFB	0
 BUFCLR	CP	24
 	RET	NZ
 	POP	DE
 	LD	A,0
 	CP	L
 	JP	Z,CXRDT1
 GO	LD	(HL),A
 	LD	A,8
 	CALL	DISPLY
 	DEC	L
 	XOR	A
 	CP	L
 	JR	NZ,GO
 	LD	(HL),0
 	JP	CXRDT1
 BASIC	LD	A,(BTEST)
 	CP	1
 	JP	Z,VIDDIS
 	LD	A,(40A2H)
 	CP	0FFH
 	JP	NZ,VIDDIS
 	LD	A,(40A3H)
 	CP	0FFH
 	JP 	NZ,VIDDIS
 	LD 	A,171
 	OUT	(0EAH),A
 	LD 	HL,BOOT
 	JP	4405H
 BOOT	DEFM	'BOOT'
 	DEFB	0DH
 BTEST	DEFB	1
 CLEAR	LD	B,A;THIS ROUTINE CHECKS TO SEE IF CLEAR
 	LD	A,(3840H);KEY IS HELD DOWN
 	BIT	1,A;IF IT IS THE SYSOP WANTS CONTROL
 	LD	A,B;RETURNS WITH X=3
 	RET	Z;YOU CAN TEST FOR THIS AND BRANCH
 	POP	HL;TO A SYSOP OPERATION OR SUCH
 	LD	HL,3
 	JP	0A9AH
 ;The following code resets the RS-232 port 300 - 8/N/1
 RS232	LD	A,00H
 	OUT	(0E8H),A	;Master reset of RS-232
 	LD	A,055H  	;Setup for 300 baud
 	OUT	(0E9H),A	;OUT 233,85
 	LD	A,06DH  	;Setup for 8/N/1
 	OUT	(0EAH),A	;OUT 234,109
 	LD	A,0ABH		;Setup to drop DTR
 	OUT	(0EAH),A	;OUT 234,171
 	LD	DE,MSGC
 	CALL	01C9H
 	CALL 	MSG
 	RET
 MSGC	DEFB	0AH
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	'Minihost/Cmd v3.3 (c)1985 Mike Bernstein'
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	' Program to remain in the PUBLIC DOMAIN'
 	DEFB	0AH
 	DEFB	0AH
 	DEFM	' Call The Kandy Shack at (714) 354-8004'
 	DEFB	0AH
 	DEFM	'       if you have any questions'
 	DEFB	0DH
 	DEFB	0AH
 	DEFB	0
 STRIP	AND	07FH	;STRIPS HI BIT
 	CP	060H	;CHECKS FOR <SHIFT @>
 	JP	Z,NULLIT
 	CP	1	;CHECKS FOR <BREAK>
 	JP	NZ,COMP
 NULLIT	XOR	A
 COMP	CP	0
 	JP	Z,KBDVR
 	RET
 PUTIT	LD	B,A	; Checks for BL=2 if it is then
 			; '*' will be echoed back
 	LD	A,(BLIND)
 	CP	2
 	JR	Z,USEIT
 	LD	A,B
 	RET
 USEIT	LD	A,'*'
 	RET
 	END	ENTRY
