 RS2D;-------------------------------------------------------------
; GTIME3/CMD converted by Mike Harrow [72507,2435]            
;                                                             
; Original program -- GETTIME/CMD -- Author Unknown           
; The original program was for the Model 4 and retrieved the  
; Time & Date from a Prometheus Promodem or an ADC MD1202.    
;                                                             
; This version is for the TRS80 Model 3 and USR Courier 2400. 
; The TRS80 clock is set from the Modem clock after execution 
;                                                             
; Included in this source is a Macro for Ldos 5.x that searchs
; the spare DCB's for a specific device. It is comparable to  
; the Model 4 SVC 82 (@GTDCB). This Macro is appropriately    
; called @GTDCB3.                                             
;                                                             
; You can use this Macro to find other User defined Devices   
; simply by changing #DEVNAME (2 Character String). I have    
; tried to make the exit conditions the same as the Model 4   
; @GTDCB.                                                     
;                                                             
; MACRO EXIT CONDITIONS:                                      
;    Success, Z flag set. DCB was found                       
;             HL = Pointer to start of DCB                    
;    Failure, NZ condition. No DCB was available              
;             A = Error 8 (device not available)              
;             HL is altered.                                  
;                                                             
; GENERAL: AF is always altered by this MACRO                 
;                                                             
; Acknowledgement to Guy Omer of 8/N/1 (904)377-1200 for      
; making available the original program and supplying the     
; exit conditions of the Model 4 SVC 82.                      
;                                                             
; WARNING: The USR Courier 2400 must be configured to Echo    
; Commands sent from the keyboard. Set dip switch 4 to the    
; UP position or from a terminal program send the command     
; < ATE1 >. Without the brackets. System will lockup if the   
; modem doesn't echo the keyboard commands                    
;-------------------------------------------------------------
@GTDCB3	MACRO	#DEVNAME	; Get Device Control Block Addr
	PUSH	BC		; Save BC for return
	PUSH	DE		; Save DE for return
	LD	DE,#DEVNAME	; D=2nd Char. E=1st Char.
	LD	HL,042F8H	; Addr. to start search
	LD	B,4		; Number of locations to search
COMP	LD	A,(HL)		; A = character in spare DCB's
	INC	HL		; HL => next char. in spare DCB
	CP	E		; compare E with A
	JR	Z,COMP2		; COMP2 if E and A match
	INC	HL		; HL => next char. in spare DCB
	DJNZ	COMP		; Loop till B=0 all DCB tested
	JR	FAULT		; search complete DCB not found
COMP2	LD	A,(HL)		; A => 2nd char. in spare DCB
	CP	D		; compare D with A
	JR	Z,MATCH		; If D=A then Device found
	INC	HL		; 2nd char. didn't match Inc HL
	DJNZ	COMP		; dec B - if not 0 keep testing
	JR	FAULT		; search complete DCB not found
MATCH	LD	A,0F9H		; A = LSB of First Spare DCB
	CP	L		; Check for address match
	JR	Z,SPARE1	; On match jump to SPARE1
	LD	A,0FBH		; A = LSB of Second Spare DCB
	CP	L		; Check for address match
	JR	Z,SPARE2	; On match jump to SPARE2
	LD	A,0FDH		; A = LSB of Third Spare DCB
	CP	L		; Check for address match
	JR	Z,SPARE3	; On match jump to SPARE3
	LD	A,0FFH		; A = LSB of Fourth Spare DCB
	CP	L		; Check for address match
	JR	Z,SPARE4	; On match jump to SPARE4
FAULT	LD	A,8		; A = Error Code 8
	CP	9		; Force NZ - NO DCB Available
	JR	RETURN		; Jump to Exit
SPARE1	LD	HL,042D4H	; HL = Spare DCB #1
	JR	RETURN		; Jump to Exit
SPARE2	LD	HL,042DAH	; HL = Spare DCB #2
	JR	RETURN		; Jump to Exit
SPARE3	LD	HL,042E0H	; HL = Spare DCB #3
	JR	RETURN		; Jump to Exit
SPARE4	LD	HL,042E6H	; HL = Spare DCB #4
RETURN	POP	DE		; Restore DE
	POP	BC		; Restore BC
	ENDM
;--------------------------------------------------------------
@GET	EQU	0013H		; Get byte from Device
@MSG	EQU	4402H		; Send message to Device
MULTEA	EQU	4B6BH		; Multiply (A * E)
;--------------------------------------------------------------
	ORG	5200H
START	@GTDCB3	'LC'		; Pass device name CL to Macro
	JR	NZ,DIRECT	; If no Device then go Direct
	LD	(DCB),HL	; DCB = HL = Device Control Buf
	LD	HL,REQUEST	; HL ==> Request time  ATI3(CR)
	LD	DE,(DCB)	; DE = DCB address
	CALL	@MSG		; Send Time request to Device
GETLUP	LD	DE,(DCB)	; DE ==> DCB address
	CALL	@GET		; Get byte from device
	JR	Z,GETLUP 	; Get again if no byte
	CP	0AH		; Compare byte to 0AH or LF
	JR	NZ,GETLUP	; Loop until Rx a LF
	LD	HL,INTAKE	; HL ==> INTAKE buffer
GETLUP2	CALL	@GET		; Get byte from device
	JR	Z,GETLUP2	; No byte - loop again
	LD	(HL),A		; Put Rx byte into Buffer
	INC	HL		; HL ==> next pos. in buffer
	CP	0AH		; Test for LF
	JR	NZ,GETLUP2	; Loop until LF
FLUSH	CALL	@GET		; Get byte - flush OK from DCB
	JR	Z,FLUSH 	; No byte - loop again
	CP	'K'		; Test for K in OK string
	JR	Z,FLUSH2	; Almost finished - test for CR
	JR	FLUSH		; Get next byte
FLUSH2	CALL	@GET		; Get byte - to flush last LF
	JR	Z,FLUSH2	; No byte - loop again
	CP	0AH		; Test for LF
	JR	NZ,FLUSH2	; Loop until Rx a LF
	JP	HOUR		; Jump to set time sys cntrl
REQUEST	DM	'ATI3',0DH	; Modem Command string
DCB	DW	0		; location for DCB address
INTAKE	DS	10		; Input Buffer
DIRECT	LD	A,0AAH		; A = Baud Rate 2400
	OUT	(0E8H),A	; RESET UART & Enable CR
	OUT	(0E9H),A	; Set Baud Rate
	LD	A,6CH		; A = 01101100
	OUT	(0EAH),A	; Set UART to 8/N/1
	LD	HL,REQUEST	; HL => Request time string
	LD	B,5		; B = Request string length
PAUSE1	IN	A,(0EAH)	; Get Status
	BIT	6,A		; Test Tx Register
	JR	Z,PAUSE1A	; Wait for Tx clear
	LD	A,(HL)		; A = next Request Char to Tx
	INC	HL		; HL ==> next Request Char.
	OUT	(0EBH),A	; Send byte to modem
PAUSE1A	IN	A,(0EAH)	; Get Status of UART
	BIT	7,A		; Test for Data Rx
	JR	Z,PAUSE1A	; Loop until Data Rx (Echo)
	IN	A,(0EBH)	; A = Data Rx
	DJNZ	PAUSE1		; Dec B and Loop until B=0
PAUSE2	IN	A,(0EAH)	; Get Status of UART
	BIT	7,A		; Test for Data Rx
	JR	Z,PAUSE2	; Loop until Data Rx (Echo)
	IN	A,(0EBH)	; A = Data Rx
	CP	0AH		; Test for LF
	JR	NZ,PAUSE2	; Loop until LF is Rxed
	LD	HL,INTAKE	; HL => Input Buffer
PAUSE3	IN	A,(0EAH)	; Get Uart Status
	BIT	7,A		; Test for data Rx
	JR	Z,PAUSE3	; Loop until data Rx
	IN	A,(0EBH)	; A = data Rx
	LD	(HL),A		; Put data in Buffer
	INC	HL		; HL => next pos. in Buffer
	CP	0AH		; Test for LF
	JR	NZ,PAUSE3	; Loop until end Modem reply
HOUR	LD	A,(INTAKE)	; A = 1st char. Rx from Modem
	SUB	'0'		; A = Dec value (tens of hour)
	LD	E,10		; E = 10 for multiplier
	CALL	MULTEA		; A = Dec value tens
	LD	B,A		; B = A
	LD	A,(INTAKE+1)	; A = 2nd char. Rx from Modem
	SUB	'0'		; A = Dec value (ones of hour)
	ADD	A,B		; A = Hour in Hex
	LD	(04219H),A	; Put Hour into TIME$ sys cntrl
MINUTE	LD	A,(INTAKE+3)	; A = 4th char. Rx from Modem
	SUB	'0'		; A = Dec value (tens of min.)
	LD	E,10		; E = 10 for multiplier
	CALL	MULTEA		; A = Dec value tens
	LD	B,A		; B = A
	LD	A,(INTAKE+4)	; A = 5th char. Rx from Modem
	SUB	'0'		; A = Dec value (ones of min.)
	ADD	A,B		; A = Minutes in Hex
	LD	(04218H),A	; Put Min. into TIME$ sys cntrl
SECOND	LD	A,(INTAKE+6)	; A = 7th char. Rx from Modem
	SUB	'0'		; A = Dec value (tens of sec.)
	LD	E,10		; E = 10 for Multiplier
	CALL	MULTEA		; A = Dec value tens
	LD	B,A		; B = A
	LD	A,(INTAKE+7)	; A = 8th char. Rx from Modem
	SUB	'0'		; A = Dec value (ones of sec.)
	ADD	A,B		; A = Seconds in Hex
	LD	(04217H),A	; Put Sec. into TIME$ sys cntrl
	RET			; Return to Dos - End Program
	DATE			; Insert Assemble Date
	TIME			; Insert Assemble Time
	END START
