;****************************************************************
;	GETIM5/ASM  - gets the date and time from a ADC Modem
;	and installs them as system time under LDOS 5.
;
;	Original program by Steven C. Jenkins (72407,2012)
;	for TRSDOS/LS-DOS 6 operating system; rewritten for
;	EDAS/MRAS assembler and LDOS operating system.
;
;	The value at the YEAR label should be corrected for the
;	current year and the string in the REQUEST label should
;	be changed to either AT@T or AT*T depending upon the
;	model of your DAK modem.
;				Jim Gaffney (70515,1036)
;****************************************************************
DATE$	EQU	421AH
TIME$	EQU	4217H
@EXIT	EQU	402DH
;================================================================
MULT8	MACRO			;8-bIt mulitply by 10
	PUSH	BC		;Save the registers
	PUSH	DE
	PUSH	HL
	ADD	A,A		;A times 2
	LD	H,A		;store it
	ADD	A,A		;A times 4
	ADD	A,A		;A times 8
	ADD	A,H		;A times 10
	POP	HL		;Restore the registers
	POP	DE
	POP	BC
	ENDM
;===============================================================
	ORG	5200H
START	LD	A,55H
	OUT	(0E8H),A		;UART Master reset
	OUT	(0E9H),A		;Baud rate generator - 300
	LD	A,6CH
	OUT	(0EAH),A		;To UART status register
	LD	HL,REQUEST		;Point to message to send
	LD	B,5			;Number of char to send
PAUSE1	IN	A,(0EAH)		;get status
	BIT	6,A			;check if ready
	JR	Z,PAUSE1		;loop until ready
	LD	A,(HL)			;load char to send
	INC	HL			;bump pointer
	OUT	(0EBH),A		;send out character
PAUSE1A	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE1A		;Loop until ready
	IN	A,(0EBH)		;UART transmit/holding reg.
	DJNZ	PAUSE1			;Loop until all char. sent
	LD	HL,INTAKE		;point to storage area
PAUSE2	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE2		;loop until ready
	IN	A,(0EBH)		;get a character
	CP	0AH			;LF?
	JR	NZ,PAUSE2		;flush echo-back
	LD	HL,INTAKE		;point to storage area again
PAUSE3	IN	A,(0EAH)		;get status
	BIT	7,A
	JR	Z,PAUSE3		;loop until ready
	IN	A,(0EBH)		;Input a character
	LD	(HL),A			;store it
	INC	HL			;Bump the pointer
	CP	0AH			;LF?
	JR	NZ,PAUSE3		;No, loop for another char.
STEP2	LD	A,(INTAKE)		;Read 1st month char
	CP	'0'			;Is is a zero?
	LD	B,0			;Store zero for tens digit
	JR	Z,MONTH1		; and go
	LD	B,10			;Else store 1 for tens digit
MONTH1	LD	A,(INTAKE+1)		;Get 2nd month character
	SUB	'0'			;Strip ASCII bias
	ADD	A,B			;add in the appropriate tens digit
	LD	B,A			;Month is in reg. B in hex
	LD	A,(INTAKE+3)		;Get 1st day character
	SUB	'0'			;Strip ASCII bias
	PUSH	BC			;Save month
	MULT8				;Mult. 1st day character by ten
	POP	BC			;Restore month
	LD	C,A			;put 1st day character in C
	LD	A,(INTAKE+4)		;get 2nd day character
	SUB	'0'			;Strip ASCII bias
	ADD	A,C			;Add back in 1st day character
	LD	C,A			;Day is in reg. C in hex
	LD	IX,DATE$
	LD	A,(YEAR)		;get year
	LD	(IX),A			;store it
	LD	(IX+1),C		;stuff it there
	LD	(IX+2),B		;and stuff THAT too.
	LD	A,(INTAKE+6)		;get 1st hour digit
	CP	'0'			;is 1st digit a zero
	LD	B,0			;store zero for tens digit
	JR	Z,HOUR1			;and go
	LD	B,10			;else store 1 for tens digit
HOUR1	LD	A,(INTAKE+7)		;get 2nd hour digit
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;add back in the tens digit
	LD	B,A			;Hour is in B register
	LD	A,(INTAKE+15)		;get AM/PM character
	CP	'A'			;Is it an A?
	LD	A,0			;add no 24 hour clock bias
	JR	Z,HOUR2			;and go
	LD	A,12			;else correct for P.M.
HOUR2	ADD	A,B			;add appropriate bias
	CP	12			;Is time midnite -> 1 a.m.?
	JR	NZ,CHK24		;No, check for noon
	SUB	12			;Change hour back to "00"
	JR	TIMOUT			;and continue on
CHK24	CP	24			;Is hour noon ->1 p.m.?
	JR	NZ,TIMOUT		;No, continue on
	SUB 12				;Change hour back to "12"
TIMOUT	LD	B,A			;now in 24-hr format
	LD	IX,TIME$
	LD	(IX+2),B		;get the hour done.
	LD	A,(INTAKE+9)		;get 1st minutes character
	SUB	'0'			;Strip the ASCII bias
	MULT8				;Multipy it by 10
	LD	B,A			;Put it into B
	LD	A,(INTAKE+10)		;get 2nd minutes character
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;Add in the tens digit
	LD	(IX+1),A		;stuff the minutes in.
	LD	A,(INTAKE+12)		;get the 1st seconds character
	SUB	'0'			;strip the ASCII bias
	MULT8				;multiply it by 10
	LD	B,A			;and save it in B
	LD	A,(INTAKE+13)		;get the 2nd seconds digit
	SUB	'0'			;strip the ASCII bias
	ADD	A,B			;Add back in the tens digit
	LD	(IX),A			;and stuff the seconds into place.
	XOR	A			;zero the accumulator
	LD	HL,0			;and the HL register
	CALL	@EXIT			;and jump back to DOS
YEAR	DB	87			;change to match current year
REQUEST	DB	'AT*T',13		; String must match your Modem type
DUMBUF	DB	'         '		;DUMMY BUFFER
DCB	DW	0			;DCB for Modem
INTAKE	DS	30			;storage for DOS date/time
	END	START
D