FIXHIT00100 ;	       FIXHIT/ASM - Version 1.0
00110 ;	         NEWDOS80/V2  (III)
00120 ;	          2nd February 1985
00130 ;        For NORTHERN BYTES & the PUBLIC DOMAIN
00140 ;                  by Tony Domigan
00150 ;  PO Box 150, Thomastown, Victoria, 3074, Australia
00160 ;MCI-ID:2545121. SOURCE-ID:BCT039. TAB-ID:DOMIPOBOWINN
00170 ;------------------------------------------------------
00180 ;         	Pointers used in FIXHIT
00190 ;  B  = FPDE counter     BC' = FPDE & Page counters
00200 ;  DE = New HIT row ptr	 DE' = New HIT column ptr
00210 ;  HL = Buffer FPDE ptr	 HL' = FCB buffer (first FPDE)
00220 ;  IX = OLD HIT row ptr  IY  = OLD HIT column ptr
00230 ;------------------------------------------------------
00240 ;
00250 	ORG	5200H		;Anywhere abv 5200H
00260 ;------------------------------------------------------
00270 ;	**TEST FOR DRIVESPEC**
00280 ;------------------------------------------------------
00290 PARSER	EQU	$
00300 	LD	A,(HL)		;Trailing chars?
00310 	CP	0DH		;Assume drive 0?
00320 	JR	Z,BANNER	;Yes, print msg
00330 	CP	3AH		;Colon
00340 	JR	NZ,NUMBER	;Skip if not colon
00350 	INC	HL		;Yes, colon so ck next
00360 	LD	A,(HL)		;Get next character
00370 NUMBER	CP	34H		;> Drive 3?
00380 	JR	NC,BADNUM	;Yes, bad drive number
00390 	CP	30H		;>=0and<=3
00400 	JR	NC,POSTDR	;Yes, use drive number
00410 BADNUM	LD	A,0A0H		;Illegal drive number
00420 	JP	4409H		;Error exit
00430 POSTDR	LD	(DRIVE),A	;Post drv num to FCB
00440 	LD	(DRVNUM),A	;Post drv num to banner
00450 	LD	(WRPDRV),A	;Post drive to WRDIRP,n
00460 ;------------------------------------------------------
00470 ;	**DISPLAY BANNER**
00480 ;------------------------------------------------------
00490 BANNER	EQU	$
00500 	CALL	01C9H		;CLS
00510 	LD	HL,BANMSG	;Pt to msg
00520 	CALL	4467H		;Display msg
00530 ;------------------------------------------------------
00540 ;	**OPEN DIR/SYS OF NOMINATED DRIVE**
00550 ;------------------------------------------------------
00560 OPEN	EQU	$
00570 	LD	HL,BUFF1	;FCB buffer
00580 	LD	DE,FCB		;Pt to my FCB
00590 	LD	B,00H		;LRL=Full sector I/O
00600 	CALL	4424H		;OPEN	DIR/SYS
00610 	JP	NZ,EREXIT	;Z=No error
00620 	LD	A,(LEN)		;File length from FCB
00630 	SUB	02H		;REL Count=EOF-HIT
00640 	LD	C,A		;Post page counter to C
00650 ;------------------------------------------------------
00660 ;	**SETUP POINTERS**
00670 ;------------------------------------------------------
00680 SETUP	EQU	$
00690 	LD	B,08H		;FPDE Slots 0-7
00700 	LD	DE,BUFF2	;New HIT Buffer
00710 	LD	IX,BUFF3	;Old HIT Buffer
00720 	PUSH	BC		;Save slot/page count
00730 	PUSH	DE		;Save new HIT buff addr
00740 	PUSH	HL		;Save FCB buffer addr
00750 	PUSH	IX		;Save old HIT buff addr
00760 	POP	IY		;IY=IX
00770 	EXX			;Switch to AF',BC',HL'
00780 	POP	HL		;HL' = HL
00790 	POP	DE		;DE' = DE
00800 	POP	BC		;BC' = BC
00810 	EXX			;Switch to orig set
00820 ;------------------------------------------------------
00830 ;	**POSITION TO HIT SECTOR**
00840 ;------------------------------------------------------
00850 INIT	EQU	$
00860 	CALL	READ		;Read GAT sector
00870 	CALL	READ		;Read HIT sector
00880 ;------------------------------------------------------
00890 ;	**PREPARE BUFFERS**
00900 ;------------------------------------------------------
00910 SETBUF	EQU	$
00920 	PUSH	BC		;Save counters
00930 	PUSH	HL		;Save FCB buff addr
00940 	PUSH	DE		;Save BUFF1 addr
00950 	PUSH	DE		;Again
00960 	PUSH	IX		;Move IX ..
00970 	POP	DE		;to DE (buff3)
00980 	LD	BC,256		;Full sector
00990 	PUSH	BC		;Save it
01000 MOVOLD	LDIR			;Mv orig buffer to buff3
01010 	POP	BC		;Ret byte count
01020 	DEC	BC		;Minus 1
01030 	POP	DE		;Save buff2 addr
01040 	INC	DE		;Plus 1
01050 	LD	(HL),00H	;Load 0 to 1st byte
01060 MAKNEW	LDIR			;Zero buffer 2
01070 	POP	DE		;Restore buff3 addr
01080 	POP	HL		;Restore FCB buff1 addr
01090 	POP	BC		;Restore FPDE/PAGE count
01100 	LD	A,(LEN)		;Length of DIR/SYS
01110 	SUB	10		;= Extra allocation
01120 	LD	(BUFF2+1FH),A	;Replace allocation
01130 ;------------------------------------------------------
01140 ;	**BEGIN LOOP FPDE PAGES**
01150 ;------------------------------------------------------
01160 PAGE	EQU	$
01170 	CALL	READ		;Read fpde page to buff1
01180 ;------------------------------------------------------
01190 ;	**LOOP FOR 8 FPDE SLOTS PER FPDE PAGE **
01200 ;------------------------------------------------------
01210 FPDE	EQU	$
01220 	LD	A,(HL)		;1st byte of fpde
01230 	CP	00H		;Not allocated?
01240 	JR	Z,NXSLOT	;Skip if not allocated
01250 	CP	90H		;FXDE?
01260 	JR	NZ,HASHIT	;No, make hash code
01270 	LD	A,(IX+0)	;Use orig hash code
01280 	JR	FIXIT		;Post to new HIT
01290 ;------------------------------------------------------
01300 ;	**MAKE HASH CODE FROM FILESPEC**
01310 ;------------------------------------------------------
01320 HASHIT	EQU	$
01330 	PUSH	HL		;Save slot pointer
01340 	PUSH	BC		;Save slot counter
01350 	LD	A,L		;LSB of FPDE
01360 	ADD	A,05H		;Increment by five
01370 	LD	L,A		;HL-->Filespec
01380 STHASH	LD	B,0BH		;Filsespec & Ext
01390 	XOR	A		;Zero accum
01400 HLOOP	XOR	(HL)		;XOR (HL) with accum
01410 	INC	HL		;Next char in filespec
01420 	RLCA			;Rotate left result in A
01430 	DJNZ	HLOOP		;Loop for 11 characters
01440 	CP	00H		;Hash = 0
01450 	JR	NZ,HASHOK	;Skip if not 0
01460 	INC	A		;Zero not allowed
01470 HASHOK	POP	BC		;Restore slot counter
01480 	POP	HL		;Restore FPDE pointer
01490 FIXIT	LD	(DE),A		;Post code to new HIT
01500 ;------------------------------------------------------
01510 ;	**POSITION TO NEXT FPDE SLOT IN PAGE**
01520 ;------------------------------------------------------
01530 NXSLOT	EQU	$
01540 	PUSH	BC		;Save slot counter
01550 	PUSH	DE		;Move new HIT row counter
01560 	POP	BC		;To BC
01570 	LD	DE,20H		;Incr all slots by 32
01580 	ADD	HL,DE		;FCB row = +32
01590 	PUSH	HL		;Save HL
01600 	ADD	IX,DE		;Old HIT row = +32
01610 	PUSH	BC		;Move old DE to
01620 	POP	HL		;to HL so that
01630 	ADD	HL,DE		;New HIT = +32
01640 	EX	DE,HL		;Xfer back to DE
01650 	POP	HL		;Recover FCB slot addr
01660 	POP	BC		;Recover slot count
01670 	DJNZ	FPDE		;Loop for 8 slots
01680 ;------------------------------------------------------
01690 ;	**LOOP FOR ALL FPDE PAGES**
01700 ;------------------------------------------------------
01710 NXFPDE	EQU	$
01720 	EXX			;AF', BC', HL'
01730 	DEC	C		;Decrement page count
01740 	JR	Z,HITCK		;Finished, check hit sr's
01750 	INC	DE		;Bump new hit column ptr
01760 	INC	IY		;Bump old hit column ptr
01770 	PUSH	BC		;Save
01780 	PUSH	DE		; new
01790 	PUSH	HL		;  pointers
01800 	PUSH	IY		;   to stack
01810 	EXX			;Non-prime registers
01820 	POP	IX		;Restore
01830 	POP	HL		; New pointers
01840 	POP	DE		;  To the native
01850 	POP	BC		;   Registers
01860 	JR	PAGE		;Loop till next page
01870 ;------------------------------------------------------
01880 ;	**COMPARE OLD & NEW HIT SECTORS**
01890 ;------------------------------------------------------
01900 HITCK	EQU	$
01910 	LD	IX,0000H	;Non-match counter
01920 	LD	HL,BUFF2	;New hash table
01930 	LD	DE,BUFF3	;Old hash table
01940 	LD	B,00H		;256 bytes
01950 CKLOOP	LD	A,(DE)		;Get old hash code
01960 	CP	(HL)		;Compare with new
01970 	JR	Z,SAME		;Skip if the same
01980 	INC	IX		;Bump error count
01990 SAME	INC	HL		;Next new hash code
02000 	INC	DE		;Next old hash code
02010 	DJNZ	CKLOOP		;Loop for whole table
02020 	PUSH	IX		;Move error count
02030 	POP	DE		;to DE
02040 	LD	A,E		;Errors always <256
02050 	LD	HL,ERRNUM	;Point to error num $
02060 	PUSH	AF		;Save error count
02070 	CALL	44D7H		;Load to string
02080 	LD	HL,ERRNUM	;Point to error msg
02090 	CALL	4467H		;Display num errors
02100 	POP	AF		;Restore num errors
02110 	CP	00H		;No errors?
02120 	JR	Z,CLOSE		;Yes, omit fix rtne
02130 	LD	HL,WRPRMT	;Fix Y/N Msg
02140 	CALL	4467H		;Display msg
02150 	CALL	49H		;KBWAIT
02160 	OR	20H		;Cvrt to l/c
02170 	CP	79H		;yes?
02180 	JR	Z,YES		;then fixit
02190 	XOR	A		;Zero accum
02200 	LD	(RCOUNT),A	;Stop RP fix
02210 NO	LD	HL,NWMSG	;Abort msg
02220 	CALL	4467H		;Display it
02230 	JR	CLOSE		;JP over write rtne
02240 YES	LD	HL,WRMSG	;Write message
02250 	CALL	4467H		;Display it
02260 ;------------------------------------------------------
02270 ;	**POSITION TO HIT SECTOR**
02280 ;------------------------------------------------------
02290 	LD	DE,FCB		;Pt to FCB
02300 	LD	HL,BUFF1	;Pt to FCB buffer
02310 	LD	A,0C9H		;Patch RET NZ to RET
02320 	LD	(NOERR),A	;To stop dupe err msg
02330 SOF	CALL	443FH		;Move to start of file
02340 GAT	CALL	READ		;Read GAT
02350 ;------------------------------------------------------
02360 ;	**MOVE NEW HIT TO FCB BUFFER**
02370 ;------------------------------------------------------
02380 MOVE	LD	HL,BUFF2	;New HIT buffer
02390 	LD	DE,BUFF1	;FCB buffer
02400 	LD	BC,256		;Bytes to move
02410 	LDIR			;Xfer it
02420 ;------------------------------------------------------
02430 ;	**PREPARE FCB FOR READ-PROTECT WRITE**
02440 ;------------------------------------------------------
02450 	LD	A,(FCB)		;FCB 1st byte
02460 	OR	01H		;Make read-protect
02470 	LD	(FCB),A		;Ammend FCB
02480 	LD	A,(FCB+1)	;FCB 2nd byte
02490 	OR	40H		;Do not update EOF
02500 	LD	(FCB+1),A	;Ammend FCB
02510 ;------------------------------------------------------
02520 ;	**WRITE WITH VERIFY**
02530 ;------------------------------------------------------
02540 WRITE	EQU	$
02550 	LD	HL,BUFF1	;FCB buffer
02560 	LD	DE,FCB		;DE --> FCB
02570 	LD	B,00H		;LRL=256
02580 	CALL	443CH		;Write with verify
02590 	JR	Z,CLOSE		;Exit if no error
02600 EREXIT	OR	80H		;Make long err msg
02610 	CALL	4409H		;Display error msg
02620 ;------------------------------------------------------
02630 ;	**CLOSE FCB**
02640 ;------------------------------------------------------
02650 CLOSE	EQU	$
02660 	CALL	4428H		;Close FCB
02670 	LD	A,(RCOUNT)	;How many rp errs?
02680 	CP	00H		;No errors?
02690 	JP	Z,402DH		;Exit if so
02700 	LD	HL,RCOUNT	;Rp err no $
02710 	CALL	44D7H		;Move to $
02720 	LD	HL,RPTMSG	;Pt to err num $
02730 	CALL	4467H		;Disp msg
02740 	LD	HL,WRDIRP	;WRDIRP CMD
02750 	JP	4405H		;Execute WRDIRP,n
02760 ;------------------------------------------------------
02770 ;	**READ SECTOR**
02780 ;------------------------------------------------------
02790 READ	EQU	$
02800 	PUSH	BC		;Save slot count
02810 	PUSH	HL		;Save slot pointer
02820 	PUSH	DE		;Save new hit ptr
02830 	LD	HL,BUFF1	;FCB buffer
02840 	LD	DE,FCB		;FCB
02850 	LD	BC,0000H	;LRL=256
02860 	CALL	4436H		;Read sector
02870 	POP	DE		;Restore new row ptr
02880 	POP	HL		;Restore fcb row ptr
02890 	POP	BC		;Restore slot count
02900 	PUSH	AF		;Save error count
02910 	CP	1CH		;EOF?
02920 	JP	Z,EREXIT	;Error exit
02930 	CP	1DH		;Past EOF?
02940 	JP	Z,EREXIT	;Error exit
02950 	POP	AF		;Restore error code
02960 NOERR	RET	NZ		;Continue if NZ
02970 ;------------------------------------------------------
02980 ;	**READ-PROTECT ERROR**
02990 ;------------------------------------------------------
03000 NRPERR	EQU	$
03010 	LD	A,(NEXT)	;Get next pointer
03020 	DEC	A		;Pt to last sector read
03030 	PUSH	HL		;Save FCB ptr
03040 	LD	HL,RPSR		;Sector num
03050 	CALL	44D7H		;Post to $
03060 	LD	HL,NRPMSG	;Nr msg
03070 	CALL	4467H		;Display it
03080 	LD	HL,RCOUNT	;NR error count
03090 	INC	(HL)		;Bump counter
03100 	POP	HL		;Restore FCB ptr
03110 	RET			;Continue processing
03120 ;------------------------------------------------------
03130 ;	**STRINGS AND STORAGE**
03140 ;------------------------------------------------------
03150 BANMSG	DEFM	'FIXHIT for NEWDOS80/V2 - Drive on Test --> '
03160 DRVNUM	DEFM	'0'
03170 	DEFB	0AH
03180 	DEFB	0DH
03190 ERRNUM	DEFM	'  H '
03200 	DEFM	'Hash code Errors '
03210 	DEFB	0AH
03220 	DEFB	0DH
03230 WRPRMT	DEFM	'Reply Y/N to Repair Diskette Hash Code Table -->'
03240 	DEFB	0AH
03250 	DEFB	0DH
03260 WRMSG	DEFM	'Writing the Corrected Hit Sector Now'
03270 	DEFB	0DH
03280 NWMSG	DEFM	'**ABORTING** Per Request'
03290 	DEFB	0DH
03300 NRPMSG	DEFM	'DIR/SYS FRS : '
03310 RPSR	DEFM	'00 '
03320 	DEFM	'is NOT READ-PROTECTED'
03330 	DEFB	0AH
03340 	DEFB	0DH
03350 WRDIRP	DEFM	'WRDIRP,'
03360 WRPDRV	DEFB	30H
03370 	DEFB	0DH
03380 RPTMSG	DEFM	'Read-Protecting '
03390 RCOUNT	DEFB	00H
03400 	DEFB	00H
03410 	DEFM	'H '
03420 	DEFM	'Directory Sectors'
03430 	DEFB	0DH
03440 ;------------------------------------------------------
03450 ;	** F C B **
03460 ;------------------------------------------------------
03470 FCB	DEFM	'DIR/SYS:'	;Filespec
03480 DRIVE	DEFM	'0'		;Drivespec
03490 	DEFB	0DH
03500 NEXT	DEFB	00H		;Next sector pointer
03510 	DEFB	00H
03520 LEN	DEFB	00H		;LSB length of file
03530 	DEFB	00H
03540 LUMP	DEFB	00H		;Starting lump
03550 GRAN	DEFB	00H		;Number of grans
03560 EXT	DEFS	10H		;Extents
03570 ;------------------------------------------------------
03580 ;	**STORAGE BUFFERS**
03590 ;------------------------------------------------------
03600 BUFF1	DEFS	256		;FCB buffer
03610 BUFF2	DEFS	256		;New HASH CODE buffer
03620 BUFF3	DEFS	256		;Orig HIT sector
03630 	END	PARSER
-----------------------------
03580 ;	**STORAGE BUFFERS**
03590 ;------------------------------------------------------
