; filter/asm - kjw/bqsd - 07/82
;
EVAL	EQU	83		;evaluate input line
OPEN	EQU	40		;open device/file
GET	EQU	77		;input a byte
VALUE	EQU	89		;fetch value from string
;
SVC	EQU	08H		;execute SVC
OVLY	EQU	18H		;execute overlay
;
ERR87	EQU	87		;invalid data
ERR47	EQU	47		;required not found
ERR68	EQU	68		;invalid devicespec
ERR72	EQU	72		;protected system dev
ERR09	EQU	09		;invalid data
ERR66	EQU	66		;no function exists
ERR28	EQU	28		;end of file
ERR29	EQU	29		;out of range
;
DATAK7	EQU	0173H		;top of memory
HIMEM	EQU	DATAK7
FETMEM	EQU	0330H		;allocate top memory
LOCDCB	EQU	032AH		;load IX with DCB
;
;
;	$FILTER - setup/display translation table
;
;	FILTER FROM devicespec TO channel (set filter)
;	FILTER FROM devicespec		  (display flt)
;	FILTER FROM devicespec,switch	  (turns on/off)
;
;	/FLT default extension
;
;	devicespec must evaluate to device 0-4 ONLY
;	channel must be a single char oriented path
;	switch can be ON OFF YES NO
;
;	shorthand
;
;	FILTER @ki datafile
;	FILTER @ki
;	FILTER @ki,n
;
FILTER	LD	A,80H		;setup params
	LD	(FLTPON),A	;ON param
	LD	(FLTPOF),A	;OFF param
	XOR	A		;set NOP opcode
	LD	(FLTVEC),A	;for display of settings
;
	LD	IX,FBLCK	;evaluation block
	LD	A,EVAL		;SVC #
	RST	SVC		;fetch params
	JR	NZ,POSTEY	;post error!
;
;	check for source device
;
	LD	A,ERR47 	;required parameter
	BIT	2,(IX)		;source here?
	JP	Z,POSTE		;go error
;
	LD	A,(DCB@1)	;get source channel
	LD	B,ERR68 	;invalid device
	BIT	7,A		;device issued?
	JP	Z,POSTEB	;no, go!
;
	LD	B,ERR72 	;protected device
	AND	0FH		;fetch device number
	CP	5		;device 0-4 ONLY!
	JP	NC,POSTEB	;no, go!
	LD	(FLTDEV),A	;save the device number
;
	BIT	1,(IX+0)	;dest field evaluated?
	JR	Z,CKFLG 	;check on/off flag
;
;	setup destination path
;
	LD	DE,DCB@2+1	;dest DCB
	LD	HL,EXT2 	;/FLT extension
	LD	A,FEXT		;add extension
	RST	SVC		;add it
;
	LD	HL,FOLIST	;filter open list
	LD	A,OPEN		;SVC #
	RST	SVC		;open up the channel
POSTEY	JR	NZ,POSTEV	;error, abort
;
;	reclaim old top memory if used
;
	LD	A,(FLTDEV)	;get device
	CALL	LOCDCB		;find the DCB
	LD	A,(IX+8)	;any table here now?
	OR	A		;yes?
	JR	Z,GOFILTER	;nope, go!
	LD	L,A		;pass to HL
	LD	H,0		;HL = counter
	ADD	HL,HL		;HL = buffer size
	LD	B,H		;pass to BC
	LD	C,L
	LD	L,(IX+6)	;get table address
	LD	H,(IX+7)
	CALL	RECMEM		;attempt to reclaim mem
;
GOFILTER LD	E,0		;clear entry counter
	LD	IX,(HIMEM)	;fetch topmem
;
;	code for setup of filter here!
;
FLTLOAD CALL	FLTLINE 	;fetch a line
	JR	NZ,POSTEV	;display the error
	JR	C,FLTDONE	;input complete, go!
;
;	interpret the input line
;
	INC	E		;bump entry counter
	LD	(IX-1),B	;source byte
	LD	(IX),C		;xlate byte
;
	DEC	IX		;dec pointer
	DEC	IX		;byte 2
	JR	FLTLOAD 	;go more!
;
;	filter loaded, set it up
;
FLTDONE LD	H,0		;get counter
	LD	L,E		;HL = entry counter
	ADD	HL,HL		;*2 (2 byte entries)
	LD	B,H		;give to BC
	LD	C,L		;BC = needed size
	CALL	FETMEM		;fetch memory
POSTEV	JP	NZ,POSTE	;insufficient memory
;
	LD	A,(FLTDEV)	;get device #
	CALL	LOCDCB		;load DCB into IX
	LD	(IX+6),L	;xlate table start
	LD	(IX+7),H	;MSB start
	LD	(IX+8),E	;# of entries
;
;	disable setting display
;
	LD	A,0C9H		;RET opcode
	LD	(FLTVEC),A	;put into code
;
;	check for ON, OFF setting
;
CKFLG	LD	A,0		;get device
FLTDEV	EQU	$-1
	CALL	LOCDCB		;load IX with DCB
;
	LD	A,(FLTPOF)	;get OFF param
	INC	A		;OFF=ON?
	JR	Z,FLTOFF	;yes, turn off
	DEC	A		;OFF=OFF?
	JR	Z,FLTON 	;yes, turn on
;
	LD	A,(FLTPON)	;get ON param
	INC	A		;ON=ON?
	JR	Z,FLTON
	DEC	A		;ON=OFF?
	JR	Z,FLTOFF	;yes, go
;
FLTON	LD	A,(IX+8)	;get table length
	OR	A		;anything?
POSTEW	LD	A,ERR66 	;no function exists
	JP	Z,POSTE 	;post the error
	SET	0,(IX+5)	;else turn it on
	JR	FLTCNT		;continue
;
FLTOFF	RES	0,(IX+5)	;turn it off
;
FLTCNT	XOR	A		;set ZERO
FLTVEC	NOP			;return placed here
;
;	display settings of current filter
;
	LD	A,(IX+8)	;get filter length
	OR	A		;any length?
	JR	Z,POSTEW	;no function
;
;	display table location and length
;
	LD	E,A		;give to DE
	LD	D,0		;DE = # entries
	LD	HL,MES4		;temp storage
	LD	B,D		;command - bin>ascii
	LD	A,BINDEC	;to decimal
	RST	SVC		;convert it
	INC	HL		;bump pointer
	INC	HL
	LD	DE,FLTMSG2	;where it goes in text
	LD	BC,3		;length
	LDIR			;move to string
;
	LD	E,(IX+6)	;table address
	LD	D,(IX+7)
	LD	HL,FLTMSG	;text
	LD	B,A		;command - bin>ascii
	LD	A,BINHEX	;SVC #
	RST	SVC		;fill string
;
;	output device number and name
;
	LD	A,'$'		;relative device #
	CALL	DSP$		;display it
	JR	NZ,POSTERX	;go error!
	LD	A,(FLTDEV)	;get device
	LD	C,A		;save here
	CALL	OUTHEX		;out 2 digits
	JR	NZ,POSTERX	;error
	CALL	OUTSP		;space
	JR	NZ,POSTERX	;error
	LD	A,(FLTDEV)	;get device back
	ADD	A,A		;*2
	ADD	A,A		;*4
	LD	L,A		;lsb
	LD	H,DEVTBL<-8	;msb
	PUSH	IX		;save DCB
	PUSH	HL		;pass to IX
	POP	IX		;IX + 2 => name
	CALL	DNAME		;display name
	POP	IX		;restore DCB
POSTERX	JP	NZ,POSTE	;display error
;
	LD	HL,FLTMSG	;message
	CALL	LINE$		;display it
	JR	NZ,POSTERX	;go error
;
;	table is created backwards
;	let's display it the same way
;
	LD	C,(IX+6)	;get table address
	LD	B,(IX+7)
	LD	L,(IX+8)	;table length
	LD	H,0		;MSB chars filtered
	ADD	HL,HL		;HL = length of table
	ADD	HL,BC		;HL => end byte
;
;	looper to display the filter settings
;
	LD	B,(IX+8)	;# entries
FLTLOOP LD	E,5		;5 per line
;
FLTLP	DEC	HL		;less one entry
	DEC	HL
	LD	A,(HL)		;fetch a character
	INC	HL		;bump to next
	CALL	DSPFLT		;display it
POSTER	JP	NZ,POSTE	;error!
;
	LD	A,'='           ;between char
	CALL	DSP$		;display it
	JR	NZ,POSTER	;error!
;
	LD	A,(HL)		;fetch char
	DEC	HL		;put it back
	CALL	DSPFLT		;display it
	JR	NZ,POSTER	;error!
;
	PUSH	BC		;save counter
	CALL	DSPSEP		;separators
	POP	BC		;get counter
	JR	NZ,POSTER	;error!
;
;	check for completed
;
	DEC	B		;less counter
	JR	Z,FLTDON	;finished, send C/R
;
;	check for row end
;
	DEC	E		;less row count
	JR	NZ,FLTLP	;go if not at end
	LD	A,CR		;else send a C/R
	CALL	DSP$		;display it
	JR	NZ,POSTER	;error, abort
	JR	FLTLOOP 	;else next line
;
;	completed, send CR and return
;
FLTDON	LD	A,CR		;CR
	CALL	DSP$		;display it
	JR	NZ,POSTER	;error!
	XOR	A		;set ZERO
	RET			;back to caller
;
;	display character in format:
;	A(41H)	  period used for non-display ascii
;
DSPFLT	LD	C,A		;save char
	CP	20H		;displayable?
	JR	NC,DSPFOK	;ok, continue
	LD	A,'.'           ;default character
DSPFOK	CALL	DSP$		;display the ascii char
	RET	NZ		;error, return
;
	LD	A,'('           ;display paren
	CALL	DSP$		;display it
	RET	NZ		;error, return
;
	LD	A,C		;get original value back
	CALL	OUTHEX		;output 2 hex digits
	RET	NZ		;error
;
	LD	A,')'           ;close paren
	CALL	DSP$		;display it
	RET			;done, Z = status
;
;	output 2 hex digits from A = ascii
;
OUTHEX	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	OUTONE		;output a character
	RET	NZ		;error
	LD	A,C		;fetch char again
;
;	convert digit and output
;
OUTONE	AND	0FH		;mask it off
	ADD	A,'0'           ;add the ascii
	CP	'9'+1           ;0-9?
	JR	C,OUTOK 	;yes, no adjust
	ADD	A,7		;adjust for A-F
OUTOK	JP	DSP$		;display the character
;
;	output separator gap between
;
DSPSEP	LD	B,4		;4 SPACES
	CALL	OUTSP		;do it!
	RET	NZ		;if error
	DJNZ	$-4		;til done
	RET
;
FLTLINE	CALL	FLTLINS		;fetch source info
	RET	NZ		;error, return
	RET	C		;done, return
	LD	B,A		;save source
;
	CALL	FLTLIND		;fetch dest info
	RET	NZ		;error, return
	RET	C		;done, return
	LD	C,A		;save xlate byte
	RET			;done, B C = source/xlate
;
FLTLINS	CALL	FLTCHR		;get a character
	RET	NZ		;error!
	RET	C		;end of file or ETX!
;
	CP	'.'		;remark line?
	JR	Z,FLTREM	;remove it!
;
	CALL	CKGAP		;separator?
	JR	Z,FLTLINS	;go till significant
;
	CALL	IFSTR		;string?
	JR	Z,FLTSTR	;yes, fetch it
;
;	fetch value of entry from file
;
	LD	HL,DCB@1	;re-use DCB for data
	LD	(HL),A		;put first char in
	INC	HL		;bump pointer
;
FLTVALS	CALL	FLTCHR		;fetch a character
	RET	NZ		;error
	RET	C		;done
	CP	'='		;done?
	JR	Z,FOREND	;yes, force value end
	LD	(HL),A		;else put in buffer
	INC	HL		;bump pointer
	JR	FLTVALS		;get more chars
;
FOREND	LD	(HL),CR		;terminate input
	LD	HL,DCB@1	;start of entry
	PUSH	BC		;save it
	LD	A,VALUE		;SVC #
	RST	SVC
	JR	NZ,FORBAD	;error, return
	LD	A,C		;else fetch LSB
FORBAD	POP	BC		;unstack
	RET			;return status
;
FLTSTR	CALL	FLTCHR		;fetch character
	RET	NZ
	RET	C
	LD	C,A		;save char
;
	CALL	FLTCHR		;fetch another
	RET	NZ
	RET	C
	CP	'='		;equator?
	JR	Z,STROKS	;yes, done!
	CALL	IFSTR		;string marker?
	LD	A,ERR87		;invalid member
	RET	NZ		;nope, return
;
	CALL	FLTCHR		;get another
	RET	NZ
	RET	C
	CP	'='		;must be this
	LD	A,ERR87		;invalid
	RET	NZ		;error
STROKS	LD	A,C		;else fetch byte
	RET			;return Z
;
FLTREM	CALL	FLTCHR		;fetch character
	RET	NZ
	RET	C
	CP	CR		;end of line?
	JR	NZ,FLTREM	;keep removing it
	JR	FLTLINS		;start next line
;
FLTLIND	CALL	FLTCHR		;get char
	RET	NZ
	RET	C
;
	CALL	IFSTR		;string?
	JR	Z,FLTSTRD	;get string
;
;	fetch value of entry
;
	LD	HL,DCB@1	;re-use DCB
	LD	(HL),A		;save first char
	INC	HL		;bump pointer
;
FLTVALD	CALL	FLTCHR		;get char
	RET	NZ
	RET	C
	CALL	CKGAP		;end of value?
	JR	Z,FOREND	;yes, done!
	LD	(HL),A		;else put in string
	INC	HL		;bump pointer
	JR	FLTVALD		;next char
;
FLTSTRD	CALL	FLTCHR		;get char
	RET	NZ
	RET	C
;
	LD	C,A		;save char
	CALL	FLTCHR		;get next char
	RET	NZ
	RET	C
	CALL	CKGAP		;separator?
	JR	Z,STROKD	;yes, done!
	CALL	IFSTR		;string marker?
	LD	A,ERR87		;invalid data set member
	RET	NZ		;nope, error
;
STROKD	LD	A,C		;re-fetch char
	RET			;return Z
;
FLTCHR	PUSH	DE		;save counter
	PUSH	BC		;need for $GET
	LD	DE,DCB@2+1	;DCB for input channel
	LD	A,GET		;SVC #
	RST	SVC		;fetch a character
	LD	(CHRSAV),BC	;save char
	POP	BC		;restore
	POP	DE		;restore stack
	JR	Z,FLTOK 	;no error, go!
;
;	check for EOF
;
	CP	ERR28		;end of file?
	SCF			;set end of file
	RET	Z		;yes, return
	CP	ERR29		;out of range?
	SCF			;set end of file
	RET	Z		;yes, return
	OR	A		;clear carry, set NZ
	RET			;return in error
;
;	check for EOT
;
FLTOK	LD	A,(CHRSAV+1)	;get character
	CP	ETX		;EOT?
	SCF			;set end of data
	RET	Z		;yes, return
;
	CP	A		;set zero, no carry
	RET			;done, A = char
;
;	check for string indicator
;
IFSTR	CP	'"'             ;quote?
	RET	Z		;yes, return
	CP	27H		;single quote?
	RET			;return Z on result
;
;	check for separator/terminator
;
CKGAP	CP	' '
	RET	Z
	CP	','
	RET	Z
	CP	CR
	RET
;
;	parameter table for $FILTER
;
FBLCK	DEFB	0		;work byte
	DEFW	DCB@1		;first DCB
	DEFW	DCB@2		;second DCB
	DEFW	DCB@2		;for mask
	DEFW	FLTPAR		;param block
;
FLTPAR	DEFB	20H+1		;switch + length-1
	DEFW	FLTPON		;ON param
	DEFM	'ON'
;
	DEFB	20H+2
	DEFW	FLTPON
	DEFM	'YES'
;
	DEFB	20H+2
	DEFW	FLTPOF
	DEFM	'OFF'
;
	DEFB	20H+1
	DEFW	FLTPOF
	DEFM	'NO'
;
	DEFB	0
;
FLTPON	DEFW	8080H		;ON param
FLTPOF	DEFW	8080H		;OFF param
CHRSAV	DEFW	0000H		;character saver
;
;	text for filter buffer location and length
;
FLTMSG	DEFM	'xxxxH - '
FLTMSG2	DEFM	'xxx'
	DEFB	CR
	DEFB	CR
	DEFB	ETX
;
FOLIST	DEFW	BUFER1
	DEFW	BUFER1
	DEFW	0
	DEFB	'R'
	DEFB	1
	DEFB	'F'
	DEFB	3
	DEFB	0
;
