XFER3  	ORG	4000H
 ; xfer3/asm
 RST8	JP	START
 RST10	JP	READ
 RST18	JP	WRITE
 RST20	JP	PRINT
 RST28	JP	FLASH
 RST30	JP	FILECOMM
 RST38	JP	TASK
 CURSOR	DW	3C00H
 SAVEDIR	DW	0
 RESULT	DB	0
 SGRANS	DB	0
 DGRANS	DB	0
 SFILES	DB	0
 DFILES	DB	0
 GRANS	DB	0
 STRSPC	DB	0,0,0,0,0,0,0
 CTRACK	DB	0,0,0,0
 	DS	60H
 STACK	EQU	$
 ENTRY	DI			;don't need interrupts
 	IM	1		;interrupts = rst 38H
 	LD	SP,STACK	;setup stack area
 	LD	A,4
 	OUT	(0E0H),A	;setup RTC interrupt
 	LD	A,0C3H
 	LD	(4049H),A
 	LD	HL,NMIRET
 	LD	(404AH),HL
 	XOR	A
 	OUT	(0E4H),A
 	LD	A,28H
 	OUT	(0ECH),A
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	H,80H		;check for topmem
 	CALL	TMEM		;memory there?
 	JR	NZ,HAVMEM
 	LD	H,0C0H
 	CALL	TMEM
 	JR	NZ,HAVMEM
 	LD	H,0
 HAVMEM	LD	A,H
 	SUB	4		;adjust for gran
 	LD	(TOPMEM),A	;save it
 	LD	BC,0
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 	CALL	60H
 START	DI
 	LD	SP,STACK
 	EI
 	LD	HL,MSG1		;title message
 	RST	20H		;display it
 	XOR	A		;use drive 0
 	SBC	HL,HL		;HL = 0
 	LD	(SGRANS),HL	;grans to be copied
 	LD	(SFILES),HL	;# files to be copied
 	LD	(FLAG),A	;turn off prompting
 	CALL	DRIVESET	;setup drive params
 	LD	DE,0601H
 	LD	A,18		;# sectors to read
 	LD	BC,SDIRBUFF	;source directory buffer
 	CALL	MREAD		;multiple read routine
 	LD	HL,MSG7		;source read error
 	JP	NZ,ERROR	;bad read
 	LD	HL,MSG11
 	LD	HL,SDIRBUFF+0D0H
 	CALL	PUTNAMEDATE	;print it
 	LD	HL,PRINTFILE	;filename routine
 	RST	30H		;do whole directory
 	LD	A,(SGRANS)	;get source grans
 	CALL	ASCII		;decimal ascii
 	LD	(SGRANSA),A
 	LD	(SGRANSA+1),BC	;put into string
 	LD	A,(SFILES)	;get source files
 	CALL	ASCII
 	LD	(SFILESA),A
 	LD	(SFILESA+1),BC
 	LD	HL,FILMSG	;how many to be copied
 	RST	20H
 BAD1	LD	HL,MSG6		;ask for source disk
 	RST	20H		;display it
 	CALL	INKEY		;wait for a key
 	SUB	30H		;remove ascii
 	JR	C,BAD1		;no good
 	CP	4		;too big ?
 	JR	NC,BAD1
 	LD	(DEST),A	;save the drive
 	LD	(SOURCE),A
 	LD	HL,MSG00	;linefeed
 	RST	20H		;print it
 	CALL	DMOUNT		;display and wait
 	XOR	A
 	LD	(SOURCE),A	;re-save source disk
 	LD	DE,1		;read track 0/sector 1
 	LD	BC,DDIRBUFF	;destination directory
 	RST	10H		;read the sector
 	LD	HL,MSG8		;destination read error
 	JP	NZ,ERROR
 	LD	A,(DDIRBUFF+1)
 	LD	D,A		;give to Track
 	LD	E,1		;start with sector 1
 	LD	(DESDIR),DE
 	LD	A,18		;read 18 sectors
 	LD	BC,DDIRBUFF	;destination dir buffer
 	CALL	MREAD		;read the directory
 	LD	HL,MSG8		;read error
 	JP	NZ,ERROR	;bad one
 	LD	A,(RESULT)	;check for read protect
 	BIT	5,A		;must be set
 	LD	HL,MSG11	;not a directory
 	JP	NZ,ERROR		;terminate
 	LD	HL,DDIRBUFF	;look at GAT table
 	LD	BC,2800H	;40 tracks/ 0 counter
 GRNLOOP	LD	A,(HL)		;get a byte
 	CPL			;reverse the bits
 	AND	3FH		;low 6 bits
 	PUSH	BC
 	LD	BC,0600H
 GHNLP	RRA
 	CALL	C,BUMPC
 	DJNZ	GHNLP
 	LD	A,C
 	POP	BC
 	ADD	A,C		;add to total
 	LD	C,A		;save total
 	INC	HL		;bump pointer
 	DJNZ	GRNLOOP		;keep counting
 	LD	(DGRANS),A	;save the count
 	CALL	ASCII		;make it ascii
 	LD	(MSG18),A	;put in string
 	LD	(MSG18+1),BC
 	LD	HL,DDIRBUFF+0D0H
 	CALL	PUTNAMEDATE
 	LD	HL,MSG18
 	RST	20H		;display it
 	LD	A,(DGRANS)
 	LD	C,A
 	LD	A,(SGRANS)
 	CP	C
 	JR	Z,DOLOOP
 	JR	C,DOLOOP	;continue
 	LD	A,1		;turn on prompting
 	LD	(FLAG),A
 	LD	HL,MSG28	;turning on prompting
 	RST	20H
 DOLOOP	LD	HL,MSG19	;want to continue?
 	RST	28H		;wait for answer
 	JP	COPYALL		;do the copy
 ;**  SUBROUTINES  **
 BUMPC	INC	C
 	RET
 TASKERR	LD	A,(SOURCE)
 	LD	(DEST),A
 	CALL	SMOUNT
 	RST	8
 TMEM	LD	A,(HL)		;read 1 byte
 	CPL			;reverse bytes
 	LD	(HL),A
 	CP	(HL)		;test for same
 	RET
 CONTROL	CP	10		;linefeed?
 	JR	Z,LINFEED
 	CP	11		;tab ?
 	JR	Z,TAB
 	CP	1DH		;BOL?
 	JR	Z,BOL
 	CP	1EH		;EOL?
 	JR	Z,EOL
 	CP	31		;clear screen
 	JR	Z,CLS		;do it
 	RET
 LINFEED	LD	DE,40H		;64 char/line
 	CALL	BOL		;get begin of line
 	ADD	HL,DE		;go to next line
 	JR	OFFVID		;frame it
 TAB	LD	A,L		;get lsb
 	AND	0E0H		;set to begin/middle line
 	LD	L,A
 	LD	DE,20H		;move to next position
 	ADD	HL,DE
 	JR	OFFVID		;still on video?
 BOL	LD	A,L		;get lsb byte
 	AND	0C0H		;put to beginning of line
 	LD	L,A		;put that back
 	RET			;no frame needed
 EOL	CALL	BOL		;go beginning of line
 	PUSH	BC		;save these
 	LD	BC,3FH		;line length -1
 FIXCON	PUSH	HL		;save the rest
 	LD	D,H		;give to DE
 	LD	E,L
 	INC	DE		;start +1
 	LD	(HL),20H	;clear byte
 	LDIR			;put spaces all over
 	POP	HL
 	POP	BC		;get 'em all back
 OFFVID	LD	A,H		;check for boundrys
 	CP	3CH		;less than video?
 	JR	NC,OFFAOK	;test one ok
 	LD	HL,3C00H	;top of vid
 	RET			;resume
 OFFAOK	CP	40H		;more than top?
 	RET	C		;it's OK
 	PUSH	BC		;this too
 	LD	DE,3C00H	;scroll the screen
 	LD	HL,3C40H	;2'nd line
 	LD	BC,3C0H		;screen less one line
 	LDIR			;move it up
 	POP	BC		;get 'em back
 	LD	HL,3FC0H	;bottom line
 	JR	EOL		;clear bottom line
 CLS	LD	HL,3C00H	;top of screen
 	PUSH	BC		;save from use
 	LD	BC,1023		;screen size -1
 	JR	FIXCON		;fill with spaces
 KEY	PUSH	HL		;save all registers
 	PUSH	DE
 	PUSH	BC
 	LD	HL,GET		;return address
 	PUSH	HL		;to the stack
 	LD	HL,STRSPC	;work area
 	LD	BC,3801H	;keyboard memory
 	LD	D,0		;row counter
 NEXROW	LD	A,(BC)		;get key byte
 	LD	E,A		;save it here
 	XOR	(HL)		;reverse with mask
 	LD	(HL),E		;save new key
 	AND	E		;same as last key?
 	JR	NZ,HAVEIT	;have a new one
 	INC	D		;bump row count
 	INC	L		;bump mask byte
 	RLC	C		;move key memory
 	JP	P,NEXROW	;go for 7 rows
 	RET			;done
 HAVEIT	LD	E,A		;save masked byte
 	LD	A,D		;get row count
 	RLCA			;*2
 	RLCA			;*4
 	RLCA			;*8
 	LD	D,A		;row * 8
 	LD	C,1		;column mask bit
 MKT1	LD	A,C
 	AND	E		;this the right key?
 	JR	NZ,MKT2		;yup
 	INC	D		;bump row*8
 	RLC	C		;shift mask bit left
 	JR	MKT1		;continue
 MKT2	LD	HL,KEYTABL	;look up key table
 	LD	C,D
 	LD	B,0		;bc=displacement
 	ADD	HL,BC
 	LD	A,(HL)		;get the byte
 GOTKEY	LD	BC,1000H	;debounce delay
 DELAY	PUSH	AF
 	DEC	BC
 	NOP
 	LD	A,B
 	OR	C
 	JR	NZ,DELAY+1
 	POP	AF
 	RET
 GET	POP	BC
 	POP	DE
 	POP	HL
 	OR	A
 	RET			;restore 'em all
 KEYTABL	DB	'@ABCDEFG'
 	DB	'HIJKLMNO'
 	DB	'PQRSTUVW'
 	DB	'XYZ*****'
 	DB	'01234567'
 	DB	'89:+<->?'
 	DB	13,3,1,5BH,5CH,5DH,5EH,20H
 ASCII	PUSH	HL		;save from this
 	CALL	ASCI		;convert to ascii
 	LD	H,B		;save lsb here
 	PUSH	HL
 	LD	A,C		;get msb
 	SUB	30H		;remove ascii
 	CALL	ASCI
 	LD	A,C		;get msb
 	CP	'0'		;leading 0 ?
 	JR	NZ,ASCIGO1
 	LD	A,20H
 ASCIGO1	POP	HL		;restore hl
 	LD	C,B
 	LD	B,H		;ACB = ascii
 	POP	HL
 	RET
 ASCI	LD	C,'0'		;start with 0
 ASCII1	SUB	10		;repeat 10 subtract
 	JR	C,ASCII2
 	INC	C		;bump msb
 	JR	ASCII1
 ASCII2	ADD	A,3AH		;make this ascii
 	LD	B,A		;BC = ascii
 	RET
 FILECOMM	LD	(COMMADDR),HL	;comman looper
 FILELOOP	LD	IX,SDIRBUFF+200H
 	LD	B,80		;80 files possible
 FILELP	BIT	4,(IX)		;active file
 	JR	Z,NEXFILE	;skip dead ones
 	BIT	6,(IX)		;system file?
 	JR	NZ,NEXFILE
 	BIT	3,(IX)		;invisible ?
 	JR	NZ,NEXFILE	;skip them too
 	PUSH	BC
 	CALL	0		;set from calling routine
 COMMADDR	EQU	$-2
 	POP	BC
 NEXFILE	LD	DE,30H		;displacement to next
 	ADD	IX,DE
 	PUSH	IX
 	POP	DE
 	LD	A,E
 	CP	0F0H
 	JR	NZ,NXYI
 	INC	D
 	LD	E,0
 	PUSH	DE
 	POP	IX
 NXYI	DJNZ	FILELP
 	RET			;done
 PRINTFILE	PUSH	BC	;save loop counter
 	LD	HL,SFILES	;bump source file count
 	INC	(HL)
 	LD	B,8		;8 chars in name
 	PUSH	IX		;IX => IY
 	POP	IY
 	LD	HL,FILENAME	;name string
 	PUSH	HL		;save on stack
 PF1	LD	B,8		;8 chars in name
 	CALL	PFPUT		;put in string
 	LD	A,(IY+5)	;get next byte
 	CP	20H		;space ?
 	JR	Z,PF2
 	LD	(HL),'/'	;for extension
 	INC	HL
 	LD	B,3		;3 char extension
 	CALL	PFPUT
 PF2	LD	(HL),0		;terminate message
 	POP	HL		;filename message
 	RST	20H		;display it
 	CALL	MANYGRANS	;how many grans this file
 	LD	A,(HL)		;get file gran count
 	CALL	ASCII
 	LD	(GRANMSG),A
 	LD	(GRANMSG+1),BC	;to the string
 	LD	HL,GRANMSG-3
 	RST	20H		;display it
 	POP	BC		;restore counter
 	RET			;done
 MANYGRANS	PUSH	IX	;IX => IY
 	POP	IY
 	LD	HL,GRANS	;how many grans
 	LD	(HL),0		;start with 0
 MGRLP	LD	A,(IY+22)	;get extent element
 	CP	0FFH		;terminator?
 	RET	Z
 	LD	A,(IY+23)	;get # grans
 	AND	1FH		;low 5 bits only
 	RET	Z
 	LD	B,A		;give here for count
 	CALL	ADDCOUNT	;bump counter B times
 	PUSH	HL		;save counter pointer
 	LD	HL,SGRANS	;add to total
 	CALL	ADDCOUNT	;bump this one
 	POP	HL
 	INC	IY		;bump position
 	INC	IY		;to next extry pair
 	JR	MGRLP		;continue
 ADDCOUNT	LD	C,B	;save the count
 ADDCLOOP	INC	(HL)	;bump the counter
 	DJNZ	ADDCLOOP	;till B = 0
 	LD	B,C		;get count back
 	RET			;done
 INITCOUNT	LD	(HL),20H
 	INC	HL
 	LD	(HL),20H
 	INC	HL
 	LD	(HL),'0'
 	RET
 PFPUT	LD	A,(IY+5)	;get name byte
 	CP	20H		;space ?
 	JR	Z,PFPUTX	;skip them
 	LD	(HL),A		;else put in string
 	INC	HL		;bump string pointer
 PFPUTX	INC	IY		;get next byte
 	DJNZ	PFPUT		;go some more
 	RET
 GETTRK	PUSH	HL		;save HL
 	PUSH	AF		;save C flag
 	LD	HL,CTRACK	;current track table
 	LD	A,0		;binary drive
 DRIVE	EQU	$-1
 	ADD	A,L		;point to right byte
 	LD	L,A
 	POP	AF		;restore C flag
 	JR	C,PUTIN		;C = put in table
 	LD	A,(HL)		;get the byte
 PUTIN	LD	(HL),A		;put byte in table
 	POP	HL		;restore HL
 	OR	A		;set flags this byte
 	RET			;done
 INKEY	LD	HL,(CURSOR)	;get cursor address
 	LD	BC,400H		;delay count
 	LD	A,(HL)		;get cursor byte
 	CP	95
 	LD	A,95
 	JR	NZ,CUPUT
 	LD	A,140
 CUPUT	LD	(HL),A
 INKI	CALL	KEY		;scan keyboard
 	JR	NZ,KEYIN	;have a key
 	DEC	C		;decrement flash counter
 	JR	NZ,INKI
 	DJNZ	INKI
 	JR	INKEY+3		;reverse cursor
 KEYIN	CP	60H		;lowercase input?
 	JR	C,INKEYOK	;nope
 	AND	5FH		;make it uppercase
 INKEYOK	LD	(HL),A		;display it
 	RET			;done
 KIM2	DB	'K'+80H,'i'+80H,'m'+80H,' '+80H
 	DB	'W'+80H,'a'+80H,'t'+80H,'t'+80H
 TASK	PUSH	AF
 	PUSH	BC
 	PUSH	DE
 	PUSH	HL
 	IN	A,(0E0H)
 	BIT	2,A
 	JR	NZ,TASKDONE
 	LD	HL,KIM
 	LD	DE,KIM2
 	LD	B,8
 CHKIM	LD	A,(DE)
 	AND	7FH
 	CP	(HL)
 	CALL	NZ,KILLPGM
 	INC	HL
 	INC	DE
 	DJNZ	CHKIM
 	LD	A,(3840H)
 	AND	4
 	JR	Z,NOTBRK
 	LD	A,(3880H)
 	OR	A
 	JR	Z,NOTBRK
 	RST	8
 NOTBRK	LD	A,3
 TASKCNT	EQU	$-1
 	DEC	A
 	LD	(TASKCNT),A
 	JR	NZ,TASKDONE
 	LD	A,3
 	LD	(TASKCNT),A
 	CALL	ALIVE
 TASKDONE	IN	A,(0ECH)
 	POP	HL
 	POP	DE
 	POP	BC
 	POP	AF
 	EI
 	RET
 KILLPGM	LD	HL,4000H
 	LD	DE,4001H
 	LD	BC,0-4000H
 	LD	(HL),76H
 	LDIR
 	RST	0
 ERROR	RST	20H
 	LD	HL,MSG10	;termination
 	RST	20H
 	LD	HL,CTRACK
 	LD	B,4
 FIXTRK	LD	(HL),0
 	INC	HL
 	DJNZ	FIXTRK
 	JP	TASKERR		;remount disk
 MDWRITE	LD	HL,DWRITE	;directory write
 	JR	MWRITE+3	;go common
 MREAD	LD	HL,READ		;read routine
 	JR	MWRITE+3	;go common routine
 MWRITE	LD	HL,WRITE
 	LD	(RDWRT),HL	;save in code
 	LD	L,A		;L = counter
 MLOOP	PUSH	HL		;save counter
 	CALL	0		;do the command
 RDWRT	EQU	$-2
 	POP	HL		;restore count
 	RET	NZ		;bad I/O
 	INC	E		;bump sector
 	LD	A,E		;check for end of track
 	SUB	19		;18 sectors/track
 	JR	NZ,XLOOP	;go loop
 	LD	E,1		;E = 1
 	INC	D		;bump track
 XLOOP	DEC	L		;reduce counter
 	RET	Z		;all done
 	JR	MLOOP		;now continue
 PUTNAMEDATE	LD	DE,MSG2	;use this message string
 	LD	BC,8		;8 chars in name & date
 	PUSH	BC		;save 8
 	LDIR
 	INC	DE
 	LD	A,'-'
 	LD	(DE),A
 	INC	DE
 	INC	DE
 	POP	BC		;get 8 back
 	LDIR
 	LD	HL,MSG2AA
 	JP	PRINT		;display/return
 WRITE1	LD	A,0FCH
 	LD	(MASK),A
 	LD	(SPPASS),SP
 	CALL	SETNMI
 	RET	NZ
 	LD	A,0A0H
 IOTYPE	EQU	$-1
 	OUT	(0F0H),A
 	CALL	DSKSLO
 W1	IN	A,(0F0H)
 	AND	E
 	JP	PO,W1
 	OUTI
 	LD	B,60H
 	DJNZ	$
 	LD	A,D
 	DEC	B
 W2	OUT	(0F4H),A
 	OUTI
 	JR	NZ,W2
 	JR	$
 READ	LD	HL,READ1
 	JR	DOBOTH-3
 DWRITE	LD	A,0A0H
 	JR	WRITXX
 WRITE	LD	A,0A1H
 WRITXX	LD	(IOTYPE),A
 	LD	HL,WRITE1
 	LD	(READ1X+1),HL
 DOBOTH	LD	A,10
 	LD	(R1COUNT),A
 READ1X	CALL	0
 	RET	Z
 	BIT	4,A
 	JR	Z,READ1Y
 	PUSH	AF
 	XOR	A
 	SCF
 	CALL	GETTRK
 	POP	AF
 READ1Y	EX	AF,AF'
 	LD	A,0D0H
 	OUT	(0F0H),A
 	LD	A,0
 R1COUNT	EQU	$-1
 	DEC	A
 	LD	(R1COUNT),A
 	JR	NZ,READ1X
 	EX	AF,AF'
 	RET
 READ1	LD	A,9CH
 	LD	(MASK),A	;save error mask
 	LD	(SPPASS),SP
 	CALL	SETNMI
 	RET	NZ
 	LD	A,80H
 	OUT	(0F0H),A
 	CALL	DSKSLO
 R1	IN	A,(0F0H)
 	AND	E
 	JP	PO,R1
 	INI
 	LD	A,D
 R2	OUT	(0F4H),A
 	INI
 	JR	NZ,R2
 	JR	$
 SETNMI	LD	(BUFFSAVE),BC
 	LD	(SECSAVE),DE
 	CALL	SEEK
 	RET	NZ
 	CALL	SELECT
 	LD	A,(DRIV)
 	OR	40H
 	LD	D,A
 	LD	E,3
 	LD	HL,RETNMI
 	LD	(404AH),HL
 	LD	A,0C0H
 	OUT	(0E4H),A
 	LD	H,B
 	LD	L,C
 	LD	BC,0F3H
 	IN	A,(0F0H)
 	DI
 	XOR	A
 	RET
 RETNMI	XOR	A
 	OUT	(0E4H),A
 	LD	HL,NMIRET
 	LD	(404AH),HL
 	LD	SP,0
 SPPASS	EQU	$-2
 	LD	DE,0
 SECSAVE	EQU	$-2
 	LD	BC,0
 BUFFSAVE	EQU	$-2
 	INC	B
 	CALL	DSKSLO
 	IN	A,(0F0H)
 	LD	(RESULT),A
 	AND	0FCH
 MASK	EQU	$-1
 	EI
 	RET	Z
 	PUSH	AF
 	DEC	B
 	POP	AF
 	RET
 NMIRET	RETN
 DRVASC	LD	A,(DRIVE)	;get binary drive
 	ADD	A,30H		;add ascii
 	RET			;that's all
 DSKSLO	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	EX	(SP),HL
 	RET
 SEEK	CALL	SELECT
 	OR	A
 	CALL	GETTRK		;get current track
 	JR	NZ,SEEK1	;continue if not 0
 	CALL	RESTORE		;restore to track 0
 	RET	NZ		;bad one
 SEEK1	OUT	(0F1H),A
 	PUSH	AF
 	LD	A,D
 	OUT	(0F3H),A
 	LD	A,E
 	OUT	(0F2H),A
 	LD	A,D
 	CP	16H
 	LD	A,(DRIV)
 	RES	5,A
 	JR	C,SEEKX
 	SET	5,A
 SEEKX	LD	(DRIV),A
 	POP	AF
 	CP	D		;already on the track?
 	JR	Z,SEEK2		;don't bother with it
 	LD	A,18H		;seek command
 	CALL	MOVE		;move the head
 	RET	NZ		;error in move
 SEEK2	IN	A,(0F1H)
 	SCF			;carry = put in table
 	CALL	GETTRK		;put it in
 	XOR	A		;set Z flag
 	RET			;done OK
 RESTORE	LD	A,08H		;drive restore command
 	CALL	MOVE		;move the head
 	RET	NZ		;bad
 	IN	A,(0F0H)
 	CPL			;reverse the bits
 	BIT	2,A		;head over track 0 ?
 	LD	A,0		;set track 0
 	RET			;Z = OK
 MOVE	AND	0FCH
 	OR	3
 SPEED	EQU	$-1
 	OUT	(0F0H),A
 	CALL	DSKSLO
 MOVEWT	CALL	SELECT		;select the drive
 	IN	A,(0F0H)
 	BIT	0,A
 	JR	NZ,MOVEWT	;else wait some more
 	AND	18H
 	RET
 DRIVESET	AND	3
 	LD	(DRIVE),A
 	LD	B,1		;which bit to set
 	OR	A		;set flags
 	JR	DRVCK		;have it
 DRVSET	SLA	B		;move drive bit left
 	DEC	A		;binary - 1
 DRVCK	JR	NZ,DRVSET	;continue loop
 	LD	A,B		;get bit
 	OR	80H
 	LD	(DRIV),A	;save for drive select
 	RET			;done
 PRINT	LD	A,(HL)		;get data byte
 	INC	HL		;bump pointer
 	OR	A		;check for terminator
 	RET	Z		;done if yes
 	CP	20H		;control byte ?
 	PUSH	HL		;save data pointer
 	LD	HL,(CURSOR)	;get cursor position
 	JR	C,DOCTL		;do control byte
 	LD	(HL),A		;display the byte
 	CP	(HL)		;still there ?
 	JR	Z,PRTOK		;lower case if yes
 	SUB	20H		;make it upper case
 	LD	(HL),A		;put it back
 PRTOK	INC	HL		;bump the cursor
 	LD	(CURSOR),HL	;update where it is
 	POP	HL		;get data address back
 	JR	PRINT		;do next byte
 DOCTL	CALL	CONTROL		;display control code
 	JR	PRTOK+1		;continue
 FLASH	EXX
 	LD	HL,MSG0
 	EXX
 	JR	WAIT2
 SMOUNT	LD	HL,MSG4		;mount source diskette
 	LD	A,(SOURCE)	;source drive
 	JR	MOUNT		;go common routine
 DMOUNT	LD	HL,MSG5		;mount destination disk
 	LD	A,(DEST)	;dest drive
 MOUNT	CALL	DRIVESET	;set up for select
 	EXX			;alternate HL
 	LD	HL,MSG0		;clear line code
 	EXX			;back to this
 	LD	A,0		;get source drive
 SOURCE	EQU	$-1
 	CP	0		;same as destination ?
 DEST	EQU	$-1
 	JR	NZ,MOUNTDONE	;check status
 WAIT2	PUSH	HL		;save message pointer
 	RST	20H		;print it
 	POP	HL
 LOOP2	CALL	KEY		;get a key
 	CP	13		;yes ?
 	JR	Z,MOUNTDONE	;terminate
 	LD	A,0		;get counter
 COUNT1	EQU	$-1
 	DEC	A		;less 1
 	LD	(COUNT1),A	;put updated one back
 	JR	NZ,LOOP2
 	EXX			;other message
 	JR	WAIT2		;print this message/wait
 MOUNTDONE	LD	HL,MSG0
 	RST	20H		;print it
 	RET
 SELECT	IN	A,(0F0H)
 	AND	80H
 	LD	A,0		;get drive bit
 DRIV	EQU	$-1
 	OUT	(0F4H),A
 	RET	Z		;already was on
 	PUSH	BC		;save this
 	LD	BC,0		;1 second delay time
 	CALL	DELAY		;decrement BC till 0
 	POP	BC		;restore it
 	JR	SELECT
 COPYALL	LD	HL,CREATE	;create/allocate files
 	RST	30H
 	LD	HL,DOCOPY	;file copy routine
 	RST	30H	;do all files
 	CALL	MAKEHIT		;rebuild HIT table
 	LD	HL,MSG27	;updating directory
 	RST	20H
 	CALL	DMOUNT		;set it up
 	LD	A,18		;write 18 sectors
 	LD	BC,DDIRBUFF	;destination directory
 	LD	DE,0
 DESDIR	EQU	$-2
 	CALL	MDWRITE		;multiple directory write
 	LD	HL,MSG21	;bad directory update
 	JP	NZ,ERROR	;messed it up
 	LD	HL,MSG23
 	RST	20H
 	LD	HL,MSG20	;enter to re-boot
 	RST	28H		;flash it
 	DI			;disable
 	RST	0
 IFMATCH	PUSH	HL		;save pointers
 	PUSH	DE
 	LD	B,11		;must match 11 chars
 IFMATCH1	LD	A,(DE)	;get a byte
 	CP	(HL)		;same ?
 	JR	NZ,IFMATCH2
 	INC	DE		;bump pointers
 	INC	HL
 	DJNZ	IFMATCH1	;continue for 11
 IFMATCH2	POP	DE	;restore pointers
 	POP	HL
 	RET
 KILLIT	BIT	4,(IX)		;dead already?
 	RET	Z		;yep
 	PUSH	IX		;pass to IY for kill
 	POP	IY
 KILLLP	RES	4,(IY)		;de-activate the file
 KILLLP1	LD	A,(IY+16H)	;get extension entry
 	CP	0FFH		;terminator?
 	RET	Z		;yep
 	LD	H,A		;start track of kill
 	LD	A,(IY+17H)	;get gran offset/count
 	AND	0E0H
 	LD	L,1
 	JR	Z,PASTAA
 	CP	20H
 	LD	L,4
 	JR	Z,PASTAA
 	CP	40H
 	LD	L,7
 	JR	Z,PASTAA
 	CP	60H
 	LD	L,10
 	JR	Z,PASTAA
 	CP	80H
 	LD	L,13
 	JR	Z,PASTAA
 	LD	L,16
 PASTAA	LD	A,(IY+17H)
 	AND	1FH
 	LD	C,A		;here for count
 	RET	Z
 	CALL	RELEASE		;de-allocate the grans
 	INC	IY		;point to next extent
 	INC	IY
 	JR	KILLLP1		;do it
 RELEASE	PUSH	DE		;save HIT table pointer
 	EX	DE,HL		;DE => start track/sector
 	DEC	H		;HL points to GAT table
 	DEC	H
 	LD	L,D		;point to GAT track
 	LD	A,E		;see if start on sec 0
 	CP	1
 	JR	Z,RELLP
 	CP	4
 	JR	Z,SECOND
 	CP	7
 	JR	Z,THIRD
 	CP	10
 	JR	Z,FOURTH
 	CP	13
 	JR	Z,FIFTH
 	JR	SIXTH
 RELLP	RES	0,(HL)		;release the gran
 	DEC	C
 	JR	Z,RELDONE	;done with this entry
 SECOND	RES	1,(HL)		;release the gran
 	DEC	C
 	JR	Z,RELDONE
 THIRD	RES	2,(HL)
 	DEC	C
 	JR	Z,RELDONE
 FOURTH	RES	3,(HL)
 	DEC	C
 	JR	Z,RELDONE
 FIFTH	RES	4,(HL)
 	DEC	C
 	JR	Z,RELDONE
 SIXTH	RES	5,(HL)
 	DEC	C
 	JR	Z,RELDONE
 	INC	HL		;point to next track
 	JR	RELLP
 RELDONE	POP	DE		;restore DE
 	RET			;HIT done separately
 CREATE2	LD	A,L		;get lsb
 	SUB	5
 	LD	L,A
 	BIT	4,(HL)		;alive ?
 	JR	Z,CREATE2B	;skip it, dead already
 CREATE2A	PUSH	HL		;save on stack
 	CALL	PRINTFILE	;print the filename
 	LD	HL,MSG25	;ask if to be replaced
 	RST	20H
 	CALL	INKEY		;wait for answer
 	PUSH	AF		;save key
 	LD	HL,MSG00	;linefeed
 	RST	20H
 	POP	AF
 	POP	HL
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;no ?
 	JP	Z,KILLIT	;cancel this file
 	CP	'Y'		;yes ?
 	JR	NZ,CREATE2A	;try again
 	PUSH	IX		;save pointer
 	PUSH	HL
 	POP	IX
 	LD	DE,DDIRBUFF+200H
 	CALL	KILLIT		;kill dest file
 	POP	IX		;restore pointer
 	JR	CREATE3
 CREATE2B	LD	A,L
 	ADD	A,5		;put it back
 	LD	L,A
 	JR	CREATE2C	;continue with dir
 CREATE	LD	A,0		;get prompt flag
 FLAG	EQU	$-1
 	DEC	A		;must be 1 for prompt
 	JR	NZ,CREATE00	;continue with copy
 	CALL	PRINTFILE	;show name
 	LD	HL,MSG12	;copy it?
 	RST	20H
 	CALL	INKEY		;get a key
 	PUSH	AF
 	LD	HL,MSG00
 	RST	20H
 	POP	AF
 	LD	DE,SDIRBUFF+200H
 	CP	'N'		;nope ?
 	JP	Z,KILLIT	;kill from source file
 	CP	'Y'
 	JR	NZ,CREATE	;ask again if wrong
 CREATE00	PUSH	IX	;pass file data start
 	POP	DE
 	LD	A,E
 	ADD	A,5		;point to name
 	LD	E,A
 	LD	HL,DDIRBUFF+205H	;destination name
 	LD	C,80		;see if file is there
 CREATE1	CALL	IFMATCH		;see if files match
 	JR	Z,CREATE2	;see if to be overwritten
 CREATE2C	PUSH	BC	;save this
 	LD	BC,30H		;displacement between
 	ADD	HL,BC		;add to dest pointer
 	POP	BC		;get counter back
 	LD	A,L
 	CP	0F5H
 	JR	NZ,CUOO
 	LD	L,5
 	INC	H
 CUOO	DEC	C
 	JR	NZ,CREATE1	;go some more
 CREATE3	CALL	FINDSPOT	;locate an entry
 	PUSH	HL		;pass to IY for allocate
 	POP	IY
 	EX	DE,HL		;DE => dest spot
 	PUSH	IX
 	POP	HL		;HL => source spot
 	LD	BC,22		;move the entry here
 	LDIR			;exact duplication
 	LD	H,D
 	LD	L,E
 	INC	DE		;clear the extents
 	LD	BC,25
 	LD	(HL),0FFH	;set no extents
 	LDIR
 	PUSH	IY		;save from manygrans
 	CALL	MANYGRANS	;how many grans we need?
 	POP	IY
 	LD	B,(HL)		;get the count
 ALLOCLP0	LD	A,12	;allow 12 extents/entry
 	PUSH	IY		;save pointer
 ALLOCLP	PUSH	AF		;save extent counter
 	CALL	CHUNK		;allocate chunk of grans
 	LD	HL,MSG26	;disk space full
 	JP	C,ERROR		;no good
 	LD	(IY+16H),D	;save start track
 	LD	A,C		;get gran count
 	OR	E		;or with sector start
 	LD	(IY+17H),A	;save this too
 	INC	IY		;look at next entry
 	INC	IY
 	LD	A,B		;get needed count
 	SUB	C		;less this entry
 	LD	B,A		;re-save it
 	JR	Z,ALLOCDN	;finished
 	POP	AF		;get 12 counter back
 	DEC	A		;only 12 spots available
 	JR	NZ,ALLOCLP	;do them all
 	LD	HL,MSG13
 	JP	ERROR
 ALLOCDN	POP	AF		;restore stack
 	POP	IY
 	RET			;done with this entry
 FINDSPOT	LD	HL,DDIRBUFF+200H
 	PUSH	DE
 	PUSH	BC
 	LD	B,80		;80 entries/dir
 	LD	DE,30H
 CREATE4	BIT	4,(HL)		;available?
 	JR	Z,CREATE5	;check it out
 CREATE6	ADD	HL,DE		;next one
 	LD	A,L
 	CP	0F0H
 	JR	NZ,CRR5
 	LD	L,0
 	INC	H
 CRR5	DJNZ	CREATE4		;continue
 	LD	HL,MSG13	;out of filespace
 	JP	ERROR		;terminate
 CREATE5	LD	A,L		;get lsb
 	POP	BC
 	POP	DE
 	RET			;HL => entry area
 CHUNK	LD	HL,DDIRBUFF	;dest gat table
 	LD	C,0		;how many allocated
 CHUNK1	BIT	0,(HL)		;gran 0 available?
 	LD	D,L		;get track we're on
 	LD	E,0
 	JR	Z,CHUNK2	;yes, set E at 0
 	BIT	1,(HL)		;gran 1 available ?
 	LD	E,20H
 	JR	Z,CHUNK3	;yes, set E at 20H
 	BIT	2,(HL)
 	LD	E,40H
 	JR	Z,CHUNK4
 	BIT	3,(HL)
 	LD	E,60H
 	JR	Z,CHUNK5
 	BIT	4,(HL)
 	LD	E,80H
 	JR	Z,CHUNK6
 	LD	E,0A0H
 	BIT	5,(HL)
 	JR	Z,CHUNK7
 	INC	L		;next one
 	LD	A,L
 	CP	28H		;end of table?
 	JR	C,CHUNK1	;continue
 	SCF			;C = error
 	RET			;done
 CHUNK2	BIT	0,(HL)		;allocation test
 	JR	NZ,CHUNK8	;finished
 	SET	0,(HL)		;allocate it
 	INC	C		;bump counter
 	LD	A,B		;get needed count
 	CP	C		;enough ?
 	RET	Z		;done
 	CALL	IFNUF
 	RET	Z
 CHUNK3	BIT	1,(HL)		;allocation test
 	JR	NZ,CHUNK8	;done
 	SET	1,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	CALL	IFNUF
 	RET	Z
 CHUNK4	BIT	2,(HL)
 	JR	NZ,CHUNK8
 	SET	2,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	CALL	IFNUF
 	RET	Z
 CHUNK5	BIT	3,(HL)
 	JR	NZ,CHUNK8
 	SET	3,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	CALL	IFNUF
 	RET	Z
 CHUNK6	BIT	4,(HL)
 	JR	NZ,CHUNK8
 	SET	4,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	CALL	IFNUF
 	RET	Z
 CHUNK7	BIT	5,(HL)
 	JR	NZ,CHUNK8
 	SET	5,(HL)
 	INC	C
 	LD	A,B
 	CP	C
 	RET	Z
 	CALL	IFNUF
 	RET	Z
 	INC	L		;next track
 	LD	A,L
 	CP	28H
 	JR	C,CHUNK2
 	SCF
 	RET
 CHUNK8	OR	A		;clear carry
 	RET
 IFNUF	LD	A,C
 	CP	1FH
 	RET
 DOCOPY	LD	HL,MSG22	;copying file....
 	RST	20H		;display it
 	CALL	PRINTFILE	;print filename
 	CALL	POSITIY		;position IY to file
 	LD	HL,1		;position in file
 DOCOPY0	XOR	A		;use this as a counter
 	LD	(COUNTER),A	;save it
 	LD	(DESPOS),HL	;dest start position
 	PUSH	HL		;save this
 	CALL	SMOUNT		;mount source disk
 	POP	HL
 	LD	BC,DATABUFF
 DOCOPY1	PUSH	BC		;save buffer
 	PUSH	HL		;save position
 	CALL	POSITS
 	POP	HL
 	POP	BC
 	JR	C,EMPTYBUFF	;write the buffer back
 	PUSH	HL		;save position
 	LD	A,3		;1 gran read
 	CALL	MREAD		;read it
 	POP	HL		;restore it
 	JR	NZ,DOCOPYN	;bad read on source
 	INC	HL		;bump position in file
 	LD	A,0
 COUNTER	EQU	$-1
 	INC	A
 	LD	(COUNTER),A
 	LD	A,B		;get page in memory
 	CP	0		;at top of memory?
 TOPMEM	EQU	$-1
 	JR	C,DOCOPY1
 	OR	A		;clear carry for not done
 EMPTYBUFF	PUSH	AF	;save carry flag for loop
 	PUSH	HL
 	CALL	DMOUNT		;mount destination disk
 	LD	A,(COUNTER)	;sector counter
 	LD	BC,DATABUFF	;where data is
 	LD	HL,0		;get start position
 DESPOS	EQU	$-2		;saved from above
 	CALL	CREATWRITE	;write the grans back
 	POP	HL		;restore position
 	POP	AF		;get result back
 	RET	C		;done with this file
 	JR	DOCOPY0		;do the rest
 DOCOPYN	LD	HL,MSG7
 	JP	ERROR		;source read error
 MAKEHIT	LD	HL,DDIRBUFF+100H	;dest HIT table
 	LD	DE,DDIRBUFF+101H
 	LD	BC,0DFH
 	LD	(HL),0		;zero it out
 	LDIR
 	LD	IX,DDIRBUFF+200H	;start of names
 	LD	B,80		;80 entries
 	XOR	A
 	LD	(TEMP0),A
 HITLP	BIT	4,(IX)		;active entry
 	PUSH	BC		;save count
 	CALL	NZ,PUTHIT	;insert HIT byte
 	LD	BC,30H		;next entry
 	ADD	IX,BC
 	PUSH	IX
 	POP	BC
 	LD	A,C
 	CP	0F0H
 	JR	NZ,ASDF
 	LD	C,0
 	INC	B
 	PUSH	BC
 	POP	IX
 ASDF	POP	BC
 	LD	A,(TEMP0)
 	INC	A
 	LD	(TEMP0),A
 	DJNZ	HITLP		;do all 64
 	RET			;done
 HASH	PUSH	IX		;save position
 	PUSH	BC
 	LD	BC,0B00H	;B = char count, C = hash
 HASHLP	LD	A,(IX+5)	;get a name byte
 	INC	IX		;point to next one
 	XOR	C		;hash it
 	RLCA
 	LD	C,A
 	DJNZ	HASHLP
 	OR	A		;check for 0 hash
 	JR	NZ,HASHOK	;ok if not
 	INC	A		;else make it 1
 HASHOK	POP	BC
 	POP	IX
 	RET			;done
 PUTHIT	BIT	7,(IX)		;extension entry ?
 	RET	NZ		;don't do those YET
 	LD	HL,DDIRBUFF+100H
 	LD	A,0
 TEMP0	EQU	$-1
 	LD	L,A
 	CALL	HASH		;compute hash byte
 	LD	(HL),A		;put in table
 	RET
 POSITIY	PUSH	IX		;pass to HL for compare
 	POP	DE
 	LD	A,E
 	ADD	A,5
 	LD	E,A		;point to name
 	LD	HL,DDIRBUFF+205H
 	LD	C,80
 POSITIY1	CALL	IFMATCH	;compare names
 	JR	Z,POSIYG	;go if match
 	PUSH	BC		;save count
 	LD	BC,30H		;point to next entries
 	ADD	HL,BC
 	POP	BC		;restore count
 	LD	A,L
 	CP	0F5H
 	JR	NZ,LKJ
 	LD	L,5
 	INC	H
 LKJ	DEC	C
 	JR	NZ,POSITIY1	;continue
 	LD	HL,MSG24	;program error
 	JP	ERROR
 POSIYG	LD	A,L		;get dest LSB
 	SUB	5
 	LD	L,A
 	PUSH	HL
 	POP	IY
 	RET			;IY => filename (dest)
 POSITS	PUSH	IY		;must save IY from use
 	PUSH	IX		;pass to IY
 	POP	IY
 	LD	DE,SDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save for postion use
 	CALL	POSIT		;position to IY file
 	POP	IY		;restore IY
 	RET
 POSITD	PUSH	IY		;save IY
 	LD	DE,DDIRBUFF+200H
 	LD	(SAVEDIR),DE	;save it
 	CALL	POSIT		;position the file
 	POP	IY		;restore it
 	RET
 POSIT	LD	A,(IY+16H)	;get extent
 	CP	0FFH		;terminator?
 	SCF			;C = EOF
 	RET	Z		;return if end
 	LD	D,A		;else start track
 	LD	A,(IY+17H)	;get offset/grans
 	LD	E,1		;start with sector 1
 	PUSH	AF
 	AND	0E0H
 	JR	Z,POSIT2-1
 	CP	20H
 	LD	E,4
 	JR	Z,POSIT2-1
 	CP	40H
 	LD	E,7
 	JR	Z,POSIT2-1
 	CP	60H
 	LD	E,10
 	JR	Z,POSIT2-1
 	CP	80H
 	LD	E,13
 	JR	Z,POSIT2-1
 	LD	E,16
 	POP	AF
 POSIT2	AND	1FH		;get gran counter
 	RET	Z
 POSIT2A	LD	(CNTSAV),A	;save the counter
 	DEC	HL		;reduce posit count
 	LD	A,H
 	OR	L		;any bits left ?
 	RET	Z
 	CALL	NEXTGRAN
 	LD	A,0		;get count back
 CNTSAV	EQU	$-1
 	DEC	A		;reduce it
 	JR	NZ,POSIT2A
 	INC	IY		;next extent
 	INC	IY
 	JR	POSIT
 NEXTGRAN	LD	A,E
 	ADD	A,3
 	LD	E,A
 	CP	19
 	RET	NZ
 	LD	E,1
 	INC	D
 	RET
 CREATWRITE	PUSH	HL
 	PUSH	BC		;save buffer
 	CALL	POSITD
 	POP	BC
 	LD	A,3		;3 sectors/gran
 	CALL	MWRITE		;multiple write
 	LD	HL,MSG9		;dest write error
 	JP	NZ,ERROR	;terminate
 	POP	HL		;restore position
 	INC	HL
 	LD	A,(COUNTER)
 	DEC	A		;reduce it
 	RET	Z		;done with this bunch
 	LD	(COUNTER),A
 	JR	CREATWRITE	;continue
 GETTASK	LD	A,(TASKC1)
 	LD	E,A
 	LD	D,0
 	LD	L,A
 	LD	H,0
 	ADD	HL,HL
 	ADD	HL,DE
 	LD	DE,TASKTBL
 	ADD	HL,DE
 	LD	A,0
 TASKC1	EQU	$-1
 	INC	A
 	CP	20
 	JR	C,TASKC2
 	XOR	A
 TASKC2	LD	(TASKC1),A
 	RET
 TASKTBL	DB	88H,82H,90H
 	DB	84H,90H,89H
 	DB	80H,89H,80H
 	DB	81H,91H,88H
 	DB	0A0H,89H,80H
 	DB	81H,90H,82H
 	DB	82H,84H,84H
 	DB	0A0H,82H,0A0H
 	DB	0A0H,84H,88H
 	DB	89H,0A0H,82H
 	DB	84H,81H,90H
 	DB	81H,84H,80H
 	DB	90H,88H,80H
 	DB	82H,90H,0A0H
 	DB	80H,84H,92H
 	DB	0A2H,80H,84H
 	DB	88H,81H,0A0H
 	DB	80H,0A4H,81H
 	DB	84H,82H,90H
 	DB	81H,0A4H,80H
 ALIVE	CALL	GETTASK
 	LD	DE,3C00H+61
 	LD	A,(HL)
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	LD	A,(HL)
 	LD	(DE),A
 	INC	HL
 	INC	DE
 	LD	A,(HL)
 	LD	(DE),A
 	RET
 ;  **  MESSAGE TEXT  **
 FILMSG	DB	10
 SFILESA	DB	'xxx Files, '
 SGRANSA	DB	'xxx Grans to be copied.',10,0
 FILENAME	DB	'            ',0
 	DB	' / '
 GRANMSG	DB	'xxx Grans',11,0
 MSG00	DB	10,0		;linefeed
 MSG0	DB	1DH,1EH,0
 MSG1	DB	31,'**  File Transfer Utility Mod III  **  by '
 KIM	DB	'Kim Watt'
 	DB	10,'                                                              '
 	DB	10,10,'This program will copy the following files from this',10
 	DB	'diskette onto another TRSDOS III formatted disk on any drive.',10,0
 MSG2AA	DB	'Disk Name/Date:  '
 MSG2	DB	'         -         ',10,0
 MSG3	DB	'                ',10,0
 MSG4	DB	1DH,'Mount SOURCE disk, <KEY>:',0
 MSG5	DB	1DH,'Mount DESTINATION disk, <KEY>:',0
 MSG6	DB	1DH,1EH,'Destination Drive ? ',0
 MSG7	DB	10,'SOURCE Disk READ ERROR !',10,0
 MSG8	DB	10,'DESTINATION Disk READ ERROR !',10,0
 MSG9	DB	10,'DESTINATION Disk WRITE ERROR !',10,0
 MSG10	DB	10,'Program TERMINATED in ERROR.',10,0
 MSG11	DB	10,'CANNOT LOCATE Directory.',10,0
 MSG12	DB	'<< Copy it ? ',0
 MSG13	DB	10,'FILE SPACE FULL !',10,0
 MSG18	DB	'xxx Grans available on destination disk.',10,0
 MSG19	DB	'<KEY> to proceed with copy:',0
 MSG20	DB	'<KEY> to BOOT:',0
 MSG21	DB	10,'Destination Directory Update WRITE ERROR ! ',10,0
 MSG22	DB	'Copying File ==>> ',0
 MSG23	DB	'**  Copy Completed  **',10,0
 MSG24	DB	10,'Internal error.  Notify Breeze/QSD.',10,0
 MSG25	DB	'<< EXISTS, Replace it ? ',0
 MSG26	DB	10,'DISK SPACE FULL !',10,0
 MSG27	DB	'Updating Destination Directory.',10,0
 MSG28	DB	'Not enough grans on Destination Disk, Select files to copy.',10,0
 ;**  BUFFERS  **
 LOWEND	EQU	$&0FF00H	;get even page of memory
 SDIRBUFF	EQU	LOWEND+100H
 DDIRBUFF	EQU	SDIRBUFF+1200H	;room for 10 secs
 DATABUFF	EQU	DDIRBUFF+1200H	;for data I/O
 	END	ENTRY
