FIXGAT ;	       FIXGAT/ASM - Version 1.0
 ;	         NEWDOS80/V2  (III)
 ;	           3rd March 1985
 ;        For NORTHERN BYTES & the PUBLIC DOMAIN
 ;                  by Tony Domigan
 ;  PO Box 150, Thomastown, Victoria, 3074, Australia
 ;MCI-ID:2545121. SOURCE-ID:BCT039. TAB-ID:DOMIPOBOWINN
 ;------------------------------------------------------
 ;
 	ORG	5200H		;Anywhere abv 5200H
 ; ------------  TEST FOR DRIVESPEC ------------------
 PARSER	EQU	$
 	LD	A,(HL)		;Trailing chars?
 	CP	0DH		;Assume drive 0?
 	JR	NZ,DN		;Yes, print msg
 	LD	A,30H
 DN	CP	3AH		;Colon
 	JR	NZ,NUMBER	;Skip if not colon
 	INC	HL		;Yes, colon so ck next
 	LD	A,(HL)		;Get next character
 NUMBER	CP	34H		;> Drive 3?
 	JR	NC,BADNUM	;Yes, bad drive number
 	CP	30H		;>=0and<=3
 	JR	NC,POSTDR	;Yes, use drive number
 BADNUM	LD	A,0A0H		;Illegal drive number
 	JP	4409H		;Error exit
 POSTDR	LD	(DRIVE),A	;Post drv num to FCB
 	LD	(DRVNUM),A	;Post drv num to banner
 ; ------------  CALCULATE PDRIVE POINTER ------------
 CALCS	SUB	30H		;Convert to Binary
 	LD	HL,000AH	;Gap between PDRIVES
 	CALL	4C37H		;NEWDOS Multiply Rtne
 	LD	A,PDRIVE	;LSB PDRIVE address
 	ADD	A,L		;Adjust Pointer
 	LD	L,A		;lsb of pointer
 	LD	H,42H		;msb of pdrive
 	PUSH	HL		;Save :dn pdrive ptr
 	POP	IX		;Xfr it to IX
 ; ------------  RETRIEVE DISK ALLOC BYTES -----------
 PTDIR	LD	A,(IX+0)	;Directory
 	LD	(DIRPT),A	;Store it
 	LD	HL,NDIR		;Convert to..
 	CALL	44D7H		;ASCII string
 SUMLMP	LD	A,(IX+1)	;Total lumps
 	LD	(LUMPS),A
 	LD	HL,NLUMP
 	CALL	44D7H
 TCOUNT	LD	A,(IX+3)	;Track count
 	LD	(TC),A
 	LD	HL,NTC
 	CALL	44D7H
 SPTNO	LD	A,(IX+4)	;Sectors/track
 	LD	(SPT),A
 	LD	HL,NSPT
 	CALL	44D7H
 GPLVAL	LD	A,(IX+5)	;Grans per lump
 	LD	(GPL),A
 	PUSH	AF
 	LD	HL,NGPL
 	CALL	44D7H
 SDIR	POP	AF
 	PUSH	AF
 	LD	L,A		;Place GPL in HL
 	LD	H,00H
 	LD	A,(IX+0)	;DIR lump
 	CALL	4C37H		;Multiply gplxdir
 	LD	A,05H		;5 Sectors/gran
 	CALL	4C39H		;5xtotal grans
 	EX	DE,HL		;Sce string number
 	LD	HL,DIRS		;Dest string
 	CALL	44D2H		;Post to message
 	POP	AF		;Restore GPL
 ; ------------    MAKE STARTING GRAN. ALLOC. BYTE ---
 FGAB	LD	B,A		;Loop=GPL
 	LD	A,0FFH		;All Allocated byte
 FGLOOP	SLA	A		;Zero gran
 	DJNZ	FGLOOP		;Loop til GPL
 	LD	(GAB),A		;Post initz byte
 ; ------------    DISPLAY BANNER --------------------
 BANNER	CALL	01C9H		;CLS
 	LD	HL,BANMSG	;Pt to msg
 	CALL	4467H		;Display msg
 ; ------------    OPEN DIR/SYS OF NOMINATED DRIVE ---
 OPEN	LD	HL,BUFF1	;FCB buffer
 	LD	DE,FCB		;Pt to my FCB
 	LD	B,00H		;LRL=Full sector I/O
 	CALL	4424H		;OPEN	DIR/SYS
 	JP	NZ,EREXIT	;Z=No error
 	LD	A,(LEN)		;File length from FCB
 	SUB	02H		;REL Count=EOF-HIT
 	LD	C,A		;Post page counter to C
 ; ------------   SETUP POINTERS ---------------------
 SETUP	LD	B,08H		;FPDE Slots 0-7
 	LD	(PCOUNT),BC	;Store slot/page
 ; ------------   POSITION TO HIT SECTOR -------------
 INIT	CALL	READ		;Read GAT sector
 ; ------------   PREPARE BUFFERS --------------------
 SETBUF	LD	DE,BUFF2	;Dest=NewGAT
 	LD	BC,100H		;Move sector
 	PUSH	BC		;Save count
 	LDIR			;Move it
 	POP	BC		;Restore Count
 	LDIR			;Move also to OldGAT
 ; ------------   PREP ALLOC TABLE -------------------
 	LD	HL,BUFF2	;New GAT
 DOALLO	LD	A,(LUMPS)	;Lump Count
 	CP	60H		;Existence Table?
 	JR	C,INITZ		;Yes if carry
 BIG	LD	A,0CAH		;No existence table
 	LD	(SIZE+1),A	;post to fill rtne
 	LD	(FLAG),A	;Save BIG flag
 INITZ	CALL	INZ		;Init Allocation Table
 	LD	A,(FLAG)	;Big flag
 	CP	00H		;GET?
 	JR	NZ,SKPHIT	;Skip if no GET
 	LD	A,6CH
 	LD	(FLAG),A	;No-more flag
 	LD	(SIZE+1),A	;Post to fill rtne
 	JR	DOALLO		;Do GET
 INZ	LD	A,(GAB)		;Formed init alloc
 	LD	(PBLOOP+1),A	;Place in loop
 	LD	A,(LUMPS)	;Number of Lumps...
 	LD	B,A		;into loop counter
 	PUSH	BC		;Save lump counter
 	CALL	PBLOOP		;Do unallocated GAT
 SIZE	LD	A,61H		;Standard GAT
 	POP	BC		;Restore counter
 	LD	C,B
 	LD	B,00H
 	LD	E,A
 	LD	D,00H
 	EX	DE,HL
 	SBC	HL,BC
 	LD	A,L
 	EX	DE,HL
 	LD	B,A		;loop val
 	LD	A,0FFH		;Allocated byte
 	LD	(PBLOOP+1),A	;Place in loop
 	CALL	PBLOOP		;Make table
 	RET
 PBLOOP	LD	(HL),00H	;Fill byte
 	INC	HL		;Inc Table pointer
 	DJNZ	PBLOOP
 	RET
 ; ------------   SKIP HIT SECTOR --------------------
 SKPHIT	CALL	READ		;Read HIT sector
 ; ------------   BEGIN LOOP FPDE PAGES --------------
 PAGE	LD	BC,(PCOUNT)	;Page/Slot Count
 	LD	IY,BUFF1	;FPDE pointer
 	CALL	READ		;Read fpde page to buff1
 ; ---------   LOOP FOR 8 FPDE SLOTS PER FPDE PAGE --
 FPDE	PUSH	IY		;save FPDE pointer
 	LD	A,(IY+0)	;First byte of FPDE
 	AND	90H		;Mask for alloc FP/FXDE
 	CP	00H		;Not allocated?
 	JP	Z,NXSLOT	;Skip if no file
 SLOTOK	LD	DE,22		;Rel byte 22H
 	ADD	IY,DE		;Pt to first extent
 SLOTCK	LD	D,00H		;Zero D
 	LD	IX,BUFF2	;New GAT
 	LD	HL,GTABLE	;SET Table
 	LD	A,(IY+0)	;Starting Lump
 	CP	0FFH		;None?
 	JP	Z,NXSLOT	;Skip if so
 	CP	0FEH		;FXDE?
 	JP	Z,NXSLOT	;Skip if so
 	LD	E,A		;DE = Lump
 	ADD	IX,DE		;IX = Lump pos in GAT
 GCOUNT	LD	A,(IY+1)	;Allocation
 	PUSH	AF
 	AND	1FH		;Mask for No. grans
 	INC	A		;Real grans
 	LD	C,A		;Save in C
 GSTART	POP	AF
 	AND	0E0H		;Mask for start Gran
 	RLCA			;Convert..
 	RLCA			; to
 	RLCA			;   binary
 SGLOOP	PUSH	AF
 	LD	A,(GPL)		;Number grans/lump
 	LD	E,A		;Placed in E
 	POP	AF		;Restore Start
 	PUSH	AF
 	CP	E		;Less than GPL
 	JR	C,SGOK		;Skip if so
 ZSB	POP	AF		;Restore Stack
 	XOR	A		;Zero A
 	PUSH	AF		;Save Gran Zero
 	INC	IX		;Bump GAT pointer
 SGOK	LD	E,A		;E=Start gran
 	LD	D,00H
 	LD	HL,GTABLE	;SET table
 	ADD	HL,DE		;HL=SET bit val
 	LD	A,(HL)		;Load it to A
 	LD	(SB+3),A	;Mod SET bit
 SB	SET	0,(IX+0)	;Allocate Gran
 	POP	AF
 	INC	A		;Bump gran ptr
 	DEC	C		;More Grans?
 	JR	NZ,SGLOOP	;Yes, loop for more
 	INC	IY		;Pt to the..
 	INC	IY		;   next Extent
 	JR	SLOTCK		;Ck Next Extent
 GTABLE	DEFB	0C6H		;BIT 0
 	DEFB	0CEH		;    1
 	DEFB	0D6H		;    2
 	DEFB	0DEH		;    3
 	DEFB	0E6H		;    4
 	DEFB	0EEH		;    5
 	DEFB	0F6H		;    6
 	DEFB	0FEH		;    7
 ; ------------ POSITION TO NEXT FPDE SLOT IN PAGE ---
 NXSLOT	EQU	$
 	POP	IY		;Restore FPDE ptr
 	LD	DE,32		;Slot Gap
 	ADD	IY,DE		;New FPDE
 	DEC	B		;Slot count
 	JP	NZ,FPDE		;Loop til end of page
 ; ------------ LOOP FOR ALL FPDE PAGES --------------
 NXFPDE	LD	BC,(PCOUNT)	;Page/Slot count
 	DEC	C		;Next FPDE
 	LD	(PCOUNT),BC	;Save Pointers
 	JP	NZ,PAGE		;Loop for rem pages
 ; ------------ COMPARE OLD & NEW GAT SECTORS --------
 HITCK	EQU	$
 	LD	IX,0000H	;Non-match counter
 	LD	HL,BUFF2	;New GAT table
 	LD	DE,BUFF3	;Old GAT table
 	LD	B,00H		;256 bytes
 CKLOOP	LD	A,(DE)		;Get old GAT code
 	CP	(HL)		;Compare with new
 	JR	Z,SAME		;Skip if the same
 	INC	IX		;Bump error count
 SAME	INC	HL		;Next new GAT code
 	INC	DE		;Next old GAT code
 	DJNZ	CKLOOP		;Loop for whole table
 	PUSH	IX		;Move error count
 	POP	DE		;to DE
 	LD	A,E		;Errors always <256
 	LD	HL,ERRNUM	;Point to error num $
 	PUSH	AF		;Save error count
 	CALL	44D7H		;Load to string
 	LD	HL,ERRNUM	;Point to error msg
 	CALL	4467H		;Display num errors
 	POP	AF		;Restore num errors
 	CP	00H		;No errors?
 	JR	Z,CLOSE		;Yes, omit fix rtne
 	LD	HL,WRPRMT	;Fix Y/N Msg
 	CALL	4467H		;Display msg
 	CALL	49H		;KBWAIT
 	OR	20H		;Cvrt to l/c
 	CP	79H		;yes?
 	JR	Z,YES		;then fixit
 NO	LD	HL,NWMSG	;Abort msg
 	CALL	4467H		;Display it
 	JR	CLOSE		;JP over write rtne
 YES	LD	HL,WRMSG	;Write message
 	CALL	4467H		;Display it
 ; ------------ POSITION TO GAT SECTOR ---------------
 	LD	DE,FCB		;Pt to FCB
 SOF	CALL	443FH		;Move to start of file
 ; ------------ MOVE NEW HIT TO FCB BUFFER ------------
 MOVE	LD	HL,BUFF2	;New GAT buffer
 	LD	DE,BUFF1	;FCB buffer
 	LD	BC,256		;Bytes to move
 	LDIR			;Xfer it
 ; ------------ PREPARE FCB FOR READ-PROTECT WRITE ----
 	LD	A,(FCB)		;FCB 1st byte
 	OR	01H		;Make read-protect
 	LD	(FCB),A		;Ammend FCB
 	LD	A,(FCB+1)	;FCB 2nd byte
 	OR	40H		;Do not update EOF
 	LD	(FCB+1),A	;Ammend FCB
 ; ------------ WRITE WITH VERIFY ---------------------
 WRITE	LD	HL,BUFF1	;New GAT
 	LD	DE,FCB		;DE --> FCB
 	LD	B,00H		;LRL=256
 	CALL	443CH		;Write with verify
 	JR	Z,CLOSE		;Exit if no error
 EREXIT	OR	80H		;Make long err msg
 	CALL	4409H		;Display error msg
 CLOSE	CALL	4428H		;Close FCB
 	JP	402DH		;Exit to DOS
 ; ------------ READ SECTOR --------------------------
 READ	EQU	$
 	PUSH	BC		;Save slot count
 	LD	HL,BUFF1	;FCB buffer
 	LD	DE,FCB		;FCB
 	LD	BC,0000H	;LRL=256
 	CALL	4436H		;Read sector
 	POP	BC		;Restore slot count
 	PUSH	AF		;Save error count
 	CP	1CH		;EOF?
 	JP	Z,EREXIT	;Error exit
 	CP	1DH		;Past EOF?
 	JP	Z,EREXIT	;Error exit
 	POP	AF		;Restore error code
 NOERR	RET	NZ		;Continue if NZ
 ; ------------ READ-PROTECT ERROR -------------------
 NRPERR	LD	A,(NEXT)	;Get next pointer
 	DEC	A		;Pt to last sector read
 	PUSH	HL		;Save FCB ptr
 	LD	HL,RPSR		;Sector num
 	CALL	44D7H		;Post to $
 	LD	HL,NRPMSG	;Nr msg
 	CALL	4467H		;Display it
 	POP	HL		;Restore FCB ptr
 	RET			;Continue processing
 ; ------------ STRINGS AND STORAGE ------------------
 BANMSG	DEFM	'FIXGAT for NEWDOS80/V2 - Drive on Test --> '
 DRVNUM	DEFM	'0'
 	DEFB	0AH
 	DEFB	0AH
 STATS	DEFM	'Disk Stats : '
 NTC	DEFW	2020H
 	DEFM	'H Tracks. '
 NSPT	DEFW	2020H
 	DEFM	'H Sectors/Track. '
 NLUMP	DEFW	2020H
 	DEFM	'H Lumps/Disk.'
 	DEFB	0AH
 	DEFM	'             '
 NGPL	DEFW	2020H
 	DEFM	'H Grans/Lump. '
 	DEFM	'DIRectory Lump/Sector '
 NDIR	DEFW	2020H
 	DEFM	'H/'
 DIRS	DEFW	2020H
 	DEFM	'  H'
 	DEFB	0AH
 	DEFB	0DH
 ERRNUM	DEFM	'  H '
 	DEFM	'Granule Allocation Errors'
 	DEFB	0AH
 	DEFB	0DH
 WRPRMT	DEFM	'Reply Y/N to Repair Diskette Granule Allocation Table'
 	DEFB	0AH
 	DEFB	0DH
 WRMSG	DEFM	'Writing the Corrected GAT Sector Now'
 	DEFB	0DH
 NWMSG	DEFM	'*********   ABORTING   ***  Per Request'
 	DEFB	0DH
 NRPMSG	DEFM	'DIR/SYS FRS : '
 RPSR	DEFM	'00 '
 	DEFM	'is not Read-Protected'
 	DEFB	0AH
 	DEFB	0DH
 PCOUNT	DEFW	0000H
 DIRPT	DEFB	00H
 LUMPS	DEFB	00H
 TC	DEFB	00H
 SPT	DEFB	00H
 GPL	DEFB	00H
 GAB	DEFB	00H
 FLAG	DEFB	00H
 PDRIVE	EQU	91H
 ; ------------ F C B --------------------------------
 FCB	DEFM	'DIR/SYS:'	;Filespec
 DRIVE	DEFM	'0'		;Drivespec
 	DEFB	0DH
 NEXT	DEFB	00H		;Next sector pointer
 	DEFB	00H
 LEN	DEFB	00H		;LSB length of file
 	DEFB	00H
 LUMP	DEFB	00H		;Starting lump
 GRAN	DEFB	00H		;Number of grans
 EXT	DEFS	10H		;Extents
 ; ------------ STORAGE BUFFERS ----------------------
 	ORG	5800H
 BUFF1	DEFS	256		;FCB buffer
 BUFF2	DEFS	256		;New GAT CODE buffer
 BUFF3	DEFS	256		;Orig GAT sector
 	END	PARSER
