SEDIT  00100 ;DAVE ZEVCHAK  03/09/83
00110 ;
00120 ;EDTASM COMPATIBLE FORMAT
00130 ;
00140 ; THIS IS AN EDITOR FILTER FOR LDOS WITH KI/DVR INSTALLED.
00150 ; IT WILL GIVE YOU THE ABILITY TO PULL INFORMATION OFF THE
00160 ; SCREEN AND ROUTE IT AS IF IT WERE COMING FROM THE KEYBOARD.
00170 ; FOR EXAMPLE IF YOU HAVE A LINE OF BASIC CODE IN LINE 500
00180 ; THAT WAS SUPPOSE TO BE IN LINE 4000 YOU CAN EASILY PULL
00190 ; THE CONTENTS OF LINE 500 AND PLACE THEM IN LINE 4000.
00200 ; TO DO THIS LIST 500 (LINE 500 WILL BE LISTED ON THE SCREEN).
00210 ; TYPE 4000 ON THE > PROMPT LINE. THEN TOGGLE ON THE CURSOR
00220 ; WITH <CLEAR> <SHIFT> <Z>. THE BLOCK CURSOR WILL APPEAR ON
00230 ; THE SCREEN ON THE LEFT HAND SIDE MIDWAY DOWN FROM THE TOP.
00240 ; NOW POSITION THE CURSOR OVER THE FIRST CHARACTER IN LINE
00250 ; 500 USING THE <CLEAR> <ARROW> KEYS. THEN USING THE <CLEAR>
00260 ; <SPACE BAR> KEYS WATCH THE INFORMATION APPEAR ON THE PROMPT
00270 ; LINE AFTER THE 4000. PRESS THE <ENTER> KEY. THIS WILL ENTER LINE
00280 ; 4000 INTO THE BASIC PROGRAM. IT WILL ALSO TURN OFF THE BLOCK
00290 ; CURSOR LEAVING IT IN THE SAME POSITION IT WAS LAST IN.
00300 ; TOGGLE THE CURSOR ON THEN OFF THEN ON AGIAN WILL HOME IT
00310 ; BACK TO THE LEFT SIDE MIDWAY DOWN FROM THE TOP.
00320 ;
00330 ; TO INSTALL THIS FILTER ENTER THE FOLLOWING AT THE LDOS PROMT :
00340 ;	FILTER *KI USING EDIT/FLT
00350 ;
00360 ; IF THERE ARE ANY PROBLEMS THE PROGRAM WILL PROMPT YOU.
00370 ; YOU MUST SET *KI TO KI/DVR BEFORE THE PROGRAM WILL BE
00380 ; OPERATIONAL.
00390 ;
00400 ;NOTE : THIS FILTER MUST BE INSTALLED BEFORE MINIDOS/FLT OR
00410 ;KSM/FLT. THESE TWO FILTERS WILL CONFLICT WITH EDIT/FLT IF
00420 ;IT IS INSTALLED AFTER THEM.
00430 ;
00440 ;
00450 	TITLE	'<     Editor filter>'
00460 ;
00470 ;		MODEL III       MODEL I
00480 DISPLY	EQU	4467H		;4467H
00490 KIADDR	EQU	4016H		;4016H
00500 DOADDR	EQU	4020H		;4020H
00510 SYSFLG	EQU	442BH		;430FH
00520 KIJCL	EQU	42BEH		;43BEH
00530 HIGH	EQU	4411H		;4049H
00540 DOS	EQU	402DH		;402DH
00550 LOGOUT	EQU	428AH		;447BH
00560 ABORT	EQU	4030H		;4030H
00570 DEVFLG	EQU	4289H		;441FH
00580 ;
00590 	ORG	5200H
00600 ;
00610 FILTER	PUSH	DE		;SAVE DEVICE DCB
00620 	LD	HL,MESS		;POINT TO MESSAGE
00630 	CALL	DISPLY		;AND DISPLAY IT
00640 	LD	A,(DEVFLG)	;GET DEVICE FLAG
00650 	BIT	04H,A		;CHECK FOR KI ACTIVE
00660 	JP	Z,ERROR		;JUMP IF KI/DVR NOT ACTIVE
00670 	POP	IX		;RECOVER DEVICE DCB
00680 	LD	DE,(KIADDR)	;GET KEYBOARD VECTOR
00690 	LD	A,(SYSFLG)	;GET SYSTEM FLAG
00700 	BIT	05H,A		;CHECK FOR 'DO' FILE ACTIVE
00710 	JR	Z,AROUND	;JUMP AROUND IF NOT ACTIVE
00720 	LD	DE,(KIJCL)	;GET KEYBOARD JCL VECTOR
00730 AROUND	LD	(START1+1),DE	;PLACE VECTOR INTO CALL ROUTINE
00740 	LD	BC,LAST-START	;CALCULATE LENGTH OF ROUTINE
00750 	LD	HL,(HIGH)	;GET HIGH RAM ADDRESS
00760 	LD	(RESET),HL	;SAVE THE PRESENT HIGH ADDRESS
00770 	XOR	A		;CLEAR CARRY FLAG
00780 	SBC	HL,BC		;CALCULATE NEW HIGH ADDRESS
00790 	LD	(HIGH),HL	;SET UP NEW HIGH ADDRESS
00800 	INC	HL		;UP THE ADDRESS ONE
00810 	PUSH	HL		;SAVE IT ON STACK
00820 	LD	DE,SCREEN-START	;GET LENGTH FROM START TO SCREEN
00830 	ADD	HL,DE		;CALCULATE HIGH RAM LOCATION
00840 	LD	(SCR1),HL	;STORE NEW LOCATION IN ROUTINE
00850 	LD	(GOBACK1+1),HL
00860 	LD	(SCR2+1),HL
00870 	LD	(SCR3+1),HL
00880 	LD	(SCR4+1),HL
00890 	LD	(GETIT+1),HL
00900 	LD	(SCR5+1),HL
00910 	LD	(RSTOR1+1),HL
00920 	LD	(RSTOR6+1),HL
00930 	LD	(SCR6+1),HL
00940 	LD	(FIXIT1+1),HL
00950 	LD	(SCR7+1),HL
00960 	POP	HL		;RESTORE HIGH RAM ADDRESS
00970 	PUSH	HL		;SAVE IT AGAIN
00980 	LD	DE,FLAG-START	;CALCULATE LENGTH FROM START TO FLAG
00990 	ADD	HL,DE		;CALCULATE NEW RAM ADDRESS
01000 	LD	(FG1+1),HL	;SAVE IT IN ROUTINE
01010 	LD	(FG2+1),HL
01020 	LD	(SETRST+1),HL
01030 	LD	(FG3+1),HL
01040 	LD	(FG4+1),HL
01050 	POP	HL		;RESTORE HIGH RAM
01060 	PUSH	HL		;SAVE IT
01070 	LD	DE,STORE-START	;CALCULATE OFFSET
01080 	ADD	HL,DE		;CALCULATE NEW RAM LOCATION
01090 	LD	(ST1+1),HL	;PLACE NEW ADDRESS IN ROUTINE
01100 	LD	(ST2+1),HL
01110 	LD	(ST3+1),HL
01120 	LD	(ST4+1),HL
01130 	LD	(ST5+1),HL
01140 	POP	HL		;RESTORE HIGH RAM ADDRESS
01150 	PUSH	HL		;SAVE IT AGAIN
01160 	LD	DE,TEMP-START	;CALCULATE OFFSET
01170 	ADD	HL,DE		;CALCULATE NEW RAM ADDRESS
01180 	LD	(TMP1+1),HL	;SAVE IN ROUTINE
01190 	LD	(TMP2+1),HL
01200 	LD	(TMP3+1),HL
01210 	LD	(TMP4+1),HL
01220 	LD	(TMP5+1),HL
01230 	LD	(TMP6+1),HL
01240 	LD	(TMP7+1),HL
01250 	LD	(TMP8+1),HL
01260 	LD	(TMP9+1),HL
01270 	LD	(GOBACK2+1),HL
01280 	POP	HL		;RESTORE HIGH ADDRESS
01290 	PUSH	HL		;SAVE IT
01300 	LD	DE,GETIT-START	;CALCULATE LENGTH FROM START TO GETIT
01310 	ADD	HL,DE		;CALCULATE NEW ADDRESS
01320 	LD	(INIT+1),HL	;PLACE IN ROUTINE
01330 	LD	(LEFT+1),HL
01340 	LD	(RIGHT+1),HL
01350 	LD	(DOWN+1),HL
01360 	LD	(UP+1),HL
01370 	LD	(FILL+1),HL
01380 	POP	HL		;RESTORE RAM ADDRESS
01390 	PUSH	HL
01400 	LD	DE,FLAG1-START
01410 	ADD	HL,DE
01420 	LD	(FLG1+1),HL
01430 	LD	(FLG2+1),HL
01440 	LD	(FLG3+1),HL
01450 	POP	HL
01460 	PUSH	HL
01470 	LD	DE,FIXIT1-START
01480 	ADD	HL,DE
01490 	LD	(FIX+1),HL
01500 	POP	HL
01510 	PUSH	HL		;SAVE IT
01520 	PUSH	HL
01530 	POP	DE		;GET HIGH RAM ADDRESS INTO DE
01540 	LD	HL,START	;POINT TO ROUTINE
01550 	LDIR			;MOVE IT INTO HIGH RAM
01560 	DI			;STOP INTERRUPTS
01570 	LD	(IX+00H),05H	;SET UP DEVICE TYPE
01580 	POP	HL		;GET HIGH RAM ADDRESS
01590 	LD	A,(SYSFLG)	;GET SYSTEM FLAG
01600 	BIT	05H,A		;CHECK FOR DO ACTIVE
01610 	JR	NZ,ARND13	;JUMP IF DO ACTIVE
01620 	LD	(IX+1),L	;SAVE NEW ADDRESS IN KI VECTOR
01630 	LD	(IX+2),H
01640 	JR	ARND15		;JUMP AROUND
01650 ARND13	LD	(KIJCL),HL	;SAVE NEW ADDRESS IN KI JCL VECTOR
01660 ARND15	EI			;ENABLE INTERRUPTS
01670 	JP	DOS		;JUMP BACK TO LDOS
01680 ERROR	LD	HL,MESS1	;POINT TO ERROR MESSAGE
01690 	CALL	LOGOUT		;DISPLAY IT
01700 	JP	ABORT		;ABORT FILTER
01710 ;
01720 ;
01730 ; START OF THE EDITOR ROUTINE
01740 ;	<CLEAR> <SHIFT> <Z>    TOGGLES CURSOR
01750 ;	<CLEAR> <UP ARROW>     MOVES CURSOR UP
01760 ;	<CLEAR> <DOWN ARROW>   MOVES CURSOR DOWN
01770 ;	<CLEAR> <LEFT ARROW>   MOVES CURSOR LEFT
01780 ;	<CLEAR> <RIGHT ARROW>  MOVES CURSOR RIGHT
01790 ;	<CLEAR> <SPACE BAR>    PRINTS CHARACTER UNDER CURSOR AND MOVES RIGHT ONE
01800 ;	<BREAK>, <ENTER>, AND <DOWN ARROW> TURN CURSOR OFF (SCROLL SCREEN)
01810 ;
01820 START	JR	START1		;JUMP AROUND IDENTIFIER
01830 RESET	DB	00H		;STORAGE FOR OLD HIGH RAM
01840 	DB	00H
01850 	DB	09H
01860 	DB	'EDIT'		;FILTER NAME
01870 	DB	31H		;VERSION NUMBER
01880 START1	CALL	0000H		;CALL KEYBOARD ROUTINE
01890 	PUSH	AF		;SAVE KEYBOARD CHARACTER
01900 	CP	0FAH		;CHECK FOR CLEAR SHIFT Z
01910 	JR	Z,SETRST	;JUMP IF CURSOR ON COMMAND
01920 FLG1	LD	A,(FLAG1)	;GET CURSOR UP FLAG
01930 	CP	0FFH		;CHECK FOR ON
01940 FIX	CALL	Z,FIXIT1	;GOSUB IF ON
01950 FG1	LD	A,(FLAG)	;GET CURSOR FLAG
01960 	CP	0FFH		;CHECK FOR ON
01970 	JR	NZ,RETURN	;RETURN IF OFF
01980 	POP	AF		;RESTORE KEYBOARD CHARACTER
01990 	PUSH	AF		;SAVE IT AGAIN
02000 	CP	01H		;CHECK FOR BREAK KEY
02010 	JR	Z,INIT		;JUMP IF BREAK KEY
02020 	CP	0AH		;CHECK FOR LF KEY
02030 	JR	Z,INIT		;JUMP IF SO
02040 	CP	0DH		;CHECK FOR CR KEY
02050 	JR	Z,INIT		;JUMP IF ENTER KEY
02060 	CP	088H		;CHECK FOR CLEAR LEFT ARROW
02070 	JR	Z,LEFT		;JUMP IF LEFT ARROW
02080 	CP	0DBH		;CHECK FOR CLEAR UP ARROW
02090 	JR	Z,UP1		;JUMP IF UP ARROW
02100 	CP	089H		;CHECK FOR CLEAR RIGHT ARROW
02110 	JR	Z,RIGHT1	;JUMP IF RIGHT ARROW
02120 	CP	08AH		;CHECK FOR CLEAR DOWN ARROW
02130 	JR	Z,DOWN1		;JUMP IF DOWN ARROW
02140 	CP	0A0H		;CHECK FOR CLEAR SPACE BAR
02150 	JR	Z,FILL1		;JUMP IF SPACE BAR
02160 RETURN	POP	AF		;OTHER WISE RESTORE KEY CHAR
02170 	RET			;AND RETURN
02180 RETURN1	POP	AF		;RESTORE KEY CHAR
02190 	XOR	A		;DISCARD IT
02200 	RET			;RETURN TO CALLER
02210 ;
02220 INIT	CALL	GETIT		;GET SCREEN CHAR BACK
02230 	LD	HL,3E00H	;HL = MIDDLE OF DISPLAY
02240 SCR1	LD	(SCREEN),HL	;SAVE IT IN SCREEN STORAGE
02250 	XOR	A		;CLEAR A
02260 FG2	LD	(FLAG),A	;SET CURSOR TO OFF
02270 	JR	RETURN		;RETURN TO CALLER
02280 ;
02290 SETRST	LD	A,(FLAG)	;GET CURSOR FLAG
02300 	CP	0FFH		;CHECK FOR ON
02310 	JR	Z,AHEAD		;JUMP IF ON
02320 	LD	A,0FFH		;OTHER WISE TURN IT ON
02330 FG3	LD	(FLAG),A	;SAVE IT
02340 GOBACK1	LD	HL,(SCREEN)	;GET SCREEN LOCATION
02350 GOBACK	LD	A,(HL)		;GET SCREEN CHARACTER
02360 ST1	LD	(STORE),A	;SAVE IT
02370 	LD	A,8FH		;BLOCK CURSOR
02380 	LD	(HL),A		;PLACE ON SCREEN
02390 SCR2	LD	(SCREEN),HL	;SAVE SCREEN LOCATION
02400 	JR	RETURN1		;RETURN TO CALLER
02410 AHEAD	XOR	A		;CLEAR A
02420 FG4	LD	(FLAG),A	;TURN CURSOR OFF
02430 SCR3	LD	HL,(SCREEN)	;GET SCREEN LOCATION
02440 ST2	LD	A,(STORE)	;GET SCREEN CHAR
02450 	LD	(HL),A		;PLACE BACK ON SCREEN
02460 	LD	HL,3E00H	;SET HL = MIDDLE OF SCREEN
02470 SCR4	LD	(SCREEN),HL	;SAVE SCREEN LOCATION
02480 	JR	RETURN1		;RETURN TO CALLER
02490 ;
02500 DOWN1	JR	DOWN		;JUMP VECTORS
02510 UP1	JR	UP
02520 RIGHT1	JR	RIGHT
02530 FILL1	JR	FILL
02540 ;
02550 LEFT	CALL	GETIT		;GET SCREEN CHARACTER ON SCREEN
02560 	DEC	HL		;GO LEFT ONE CHARACTER
02570 TMP1	LD	(TEMP),HL	;SAVE SCREEN LOCATION TEMPORARILY
02580 	LD	BC,3C00H	;CHECK FOR UNDER SHOOT
02590 	XOR	A
02600 	SBC	HL,BC
02610 	JR	C,RSTORT	;JUMP IF OFF SCREEN
02620 TMP2	LD	HL,(TEMP)	;RETORE OLD LOCATION
02630 	JR	GOBACK		;MOVE CURSOR AND RETURN
02640 RSTORT	LD	HL,3FFFH	;UNDER SHOOT GO TO BOTTOM OF DISPLAY
02650 	JR	GOBACK		;MOVE CURSOR AND RETURN
02660 ;
02670 RIGHT	CALL	GETIT		;GET SCREEN CHARACTER
02680 	INC	HL		;RIGHT ONE CHARACTER
02690 TMP3	LD	(TEMP),HL	;SAVE NEW SCREEN LOCATION
02700 	LD	BC,4000H	;CHECK FOR OVER SHOOT
02710 	XOR	A
02720 	SBC	HL,BC
02730 	JR	NC,RSTORB	;JUMP IF OVER SHOOT
02740 TMP4	LD	HL,(TEMP)	;ELSE RESTORE NEW SCREEN LOCATION
02750 	JR	GOBACK		;MOVE CURSOR AND RETURN
02760 RSTORB	LD	HL,3C00H	;MOVE TO TOP OF SCREEEN
02770 	JR	GOBACK		;MOVE CURSOR AND RETURN
02780 ;
02790 DOWN	CALL	GETIT		;GET OLD SCREEN CHARACTER
02800 	LD	BC,0040H	;CALCULATE DOWN LOCATION
02810 	ADD	HL,BC
02820 TMP5	LD	(TEMP),HL	;SAVE IT TEMP STORAGE
02830 	LD	BC,4000H	;CHECK FOR OVER SHOOT
02840 	XOR	A
02850 	SBC	HL,BC
02860 	JR	NC,RSTOR1	;JUMP IF OVER SHOOT
02870 TMP6	LD	HL,(TEMP)	;OTHERWISE RESTORE LOCATION
02880 RSTOR2	JR	GOBACK		;MOVE CURSOR AND RETURN
02890 RSTOR1	LD	HL,(SCREEN)	;GET OLD LOCATION
02900 	LD	BC,960		;BC = 960
02910 	XOR	A		;CLEAR CARRY
02920 	SBC	HL,BC		;BACK TO TOP OF SCREEN
02930 	JR	GOBACK		;MOVE CURSOR AND RETURN
02940 ;
02950 UP	CALL	GETIT		;GET OLD SCREEN CHARACTER
02960 	LD	BC,0040H	;CALCULATE MOVE UPWARDS
02970 	XOR	A
02980 	SBC	HL,BC
02990 TMP7	LD	(TEMP),HL	;SAVE CALCULATION
03000 	LD	BC,3C00H	;CHECK FOR UNDER SHOOT
03010 	XOR	A
03020 	SBC	HL,BC
03030 	JR	C,RSTOR6	;JUMP IF UNDER SHOOT
03040 TMP8	LD	HL,(TEMP)	;OTHERWISE RESTORE CALCULATION
03050 	JR	RSTOR2		;MOVE CURSOR AND RETURN
03060 RSTOR6	LD	HL,(SCREEN)	;GET OLD LOCATION
03070 	LD	BC,960
03080 	ADD	HL,BC		;CALCULATE NEW LOCATION
03090 	JR	RSTOR2		;MOVE CURSOR AND RETURN
03100 ;
03110 GETIT	LD	HL,(SCREEN)	;GET OLD SCREEN LOCATION
03120 ST3	LD	A,(STORE)	;GET OLD SCREEN CHARACTER
03130 	LD	(HL),A		;PLACE IT IN A
03140 	RET			;RETURN TO CALLER
03150 ;
03160 FILL	CALL	GETIT		;GET OLD SCREEN CHARACTER
03170 	LD	D,A		;SAVE IT IN D
03180 	INC	HL		;UP THE SCREEN LOCATION BY ONE
03190 TMP9	LD	(TEMP),HL	;SAVE THE NEW LOCATION
03200 	LD	BC,4000H	;CHECK FOR OVER SHOOT
03210 	XOR	A
03220 	SBC	HL,BC
03230 	JR	NC,RSTOR3	;JUMP IF OVER SHOOT
03240 GOBACK2	LD	HL,(TEMP)	;OTHERWISE GET NEW LOCATION
03250 GOBACK3	LD	A,(HL)		;GET NEW CHARACTER
03260 ST4	LD	(STORE),A	;SAVE IT
03270 	LD	A,8FH		;GET CURSOR CHARACTER
03280 	LD	(HL),A		;PLACE ON SCREEN
03290 SCR5	LD	(SCREEN),HL	;SAVE NEW LOCATION
03300 	LD	A,(DOADDR+1)	;GET HIGH DISPLAY ADDRESS
03310 	CP	3FH		;CHECK FOR BOTTOM 4 LINES
03320 	JR	NZ,OUTIT	;JUMP IF NOT BOTTOM
03330 	LD	A,(DOADDR)	;GET LOW DISPLAY ADDRESS
03340 	CP	0FFH		;CHECK FOR LAST LINE
03350 	JR	Z,FIXIT		;JUMP IF END
03360 OUTIT	POP	AF		;RESTORE KEYBOARD CHARACTER
03370 	LD	A,D		;OVERWRITE WITH SCREEN CHARACTER
03380 	RET			;RETURN TO CALLER
03390 RSTOR3	LD	HL,3C00H	;GO TO TOP OF SCREEN
03400 	JR	GOBACK3		;MOVE CURSOR, PRINT CHARACTER AND RETURN
03410 FIXIT	LD	A,0FFH		;SET UP TO FIX WRAP AROUND
03420 FLG2	LD	(FLAG1),A
03430 	JR	OUTIT
03440 FIXIT1	LD	HL,(SCREEN)	;FIX WRAP AROUND PROBLEM
03450 	LD	BC,0040H	;BACK CURSOR UP ONE LINE
03460 	XOR	A
03470 	SBC	HL,BC
03480 SCR6	LD	(SCREEN),HL	;SAVE ADDRESS
03490 	LD	A,(DOADDR)	;COMPARE DISPLAY ADDRESS
03500 	LD	C,A		;AGAINST CURSOR ADDRESS
03510 SCR7	LD	A,(SCREEN)	;IF EQUAL THEN SKIP FIX
03520 	LD	B,04H
03530 LOOP25	CP	C
03540 	JR	Z,ARNDIT
03550 	ADD	A,40H
03560 	DJNZ	LOOP25
03570 ST5	LD	A,(STORE)	;SCREEN NEEDS FIXED SO FIX
03580 	LD	(HL),A
03590 	LD	A,8FH
03600 	LD	(HL),A
03610 ARNDIT	XOR	A		;CANCEL FIX FLAG
03620 FLG3	LD	(FLAG1),A
03630 	RET
03640 ;
03650 SCREEN	DW	3E00H
03660 FLAG	DB	00H
03670 STORE	DB	00H
03680 TEMP	DW	0000H
03690 FLAG1	DB	00H
03700 LAST	EQU	$
03710 ;
03720 MESS	DB	LF,'EDITOR FILTER BY DAVE ZEVCHAK',CR,LF
03730 MESS1	DB	'EDITOR NEES KI/DVR ACTIVE',CR
03740 CR	EQU	13
03750 LF	EQU	10
03760 	END	FILTER

