EDPATC ;********************************************************
 ;*		A PATCH OF A PATCH			*
 ;*							*
 ;*TRANSFERRING MICROSOFT'S EDTASM-PLUS MODEL I CASSETTE *
 ;*PROGRAM TO A MODEL III DISK (WITH THE ADDED VIRTUE OF *
 ;*SAVING SOURCE TEXT TO DISK.)				*
 ;*							*
 ;*		NATE SALSBURY				*
 ;*		610 MADAM MOORE'S LANE			*
 ;*		NEW BERN, NC   28560			*
 ;*							*
 ;********************************************************
 ;*							*
 ;*THE FIRST PART OF THIS 2-PATCH LISTING (LINES 470 TO	*
 ;*1840) APPEARED IN THE OCTOBER '81 EDITION OF '80 MICRO*
 ;*COMPUTING', PAGE 344. THE AUTHOR WAS ARNE RHODE. THE	*
 ;*READER IS REFERRED TO THE ARTICLE FOR A DETAILED DIS-	*
 ;*CUSSION OF THAT PART OF THIS LISTING. IT HAS BEEN RE-	*
 ;*PEATED HERE FOR CONVENIENCE IN REVIEWING MY ADDITIONS.*
 ;*							*
 ;*THE ORIGINAL ARTICLE DISCUSSES VARIOUS TECHNIQUES FOR	*
 ;*INITIALLY GETTING THE CASSETTE VERSION TO YOUR DISK.	*
 ;*							*
 ;*SEVERAL CHANGES WERE MADE BY ME TO ACCOMODATE MY MACH-*
 ;*INE AND MY VERSION OF EDTASM-PLUS. THESE CHANGES ARE	*
 ;*DISCUSSED IN THE TEXT OF THIS ARTICLE.		*
 ;*							*
 ;********************************************************
 ;
 ;	+++++++++++++++++++++++++++++++
 ;	+ I M P O R T A N T   N O T E +
 ;	+++++++++++++++++++++++++++++++
 ;
 ;TO USE THESE PATCHES YOU GIVE UP THE EDTASM 'QUASH'
 ;FEATURE. IT IS REPLACED BY COMMANDS TO EXIT EDTASM
 ;AND STORE YOUR SOURCE TEXT ON DISK.
 ;
 BFSTAD	EQU	8210H		;START OF 'DUMP' BUFFER
 				; WHICH IS 7390H (BUFST)
 				; + 0E80H OFFSET FROM
 				; 4380H TO 5200
 BFENAD	EQU	BFSTAD+2	;END OF ACTUAL TEXT=8212H
 BUFFER	EQU	BFENAD+2	;TEMP STORGE BUFFER=8214H
 ;
 ;********************************************************
 ;	CHANGE THIS EQU FOR YOUR MACHINE IF NEEDED
 ;
 MEMEND	EQU	0FFFFH
 ;
 ;********************************************************
 ;
 ;YOU MAY HAVE TO 'ORG' AT DIFFERENT ADDRESS. THE ARTICLE
 ;IN '80 MICROCOMPUTING' HAS INFORMATION ON HOW TO FIND
 ;THE RIGHT PLACE IN YOUR EDTASM-PLUS.
 ;
 	ORG	6486H		;START OF 'QUASH' SEQ
 ;
 ;********************************************************
 	LD	HL,(4232H)	;END OF EDTASM TEXT PTR
 	PUSH	HL		;SAVE END ADDRESS
 	LD	DE,(4230H)	;START OF EDTASM TEXT PTR
 	PUSH	DE		;SAVE START ADDR
 	INC	HL		;MOVE PAST TWO 0FFH
 	INC	HL		  ;BYTES AT END OF TEXT
 	PUSH	HL		;SAVE THIS POINT TOO
 	INC	HL		;JUST PAST END OF ALL TXT
 	XOR	A		;CLEAR CARRY
 	SBC	HL,DE		;FIND LENGTH TO MOVE
 	LD	B,H
 	LD	C,L		;BYTE COUNT TO BC
 	LD	HL,BUFFER-1	;DEST ADDR -1..
 	ADD	HL,BC		  ; + LEN = END ADDRESS
 	EX	DE,HL		;DE HAS BUFFER END ADDR
 	POP	HL		;END OF EDTASM SOURCE
 	PUSH	DE		;SAVE END OF BUFFER ADDR
 	LDDR			;MOVE TEXT TO BUFFER
 	POP	DE		;END OF BUFFER AGAIN
 	POP	HL		;START OF EDTASM SOURCE
 	LD	(BFSTAD),HL	;SAVE EDTASM START ADDR
 	POP	HL		;END OF EDTASM SOURCE
 	LD	(BFENAD),HL	;SAVE EDTASM END ADDR
 	LD	HL,DMPADR	;SCREEN TXT FOR 'DUMP'
 	LD	A,D		;MSB END OF BUFFER ADDR
 	CALL	CNVL		;TOP 4 BITS TO HEX
 	LD	A,D
 	CALL	CNVR		;LOW 4 BITS TO HEX
 	LD	A,E		;LSB OF END OF TEXT
 	CALL	CNVL		;TOP 4 BITS TO HEX
 	LD	A,E
 	CALL	CNVR		;LOW 4 BITS TO HEX
 	LD	HL,TEXT
 	CALL	4532H	;TEXT TO SCREEN VIA EDTASM
 WTSPC	EQU	$
 	LD	A,(3840H)	;KEYBOARD MEMORY
 	AND	80H		;ISOLATE 'SPACE'
 	JR	Z,WTSPC		;ONLY GO ON 'SPACE'
 	JP	0		;RE-BOOT WHEN DONE
 ;
 ;  NOW, GO TO END OF ACTUAL EDTASM PROGRAM AND ADD MORE
 ;
 	ORG	7284H		;JUST PAST END OF EDTASM+
 ;
 ;CONVERT NIBBLE TO A HEX CHARACTER
 ;
 CNVL	EQU	$
 	RRCA
 	RRCA
 	RRCA
 	RRCA			;MOVE MSB TO LSB
 CNVR	EQU	$
 	AND	0FH		;REMOVE UPPER HLF
 	OR	30H		;TEST FOR NUMERIC
 	CP	3AH		;CHECK FOR ALPHA
 	JR	C,HEXOK		;IT'S A NUMBER
 	ADD	A,07H		;CONVERT TO A-F
 HEXOK	EQU	$
 	LD	(HL),A		;STORE IN SCREEN MSG
 	INC	HL		;TO NEXT SPOT IN MSG
 	RET
 TEXT	DEFW	0A0AH		;TWO LINE FEEDS
 	DEFM	'RECORD FOLLOWING INFORMATION'
 	DEFW	0A0AH		;TWO LINE FEEDS
 	DEFM	'DUMP FILESPEC NAME '
 	DEFM	'8210H'		;START OF RELOCATED SRC
 	DEFB	20H
 DMPADR	DEFM	'XXXXH'		;PROGRAM FILLS THIS IN
 				  ;AS 'END' OF DUMP
 	DEFB	20H
 ;
 ;TRANSFER ADDRESS FOLLOWS. CALCULATED=> PROG SHIFTED BY
 ;5200H-4380H=E80H. THE 'TRANSFER' SECTION IS NOW 'ORG' AT
 ;7330H. THEREFORE, 7330H+E80H=81B0H - ADDRESS FOR TRANS-
 ;FER ROUTINE WHEN PROGRAM IS FIRST LOADED IN FROM DISK.
 ;
 	DEFM	'81B0H'		;ENTRY POINT TO MOVE ALL
 				  ;THE 'TRANSFER' ADDRESS
 	DEFW	0A0AH		;TWO LINE FEEDS
 	DEFM	'WHEN READY, HIT SPACE BAR TO BOOT'
 	DEFB	80H		;EDTASM TERMINATOR
 ;
 ;ENTRY POINT AFTER EDTASM RELOCATED BY ROUTINE @ 7330H
 ;
 BEGIN	EQU	$
 	LD	SP,4380H	;EDTASM STACK
 	LD	HL,(BFSTAD)	;START OF EDTASM TXT BUF
 	LD	(4230H),HL	;STORE IN EDTASM
 	PUSH	HL		;START OF EDTASM TXT
 	LD	HL,(BFENAD)	;END OF EDTASM TXT BUF
 	LD	(4232H),HL	;STORE IN EDTASM
 	INC	HL
 	INC	HL
 	NOP
 	POP	DE		;START OF EDTASM TEXT BUF
 	XOR	A		;CLEAR CARRY
 	SBC	HL,DE		;LENGTH TO MOVE
 	LD	B,H
 	LD	C,L		;BC HAS BYTE COUNT
 	LD	HL,BUFFER	;START OF MOVE
 	LDIR			;MOVE DUMPED TXT TO EA+
 	LD	HL,MEMEND
 	LD	(4236H),HL	;STORE IN EDTASM
 	DEC	HL
 	LD	(4234H),HL	;ANOTHER EDTASM PTR
 	JP	4383H		;EDTASM WARM START ENTRY
 ;
 ; THIS SEQUENCE RELOCATES EDTASM+ AFTER LOADING FROM DISK
 ;
 	ORG	7330H
 	DI
 	LD	BC,ENDTXT-4380H+2	;# BYTES TO MOVE
 	LD	HL,5200H	;HL => SOURCE
 	LD	DE,4380H	;DE => DESTINATION
 	LDIR			;MOVE DUMPED PROGRAM
 	JP	BEGIN		;GO TO NEXT STEP
 ;
 ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 ;+							+
 ;+THIS IS THE END OF THE ORIGINAL PATCH WHICH APPEARED	+
 ;+IN THE REFERENCED '80 MICROCOMPUTING' ARTICLE.	+
 ;+							+
 ;+THE FOLLOWING PATCHES ARE THE AUTHOR'S TO ALLOW USE	+
 ;+OF THE PREVIOUS MATERIAL ON A MODEL III.		+
 ;+							+
 ;++++++++++++++++++++++++++++++++++++++++++++++++++++++++
 ;
 ;      +++++++++++++++++++++++++++++++++++++++++++++++++
 ;	AFTER EDTASM+ IS MOVED INTO PLACE, CHANGE 'CALL
 ;	4408H' AT 4FD4H & 4FFEH TO CALL HERE INSTEAD
 ;      +++++++++++++++++++++++++++++++++++++++++++++++++
 ;
 CASSON	EQU	$		;PATCH WHEN TAPE STARTS
 ;
 	CALL	4408H		;EA+ CALL WE INTERRUPTED
 				 ;TO GET 'READY CASSETTE'
 				 ;MESSAGE
 	XOR	A
 	LD	(4211H),A	;SET LOW CASSETTE SPEED
 	LD	HL,4203H	;LOCN OF 'BK' VECTOR
 				  ;DURING TAPE LOADS
 	LD	DE,SAVBRK	;PLACE TO STORE IT
 	LD	BC,03H		;# CHARS TO MOVE
 	LDIR			;SAVE 'EM
 	LD	A,0C3H		;'JUMP' INSTRUCTION
 	LD	(4203H),A	  ;FOR TAPE 'BREAK' TO GO
 	LD	HL,4283H	  ;TO EA+ 'WARM' REENTRY
 	LD	(4204H),HL	;PUT THIS IN JUMP VECTOR
 	LD	E,0D3H		;RELOAD E WITH SOURCE
 				  ;TAPE'S FIRST BYTE
 	RET			;TO EA+ MAIN PROGRAM
 ;
 ;      ++++++++++++++++++++++++++++++++++++++++++++++++
 ;	AFTER EDTASM+ IS MOVED INTO PLACE, CHANGE 'CALL
 ;	01F8H' AT 44CFH, 4D1FH, 650DH & 71C6H TO CALL
 ;	HERE INSTEAD.
 ;      ++++++++++++++++++++++++++++++++++++++++++++++++
 ;
 CASOFF	EQU	$
 ;
 	LD	A,(4213H)	;GET EA+ BYTE
 	LD	(STORE),A	;SAVE IT
 	LD	A,04H		;'REGULAR' DOS BYTE
 	LD	(4213H),A	;PUT IT THERE
 	CALL	01F8H		;TURN OFF CASSETTE
 	DI			;A  'M U S T'
 	LD	A,(STORE)	;GET EA+ BYTE BACK
 	LD	(4213H),A	  ;AND REPLACE IT
 	LD	HL,SAVBRK	;RESTORE 'BK' VECTOR
 	LD	DE,4203H
 	LD	BC,0003H
 	LDIR
 	RET			;TO EA+
 SAVBRK	DEFS	3		;STORAGE FOR 'BK' VECTOR
 STORE	DEFB	00H		;SAVE (4213H) HERE
 EXTRA	DEFS	0CH		;TO START BUFFER AT 7390H
 				 ;AND, IN CASE I THINK OF
 				 ;ANYTHING ELSE!
 ;
 ;WE MUST SET UP DUMMY TEXT AND ADDRESSES IN EVENT WE
 ;START WITH AN EMPTY TEXT BUFFER. THIS IS REQD SINCE
 ;START-UP IS THROUGH THE 'WARM' ENTRY TO EDTASM+. IF A
 ;REAL SOURCE IS USED, THE 'DUMMY' WILL BE OVERLAID.
 ;
 BUFST	DEFW	$		;EA+ WILL START SOURCE
 				  ;TEXT AT THIS ADDRESS
 BUFEND	DEFW	$-2		;SEE 10/81 '80 MICRO' ART
 ENDTXT	DEFW	0FFFFH		;EA+ END-OF-TEXT MARKER
 	END
