; dpcopy1/asm - kjw/bqsd - 10/82
;
;	data storage areas
;
DRIVES	DEFB	0		;drives active in chain
	DEFB	0
	DEFB	0
	DEFB	0
;
XDRIVES	DEFB	0		;drives locked in chain
	DEFB	0
	DEFB	0
	DEFB	0
;
COPIES	DEFW	0		;# copies requested
COUNT	DEFW	0		;# copies completed
CURPTR	DEFW	0		;indirect cursor pointer
;
;	clear current line, move to next line
;
CLRLIN	DEFB	13		;advance next line
	DEFB	11		;up one line
	DEFB	23		;clear this line
	DEFB	13		;advance next line
	DEFB	03		;end of text
;
;	clear current line, reset cursor to beginning
;
CLRIT	DEFB	13		;advance next line
	DEFB	11		;up one line
	DEFB	23		;clear this line
	DEFB	03		;end of text
;
;	serial # storage area
;
SER0	DEFS	32		;serial # drive 0
SER1	DEFS	32		;serial # drive 1
SER2	DEFS	32		;serial # drive 2
SER3	DEFS	32		;serial # drive 3
SERX	DEFS	32		;serial # work area
;
;	lookup table for serial numbers
;
SERTBL	DEFW	SER0		;drive 0
	DEFW	SER1		;drive 1
	DEFW	SER2		;drive 2
	DEFW	SER3		;drive 3
;
;	IY always points to following table
;	for quick reference
;
TABLE	DEFB	'Y'	;+00 - verify flag
	DEFB	0	;+01 - source drive binary
	DEFB	0	;+02 - dest drive current
	DEFB	'*'	;+03 - auto serial #
	DEFB	0	;+04 - current track
	DEFB	77	;+05 - track count destination
	DEFB	0	;+06 - verify retry flag
	DEFB	0	;+07 - current counter
	DEFB	2	;+08 - # retries
	DEFB	0	;+09 - current try
	DEFB	0	;+10 - inner loop retry
	DEFB	0	;+11 - track serial number
	DEFB	0	;+12 - sector serial number
	DEFB	0	;+13 - byte serial number
	DEFB	-1	;+14 - initialization byte
	DEFB	0	;+15 - serial # length
	DEFB	0	;+16 - true = format
	DEFB	0	;+17 - true = copy
	DEFB	0	;+18 - gat to skip tracks
	DEFB	0	;+19 - gat skip byte
	DEFB	27	;+20 - # sectors track 0
	DEFB	30	;+21 - # sectors disk
	DEFB	0	;+22 - # sectors loaded in RAM
	DEFB	6	;+23 - outer level # retries +1
	DEFB	3	;+24 - inner level # retries +1
;
;	text area
;
MSG0	DEFM	'Use GAT to skip tracks '
	DEFM	'(default yes) ? '
	DEFB	03
;
MSG00	DEFM	'GAT track mask byte (default C0H) ? '
	DEFB	03
;
HELLO	DEFB	1BH
	DEFM	'DPCOPY - DosPLUS II Copy Utility - '
	DEFM	'Version A.00'
	DEFB	13
	DEFM	'(c)(p) 1982 by '
	DEFM	'MicroPower, Inc.'
	DEFB	13
	DEFB	13
	DEFB	03
;
MSG1	DEFM	'Number of Copies (default 100) ? '
	DEFB	03
;
MSG2	DEFM	'Byte for Byte Verify (default Yes) ? '
	DEFB	03
;
MSG3	DEFM	'Source Drive (default 0) ? '
	DEFB	03
;
MSG4	DEFM	'Destination Drives (default '
MSG4A	DEFM	'x,x,x) ? '
	DEFB	03
;
MSG5	DEFB	13
	DEFM	'Mount all disks, key <ENTER>'
	DEFM	' to begin: '
	DEFB	03
;
MSG6	DEFM	'All Copies Completed - '
	DEFM	'Key <ENTER> to restart: '
	DEFB	03
;
MSG7	DEFB	13
	DEFB	11
	DEFM	'Formatting Drive '
MSG7A	DEFM	'x '
	DEFB	23
	DEFB	03
;
MSG8	DEFM	'Source and Destination '
	DEFM	'SAME DRIVE !'
	DEFB	13
	DEFB	03
;
MSG9	DEFM	'No DESTINATION Drives !'
	DEFB	13
	DEFB	03
;
MSG20	DEFB	13
	DEFM	'Program Error - '
	DEFB	03
;
MSG21	DEFM	'Drive '
MSG21A	DEFM	'x Removed From Que !'
	DEFB	13
	DEFB	03
;
MSG24	DEFB	13
	DEFM	'Drive NOT READY - '
	DEFB	03
;
MSG25	DEFB	13
	DEFB	11
	DEFM	'Reading    Drive '
MSG25A	DEFM	'x '
	DEFB	23
	DEFB	03
;
MSG26	DEFB	13
	DEFB	11
	DEFM	'Writing    Drive '
MSG26A	DEFM	'x '
	DEFB	23
	DEFB	03
;
MSG27	DEFB	13
	DEFB	11
	DEFM	'Verifying  Drive '
MSG27A	DEFM	'x '
	DEFB	23
	DEFB	03
;
MSG28	DEFB	13
	DEFM	'Drive NOT IN SYSTEM - '
	DEFB	03
;
MSG29	DEFM	'SOURCE ERROR - cannot continue!'
	DEFB	13
	DEFB	03
;
MSG30	DEFB	13
	DEFM	'Drive '
MSG30A	DEFM	'x Copied OK'
	DEFB	03
;
MSG31	DEFB	13
	DEFM	'Drive '
MSG31A	DEFM	'x BAD COPY - Do Not Use'
	DEFB	03
;
MSG32	DEFB	13
MSG32A	DEFM	'xxxxx Copies Completed of '
MSG32B	DB	'xxxxx'
	DEFB	13
	DEFB	13
	DEFB	03
;
MSG33	DEFM	'Testing Buffer Memory ...'
	DEFB	13
	DEFB	03
;
MSG34	DEFM	'FAULTY MEMORY - 64K Required'
	DEFB	13
	DEFB	03
;
MSG35	DEFB	13
	DEFM	'Data Mismatch - '
	DEFB	03
;
MSG36	DEFM	'Auto Serial Number (default yes) ? '
	DEFB	03
;
MSG37	DEFM	'Starting Serial Number ? '
	DEFB	03
;
MSG38	DEFM	'Serial Number for Drive '
MSG38A	DEFM	'x ? '
	DEFB	03
;
MSG39	DEFB	13
	DEFB	11
	DEFM	'Installing Serial Numbers ...'
	DEFB	23
	DEFB	13
	DEFB	03
;
SERMSG	DEFM	' - Serial #: '
SERMSGA	DC	32,03
;
MSG41	DEFM	'Track Count (default 77) ? '
	DEFB	03
;
MSG42	DEFM	'Serial Numbering (default no) ? '
	DEFB	03
;
MSG43	DEFM	'Serial Number Location:'
	DEFB	13
	DEFM	'Track, Sector, Byte, Length ? '
	DEFB	03
;
MSG45	DEFM	'Format Destination Disks '
	DEFM	'(default yes) ? '
	DEFB	03
;
MSG46	DEFM	'Transfer Data (default yes) ? '
	DEFB	03
;
MSG47	DEFM	'Media Tolerance Factor 0-3 '
	DEFM	'(default 1) ? '
	DEFB	03
;
MSG48	DEFB	13
	DEFM	'Cannot run with high memory allocated'
	DEFB	13
	DEFB	03
;
	PAGE
;
;	program entry point
;
ENTRY	LD	(STACK),SP	;save stack for exit
	LD	A,@SETBRK	;setup break processor
	LD	HL,0		;turn it off
	RST	SVC		;fetch old processor
	LD	(OLDBRK),HL	;save old vector
;
RESTART	LD	SP,(STACK)	;reset stack
	LD	HL,PGMEXT	;program exit
	LD	A,@SETBRK	;setup break
	RST	SVC		;set it up
;
;	check for no high memory drivers
;
	LD	HL,(TOPMEM)	;get top free memory
	LD	DE,(PHYMEM)	;get top physical memory
	OR	A		;clear carry
	SBC	HL,DE		;compare
	JR	Z,OK2RUN	;ok, fine!
;
	LD	HL,MSG48	;'high mem drivers'
	CALL	DISPLAY		;display it
	XOR	A		;return zero
	RET			;back to invoker
;
OK2RUN	LD	A,1		;video DCB #
	CALL	LOCDCB		;load IX with video DCB
	LD	DE,11		;offset to cursor loc.
	ADD	IX,DE		;IX+0 => cursor
	LD	(CURPTR),IX	;save cursor pointer
	LD	IY,TABLE	;initialize IY to data
	LD	(IY+14),-1	;set initialization byte
;
;	looper entry point
;
START	LD	SP,0		;reset stack to top
STACK	EQU	$-2
	LD	HL,HELLO	;sign on message
	CALL	DISPLAY		;display it
	LD	IY,TABLE	;reset IY to table
	LD	(IY+14),-1	;set init byte
	LD	HL,MSG33	;'testing memory'
	CALL	DISPLAY		;display it
	CALL	TESTMEM		;test memory
;
;	fetch # copies to make
;
BAD1	LD	HL,MSG1		;prompt
	CALL	DISPLAY		;display it
	LD	B,5		;allow 5 chars of input
	CALL	GETSTR		;get key input
	LD	BC,100		;default number
	JR	Z,BAD1D		;nil input, use default
	CALL	VALUE		;fetch value
	JR	NZ,BAD1		;invalid input
BAD1D	LD	(COPIES),BC	;save # copies to make
;
;	move break processor to restart program
;
	LD	HL,RESTART	;restart vector
	LD	A,@SETBRK	;SVC #
	RST	SVC		;set it up
;
;	fetch verify on/off option
;
BAD2	LD	HL,MSG2		;prompt
	CALL	DISPLAY		;display it
	LD	B,2		;input length
	CALL	GETSTR		;fetch from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD2O		;nil input, use default
	LD	A,(HL)		;fetch char of input
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD2O		;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD2		;invalid, ask again
BAD2O	LD	(IY+0),A	;save flag
;
;	fetch diskette track count
;
BAD11	LD	HL,MSG41	;prompt
	CALL	DISPLAY		;display it
	LD	B,3		;3 char input
	CALL	GETSTR		;fetch user input
	LD	C,77		;default value
	JR	Z,BAD11O	;nil, use default
	CALL	VALUE		;fetch string value
	JR	NZ,BAD11	;invalid, ask again
BAD11O	LD	(IY+5),C	;save track count
;
;	check if GAT to be used to skip tracks
;
BAD98	LD	HL,MSG0		;prompt
	CALL	DISPLAY		;display it
	LD	B,2		;input length
	CALL	GETSTR		;fetch from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD98G	;nil input, use default
	LD	A,(HL)		;fetch input char
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD98G	;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD98	;invalid if not
BAD98G	LD	(IY+18),A	;save GAT use result
	CP	'Y'		;is it yes?
	JR	NZ,BAD3		;continue if not
;
;	fetch gat table skip byte
;
BAD99	LD	HL,MSG00	;prompt text
	CALL	DISPLAY		;display it
	LD	B,6		;6 char input
	CALL	GETSTR		;fetch from keyboard
	LD	C,0C0H		;default value
	JR	Z,BAD999	;nil, use default
	CALL	VALUE		;fetch value
	JR	NZ,BAD99	;invalid input
BAD999	LD	(IY+19),C	;save skip value
;
;	fetch media tolerance factor
;
BAD3	LD	HL,MSG47	;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;get from keyboard
	LD	A,1		;default factor
	JR	Z,BAD3P		;save byte
	LD	A,(HL)		;get input byte
	SUB	'0'		;remove ascii
	JR	C,BAD3		;invalid, ask again
	CP	4		;0-3?
	JR	NC,BAD3		;invalid, ask again
;
BAD3P	PUSH	AF		;save original
	ADD	A,A		;times two
	INC	A		;adjust for DEC
	LD	(IY+23),A	;save outer factor
	POP	AF		;get original
	INC	A		;adjust for DEC
	LD	(IY+24),A	;save inner factor
	LD	(IY+8),A	;save I/O retries
;
;	fetch source drive
;
BAD3Z	LD	HL,MSG3		;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;get from keyboard
	LD	A,0		;default drive
	JR	Z,BAD3D		;go if nil input
	LD	A,(HL)		;else fetch input char
	SUB	'0'		;remove ascii
	JR	C,BAD3Z		;invalid, ask again
	CP	4		;test for 0-3
	JR	NC,BAD3Z	;invalid, try again
BAD3D	LD	(IY+1),A	;save source drive
;
;	fetch destination drive(s)
;
;	setup prompt string
;
BAD4	LD	B,0		;start with drive 0
	LD	IX,MSG4A	;prompt message
;
BAD3E	LD	A,B		;get current drive
	LD	HL,DRIVES	;drive table
	ADD	A,L		;add drive offset
	LD	L,A		;HL => drive entry
	LD	(HL),0		;set as inactive
	LD	A,(IY+1)	;get source drive
	CP	B		;current dest drive?
	JR	Z,BAD3F		;yes, skip this drive
;
	LD	A,B		;fetch current drive
	ADD	A,'0'		;add ascii
	LD	(IX),A		;pass to string prompt
	INC	IX		;bump prompt
	INC	IX		;by 2
	LD	(HL),-1		;set drive as active
;
BAD3F	INC	B		;bump current drive #
	LD	A,B		;fetch it back
	CP	4		;check for 0-3
	JR	C,BAD3E		;go if more to do
;
	LD	HL,MSG4		;prompt string
	CALL	DISPLAY		;display it
	LD	B,20		;20 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD5		;nil, use defaults
;
	PUSH	HL		;save input pointer
	LD	HL,DRIVES	;drive table
	LD	DE,DRIVES+1	;start +1
	LD	BC,3		;length -1
	LD	(HL),0		;set as inactive
	LDIR			;set all as inactive
	POP	HL		;restore input pointer
;
	XOR	A		;set Z flag
	EX	AF,AF'		;save here
;
BAD4L	CALL	POSHL		;position to input
	JR	C,BAD4O		;nil, done!
	SUB	'0'		;remove ascii
	JR	C,BAD4		;invalid, ask again
	CP	4		;in range 0-3?
	JR	NC,BAD4		;nope, ask again
;
	PUSH	HL		;save input pointer
	LD	HL,DRIVES	;drive table
	ADD	A,L		;add offset
	LD	L,A		;HL => drive entry
	LD	A,(HL)		;fetch data
;***************************************
;***********************************************
;***********************************************
;***********************************************
;****************eck if anything
	JR	NZ,BAD5		;yes, something input
	LD	HL,MSG9		;'no destination drives'
	CALL	DISPLAY		;display it
	JR	BAD4		;re-prompt again
;
BAD5	LD	A,(IY+1)	;get source drive
	LD	HL,DRIVES	;drive table
	ADD	A,L		;add source offset
	LD	L,A		;HL => source drive byte
	LD	A,(HL)		;fetch the byte
	INC	A		;FF = true?
	JR	NZ,BAD12	;nope, continue
	LD	HL,MSG8		;'source & dest same' !
	CALL	DISPLAY		;display it
	JR	BAD4		;ask again
;
;	fetch if disks are to be serial numbered
;
BAD12	LD	HL,MSG42	;text prompt
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD12K	;nil, use default (no)
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD12O	;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD12	;neither, invalid!
BAD12K	LD	A,'*'		;off setting
BAD12O	LD	(IY+3),A	;save into data table
	CP	'*'		;off?
	JP	Z,BAD7		;yes, continue
;
;	fetch serial number location
;
BAD13	LD	HL,MSG43	;text prompt
	CALL	DISPLAY		;display it
	LD	B,32		;32 char input
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD13		;nil input, ask again
;
;	check track
;
	CALL	VALUE		;get value
	JR	NZ,BAD13	;invalid numeric input
	LD	(IY+11),C	;save track number
;
;	check sector
;
	CALL	VALUE		;get value
	JR	NZ,BAD13	;invalid, ask again
	LD	(IY+12),C	;save sector
;
;	check byte offset
;
	CALL	VALUE		;fetch value
	JR	NZ,BAD13	;invalid input
	LD	(IY+13),C	;save byte offset
;
;	check serial # length
;
	CALL	VALUE		;get value
	JR	NZ,BAD13	;invalid, try again
	LD	(IY+15),C	;save serial # length
;
;	check if serial number is AUTO or MANUAL
;
BAD6	LD	HL,MSG36	;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;input length
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD6A		;go if nil input
	LD	A,(HL)		;else fetch first char
	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	JR	Z,BAD6A		;yes, go!
	CP	'N'		;no?
	JR	NZ,BAD6		;neither, invalid input
BAD6A	LD	(IY+3),A	;save result
	CP	'N'		;no auto?
	JR	Z,BAD7		;nope, continue
;
;	AUTO mode, get starting serial #
;
BAD6B	LD	HL,MSG37	;prompt text
	CALL	DISPLAY		;display it
	LD	B,(IY+15)	;fetch serial # length
	CALL	GETSTR		;get from keyboard
	JR	Z,BAD6B		;nil, ask again
	LD	A,B		;get length
	CP	(IY+15)		;must be exact length
	JR	NZ,BAD6B	;wrong length, ask again
	LD	DE,SERX		;current # storage area
	LD	C,B		;pass length
	LD	B,0		;BC = length
	LDIR			;save the number
;
;	see if disks are to be formatted also
;
BAD7	LD	HL,MSG45	;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default value
	JR	Z,BAD70		;go if nil input
	LD	A,(HL)		;else fetch input char
BAD70	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,-1		;true
	JR	Z,BAD71		;go if yes
	INC	B		;false
	CP	'N'		;no?
	JR	NZ,BAD7		;neither, invalid input
BAD71	LD	(IY+16),B	;save flag
;
;	see if data to be transferred
;
BAD8	LD	HL,MSG46	;prompt text
	CALL	DISPLAY		;display it
	LD	B,2		;2 char input
	CALL	GETSTR		;get from keyboard
	LD	A,'Y'		;default
	JR	Z,BAD80		;go if nil input
	LD	A,(HL)		;else fetch first char
BAD80	CALL	UCASE		;make it upper case
	CP	'Y'		;yes?
	LD	B,-1		;true
	JR	Z,BAD81		;go if yes
	INC	B		;set false
	CP	'N'		;no?
	JR	NZ,BAD8		;neither, invalid input!
BAD81	LD	(IY+17),B	;save flag
;
;	all parameters specified
;
	LD	HL,0		;set 0 copies completed
	LD	(COUNT),HL	;save into counter word
	LD	(IY+14),0	;set data initialized
	JP	LOOPER		;go copy!
;
PGMEXT	LD	SP,(STACK)	;get stack
	LD	HL,0		;get old break vector
OLDBRK	EQU	$-2
	LD	A,@SETBRK	;set it up
	XOR	A		;return to invoker
	RET			;done!
;
