; diskmanm/asm - kjw/bci - File Maker
;
;	created 08/12/83	- kjw/bci
;	revised 08/12/83	- kjw/bci
;
;	dos equivalences
;
@ERROR	EQU	4409H		;display dos error
@DSP	EQU	0033H		;char to video
@KBLINE	EQU	0040H		;keyboard string
@OPEN	EQU	4424H		;open file
@CLOSE	EQU	4428H		;close file
@READ	EQU	4436H		;read record
@WRITE	EQU	4439H		;write record
@REW	EQU	443FH		;rewind file
@GET	EQU	0013H		;get byte
@PUT	EQU	001BH		;put byte
	ORG	5200H		;dos memory use
;
ENTRY	LD	(STACK),SP	;save stack pointer
	LD	HL,HELLO	;sign on message
	CALL	DISPLA		;display header
;
;	reset data pointers
;
	LD	IX,DATA		;data block
	XOR	A		;set zero
	LD	(IX+0),A	;MSB relative sector
	LD	(IX+1),A	;LSB relative sector
	LD	(IX+2),A	;relative byte
	INC	A		;set one
	LD	(IX+3),A	;current file #
;
;	copy DMANO/CMD to DMAN/CMD
;
	LD	DE,FCBO		;FCB DISKMANO
	LD	HL,IOBUFFO	;I/O buffer
	LD	B,0		;LRL
	CALL	OPEN		;open file
;
	LD	DE,FCB		;FCB DISKMAN
	LD	HL,IOBUFF	;I/O buffer
	LD	B,0		;LRL
	CALL	OPEN		;open file
;
	LD	HL,FCBO		;source FCB DISKMANO
	LD	DE,FCB		;dest FCB DISKMAN
	CALL	MOVE		;move the data
;
;	copy driver portion to file
;
	LD	HL,FNAME	;filename 00
	LD	DE,FCBX		;fileblock
	LD	BC,FNAMEL	;filename length
	LDIR			;move it
;
	LD	DE,FCBX		;file block
	LD	HL,IOBUFFX	;I/O buffer
	LD	B,0		;LRL
	CALL	OPEN		;open file
	LD	HL,FCBX		;buffer to copy
	CALL	COPYN		;copy the data
;
;	setup loop to transfer files 1-15
;
LOOP	LD	A,(IX+3)	;get current system
	CALL	ASCII		;convert to decimal ascii
	LD	(PROMPT1),BC	;to prompt string
	LD	(FNAME1),BC	;to filename
;
;	ask user if current file to be copied
;
BAD	LD	HL,PROMPT	;prompt message
	CALL	DISPLA		;display it
	CALL	GETSTR		;get key input
	AND	5FH		;make upper case
	CP	'Y'		;yep?
	JP	NZ,SKIP		;nope, skip it
;
	LD	HL,FNAME	;filename
	LD	DE,FCBX		;file block
	LD	BC,FNAMEL	;name length
	LDIR			;move to buffer
;
;	open source file for input
;
	LD	DE,FCBX		;file block
	LD	HL,IOBUFFX	;I/O buffer
	LD	B,0		;LRL
	CALL	OPEN		;open file
	CALL	SETLOC		;setup location
;
	LD	HL,FCBX		;file block
	CALL	COPYX		;copy the file
	JR	NEXT		;go next file
;
;	skip this file
;
SKIP	LD	B,-1		;load FFFFFF
	LD	H,B
	LD	L,H		;BHL = FFFFFF
	LD	C,B		;byte = FF
	CALL	PUTLOC		;add to table
;
;	go next file
;
NEXT	LD	IX,DATA		;init data
	INC	(IX+3)		;bump file
	LD	A,(IX+3)	;get result
	CP	16		;1-15?
	JR	C,LOOP		;go for length
	JR	EXIT		;exit program
;
;	dos error exit
;
ERROR	OR	0C0H		;return from error call
	CALL	@ERROR		;dos error display
	JR	ABORT		;'aborted'
;
;	program exit
;
EXIT	LD	DE,FCB		;file block
	CALL	CLOSE		;close file
	LD	HL,IOBUFF	;I/O buffer
	LD	B,0		;LRL
	CALL	OPEN		;open file
	CALL	READ		;read first sector
	CALL	UPDATE		;update table
	LD	DE,FCB		;reset pointer
	CALL	REWIND		;rewind file
	CALL	WRITE		;update sector
;
	LD	HL,DONE		;'completed'
	CALL	DISPLA		;display message
	JR	BACKDOS		;back to dos
;
ABORT	LD	HL,ABTMSG	;'aborted'
	CALL	DISPLA		;display message
;
BACKDOS	LD	SP,$		;reset stack
STACK	EQU	$-2
	XOR	A		;set NO error
	LD	L,A		;extended error
	LD	H,A
	RET			;return to opsystem
;
;	subroutines
;
;	set location of current file into location table
;
SETLOC	LD	B,0		;msb rel sector
	LD	IX,DATA		;init data pointer
	LD	H,(IX+0)	;nsb rel sector
	LD	L,(IX+1)	;lsb rel sector
	LD	C,(IX+2)	;relative byte
;
PUTLOC	EX	DE,HL		;BDE = relative sector
	LD	A,(IX+3)	;current file
	DEC	A		;adjust 0 relative
	ADD	A,A		;*2
	ADD	A,A		;*4
	LD	HL,LOCTBL	;location table
	ADD	A,L		;add lsb
	LD	L,A		;update
	JR	NC,$+3		;go if no overflow
	INC	H		;adjust page crossing
;
;	store relative sector
;
	LD	(HL),B		;MSB sector
	INC	HL		;bump table
	LD	(HL),D		;NSB sector
	INC	HL		;bump table
	LD	(HL),E		;LSB sector
	INC	HL		;bump table
	LD	(HL),C		;to table
	RET			;table updated!
;
;	text area
;
HELLO	DEFB	1CH
	DEFB	1FH
	DEFM	'DMANMAKE - '
	DEFM	'Disk Manager Utility Builder - '
	DEFM	'by Kim Watt'
	DEFB	0DH
	DEFM	'Copyright (C) 1983 - '
	DEFM	'Breeze Computing, Inc.'
	DEFB	0DH
	DEFB	0DH
	DEFB	03H
;
PROMPT	DEFM	'Append File: '
	DEFM	'DMAN'
PROMPT1	DEFM	'xx ?'
	DEFB	03H
;
DONE	DEFM	'Completed!'
	DEFB	0DH
	DEFB	03H
;
ABTMSG	DEFM	'Aborted!'
	DEFB	0DH
	DEFB	03H
;
;	buffer storage
;
KEYBUFF	DEFS	64		;key input buffer
;
FCB	DEFM	'DMAN/CMD'
	DEFB	0DH
	DEFB	03H
	DEFS	50
IOBUFF	DEFS	256
;
FCBO	DEFM	'DMANO/CMD'
	DEFB	0DH
	DEFB	03H
	DEFS	50
IOBUFFO	DEFS	256
;
FCBX	DEFS	64
IOBUFFX	DEFS	256
;
FNAME	DEFM	'DMAN'
FNAME1	DEFM	'00/CMD'
	DEFB	0DH
	DEFB	03H
FNAMEL	EQU	$-FNAME
;
LOCTBL	DEFS	4*16
;
DATA	DEFB	0		;MSB rel sector
	DEFB	0		;NSB rel sector
	DEFB	0		;LSB rel sector
	DEFB	0		;relative byte
;
DISPLA	PUSH	IX		;save it
	PUSH	HL		;save it
;
DISPLA0	LD	A,(HL)		;get character
	CP	03H		;terminator?
	JR	Z,DISPLA1	;yes, go!
	CALL	@DSP		;char to video
	INC	HL		;bump text pointer
	JR	DISPLA0		;continue next char
;
DISPLA1	POP	HL		;restore
	POP	IX		;restore
	RET			;done!
;
GETSTR	LD	HL,KEYBUFF	;keyboard input buffer
	LD	B,3		;max input length
	CALL	@KBLINE		;get key input
	JP	C,ABORT		;go on BREAK
	LD	A,(HL)		;get first char input
	RET			;done, go!
;
OPEN	CALL	@OPEN		;open file
	RET	Z		;go if no error
	JP	ERROR		;else abort!
;
CLOSE	CALL	@CLOSE		;close file
	RET	Z		;go if no error
	JP	ERROR		;else abort
;
READ	CALL	@READ		;read sector
	RET	Z		;go if no error
	JP	ERROR		;else abort
;
WRITE	CALL	@WRITE		;write sector
	RET	Z		;go if no error
	JP	ERROR		;else abort
;
REWIND	CALL	@REW		;rewind file
	RET	Z		;go if no error
	JP	ERROR		;else abort
;
ASCII	LD	C,'0'		;init MSB
ASCI1	SUB	10		;less 10's place
	JR	C,ASCI2		;go if done
	INC	C		;bump ascii
	JR	ASCI1		;continue
ASCI2	ADD	A,'0'+10	;last sub + ascii
	LD	B,A		;pass LSB
	RET			;CB = ascii
;
;	update file location table
;
UPDATE	LD	IX,IOBUFF+1CH	;first entry
	LD	B,15		;max # entries
	LD	DE,16		;offset between entries
	LD	HL,LOCTBL	;location storage table
;
UPDLP	PUSH	DE		;save offset
	PUSH	BC		;save count
	PUSH	IX		;pass IX => DE
	POP	DE		;DE => sector
	LD	BC,4		;entry length
	LDIR			;move 4 bytes
	POP	BC		;restore count
	POP	DE		;restore offset
	ADD	IX,DE		;next entry
	DJNZ	UPDLP		;go for count
	RET			;table updated
;
;	move 256 bytes from HL to DE
;
MOVE	LD	(SFILE),HL	;save source DCB
	LD	(DFILE),DE	;save dest DCT
	LD	B,0		;init byte count
;
MOVELP	CALL	GET		;get a byte
	CALL	PUT		;write to dest
	DJNZ	MOVELP		;go for 'em all
	RET			;done!
;
;	copy file from HL to DE
;
COPYN	PUSH	HL		;save source DCB
	LD	HL,(NCOPY)	;normal copy
	JR	COPY		;go common
;
COPYX	PUSH	HL		;save source DCB
	LD	HL,(XCOPY)	;xor'd copy
;
COPY	LD	(COPYT),HL	;copy type
	POP	HL		;restore DCB
	LD	(SFILE),HL	;save source DCB
;
COPYLP	CALL	GET		;get a byte
	CP	02H		;entry point?
	JR	Z,COPYEND	;yes, finish it up
	CP	01H		;data block
	JR	Z,COPYBL	;yes, go!
;
;	remove remark block
;
	CALL	GET		;get length
	LD	B,A		;pass to B
COPYRLP	CALL	GET		;get a byte
	DJNZ	COPYRLP		;copy this block
	JR	COPYLP		;go next block
;
;	move load block
;
COPYBL	CALL	PUT		;write byte in A
	CALL	GET		;get length
	LD	B,A		;pass to B
	CALL	PUT		;write to file
	CALL	GET
	CALL	PUT
	CALL	GET
	CALL	PUT
	DEC	B
	DEC	B
COPYBLP	CALL	GET		;get a byte
COPYT	DEFB	0,0		;copy modifier
	CALL	PUT		;write to file
	DJNZ	COPYBLP		;copy this block
	JR	COPYLP		;go next block
;
;	entry header found
;
COPYEND	CALL	PUT		;write to file
	LD	B,3		;3 more byte to move
;
COPYEN	CALL	GET		;get a byte
	CALL	PUT		;write to file
	DJNZ	COPYEN		;finish it up
	RET			;file copied!
;
;	copy modifiers
;
NCOPY	NOP			;normal copy
	NOP
XCOPY	XOR	'*'		;coded copy
;
;	fetch byte from source file
;
GET	PUSH	DE		;save
	LD	DE,$		;get source FCB
SFILE	EQU	$-2
	CALL	@GET		;read a byte
	POP	DE		;restore DE
	RET	Z		;go if no error
	JP	ERROR		;else abort
;
;	write byte to destination file
;
PUT	PUSH	DE		;save
	LD	DE,$		;get dest FCB
DFILE	EQU	$-2
	CALL	@PUT		;write a byte
	POP	DE		;restore DE
	JP	NZ,ERROR	;go if disk error
;
;	update file position
;
	LD	IX,DATA		;data block
	INC	(IX+2)		;bump rel byte
	RET	NZ		;not at end
	INC	(IX+1)		;bump lsb rel sector
	RET	NZ		;not past 10
	INC	(IX+0)		;bump msb rel sector
	RET			;done!
;
	END	ENTRY
