; diskmand/asm - kjw/bci - misc subroutines
;
;	created 08/12/83	- kjw/bci
;	revised 08/15/83	- kjw/bci
;
	PAGE
;
;	$MULT	- triple precision multiply
;
;	ENTRY	BHL =	miltiplicand
;		C   =	multiplier
;
;	EXIT	ABHL =	result
;
MULT	PUSH	IX		;save
	PUSH	DE		;save
;
	PUSH	BC		;save
	LD	A,C		;get multiplier
	LD	C,B		;pass MSB
	EX	DE,HL		;CDE = multiplicand
	LD	HL,0		;init MSB's
	PUSH	HL		;pass to IX
	POP	IX		;HLIX = 00000000
	LD	B,8		;multiplier precision
;
MULT1	ADD	IX,IX		;shift LSB's left
	ADC	HL,HL		;shift MSB's left
	RLCA			;catch overflow
	JR	NC,MULT2	;go if none
	PUSH	BC		;save count/MSB
	ADD	IX,DE		;result + multiplicand
	LD	B,0		;init MSB
	ADC	HL,BC		;catch overflow
	POP	BC		;restore
;
MULT2	DJNZ	MULT1		;for for precision
	POP	BC		;restore C register
	LD	A,H		;get MSB
	LD	B,L		;get NSB
	PUSH	IX		;pass LSB's to HL
	POP	HL		;ABHL = result
	POP	DE		;unstack
	POP	IX		;unstack
	RET			;done, C unchanged
;
	PAGE
;
;	$DIVID	- triple precision divide
;
;	ENTRY	BHL =	dividend
;		C   =	divisor
;
;	EXIT	BHL =	result
;		A   = remainder
;
DIVID	LD	A,C		;get divisor
	OR	A		;/0?
	JR	NZ,DIVD0	;go if not
;
;	attempt to divide by 0 - assume divide by 256
;
	LD	A,L		;shift left one byte
	LD	L,H
	LD	H,B
	LD	B,C
	RET			;BHL+A = BHL/256
;
DIVD0	PUSH	DE		;save it
	LD	D,C		;D = divisor
	LD	E,24		;precision
	XOR	A		;init LSB bits
;
DIVD1	ADD	HL,HL		;shift dividend left
	RL	B		;shift dividend
	RLA			;shift low 8 bits
	JR	C,DIVD2		;go if overflow
	CP	D		;at divisor?
	JR	C,DIVD3		;go if not
;
DIVD2	SUB	D		;less divisor
	INC	L		;quotient +1
;
DIVD3	DEC	E		;less precision
	JR	NZ,DIVD1	;go for 24 bits
	POP	DE		;unstack
	RET			;BHL+A = result
;
	PAGE
;
;	$ADD24	- triple precision addition
;
;	ENTRY	BHL =	factor 1
;		CDE =	factor 2
;
;	EXIT	BHL =	sum (BHL = BHL + CDE)
;
ADD24	LD	A,L		;get LSB
	ADD	A,E		;add LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	ADC	A,D		;add NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	ADC	A,C		;add MSB
	LD	B,A		;update
	RET			;BHL = sum
;
	PAGE
;
;	$SUB24	- triple precision subtract
;
;	ENTRY	BHL =	factor 1
;		CDE =	factor 2
;
;	EXIT	BHL =	difference (BHL = BHL - CDE)
;
SUB24	LD	A,L		;get LSB
	SUB	E		;less LSB
	LD	L,A		;update
	LD	A,H		;get NSB
	SBC	A,D		;less NSB
	LD	H,A		;update
	LD	A,B		;get MSB
	SBC	A,C		;less MSB
	LD	B,A		;update
	RET			;BHL = difference
;
	PAGE
;
;	$INC24	- triple precision increment
;
;	ENTRY	BHL =	value
;
;	EXIT	BHL =	BHL +1
;
INC24	INC	L		;bump LSB
	RET	NZ		;not FF => 00
	INC	H		;bump NSB
	RET	NZ		;not FF => 00
	INC	B		;bump MSB
	RET			;BHL = BHL + 1
;
	PAGE
;
;	$DEC24	- triple precision decrement
;
;	ENTRY	BHL =	value
;
;	EXIT	BHL =	BHL -1
;
DEC24	LD	A,-1		;init for test
	DEC	L		;dec LSB
	CP	L		;00 => FF?
	RET	NZ		;go if not
	DEC	H		;dec NSB
	CP	H		;00 => FF?
	RET	NZ		;go if not
	DEC	B		;dec MSB
	RET			;BHL = BHL - 1
;
	PAGE
;
;	$CMP24	- triple precision compare
;
;	ENTRY	BHL =	source value
;		CDE =	test value
;
;	EXIT	Z     = BHL = CDE
;		NZ/C  = BHL < CDE
;		NZ/NC = BHL > CDE
;
CMP24	LD	A,B		;get MSB
	CP	C		;compare
	RET	NZ		;go if not equal
	LD	A,H		;get NSB
	CP	D		;compare
	RET	NZ		;go if not equal
	LD	A,L		;get LSB
	CP	E		;compare
	RET			;return with status
;
	PAGE
;
;	$BINASC	- binary to ascii convert
;
;	ENTRY	IX =>	string to contain ascii chars
;		BHL =	binary value to convert
;		D  =	desired length of ascii chars
;		E  =	base to convert binary to
;
;	EXIT	IX =>	ascii string of length D
;
BINASC	CALL	SAVREG		;save input registers
	LD	A,D		;get length of string
	LD	C,E		;pass numeric base
	PUSH	IX		;pass string start to DE
	POP	DE		;DE => string to hold dat
	PUSH	AF		;save count
	EX	DE,HL		;HL => string
;
DECHEX1	DEC	A		;less count
	JR	Z,DECHEX2	;go if at end
	LD	(HL),' '	;load nil char
	INC	HL		;bump string
	JR	DECHEX1		;go for length
;
DECHEX2	POP	AF		;restore count
	EX	DE,HL		;DE => last character
;
DECHEX3	PUSH	AF		;save char count
	CALL	DIVID		;divide BHL/C
	ADD	A,'0'		;make remainder ascii
	CP	'9'+1		;0-9?
	JR	C,$+4		;go if yes
	ADD	A,7		;adjust to A-F
	LD	(DE),A		;char to string
	DEC	DE		;move to next position
;
;	check for value completed
;
	LD	A,B		;get msb
	OR	H		;or nsb
	OR	L		;or lsb
	JR	Z,DECHEX4	;go if result = 000000H
;
	POP	AF		;restore char count
	DEC	A		;less counter
	JR	NZ,DECHEX3	;go if more chars!
	PUSH	AF		;setup for exit
;
DECHEX4	POP	AF		;restore stack
	XOR	A		;set NO error
	RET			;done!
;
	PAGE
;
;	$VALUE	- fetch numeric value from string
;
;	ENTRY	HL =>	string to parse
;
;	EXIT	NZ =	A = error code (invalid char)
;		Z  =	OK, CDE = value
;		HL =>	terminating character
;
;	NOTE:	HEX/OCTAL/DECIMAL/BINARY may all be
;			interpreted by appending
;			H/O or Q/D/B to the number
;		default base is DECIMAL
;		case is independent
;
VALUE	PUSH	BC		;save B from use
	PUSH	HL		;save input pointer
	CALL	POSEND		;find last valid char
;
	LD	C,16		;base
	CP	'H'		;hex?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,8		;base
	CP	'O'		;octal?
	JR	Z,GOVAL		;yes, go!
	CP	'Q'		;octal?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,2		;base
	CP	'B'		;binary?
	JR	Z,GOVAL		;yes, go!
;
	LD	C,10		;base
	CP	'D'		;decimal?
	JR	Z,GOVAL		;yes, go!
	XOR	A		;default decimal
;
GOVAL	LD	(ADDTERM),A	;pass term character
	POP	DE		;restore string start
	LD	B,0		;init MSB
	LD	H,B		;init NSB
	LD	L,B		;init LSB
;
;	loop to evaluate numeric input
;
VALLP	LD	A,(DE)		;get string char
	CALL	UCASE		;make upper case
	CALL	CKTERM		;terminator?
	JR	Z,VALEND	;yes, go!
	INC	DE		;bump string pointer
	CP	'$'		;base specifier?
ADDTERM	EQU	$-1
	JR	Z,VALEND	;yes, go!
	CP	' '		;space?
	JR	Z,VALEND	;yes, go!
	CP	','		;comma?
	JR	Z,VALEND	;yes, go!
;
;	convert character
;
	CALL	CONVCHR		;convert to binary
	JR	NZ,VALEND	;error, go!
;
	JR	VALLP		;go next character
;
VALEND	EX	DE,HL		;DE = LSB's, HL=>string
	EX	AF,AF'		;save error code
	LD	A,B		;get MSB value
	POP	BC		;restore BC
	LD	C,A		;pass MSB
	EX	AF,AF'		;get error back
	RET	NZ		;go if error!
	XOR	A		;else set NO error
	RET			;done, CDE = value
;
;	digit to binary conversion
;
CONVCHR	PUSH	AF		;save new digit
	CALL	MULT		;BHL = BHL * C
	POP	AF		;restore new digit
;
	SUB	'0'		;remove ascii
	JR	C,CHBAD		;go if <'0'
	CP	10		;0-9?
	JR	C,CHOK		;yes, go!
	CP	17		;between 9&A?
	JR	C,CHBAD		;yes, invalid!
	SUB	7		;A-F?
CHOK	CP	C		;test to base
	JR	NC,CHBAD	;>= base
;
;	add new digit to subtotal
;
	PUSH	BC		;save
	PUSH	DE		;save
	LD	E,A		;pass digit
	LD	D,0		;init NSB
	LD	C,D		;init MSB
	CALL	ADD24		;BHL = BHL + CDE
	POP	DE		;unstack
	POP	BC
	XOR	A		;set Z flag
	RET			;done!
;
CHBAD	OR	-1		;illegal data
	RET			;return
;
;	position to last char for base specifier
;
	INC	HL		;bump pointer
POSEND	LD	A,(HL)		;get a char
	CALL	CKTERM		;terminator?
	JR	Z,POSHAV	;have it, go!
	CP	' '		;space?
	JR	Z,POSHAV	;yes, go!
	CP	','		;comma?
	JR	NZ,POSEND-1	;go next char if none
POSHAV	DEC	HL		;last valid char
	LD	A,(HL)		;get the char
	JR	UCASE		;make upper case for test
;
	PAGE
;
;	$GOTABL	- lookup value in table
;
;	ENTRY	HL =>	lookup table (terminated 00H)
;		A  =	character to locate
;
;	EXIT	if entry found, jump made to vector
;		if entry not found, return made to caller
;
GOTABL	INC	(HL)		;check for terminator
	DEC	(HL)		;(HL) = 00?
	RET	Z		;yes, entry not found!
;
	CP	(HL)		;matching character?
	INC	HL		;bump to vector
	JR	Z,GOTABL0	;yes, fetch entry
	INC	HL		;bump to next entry
	INC	HL		;3 bytes each
	JR	GOTABL		;check next entry
;
GOTABL0	LD	A,(HL)		;get LSB vector
	INC	HL		;bump table
	LD	H,(HL)		;get MSB vector
	LD	L,A		;HL = vector
	EX	(SP),HL		;remove caller address
	RET			;go vector!
;
	PAGE
;
;	$UCASE	- convert character in A to upper case
;
;	ENTRY	A  =	character to convert
;
;	EXIT	A  =	character in upper case
;
UCASE	CP	'a'		;in LC range?
	RET	C		;go if not
	CP	'z'+1		;in LC range?
	RET	NC		;go if not
	AND	5FH		;else make upper case
	RET			;done
;
	PAGE
;
;	$SAVREG	- preserve primary registers
;
;	ENTRY	none
;
;	EXIT	AF destroyed
;		BC,DE,HL,IX,IY preserved on stack
;		unstacker vector left on stack
;
SAVREG	POP	AF		;get caller address
	PUSH	IY		;save registers
	PUSH	IX
	PUSH	HL
	PUSH	DE
	PUSH	BC
;
;	setup stack for unstacker return
;
	PUSH	HL		;save
	LD	HL,GETREG	;unstacker
	EX	(SP),HL		;get HL, leave on stack
	PUSH	AF		;restore caller address
	RET			;done!
;
GETREG	POP	BC		;unstack registers
	POP	DE
	POP	HL
	POP	IX
	POP	IY
	RET			;return with AF status
;
	PAGE
;
;	$POSHL	- position HL to significant char
;
;	ENTRY	HL =>	text string
;
;	EXIT	Z  =	terminator found, HL => term char
;		NZ =	valid char found
;			HL => first valid character
;			A  =  first valid character
;
	INC	HL		;bump pointer
POSHL	LD	A,(HL)		;get a character
	CP	' '		;separator?
	JR	Z,POSHL-1	;ignore if yes
	CP	','		;separator?
	JR	Z,POSHL-1	;ignore if yes
;
	PAGE
;
;	$CKTERM - check for terminator character
;
;	ENTRY	A  =	character to test
;
;	EXIT	Z  =	terminator found
;		NZ =	no terminating char
;
CKTERM	CP	_ETX		;end of text?
	RET	Z		;yes, return
	CP	_CR		;carriage return?
	RET			;return, Z=yes
;
	PAGE
;
;	$DOERR	- error handler
;
;	ENTRY	A  <>	0 = dos error code
;		A  =	0 = HL = error message
;		DE =	first message to display
;
;	EXIT	text displayed to video
;
DOERR	PUSH	HL		;save message text
	PUSH	AF		;save error code
	EX	DE,HL		;HL => first message
	CALL	DOLINE		;display error
	POP	AF		;restore error code
	POP	HL		;restore error text
	OR	A		;dos error?
	JP	Z,DOLINE	;nope, display text
	JP	ERROR		;else display dos error
;
	PAGE
;
;	$COMPAR	- string comparator
;
;	ENTRY	DE =>	first string
;		HL =>	second string
;		B  =	length to compare
;
;	EXIT	Z  =	strings identical, B=0
;		NZ/NCy	= HL < DE
;		NZ/Cy	= HL > DE
;
COMPAR	LD	A,(DE)		;get first string
	CP	(HL)		;test
	RET	NZ		;go if no match
	INC	DE		;bump first
	INC	HL		;bump second
	DJNZ	COMPAR		;go for length
	RET			;identical, return Z
;
	PAGE
;
;	$SHOWF	- display file specifics
;
SHOWF	LD	A,(@FLAG1)	;get system flag
	RLCA			;file open?
	JP	NC,SHOWC	;nope, show file closed
;
;	load string specifics
;
	LD	HL,FILEMS0	;'filename'
	LD	BC,32<8+' '	;clear field
	CALL	CLEAR		;clear it
;
	EX	DE,HL		;DE => text
	LD	HL,(@FNAME)	;get start filename
;
SETNAM	LD	A,(HL)		;get data string
	CP	_ETX		;terminator?
	JR	Z,FINNAM	;yes, go!
	CP	_CR		;terminator?
	JR	Z,FINNAM	;yes, go!
	LD	(DE),A		;load to string
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	SETNAM		;go for 32 chars
;
FINNAM	LD	HL,(@RECPTR)	;record pointer
	LD	BC,88		;offset to date
	ADD	HL,BC		;HL => creation date
	LD	DE,FILEMS1	;text to load
	LD	C,8		;length
	LDIR			;move it
;
	LD	IY,@DATA	;data storage
	LD	H,(IY+49)	;max diskettes
	LD	L,(IY+50)
	LD	IX,FILEMS3	;name storage
	LD	DE,5<8+10	;length+base
	CALL	BINASC		;load ascii
;
	LD	B,0		;zero msb
	LD	H,(IY+52)	;disks used
	LD	L,(IY+53)
	LD	IX,FILEMS2	;name storage
	LD	DE,5<8+10	;length + base
	CALL	BINASC		;load ascii
;
	LD	B,(IY+73)	;get # files
	LD	H,(IY+74)
	LD	L,(IY+75)
	LD	IX,FILEMS4	;text to load
	LD	DE,8<8+10	;length + base
	CALL	BINASC		;load ascii
;
	LD	B,(IY+60)	;eof sector
	LD	H,(IY+61)
	LD	L,(IY+62)
	CALL	INC24		;+1 for 0 relative
	LD	C,4		;divide / 4
	CALL	DIVID		;#k
	OR	A		;any remainder?
	CALL	NZ,INC24	;yes, bump count
	LD	IX,FILEMS5	;text to load
	LD	DE,8<8+10	;length + base
	CALL	BINASC		;load ascii
;
;	display string and return
;
SHOWT	LD	HL,FILEMSG	;start message
	JP	DOLINE		;display and return
;
SHOWC	LD	HL,FILEMS0	;start text
	LD	BC,32<8+'.'	;length + fill
	CALL	CLEAR		;clear area
	LD	HL,FILEMS1	;start text
	LD	B,2		;length
	CALL	CLEAR		;clear area
	INC	HL		;bump
	INC	HL
	INC	HL
	CALL	CLEAR		;clear area
	INC	HL		;bump
	INC	HL
	INC	HL
	CALL	CLEAR		;clear area
;
	LD	HL,FILEMS2	;start text
	LD	B,5		;length
	CALL	CLEAR		;clear area
	LD	HL,FILEMS3	;start text
	CALL	CLEAR		;clear area
	LD	HL,FILEMS4	;start text
	LD	B,8		;length
	CALL	CLEAR		;clear area
	LD	HL,FILEMS5	;start text
	CALL	CLEAR		;clear area
	JR	SHOWT		;display message
;
;	clear data area
;
CLEAR	PUSH	BC		;save
	PUSH	HL		;save
;
CLEAR0	LD	(HL),C		;load data
	INC	HL		;bump pointer
	DJNZ	CLEAR0		;go for length
;
	POP	HL		;restore
	POP	BC		;restore
	RET			;done
;
