; diskmanc/asm - kjw/bci - DOS Interfacing
;
;	created 08/11/83	- kjw/bci
;	revised 08/16/83	- kjw/bci
;
	PAGE
;
;	$KBCHAR - scan keyboard for character
;
;	ENTRY	none
;
;	EXIT	Z  =	no character available, A=0
;		NZ =	A = input character
;
KBCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@KBD		;scan keyboard
	POP	DE		;restore
	POP	IY		;restore
	OR	A		;set flags on result
	RET			;return with char/flags
	ENDIF
;
	PAGE
;
;	$ENKEY	- scan keyboard, wait for <ENTER> key
;
;	ENTRY	none
;
;	EXIT	<BREAK> pressed = Cy flag
;		<ENTER> pressed = NCy flag
;		Z  =	set
;
ENKEY	LD	A,'$'		;cursor
	CALL	INKEY0		;wait for key press
	RET	Z		;go if ENTER/BREAK
	JR	ENKEY		;else wait
;
	PAGE
;
;	$INKEY	- scan keyboard, wait for key press
;
;	ENTRY	none
;
;	EXIT	A  =	input key
;		Z  =	BREAK/ENTER pressed
;		Cy =	BREAK pressed
;
;	NOTE:	cursor flashes at current position
;		HL returns with current cursor offset
;
INKEY	LD	A,CURCHAR	;cursor character
;
;	special key editor entry, A  = cursor char
;
INKEY0	LD	(CURCHR),A	;save cursor character
	CALL	CURADD		;locate cursor address
;
;	special key editor entry, HL = video address
;
INKEY1	PUSH	BC		;save
	PUSH	DE		;save
	CALL	VIDON		;enable video memory
	LD	E,(HL)		;fetch current character
	CALL	VIDOFF		;disable video memory
	LD	D,'$'		;fetch cursor char
CURCHR	EQU	$-1
;
;	change cursor and initialize delay count
;
INKEY2	CALL	VIDON		;enable video memory
	LD	A,E		;fetch normal character
	CP	(HL)		;match with video?
	LD	A,D		;fetch cursor if on
	JR	Z,$+3		;go if char on video
	LD	A,E		;else reset character
	LD	(HL),A		;update video
	CALL	VIDOFF		;disable video
	LD	BC,FDELAY	;set delay factor
;
;	wait for keyboard key, dec flash count
;
INKEY3	CALL	KBCHAR		;scan keyboard
	JR	NZ,INKEY4	;go if we have a key
;
;	check if time for cursor change
;
	DEC	BC		;less flash count
	LD	A,B		;any more?
	OR	C		;BC = 0000?
	JR	NZ,INKEY3	;wait if not time
	JR	INKEY2		;else change cursor
;
;	have a key, restore original char to video
;
INKEY4	PUSH	AF		;save input char
	CALL	VIDON		;enable video memory
	LD	(HL),E		;restore video char
	CALL	VIDOFF		;disable video memory
	POP	AF		;restore input char
	POP	DE		;restore stack
	POP	BC
;
;	set flags on resulting key
;
	CP	_BREAK		;break key?
	SCF			;carry = yes
	RET	Z		;done if yes
	CP	_CR		;enter key?
	SCF			;set carry flag
	CCF			;reset carry flag
	RET			;Z = enter key, else not
;
	PAGE
;
;	$KBLINE	- fetch string from keyboard
;
;	ENTRY	B  =	max length to input
;
;	EXIT	HL =>	string input area
;		A  =	first input character
;		Z  =	no input, ENTER/BREAK only
;
KBLINE	LD	HL,KBBUFF	;keyboard buffer
	PUSH	HL		;save input string
	LD	C,B		;pass input length
;
;	clear out input area and add CR to string
;
	CALL	FILCLR		;load blanks
	LD	(HL),_CR	;terminate input
	LD	B,C		;reset length
	CALL	CURADD		;fetch cursor address
	POP	DE		;restore string start
;
;	$KBLINE1 - alternate entry to KBLINE
;
;	ENTRY	DE =>	string text buffer
;		B  =	max input length
;		HL =>	video area containing data
;
KBLINE1	LD	A,CUREDIT	;cursor to edit
	LD	(CURCHR),A	;set cursor character
	LD	A,(KEYFLAG)	;get keyboard flag
	RES	1,A		;set NO keys
	LD	(KEYFLAG),A	;update
	LD	C,0		;init cursor location
;
KBLINE2	CALL	INKEY1		;scan keyboard
	JP	Z,KBLINER	;exit on BREAK/ENTER
;
;	setup registers and check for special keys
;
KBLINE3	PUSH	IY		;save
	PUSH	HL		;pass HL => IY
	POP	IY		;IY => video
	LD	HL,KBLINE4	;return vector
	PUSH	HL		;to stack
	LD	HL,KBLINET	;special key lookup table
	CALL	GOTABL		;any matching keys?
;
;	not a special key, check if valid keystroke
;
	CP	20H		;control key?
	RET	C		;yes, ignore it
	CP	80H		;non ascii/numeric?
	RET	NC		;yes, ignore it
	LD	HL,KEYFLAG	;keyboard flag
	SET	1,(HL)		;set KEY in buffer
	JR	KEYRCM		;add key to buffer
;
;	return vector for key use
;
KBLINE4	PUSH	IY		;pass video back to HL
	POP	HL		;HL => video
	POP	IY		;restore IY
	JR	KBLINE2		;continue next key
;
;	right arrow with erase of current key
;
KEYRDS	LD	A,' '		;load blank
	JR	KEYRCM		;continue
;
;	right arrow with maintain of current key
;
KEYRHT	LD	A,(DE)		;get current char
;
KEYRCM	CALL	KEYVID		;key to video/buffer
;
;	check if cursor can be moved right
;
MOVRHT	LD	A,B		;get maximum length
	DEC	A		;adjust 0 relative
	CP	C		;at max before end?
	RET	Z		;yes, can't add it
;
	INC	IY		;bump video
	INC	DE		;bump buffer
	INC	C		;bump current length
	OR	A		;clear carry flag
	RET			;done!
;
;	move cursor left with erase
;
KEYLDS	LD	A,' '		;load blank
	JR	KEYLCM		;continue
;
;	move cursor left with cursor preserve
;
KEYLEF	LD	A,(DE)		;get current character
;
KEYLCM	CALL	KEYVID		;key to video
;
MOVLFT	INC	C		;any length
	DEC	C		;C = 0?
	SCF			;carry = yes
	RET	Z		;yes, done!
;
	DEC	C		;length -1
	DEC	IY		;video -1
	DEC	DE		;buffer -1
	OR	A		;clear carry
	RET			;return done
;
;	key delete mode
;
KEYDEL	LD	HL,BUFLFT	;buffer left sub
	JR	KEYINDE		;go common
;
;	key insert mode
;
KEYINS	LD	HL,BUFRHT	;buffer right sub
;
KEYINDE	LD	A,B		;get max length
	DEC	A		;adjust 0 relative
	SUB	C		;less current length
	RET	Z		;at end, can't perform!
;
	LD	(KEYCAL1),HL	;pass subroutine
	LD	(KEYCAL2),HL	;need it twice
;
	PUSH	BC		;save count
	PUSH	DE		;save buffer
	LD	B,A		;save character
	CALL	VIDON		;enable video memory
	PUSH	IY		;pass video to HL
	POP	HL		;HL => video
	CALL	$-$		;shift data
KEYCAL1	EQU	$-2
	EX	DE,HL		;HL => buffer
	CALL	$-$		;shift data
KEYCAL2	EQU	$-2
	CALL	VIDOFF		;disable video
	POP	DE		;restore registers
	POP	BC		;restore
	RET			;done
;
;	move buffer right for insert
;
BUFRHT	PUSH	DE		;save needed
	PUSH	BC		;save length
;
	LD	C,B		;C = length
	LD	B,0		;BC = length
	ADD	HL,BC		;HL => end
	LD	D,H		;pass to DE
	LD	E,L		;DE => end
	DEC	HL		;HL => end -1
	LDDR			;shift data
	LD	A,' '		;load blank
	LD	(DE),A		;to current position
;
	POP	BC		;restore stack
	POP	DE		;restore
	RET			;shifted!
;
;	move buffer left for delete
;
BUFLFT	PUSH	BC		;save needed
	PUSH	DE		;save
;
	LD	C,B		;pass length
	LD	B,0		;BC = length
	LD	D,H		;pass start to DE
	LD	E,L		;DE/HL => start
	INC	HL		;HL => start +1
	LDIR			;move block
	LD	A,' '		;load blank
	LD	(DE),A		;blank to last char
;
	POP	DE		;restore stack
	POP	BC		;restore
	RET			;moved!
;
;	clear to end of frame
;
KEYESC	LD	A,B		;get max length
	SUB	C		;at max?
	RET	Z		;yes, nothing to clear!
;
	PUSH	BC		;save count
	PUSH	DE		;save buffer
	LD	B,A		;pass length
	LD	C,A		;need twice
	CALL	VIDON		;enable video
	PUSH	IY		;pass video to HL
	POP	HL		;HL => video
	CALL	FILCLR		;clear block
	EX	DE,HL		;HL => buffer
	LD	B,C		;reset length
	CALL	FILCLR		;clear block
	CALL	VIDOFF		;disable video
	POP	DE		;restore stack
	POP	BC		;restore
	RET			;done, cleared!
;
;	return vector for keyboard input
;
KBLINER	LD	HL,KBBUFF	;key buffer
	LD	A,0		;get system flag
KEYFLAG	EQU	$-1
	BIT	1,A		;any input?
	LD	A,(HL)		;return with first char
	RET			;return to caller
;
;	fill buffer block for length B @ (HL)
;
FILCLR	LD	(HL),' '	;load blank
	INC	HL		;bump buffer pointer
	DJNZ	FILCLR		;go for length B
	RET			;done!
;
;	load char in A into video and buffer
;
KEYVID	PUSH	BC		;save
	LD	B,A		;pass character
	CALL	VIDON		;enable video memory
	LD	A,B		;get character
	LD	(DE),A		;to buffer
	LD	(IY),A		;to video
	CALL	VIDOFF		;disable video
	POP	BC		;restore BC
	RET			;done!
;
;	keyboard response lookup table for $KBLINE
;
KBLINET	DEFB	_UP		;up arrow
	DEFW	KEYINS		;insert mode
	DEFB	_DOWN		;down arrow
	DEFW	KEYDEL		;delete mode
	DEFB	_LEFT		;left arrow
	DEFW	KEYLEF		;cursor left
	DEFB	_RIGHT		;right arrow
	DEFW	KEYRHT		;cursor right
	DEFB	_SLEFT		;shift left arrow
	DEFW	KEYLDS		;cursor left / erase
	DEFB	_SRIGHT		;shift right arrow
	DEFW	KEYRDS		;cursor right / erase
	DEFB	_CLEAR		;clear key
	DEFW	KEYESC		;erase to end of line
	DEFB	_ETBL		;end of table
;
	PAGE
;
;	enable/disable video memory
;
VIDON	EQU	$
;
	IF	LDOS1.OR.LDOS3
	RET			;no need
	ENDIF
;
VIDOFF	EQU	$
;
	IF	LDOS1.OR.LDOS3
	RET			;no need
	ENDIF
;
	PAGE
;
;	$DOCHAR	- character to display
;
;	ENTRY	A  =	character to display
;
;	EXIT	character displayed to video
;
DOCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@DSP		;display character
	POP	DE		;restore
	POP	IY		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	$DOLINE	- display string to video
;
;	ENTRY	HL =>	display text
;
;	EXIT	HL =>	last char +1
;
;	NOTE:	special characters allowed
;		03H _ETX = end text and return
;		02H _STX = cursor ROW/COL follows
;
DOLINE	LD	A,(HL)		;fetch character
	INC	HL		;bump string
	CP	_ETX		;end of text?
	RET	Z		;yes, end!
	CP	_STX		;header marker?
	JR	Z,DOLINE1	;go if yes
	CALL	DOCHAR		;display character
	JR	DOLINE		;continue next char
;
;	fetch row/col and set cursor
;
DOLINE1	PUSH	BC		;save
	LD	B,(HL)		;get ROW
	INC	HL		;bump text pointer
	LD	C,(HL)		;get COLUMN
	INC	HL		;bump text pointer
	CALL	PUTCUR		;set cursor
	POP	BC		;restore BC
	JR	DOLINE		;continue
;
	PAGE
;
;	$PRCHAR	- send character to printer
;
;	ENTRY	A  =	character to print
;
;	EXIT	character delivered to printer
;
PRCHAR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	IY		;must save
	PUSH	DE		;must save
	CALL	@PRT		;print character
	POP	DE		;restore
	POP	IY		;restore
	RET			;done
	ENDIF
;
	PAGE
;
;	$PRLINE	- display string to printer
;
;	ENTRY	HL =>	text to print
;
;	EXIT	HL =>	last char printed +1
;			text terminates with 03H _ETX
;
PRLINE	LD	A,(HL)		;get text char
	INC	HL		;bump pointer
	CP	_ETX		;end of text?
	RET	Z		;yes, done!
	CALL	PRCHAR		;else send character
	JR	PRLINE		;go next character
;
	PAGE
;
;	$PUTCUR	- load cursor with row/column
;
;	ENTRY	B  =	video row desired
;		C  =	video column desired
;
;	EXIT	cursor updated to new location
;
PUTCUR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	HL		;save from math
	LD	L,B		;fetch row
	LD	H,0		;HL = row
	ADD	HL,HL		;*2
	ADD	HL,HL		;*4
	ADD	HL,HL		;*8
	ADD	HL,HL		;*16
	ADD	HL,HL		;*32
	ADD	HL,HL		;*64
	LD	A,L		;fetch LSB
	ADD	A,C		;add column
	LD	L,A		;HL = rows*64 + column
	LD	A,H		;fetch MSB
	ADD	A,@VIDEO<-8	;add msb video offset
	LD	H,A		;HL = new cursor address
	LD	(@CURSOR),HL	;update video cursor
	POP	HL		;restore HL
	RET			;done!
	ENDIF
;
	PAGE
;
;	$CURADD	- fetch cursor address offset
;
;	ENTRY	none
;
;	EXIT	HL =>	current offset of cursor in video
;
CURADD	EQU	$
;
	IF	LDOS1.OR.LDOS3
	LD	HL,(@CURSOR)	;fetch cursor
	RET			;done
	ENDIF
;
	PAGE
;
;	$MSIZE	- fetch high free memory address
;
;	ENTRY	none
;
;	EXIT	HL =	highest free address available
;
MSIZE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	LD	HL,(@HIGH$)	;fetch high memory
	RET			;done
	ENDIF
;
	PAGE
;
;	$DATE	- fetch system date
;
;	ENTRY	HL =>	8 byte buffer to hold string
;
;	EXIT	buffer loaded with format MM/DD/YY
;
DATE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@DATE		;fetch system date
	ENDIF
;
	PAGE
;
;	$ERROR	- display system error code
;
;	ENTRY	A  =	dos error code
;
;	EXIT	error code displayed to video
;
ERROR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	OR	11000000B	;short msg + return
	JP	@ERROR		;display and return
	ENDIF
;
	PAGE
;
;	misc. dos file handling routines
;
;	$FSPEC	- extract filespec from string
;
;	ENTRY	HL =>	string to evaluate
;		DE =>	FCB to hold filename
;
;	EXIT	NZ =	invalid filespec characters
;		Z  =	filespec loaded
;		HL =>	terminating character
;		DE =>	filespec
;
FSPEC	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@FSPEC		;evaluate filespec
	ENDIF
;
	PAGE
;
;	$INIT	- open/create file
;
;	ENTRY	DE =>	filespec to open
;		HL =>	256 byte I/O buffer
;		B  =	'R' or 'W' for read/write access
;
;	EXIT	Z  =	OK, A=0, file is open
;		NZ =	A = dos error code
;
INIT	EQU	$
;
	IF	LDOS1.OR.LDOS3
	LD	B,0		;set LRL = 256
	JP	@INIT		;open/create file
	ENDIF
;
	PAGE
;
;	$OPEN	- open existing file
;
;	ENTRY	DE =>	filespec to open
;		HL =>	256 byte I/O buffer
;		B  =	'R' or 'W' for read/write access
;
OPEN	EQU	$
;
	IF	LDOS1.OR.LDOS3
	LD	B,0		;set LRL = 256
	JP	@OPEN		;open existing file
	ENDIF
;
	PAGE
;
;	$REWIND	- rewind file to beginning
;
;	ENTRY	DE =>	FCB
;
;	EXIT	Z  =	OK, file rewound
;		NZ =	A = error code
REWIND	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@REW		;rewind file
	ENDIF
;
	PAGE
;
;	$POSN	- position file to logical record #
;
;	ENTRY	DE =>	open FCB
;		BC =>	3 byte requested record #
;
;	EXIT	Z  =	OK, file positioned
;		NZ =	A = dos error code
;
POSN	EQU	$
;
	IF	LDOS1.OR.LDOS3
	LD	H,B		;pass pointer to HL
	LD	L,C		;HL => 3 byte record
	INC	HL		;ignore MSB this dos
	LD	B,(HL)		;get NSB
	INC	HL		;bump pointer
	LD	C,(HL)		;get LSB
	JP	@POSN		;position file
	ENDIF
;
	PAGE
;
;	$READ	- read logical record #
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, I/O buffer loaded with record
;		NZ =	A = dos error code
;
READ	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@READ		;read record
	ENDIF
;
	PAGE
;
;	$WRITE	- write logical record #
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, I/O buffer written to file
;		NZ =	A = dos error code
;
WRITE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@WRITE		;write record
	ENDIF
;
	PAGE
;
;	$CLOSE	- close file control block
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, file closed, DE => filespec
;		NZ =	A = dos error code
;
CLOSE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@CLOSE		;close file for I/O
	ENDIF
;
	PAGE
;
;	$KILL	- delete file
;
;	ENTRY	DE =>	open FCB
;
;	EXIT	Z  =	OK, file deleted, DE => filespec
;		NZ =	A = dos error code
;
KILL	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@KILL		;delete file
	ENDIF
;
	PAGE
;
;	misc. direct disk I/O subroutines
;
;	$DSIZE	- fetch diskette type parameters
;
;	ENTRY	C  =	drive number
;
;	EXIT	B  =	misc. flags
;			7 = 1=rigid drive, 0=floppy
;			6 = 1=double density, 0=single
;			5 = 1=double sided, 0=single
;			4 = 1=8" drive, 0=5"
;			3-0 = unused
;		C  =	drive # (unchanged)
;		D  =	directory cylinder
;		E  =	# sectors in directory
;		HL =	cylinder count
;
DSIZE	EQU	$
;
	IF	LDOS1.OR.LDOS3
	PUSH	IY		;must save
	CALL	@GETDCT		;get drive data
	LD	D,(IY+9)	;fetch directory cylinder
;
	LD	A,(IY+7)	;get drive data
	AND	1FH		;highest # sector
	INC	A		;sector count
	BIT	3,(IY+3)	;rigid?
	JR	NZ,SKP0		;yes, ignore
	BIT	4,(IY+5)	;double sided?
	JR	Z,SKP0		;nope, ignore
	ADD	A,A		;double sector count
SKP0	CP	35		;34 max sectors in direct
	JR	C,$+4		;go if less
	LD	A,34		;else set maximum
	LD	E,A		;E = # sectors directory
;
	LD	L,(IY+6)	;get highest cylinder
	LD	H,0		;HL = highest cylinder
	INC	HL		;HL = cylinder count
	BIT	5,(IY+4)	;double count?
	JR	Z,$+3		;go if not
	ADD	HL,HL		;else double cylinder cnt
;
	LD	B,0		;init flags
	BIT	3,(IY+3)	;rigid drive?
	JR	Z,$+4		;go if not
	SET	7,B		;else flag rigid drive
	BIT	6,(IY+3)	;double density?
	JR	Z,$+4		;go if not
	SET	6,B		;else set double flag
	BIT	7,B		;rigid drive?
	JR	NZ,$+10		;go if yes
	BIT	5,(IY+4)	;2 sides?
	JR	Z,$+4		;go if not
	SET	5,B		;else set double bit
	BIT	5,(IY+3)	;drive size?
	JR	Z,$+4		;go if 5"
	SET	4,B		;else set 8" bit
	POP	IY		;restore IY
	RET			;completed!
	ENDIF
;
	PAGE
;
;	$CKDRV	- check if drive ready for I/O
;
;	ENTRY	C  =	drive # to check
;
;	EXIT	Z  =	OK, drive ready and mounted
;		NZ =	A = dos error code
;
CKDRV	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@CKDRV		;check drive ready
	ENDIF
;
	PAGE
;
;	$RDDIR	- read diskette directory
;
;	ENTRY	C  =	drive # to read
;		E  =	sector in directory to read
;		HL =>	256 byte I/O buffer
;
;	EXIT	Z  =	OK, I/O buffer loaded
;		NZ =	A = dos error code
;		D  =	actual directory cylinder
;
RDDIR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@RDSSEC		;read system sector
	ENDIF
;
	PAGE
;
;	$WRDIR	- write directory record
;
;	ENTRY	C  =	drive # to write to
;		D  =	directory cylinder
;		E  =	sector to write
;		HL =>	256 byte I/O buffer
;
;	EXIT	Z  =	OK, sector written
;		NZ =	A = dos error code
;
WRDIR	EQU	$
;
	IF	LDOS1.OR.LDOS3
	JP	@WRPROT		;write protected sector
	ENDIF
;
