; dmanequ/asm - kjw/bci - System Equates
;
;	created 08/12/83	- kjw/bci
;	revised 09/22/83	- kjw/bci
;
ASMDATE	MACRO
	DEFM	'10/13/83'
	ENDM
;
VERSION	MACRO
	DEFM	'0.04/'		;program version number
	IF	LDOS1
	DEFM	'L1'
	ENDIF
	IF	LDOS2
	DEFM	'L2'
	ENDIF
	IF	LDOS3
	DEFM	'L3'
	ENDIF
	IF	LDOS4
	DEFM	'L4'
	ENDIF
	IF	MDOS1
	DEFM	'M1'
	ENDIF
	IF	MDOS3
	DEFM	'M3'
	ENDIF
	ENDM
;
;	ascii equivalences
;
_ETBL	EQU	00H		;end table
_NULL	EQU	00H		;null
_BRK	EQU	01H		;break
_STX	EQU	02H		;start text
_ETX	EQU	03H		;end text
_EOT	EQU	04H		;end transmission
_ENQ	EQU	05H		;enquiry
_ACK	EQU	06H		;acknowledge
_BEL	EQU	07H		;bel
_BKSP	EQU	08H		;backspace
_HT	EQU	09H		;horizontal tab
_LF	EQU	0AH		;linefeed
_VT	EQU	0BH		;vertical tab
_FF	EQU	0CH		;form feed
_CR	EQU	0DH		;carriage return
_CURON	EQU	0EH		;cursor on
_CUROFF	EQU	0FH		;cursor off
_DLE	EQU	10H		;data link engage
_DC1	EQU	11H		;device control 1
_DC2	EQU	12H		;device control 2
_DC3	EQU	13H		;device control 3
_DC4	EQU	14H		;device control 4
_NAK	EQU	15H		;negative acknowledge
_SYN	EQU	16H		;synchronize
_ETB	EQU	17H		;end transmission block
_CAN	EQU	18H		;cancel
_EM	EQU	19H		;end marker
_SUB	EQU	1AH		;submit
_ESC	EQU	1BH		;escape
_HOME	EQU	1CH		;home
_BOL	EQU	1DH		;begin of line
_EREOL	EQU	1EH		;erase to end of line
_EREOF	EQU	1FH		;erase to end of frame
_ECR	EQU	';'		;embedded carriage return
_REMARK	EQU	27H		;apostrophe remark
;
	IF	MOD1
_LBR	EQU	'<'		;left brace
_RBR	EQU	'>'		;right brace
_SEP	EQU	'/'		;separator
	ENDIF
;
	IF	MOD3
_LBR	EQU	'['		;left brace
_RBR	EQU	']'		;right brace
_SEP	EQU	'|'		;separator
	ENDIF
;
	IF	MOD4.OR.MOD2
_LBR	EQU	'['		;left brace
_RBR	EQU	']'		;right brace
_SEP	EQU	'|'		;separator
	ENDIF
	PAGE
;
;	dos dependent equivalences
;
	IF	LDOS1
DOSBUF$	EQU	4318H		;dos input buffer
@DODIR	EQU	4463H		;directory data
@RETCMD	EQU	4405H		;command interpreter
@VIDEO	EQU	3C00H		;begin video memory
@ROWS	EQU	16		;# video rows
@COLS	EQU	64		;# video columns
@VID	EQU	5		;start video row
@CODE	EQU	7000H		;begin load code
_BREAK	EQU	01H		;break key
_UP	EQU	5BH		;up arrow
_DOWN	EQU	0AH		;down arrow
_LEFT	EQU	08H		;left arrow
_RIGHT	EQU	09H		;right arrow
_SUP	EQU	1BH		;shift up
_SDOWN	EQU	1AH		;shift down
_SLEFT	EQU	18H		;shift left arrow
_SRIGHT	EQU	19H		;shift right arrow
_CLEAR	EQU	1FH		;clear key
_FLAGO	EQU	8CH		;flag on char
_FLAGF	EQU	'-'		;flag off char
CUREDIT	EQU	5FH		;editing cursor
CURPAGE	EQU	8FH		;paging cursor
CURENT	EQU	8CH		;enter key cursor
	ENDIF
;
	IF	LDOS3
DOSBUF$	EQU	4225H		;dos input buffer
@DODIR	EQU	4419H		;get directory data
@RETCMD	EQU	4299H		;dos command interpreter
@VIDEO	EQU	3C00H		;video memory
@ROWS	EQU	16		;# video rows
@COLS	EQU	64		;# video columns
@VID	EQU	5		;start video row
@CODE	EQU	7000H		;begin load code
_BREAK	EQU	01H		;break key
_UP	EQU	5BH		;up arrow
_DOWN	EQU	0AH		;down arrow
_LEFT	EQU	08H		;left arrow
_RIGHT	EQU	09H		;right arrow
_SUP	EQU	1BH		;shift up
_SDOWN	EQU	1AH		;shift down
_SLEFT	EQU	18H		;shift left arrow
_SRIGHT	EQU	19H		;shift right arrow
_CLEAR	EQU	1FH		;clear key
_FLAGO	EQU	8CH		;flag on char
_FLAGF	EQU	'-'		;flag off char
CUREDIT	EQU	5FH		;editing cursor
CURPAGE	EQU	8FH		;paging cursor
CURENT	EQU	8CH		;enter key cursor
	ENDIF
;
	IF	LDOS4.OR.LDOS2
@SVC	EQU	28H		;execute system call
@DODIR	EQU	34		;get directory data
@RETCMD	EQU	25		;command interpreter
@VIDEO	EQU	0F400H		;begin video memory
@ROWS	EQU	24		;# video rows
@COLS	EQU	80		;# video columns
@VID	EQU	6		;start video row
@CODE	EQU	3000H		;begin load code
_BREAK	EQU	128		;break key
_UP	EQU	011		;up arrow
_DOWN	EQU	010		;down arrow
_LEFT	EQU	08H		;left arrow
_RIGHT	EQU	09H		;right arrow
_SUP	EQU	1BH		;shift up
_SDOWN	EQU	1AH		;shift down
_SLEFT	EQU	18H		;shift left arrow
_SRIGHT	EQU	19H		;shift right arrow
_CLEAR	EQU	1FH		;clear key
_FLAGO	EQU	8CH		;flag on char
_FLAGF	EQU	'-'		;flag off char
CUREDIT	EQU	5FH		;editing cursor
CURPAGE	EQU	8FH		;paging cursor
CURENT	EQU	8CH		;enter key cursor
	ENDIF
;
	IF	MDOS1
DOSBUF$	EQU	4318H		;dos input buffer
@RETCMD	EQU	4405H		;command interpreter
@VIDEO	EQU	3C00H		;begin video memory
@ROWS	EQU	16		;# video rows
@COLS	EQU	64		;# video columns
@VID	EQU	5		;start video row
@CODE	EQU	7000H		;begin load code
_BREAK	EQU	01H		;break key
_UP	EQU	5BH		;up arrow
_DOWN	EQU	0AH		;down arrow
_LEFT	EQU	08H		;left arrow
_RIGHT	EQU	09H		;right arrow
_SUP	EQU	1BH		;shift up
_SDOWN	EQU	1AH		;shift down
_SLEFT	EQU	18H		;shift left arrow
_SRIGHT	EQU	19H		;shift right arrow
_CLEAR	EQU	1FH		;clear key
_FLAGO	EQU	8CH		;flag on char
_FLAGF	EQU	'-'		;flag off char
CUREDIT	EQU	5FH		;editing cursor
CURPAGE	EQU	8FH		;paging cursor
CURENT	EQU	8CH		;enter key cursor
	ENDIF
;
	IF	MDOS3
DOSBUF$	EQU	4225H		;dos input buffer
@RETCMD	EQU	4405H		;dos command interpreter
@VIDEO	EQU	3C00H		;video memory
@ROWS	EQU	16		;# video rows
@COLS	EQU	64		;# video columns
@VID	EQU	5		;start video row
@CODE	EQU	7000H		;begin load code
_BREAK	EQU	01H		;break key
_UP	EQU	5BH		;up arrow
_DOWN	EQU	0AH		;down arrow
_LEFT	EQU	08H		;left arrow
_RIGHT	EQU	09H		;right arrow
_SUP	EQU	1BH		;shift up
_SDOWN	EQU	1AH		;shift down
_SLEFT	EQU	18H		;shift left arrow
_SRIGHT	EQU	19H		;shift right arrow
_CLEAR	EQU	1FH		;clear key
_FLAGO	EQU	8CH		;flag on char
_FLAGF	EQU	'-'		;flag off char
CUREDIT	EQU	5FH		;editing cursor
CURPAGE	EQU	8FH		;paging cursor
CURENT	EQU	8CH		;enter key cursor
	ENDIF
;
;	system linkages
;
FIRST	EQU	@CODE		;first byte of code
$CMD	EQU	@CODE+000	;begin load code
$KBCHAR	EQU	@CODE+003	;keyboard character
$KBLINE	EQU	@CODE+006	;keyboard string
$KBEDIT	EQU	@CODE+009	;keyboard editor
$KBWKEY	EQU	@CODE+012	;alt keyboard editor
$DOCHAR	EQU	@CODE+015	;char to video
$DOLINE	EQU	@CODE+018	;string to video
$PRCHAR	EQU	@CODE+021	;char to printer
$PRLINE	EQU	@CODE+024	;string to printer
$MSIZE	EQU	@CODE+027	;fetch high memory
$DATE	EQU	@CODE+030	;fetch system date
$ERROR	EQU	@CODE+033	;display system error
$FSPEC	EQU	@CODE+036	;fetch user filespec
$INIT	EQU	@CODE+039	;open/create file
$OPEN	EQU	@CODE+042	;open file
$POSN	EQU	@CODE+045	;position to record
$READ	EQU	@CODE+048	;read record
$WRITE	EQU	@CODE+051	;write record
$CLOSE	EQU	@CODE+054	;close file
$KILL	EQU	@CODE+057	;kill file
$DSIZE	EQU	@CODE+060	;fetch disk params
$CKDRV	EQU	@CODE+063	;check drive ready
$RDDIR	EQU	@CODE+066	;read directory
$WRDIR	EQU	@CODE+069	;write directory
$OVRLAY	EQU	@CODE+072	;load overlay
;
$MULT	EQU	@CODE+075	;multiply
$DIVID	EQU	@CODE+078	;divide
$ADD24	EQU	@CODE+081	;add
$SUB24	EQU	@CODE+084	;subtract
$INC24	EQU	@CODE+087	;increment
$DEC24	EQU	@CODE+090	;decrement
$CMP24	EQU	@CODE+093	;compare
$BINASC	EQU	@CODE+096	;binary => ascii
$VALUE	EQU	@CODE+099	;ascii => binary
$GOTABL	EQU	@CODE+102	;table vectoring
$UCASE	EQU	@CODE+105	;char to upper case
$SAVREG	EQU	@CODE+108	;save registers
$POSHL	EQU	@CODE+111	;position to input chars
$COMPAR	EQU	@CODE+114	;compare strings
$EXIT	EQU	@CODE+117	;exit program
$DOERR	EQU	@CODE+120	;display error
$ENKEY	EQU	@CODE+123	;wait for enter key
$REWIND	EQU	@CODE+126	;rewind file
$SHOWF	EQU	@CODE+129	;display file stats
$CLEAR	EQU	@CODE+132	;clear data block
$VIDON	EQU	@CODE+135	;enable video
$VIDOFF	EQU	@CODE+138	;disable video
$INKEY	EQU	@CODE+141	;strobe keyboard
$INKEY1	EQU	@CODE+144	;special strobe
$DOHEAD	EQU	@CODE+147	;display header
$WILD	EQU	@CODE+150	;wild card make/test
$GET	EQU	@CODE+153	;get char from device
$PUT	EQU	@CODE+156	;put char to device
$GETDCT	EQU	@CODE+159	;get drive code table
$CURADD	EQU	@CODE+162	;get cursor address
$DFREE	EQU	@CODE+165	;get disk free space
$POSNR	EQU	@CODE+168	;non-buffered position
$LEOF	EQU	@CODE+171	;locate end of file
$READR	EQU	@CODE+174	;non-buffered read
$WRITER	EQU	@CODE+177	;non-buffered write
;
@DATA	EQU	@CODE+184	;data storage +7
@BUFTBL	EQU	@DATA-4		;buffer table
@BUFFS	EQU	@DATA-2		;buffers start
@POSIT	EQU	@DATA+0
@CURCMD	EQU	@DATA+4
@SYSADD	EQU	@DATA+6
@STACK	EQU	@DATA+8
@FLAG1	EQU	@DATA+10
@FLAG2	EQU	@DATA+11
@FNAME	EQU	@DATA+12
@FCB	EQU	@DATA+14
@IOBUFF	EQU	@DATA+16
@RECPTR	EQU	@DATA+18
@FREE1	EQU	@DATA+20
;
@DISKM	EQU	@DATA+48
@DISKS	EQU	@DATA+51
@DELD	EQU	@DATA+54
@SDT	EQU	@DATA+57
@EOFS	EQU	@DATA+60
@PATCHS	EQU	@DATA+63
@DDLS	EQU	@DATA+64
@DDLE	EQU	@DATA+67
@SSF	EQU	@DATA+70
@NFU	EQU	@DATA+73
@NFFR	EQU	@DATA+76
@NFFB	EQU	@DATA+79
@CRE	EQU	@DATA+80
@FREE2	EQU	@DATA+96
EXBUF$	EQU	@CODE+1200H	;command buffer
@OCODE	EQU	EXBUF$+100H	;start overlay code
BUFTBL	EQU	@OCODE+2A00H	;start buffer table
BUFFS	EQU	BUFTBL+100H	;start actual buffers
;
	IF	LDOS4.OR.LDOS2
DOSBUF$	EQU	EXBUF$+100H-80
	ENDIF
;
