; dman08/asm - kjw/bci - CHANGE
;
;	created 09/22/83	- kjw/bci
;	revised 10/08/83	- kjw/bci
;
;	data useage
;
;	+20-22	- # diskettes to use for dest
;	+23-25	- file size source
;	+26-28	- file size dest
;	+29-31	- current source record
;	+32-34	- current dest record
;	+35-37	- record count
;	+38	- entries / sector source
;	+39	- pointer source
;	+40	- entries / sector dest
;	+41	- pointer dest
;	+47	- 7	0=compressed, 1=expanded
;		- 6	0=no params,  1=params found
;
ENTRY	LD	IX,@DATA	;data block
	LD	(COMMAND),HL	;save command pointer
	PUSH	AF		;save command
	LD	HL,CLSMSG	;clear lower video
	CALL	$DOLINE		;display
	LD	(IX+47),0	;clear flags
	LD	B,(IX+48)	;get current max disks
	LD	H,(IX+49)
	LD	L,(IX+50)
	LD	(IX+20),B	;save as # for dest
	LD	(IX+21),H
	LD	(IX+22),L
	POP	AF		;restore command
	DEC	A		;command 1 CHANGE?
	JP	NZ,$CMD		;can't get here!
;
;	check if file is open
;
	BIT	7,(IX+10)	;index available?
	LD	HL,NOTMSG	;'file not open'
	JR	Z,ERREX		;error exit
	JR	START		;else continue
;
;	exit vectors
;
MISSING	LD	HL,MISMSG	;'missing information'
	JR	IERROR		;internal error
INVALID	LD	HL,INVMSG	;'invalid command'
IERROR	XOR	A		;set internal error
ERROR	LD	DE,ERRMSG	;'change system error'
ERREX	CALL	$DOERR		;display
GOCMD	LD	A,0<4+1		;command interpreter
	JP	$OVRLAY		;back to it
ABORT	JP	$CMD		;interpreter
BRKABT	LD	HL,BRKMSG	;aborted
	CALL	$DOLINE		;display
	JR	GOCMD		;back to interpreter
;
;	check for BREAK key
;
BRKCHK	CALL	$KBCHAR		;scan keyboard
	CP	_BREAK		;break key?
	RET	NZ		;nope, continue
	JR	BRKABT		;else abort!
;
START	CALL	SHOWSRC		;display source data
	LD	HL,$		;get command pointer
COMMAND	EQU	$-2
;
START0	CALL	$POSHL		;any input?
	JR	NZ,START1	;go if yes!
;
;	prompt user for filespec to copy to
;
	LD	HL,PROMPT	;'filespec'
	CALL	$DOLINE		;display prompt
	LD	B,50		;key input length
	CALL	$KBLINE		;get key input
	JP	C,ABORT		;abort on break
	JR	START0		;check if anything
;
;	evaluate user input
;
START1	LD	DE,DFCB		;dest FCB block
	CALL	$FSPEC		;extract filespec
	JR	NZ,ERROR	;go on disk error
;
;	check if any parameters
;
	CALL	$POSHL		;any more input?
	JR	Z,MISSING	;missing information
	CP	'('		;parameters?
	JR	NZ,INVALID	;invalid input
;
;	evaluate parameters
;
PARAM	INC	HL		;bump input pointer
	CALL	$POSHL		;any more input?
	JR	Z,EXECUT	;nope, continue
	CP	')'		;terminator?
	JR	Z,EXECUT	;yes, go!
	CP	_REMARK		;terminator?
	JR	Z,EXECUT	;yes, go!
	CALL	$UCASE		;make upper case
	CP	'C'		;compressed?
	JR	Z,PARAMC	;go if yes
	CP	'E'		;expanded?
	JR	Z,PARAME	;go if yes
	CP	'O'		;overwrite?
	JR	Z,PARAMO	;yes, go!
	CP	'D'		;new disk count?
	JR	NZ,INVALID	;nope, invalid parameter
;
PARAMD	INC	HL		;bump pointer
	LD	A,(HL)		;get data
	CP	'='		;value follows?
	JR	NZ,INVALID	;go if wrong!
	INC	HL		;bump pointer
	CALL	$VALUE		;get input value
	JR	NZ,INVALID	;go if non-number
	LD	A,C		;get msb
	OR	A		;>65535?
	JR	NZ,INVALID	;too big!
	LD	(IX+20),C	;load # disks for dest
	LD	(IX+21),D
	LD	(IX+22),E
;
;	check if # disk specified is < # used
;
	PUSH	HL		;save
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	CALL	$CMP24		;compare
	POP	HL		;restore input pointer
	JR	Z,DSKSOK	;equal
	JP	NC,INVALID	;cannot make smaller!
;
DSKSOK	DEC	HL		;adjust for immed inc
	JR	PARAMC		;continue
;
PARAME	SET	7,(IX+47)	;set new expanded dest
PARAMC	SET	6,(IX+47)	;set param found
	JR	PARAM		;continue
PARAMO	SET	5,(IX+47)	;set overwrite
	JR	PARAM		;continue
;
;	check if file exists
;
EXECUT	BIT	6,(IX+47)	;any params?
	JP	Z,MISSING	;missing information!
	CALL	SHOWDES		;display dest data
;
	LD	DE,DFCB		;dest file block
	LD	HL,DBUFF	;dest I/O buffer
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;clear buffer
	LD	BC,0<8+'W'	;lrl + write access
	CALL	$INIT		;open/create file
	JP	NZ,ERROR	;go on disk error
	JR	C,ALLOC		;new file, continue
	BIT	5,(IX+47)	;overwrite?
	JR	NZ,ALLOC	;yes, go!
;
;	file exists, ask if to be replaced
;
ASKIF	LD	HL,REPMSG	;'exists, replace?'
	CALL	$DOLINE		;display
	LD	B,3		;key input length
	CALL	$KBLINE		;get key input
	JP	C,ABORT		;abort on break
	CALL	$UCASE		;first char to upper case
	CP	'N'		;no?
	JP	Z,ABORT		;yes, abort!
	CP	'Y'		;overwrite?
	JR	NZ,ASKIF	;neither, ask again
;
;	allocate required amount of disk space
;
ALLOC	LD	HL,ALLCMG	;'allocating'
	CALL	$DOLINE		;display
	LD	DE,DFCB		;dest file block
	LD	BC,@DATA+26	;file length needed
	CALL	$POSNR		;position file
	JR	Z,ALLOC1	;go if OK
	CP	1CH		;out of range?
	JR	Z,ALLOC1	;yes, OK
	CP	1DH		;out of range?
	JP	NZ,ERROR	;go if disk error
ALLOC1	CALL	$WRITER		;write sector
	JP	NZ,ERROR	;go if disk error!
;
;	copy source -> destination
;
	CALL	VERIFY		;init/verify disk space
	JP	NZ,ERROR	;go on error
	CALL	BRKCHK		;break check
	CALL	COPYN		;copy names/dates
	JP	NZ,ERROR	;go on error
	CALL	BRKCHK		;check for break
	CALL	COPYI		;copy indexes
	JP	NZ,ERROR	;go on error
	CALL	BRKCHK		;break check
	CALL	COPYF		;copy files
	JP	NZ,ERROR	;go on error
	CALL	BRKCHK		;break check
	CALL	COPY0		;copy sector 0 header
	JP	NZ,ERROR	;go on error
;
;	completed, exit
;
	LD	DE,DFCB		;dest file block
	CALL	$CLOSE		;close file
	JP	NZ,ERROR	;go on disk error
	LD	HL,CMPMSG	;'completed'
	CALL	$DOLINE		;display
	JP	GOCMD		;back to command mode
;
;	write to all sectors of file to init
;
VERIFY	CALL	BRKCHK		;break check
	LD	HL,INIMSG	;'initializing'
	CALL	$DOLINE		;display
	LD	HL,DBUFF	;dest buffer
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;reset buffer
	LD	BC,ZEROES	;zeroes for rewind
	LD	DE,DFCB		;dest file block
	CALL	$POSNR		;rewind file
	RET	NZ		;go on error
	LD	B,(IX+26)	;get dest filesize
	LD	H,(IX+27)
	LD	L,(IX+28)
;
INITLP	CALL	$WRITER		;write record
	RET	NZ		;go on disk error
	CALL	$DEC24		;dec counter
	LD	A,B		;done with write?
	OR	H
	OR	L
	JR	NZ,INITLP	;continue if more
;
;	rewind file and read verify all sectors
;
	LD	BC,ZEROES	;rewind data
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	CALL	BRKCHK		;check for break
	LD	HL,VERMSG	;'verifying'
	CALL	$DOLINE		;display
	LD	B,(IX+26)	;get dest size back
	LD	H,(IX+27)
	LD	L,(IX+28)
;
VERLP	CALL	$READR		;read sector
	RET	NZ		;go on error
	CALL	$DEC24		;decrement counter
	LD	A,B		;check if done
	OR	H
	OR	L
	JR	NZ,VERLP	;go till done
	RET			;inited and verified!
;
;	copy disk names/dates from source => dest
;
COPYN	LD	HL,CNAMSG	;'copying names/dates'
	CALL	$DOLINE		;display
	LD	BC,ZEROES+1	;record #1
	LD	DE,(@FCB)	;get source fcb
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	LD	DE,DFCB		;dest fcb
	LD	BC,ZEROES+1	;point to record
	CALL	$POSNR		;position file
	RET	NZ		;go on error
;
;	compute # sectors to copy
;
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide
	OR	A		;any reminder?
	CALL	NZ,$INC24	;bump result if yes
;
;	move BHL count sectors from source => dest
;
MOVESEC	LD	DE,(@FCB)	;get source fcb
	CALL	$READR		;read a record
	RET	NZ		;go on error
;
;	move I/O buffers
;
	PUSH	BC		;save count
	PUSH	HL
	LD	HL,(@IOBUFF)	;get I/O buffer start
	LD	DE,DBUFF	;dest I/O buffer
	LD	BC,100H		;buffer length
	LDIR			;move!
	POP	HL		;restore count
	POP	BC
;
	LD	DE,DFCB		;dest file block
	CALL	$WRITER		;write record!
	RET	NZ		;go on error
;
	CALL	$DEC24		;decrement count
	LD	A,B		;check if any more
	OR	H
	OR	L
	JR	NZ,MOVESEC	;continue if any
	RET			;else return Z status!
;
;	copy indexes from source to dest
;
COPYI	LD	HL,CPIMSG	;'copying indexes'
	CALL	$DOLINE		;display
	LD	DE,(@FCB)	;source FCB
	LD	BC,@DATA+57	;start tables
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	LD	DE,DFCB		;dest fcb
	LD	BC,IND0+57	;start tables
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	JP	MOVESEC		;move sectors
;
;	copy files from source to dest
;
COPYF	LD	HL,CFIMSG	;'copying file data'
	CALL	$DOLINE		;display
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+70)	;get start sector files
	LD	H,(IX+71)
	LD	L,(IX+72)
	LD	(IX+29),B	;update current record
	LD	(IX+30),H	;for source
	LD	(IX+31),L
	LD	IY,IND0		;dest table
	LD	B,(IY+70)	;get dest start sector
	LD	H,(IY+71)
	LD	L,(IY+72)
	LD	(IX+32),B	;current record dest
	LD	(IX+33),H
	LD	(IX+34),L
;
	LD	B,(IX+76)	;get # to copy
	LD	H,(IX+77)
	LD	L,(IX+78)
	LD	A,B		;check if any files
	OR	H
	OR	L
	RET	Z		;nope, done!
	LD	(IX+35),B	;init record count
	LD	(IX+36),H
	LD	(IX+37),L
	LD	A,4		;ent/sec expanded
	BIT	6,(IX+10)	;expanded?
	JR	NZ,$+4		;go if yes
	LD	A,8		;ent/sec compressed
	LD	(IX+38),A	;entries/sector source
;
	LD	A,4		;ent/sec expanded
	BIT	7,(IX+47)	;expanded dest?
	JR	NZ,$+4		;go if yes
	LD	A,8		;ent/sec compressed
	LD	(IX+40),A	;entries/sector dest
	LD	(IX+39),0	;pointer source
	LD	(IX+41),0	;pointer dest
;
;	position files
;
	LD	DE,(@FCB)	;source file
	LD	BC,@DATA+29	;source record
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	LD	DE,DFCB		;dest file
	LD	BC,@DATA+32	;dest record
	CALL	$POSNR		;position file
	RET	NZ		;go on error
;
COPYLP	LD	IX,@DATA	;reset pointer
	LD	A,(IX+39)	;get current position
	OR	A		;at first record
	JR	NZ,COPYLP1	;go if not
	LD	DE,(@FCB)	;get source FCB
	CALL	$READR		;read a sector
	RET	NZ		;go on disk error
COPYLP1	LD	A,(IX+39)	;get position
	BIT	6,(IX+10)	;expanded?
	CALL	COPYPOS		;compute offset
	LD	C,A		;pass offset
	LD	B,0		;BC = offset
	LD	HL,(@IOBUFF)	;buffer start
	ADD	HL,BC		;HL => current record
	CALL	UNPACK		;unpack record
	LD	IX,@DATA	;reset pointer
	LD	A,(IX+39)	;pointer source
	INC	A		;bump it
	CP	(IX+38)		;maximum read?
	JR	NZ,$+3		;go if not
	XOR	A		;else reset to first
	LD	(IX+39),A	;update pointer
;
;	write to dest file
;
	LD	A,(IX+41)	;get pointer dest
	OR	A		;at first entry?
	JR	NZ,COPYLP2	;go if not
	LD	HL,DBUFF	;dest buffer
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;reset buffer
;
COPYLP2	LD	A,(IX+41)	;get pointer dest
	BIT	7,(IX+47)	;set flags
	CALL	COPYPOS		;compute offset
	LD	C,A		;pass lsb
	LD	B,0		;BC = offset
	LD	HL,DBUFF	;dest buffer start
	ADD	HL,BC		;HL => entry
	CALL	PACK		;pack => HL
	LD	IX,@DATA	;reset pointer
;
;	check if buffer full for write
;
	LD	A,(IX+41)	;get pointer dest
	INC	A		;bump it
	LD	(IX+41),A	;update counter
	CP	(IX+40)		;buffer full?
	JR	NZ,COPYLP3	;nope, continue
	LD	DE,DFCB		;dest file block
	CALL	$WRITER		;write sector
	RET	NZ		;go on error
	LD	(IX+41),0	;reset counter
;
COPYLP3	LD	B,(IX+35)	;get record count
	LD	H,(IX+36)
	LD	L,(IX+37)
	CALL	$DEC24		;decrement counter
	LD	(IX+35),B	;update remaining count
	LD	(IX+36),H
	LD	(IX+37),L
	LD	A,B		;check if done
	OR	H
	OR	L
	JP	NZ,COPYLP	;continue if more
;
;	all files transferred, check if partial buffer
;
	LD	A,(IX+41)	;get dest pointer
	OR	A		;at 0?
	RET	Z		;yes, buffer written
	LD	DE,DFCB		;dest file block
	JP	$WRITER		;write and return stat
;
;	copy first sector of file with updated info
;
COPY0	LD	HL,C0MSG	;'copying headers'
	CALL	$DOLINE		;display
	LD	DE,(@FCB)	;get source fcb
	LD	BC,ZEROES	;for rewind
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	CALL	$READR		;read the sector
	RET	NZ		;go on error
	LD	HL,(@IOBUFF)	;get I/O buffer
	LD	DE,DBUFF	;dest buffer
	LD	BC,100H		;length
	LDIR			;move it
	LD	HL,IND0+48	;start new information
	LD	DE,DBUFF+48	;where it goes
	LD	BC,32		;data length
	LDIR			;I/O buffer updated
;
	LD	A,0		;set compressed
	BIT	7,(IX+47)	;new file compressed?
	JR	Z,$+3		;go if yes
	DEC	A		;set FF for expanded
	LD	(DBUFF+0FFH),A	;flag buffer
;
	LD	HL,DBUFF+80	;date created
	CALL	$DATE		;move date here
	LD	DE,DFCB		;dest file block
	LD	BC,ZEROES	;for rewind
	CALL	$POSNR		;position file
	RET	NZ		;go on error
	JP	$WRITER		;write and return
;
;	compute byte offset for current buffer
;
COPYPOS	JR	NZ,COPYPE	;go if expanded
	RRCA			;align data
	RRCA
	RRCA
	AND	0E0H		;A = offset
	RET			;done
COPYPE	RRCA			;align data
	RRCA
	AND	0C0H		;A = offset
	RET			;done
;
;	display source statistics
;
SHOWSRC	LD	IX,@DATA	;reset pointer
	LD	DE,(@FCB)	;get source file block
	CALL	$LEOF		;locate end of file
	LD	(IX+23),B	;save file size
	LD	(IX+24),H
	LD	(IX+25),L
;
;	compute file size in K
;
	CALL	$INC24		;correct from 0 relative
	LD	C,4		;sectors / kilobyte
	CALL	$DIVID		;BHL+A = BHL/C
	PUSH	AF		;save remainder
	LD	IX,SMSG5	;text to hold
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	AF		;restore remainder
	ADD	A,A		;*2
	LD	HL,REMTBL	;remainder table
	ADD	A,L		;add offset
	LD	L,A		;update lsb
	JR	NC,$+3		;go if no overflow
	INC	H		;bump page
	LD	A,(HL)		;get first char
	INC	HL		;bump
	LD	H,(HL)		;get second char
	LD	L,A		;HL = text
	LD	(SMSG6),HL	;load into message
;
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+48)	;get max diskettes
	LD	H,(IX+49)
	LD	L,(IX+50)
	LD	IX,SMSG9	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;convert to ascii
;
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	LD	IX,SMSG7	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;convert to ascii
;
	LD	IX,@DATA	;reset pointer
	LD	B,(IX+73)	;get # files
	LD	H,(IX+74)
	LD	L,(IX+75)
	LD	IX,SMSG8	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
;
	LD	IX,@DATA	;reset pointer
	LD	HL,SMSG1	;'source file: '
	CALL	$DOLINE		;display
	LD	HL,SMSG2	;'expanded'
	BIT	6,(IX+10)	;yes?
	JR	NZ,$+5		;go if yes
	LD	HL,SMSG3	;'compressed'
	CALL	$DOLINE		;display
	LD	HL,SMSG4	;start of text
	JP	$DOLINE		;display and return
;
;	setup table for new file
;
SHOWDES	LD	IX,@DATA	;reset pointer
	LD	IY,IND0		;first record buffer
	LD	HL,IND0		;start of table
	LD	BC,0<8+0FFH	;length + fill
	CALL	$CLEAR		;init buffer
	LD	HL,@DATA+48	;start data table
	LD	DE,IND0+48	;new data table
	LD	BC,32		;table length
	LDIR			;move it!
;
;	update new changes to file
;
	LD	B,(IX+20)	;get # disks to use
	LD	H,(IX+21)
	LD	L,(IX+22)
	LD	(IY+48),B	;update new table
	LD	(IY+49),H
	LD	(IY+50),L
;
;	compute # sectors needed
;
	PUSH	BC		;save
	PUSH	HL		;save
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide out
	OR	A		;any remainder?
	CALL	NZ,$INC24	;bump partial if yes
	CALL	$INC24		;+1 for header sector
	LD	(IY+57),B	;update disk table start
	LD	(IY+58),H
	LD	(IY+59),L
	POP	DE		;nsb/lsb # disks
	POP	AF		;A = msb
	LD	C,A		;CDE = # disks
	CALL	$ADD24		;BHL = BHL + CDE
	LD	(IY+70),B	;save start sector files
	LD	(IY+71),H
	LD	(IY+72),L
;
;	compute actual file length currently needed
;
	PUSH	BC		;save current sectors
	PUSH	HL
	LD	B,(IX+76)	;get next free record
	LD	H,(IX+77)
	LD	L,(IX+78)
	LD	C,4		;entries / sector expand
	BIT	7,(IX+47)	;expanded dest?
	JR	NZ,$+4		;go if yes
	LD	C,8		;entries / sector compres
	CALL	$DIVID		;compute
	OR	A		;any remainder?
	CALL	NZ,$INC24	;bump if yes
	POP	DE		;restore file start
	POP	AF		;a=msb
	LD	C,A		;CDE = current end
	CALL	$ADD24		;BHL = total size needed
	LD	(IY+60),B	;save end of file sector
	LD	(IY+61),H	;nsb
	LD	(IY+62),L	;lsb
	LD	(IX+26),B	;save for allocating
	LD	(IX+27),H
	LD	(IX+28),L
;
;	compute file size in K
;
	LD	C,4		;sectors / kilobyte
	CALL	$DIVID		;BHL+A = BHL/C
	PUSH	AF		;save remainder
	LD	IX,SMSG5	;text to hold
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	AF		;restore remainder
	ADD	A,A		;*2
	LD	HL,REMTBL	;remainder table
	ADD	A,L		;add offset
	LD	L,A		;update lsb
	JR	NC,$+3		;go if no overflow
	INC	H		;bump page
	LD	A,(HL)		;get first char
	INC	HL		;bump
	LD	H,(HL)		;get second char
	LD	L,A		;HL = text
	LD	(SMSG6),HL	;load into message
;
	LD	IX,IND0		;reset pointer
	LD	B,(IX+48)	;# disks for dest
	LD	H,(IX+49)
	LD	L,(IX+50)
	LD	IX,SMSG9	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
;
	LD	IX,IND0		;reset pointer
	LD	B,(IX+51)	;get # disks used
	LD	H,(IX+52)
	LD	L,(IX+53)
	LD	IX,SMSG7	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;convert to ascii
;
	LD	IX,IND0		;reset pointer
	LD	B,(IX+73)	;get # files
	LD	H,(IX+74)
	LD	L,(IX+75)
	LD	IX,SMSG8	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;binary => ascii
;
	LD	IX,@DATA	;reset pointer
	LD	HL,SMSG10	;'dest file:'
	CALL	$DOLINE		;display
	LD	HL,SMSG2	;'expanded'
	BIT	7,(IX+47)	;yes?
	JR	NZ,$+5		;go if yes
	LD	HL,SMSG3	;'compressed'
	CALL	$DOLINE		;display
	LD	HL,SMSG4	;start of text
	JP	$DOLINE		;display and return
;
REMTBL	DEFM	'0 '
	DEFM	'25'
	DEFM	'5 '
	DEFM	'75'
;
;	pack data file from EBUFF to (HL)
;
PACK	EX	DE,HL		;DE => dest
	LD	HL,EBUFF	;expanded buffer
	LD	BC,11		;length
	LDIR			;move data
;
	LD	A,(@DATA+47)	;get sys flag
	BIT	7,A		;expanded?
	JR	NZ,PACKE	;yes, go!
;
;	pack compressed
;
PACKC	LD	HL,EBUFF+21	;name here
	LD	B,17		;length
	CALL	MBITS		;move bits
	LD	IX,EBUFF+74	;start flags
	LD	B,12		;flag count
	CALL	MBITS0		;move bits
;
;	align last data byte to high order bits
;
PACKD	SLA	E		;align bits
	DEC	D		;less bit counter
	JR	NZ,PACKD	;go for count
	LD	(IY+0),E	;update last byte
	RET			;done
;
;	pack expanded
;
PACKE	LD	B,5		;10 digits total
PACK1	LD	A,(HL)		;get data
	CALL	PACKR		;adjust data
	RLCA			;align
	RLCA
	RLCA
	RLCA
	AND	0F0H		;4 bits only
	LD	C,A		;save partial
	INC	HL		;bump pinter
	LD	A,(HL)		;get data
	CALL	PACKR		;adjust char
	OR	C		;combine
	LD	(DE),A		;to dest file
	INC	HL		;bump source
	INC	DE		;bump dest
	DJNZ	PACK1		;go for 10 digits
;
	LD	B,53		;53 bytes to move
	CALL	MBITS		;move bits
	LD	B,12		;12 flags
	JR	MBITS0		;move 'em
;
;	compute digit for packed record
;
PACKR	CP	'*'		;nil?
	JR	Z,PACKRR	;go if yes
	SUB	'0'		;remove ascii
	JR	C,PACKRR	;out of range!
	CP	10		;0-9?
	RET	C		;yes, go!
PACKRR	XOR	A		;else set to zero
	RET			;return digit
;
;	move B bits from (HL) => (DE)
;
MBITS	PUSH	HL		;pass to IX
	POP	IX		;IX => source
	PUSH	DE		;pass to IY
	POP	IY		;IY => dest
	LD	DE,8<8+0	;D=bit count, E=byte
	LD	L,7		;bits to move / byte
	JR	MBITS1		;continue
;
MBITS0	LD	L,1		;bits to move / byte
MBITS1	LD	A,(IX+0)	;get data
	ADD	A,A		;ignore bit
	INC	IX		;bump pointer
	PUSH	HL		;save count
	CALL	MBITS2		;move bits
	POP	HL		;restore count
	DJNZ	MBITS1		;go for byte count
	LD	(IY+0),E	;update last byte
	RET			;done
;
MBITS2	ADD	A,A		;move bit to carry
	RL	E		;move to data byte
	DEC	D		;less bit counter
	JR	NZ,MBITS3	;go if not full
	LD	(IY+0),E	;load data byte
	INC	IY		;bump dest pointer
	LD	DE,8<8+0	;reset count/byte
;
MBITS3	DEC	L		;less bit count/byte
	JR	NZ,MBITS2	;go for count
	RET			;byte moved!
;
UNPACK	PUSH	HL		;save source pointer
	CALL	CLREBUF		;reset Expanded buffer
	POP	HL		;HL => compressed rec
	LD	DE,EBUFF	;DE => expanded rec
	LD	BC,11		;count
	LDIR			;move flags
;
;	check if compressed, expanded
;
	LD	A,(@FLAG1)	;get sys flag
	BIT	6,A		;expanded?
	JR	NZ,UNPACKE	;yes, go!
;
;	unpack compressed
;
	LD	B,17		;17 bytes to uncompress
	LD	DE,EBUFF+21	;name/version here
	CALL	UBITS		;unpack bits
	LD	IY,EBUFF+74	;flag storage
	JR	UNPACKC		;continue
;
;	move telephone
;
UNPACKE	LD	B,5		;5 compressed digits
UNPACK1	LD	A,(HL)		;get compressed digit
	INC	HL		;bump pointer
	LD	C,A		;save
	RRCA			;align high bits
	RRCA
	RRCA
	RRCA
	CALL	UNPACK2		;make ascii
	LD	A,C		;get digit
	CALL	UNPACK2		;make ascii
	DJNZ	UNPACK1		;go for count
	JR	UNPACK3		;continue
;
UNPACK2	AND	0FH		;low 4 bits only
	ADD	A,'0'		;make ascii
	LD	(DE),A		;load
	INC	DE		;bump
	RET			;loaded
;
UNPACK3	LD	B,53		;53 bits to move
	CALL	UBITS		;move bits
;
;	move flag data
;
UNPACKC	LD	B,12		;12 flags
UNPACK4	ADD	A,A		;bump count
	LD	E,0		;set flag off
	JR	NC,$+3		;go if off
	DEC	E		;set flag on
	LD	(IY+0),E	;load data
	INC	IY		;bump
	DEC	D		;less bits / byte
	JR	NZ,UNPACK5	;continue
	LD	D,8		;reset count
	LD	A,(IX+0)	;get next data
	INC	IX		;bump source
UNPACK5	DJNZ	UNPACK4		;go for flag count
	XOR	A		;set OK
	RET			;done
;
;	move bits from (HL) to (DE)
;
UBITS	PUSH	HL		;pass to IX
	POP	IX		;IX => source
	PUSH	DE		;pass to IY
	POP	IY		;IY => dest
	LD	DE,8<8+0	;D=bits/byte, E=byte
	LD	L,7		;bits to move / byte
	LD	A,(IX+0)	;get first data byte
	INC	IX		;bump pointer
;
UBITS2	ADD	A,A		;move bit to carry
	RL	E		;catch bit
	DEC	D		;less bits / byte
	JR	NZ,UBITS3	;more to go
	LD	D,8		;reset bit count
	LD	A,(IX+0)	;get next source
	INC	IX		;bump pointer
;
UBITS3	DEC	L		;less # bits / byte
	JR	NZ,UBITS2	;go till have 7
	LD	L,7		;reset # bits needed
	LD	(IY+0),E	;load data byte
	INC	IY		;bump pointer
	LD	E,0		;reset byte
UBITS4	DJNZ	UBITS2		;go for count
	RET			;done!
;
;	clear expanded buffer to nil data
;
CLREBUF	LD	HL,EBUFF	;start buffer
	LD	BC,5<8+0	;flags 5 bytes
	CALL	$CLEAR		;zero it out
	LD	HL,EBUFF+5	;links
	LD	BC,6<8+0FFH	;links 6 bytes
	CALL	$CLEAR		;reset links
	LD	HL,EBUFF+11	;phone
	LD	BC,10<8+'*'	;length + fill
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+21	;name etc
	LD	B,12+5+12+10+8+6
	LD	C,' '
	CALL	$CLEAR		;reset data
	LD	HL,EBUFF+74	;flags
	LD	BC,12<8+0	;length + fill
	JP	$CLEAR		;clear and return
;
;	message text
;
CLSMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFB	_EREOF
	DEFB	_ETX
;
NOTMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'File Not Available - Use OPEN'
	DEFB	_EREOL
	DEFB	_ETX
;
MISMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Missing Information - Use HELP'
	DEFB	_EREOL
	DEFB	_ETX
;
INVMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Invalid Command Parameter - Use HELP'
	DEFB	_EREOL
	DEFB	_ETX
;
ERRMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'System Error - '
	DEFB	_EREOL
	DEFB	_ETX
;
PROMPT	DEFB	_STX
	DEFB	@VID,00
	DEFM	'Filespec? '
	DEFB	_EREOL
	DEFB	_ETX
;
REPMSG	DEFB	_STX
	DEFB	@VID,00
	DEFM	'File Exists, Replace? '
	DEFB	_EREOL
	DEFB	_ETX
;
CMPMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'** Completed **'
	DEFB	_EREOL
	DEFB	_ETX
;
BRKMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'** Aborted **'
	DEFB	_EREOL
	DEFB	_ETX
;
SMSG1	DEFB	_STX
	DEFB	@VID+3,00
	DEFM	'Source File     : '
	DEFB	_ETX
;
SMSG10	DEFB	_STX
	DEFB	@VID+6,00
	DEFM	'Destination File: '
	DEFB	_ETX
;
SMSG2	DEFM	'EXPANDED  '
	DEFB	_ETX
;
SMSG3	DEFM	'COMPRESSED'
	DEFB	_ETX
;
SMSG4	DEFM	'  File Size:'
SMSG5	DEFM	'.........'
SMSG6	DEFM	'..k'
	DEFB	_CR
	DEFM	'Contains: '
SMSG9	DEFM	'..... Max Disks, '
SMSG7	DEFM	'..... Used Disks, '
SMSG8	DEFM	'........ Used Files'
	DEFB	_CR
	DEFB	_ETX
;
ALLCMG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Allocating New File Space ...'
	DEFB	_EREOL
	DEFB	_ETX
;
INIMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Initializing New File ...'
	DEFB	_EREOL
	DEFB	_ETX
;
VERMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Verifying New File ...'
	DEFB	_EREOL
	DEFB	_ETX
;
CNAMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Copying Names/Dates ...'
	DEFB	_EREOL
	DEFB	_ETX
;
CFIMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Copying File Data ...'
	DEFB	_EREOL
	DEFB	_ETX
;
CPIMSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Copying Index Sectors ...'
	DEFB	_EREOL
	DEFB	_ETX
;
C0MSG	DEFB	_STX
	DEFB	@VID+1,00
	DEFM	'Copying Header Information ...'
	DEFB	_EREOL
	DEFB	_ETX
;
ZEROES	DEFB	0,0,0,1
DFCB	DEFS	50
;
DMYBUF	EQU	$&0FF00H
IND0	EQU	DMYBUF+100H
EBUFF	EQU	IND0+100H
DBUFF	EQU	EBUFF+100H
_______	EQU	DBUFF+0FFH
	ORG	_______
	DEFB	0
;
	END	ENTRY
