; dman07a/asm - kjw/bci - EDITOR support
;
;	update index sector relative 00000
;
UPDAT0	LD	HL,@DATA+48	;source data
	LD	DE,IND0+48	;dest data mem buff
	LD	BC,32		;data length
	LDIR			;move it
	SET	2,(IX+21)	;set buffer needs update
	XOR	A		;set NO error
	RET			;done!
;
UPDATF	SET	6,(IX+21)	;set buffer updated
	XOR	A		;set no error
	RET			;done!
;
;	display flag names to video
;
FLAGNAM	LD	B,@VID+8	;row start
	LD	C,0		;column start
	LD	HL,IND0+60H	;flag name buffer
	LD	DE,1<8+12	;D=flag# / E=count
;
FLAGLP	PUSH	BC		;save row/col
	PUSH	DE		;save flag #/count
	LD	A,B		;get current row
	LD	(FLAGM1),A	;to text
	LD	A,C		;get current column
	LD	(FLAGM2),A	;to text
	LD	A,D		;get flag #
	CALL	ASCII		;to ascii
	LD	(FLAGM3),BC	;to the string
	LD	DE,FLAGM4	;actual text
	LD	BC,8		;char length
	LDIR			;move text
;
	PUSH	HL		;save text pointer
	LD	HL,FLAGM	;flag message
	CALL	$DOLINE		;display flag
	POP	HL		;unstack
	POP	DE
	POP	BC
;
;	go next flag
;
	DEC	E		;less count
	RET	Z		;done!
	INC	D		;bump flag #
	LD	A,C		;get column
	ADD	A,16		;offset to next
	LD	C,A		;update column
	CP	64		;0-63?
	JR	C,FLAGLP	;go next if yes
	LD	C,0		;reset column
	INC	B		;bump row
	JR	FLAGLP		;continue
;
;	quick convert to decimal ascii
;
ASCII	LD	C,'0'		;init msb
ASCI1	SUB	10		;less 10's place
	JR	C,ASCI2		;found, go!
	INC	C		;bump ascii
	JR	ASCI1		;continue
ASCI2	ADD	A,'0'+10	;ascii + last sub
	LD	B,A		;load lsb
	RET			;done
;
;	display expanded video data
;
DISPLAY	CALL	$VIDON		;enable video memory
	LD	IY,TABLETE	;display table expanded
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,DISPLP	;go if yes
	LD	IY,TABLETC	;display table compressed
;
DISPLP	LD	E,(IY+0)	;get video address
	LD	D,(IY+1)
	LD	C,(IY+2)	;get field length
	LD	B,0		;BC = length
	LD	HL,DISPRET	;return vector
	PUSH	HL		;to stack
	LD	L,(IY+4)	;get driver address
	LD	H,(IY+5)	;HL => driver
	PUSH	HL		;to stack
	LD	H,EBUFF<-8	;msb buffer
	LD	L,(IY+3)	;HL => data
	RET			;go driver
;
DISPRET	LD	BC,8		;offset to next entry
	ADD	IY,BC		;IY => next entry
	LD	A,(IY+0)	;check for terminator
	OR	(IY+1)		;=0000?
	JR	NZ,DISPLP	;go if not
	JP	$VIDOFF		;disable video
;
;	display drivers
;
DVRN	LD	A,(EBUFF)	;get first char
	BIT	5,A		;alt format?
	LD	B,3		;make filespec
	JP	Z,$WILD		;move and return if norm
	LD	B,0		;msb length
	LDIR			;else move it
	RET			;done
;
DVR0	LD	A,'('		;area code
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	BC,3		;3 chars
	LDIR			;move 'em
	LD	A,')'		;area code
	LD	(DE),A		;to video
	INC	DE		;bump video
	LD	A,' '		;blank
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	C,3		;prefix
	LDIR			;move 'em
	LD	A,'-'		;phone separator
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	C,4		;phone
;
DVR1	LDIR			;move to video
	RET			;done
;
DVR2	LD	A,(HL)		;get a byte
	INC	A		;on?
	LD	A,_FLAGO	;flag on
	JR	Z,$+4		;go if on
	LD	A,_FLAGF	;flag off
	LD	(DE),A		;to video
	RET			;done
;
DVR3	BIT	4,(HL)		;active date?
	JR	NZ,DVR3A	;go if not!
;
	INC	HL		;flags2
	INC	HL		;flags3
	INC	HL		;flags4
	EX	DE,HL		;HL => video
	LD	A,(DE)		;get month
	AND	0FH		;low 4 bits only
	CALL	ASCII		;decimal ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump
	INC	HL		;bump
	DEC	DE		;flags3
	DEC	DE		;flags2
	LD	A,(DE)		;get data
	RRCA			;shift data
	RRCA
	RRCA
	AND	00011111B	;day of month
	CALL	ASCII		;to ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump
	INC	HL		;bump
	LD	A,(DE)		;get data
	AND	7		;low 3 bits
	ADD	A,80		;correct year
	CALL	ASCII		;to ascii
	LD	(HL),C		;load msb
	INC	HL		;bump
	LD	(HL),B		;load lsb
	RET			;done, date loaded
;
DVR3A	EX	DE,HL		;HL => buffer
	LD	A,'*'		;nil indicator
	LD	(HL),A		;load month
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	LD	(HL),A		;load day
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	LD	(HL),A		;load year
	INC	HL
	LD	(HL),A
	RET			;done
;
DVR4	BIT	1,(HL)		;pds file?
	LD	A,'P'		;set
	JR	NZ,$+4		;go if yes
	LD	A,'-'		;else not
	LD	(DE),A		;to text
	INC	DE		;bump to next
;
	INC	HL		;flags2
	INC	HL		;flags3
	LD	A,'I'		;invisible?
	BIT	6,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'S'		;system?
	BIT	5,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'M'		;modified?
	BIT	7,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'C'		;created?
	BIT	3,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'N'		;non-shrink?
	BIT	4,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,(HL)		;get data
	AND	7		;prot level
	ADD	A,'0'		;make ascii
	LD	(DE),A		;to video
	RET			;done
;
DVR5	LD	A,(HL)		;get data
	RRCA			;align data
	RRCA
	AND	3		;low 2 bits
	ADD	A,'A'		;adjust
	LD	(DE),A		;to video
	RET			;done
;
;	keyboard editors
;
EDIT0	JR	EDIT0A		;go if have key
	LD	(EDIT0HL),HL	;save HL
	LD	(EDIT0P),DE	;save data pointer
	CALL	ADJUST		;adjust input
EDIT00	LD	DE,TBUFF	;temp buffer
	LD	B,14		;key input length
	LD	HL,$		;get pointer
EDIT0HL	EQU	$-2
	CALL	$KBEDIT		;edit
	JR	EDIT0B		;continue
;
EDIT0A	PUSH	AF		;save input key
	LD	(EDIT0P),DE	;save data pointer
	LD	(EDIT0HL),HL	;save video pointer
	CALL	ADJUST		;adjust input
	POP	AF		;restore pointer
	CALL	$KBWKEY		;go with key
;
;	adjust and re-display
;
EDIT0B	JR	C,EDIT0H	;clear if BREAK
	LD	DE,TBUFF1	;data pointer
	LD	HL,TBUFF	;input buffer
	LD	BC,14<8+0	;max length + desired
;
EDIT0C	LD	A,(HL)		;get input char
	INC	HL		;bump pointer
	CP	'0'		;digit?
	JR	C,EDIT0G	;nope, remove it
	CP	'9'+1		;digit?
	JR	NC,EDIT0G	;nope, remove it
	LD	(DE),A		;load to data buffer
	INC	DE		;bump pointer
	INC	C		;bump char count
	LD	A,C		;check for max
	CP	10		;at max?
	JR	Z,EDIT0E	;end if at max
EDIT0G	DJNZ	EDIT0C		;continue
EDIT0D	LD	A,C		;have 10 digits?
	CP	10		;have max?
	JR	Z,EDIT0E	;yes, end!
	CP	7		;have 7?
	JR	NZ,EDIT00	;nope, invalid input!
	LD	HL,TBUFF1-3	;add '***' for area code
	JR	EDIT0F		;contiue
;
EDIT0H	LD	HL,TBUFF0	;nil data
	JR	EDIT0F		;continue
EDIT0E	LD	HL,TBUFF1	;data buffer
EDIT0F	LD	DE,$		;fetch pointer
EDIT0P	EQU	$-2
	LD	BC,10		;# digits
	LDIR			;move to buffer
;
;	re-display corrected phone #
;
REDISP	PUSH	IX		;save tables
	PUSH	IY
	CALL	DISPLAY		;display data
	POP	IY		;restore tables
	POP	IX
	XOR	A		;clear carry
	RET			;done!
;
;	adjust display for new data
;
ADJUST	PUSH	HL		;save video pointer
	EX	DE,HL		;HL => data source
	LD	DE,PHMSG1	;data
	PUSH	HL		;save start
	LD	BC,10		;length
	LDIR			;move it
	POP	HL		;hl => data
	LD	DE,TBUFF	;key input buffer
	LD	C,10		;length
	LDIR			;move it
	EX	DE,HL		;HL => remainder
	LD	BC,4<8+' '	;length + fill
	CALL	$CLEAR		;clear remainder
	LD	HL,PHMSG	;phone clear string
	CALL	$DOLINE		;display it
	POP	HL		;restore pointer
	LD	DE,TBUFF	;alternate input buffer
	LD	B,14		;key input length
	RET			;get key input
;
;
EDIT1	JR	EDIT1A		;go if have key
	JP	$KBEDIT		;edit and return
EDIT1A	JP	$KBWKEY		;with input key
;
EDIT2	JR	EDIT2A		;have a key
	XOR	A		;enter only
	RET			;go next entry
EDIT2A	CALL	$UCASE		;make upper case
	CP	'Y'		;yes?
	JR	Z,EDIT2S	;yes, set
	CP	'S'		;set?
	JR	Z,EDIT2S	;yes, set
	CP	'+'		;set?
	JR	Z,EDIT2S	;yes, go!
	CP	'N'		;nope?
	JR	Z,EDIT2R	;yes, reset
	CP	'R'		;reset?
	JR	Z,EDIT2R	;yes, reset
	CP	'-'		;reset?
	JR	Z,EDIT2R	;yes, go!
EDIT2C	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input key
	RET	C		;go on break
	JR	EDIT2A		;try again
;
EDIT2S	LD	A,-1		;flag on
	JR	EDIT2D		;continue
EDIT2R	XOR	A		;flag off
EDIT2D	LD	(DE),A		;update flag
	JP	REDISP		;re-display
;
EDIT5	JR	EDIT5A		;continue
	XOR	A		;enter only
	RET			;done
EDIT5A	CALL	$UCASE		;make upper case
	CP	'A'		;less?
	JR	C,EDIT5B	;yes, ask again
	CP	'E'		;A-D?
	JR	NC,EDIT5B	;too big!
	SUB	'A'		;remove ascii
	RLCA			;align bits
	RLCA
	AND	00001100B	;middle two only
	LD	C,A		;save result
	LD	A,(DE)		;get flags
	AND	11110011B	;remove bits
	OR	C		;combine with new
	LD	(DE),A		;update flags
	XOR	A		;set NC
	JP	REDISP		;re-display
EDIT5B	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input
	RET	C		;go on break
	JR	EDIT5A		;continue
;
;	edit dislayed record
;
EDITREC	LD	HL,CLS1		;clear command line
	CALL	$DOLINE		;display driver
EDITRC	LD	IX,TABLETE	;command table expanded
	LD	IY,TABLETV	;special vector table
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,EDITRC0	;go if yes
	LD	IX,TABLETC	;command table compressed
	LD	IY,TABLETW	;vector table
EDITRC0	LD	(TABLR1),IX	;ix reset table
	LD	(TABLR2),IY	;iy reset table
	JR	POSEDIT		;position for edit
;
EDITRC1	LD	E,(IX+3)	;get data offset
	LD	D,EBUFF<-8	;DE => data storage
	LD	B,(IX+2)	;get field length
	LD	L,(IX+0)	;get video area
	LD	H,(IX+1)	;HL => video
	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input key
	RET	C		;go if break
	CP	_ESC		;escape key?
	RET	Z		;go if yes
;
;	check if editing command
;
	LD	C,0		;init for vector
	LD	HL,EDITTBL	;editing table
	CALL	$GOTABL		;go if positioning key
;
;	not an edit key, edit current entry
;
	LD	HL,ADVNX	;return vector
	PUSH	HL		;leave on stack
	LD	C,0		;init count
	LD	L,(IX+0)	;get video
	LD	H,(IX+1)	;HL => video
	PUSH	HL		;save it
	LD	L,(IX+6)	;get subroutine
	LD	H,(IX+7)	;HL => subroutine
	CP	_CR		;carriage return?
	JR	NZ,$+4		;go if not
	INC	HL		;else bump vector
	INC	HL
	EX	(SP),HL		;get video, leave vector
	RET			;go editor!
;
ADVNX	RET	C		;go on BREAK
	JR	DISPU		;continue
;
;	cursor positioning commands
;
ADVSR	INC	C		;shift right
ADVSL	INC	C		;shift left
ADVSD	INC	C		;shift down
ADVSU	INC	C		;shift up
ADVR	INC	C		;+3 - right
ADVL	INC	C		;+2 - left
ADVD	INC	C		;+1 - down
ADVU	EQU	$		;+0 - up
;
	LD	A,C		;get offset
	LD	(DISPY),A	;save into code
	LD	C,(IY+0)	;get table offset
DISPY	EQU	$-1
DISPZ	LD	IX,$		;expanded data
TABLR1	EQU	$-2
	LD	IY,$		;vectors
TABLR2	EQU	$-2
	JR	DISPX		;continue
DISPU	LD	C,8		;init offset to next
;
DISPX	LD	B,0		;load MSB
	ADD	IX,BC		;offset to next entry
	ADD	IY,BC		;offset to next
;
;	check for non-editing entry
;
POSEDIT	LD	A,(IY+0)	;get data
	AND	(IY+1)		;=FFFF?
	INC	A		;yes?
	JR	Z,DISPU		;yes, skip to next
;
;	check for completed
;
	LD	A,(IX+0)	;check for terminator
	OR	(IX+1)		;=0000?
	JR	NZ,EDITRC1	;go if not
	LD	C,8		;offset to next
	JR	DISPZ		;contiue
;
PHMSG	DEFB	_STX
	DEFB	12,008
PHMSG1	DEFM	'              '
	DEFB	_ETX
TBUFF0	DEFM	'*******'
	DEFM	'***'		;altered area code
RECSTOR	DEFM	'......'	;record storage
STORREC	DEFM	'......'	;alternate storage
TBUFF1	DEFM	'..........'
TBUFF	DEFM	'...............'
;
CLS1	DEFB	_STX
	DEFB	@VID,000
	DEFB	_EREOL
	DEFB	_ETX
;
