; dman04e/asm - kjw/bci - Log Diskettes
;
;	created 08/16/83	- kjw/bci
;	revised 10/07/83	- kjw/bci
;
;	display disk #/type to video
;
SHOW1W	LD	A,'?'		;unknown cyls
	LD	(SMSG4),A	;to text
	LD	(SMSG4+1),A
	LD	(SMSG4+2),A
	JR	SHOW1Z		;continue
;
SHOW1	LD	IY,@DATA	;start data table
	LD	A,(IY+34)	;get drive #
	ADD	A,'0'		;make ascii
	LD	(SMSG0),A	;to string
;
	LD	B,(IY+20)	;get disk #
	LD	H,(IY+21)
	LD	L,(IY+22)
	LD	IX,SMSG1	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
;
	LD	HL,NAMDAT	;name/date
	LD	DE,SMSG2	;text to load
	LD	BC,8		;length
	LDIR			;move it
;
	LD	DE,SMSG3	;text to load
	LD	C,8		;length
	LDIR			;move date
;
	LD	B,0		;init msb
	LD	H,B		;init nsb
	LD	L,(IY+38)	;cyl count
	INC	L		;count =FF?
	JR	Z,SHOW1W	;go if unknown cyls
	DEC	L		;yes?
	JR	Z,SHOW1X	;yes, go! adding!
	LD	IX,SMSG4	;where it goes
	LD	DE,3<8+10	;length + base
	CALL	$BINASC		;binary=>ascii
;
SHOW1Z	LD	A,'S'		;single den
	BIT	6,(IY+39)	;single?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double den
	LD	(SMSG5),A	;to text
;
	LD	A,'S'		;single sided
	BIT	5,(IY+39)	;single?
	JR	Z,$+4		;go if yes
	LD	A,'D'		;double sided
	LD	(SMSG6),A	;to text
;
	LD	A,'5'		;5"?
	BIT	4,(IY+39)	;yes?
	JR	Z,$+4		;go if yes
	LD	A,'8'		;8"
	LD	(SMSG7),A	;to text
;
	LD	A,'F'		;floppy?
	BIT	7,(IY+39)	;yes?
	JR	Z,$+4		;go if yes
	LD	A,'R'		;rigid
	LD	(SMSG8),A	;to text
;
	LD	HL,0		;get free space
FREE	EQU	$-2
	LD	A,H		;check for nil
	AND	L
	INC	A		;=FFFF?
	LD	C,'?'		;set unknown
	JR	Z,SHOW1AB	;go if yes
	LD	A,H		;check for nil
	OR	L
	JR	Z,SHOW1AA	;go if yes
	LD	B,0		;BHL = free space
	PUSH	IX		;save
	LD	IX,SMSG9	;text to load
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;binary => ascii
	POP	IX		;restore
;
SHOW1Y	LD	HL,SMSG		;text message
	JP	$DOLINE		;display and return
SHOW1X	LD	A,'-'		;load default char
	LD	(SMSG4),A	;to string
	LD	(SMSG4+1),A
	LD	(SMSG4+2),A
	LD	(SMSG5),A
	LD	(SMSG6),A
	LD	(SMSG7),A
	LD	(SMSG8),A
SHOW1AA	LD	C,'-'		;load nil
SHOW1AB	LD	HL,SMSG9	;free space
	LD	B,5		;length
	CALL	$CLEAR		;clear string
	JR	SHOW1Y		;display
;
;	display flag names to video
;
FLAGNAM	LD	B,@VID+8	;row start
	LD	C,0		;column start
	LD	HL,IND0+60H	;flag name buffer
	LD	DE,1<8+12	;D=flag# / E=count
;
FLAGLP	PUSH	BC		;save row/col
	PUSH	DE		;save flag #/count
	LD	A,B		;get current row
	LD	(FLAGM1),A	;to text
	LD	A,C		;get current column
	LD	(FLAGM2),A	;to text
	LD	A,D		;get flag #
	CALL	ASCII		;to ascii
	LD	(FLAGM3),BC	;to the string
	LD	DE,FLAGM4	;actual text
	LD	BC,8		;char length
	LDIR			;move text
;
	PUSH	HL		;save text pointer
	LD	HL,FLAGM	;flag message
	CALL	$DOLINE		;display flag
	POP	HL		;unstack
	POP	DE
	POP	BC
;
;	go next flag
;
	DEC	E		;less count
	RET	Z		;done!
	INC	D		;bump flag #
	LD	A,C		;get column
	ADD	A,16		;offset to next
	LD	C,A		;update column
	CP	64		;0-63?
	JR	C,FLAGLP	;go next if yes
	LD	C,0		;reset column
	INC	B		;bump row
	JR	FLAGLP		;continue
;
;	quick convert to decimal ascii
;
ASCII	LD	C,'0'		;init msb
ASCI1	SUB	10		;less 10's place
	JR	C,ASCI2		;found, go!
	INC	C		;bump ascii
	JR	ASCI1		;continue
ASCI2	ADD	A,'0'+10	;ascii + last sub
	LD	B,A		;load lsb
	RET			;done
;
;	file editor
;
EDITOR	CALL	PACK		;pack the data
	CALL	DISPLAY		;display data
	LD	IX,@DATA	;reset data pointer
	BIT	6,(IX+47)	;continuous mode?
	JP	NZ,ADDIT	;yes, just addit
;
EDITOR0	LD	HL,EDITMSG	;'editor message'
	CALL	$DOLINE		;display it
	CALL	$INKEY		;wait for a key
	PUSH	AF		;save key
	LD	HL,EDITMSC	;clear next line
	CALL	$DOLINE		;display
	POP	AF		;restore key/flags
	JP	C,EXIT		;terminate on BREAK
	JR	Z,ADDIT		;default ADD
	CALL	$UCASE		;make upper case
	CP	'C'		;continuous?
	JR	Z,SETCONT	;yes, go!
	CP	'A'		;log?
	JR	Z,ADDIT		;go if yes
	CP	'Q'		;abort?
	JP	Z,EXIT		;yes, abort!
	CP	'E'		;edit?
	JR	Z,EDITIT	;yes, go!
	CP	'N'		;next file?
	RET	Z		;yes, go!
	CP	'S'		;scan?
	JR	NZ,EDITOR0	;none, ask again!
;
;	scan for duplicate files
;
SCANIT	LD	IX,@DATA	;set data pointer
	RES	4,(IX+108)	;set call from EDIT
	CALL	SEARCH		;search duplicates
	JR	Z,EDITOR0	;continue if no error
;
	LD	DE,SCNERR	;error message
	CALL	$DOERR		;display error
	LD	HL,SCNKEY	;message (KEY) to cont
	CALL	$DOLINE		;display
	CALL	$ENKEY		;wait for enter key
	JR	EDITOR0		;continue edit
;
;	edit existing record
;
EDITIT	CALL	EDITREC		;edit record
	CALL	PACK		;re-pack
EDITASK	LD	IX,@DATA	;reset pointer
	LD	HL,SAVEQ	;'save record'
	CALL	$DOLINE		;display
	CALL	$INKEY		;get key input
	JP	C,EXIT		;go on break
	JR	Z,ADDIT		;default add
	CALL	$UCASE		;make upper case
	CP	'A'		;log?
	JR	Z,ADDIT		;yes, go!
	CP	'E'		;edit?
	JR	Z,EDITIT	;edit record
	CP	'I'		;continue and ignore
	JP	Z,EDITOR	;yes, go!
	CP	'Q'		;quit?
	JP	Z,EXIT		;yes, go!
	JR	EDITASK		;else ask again
;
;	set continuous mode
;
SETCONT	SET	6,(IX+47)	;set no-prompt mode
;
;	add new record
;
ADDIT	JP	ADDREC		;add record
;
;	move data from directory record (HL)
;
MOVE	PUSH	HL		;save pointer
	CALL	CLREBUF		;clear EBUFF
	POP	HL		;HL => dir record
	LD	IY,EBUFF	;expanded record
;
	INC	HL		;sys flags
	LD	A,(HL)		;fetch
	AND	10H		;keep bit 4 only
	OR	1		;flag as updated
	LD	(IY+0),A	;update flags1
;
	DEC	HL		;dir+0
	LD	A,(HL)		;get prot level
	AND	7		;low 3 bits
	LD	(IY+2),A	;init flags 3
	BIT	3,(HL)		;invisible?
	JR	Z,$+6		;go if not
	SET	6,(IY+2)	;set INVISIBLE
	BIT	6,(HL)		;system?
	JR	Z,$+6		;go if not
	SET	5,(IY+2)	;set SYSTEM
	BIT	5,(HL)		;PDS?
	JR	Z,$+6		;go if not
	SET	1,(IY+0)	;set if yes
	INC	HL		;dir+1
	BIT	7,(HL)		;created?
	JR	Z,$+10		;go if not
	SET	4,(IY+2)	;set NON-SHRINK
	SET	3,(IY+2)	;set CREATED
	BIT	6,(HL)		;modified?
	JR	Z,$+6		;go if not
	SET	7,(IY+2)	;set MODIFIED
	LD	A,(HL)		;get flags
	AND	1FH		;low 4 bits only
	LD	(IY+3),A	;init MONTH flags4
;
	LD	A,(IX+39)	;get disk type
	OR	(IY+3)		;combine flags
	LD	(IY+3),A	;update flags
;
	INC	HL		;bump pointer
	LD	A,(HL)		;get data
	LD	(IY+1),A	;save DAY/YEAR
	LD	A,(IX+38)	;get cyl count
	LD	(IY+4),A	;update
	INC	HL		;bump to filespec
	INC	HL
	INC	HL		;dir+5
;
;	move filespec to expanded buffer
;
	LD	DE,EBUFF+21	;point to name
	LD	B,11		;max length
MOVE1	LD	A,(HL)		;get a character
	AND	7FH		;remove high bit
	CALL	$UCASE		;make upper case
	CP	' '		;displayable?
	JR	NC,$+4		;go if yes
	LD	A,'.'		;else change control code
	LD	(DE),A		;move to buffer
	INC	DE		;bump buffer
	INC	HL		;bump source
	DJNZ	MOVE1		;go for length
	XOR	A		;set NO error
	LD	(DE),A		;term last char
	RET			;completed!
;
;	display expanded video data
;
DISPLAY	CALL	$SAVREG		;save registers
	CALL	$VIDON		;enable video memory
	LD	IY,TABLETE	;display table expanded
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,DISPLP	;go if yes
	LD	IY,TABLETC	;display table compressed
;
DISPLP	LD	E,(IY+0)	;get video address
	LD	D,(IY+1)
	LD	C,(IY+2)	;get field length
	LD	B,0		;BC = length
	LD	HL,DISPRET	;return vector
	PUSH	HL		;to stack
	LD	L,(IY+4)	;get driver address
	LD	H,(IY+5)	;HL => driver
	PUSH	HL		;to stack
	LD	H,EBUFF<-8	;msb buffer
	LD	L,(IY+3)	;HL => data
	RET			;go driver
;
DISPRET	LD	BC,8		;offset to next entry
	ADD	IY,BC		;IY => next entry
	LD	A,(IY+0)	;check for terminator
	OR	(IY+1)		;=0000?
	JR	NZ,DISPLP	;go if not
	JP	$VIDOFF		;disable video
;
;	display drivers
;
DVRN	LD	A,(EBUFF)	;get first char
	BIT	5,A		;alt format?
	LD	B,3		;make filespec
	JP	Z,$WILD		;move and return if norm
	LD	B,0		;msb length
	LDIR			;else move it
	RET			;done
;
DVR0	LD	A,'('		;area code
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	BC,3		;3 chars
	LDIR			;move 'em
	LD	A,')'		;area code
	LD	(DE),A		;to video
	INC	DE		;bump video
	LD	A,' '		;blank
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	C,3		;prefix
	LDIR			;move 'em
	LD	A,'-'		;phone separator
	LD	(DE),A		;to video
	INC	DE		;bump
	LD	C,4		;phone
;
DVR1	LDIR			;move to video
	RET			;done
;
DVR2	LD	A,(HL)		;get a byte
	INC	A		;on?
	LD	A,_FLAGO	;flag on
	JR	Z,$+4		;go if on
	LD	A,_FLAGF	;flag off
	LD	(DE),A		;to video
	RET			;done
;
DVR3	BIT	4,(HL)		;active date?
	JR	NZ,DVR3A	;go if not!
;
	INC	HL		;flags2
	INC	HL		;flags3
	INC	HL		;flags4
	EX	DE,HL		;HL => video
	LD	A,(DE)		;get month
	AND	0FH		;low 4 bits only
	CALL	ASCII		;decimal ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump
	INC	HL		;bump
	DEC	DE		;flags3
	DEC	DE		;flags2
	LD	A,(DE)		;get data
	RRCA			;shift data
	RRCA
	RRCA
	AND	00011111B	;day of month
	CALL	ASCII		;to ascii
	LD	(HL),C		;msb
	INC	HL		;bump
	LD	(HL),B		;lsb
	INC	HL		;bump
	INC	HL		;bump
	LD	A,(DE)		;get data
	AND	7		;low 3 bits
	ADD	A,80		;correct year
	CALL	ASCII		;to ascii
	LD	(HL),C		;load msb
	INC	HL		;bump
	LD	(HL),B		;load lsb
	RET			;done, date loaded
;
DVR3A	EX	DE,HL		;HL => buffer
	LD	A,'*'		;nil indicator
	LD	(HL),A		;load month
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	LD	(HL),A		;load day
	INC	HL
	LD	(HL),A
	INC	HL
	INC	HL
	LD	(HL),A		;load year
	INC	HL
	LD	(HL),A
	RET			;done
;
DVR4	BIT	1,(HL)		;PDS?
	LD	A,'P'		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'		;nil
	LD	(DE),A		;to video
	INC	DE		;bump
	INC	HL		;flags2
	INC	HL		;flags3
	LD	A,'I'		;invisible?
	BIT	6,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'S'		;system?
	BIT	5,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'M'		;modified?
	BIT	7,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'C'		;created?
	BIT	3,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,'N'		;non-shrink?
	BIT	4,(HL)		;yes?
	JR	NZ,$+4		;go if yes
	LD	A,'-'
	LD	(DE),A		;to video
	INC	DE		;bump
;
	LD	A,(HL)		;get data
	AND	7		;prot level
	ADD	A,'0'		;make ascii
	LD	(DE),A		;to video
	RET			;done
;
DVR5	LD	A,(HL)		;get data
	RRCA			;align data
	RRCA
	AND	3		;low 2 bits
	ADD	A,'A'		;adjust
	LD	(DE),A		;to video
	RET			;done
;
;	keyboard editors
;
EDIT0	JR	EDIT0A		;go if have key
	LD	(EDIT0HL),HL	;save HL
	LD	(EDIT0P),DE	;save data pointer
	CALL	ADJUST		;adjust input
EDIT00	LD	DE,TBUFF	;temp buffer
	LD	B,14		;key input length
	LD	HL,$		;get pointer
EDIT0HL	EQU	$-2
	CALL	$KBEDIT		;edit
	JR	EDIT0B		;continue
;
EDIT0A	PUSH	AF		;save input key
	LD	(EDIT0P),DE	;save data pointer
	LD	(EDIT0HL),HL	;save video pointer
	CALL	ADJUST		;adjust input
	POP	AF		;restore pointer
	CALL	$KBWKEY		;go with key
;
;	adjust and re-display
;
EDIT0B	JR	C,EDIT0H	;clear if BREAK
	LD	DE,TBUFF1	;data pointer
	LD	HL,TBUFF	;input buffer
	LD	BC,14<8+0	;max length + desired
;
EDIT0C	LD	A,(HL)		;get input char
	INC	HL		;bump pointer
	CP	'0'		;digit?
	JR	C,EDIT0G	;nope, remove it
	CP	'9'+1		;digit?
	JR	NC,EDIT0G	;nope, remove it
	LD	(DE),A		;load to data buffer
	INC	DE		;bump pointer
	INC	C		;bump char count
	LD	A,C		;check for max
	CP	10		;at max?
	JR	Z,EDIT0E	;end if at max
EDIT0G	DJNZ	EDIT0C		;continue
EDIT0D	LD	A,C		;have 10 digits?
	CP	10		;have max?
	JR	Z,EDIT0E	;yes, end!
	CP	7		;have 7?
	JR	NZ,EDIT00	;nope, invalid input!
	LD	HL,TBUFF1-3	;add '***' for area code
	JR	EDIT0F		;contiue
;
EDIT0H	LD	HL,TBUFF0	;nil data
	JR	EDIT0F		;continue
EDIT0E	LD	HL,TBUFF1	;data buffer
EDIT0F	LD	DE,$		;fetch pointer
EDIT0P	EQU	$-2
	LD	BC,10		;# digits
	LDIR			;move to buffer
;
;	re-display corrected phone #
;
REDISP	PUSH	IX		;save tables
	PUSH	IY
	CALL	DISPLAY		;display data
	POP	IY		;restore tables
	POP	IX
	XOR	A		;clear carry
	RET			;done!
;
;	adjust display for new data
;
ADJUST	PUSH	HL		;save video pointer
	EX	DE,HL		;HL => data source
	LD	DE,PHMSG1	;data
	PUSH	HL		;save start
	LD	BC,10		;length
	LDIR			;move it
	POP	HL		;hl => data
	LD	DE,TBUFF	;key input buffer
	LD	C,10		;length
	LDIR			;move it
	EX	DE,HL		;HL => remainder
	LD	BC,4<8+' '	;length + fill
	CALL	$CLEAR		;clear remainder
	LD	HL,PHMSG	;phone clear string
	CALL	$DOLINE		;display it
	POP	HL		;restore pointer
	LD	DE,TBUFF	;alternate input buffer
	LD	B,14		;key input length
	RET			;get key input
;
;
EDIT1	JR	EDIT1A		;go if have key
	JP	$KBEDIT		;edit and return
EDIT1A	JP	$KBWKEY		;with input key
;
EDIT2	JR	EDIT2A		;have a key
	XOR	A		;enter only
	RET			;go next entry
EDIT2A	CALL	$UCASE		;make upper case
	CP	'Y'		;yes?
	JR	Z,EDIT2S	;yes, set
	CP	'S'		;set?
	JR	Z,EDIT2S	;yes, set
	CP	'+'		;set?
	JR	Z,EDIT2S	;yes, go!
	CP	'N'		;nope?
	JR	Z,EDIT2R	;yes, reset
	CP	'R'		;reset?
	JR	Z,EDIT2R	;yes, reset
	CP	'-'		;reset?
	JR	Z,EDIT2R	;yes, go!
EDIT2C	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input key
	RET	C		;go on break
	JR	EDIT2A		;try again
;
EDIT2S	LD	A,-1		;flag on
	JR	EDIT2D		;continue
EDIT2R	XOR	A		;flag off
EDIT2D	LD	(DE),A		;update flag
	JP	REDISP		;re-display
;
EDIT5	JR	EDIT5A		;continue
	XOR	A		;enter only
	RET			;done
EDIT5A	CALL	$UCASE		;make upper case
	CP	'A'		;less?
	JR	C,EDIT5B	;yes, ask again
	CP	'E'		;A-D?
	JR	NC,EDIT5B	;too big!
	SUB	'A'		;remove ascii
	RLCA			;align bits
	RLCA
	AND	00001100B	;middle two only
	LD	C,A		;save result
	LD	A,(DE)		;get flags
	AND	11110011B	;remove bits
	OR	C		;combine with new
	LD	(DE),A		;update flags
	XOR	A		;set NC
	JP	REDISP		;re-display
EDIT5B	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input
	RET	C		;go on break
	JR	EDIT5A		;continue
;
;	edit dislayed record
;
EDITREC	LD	HL,CLS1		;clear command line
	CALL	$DOLINE		;display driver
	LD	IX,TABLETE+8	;command table expanded
	LD	IY,TABLETV+8	;special vector table
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,EDITRC1	;go if yes
	LD	IX,TABLETC+8	;command table compressed
	LD	IY,TABLETW+8	;vector table
;
EDITRC1	LD	E,(IX+3)	;get data offset
	LD	D,EBUFF<-8	;DE => data storage
	LD	B,(IX+2)	;get field length
	LD	L,(IX+0)	;get video area
	LD	H,(IX+1)	;HL => video
	LD	A,CURPAGE	;paging cursor
	CALL	$INKEY1		;fetch input key
	RET	C		;go if break
	CP	_ESC		;escape key?
	RET	Z		;go if yes
;
;	check if editing command
;
	LD	C,0		;init for vector
	LD	HL,EDITTBL	;editing table
	CALL	$GOTABL		;go if positioning key
;
;	not an edit key, edit current entry
;
	LD	HL,ADVNX	;return vector
	PUSH	HL		;leave on stack
	LD	C,0		;init count
	LD	L,(IX+0)	;get video
	LD	H,(IX+1)	;HL => video
	PUSH	HL		;save it
	LD	L,(IX+6)	;get subroutine
	LD	H,(IX+7)	;HL => subroutine
	CP	_CR		;carriage return?
	JR	NZ,$+4		;go if not
	INC	HL		;else bump vector
	INC	HL
	EX	(SP),HL		;get video, leave vector
	RET			;go editor!
;
ADVNX	RET	C		;go on BREAK
	JR	DISPU		;continue
;
;	cursor positioning commands
;
ADVSR	INC	C		;shift right
ADVSL	INC	C		;shift left
ADVSD	INC	C		;shift down
ADVSU	INC	C		;shift up
ADVR	INC	C		;+3 - right
ADVL	INC	C		;+2 - left
ADVD	INC	C		;+1 - down
ADVU	EQU	$		;+0 - up
;
	LD	A,C		;get offset
	LD	(DISPY),A	;save into code
	LD	C,(IY+0)	;get table offset
DISPY	EQU	$-1
DISPZ	LD	IX,TABLETE	;expanded data
	LD	IY,TABLETV	;expanded vectors
	LD	A,(@FLAG1)	;get system flag
	BIT	6,A		;expanded?
	JR	NZ,DISPX	;yes, go!
	LD	IX,TABLETC	;compressed data
	LD	IY,TABLETW	;compressed vectors
	JR	DISPX		;continue
DISPU	LD	C,8		;init offset to next
;
DISPX	LD	B,0		;load MSB
	ADD	IX,BC		;offset to next entry
	ADD	IY,BC		;offset to next
;
;	check for non-editing entry
;
	LD	A,(IY+0)	;get data
	AND	(IY+1)		;=FFFF?
	INC	A		;yes?
	JR	Z,DISPU		;yes, skip to next
;
;	check for completed
;
	LD	A,(IX+0)	;check for terminator
	OR	(IX+1)		;=0000?
	JR	NZ,EDITRC1	;go if not
	LD	C,8		;offset to next
	JR	DISPZ		;contiue
;
;	check for valid disk number
;
VALDISK	CALL	$VALUE		;get disk #
	JR	NZ,BADDISK	;bad disk number
	LD	B,C		;pass value
	EX	DE,HL		;BHL = input value
	LD	A,B		;get msb
	OR	A		;>65535?
	JR	NZ,BADDISK	;go if not
	OR	H		;check for 0
	OR	L
	JR	Z,BADDISK	;bad disk number
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	LD	A,C		;any logged?
	OR	D
	OR	E
	JR	Z,BADDISK	;nope, bad disk!
	CALL	$CMP24		;compare
	JR	Z,OKDISK	;go if match
	JR	C,OKDISK	;go if OK
;
BADDISK	LD	HL,INVDSKM	;'bad disk number'
	OR	-1		;set error
	RET			;done
;
OKDISK	XOR	A		;set OK
	RET			;done, BHL = disk #
;
PUTIT	PUSH	BC		;save length
	PUSH	HL		;save string
	EX	DE,HL		;HL => text
	LD	BC,8<8+' '	;length + fill
	CALL	$CLEAR		;reset area
	EX	DE,HL		;DE => text
	POP	HL		;restore input
	POP	BC		;restore length
	LD	C,B		;pass length to C
	LD	B,0		;BC = length
	LDIR			;move it
	RET			;done
;
*GET	DMAN04B			;adder
*GET	DMAN04C			;searcher
*GET	DMAN04D			;update
*GET	DMAN04A			;text/tables
;
PHMSG	DEFB	_STX
	DEFB	12,008
PHMSG1	DEFM	'              '
	DEFB	_ETX
TBUFF0	DEFM	'*******'
	DEFM	'***'
RECSTOR	DEFM	'......'
STORREC	DEFM	'......'
TBUFF1	DEFM	'..........'
TBUFF	DEFM	'...............'
DBUFF	EQU	$&0FF00H
;
XBUFF	EQU	DBUFF+100H
EBUFF	EQU	XBUFF+100H
CBUFF	EQU	EBUFF+100H
SBUFF	EQU	CBUFF+100H
DIRBUFF	EQU	SBUFF+100H
IND0	EQU	DIRBUFF+200H
INDF	EQU	IND0+100H
;
_______	EQU	INDF+100H
	ORG	_______-1
	DEFB	0
;
	END	ENTRY
