; dman04c/asm - kjw/bci - Log Diskettes
;
;	created 08/22/83	- kjw/bci
;	revised 09/24/83	- kjw/bci
;
SEARCH	LD	HL,SEARMSG	;'searching'
	CALL	$DOLINE		;display
	LD	IX,@DATA	;reset data pointer
	CALL	WRITIT		;write residual data
	RET	NZ		;go on disk error
	LD	(IX+122),0	;clear match count
	LD	(IX+123),0
	LD	(IX+124),0
	LD	A,(IX+73)	;get # files used
	OR	(IX+74)
	OR	(IX+75)
	JP	Z,SEARAB	;nope, none to search
	BIT	4,(IX+108)	;call from edit/update?
	LD	HL,1		;disk #
	JR	Z,SEARLP	;go if EDIT
	LD	H,(IX+21)	;else get current disk #
	LD	L,(IX+22)
;
SEARLP	LD	IX,@DATA	;reset pointer
	LD	(IX+112),H	;save disk #
	LD	(IX+113),L
	LD	B,0		;BHL = disk #
	CALL	$DEC24		;BHL
	LD	C,(IX+57)	;start disk tables
	LD	D,(IX+58)
	LD	E,(IX+59)
	CALL	$ADD24		;BHL = sector # disk tble
	LD	(IX+118),B	;current sector
	LD	(IX+119),H
	LD	(IX+120),L
;
;	load I/O buffer
;
	CALL	READIT		;read record
	RET	NZ		;go if error
;
;	save disk link table
;
	LD	DE,XBUFF	;storage buffer
	LD	BC,100H		;buffer length
	LDIR			;save it
	RES	6,(IX+108)	;set NO update
;
;	check if any linkages this disk
;
	CALL	MAKECHR		;create table offset
	LD	H,XBUFF<-8	;HL => table
	LD	B,(HL)		;get MSB
	INC	HL		;bump
	LD	D,(HL)		;get NSB
	INC	HL		;bump
	LD	E,(HL)		;get LSB
	EX	DE,HL		;BHL = file #
;
;	check for terminating entry
;
SEARLP2	LD	IX,@DATA	;reset pointer
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JP	Z,SEARNXT	;yes, nil linkages!
;
;	link found, search for matching file
;
	CALL	GETREC		;read record
	RET	NZ		;go on error
	CALL	CMPREC		;compare records
	JP	NZ,SEARLP3	;go if no match
	BIT	4,(IX+108)	;call from editor?
	JR	Z,CONTREC	;yep, continue log
	XOR	A		;set found!
	RET			;return with record @ IY
;
;	save record link pointers
;
CONTREC	PUSH	IY		;pass rec pointer to HL
	POP	HL		;HL => record
	LD	BC,5		;offset to links
	ADD	HL,BC		;HL => 6 bytes links
	LD	DE,STORREC	;store here
	INC	C		;6 bytes
	LDIR			;move it
;
;	load disk name/date, store string data
;
	LD	B,(IX+35)	;get current file#
	LD	H,(IX+36)
	LD	L,(IX+37)
	PUSH	IX		;save
	LD	IX,SRMSG4	;file # text
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore
;
	LD	B,0		;get disk #
	LD	H,(IX+112)
	LD	L,(IX+113)
	PUSH	IX		;save
	LD	IX,SRMSG1	;disk # text
	LD	DE,5<8+10	;length + base
	CALL	$BINASC		;to ascii
	POP	IX		;restore
;
	PUSH	IY		;pass file pointer to HL
	POP	HL		;HL => file start
;
	PUSH	HL		;save start
	LD	DE,SRMSG5	;flags text
	CALL	DVR4		;convert to ascii
	POP	HL		;restore start
	LD	DE,SRMSG6	;date text
	CALL	DVR3		;convert to ascii
;
	LD	B,0		;get disk #
	LD	H,(IX+112)
	LD	L,(IX+113)
	CALL	$DEC24		;adjust 0 relative
	LD	C,16		;entries / sector
	CALL	$DIVID		;divide it out
	ADD	A,A		;*2
	ADD	A,A		;*4
	ADD	A,A		;*8
	ADD	A,A		;*16
	LD	(IX+121),A	;save offset
	CALL	$INC24		;adjust to correct sector
	CALL	READIT		;read record
	RET	NZ		;go on error
	LD	E,(IX+121)	;name offset
	LD	D,0		;DE = offset
	ADD	HL,DE		;HL => name/date
	LD	DE,SRMSG2	;place here
	LD	BC,8		;length
	LDIR			;move it
	LD	DE,SRMSG3	;place date here
	LD	C,8		;length
	LDIR			;move it
;
SEARFN	LD	HL,SRMSG	;source data message
	CALL	$DOLINE		;display
	CALL	$INKEY		;wait for a key
	LD	IY,STORREC-5	;record storage
	JR	C,SEARABI	;abort on BREAK
	JR	Z,SEARLPN	;continue on ENTER
	CALL	$UCASE		;make upper case
	CP	'Q'		;abort?
	JR	Z,SEARABI	;yes, go!
	CP	'N'		;continue?
	JR	Z,SEARLPN	;yes, continue
	CP	'S'		;search?
	JR	Z,SEARLPN	;yes, continue
	CP	'D'		;delete record?
	JR	NZ,SEARFN	;none, ask again
;
;	delete existing file
;
	LD	B,(IY+5)	;save forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	CALL	DELREC		;delete current record
	RET	NZ		;go if error!
	JP	SEARLP2		;continue
;
;	set record as matching and non-deleted
;
SEARLPN	CALL	INCCNT		;increment count
;
;	advance to next record in link
;
SEARLP3	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)	;BHL = next file#
	JP	SEARLP2		;nope, go next record
;
;	advance to next disk #
;
SEARNXT	BIT	4,(IX+108)	;call from update?
	JR	Z,SEARCNT	;nope, continue
	XOR	A		;set NO error
	SCF			;set NEW file
	RET			;return NOT FOUND
;
SEARCNT	LD	B,0		;get current disk #
	LD	H,(IX+112)
	LD	L,(IX+113)
	LD	C,(IX+51)	;get # disks used
	LD	D,(IX+52)
	LD	E,(IX+53)
	CALL	$CMP24		;compare
	JR	Z,SEARAB	;done, go!
	CALL	$INC24		;bump disk #
	JP	SEARLP		;go next disk
;
;	abort search and return no error
;
SEARABI	CALL	INCCNT		;bump record count
SEARAB	BIT	4,(IX+108)	;call from update mode?
	JR	Z,SEARAC	;nope, continue
	XOR	A		;set not found
	SCF
	RET			;return as new record
;
SEARAC	LD	B,(IX+122)	;get file match count
	LD	H,(IX+123)
	LD	L,(IX+124)
	PUSH	IX		;save
	LD	IX,SCNFIN1	;text to load
	LD	DE,8<8+10	;length + base
	CALL	$BINASC		;convert to ascii
	POP	IX		;restore
	LD	HL,SCNFIN	;message
	CALL	$DOLINE		;display it
	XOR	A		;set NO error
	RET			;done!
;
;	delete current record
;
DELEREC	CALL	$SAVREG		;save registers
	JR	DELRCNT		;continue
;
DELREC	CALL	$SAVREG		;save registers
	LD	HL,DELMSG1	;'deleting..'
	CALL	$DOLINE		;display
;
DELRCNT	LD	IX,@DATA	;reset pointer
	CALL	MAKECHR		;get table offset
	LD	H,XBUFF<-8	;HL => table
	LD	(RECIY),HL	;save it
	LD	B,(IX+35)	;get current file #
	LD	H,(IX+36)
	LD	L,(IX+37)
	LD	(RECBC),BC	;save current #
	LD	(RECHL),HL
	CALL	GETREC		;read record
	RET	NZ		;go if error
;
;	delete current file and store pointers
;
	PUSH	IY		;pass pointer
	POP	HL		;restore pointer
	LD	BC,5		;offset to links
	ADD	HL,BC		;HL => links
	LD	DE,RECSTOR	;record storage
	INC	C		;record link length
	LDIR			;move it
;
;	de-link current record
;
DELRECA	LD	B,(IY+5)	;get forward link
	LD	H,(IY+6)
	LD	L,(IY+7)
	LD	A,B		;check if any
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRAY	;yes, go!
;
DELRAN	LD	B,(IY+8)	;get backward link
	LD	H,(IY+9)
	LD	L,(IY+10)
	LD	A,B		;check for nil
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRANY	;yes, go!
;
;	file is nil!
;
DELRANN	DEC	A		;load FF
	LD	IY,$		;load index pointer
RECIY	EQU	$-2
	LD	(IY+0),A	;clear pointers
	LD	(IY+1),A
	LD	(IY+2),A
	LD	(IY+3),A
	LD	(IY+4),A
	LD	(IY+5),A
	LD	(IY+6),'*'
	LD	(IY+7),'*'
	SET	6,(IX+108)	;set needs update
	JP	DELRE		;continue
;
DELRANY	CALL	GETREC		;load backward record
	RET	NZ		;go if error
	LD	A,-1		;load nil
	LD	(IY+5),A	;clear forward link
	LD	(IY+6),A
	LD	(IY+7),A
	SET	4,(IX+47)	;set buffer updated
;
	LD	IY,RECSTOR	;record storage
	LD	B,(IY+3)	;get backward link
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+3),B	;set as last record
	LD	(IY+4),H
	LD	(IY+5),L
	LD	(IY+7),')'	;flag
	SET	6,(IX+108)	;set buffer needs update
	JP	DELRE		;continue
;
DELRAY	CALL	GETREC		;load forward record
	RET	NZ		;go if error
	PUSH	IY		;save pointer
	LD	IY,RECSTOR	;get record storage
	LD	B,(IY+3)	;get backward link
	LD	H,(IY+4)
	LD	L,(IY+5)
	POP	IY		;restore
	LD	(IY+8),B	;update backward link
	LD	(IY+9),H
	LD	(IY+10),L
	SET	4,(IX+47)	;set update needed
;
	LD	A,B		;check for nil
	AND	H
	AND	L
	INC	A		;BHL = FFFFFF?
	JR	NZ,DELRB	;go if not
;
	LD	IY,RECSTOR	;get record storage
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+0),B	;set as first record
	LD	(IY+1),H
	LD	(IY+2),L
	LD	(IY+6),'('	;flag table
	SET	6,(IX+108)	;flag for update
;
DELRB	LD	IY,RECSTOR	;record storage
	LD	B,(IY+3)	;get back link
	LD	H,(IY+4)
	LD	L,(IY+5)
	LD	A,B		;any back link?
	AND	H
	AND	L
	INC	A		;=FFFFFF?
	JR	NZ,DELRC	;yes, continue
;
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	LD	IY,(RECIY)	;get index pointer
	LD	(IY+0),B	;set index first
	LD	(IY+1),H
	LD	(IY+2),L
	LD	(IY+6),'('	;flag
	SET	6,(IX+108)	;buffer needs update
	JR	DELRE		;continue
;
DELRC	CALL	GETREC		;get record
	RET	NZ		;go on error
	PUSH	IY		;save pointer
	LD	IY,RECSTOR	;get storage
	LD	B,(IY+0)	;get forward link
	LD	H,(IY+1)
	LD	L,(IY+2)
	POP	IY		;restore
	LD	(IY+5),B	;update forward link
	LD	(IY+6),H
	LD	(IY+7),L
	SET	4,(IX+47)	;set buffer updated
;
;	file is de-linked
;	add file space to deleted list for re-use
;	get last deleted file in link and append
;
DELRE	LD	B,(IX+73)	;get # files used
	LD	H,(IX+74)
	LD	L,(IX+75)
	CALL	$DEC24		;decrement
	LD	(IX+73),B	;update count
	LD	(IX+74),H
	LD	(IX+75),L
;
	LD	B,(IX+64)	;get deleted file link
	LD	H,(IX+65)
	LD	L,(IX+66)
;
;	check if any at all
;
	LD	A,B
	AND	H
	AND	L
	INC	A		;terminator?
	JR	NZ,DELRG	;go if not
;
;	current record is first and only link
;
DELRF	LD	BC,(RECBC)	;get record #
	LD	HL,(RECHL)
	LD	(IX+64),B	;deleted file link start
	LD	(IX+65),H
	LD	(IX+66),L
	LD	(IX+67),B	;deleted file link end
	LD	(IX+68),H
	LD	(IX+69),L
;
;	clear links in current record
;
	CALL	GETREC		;read record
	RET	NZ		;go on error
	LD	A,-1		;set nil
	LD	(IY+5),A	;clear forward link
	LD	(IY+6),A
	LD	(IY+7),A
	LD	(IY+8),A	;clear backward link
	LD	(IY+9),A
	LD	(IY+10),A
	SET	7,(IY+0)	;set deleted bit
	SET	4,(IX+47)	;set buffer updated
	JR	DELRH		;continue
;
DELRG	CALL	GETREC		;get last deleted record
	RET	NZ		;go on error
	LD	BC,$		;get current record
RECBC	EQU	$-2
	LD	HL,$
RECHL	EQU	$-2
	LD	(IY+8),B	;update back link
	LD	(IY+9),H
	LD	(IY+10),L
	SET	4,(IX+47)	;set buffer updated
;
	CALL	GETREC		;read current record
	RET	NZ		;go on error
	LD	B,(IX+64)	;get old deleted start
	LD	H,(IX+65)
	LD	L,(IX+66)
	LD	(IY+5),B	;update forward link
	LD	(IY+6),H
	LD	(IY+7),L
	LD	A,-1		;load FF
	LD	(IY+8),A	;clear back link
	LD	(IY+9),A
	LD	(IY+10),A
	SET	7,(IY+0)	;set delete flag
	SET	4,(IX+47)	;set update flag
;
;	update new link end
;
	LD	BC,(RECBC)	;get record #
	LD	HL,(RECHL)
	LD	(IX+64),B	;update first link
	LD	(IX+65),H
	LD	(IX+66),L
;
DELRH	LD	IX,@DATA	;reset pointer
	CALL	UPDAT0		;set as updated
	CALL	WRITIT		;update buffer
	RET	NZ		;go on error
	CALL	$SHOWF		;display new facts
	LD	IX,@DATA	;reset pointer
;
;	index sector needs update?
;
	BIT	1,(IX+108)	;call from UPDATE(E)/REMV
	JR	NZ,DELRI	;yes, no disk update
	BIT	6,(IX+108)	;needs update?
	JR	Z,DELRI		;go if not
;
	LD	B,(IX+118)	;get sector #
	LD	H,(IX+119)
	LD	L,(IX+120)
	CALL	READIT		;read the sector
	RET	NZ		;go on error
	EX	DE,HL		;DE => I/O buffer
	LD	HL,XBUFF	;alt buffer
	LD	BC,100H		;buffer length
	LDIR			;load it
	SET	4,(IX+47)	;set buffer updated
	CALL	WRITIT		;update to disk
	RET	NZ		;go on error
	RES	6,(IX+108)	;clear bit
;
DELRI	XOR	A		;set NO error
	SCF			;set NEW record
	RET			;done
;
INCCNT	LD	B,(IX+122)	;get # matches
	LD	H,(IX+123)
	LD	L,(IX+124)
	CALL	$INC24		;bump count
	LD	(IX+122),B	;update
	LD	(IX+123),H
	LD	(IX+124),L
	RET			;done
;
